/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBusinessBatchBuild;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.app.handler.OneToManyWriteBackHandler;
import com.kingdee.eas.dynbusiness.app.handler.OneToOneWriteBackHandler;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.IConfigurationMerge;
import com.kingdee.eas.dynbusiness.config.OneToManyWriteBackSubItem;
import com.kingdee.eas.dynbusiness.config.OneToOneWriteBackSubItem;
import com.kingdee.eas.dynbusiness.config.WriteBackSubItem;
import com.kingdee.eas.dynbusiness.util.ArrayUtils;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.dynbusiness.util.SqlBuilderHelper;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class WriteBackConfigItem
implements IBusinessBatchBuild,
IBusinessBatchHandle,
IConfigurationMerge,
IBusinessConfigItem {
    private ProcessorExecutionMode executionMode;
    public static final String TYPE_TO_SRC = "SOURCE";
    public static final String TYPE_TO_CORE = "CORE";
    public static final String STATUS_ALTERING = "ALTERING";
    private String action;
    private List writebackItems;
    private BusinessProcessConfigItem parent;
    protected String fldSrcTypeId = "FSourceBillTypeId";
    protected String fldCoreTypeId = "FCoreBillTypeId";
    private transient String fetchSrcCoreTypeSql;
    private transient boolean isInitialized = false;
    private String fldUnitId = "FUnitID";

    public WriteBackConfigItem(BusinessProcessConfigItem parent, ProcessorExecutionMode mode) {
        this.executionMode = mode;
        this.parent = parent;
    }

    public List getWritebackItems() {
        return this.writebackItems;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public synchronized void build(Context ctx) throws BOSException {
        if (this.isInitialized) {
            return;
        }
        EntityObjectInfo entryEO = BusinessProcessUtil.getEntityEntriesEntity(ctx, BOSObjectType.create((String)this.parent.getBosType()));
        if (entryEO != null && !BusinessProcessUtil.existColumnByName(ctx, entryEO.getType(), this.fldUnitId)) {
            this.fldUnitId = "FMeasureUnitID";
        }
        if (entryEO != null && !BusinessProcessUtil.existColumnByName(ctx, entryEO.getType(), this.fldSrcTypeId)) {
            this.fldSrcTypeId = null;
        }
        if (entryEO != null && !BusinessProcessUtil.existColumnByName(ctx, entryEO.getType(), this.fldCoreTypeId)) {
            this.fldCoreTypeId = null;
        }
        this.fetchSrcCoreTypeSql = this.buildFetchSrcCoreTypeSql(ctx);
        int size = this.writebackItems.size();
        for (int i = 0; i < size; ++i) {
            WriteBackSubItem wbItem = (WriteBackSubItem)this.writebackItems.get(i);
            wbItem.buildWriteBackSqls(ctx);
        }
        this.isInitialized = true;
    }

    private String buildFetchSrcCoreTypeSql(Context ctx) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT DISTINCT ");
        sb.append("entry");
        sb.append(".");
        sb.append(this.fldSrcTypeId);
        if (this.fldCoreTypeId != null) {
            sb.append(", ");
            sb.append("entry");
            sb.append(".");
            sb.append(this.fldCoreTypeId);
        }
        sb.append("\r\n");
        sb.append(this.parent.parent.getBoStructure().buildJoinClause(0));
        sb.append(SqlBuilderHelper.buildWhereClause(null, true));
        return sb.toString();
    }

    public String getFetchSrcCoreTypeSql() {
        return this.fetchSrcCoreTypeSql;
    }

    @Override
    public void handle(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (!this.isInitialized) {
            this.build(ctx);
        }
        BusinessProcessorHelper.outpurtDebug("\u53cd\u5199\u5b50\u9879\u6709" + this.writebackItems.size() + "\u4e2a");
        String[] idsArray = batchResults.getToDoIdsArray();
        if (idsArray.length == 0) {
            return;
        }
        Collection colSrcTypes = null;
        Collection colCoreTypes = null;
        if (this.fldSrcTypeId != null) {
            IRowSet rs = this.fetchSrcCoreBillTypeId(ctx, idsArray);
            colSrcTypes = DBUtil.getRSValue(rs, this.fldSrcTypeId, true);
            colCoreTypes = this.fldCoreTypeId != null ? DBUtil.getRSValue(rs, this.fldCoreTypeId, true) : new HashSet(0);
        }
        for (WriteBackSubItem wbItem : this.writebackItems) {
            if (this.fldSrcTypeId != null && !wbItem.containsFirstSrcOrCoreBillType(colSrcTypes, colCoreTypes)) continue;
            IBusinessBatchHandle handler = wbItem instanceof OneToOneWriteBackSubItem ? new OneToOneWriteBackHandler((OneToOneWriteBackSubItem)wbItem, this.action) : new OneToManyWriteBackHandler((OneToManyWriteBackSubItem)wbItem);
            handler.handle(ctx, batchResults);
        }
    }

    private IRowSet fetchSrcCoreBillTypeId(Context ctx, String[] idsArray) throws BOSException {
        String sql = this.fetchSrcCoreTypeSql;
        if (idsArray.length == 0) {
            return null;
        }
        String bindMarks = DBUtil.getBindMarks(idsArray.length);
        sql = sql.replaceAll("\\?\\?\\?", bindMarks);
        return DBUtil.executeQuery(ctx, sql, idsArray);
    }

    public ProcessorExecutionMode supportExecutionMode() {
        return this.executionMode != null ? this.executionMode : ProcessorExecutionMode.NESTED;
    }

    public void setWritebackItems(List writebackItems) {
        this.writebackItems = writebackItems;
    }

    public BusinessProcessConfigItem getParent() {
        return this.parent;
    }

    public String getFldUnitId() {
        return this.fldUnitId;
    }

    @Override
    public void merge(Object cfgItem) {
        if (cfgItem == null || !(cfgItem instanceof WriteBackConfigItem)) {
            return;
        }
        WriteBackConfigItem configItem = (WriteBackConfigItem)cfgItem;
        if (this.writebackItems == null || this.writebackItems.size() == 0) {
            this.writebackItems = configItem.writebackItems;
        } else if (configItem.writebackItems != null) {
            int size = configItem.writebackItems.size();
            for (int i = 0; i < size; ++i) {
                WriteBackSubItem wbItem = (WriteBackSubItem)configItem.writebackItems.get(i);
                Object[] srcLists = wbItem.srcBillIds.toArray();
                int subsize = this.writebackItems.size();
                for (int j = 0; j < subsize; ++j) {
                    Object[] thisSrcLists = ((WriteBackSubItem)this.writebackItems.get((int)j)).srcBillIds.toArray();
                    if (!ArrayUtils.isEquals(srcLists, thisSrcLists)) continue;
                    throw new UnsupportedOperationException("\u76ee\u524d\u4e0d\u652f\u6301\u76f8\u540c\u6e90\u5355\u7684\u53cd\u5199\u914d\u7f6e\u9879\u5408\u5e76\uff01");
                }
            }
            this.writebackItems.addAll(configItem.writebackItems);
        }
    }

    public String getFldSrcTypeId() {
        return this.fldSrcTypeId;
    }
}

