/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.expression.datameta;

import com.kingdee.eas.dynbusiness.expression.datameta.Reference;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public abstract class BaseDataMeta {
    DataType dataType;
    Object dataValue;
    private boolean isReference;

    public BaseDataMeta(DataType dataType, Object dataValue) {
        this.dataType = dataType;
        this.dataValue = dataValue;
        this.verifyDataMeta();
    }

    public DataType getDataType() {
        if (this.isReference) {
            return this.getReference().getDataType();
        }
        return this.dataType;
    }

    public Object getDataValue() {
        return this.dataValue;
    }

    public String getDataValueText() {
        if (this.dataValue == null) {
            return null;
        }
        if (DataType.DATATYPE_DATE.equals(this.dataType)) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)this.dataValue);
        }
        if (DataType.DATATYPE_LIST.equals(this.dataType)) {
            StringBuffer buff = new StringBuffer("[");
            List col = (List)this.dataValue;
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                Object o = col.get(i);
                if (o == null) {
                    buff.append("null, ");
                    continue;
                }
                if (o instanceof Date) {
                    buff.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)o)).append(", ");
                    continue;
                }
                buff.append(o.toString()).append(", ");
            }
            buff.append("]");
            if (buff.length() > 2) {
                buff.delete(buff.length() - 3, buff.length() - 1);
            }
            return buff.toString();
        }
        return this.dataValue.toString();
    }

    public String getStringValue() {
        return this.getDataValueText();
    }

    public Boolean getBooleanValue() {
        if (!DataType.DATATYPE_BOOLEAN.equals(this.dataType)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        return (Boolean)this.dataValue;
    }

    public Integer getIntegerValue() {
        if (!DataType.DATATYPE_INT.equals(this.dataType)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        return (Integer)this.dataValue;
    }

    public Long getLongValue() {
        if (!DataType.DATATYPE_INT.equals(this.dataType) && !DataType.DATATYPE_LONG.equals(this.dataType)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (this.dataValue == null) {
            return null;
        }
        return Long.valueOf(this.dataValue.toString());
    }

    public Float getFloatValue() {
        if (!(DataType.DATATYPE_INT.equals(this.dataType) || DataType.DATATYPE_FLOAT.equals(this.dataType) || DataType.DATATYPE_LONG.equals(this.dataType))) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (this.dataValue == null) {
            return null;
        }
        return Float.valueOf(this.dataValue.toString());
    }

    public Double getDoubleValue() {
        if (!(DataType.DATATYPE_INT.equals(this.dataType) || DataType.DATATYPE_LONG.equals(this.dataType) || DataType.DATATYPE_FLOAT.equals(this.dataType) || DataType.DATATYPE_DOUBLE.equals(this.dataType))) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (this.dataValue == null) {
            return null;
        }
        return Double.valueOf(this.dataValue.toString());
    }

    public BigDecimal getBigDecimalValue() {
        if (!(DataType.DATATYPE_INT.equals(this.dataType) || DataType.DATATYPE_LONG.equals(this.dataType) || DataType.DATATYPE_FLOAT.equals(this.dataType) || DataType.DATATYPE_DOUBLE.equals(this.dataType) || DataType.DATATYPE_BIGDECIMAL.equals(this.dataType))) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (this.dataValue == null) {
            return null;
        }
        if (this.dataValue instanceof BigDecimal) {
            return (BigDecimal)this.dataValue;
        }
        return BigDecimal.valueOf(Long.valueOf(this.dataValue.toString()));
    }

    public Date getDateValue() {
        if (!DataType.DATATYPE_DATE.equals(this.dataType)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        return (Date)this.dataValue;
    }

    public List getCollection() {
        if (!DataType.DATATYPE_LIST.equals(this.dataType)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        return (List)this.dataValue;
    }

    public Reference getReference() {
        if (!this.isReference) {
            throw new UnsupportedOperationException("\u5f53\u524d\u5e38\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        return (Reference)this.dataValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BaseDataMeta) {
            BaseDataMeta bdo = (BaseDataMeta)o;
            if (this.isReference() && bdo.isReference) {
                return this.getReference().equals(bdo.getReference());
            }
            if (bdo.dataType.equals(this.dataType)) {
                if (bdo.dataValue != null && bdo.dataValue.equals(this.dataValue)) {
                    return true;
                }
                return bdo.dataValue == null && this.dataValue == null;
            }
            return false;
        }
        return false;
    }

    protected void verifyDataMeta() {
        if (this.dataType != null && this.dataValue != null) {
            if (DataType.DATATYPE_NULL.equals(this.dataType) && this.dataValue != null) {
                throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + this.dataType + ",\u503c\u4e0d\u4e3a\u7a7a");
            }
            if (DataType.DATATYPE_BOOLEAN.equals(this.dataType)) {
                try {
                    this.getBooleanValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + this.dataType + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_DATE.equals(this.dataType)) {
                try {
                    this.getDateValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + this.dataType + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_BIGDECIMAL.equals(this.dataType)) {
                try {
                    this.getBigDecimalValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + this.dataType + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_DOUBLE.equals(this.dataType)) {
                try {
                    this.getDoubleValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + this.dataType + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_FLOAT.equals(this.dataType)) {
                try {
                    this.getFloatValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + this.dataType + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_INT.equals(this.dataType)) {
                try {
                    this.getIntegerValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + this.dataType + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_LONG.equals(this.dataType)) {
                try {
                    this.getLongValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + this.dataType + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_STRING.equals(this.dataType)) {
                try {
                    this.getStringValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + this.dataType + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_LIST.equals(this.dataType)) {
                try {
                    this.getCollection();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + this.dataType + ",\u503c:" + this.dataValue);
                }
            }
            if (this.isReference) {
                try {
                    this.getReference();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + this.dataType + ",\u503c:" + this.dataValue);
                }
            }
            if (DataType.DATATYPE_OBJECT.equals(this.dataType)) {
                try {
                    this.getDataValue();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException("\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d; \u7c7b\u578b\uff1a" + this.dataType + ",\u503c:" + this.dataValue);
                }
            }
        }
    }

    public Class mapTypeToJavaClass() {
        if (DataType.DATATYPE_BOOLEAN.equals(this.getDataType())) {
            return Boolean.TYPE;
        }
        if (DataType.DATATYPE_DATE.equals(this.getDataType())) {
            return Date.class;
        }
        if (DataType.DATATYPE_BIGDECIMAL.equals(this.getDataType())) {
            return BigDecimal.class;
        }
        if (DataType.DATATYPE_DOUBLE.equals(this.getDataType())) {
            return Double.TYPE;
        }
        if (DataType.DATATYPE_FLOAT.equals(this.getDataType())) {
            return Float.TYPE;
        }
        if (DataType.DATATYPE_INT.equals(this.getDataType())) {
            return Integer.TYPE;
        }
        if (DataType.DATATYPE_LONG.equals(this.getDataType())) {
            return Long.TYPE;
        }
        if (DataType.DATATYPE_STRING.equals(this.getDataType())) {
            return String.class;
        }
        if (DataType.DATATYPE_LIST.equals(this.getDataType())) {
            return List.class;
        }
        if (DataType.DATATYPE_OBJECT.equals(this.getDataType())) {
            return Object.class;
        }
        if (DataType.DATATYPE_NULL.equals(this.getDataType())) {
            return null;
        }
        throw new RuntimeException("\u6620\u5c04Java\u7c7b\u578b\u5931\u8d25\uff1a\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u7c7b\u578b");
    }

    public boolean isCompatibleType(BaseDataMeta another) {
        if (DataType.DATATYPE_NULL.equals(this.getDataType()) || DataType.DATATYPE_NULL.equals(another.getDataType())) {
            return true;
        }
        if (this.getDataType().equals(another.getDataType())) {
            return true;
        }
        if (!(DataType.DATATYPE_INT.equals(this.getDataType()) || DataType.DATATYPE_LONG.equals(this.getDataType()) || DataType.DATATYPE_FLOAT.equals(this.getDataType()) || DataType.DATATYPE_DOUBLE.equals(this.getDataType()) || DataType.DATATYPE_BIGDECIMAL.equals(this.getDataType()))) {
            return false;
        }
        return DataType.DATATYPE_INT.equals(another.getDataType()) || DataType.DATATYPE_LONG.equals(another.getDataType()) || DataType.DATATYPE_FLOAT.equals(another.getDataType()) || DataType.DATATYPE_DOUBLE.equals(another.getDataType()) || DataType.DATATYPE_BIGDECIMAL.equals(another.getDataType());
    }

    public DataType getCompatibleType(BaseDataMeta another) {
        if (this.isCompatibleType(another)) {
            if (DataType.DATATYPE_NULL.equals(this.getDataType())) {
                return another.getDataType();
            }
            if (DataType.DATATYPE_NULL.equals(another.getDataType())) {
                return this.getDataType();
            }
            if (this.getDataType().equals(another.getDataType())) {
                return this.getDataType();
            }
            if (DataType.DATATYPE_DOUBLE.equals(this.getDataType()) || DataType.DATATYPE_DOUBLE.equals(another.getDataType())) {
                return DataType.DATATYPE_DOUBLE;
            }
            if (DataType.DATATYPE_FLOAT.equals(this.getDataType()) || DataType.DATATYPE_FLOAT.equals(another.getDataType())) {
                return DataType.DATATYPE_FLOAT;
            }
            if (DataType.DATATYPE_LONG.equals(this.getDataType()) || DataType.DATATYPE_LONG.equals(another.getDataType())) {
                return DataType.DATATYPE_LONG;
            }
            if (DataType.DATATYPE_BIGDECIMAL.equals(this.getDataType()) || DataType.DATATYPE_BIGDECIMAL.equals(another.getDataType())) {
                return DataType.DATATYPE_BIGDECIMAL;
            }
            return DataType.DATATYPE_INT;
        }
        return null;
    }

    public Object toJavaObject() throws ParseException {
        if (null == this.dataValue) {
            return null;
        }
        if (DataType.DATATYPE_BOOLEAN.equals(this.getDataType())) {
            return this.getBooleanValue();
        }
        if (DataType.DATATYPE_DATE.equals(this.getDataType())) {
            return this.getDateValue();
        }
        if (DataType.DATATYPE_BIGDECIMAL.equals(this.getDataType())) {
            return this.getBigDecimalValue();
        }
        if (DataType.DATATYPE_DOUBLE.equals(this.getDataType())) {
            return this.getDoubleValue();
        }
        if (DataType.DATATYPE_FLOAT.equals(this.getDataType())) {
            return this.getFloatValue();
        }
        if (DataType.DATATYPE_INT.equals(this.getDataType())) {
            return this.getIntegerValue();
        }
        if (DataType.DATATYPE_LONG.equals(this.getDataType())) {
            return this.getLongValue();
        }
        if (DataType.DATATYPE_STRING.equals(this.getDataType())) {
            return this.getStringValue();
        }
        if (DataType.DATATYPE_LIST.equals(this.getDataType())) {
            return this.getCollection();
        }
        if (DataType.DATATYPE_OBJECT.equals(this.getDataType())) {
            return this.getDataValue();
        }
        throw new RuntimeException("\u6620\u5c04Java\u7c7b\u578b\u5931\u8d25\uff1a\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u7c7b\u578b");
    }

    public boolean isReference() {
        return this.isReference;
    }

    void setReference(boolean isReference) {
        this.isReference = isReference;
    }

    public static class DataType {
        private String type;
        public static final DataType DATATYPE_NULL = new DataType("NULL");
        public static final DataType DATATYPE_STRING = new DataType("STRING");
        public static final DataType DATATYPE_BOOLEAN = new DataType("BOOLAN");
        public static final DataType DATATYPE_INT = new DataType("INT");
        public static final DataType DATATYPE_LONG = new DataType("LONG");
        public static final DataType DATATYPE_FLOAT = new DataType("FLOAT");
        public static final DataType DATATYPE_DOUBLE = new DataType("DOUBLE");
        public static final DataType DATATYPE_DATE = new DataType("DATE");
        public static final DataType DATATYPE_LIST = new DataType("LIST");
        public static final DataType DATATYPE_OBJECT = new DataType("OBJECT");
        public static final DataType DATATYPE_BIGDECIMAL = new DataType("BIGDECIMAL");

        public DataType(String type) {
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DataType) {
                return this.type.equals(((DataType)obj).type);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }
}

