/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.function;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.currency.FormatRMB;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.condition.ObjectValueSearcher;
import com.kingdee.eas.dynbusiness.function.FunctionLoader;
import com.kingdee.eas.dynbusiness.function.IFuncParamValueProvider;
import com.kingdee.eas.dynbusiness.function.IFunction;
import com.kingdee.eas.dynbusiness.function.INodeType;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import com.kingdee.eas.dynbusiness.util.OrgUnitUtil;
import com.kingdee.eas.dynbusiness.util.SortUtil;
import com.kingdee.eas.dynbusiness.util.ValueConstants;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;

public abstract class Function
implements IFunction {
    private String name;
    protected String[] parameters;
    private IFuncParamValueProvider provider;

    @Override
    public void addParamValueProvider(IFuncParamValueProvider provider) {
        this.provider = provider;
    }

    public IFuncParamValueProvider getProvider() {
        return this.provider;
    }

    public Function(String name, String[] parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    protected Object getParamValue(String key) throws EASBizException, BOSException {
        if (this.provider == null) {
            return null;
        }
        return this.provider.provideValue(key);
    }

    protected INodeType getNodeType() {
        return this.provider;
    }

    protected Object getBizInterface(Context ctx, Class bizFactoryClass) throws BOSException {
        return BusinessProcessUtil.getBizInterface((Context)(this.getNodeType().isApplicationServer() ? ctx : null), bizFactoryClass);
    }

    private static Object truncateTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static String removeFormatSymbol(String text) {
        text = text.trim();
        return text.substring(1, text.length() - 1);
    }

    protected IObjectValue getPersonPosition(Context ctx, PersonInfo personInfo) throws BOSException, EASBizException {
        PositionInfo personPositio = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select position.* ,position.adminOrgUnit.*,isPrimary,id,number,name,parent");
            sb.append(" where person.id = '");
            sb.append(personInfo.getId().toString());
            sb.append("'");
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
            PositionMemberCollection pmColl = ipm.getPositionMemberCollection(sb.toString());
            int size = pmColl.size();
            for (int i = 0; i < size; ++i) {
                if (pmColl.get(i).getPosition() == null || !pmColl.get(i).isIsPrimary()) continue;
                personPositio = pmColl.get(i).getPosition();
            }
            if (personPositio == null && pmColl != null && pmColl.size() > 0) {
                personPositio = pmColl.get(0).getPosition();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return personPositio;
    }

    public static final String createFunctionBody(String name, String[] parameters) {
        int size;
        StringBuffer sb = new StringBuffer();
        sb.append(name).append("(");
        int n = size = parameters != null ? parameters.length : 0;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(parameters[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    static class IsNullFunction
    extends Function {
        public IsNullFunction(String name, String[] parameters) {
            super(name, parameters);
        }

        @Override
        public Object eval() throws BOSException, EASBizException {
            String var = this.parameters[0];
            Object value = this.getProvider().provideValue(var);
            if (value != null) {
                return value;
            }
            String nullVar = this.parameters[1];
            return this.getProvider().provideValue(nullVar);
        }
    }

    static class FormatFunction
    extends Function {
        public FormatFunction(String name, String[] parameters) {
            super(name, parameters);
        }

        @Override
        public Object eval() throws BOSException, EASBizException {
            String strValue = this.parameters[0];
            Object value = null;
            ExpressionParser.getInstance();
            if (ExpressionParser.isTemporaryVariable(strValue)) {
                value = this.getParamValue(strValue);
            }
            if (value == null) {
                return "";
            }
            String pattern = this.parameters[1];
            if (StringUtils.isEmpty((String)pattern)) {
                return value.toString();
            }
            if ("RMB/G".equalsIgnoreCase(pattern)) {
                Variant v = new Variant(value);
                FormatRMB format = new FormatRMB();
                return format.format(v);
            }
            if (value instanceof Date || value instanceof Timestamp) {
                SimpleDateFormat formatter = new SimpleDateFormat(pattern);
                return formatter.format(value);
            }
            return value.toString();
        }
    }

    static class SumFunction
    extends Function {
        public SumFunction(String name, String[] parameters) {
            super(name, parameters);
        }

        @Override
        public Object eval() throws BOSException, EASBizException {
            String var = this.parameters[0];
            String fullPropertyName = null;
            ExpressionParser expParser = ExpressionParser.getInstance();
            if (ExpressionParser.isTemporaryVariable(var)) {
                String func = SumFunction.createFunctionBody("getFullPropetyName", new String[]{var});
                fullPropertyName = (String)this.getProvider().provideValue(func);
            } else {
                fullPropertyName = expParser.isBracesVariable(var) ? Function.removeFormatSymbol(var) : var;
            }
            if (fullPropertyName == null) {
                return null;
            }
            IObjectValue objValue = (IObjectValue)this.getProvider().provideValue("@THIS");
            if (objValue == null) {
                return null;
            }
            BOSObjectType bosType = objValue.getBOSType();
            Context ctx = (Context)this.getProvider().provideValue("@CONTEXT");
            PropertyInfo property = BusinessProcessUtil.getPropertyInfo(ctx, bosType, fullPropertyName);
            DataType dataType = BusinessProcessUtil.getDataType(property);
            if (!DataType.DECIMAL.equals((Object)dataType) && !DataType.INTEGER.equals((Object)dataType)) {
                throw new UnsupportedOperationException("The Sum Function only support Bigdecimal and Integer type.");
            }
            String[] props = expParser.splitPropertise(fullPropertyName);
            HashMap paramMap = new HashMap();
            Object value = ObjectValueSearcher.searchValue((Object)objValue, props, 0, null, paramMap);
            if (DataType.DECIMAL.equals((Object)dataType)) {
                BigDecimal result = ValueConstants.ZERO;
                if (value instanceof BigDecimal) {
                    return value;
                }
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    if (values.length == 0) {
                        return result;
                    }
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] == null) continue;
                        result = result.add((BigDecimal)values[i]);
                    }
                }
                return result;
            }
            if (DataType.INTEGER.equals((Object)dataType)) {
                int result = 0;
                if (value instanceof Integer) {
                    return value;
                }
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    if (values.length == 0) {
                        return new Integer(result);
                    }
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] == null) continue;
                        result += ((Integer)values[i]).intValue();
                    }
                }
                return new Integer(result);
            }
            return null;
        }
    }

    static class DateSetFunction
    extends Function {
        public DateSetFunction(String name, String[] parameters) {
            super(name, parameters);
        }

        @Override
        public Object eval() throws BOSException, EASBizException {
            String paramDate = this.parameters[0];
            Date oldDate = null;
            IFunction funcDate = FunctionLoader.getInstance().parseFunction(paramDate);
            if (funcDate != null) {
                funcDate.addParamValueProvider(this.getProvider());
                oldDate = (Date)funcDate.eval();
            }
            if (oldDate == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(oldDate);
            String paramField = this.parameters[1];
            if ("END_OF_DAY".equalsIgnoreCase(paramField)) {
                calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
                calendar.set(14, 999);
            }
            return calendar.getTime();
        }
    }

    static class DateAddFunction
    extends Function {
        public DateAddFunction(String name, String[] parameters) {
            super(name, parameters);
        }

        @Override
        public Object eval() throws BOSException, EASBizException {
            String paramDate = this.parameters[0];
            Date oldDate = null;
            IFunction funcDate = FunctionLoader.getInstance().parseFunction(paramDate);
            if (funcDate != null) {
                funcDate.addParamValueProvider(this.getProvider());
                oldDate = (Date)funcDate.eval();
            }
            if (oldDate == null) {
                return null;
            }
            int amount = Integer.parseInt(this.parameters[2]);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(oldDate);
            int field = -1;
            String paramField = this.parameters[1];
            if ("MONTH".equalsIgnoreCase(paramField)) {
                field = 2;
            } else if ("YEAR".equalsIgnoreCase(paramField)) {
                field = 1;
            } else if ("DAY_OF_MONTH".equalsIgnoreCase(paramField)) {
                field = 5;
            }
            if (field == -1) {
                throw new IllegalArgumentException("the parameter part " + paramField + " is not a valid Date Part!");
            }
            calendar.add(field, amount);
            return calendar.getTime();
        }
    }

    static class GetPositionFunction
    extends Function {
        public GetPositionFunction(String name, String[] parameters) {
            super(name, parameters);
        }

        @Override
        public Object eval() throws BOSException, EASBizException {
            String person = this.parameters[1];
            if (ExpressionParser.isTemporaryVariable(person)) {
                Context ctx = (Context)this.getParamValue(this.parameters[0]);
                Object value = this.getParamValue(person);
                if (!(value instanceof PersonInfo)) {
                    return null;
                }
                try {
                    IObjectValue personPosition = this.getPersonPosition(ctx, (PersonInfo)value);
                    return personPosition;
                }
                catch (ObjectNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
    }

    static class GetOrgUnitFunction
    extends Function {
        public GetOrgUnitFunction(String name, String[] parameters) {
            super(name, parameters);
        }

        @Override
        public Object eval() throws BOSException, EASBizException {
            String person;
            boolean isClient;
            Context ctx = (Context)this.getParamValue(this.parameters[0]);
            boolean bl = isClient = ctx == null;
            if ("LoginOrg".equalsIgnoreCase(this.parameters[1])) {
                OrgType orgType = (OrgType)this.getParamValue(this.parameters[2]);
                OrgUnitInfo loginOrg = isClient ? SysContext.getSysContext().getCurrentOrgUnit() : (OrgUnitInfo)ctx.get((Object)orgType);
                return loginOrg;
            }
            if ("DefMainOrg".equalsIgnoreCase(this.parameters[1])) {
                OrgType orgType = (OrgType)this.getParamValue(this.parameters[2]);
                OrgUnitInfo loginOrg = isClient ? SysContext.getSysContext().getCurrentOrgUnit() : (OrgUnitInfo)ctx.get((Object)orgType);
                String permissionItem = this.parameters[3];
                OrgUnitCollection collection = OrgUnitUtil.getAuthOrgByPermItem(ctx, orgType, permissionItem);
                OrgUnitCollection bizOrgs = OrgUnitUtil.getOrgUnitInfosByType(ctx, collection, orgType, 2);
                if (bizOrgs == null) {
                    return null;
                }
                int size = bizOrgs.size();
                OrgUnitInfo[] mainOrgs = new OrgUnitInfo[size];
                if (size > 0) {
                    Object[] objects = bizOrgs.toArray();
                    System.arraycopy(objects, 0, mainOrgs, 0, size);
                }
                String loginOrgId = loginOrg.getId().toString();
                for (int i = 0; i < mainOrgs.length; ++i) {
                    if (!loginOrgId.equals(mainOrgs[i].getId().toString())) continue;
                    return mainOrgs[i];
                }
                mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, true);
                return mainOrgs[0];
            }
            if ("Department".equalsIgnoreCase(this.parameters[1]) && ExpressionParser.isTemporaryVariable(person = this.parameters[2])) {
                Object value = this.getParamValue(person);
                if (!(value instanceof PersonInfo)) {
                    return null;
                }
                try {
                    IObjectValue personPosition = this.getPersonPosition(ctx, (PersonInfo)value);
                    if (personPosition == null) {
                        return null;
                    }
                    return personPosition.get("adminOrgUnit");
                }
                catch (ObjectNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
    }

    static class GetUserFunction
    extends Function {
        public GetUserFunction(String name, String[] parameters) {
            super(name, parameters);
        }

        @Override
        public Object eval() throws BOSException, EASBizException {
            IUser iuser;
            UserInfo userInfo;
            boolean isPerson;
            Context ctx = (Context)this.getParamValue(this.parameters[0]);
            boolean bl = isPerson = this.parameters.length > 1 && "Person".equals(this.parameters[1]);
            if (this.getNodeType().isGUIClient() && !isPerson) {
                return SysContext.getSysContext().getCurrentUserInfo();
            }
            Object userPK = this.getNodeType().isGUIClient() ? new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()) : ctx.getCaller();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("number");
            selectors.add("name");
            if (isPerson) {
                selectors.add("person.id");
                selectors.add("person.number");
                selectors.add("person.name");
            }
            if ((userInfo = (iuser = (IUser)this.getBizInterface(ctx, UserFactory.class)).getUserInfo(userPK, selectors)) != null) {
                if (isPerson) {
                    return userInfo.getPerson();
                }
                return userInfo;
            }
            return null;
        }
    }

    static class GetBillNumberFunction
    extends Function {
        public GetBillNumberFunction(String name, String[] parameters) {
            super(name, parameters);
        }

        @Override
        public Object eval() throws BOSException, EASBizException {
            String mainOrgId;
            RuleStatus ruleStatus;
            Context ctx = (Context)this.getParamValue(this.parameters[0]);
            ICodingRuleManager iCodingRuleManager = (ICodingRuleManager)this.getBizInterface(ctx, CodingRuleManagerFactory.class);
            IObjectValue objValue = (IObjectValue)this.getParamValue(this.parameters[1]);
            IObjectValue mainOrg = (IObjectValue)this.getParamValue(this.parameters[2]);
            if (mainOrg == null) {
                mainOrg = (IObjectValue)ctx.get((Object)"CurOU");
            }
            if ((ruleStatus = iCodingRuleManager.getRuleStatus(objValue, mainOrgId = mainOrg.get(mainOrg.getPKField()).toString())).isExist() && ruleStatus.isAddView()) {
                return iCodingRuleManager.getNumber(objValue, mainOrgId);
            }
            return null;
        }
    }

    static class GetDateFunction
    extends Function {
        private static final Pattern ISO_DATE_FORMAT = Pattern.compile("yyyy\\-MM\\-dd");
        private static final Pattern ISO_DATETIME_FORMAT = Pattern.compile("yyyy\\-MM\\-dd[\\sT]HH:mm:ss");

        public GetDateFunction(String name, String[] parameters) {
            super(name, parameters);
        }

        @Override
        public Object eval() throws BOSException, EASBizException {
            Calendar calendar = Calendar.getInstance();
            if (this.parameters.length == 0 || ISO_DATE_FORMAT.matcher(this.parameters[0]).matches()) {
                return Function.truncateTime(calendar);
            }
            if (this.parameters.length >= 1 || ISO_DATETIME_FORMAT.matcher(this.parameters[0]).matches()) {
                return calendar.getTime();
            }
            return Function.truncateTime(calendar);
        }
    }
}

