/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionUtil;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public final class BusinessProcessUtil {
    private static final String ENTRIES_NAME1 = "entries";
    private static final String ENTRIES_NAME2 = "entry";
    private static final int MAX_PARAMS = 2000;
    private static Map entriesNameMap = new HashMap();

    public static IBizCtrl getBizInteface(Context ctx, BOSObjectType bosType) throws BOSException {
        EntityObjectInfo mainEO = BusinessProcessUtil.getEntityInfo(ctx, bosType);
        return BusinessProcessUtil.getLocBizInteface(ctx, (BusinessObjectInfo)mainEO);
    }

    public static IBizCtrl getLocBizInteface(Context ctx, BOSObjectType bosType) throws BOSException {
        return BusinessProcessUtil.getBizInteface(ctx, bosType);
    }

    public static EntityObjectInfo getEntityInfo(Context ctx, BOSObjectType bosType) {
        EntityObjectInfo mainEO = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        return mainEO;
    }

    public static EntityObjectInfo getEntityInfo(Context ctx, String packageName, String entityName) {
        MetaDataPK pk = new MetaDataPK(packageName, entityName);
        EntityObjectInfo mainEO = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)pk);
        return mainEO;
    }

    public static DataTableInfo getTableInfo(Context ctx, String packageName, String tableName) {
        MetaDataPK pk = new MetaDataPK(packageName, tableName);
        DataTableInfo table = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getDataTable((IMetaDataPK)pk);
        return table;
    }

    public static IBizCtrl getFacadeBizInteface(Context ctx, BOSObjectType bosType) throws BOSException {
        BusinessObjectInfo mainBO = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(bosType);
        return BusinessProcessUtil.getLocBizInteface(ctx, mainBO);
    }

    public static IBizCtrl getFacadeLocBizInteface(Context ctx, BOSObjectType bosType) throws BOSException {
        return BusinessProcessUtil.getFacadeBizInteface(ctx, bosType);
    }

    private static IBizCtrl getLocBizInteface(Context ctx, BusinessObjectInfo mainEO) throws BOSException {
        if (mainEO.isDynamic()) {
            return (IBizCtrl)BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)new MetaDataPK(mainEO.getFullName()));
        }
        String clzFactoryName = mainEO.getBusinessImplFactory();
        try {
            Class<?> clzFactory = Class.forName(clzFactoryName);
            IBizCtrl iBiz = BusinessProcessUtil.getBizInterface(ctx, clzFactory);
            return iBiz;
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static IBizCtrl getBizInterface(Context ctx, Class clzFactory) throws BOSException {
        boolean isLocal = ctx != null;
        IBizCtrl iBiz = null;
        try {
            if (isLocal) {
                Class[] parameterTypes = new Class[]{Context.class};
                Method mGetInstance = clzFactory.getMethod("getLocalInstance", parameterTypes);
                iBiz = (IBizCtrl)mGetInstance.invoke(null, ctx);
            } else {
                Method mGetInstance = clzFactory.getMethod("getRemoteInstance", null);
                iBiz = (IBizCtrl)mGetInstance.invoke(null, null);
            }
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return iBiz;
    }

    public static Method getLocBizMethod(IBizCtrl iBiz, String methodName, Class[] parameterTypes) throws BOSException {
        try {
            return iBiz.getClass().getMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static Object invokeBizMethod(IBizCtrl iBiz, Method method, Object[] params) throws EASBizException, BOSException {
        try {
            return method.invoke((Object)iBiz, params);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            BusinessProcessUtil.handleInvocationTargetException(e);
            return null;
        }
    }

    public static void handleInvocationTargetException(InvocationTargetException e) throws EASBizException, BOSException {
        Throwable t = e.getTargetException();
        if (t != null && t instanceof EASBizException) {
            throw (EASBizException)t;
        }
        if (t != null && t instanceof BOSException) {
            throw (BOSException)t;
        }
        throw new BOSException((Throwable)e);
    }

    public static Method getCollectionMethod(Context ctx, BOSObjectType bosType) throws BOSException {
        IBizCtrl iBiz = BusinessProcessUtil.getLocBizInteface(ctx, bosType);
        String mGetCollectionName = "getCollection";
        Method mGetCollection = BusinessProcessUtil.getLocBizMethod(iBiz, mGetCollectionName, new Class[]{EntityViewInfo.class});
        return mGetCollection;
    }

    public static IObjectCollection getCollectionInstance(Context ctx, BOSObjectType bosType) throws BOSException {
        return BatchActionUtil.getCollectionInstance((Context)ctx, (BOSObjectType)bosType);
    }

    public static PropertyInfo getPropertyInfo(Context ctx, BOSObjectType bosType, String propName) throws BOSException {
        PropertyInfo property;
        if (propName == null) {
            return null;
        }
        EntityObjectInfo mainEO = BusinessProcessUtil.getEntityInfo(ctx, bosType);
        String[] splits = propName.split("\\.");
        if (splits.length == 1) {
            property = mainEO.getPropertyByNameRuntime(propName);
        } else {
            HashMap subEntities = new HashMap();
            property = BusinessProcessUtil.getPropertyInfo(mainEO, propName, splits, subEntities);
        }
        return property;
    }

    public static String getPropertyAlias(Context ctx, BOSObjectType bosType, String propName) throws BOSException {
        PropertyInfo property = BusinessProcessUtil.getPropertyInfo(ctx, bosType, propName);
        if (property != null) {
            return property.getAlias();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEntityEntriesName(Context ctx, BOSObjectType bosType) throws BOSException {
        String entriesName = (String)entriesNameMap.get(bosType);
        if (entriesName != null) {
            return entriesName;
        }
        Map map = entriesNameMap;
        synchronized (map) {
            PropertyInfo property2;
            entriesName = (String)entriesNameMap.get(bosType);
            if (entriesName != null) {
                return entriesName;
            }
            EntityObjectInfo mainEO = BusinessProcessUtil.getEntityInfo(ctx, bosType);
            if (BusinessProcessUtil.isCompositionLink(mainEO, property2 = mainEO.getPropertyByNameRuntime(ENTRIES_NAME1))) {
                entriesNameMap.put(bosType, ENTRIES_NAME1);
                return ENTRIES_NAME1;
            }
            property2 = mainEO.getPropertyByNameRuntime(ENTRIES_NAME2);
            if (property2 != null && property2 instanceof LinkPropertyInfo) {
                entriesNameMap.put(bosType, ENTRIES_NAME2);
                return ENTRIES_NAME2;
            }
            PropertyCollection collection = mainEO.getPropertiesRuntime();
            for (PropertyInfo property2 : collection) {
                if (!BusinessProcessUtil.isCompositionLink(mainEO, property2)) continue;
                entriesNameMap.put(bosType, property2.getName());
                return property2.getName();
            }
            entriesNameMap.put(bosType, ENTRIES_NAME1);
            return ENTRIES_NAME1;
        }
    }

    public static boolean isEntryProperty(EntityObjectInfo mainEO, String propertyName) throws BOSException {
        String entriesName = (String)entriesNameMap.get(mainEO.getBOSType());
        if (entriesName != null && entriesName.equals(propertyName)) {
            return true;
        }
        PropertyInfo property = mainEO.getPropertyByNameRuntime(propertyName);
        if (BusinessProcessUtil.isCompositionLink(mainEO, property)) {
            if (entriesName == null) {
                entriesNameMap.put(mainEO.getBOSType(), entriesName);
            }
            return true;
        }
        return false;
    }

    public static boolean isCompositionLink(EntityObjectInfo mainEO, PropertyInfo property) {
        RelationshipInfo relation;
        return property != null && property instanceof LinkPropertyInfo && (relation = ((LinkPropertyInfo)property).getRelationship()).getLinkType(mainEO).equals((Object)RelationshipType.COMPOSITION);
    }

    public static String getEntityEntriesTable(Context ctx, BOSObjectType bosType) throws BOSException {
        EntityObjectInfo entryEO = BusinessProcessUtil.getEntityEntriesEntity(ctx, bosType);
        return entryEO != null ? entryEO.getTable().getName() : null;
    }

    public static EntityObjectInfo getEntityEntriesEntity(Context ctx, BOSObjectType bosType) throws BOSException {
        RelationshipInfo relation;
        EntityObjectInfo mainEO;
        PropertyInfo property;
        String entriesName = BusinessProcessUtil.getEntityEntriesName(ctx, bosType);
        if (entriesName != null && (property = (mainEO = BusinessProcessUtil.getEntityInfo(ctx, bosType)).getPropertyByNameRuntime(entriesName)) != null && property instanceof LinkPropertyInfo && (relation = ((LinkPropertyInfo)property).getRelationship()).getLinkType(mainEO).equals((Object)RelationshipType.COMPOSITION)) {
            return relation.getSupplierObject();
        }
        return null;
    }

    public static DataType getDataType(PropertyInfo propInfo) {
        return propInfo instanceof OwnPropertyInfo ? ((OwnPropertyInfo)propInfo).getDataType() : DataType.OBJECTPK;
    }

    public static Object getValueByBosType(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        BOSObjectType bosType = BOSUuid.read((String)pk.toString()).getType();
        IBizCtrl iBiz = BusinessProcessUtil.getLocBizInteface(ctx, bosType);
        Method mGetValue = BusinessProcessUtil.getLocBizMethod(iBiz, "getValue", new Class[]{IObjectPK.class, SelectorItemCollection.class});
        return BusinessProcessUtil.invokeBizMethod(iBiz, mGetValue, new Object[]{pk, selector});
    }

    public static Object getValueByBosType(Context ctx, BOSObjectType bosType, EntityViewInfo view) throws BOSException, EASBizException {
        IObjectValue iObjectValue;
        Connection cn;
        block7: {
            IObjectCollection col;
            block8: {
                cn = null;
                if (ctx != null) {
                    cn = EJBFactory.getConnection((Context)ctx);
                    break block7;
                }
                col = BusinessProcessUtil.getCollectionByBosType(ctx, bosType.toString(), view, null, null);
                if (col != null && col.size() != 0) break block8;
                Object var5_7 = null;
                SQLUtils.cleanup((Connection)cn);
                return var5_7;
            }
            IObjectValue iObjectValue2 = col.getObject(0);
            SQLUtils.cleanup((Connection)cn);
            return iObjectValue2;
        }
        try {
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)bosType, (Context)ctx, (Connection)cn);
            iObjectValue = dao.getValue(view);
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
        return iObjectValue;
    }

    public static IObjectCollection getCollectionByBosType(Context ctx, String bosType, EntityViewInfo view, FilterItemInfo[][] filterItems, FilterInfo fixedFilter) throws BOSException, EASBizException {
        IObjectCollection collection = null;
        Method mGetCollection = BusinessProcessUtil.getCollectionMethod(ctx, BOSObjectType.create((String)bosType));
        IBizCtrl iBiz = BusinessProcessUtil.getLocBizInteface(ctx, BOSObjectType.create((String)bosType));
        if (filterItems == null || filterItems.length == 0) {
            return (IObjectCollection)BusinessProcessUtil.invokeBizMethod(iBiz, mGetCollection, new Object[]{view});
        }
        int cntOneItem = filterItems[0].length;
        int cntFixed = fixedFilter == null ? 0 : fixedFilter.getFilterItems().size();
        int length = filterItems.length;
        int cntTotal = cntOneItem * length + cntFixed;
        int cntCycle = (cntTotal > 2000 ? 2000 - cntFixed : cntTotal - cntFixed) / cntOneItem;
        int idxOfMask = 0;
        StringBuffer sbMask = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        String leftBracket = cntOneItem > 1 ? "(" : "";
        String rightBracket = cntOneItem > 1 ? ")" : "";
        for (int i = 0; i < length; ++i) {
            if (sbMask.length() > 0) {
                sbMask.append(" OR ");
            }
            sbMask.append(leftBracket);
            for (int j = 0; j < cntOneItem; ++j) {
                filter.getFilterItems().add(filterItems[i][j]);
                if (j > 0) {
                    sbMask.append(" AND ");
                }
                sbMask.append("#").append(idxOfMask++);
            }
            sbMask.append(rightBracket);
            if ((i + 1) % cntCycle != 0 && i != length - 1) continue;
            if (sbMask.length() > 0) {
                filter.setMaskString(sbMask.toString());
            }
            if (fixedFilter != null) {
                filter.mergeFilter(fixedFilter, "AND");
            }
            view.setFilter(filter);
            if (collection == null) {
                collection = (IObjectCollection)BusinessProcessUtil.invokeBizMethod(iBiz, mGetCollection, new Object[]{view});
            } else {
                collection.addObjectCollection((IObjectCollection)BusinessProcessUtil.invokeBizMethod(iBiz, mGetCollection, new Object[]{view}));
            }
            filter = new FilterInfo();
            sbMask.setLength(0);
            idxOfMask = 0;
        }
        return collection;
    }

    public static Object getLinkObject(Context ctx, PropertyInfo propertyInfo, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        if (propertyInfo instanceof LinkPropertyInfo) {
            RelationshipInfo relation = ((LinkPropertyInfo)propertyInfo).getRelationship();
            EntityObjectInfo supplierEo = relation.getSupplierObject();
            IBizCtrl iBiz = BusinessProcessUtil.getLocBizInteface(ctx, (BusinessObjectInfo)supplierEo);
            Method mGetValue = BusinessProcessUtil.getLocBizMethod(iBiz, "getValue", new Class[]{IObjectPK.class, SelectorItemCollection.class});
            return BusinessProcessUtil.invokeBizMethod(iBiz, mGetValue, new Object[]{pk, selector});
        }
        return null;
    }

    public static Class[] getParamClassTypes(String[] paramsType) throws BOSException {
        if (paramsType == null) {
            return null;
        }
        Class[] clzType = new Class[paramsType.length];
        try {
            for (int i = 0; i < paramsType.length; ++i) {
                clzType[i] = paramsType[i].equalsIgnoreCase("String") ? String.class : (paramsType[i].equals("Boolean") ? Boolean.class : (paramsType[i].equals("boolean") ? Boolean.TYPE : (paramsType[i].equals("int") ? Integer.TYPE : (paramsType[i].equalsIgnoreCase("Integer") ? Integer.class : (paramsType[i].equalsIgnoreCase("Context") ? Class.forName("com.kingdee.bos.Context") : (paramsType[i].equalsIgnoreCase("IObjectPK") ? Class.forName("com.kingdee.bos.dao.IObjectPK") : (paramsType[i].equalsIgnoreCase("IObjectValue") ? Class.forName("com.kingdee.bos.dao.IObjectValue") : (paramsType[i].equalsIgnoreCase("CoreBillBaseInfo") ? Class.forName("com.kingdee.eas.framework.CoreBillBaseInfo") : (paramsType[i].equalsIgnoreCase("IObjectCollection") ? Class.forName("com.kingdee.bos.dao.IObjectCollection") : (paramsType[i].equalsIgnoreCase("AbstractObjectCollection") ? Class.forName("com.kingdee.bos.dao.AbstractObjectCollection") : (paramsType[i].equalsIgnoreCase("BOTRelationCollection") ? Class.forName("com.kingdee.bos.metadata.bot.BOTRelationCollection") : Class.forName(paramsType[i]))))))))))));
            }
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        return clzType;
    }

    public static boolean existColumnByName(Context ctx, BOSObjectType bosType, String columnName) throws BOSException {
        EntityObjectInfo mainEO = BusinessProcessUtil.getEntityInfo(ctx, bosType);
        DataTableInfo tableInfo = mainEO.getTable();
        ColumnInfo column = tableInfo.getColumnByNameRuntime(columnName);
        return column != null;
    }

    public static OrgType getOrgTypeFromEntity(Context ctx, BOSObjectType type) {
        EntityObjectInfo mainEO = BusinessProcessUtil.getEntityInfo(ctx, type);
        String orgType = (String)mainEO.getExtendedProperties().get("OrgType");
        if (orgType == null) {
            orgType = "NONE";
        }
        OrgType ot = OrgType.getEnum((String)orgType);
        return ot;
    }

    public static PropertyInfo getPropertyInfo(EntityObjectInfo mainEo, String name, String[] splits, Map subEntities) {
        String lastname;
        PropertyInfo prop;
        EntityObjectInfo eoi = null;
        eoi = mainEo;
        if (splits.length > 1) {
            int idx = 0;
            do {
                String propName;
                if (!subEntities.containsKey(propName = eoi.getName() + StringUtil.nameFromSplits(splits, idx + 1))) {
                    LinkPropertyInfo linkedPropInfo = (LinkPropertyInfo)eoi.getPropertyByNameRuntime(splits[idx]);
                    if (linkedPropInfo == null) {
                        throw new IllegalArgumentException("XML\u914d\u7f6e\u6587\u4ef6\u914d\u7f6e\u7684\u5c5e\u6027" + name + "\u4e0d\u662f\u5b9e\u4f53" + eoi.getAlias() + "\u6709\u6548\u7684\u5c5e\u6027");
                    }
                    RelationshipInfo relation = linkedPropInfo.getRelationship();
                    EntityObjectInfo childEo = relation.getChildObject(eoi);
                    subEntities.put(propName, childEo);
                    eoi = childEo;
                    continue;
                }
                eoi = (EntityObjectInfo)subEntities.get(propName);
            } while (++idx < splits.length - 1);
        }
        if ((prop = eoi.getPropertyByNameRuntime(lastname = splits[splits.length - 1])) == null) {
            throw new IllegalArgumentException("XML\u914d\u7f6e\u6587\u4ef6\u914d\u7f6e\u7684\u5c5e\u6027" + name + "\u4e0d\u662f\u5b9e\u4f53" + eoi.getAlias() + "\u6709\u6548\u7684\u5c5e\u6027");
        }
        return prop;
    }

    public static Integer actionNameToStatus(String actionName) {
        if (actionName == null) {
            return null;
        }
        if (actionName.equalsIgnoreCase(BatchActionEnum.SAVE.getBizAction()) || actionName.equalsIgnoreCase(BatchActionEnum.UNAUDIT.getBizAction())) {
            return Integer.valueOf("1");
        }
        if (actionName.equalsIgnoreCase(BatchActionEnum.SUBMIT.getBizAction())) {
            return Integer.valueOf("2");
        }
        if (actionName.equalsIgnoreCase(BatchActionEnum.CANCEL.getBizAction())) {
            return Integer.valueOf("3");
        }
        if (actionName.equalsIgnoreCase(BatchActionEnum.AUDIT.getBizAction()) || actionName.equalsIgnoreCase(BatchActionEnum.UNCLOSE.getBizAction())) {
            return Integer.valueOf("4");
        }
        if (actionName.equalsIgnoreCase(BatchActionEnum.FREEZE.getBizAction())) {
            return Integer.valueOf("6");
        }
        if (actionName.equalsIgnoreCase(BatchActionEnum.CLOSE.getBizAction())) {
            return Integer.valueOf("7");
        }
        return null;
    }
}

