/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.common;

import com.kingdee.messageCenter.IAdapter;
import com.kingdee.messageCenter.IClientManager;
import com.kingdee.messageCenter.IMessagePool;
import com.kingdee.messageCenter.IMessageQueue;
import com.kingdee.messageCenter.IWorker;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.MessageException;
import com.kingdee.messageCenter.common.ObjectFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.springframework.dao.DuplicateKeyException;

public class MessageQueue
implements IMessageQueue {
    private static Logger logger = Logger.getLogger(Message.class);
    private LinkedBlockingQueue<Message> queue = new LinkedBlockingQueue();
    private MessageProcessor processor = null;
    private Map<String, IWorker> workers = null;
    private String status = "\u672a\u5f00\u59cb";
    private Object mutex = new Object();

    private IMessagePool getMessagePool() {
        return ObjectFactory.getInstance().getMessagePool();
    }

    private IClientManager getClientManager() {
        return ObjectFactory.getInstance().getClientManager();
    }

    private IAdapter getMessageAdapter() {
        return ObjectFactory.getInstance().getAdapter();
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void receive(Message message) throws MessageException {
        boolean saved = this.saveMessage(message);
        if (saved) {
            this.queue.add(message);
            this.working();
            this.getMessageAdapter().receive(message);
        }
    }

    @Override
    public Message execute(Message message) throws MessageException {
        this.saveMessage(message);
        IWorker worker = this.workers.get(message.getSubject());
        if (worker == null) {
            String errMsg = "\u4e3b\u9898[" + message.getSubject() + "]\u6ca1\u6709\u627e\u5230\u5904\u7406\u5668";
            MessageException t = new MessageException(411, errMsg);
            logger.error((Object)message, (Throwable)t);
            throw t;
        }
        Message retMsg = worker.process(message);
        retMsg.setSubject(message.getSubject());
        retMsg.setEnterpriseId(message.getEnterpriseId());
        return retMsg;
    }

    private boolean saveMessage(Message message) throws MessageException {
        boolean ret = false;
        if (message.getStatus() == 0) {
            message.setDirector(0);
            try {
                this.getMessagePool().saveMessage(message);
            }
            catch (Exception e) {
                if (e instanceof DuplicateKeyException || e.getCause() instanceof DuplicateKeyException) {
                    ret = false;
                }
                throw new MessageException(e);
            }
            ret = true;
        }
        return ret;
    }

    @Override
    public void setup() throws MessageException {
        this.workers = this.getClientManager().getWorkers();
        this.processor = new MessageProcessor();
        this.status = "\u5b8c\u6210\u521d\u59cb\u5316";
        this.processUnMessages();
    }

    protected void processUnMessages() throws MessageException {
        List<Message> messageList = this.getMessagePool().getUnProcessedMessage();
        if (messageList != null && messageList.size() > 0) {
            this.queue.addAll(messageList);
            this.working();
        }
    }

    protected void working() throws MessageException {
        this.processor.start();
    }

    private class MessageProcessor
    implements Runnable {
        private Thread workerthread = new Thread(this);
        private boolean working = false;

        private MessageProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = MessageQueue.this.mutex;
            synchronized (object) {
                if (!this.working) {
                    this.working = true;
                    this.workerthread.run();
                }
            }
        }

        @Override
        public void run() {
            MessageQueue.this.status = "\u5f02\u6b65\u6d88\u606f\u5904\u7406\u5668\u542f\u52a8";
            int messagecount = 0;
            Message message = null;
            IWorker worker = null;
            while ((message = (Message)MessageQueue.this.queue.poll()) != null) {
                worker = (IWorker)MessageQueue.this.workers.get(message.getSubject());
                if (worker != null) {
                    try {
                        worker.process(message);
                        MessageQueue.this.getMessagePool().moveMessage2Old(message.getId());
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u6d88\u606f " + message.getSubject() + " \u5904\u7406\u51fa\u9519"), (Throwable)e);
                    }
                } else {
                    logger.error((Object)("\u6ca1\u6709\u627e\u5230\u4e3b\u9898" + message.getSubject() + "\u5bf9\u5e94\u7684\u5904\u7406\u5668"));
                }
                ++messagecount;
            }
            MessageQueue.this.status = "\u5f02\u6b65\u6d88\u606f\u5904\u7406\u5668\u7ed3\u675f\uff0c\u5904\u7406" + messagecount + "\u6761\u6d88\u606f\u3002";
            this.working = false;
        }
    }
}

