/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.el.rec.AchRecordDetailCollection;
import com.kingdee.eas.el.rec.AchRecordDetailFactory;
import com.kingdee.eas.el.rec.AchRecordDetailInfo;
import com.kingdee.eas.el.rec.ArcContentTypeEnum;
import com.kingdee.eas.el.rec.ArcRecordCollection;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcSchLogFactory;
import com.kingdee.eas.el.rec.ArcSchLogInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.ArchPeriodFactory;
import com.kingdee.eas.el.rec.ArchPeriodInfo;
import com.kingdee.eas.el.rec.ArchSchemeCollection;
import com.kingdee.eas.el.rec.ArchSchemeFactory;
import com.kingdee.eas.el.rec.ArchSchemeInfo;
import com.kingdee.eas.el.rec.ArchSchemeScopeOrgEntryCollection;
import com.kingdee.eas.el.rec.ArchSchemeScopeOrgEntryInfo;
import com.kingdee.eas.el.rec.ArchSysLogServiceFacadeFactory;
import com.kingdee.eas.el.rec.ArcheSchemeContentEntryCollection;
import com.kingdee.eas.el.rec.AttachBillAchDetailCollection;
import com.kingdee.eas.el.rec.AttachBillAchDetailFactory;
import com.kingdee.eas.el.rec.AttachBillAchDetailInfo;
import com.kingdee.eas.el.rec.CurrencyEntryCollection;
import com.kingdee.eas.el.rec.CurrencyEntryInfo;
import com.kingdee.eas.el.rec.GenerateRechRecordFacadeFactory;
import com.kingdee.eas.el.rec.OperationEnum;
import com.kingdee.eas.el.rec.RecUpgradeFacadeFactory;
import com.kingdee.eas.el.rec.RecordBaseExtendCollection;
import com.kingdee.eas.el.rec.RecordBaseExtendFactory;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.ReportCycleType;
import com.kingdee.eas.el.rec.app.AbstractArchSchemeFacadeControllerBean;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.filing.FilingInstanceFactory;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.license.RecLicenseUtil;
import com.kingdee.eas.el.rec.model.ArchInfos;
import com.kingdee.eas.el.rec.model.FileInfo;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.model.ReportArchInfo;
import com.kingdee.eas.el.rec.model.ReportArchInfos;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelperFactory;
import com.kingdee.eas.el.rec.outputmodule.archsys.pojo.ArchFormatInfo;
import com.kingdee.eas.el.rec.outputmodule.archsys.util.ThreadUtil;
import com.kingdee.eas.el.rec.thread.UploadArchInfosThreadPool;
import com.kingdee.eas.el.rec.tool.ArchRecordUtils;
import com.kingdee.eas.el.rec.tool.ArchUtils;
import com.kingdee.eas.el.rec.tool.FormatUtils;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.IBillHandler;
import com.kingdee.eas.el.rec.tool.IDUtils;
import com.kingdee.eas.el.rec.tool.MD5;
import com.kingdee.eas.el.rec.tool.PeriodUtil;
import com.kingdee.eas.el.rec.tool.RECStringUtil;
import com.kingdee.eas.el.rec.tool.engine.ParsingEngineUtil;
import com.kingdee.eas.el.rec.tool.engine.ReportParsingEngineUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Document;

public class ArchSchemeFacadeControllerBean
extends AbstractArchSchemeFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.app.ArchSchemeFacadeControllerBean");

    @Override
    protected void _execArchScheme(Context ctx, String archSchemeID) throws BOSException, EASBizException {
        this._execSchemeCurrent(ctx, archSchemeID, null);
    }

    private void multiHandleArchReport_OtherReport(Context ctx, ArchSchemeInfo asInfo, ArcheSchemeContentEntryCollection contents, ArchSchemeScopeOrgEntryCollection orgs) throws Exception {
        CurrencyEntryCollection currencyColl = asInfo.getCurrency();
        ArrayList<CurrencyInfo> currentcyList = new ArrayList<CurrencyInfo>();
        if (currencyColl != null && currencyColl.size() > 0) {
            for (int i = 0; i < currencyColl.size(); ++i) {
                currentcyList.add(currencyColl.get(i).getCurrency());
            }
        }
        CompanyOrgUnitCollection companyOrgs = FilingUtils.getCompanyOrgs(ctx, orgs, false, asInfo.getLastUpdateUser().getId() + "", "el_rec_ArchSchemeList_addNew");
        StringBuilder sbError = new StringBuilder();
        boolean flag = true;
        for (int i = 0; i < contents.size(); ++i) {
            RecordBaseInfo content = contents.get(i).getArchContent();
            try {
                for (int j = 0; j < companyOrgs.size(); ++j) {
                    ReportArchInfos rai = null;
                    CompanyOrgUnitInfo org = companyOrgs.get(j);
                    if (currentcyList.size() == 0) {
                        currentcyList.add(org.getBaseCurrency());
                    }
                    for (int v = 0; v < currentcyList.size(); ++v) {
                        CurrencyInfo currencyInfo = (CurrencyInfo)currentcyList.get(v);
                        PeriodCollection periods = PeriodUtil.getPeriodsForOtherReport(ctx, asInfo);
                        for (int k = 0; k < periods.size(); ++k) {
                            PeriodInfo period = periods.get(k);
                            rai = this.getReportArchInfos(ctx, asInfo, content, org, contents, period, currencyInfo);
                            if (rai == null) continue;
                            flag = false;
                            this.handleReportArchInfos(ctx, rai);
                        }
                    }
                }
                continue;
            }
            catch (Exception e) {
                logger.error((Object)(content.getName() + " \u5f52\u6863\u5185\u5bb9\u5f52\u6863\u5931\u8d25\uff01"), (Throwable)e);
                sbError.append(content.getName()).append("!");
            }
        }
        if (flag) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u6ca1\u6709\u53ef\u4ee5\u5f52\u6863\u7684\u62a5\u8868\uff01"));
        }
        if (!StringUtils.isEmpty((String)sbError.toString())) {
            throw new EASBizException(new NumericExceptionSubItem("00", sbError.toString() + "\u5f52\u6863\u5931\u8d25\uff01"));
        }
    }

    private void multiHandleArchReport_report(Context ctx, ArchSchemeInfo asInfo, ArcheSchemeContentEntryCollection contents, ArchSchemeScopeOrgEntryCollection orgs) throws Exception {
        CompanyOrgUnitCollection companyOrgs = FilingUtils.getCompanyOrgs(ctx, orgs, true, asInfo.getLastUpdateUser().getId() + "", "el_rec_ArchSchemeList_addNew");
        StringBuilder sbError = new StringBuilder();
        boolean flag = true;
        for (int j = 0; j < companyOrgs.size(); ++j) {
            ReportArchInfos rai = null;
            CompanyOrgUnitInfo org = companyOrgs.get(j);
            for (int i = 0; i < contents.size(); ++i) {
                RecordBaseInfo content = FilingUtils.getContent(ctx, contents.get(i).getArchContent(), org);
                content.setReportCycleType(asInfo.getReportCycleType());
                try {
                    PeriodCollection periods = PeriodUtil.getPeriodsForReport(ctx, asInfo, content, org);
                    for (int k = 0; k < periods.size(); ++k) {
                        PeriodInfo period = periods.get(k);
                        CurrencyEntryCollection currencys = asInfo.getCurrency();
                        if (currencys.size() == 0) {
                            CurrencyEntryInfo currencyEntryInfo = new CurrencyEntryInfo();
                            currencyEntryInfo.setCurrency(org.getBaseCurrency());
                            currencys.add(currencyEntryInfo);
                        }
                        for (int l = 0; l < currencys.size(); ++l) {
                            rai = this.getReportArchInfos(ctx, asInfo, content, org, contents, period, currencys.get(l).getCurrency());
                            if (rai == null) continue;
                            flag = false;
                            this.handleReportArchInfos(ctx, rai);
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)(content.getName() + " \u5f52\u6863\u5185\u5bb9\u5f52\u6863\u5931\u8d25\uff01"), (Throwable)e);
                    sbError.append(content.getName()).append("!");
                }
            }
        }
        if (flag) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u6ca1\u6709\u53ef\u4ee5\u5f52\u6863\u7684\u62a5\u8868\uff01"));
        }
        if (!StringUtils.isEmpty((String)sbError.toString())) {
            throw new EASBizException(new NumericExceptionSubItem("00", sbError.toString() + "\u5f52\u6863\u5931\u8d25\uff01"));
        }
    }

    private void handleReportArchInfos(Context ctx, ReportArchInfos reportArchInfos) {
        if (reportArchInfos.getReportArchInfos() == null || reportArchInfos.getReportArchInfos().size() == 0 || reportArchInfos.getReportArchInfos().get(0).getData() == null) {
            return;
        }
        ArrayList<ArchFormatInfo> list = new ArrayList<ArchFormatInfo>();
        String taskFlag = IDUtils.getId();
        try {
            RecordBaseInfo content = reportArchInfos.getContent();
            CompanyOrgUnitInfo org = reportArchInfos.getOrg();
            List<XmlBase> reportArchInfoList = reportArchInfos.getReportArchInfos();
            for (int i = 0; i < reportArchInfoList.size(); ++i) {
                IXmlSrcObj data = reportArchInfoList.get(i).getData();
                if (content == null || !content.getRecordType().getValue().equals("report")) continue;
                data.put("reportType", content.getName());
            }
            ReportParsingEngineUtil reportParsingEngineUtil = (ReportParsingEngineUtil)ParsingEngineUtil.getInstance(ctx, content);
            ArchFormatInfo formatInfo = new ArchFormatInfo();
            formatInfo.setTaskFlag(taskFlag);
            String xmlName = content.getBillType().getNumber() + "_" + org.getNumber() + "_" + reportArchInfos.getPeriodInfo().getNumber() + "_" + reportArchInfos.getCurrencyInfo().getIsoCode();
            formatInfo.setXmlName(xmlName + ".xml");
            formatInfo.setXmlBases(reportArchInfoList);
            formatInfo.setContent(content);
            for (XmlBase xmlBase : reportArchInfoList) {
                InputStream[] inputs = null;
                try {
                    inputs = reportParsingEngineUtil.getFileISArray(ctx, xmlBase.getData());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (null != inputs && inputs.length > 1) {
                    Set<FileInfo> fileInfosBase = xmlBase.getFileInfos();
                    FileInfo fileInfoBase = fileInfosBase.iterator().next();
                    Iterator<FileInfo> iterator = fileInfosBase.iterator();
                    while (iterator.hasNext()) {
                        FileInfo fileInfo;
                        fileInfoBase = fileInfo = iterator.next();
                    }
                    LinkedHashSet<FileInfo> fileInfos = new LinkedHashSet<FileInfo>();
                    for (int i = 0; i < inputs.length; ++i) {
                        FileInfo fileInfo = new FileInfo(null, i + "_" + fileInfoBase.getName(), i + "_" + fileInfoBase.getSrcname());
                        fileInfos.add(fileInfo);
                        formatInfo.setAttachment(fileInfo.getName(), inputs[i]);
                    }
                    xmlBase.setFileInfos(fileInfos);
                    continue;
                }
                Set<FileInfo> fileInfos = xmlBase.getFileInfos();
                for (FileInfo fileInfo : fileInfos) {
                    if (inputs == null) {
                        formatInfo.setAttachment(fileInfo.getName(), reportParsingEngineUtil.getFileIS(ctx, xmlBase.getData()));
                        continue;
                    }
                    formatInfo.setAttachment(fileInfo.getName(), inputs[0]);
                }
            }
            Document document = reportParsingEngineUtil.getXMLFromInfoByConfig(reportArchInfoList, content);
            formatInfo.setXml(new ByteArrayInputStream(document.asXML().getBytes()));
            list.add(formatInfo);
        }
        catch (Exception e) {
            logger.error((Object)("\u751f\u6210xml\u5931\u8d25:" + reportArchInfos.getContent().getName() + "_" + reportArchInfos.getOrg().getName()), (Throwable)e);
            try {
                ReportArchInfo report = (ReportArchInfo)reportArchInfos.getReportArchInfos().get(0);
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(report.getRecordId(), ArcStateEnum.ARC_FAIL, e.getMessage(), RECStringUtil.exception2String(e));
                ArchRecordUtils.writeReportLog(ctx, report.getRecordId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (list.size() > 0) {
            ThreadUtil.getLock(taskFlag).addThreadCount(1);
            UploadArchInfosThreadPool.execute(ctx, reportArchInfos.getOrg(), reportArchInfos.getPeriodInfo(), list, taskFlag);
        }
    }

    private int isExcued(Context ctx, RecordBaseInfo content, CompanyOrgUnitInfo org, int periodNumber, ReportCycleType reportCycleType, CurrencyInfo currencyInfo) throws BOSException, EASBizException {
        String contentId = "";
        String orgId = "";
        if (content != null) {
            contentId = content.getId().toString();
        }
        if (org != null) {
            orgId = org.getId().toString();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("content", (Object)contentId));
        filter.getFilterItems().add(new FilterItemInfo("org", (Object)orgId));
        filter.getFilterItems().add(new FilterItemInfo("periodNum", (Object)periodNumber));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)(currencyInfo.getId() + "")));
        if (reportCycleType != null) {
            filter.getFilterItems().add(new FilterItemInfo("reportCycleType", (Object)reportCycleType.getValue()));
        }
        view.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("id");
        selectorItemCollection.add("state");
        view.setSelector(selectorItemCollection);
        ArcRecordCollection cols = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(view);
        if (null == cols || cols.size() == 0) {
            return 3;
        }
        ArcRecordInfo info = cols.get(0);
        if (ArcStateEnum.ARC_FAIL.equals((Object)info.getState())) {
            return 2;
        }
        if (ArcStateEnum.REVERSE_ARC.equals((Object)info.getState())) {
            return 4;
        }
        if (ArcStateEnum.ARC_SUCCESS.equals((Object)info.getState())) {
            return 1;
        }
        if (ArcStateEnum.ARC_NODATA.equals((Object)info.getState())) {
            return 1;
        }
        return 0;
    }

    private ReportArchInfos getReportArchInfos(Context ctx, ArchSchemeInfo asInfo, RecordBaseInfo content, CompanyOrgUnitInfo org, ArcheSchemeContentEntryCollection contents, PeriodInfo period, CurrencyInfo currencyInfo) {
        try {
            int excued = this.isExcued(ctx, content, org, period.getNumber(), asInfo.getReportCycleType(), currencyInfo);
            if (2 == excued || 4 == excued) {
                ReportArchInfos reportArchInfos = new ReportArchInfos(ctx, asInfo.getReportCycleType(), content, org, period, currencyInfo);
                reportArchInfos.initReportArchInfos();
                if (reportArchInfos.getReportArchInfos() != null && reportArchInfos.getReportArchInfos().size() > 0) {
                    ArchUtils.setUsing(reportArchInfos.getReportArchInfos().get(0).getId(), asInfo.getNumber());
                }
                return reportArchInfos;
            }
            if (3 == excued) {
                ReportArchInfos reportArchInfos = new ReportArchInfos(ctx, asInfo.getReportCycleType(), content, org, period, currencyInfo);
                reportArchInfos.initReportArchInfos();
                if (reportArchInfos.getReportArchInfos() != null && reportArchInfos.getReportArchInfos().size() > 0) {
                    ArchUtils.setUsing(reportArchInfos.getReportArchInfos().get(0).getId(), asInfo.getNumber());
                }
                return reportArchInfos;
            }
            if (1 == excued) {
                logger.error((Object)(content.getBillType().getNumber() + "_" + org.getNumber() + "_" + period.getNumber() + " \u5df2\u7ecf\u6267\u884c\u6210\u529f\uff01"));
            } else if (0 == excued) {
                ArcRecordInfo arcRecrdInfo = ArcRecordFactory.getLocalInstance(ctx).getArcRecordInfo(" where content='" + content.getId().toString() + "' and org ='" + org.getId().toString() + "' and periodNum='" + period.getNumber() + "'");
                if (!StringUtils.isEmpty((String)ArchUtils.getOwner(arcRecrdInfo.getId().toString()))) {
                    logger.error((Object)(content.getBillType().getNumber() + "\u5355\u636e\u7684" + org.getNumber() + "\u7ec4\u7ec7\u7684" + period.getNumber() + "\u671f\u95f4 \u6b63\u5728\u6267\u884c\u4e2d,\u672c\u6b21\u6267\u884c\u53d6\u6d88\uff01"));
                } else {
                    ReportArchInfos reportArchInfos = new ReportArchInfos(ctx, asInfo.getReportCycleType(), content, org, period, currencyInfo);
                    reportArchInfos.initReportArchInfos();
                    if (reportArchInfos.getReportArchInfos() != null && reportArchInfos.getReportArchInfos().size() > 0) {
                        ArchUtils.setUsing(reportArchInfos.getReportArchInfos().get(0).getId(), asInfo.getNumber());
                    }
                }
            } else {
                logger.error((Object)(content.getBillType().getNumber() + "_" + org.getNumber() + "_" + period.getNumber() + " \u6b63\u5728\u6267\u884c\u4e2d\uff01"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return null;
    }

    private ArchSchemeInfo getArchemeInfo(Context ctx, String archSchemeID) throws EASBizException, BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)archSchemeID));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("org.*");
        selectorItemCollection.add("currency.*");
        selectorItemCollection.add("currency.currency.*");
        selectorItemCollection.add("archemeContent.archContent.*");
        selectorItemCollection.add("archemeContent.archContent.configs.*");
        selectorItemCollection.add("archemeContent.archContent.org.*");
        selectorItemCollection.add("archemeContent.archContent.billType.*");
        selectorItemCollection.add("schemeOrg.*");
        selectorItemCollection.add("schemeOrg.org.*");
        selectorItemCollection.add("schemeOrg.org.baseCurrency.*");
        selectorItemCollection.add("template.template.*");
        selectorItemCollection.add("currency.currency.*");
        selectorItemCollection.add("mergeScope.*");
        selectorItemCollection.add("mergeScheme.*");
        entityViewInfo.setSelector(selectorItemCollection);
        ArchSchemeCollection asInfos = ArchSchemeFactory.getLocalInstance(ctx).getArchSchemeCollection(entityViewInfo);
        if (asInfos.size() == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"\u5f52\u6863\u65b9\u6848"});
        }
        return asInfos.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiHandleArchBill(Context ctx, ArchSchemeInfo asInfo, ArcheSchemeContentEntryCollection contents, ArchSchemeScopeOrgEntryCollection orgs) {
        try {
            if (ArcContentTypeEnum.OtherReport.equals((Object)asInfo.getRecType())) {
                this.multiHandleArchReport_OtherReport(ctx, asInfo, contents, orgs);
            } else if (ArcContentTypeEnum.REPORT.equals((Object)asInfo.getRecType())) {
                this.multiHandleArchReport_report(ctx, asInfo, contents, orgs);
            } else {
                if (ArcContentTypeEnum.RptsReport.equals((Object)asInfo.getRecType())) {
                    throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u5408\u5e76\u62a5\u8868\u5f52\u6863");
                }
                CompanyOrgUnitCollection companyOrgs = FilingUtils.getCompanyOrgs(ctx, orgs, true, asInfo.getLastUpdateUser().getId() + "", "el_rec_ArchSchemeList_addNew");
                logger.error((Object)("companyOrgs size is:" + companyOrgs.size()));
                StringBuilder sbError = new StringBuilder();
                for (int j = 0; j < companyOrgs.size(); ++j) {
                    for (int i = 0; i < contents.size(); ++i) {
                        CompanyOrgUnitInfo org;
                        RecordBaseInfo content = contents.get(i).getArchContent();
                        if (content.isIsRefBill() || null == (content = FilingUtils.getContent(ctx, content, org = companyOrgs.get(j)))) continue;
                        Map<String, RecordBaseInfo> recordBaseMap = FilingUtils.getContents(ctx, asInfo.getArchemeContent(), content, org);
                        try {
                            PeriodCollection periods = PeriodUtil.getPeriods(ctx, asInfo, content, org);
                            logger.error((Object)("periods size is:" + periods.size()));
                            for (int k = 0; k < periods.size(); ++k) {
                                PeriodInfo period = periods.get(k);
                                try {
                                    this.handlArchInfos(ctx, asInfo, content, org, period, recordBaseMap);
                                    continue;
                                }
                                catch (Exception e) {
                                    String msg = content.getName() + "\u7684" + org.getNumber() + "\u5355\u636e\u7684" + period.getNumber() + "\u671f\u95f4,\u5f52\u6863\u5931\u8d25\uff01";
                                    logger.error((Object)(msg + "\u7ee7\u7eed\u6267\u884c\u4e0b\u4e00\u671f\u95f4." + e), (Throwable)e);
                                    sbError.append(msg + e + "\t");
                                }
                            }
                            continue;
                        }
                        catch (Exception e) {
                            String msg = content.getName() + "\u7684" + org.getNumber() + "\u5355\u636e,\u5f52\u6863\u5931\u8d25\uff01";
                            logger.error((Object)(msg + "\u7ee7\u7eed\u6267\u884c\u4e0b\u4e00\u7ec4\u7ec7." + e), (Throwable)e);
                            sbError.append(msg + e + "\t");
                        }
                    }
                }
                if (!StringUtils.isEmpty((String)sbError.toString())) {
                    throw new EASBizException(new NumericExceptionSubItem("00", sbError.toString()));
                }
            }
        }
        catch (Exception e) {
            String msg = asInfo.getNumber() + ":\u5f52\u6863\u5931\u8d25!";
            logger.error((Object)(msg + e), (Throwable)e);
        }
        finally {
            ArchUtils.archFlagCache.remove(asInfo.getId().toString());
        }
    }

    private void handlArchInfos(Context ctx, ArchSchemeInfo asInfo, RecordBaseInfo content, CompanyOrgUnitInfo org, PeriodInfo period, Map<String, RecordBaseInfo> recordMap) throws Exception {
        int excued = GenerateRechRecordFacadeFactory.getLocalInstance(ctx).isExcued(content, org, String.valueOf(period.getNumber()), null);
        ArchInfos archInfos = null;
        try {
            if (3 == excued) {
                archInfos = new ArchInfos(ctx, asInfo, content, org, period, recordMap);
                GenerateRechRecordFacadeFactory.getLocalInstance(ctx).genArcRecord(archInfos);
                ArchUtils.setUsing(archInfos.getArcRecordId(), asInfo.getNumber());
                Map<String, IObjectValue> billInfos = ArchUtils.getMainBills(ctx, content, period, org);
                if (null == billInfos) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("state"));
                    sic.add(new SelectorItemInfo("lastUpdateTime"));
                    ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
                    arcRecordInfo.setId(BOSUuid.read((String)archInfos.getArcRecordId()));
                    arcRecordInfo.setState(ArcStateEnum.ARC_NODATA);
                    arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                    ArcRecordFactory.getLocalInstance(ctx).updatePartial(arcRecordInfo, sic);
                    ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(archInfos.getArcRecordId(), ArcStateEnum.ARC_NODATA, "\u6ca1\u6709\u67e5\u8be2\u5230\u6ee1\u8db3\u5f52\u6863\u6761\u4ef6\u7684\u6570\u636e!", null);
                    ArchUtils.releaseMutex(archInfos.getArcRecordId());
                    return;
                }
                archInfos.init(ctx, content, billInfos, period, OperationEnum.FIRST_ARC);
                archInfos.upload();
            } else if (4 == excued) {
                archInfos = this.regetArchInfos(ctx, recordMap, content, org, period);
                this.reArchReportByBill(ctx, archInfos, null);
            } else if (2 == excued) {
                archInfos = new ArchInfos(ctx, null, content, org, period, recordMap);
                this.archFailed(ctx, archInfos);
            } else if (1 == excued) {
                logger.error((Object)(content.getBillType().getNumber() + "\u5355\u636e\u7684" + org.getNumber() + "\u7ec4\u7ec7\u7684" + period.getNumber() + "\u671f\u95f4 \u5df2\u7ecf\u6267\u884c\u6210\u529f,\u65e0\u9700\u91cd\u590d\u6267\u884c\uff01"));
            } else if (0 == excued) {
                archInfos = new ArchInfos(ctx, null, content, org, period, recordMap);
                ArcRecordInfo arcRecrdInfo = ArcRecordFactory.getLocalInstance(ctx).getArcRecordInfo(" where content='" + archInfos.getContent().getId().toString() + "' and org ='" + archInfos.getOrg().getId().toString() + "' and periodNum='" + archInfos.getPeriod() + "'");
                if (!StringUtils.isEmpty((String)ArchUtils.getOwner(arcRecrdInfo.getId().toString()))) {
                    logger.error((Object)(content.getBillType().getNumber() + "\u5355\u636e\u7684" + org.getNumber() + "\u7ec4\u7ec7\u7684" + period.getNumber() + "\u671f\u95f4 \u6b63\u5728\u6267\u884c\u4e2d,\u672c\u6b21\u6267\u884c\u53d6\u6d88\uff01"));
                    return;
                }
                String attach = "UPDATE T_REC_AttachBillAchDetail SET FState = 0 WHERE  FState = 3 and FAchRecordDetailID in(SELECT FID FROM T_REC_AchRecordDetail where FArcRecordID = '" + arcRecrdInfo.getId() + "')";
                String detail = "UPDATE T_REC_AchRecordDetail SET FState = 0 WHERE FState = 3 and FArcRecordID = '" + arcRecrdInfo.getId() + "'";
                DbUtil.execute((Context)ctx, (String)attach);
                DbUtil.execute((Context)ctx, (String)detail);
                this.archFailed(ctx, archInfos);
            } else {
                logger.error((Object)"their is no data ;");
            }
        }
        catch (Exception e) {
            logger.error((Object)(null != archInfos ? archInfos.getArcRecordId() : "null" + e.getMessage()), (Throwable)e);
            ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(null != archInfos ? archInfos.getArcRecordId() : "null", ArcStateEnum.ARC_FAIL, e.getMessage(), RECStringUtil.exception2String(e));
        }
    }

    private ArchInfos regetArchInfos(Context ctx, Map<String, RecordBaseInfo> recordBases, RecordBaseInfo content, CompanyOrgUnitInfo org, PeriodInfo period) throws Exception {
        ArchInfos archInfos = new ArchInfos(ctx, null, content, org, period, recordBases);
        GenerateRechRecordFacadeFactory.getLocalInstance(ctx).genArcRecord(archInfos);
        Map<String, IObjectValue> billInfos = ArchUtils.getMainBills(ctx, content, period, org);
        archInfos.init(ctx, content, billInfos, period, OperationEnum.AFRESH_ARC);
        archInfos.upload();
        if (0 == archInfos.size()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("state"));
            sic.add(new SelectorItemInfo("lastUpdateTime"));
            ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
            arcRecordInfo.setId(BOSUuid.read((String)archInfos.getArcRecordId()));
            arcRecordInfo.setState(ArcStateEnum.ARC_SUCCESS);
            arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            ArcRecordFactory.getLocalInstance(ctx).updatePartial(arcRecordInfo, sic);
            ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(archInfos.getArcRecordId(), ArcStateEnum.ARC_SUCCESS, "\u6ca1\u6709\u9700\u8981\u5f52\u6863\u7684\u5355\u636e\uff01", null);
        }
        return archInfos;
    }

    private RecordBaseInfo setCustomeContent(Context ctx, RecordBaseInfo refContent, CompanyOrgUnitInfo org) throws BOSException {
        RecordBaseExtendCollection recordBaseExtendCollection = RecordBaseExtendFactory.getLocalInstance(ctx).getRecordBaseExtendCollection("where org = '" + org.getId().toString() + "' and recordBaseId ='" + refContent.getId().toString() + "'");
        if (recordBaseExtendCollection.size() > 0) {
            RecordBaseInfo customContent = (RecordBaseInfo)refContent.clone();
            customContent.setPrintTemplate(recordBaseExtendCollection.get(0).getPrintTemplate());
            customContent.setPrintTemplateName(recordBaseExtendCollection.get(0).getPrintTemplateName());
            return customContent;
        }
        return refContent;
    }

    private RecordBaseInfo getCustomeContent(Context ctx, RecordBaseInfo recordBaseInfo, String creatorLongNumber, String archLongNumber) {
        HashSet<String> set = new HashSet<String>();
        set.add(archLongNumber);
        while (archLongNumber.indexOf(creatorLongNumber) > -1 && !creatorLongNumber.equals(archLongNumber) && archLongNumber.lastIndexOf("!") > -1) {
            archLongNumber = archLongNumber.substring(0, archLongNumber.lastIndexOf("!"));
            set.add(archLongNumber);
        }
        set.add(creatorLongNumber);
        String sql = "SELECT T1.FPrintTemplate, T1.FPrintTemplateName, T2.FLONGNUMBER, T2.FLEVEL, T1.FID, T1.FORGID FROM T_REC_RECORDBASEEXTEND  T1 inner join T_ORG_COMPANY T2 on T1.FRecordBaseId = ? and T2.FID = T1.FORGID and T2.FLONGNUMBER IN " + FormatUtils.list2Sql(set) + " order by T2.FLEVEL desc";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{recordBaseInfo.getId().toString()});
            if (executeQuery.next()) {
                RecordBaseInfo recordBaseInfoCutom = (RecordBaseInfo)recordBaseInfo.clone();
                recordBaseInfoCutom.setPrintTemplate(executeQuery.getString(1));
                recordBaseInfoCutom.setPrintTemplateName(executeQuery.getString(2));
                return recordBaseInfoCutom;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u5f52\u6863\u5185\u5bb9\u7684\u5957\u6253\u76ee\u6807\u51fa\u9519", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"\u83b7\u53d6\u5f52\u6863\u5185\u5bb9\u7684\u5957\u6253\u76ee\u6807\u51fa\u9519", (Throwable)e);
        }
        return recordBaseInfo;
    }

    @Override
    protected void _afreshArchRecord(Context ctx, List recordIdList) throws BOSException, EASBizException {
        int i;
        if (recordIdList == null || recordIdList.size() == 0) {
            logger.error((Object)"recordIdList is null");
            throw new EASBizException(new NumericExceptionSubItem("00", "\u8bf7\u9009\u62e9\u9700\u8981\u91cd\u65b0\u5f52\u6863\u7684\u5f52\u6863\u8bb0\u5f55\uff01"));
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("content.*");
        selectorItemCollection.add("content.org.*");
        selectorItemCollection.add("content.billType.*");
        selectorItemCollection.add("org.*");
        selectorItemCollection.add("currency.*");
        selectorItemCollection.add("mergeUnitGroup.*");
        selectorItemCollection.add("*");
        entityViewInfo.setSelector(selectorItemCollection);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(recordIdList), CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        ArcRecordCollection arcRecordInfoList = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(entityViewInfo);
        if (arcRecordInfoList == null || arcRecordInfoList.size() == 0) {
            logger.error((Object)"arcRecordInfoList.size() == 0");
            throw new EASBizException(new NumericExceptionSubItem("00", "\u6ca1\u6709\u67e5\u5230\u9700\u8981\u91cd\u65b0\u5f52\u6863\u7684\u5f52\u6863\u8bb0\u5f55\uff01"));
        }
        ArrayList<ArcRecordInfo> willReportRecordInfos = new ArrayList<ArcRecordInfo>();
        ArrayList<ArcRecordInfo> edReportRecordInfos = new ArrayList<ArcRecordInfo>();
        StringBuilder sbError = new StringBuilder();
        for (i = 0; i < arcRecordInfoList.size(); ++i) {
            if (!ArcContentTypeEnum.BILL.equals((Object)arcRecordInfoList.get(i).getContentType())) continue;
            arcRecordInfoList.get(i).setState(ArcStateEnum.ARC_LOADING);
            ArcRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)arcRecordInfoList.get(i));
            try {
                Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
                ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(arcRecordInfoList.get(i).getPeriodNum() / 100, arcRecordInfoList.get(i).getPeriodNum() % 100, arcRecordInfoList.get(i).getOrg().getAccountPeriodType());
                ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
                ArchSchemeInfo asInfo = this.getArchemeInfo(ctx, arcRecordInfoList.get(i).getArcSchemeId());
                Map<String, RecordBaseInfo> recordBases = FilingUtils.getContents(ctx, asInfo.getArchemeContent(), arcRecordInfoList.get(i).getContent(), arcRecordInfoList.get(i).getOrg());
                RecordBaseInfo info = FilingUtils.getContent(ctx, arcRecordInfoList.get(i).getContent(), arcRecordInfoList.get(i).getOrg());
                ArchInfos archInfos = this.regetArchInfos(ctx, recordBases, info, arcRecordInfoList.get(i).getOrg(), period);
                List<ArcRecordInfo> tmpReportRecordInfos = this.reArchReportByBill(ctx, archInfos, arcRecordInfoList.get(i));
                edReportRecordInfos.addAll(tmpReportRecordInfos);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                logger.error((Object)("\u91cd\u65b0\u5f52\u6863\u5931\u8d25\uff01arcRecordNum\uff1a" + arcRecordInfoList.get(i).getArcRecordNum() + " e.getMessage:" + e.getMessage()));
                sbError.append(arcRecordInfoList.get(i).getArcRecordNum()).append("!");
            }
        }
        for (i = 0; i < arcRecordInfoList.size(); ++i) {
            ArcRecordInfo arcRecordInfo = arcRecordInfoList.get(i);
            if (ArcContentTypeEnum.REPORT.equals((Object)arcRecordInfo.getContentType())) {
                boolean flag = false;
                for (ArcRecordInfo ed : edReportRecordInfos) {
                    if (!arcRecordInfo.getId().toString().equals(ed.getId().toString())) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                willReportRecordInfos.add(arcRecordInfo);
                continue;
            }
            if (ArcContentTypeEnum.RptsReport.equals((Object)arcRecordInfo.getContentType()) || ArcContentTypeEnum.QmsReport.equals((Object)arcRecordInfo.getContentType())) {
                willReportRecordInfos.add(arcRecordInfo);
                continue;
            }
            if (!ArcContentTypeEnum.OtherReport.equals((Object)arcRecordInfo.getContentType())) continue;
            willReportRecordInfos.add(arcRecordInfo);
        }
        List<ArcRecordInfo> fails = this.reArchReport(ctx, willReportRecordInfos);
        for (ArcRecordInfo fail : fails) {
            sbError.append(fail.getArcRecordNum()).append("!");
        }
        if (!StringUtils.isEmpty((String)sbError.toString())) {
            throw new EASBizException(new NumericExceptionSubItem("00", sbError.toString() + "\u5f52\u6863\u5931\u8d25\uff01"));
        }
    }

    private List<ArcRecordInfo> reArchReportByBill(Context ctx, ArchInfos archInfos, ArcRecordInfo arcRecordInfo) {
        List<ArcRecordInfo> arcRecordInfoList = null;
        try {
            if (arcRecordInfo == null) {
                arcRecordInfo = ArcRecordFactory.getLocalInstance(ctx).getArcRecordInfo("select *, currency.*,org.*, content.*, content.billType.*  where id = '" + archInfos.getArcRecordId() + "'");
            }
            ArrayList<ArcRecordInfo> bills = new ArrayList<ArcRecordInfo>();
            bills.add(arcRecordInfo);
            arcRecordInfoList = this.reveBill2Report(ctx, bills, false);
            arcRecordInfoList.remove(arcRecordInfo);
            if (archInfos.size() > 0) {
                this.reArchReport(ctx, arcRecordInfoList);
            } else {
                ArrayList<ArcRecordInfo> canReArchReports = new ArrayList<ArcRecordInfo>();
                for (ArcRecordInfo arcRecordInfo1 : arcRecordInfoList) {
                    if (!arcRecordInfo1.getState().equals((Object)ArcStateEnum.ARC_FAIL) && !arcRecordInfo1.getState().equals((Object)ArcStateEnum.REVERSE_ARC)) continue;
                    canReArchReports.add(arcRecordInfo1);
                }
                this.reArchReport(ctx, canReArchReports);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u5f52\u6863\u62a5\u8868\u5931\u8d25\uff01");
        }
        return arcRecordInfoList;
    }

    private List<ArcRecordInfo> reArchReport(Context ctx, List<ArcRecordInfo> arcRecordInfos) {
        ArrayList<ArcRecordInfo> fails = new ArrayList<ArcRecordInfo>();
        for (ArcRecordInfo arcRecordInfo : arcRecordInfos) {
            try {
                arcRecordInfo.setState(ArcStateEnum.ARC_LOADING);
                ArcRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)arcRecordInfo);
                int periodNumber = arcRecordInfo.getPeriodNum();
                PeriodInfo period = new PeriodInfo();
                period.setNumber(periodNumber);
                period.setPeriodYear(periodNumber / 100);
                period.setPeriodNumber(periodNumber - periodNumber / 100 * 100);
                if (ArcContentTypeEnum.REPORT.equals((Object)arcRecordInfo.getContentType()) || ArcContentTypeEnum.OtherReport.equals((Object)arcRecordInfo.getContentType())) {
                    ReportArchInfos reportArchInfos = new ReportArchInfos(ctx, arcRecordInfo.getReportCycleType(), arcRecordInfo.getContent(), arcRecordInfo.getOrg(), period, arcRecordInfo.getCurrency());
                    reportArchInfos.initReportArchInfos();
                    this.handleReportArchInfos(ctx, reportArchInfos);
                    continue;
                }
                if (!ArcContentTypeEnum.RptsReport.equals((Object)arcRecordInfo.getContentType()) && !ArcContentTypeEnum.QmsReport.equals((Object)arcRecordInfo.getContentType())) continue;
            }
            catch (Exception e) {
                logger.error((Object)("\u91cd\u65b0\u5f52\u6863\u5931\u8d25\uff01arcRecordNum\uff1a" + arcRecordInfo.getArcRecordNum() + " e.getMessage:" + e.getMessage()));
                fails.add(arcRecordInfo);
            }
        }
        return fails;
    }

    @Override
    protected String _reverseArch(Context ctx, String recordIds, Map otherPrams) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)recordIds)) {
            throw new EASBizException(new NumericExceptionSubItem("please choose record !", "\u8bf7\u9009\u62e9\u9700\u8981\u53cd\u5f52\u6863\u7684\u5f52\u6863\u8bb0\u5f55\uff01"));
        }
        String[] recordIdArr = recordIds.split(",");
        ArrayList<ArcRecordInfo> arcRecordInfos = new ArrayList<ArcRecordInfo>();
        for (int i = 0; i < recordIdArr.length; ++i) {
            String recordId = recordIdArr[i];
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("*");
            selectorItemCollection.add("org.*");
            selectorItemCollection.add("currency.*");
            selectorItemCollection.add("org.accountPeriodType.*");
            selectorItemCollection.add("content.*");
            selectorItemCollection.add("content.billType.*");
            ArcRecordInfo arcRecordInfo = ArcRecordFactory.getLocalInstance(ctx).getArcRecordInfo(H.PK(recordId), selectorItemCollection);
            if (arcRecordInfo.getState().getValue() != 2) continue;
            arcRecordInfos.add(arcRecordInfo);
        }
        this.execReverseArch(ctx, arcRecordInfos);
        return String.valueOf(true);
    }

    private boolean execReverseArch(Context ctx, List<ArcRecordInfo> arcRecords) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        List<ArcRecordInfo> arcRecordInfoList = null;
        try {
            arcRecordInfoList = this.reveBill2Report(ctx, arcRecords, true);
            this.requestMutexService(ctx, arcRecordInfoList, mutexService);
            this.noticeBussReverseArch(ctx, arcRecordInfoList);
            String arch_type = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_TYPE);
            NoticeArchSysHelperFactory.getInstance(ctx, arch_type).reverseArch(ctx, arcRecordInfoList, new HashMap<String, String>());
            this.updateRecord(ctx, arcRecordInfoList, ArcStateEnum.REVERSE_ARC);
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("arcRecordInfo is currently in use!", e.getMessage()));
        }
        finally {
            this.releaseMutexService(ctx, arcRecordInfoList, mutexService);
        }
        return true;
    }

    private void releaseMutexService(Context ctx, List<ArcRecordInfo> arcRecordInfos, IMutexServiceControl mutexService) {
        for (int i = 0; i < arcRecordInfos.size(); ++i) {
            try {
                mutexService.releaseObjIDForUpdate(arcRecordInfos.get(i).getId().toString());
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private void requestMutexService(Context ctx, List<ArcRecordInfo> arcRecordInfos, IMutexServiceControl mutexService) throws EASBizException {
        StringBuffer sb = new StringBuffer();
        boolean isNeedThrowError = false;
        for (int i = 0; i < arcRecordInfos.size(); ++i) {
            boolean flag = mutexService.requestObjIDForUpdate(arcRecordInfos.get(i).getId().toString(), ctx.getUserName());
            if (flag) continue;
            sb.append(arcRecordInfos.get(i).getArcRecordNum() + " \u6b63\u5728\u8fdb\u884c\u53cd\u5f52\u6863\uff01");
            isNeedThrowError = true;
        }
        if (isNeedThrowError) {
            throw new EASBizException(new NumericExceptionSubItem("arcRecordInfo is currently in use!", sb.toString()));
        }
    }

    private List<ArcRecordInfo> reveBill2Report(Context ctx, List<ArcRecordInfo> arcRecordInfos, boolean isReverseArch) throws EASBizException, BOSException {
        PeriodInfo periodInfo;
        HashMap<String, ArchPeriodInfo> archPeriodInfoMap = new HashMap<String, ArchPeriodInfo>();
        HashMap<String, PeriodInfo> periodInfoMap = new HashMap<String, PeriodInfo>();
        HashMap<String, ArcRecordInfo> map = new HashMap<String, ArcRecordInfo>();
        HashSet<String> set = new HashSet<String>();
        for (ArcRecordInfo arcRecordInfo : arcRecordInfos) {
            if ("bill" == arcRecordInfo.getContentType().getValue() && arcRecordInfo.getContent().isIsUpdateReport()) {
                ArchPeriodInfo archPeriodInfo = null;
                if (archPeriodInfoMap.containsKey(arcRecordInfo.getPeriodId())) {
                    archPeriodInfo = (ArchPeriodInfo)archPeriodInfoMap.get(arcRecordInfo.getPeriodId());
                } else {
                    archPeriodInfo = ArchPeriodFactory.getLocalInstance(ctx).getArchPeriodInfo(H.PK(arcRecordInfo.getPeriodId()));
                    archPeriodInfoMap.put(archPeriodInfo.getId().toString(), archPeriodInfo);
                }
                String periodInfoMapKey = arcRecordInfo.getOrg().getId().toString() + arcRecordInfo.getPeriodNum();
                periodInfo = null;
                if (periodInfoMap.containsKey(periodInfoMapKey)) {
                    periodInfo = (PeriodInfo)periodInfoMap.get(periodInfoMapKey);
                } else {
                    periodInfo = PeriodUtil.getPeriodInfo(ctx, arcRecordInfo.getOrg(), archPeriodInfo);
                    periodInfoMap.put(periodInfoMapKey, periodInfo);
                }
                set.add(periodInfo.getId().toString());
            }
            map.put(arcRecordInfo.getId().toString(), arcRecordInfo);
        }
        HashSet<Integer> stateSet = new HashSet<Integer>();
        stateSet.add(0);
        stateSet.add(1);
        stateSet.add(2);
        for (String periodId : set) {
            Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(H.PK(periodId));
            ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
            EntityViewInfo evInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("periodStartTime", (Object)periodInfo.getEndDate(), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodEndTime", (Object)periodInfo.getEndDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodStartTime", (Object)periodInfo.getBeginDate(), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodEndTime", (Object)periodInfo.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("contentType", (Object)"report", CompareType.EQUALS));
            if (isReverseArch) {
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("state", stateSet, CompareType.INCLUDE));
            }
            filter.setMaskString("((#0 and #1) or (#2 and #3)) and #4 and #5");
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("*");
            selectorItemCollection.add("content.*");
            selectorItemCollection.add("org.*");
            selectorItemCollection.add("currency.*");
            selectorItemCollection.add("org.accountPeriodType.*");
            selectorItemCollection.add("content.billType.*");
            evInfo.setSelector(selectorItemCollection);
            evInfo.setFilter(filter);
            ArcRecordCollection arcRecordColl = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(evInfo);
            for (int i = 0; i < arcRecordColl.size(); ++i) {
                ArcRecordInfo arcRecordInfo = arcRecordColl.get(i);
                map.put(arcRecordInfo.getId().toString(), arcRecordInfo);
            }
        }
        LinkedList<ArcRecordInfo> linkedList = new LinkedList<ArcRecordInfo>();
        Set idSet = map.keySet();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            linkedList.add((ArcRecordInfo)map.get(it.next()));
        }
        return linkedList;
    }

    private void updateRecord(Context ctx, List<ArcRecordInfo> arcRecordInfos, ArcStateEnum reverseArc) throws EASBizException, BOSException {
        CoreBaseCollection arcRecordColl = new CoreBaseCollection();
        CoreBaseCollection arcSchLogColl = new CoreBaseCollection();
        CoreBaseCollection achRecordDetailColl = new CoreBaseCollection();
        CoreBaseCollection attachBillAchDetailColl = new CoreBaseCollection();
        for (int i = 0; i < arcRecordInfos.size(); ++i) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            ArcRecordInfo arcRecordInfo = arcRecordInfos.get(i);
            arcRecordInfo.setLastUpdateTime(timestamp);
            arcRecordInfo.setLastUpdateUser(userInfo);
            arcRecordInfo.setState(reverseArc);
            arcRecordInfo.setLatelyRevArcUserId(userInfo);
            arcRecordInfo.setLatelyRevArcTime(timestamp);
            arcRecordColl.add((CoreBaseInfo)arcRecordInfo);
            ArcSchLogInfo arcSchLogInfo = new ArcSchLogInfo();
            arcSchLogInfo.setChangeTime(timestamp);
            arcSchLogInfo.setOperatorID(userInfo);
            arcSchLogInfo.setResult(reverseArc);
            arcSchLogInfo.setRecordId(arcRecordInfo);
            arcSchLogColl.add((CoreBaseInfo)arcSchLogInfo);
            if ("bill" != arcRecordInfo.getContentType().getValue()) continue;
            EntityViewInfo entityViewInfoZ = new EntityViewInfo();
            FilterInfo filterZ = new FilterInfo();
            filterZ.getFilterItems().add(new FilterItemInfo("arcRecord", (Object)arcRecordInfo.getId()));
            entityViewInfoZ.setFilter(filterZ);
            AchRecordDetailCollection achRecordDetailCollection = AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailCollection(entityViewInfoZ);
            for (int j = 0; j < achRecordDetailCollection.size(); ++j) {
                AchRecordDetailInfo achRecordDetailInfo = achRecordDetailCollection.get(j);
                achRecordDetailInfo.setState(ArcStateEnum.REVERSE_ARC);
                achRecordDetailColl.add((CoreBaseInfo)achRecordDetailInfo);
                EntityViewInfo entityViewInfoF = new EntityViewInfo();
                FilterInfo filterF = new FilterInfo();
                filterF.getFilterItems().add(new FilterItemInfo("originsBillId", (Object)achRecordDetailInfo.getBillId()));
                entityViewInfoF.setFilter(filterF);
                AttachBillAchDetailCollection attachBillAchDetailCollection = AttachBillAchDetailFactory.getLocalInstance(ctx).getAttachBillAchDetailCollection(entityViewInfoF);
                for (int k = 0; k < attachBillAchDetailCollection.size(); ++k) {
                    AttachBillAchDetailInfo attachBillAchDetailInfo = attachBillAchDetailCollection.get(k);
                    attachBillAchDetailInfo.setState(reverseArc);
                    attachBillAchDetailColl.add((CoreBaseInfo)attachBillAchDetailInfo);
                }
            }
        }
        ArcRecordFactory.getLocalInstance(ctx).save(arcRecordColl);
        ArcSchLogFactory.getLocalInstance(ctx).save(arcSchLogColl);
    }

    private boolean noticeBussReverseArch(Context ctx, List<ArcRecordInfo> arcRecordInfos) throws EASBizException {
        try {
            List<String> recordIdArr = this.getArcRecordInfosIdArray(arcRecordInfos);
            String sqlString = RECStringUtil.convertColl2String(recordIdArr);
            Map<String, List<String>> mapBill = this.conversionRowSet(ctx, this.getSqlRowSet(ctx, this.getBillSQL(sqlString)), true);
            this.noticBill(ctx, mapBill);
            Map<String, List<String>> mapAttachBill = this.conversionRowSet(ctx, this.getSqlRowSet(ctx, this.getAttachBillSQL(sqlString)), true);
            this.noticBill(ctx, mapAttachBill);
            Map<String, List<String>> mapReport = this.conversionRowSet(ctx, this.getSqlRowSet(ctx, this.getReportSQL(sqlString)), false);
            this.noticReport(ctx, mapReport, arcRecordInfos);
            return false;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new EASBizException(new NumericExceptionSubItem("noticeBussReverseArch error!", "\u901a\u77e5\u4e1a\u52a1\u53cd\u5f52\u6863\u5931\u8d25\uff01"));
        }
    }

    private List<String> getArcRecordInfosIdArray(List<ArcRecordInfo> arcRecordInfos) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < arcRecordInfos.size(); ++i) {
            list.add(arcRecordInfos.get(i).getId().toString());
        }
        return list;
    }

    private void noticReport(Context ctx, Map<String, List<String>> mapReport, List<ArcRecordInfo> arcRecordInfos) throws Exception {
        int i;
        HashMap<String, ArcRecordInfo> recordBaseMap = new HashMap<String, ArcRecordInfo>();
        for (i = 0; i < arcRecordInfos.size(); ++i) {
            String bosType;
            ArcRecordInfo arcRecordInfo = arcRecordInfos.get(i);
            if ("bill" == arcRecordInfo.getContentType().getValue() || recordBaseMap.containsKey(bosType = arcRecordInfo.getContent().getBillType().getBosType())) continue;
            recordBaseMap.put(bosType, arcRecordInfo);
        }
        for (i = 0; i < recordBaseMap.size(); ++i) {
            Set bosTypeSet = recordBaseMap.keySet();
            for (String bosType : bosTypeSet) {
                ArcRecordInfo arcRecordInfo = (ArcRecordInfo)recordBaseMap.get(bosType);
                List<String> periodOrgList = mapReport.get(bosType);
                ArrayList<ReportFilter> filterList = new ArrayList<ReportFilter>();
                for (int j = 0; j < periodOrgList.size(); ++j) {
                    String periodOrg = periodOrgList.get(j);
                    String[] periodOrgArr = periodOrg.split(",");
                    String period = periodOrgArr[0];
                    String org = periodOrgArr[1];
                    String reportCycleType = periodOrgArr[2];
                    ReportFilter reportFilter = new ReportFilter();
                    reportFilter.setCurrency(arcRecordInfo.getCurrency());
                    reportFilter.setOrgId(org);
                    reportFilter.setPeriod(period);
                    reportFilter.setReportCycleType(ReportCycleType.getEnum(reportCycleType));
                    reportFilter.setRecordBaseInfo(arcRecordInfo.getContent());
                }
                ReportParsingEngineUtil rpeUtil = (ReportParsingEngineUtil)ParsingEngineUtil.getInstance(ctx, arcRecordInfo.getContent());
                rpeUtil.revokeArch(ctx, filterList);
            }
        }
    }

    private void noticBill(Context ctx, Map<String, List<String>> mapBill) throws EASDBException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Set<String> set = mapBill.keySet();
        for (String bosType : set) {
            List<String> idlist = mapBill.get(bosType);
            String[] checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)bosType, IBillHandler.class);
            if (null == checkers || checkers.length == 0) {
                logger.error((Object)"bosType \u6ca1\u6709\u5b9e\u73b0BillHandler\uff01");
                continue;
            }
            Class<?> cla = Class.forName(checkers[0]);
            IBillHandler billHandle = (IBillHandler)cla.newInstance();
            billHandle.revokeArch(ctx, idlist);
        }
    }

    private String getBillSQL(String arcRecordIds) {
        StringBuffer billSQL = new StringBuffer(500);
        billSQL.append(" SELECT ad.FBillId,bt.FBosType FROM T_REC_AchRecordDetail ad ");
        billSQL.append(" inner join T_REC_ArcRecord ar on ad.FArcRecordID = ar.fid ");
        billSQL.append(" inner join T_REC_RecordBase rb on rb.fid = ar.FContentID ");
        billSQL.append(" inner join T_REC_BillType bt on rb.FBillTypeID = bt.fid ");
        billSQL.append(" where ar.fid in(" + arcRecordIds + ") ");
        return billSQL.toString();
    }

    private String getAttachBillSQL(String arcRecordIds) {
        StringBuffer attachBillSQL = new StringBuffer(500);
        attachBillSQL.append(" SELECT abd.FBillId,bt.FBosType FROM T_REC_AttachBillAchDetail abd ");
        attachBillSQL.append(" inner join T_REC_AchRecordDetail ad on abd.foriginsBillId = ad.fbillId ");
        attachBillSQL.append(" inner join T_REC_ArcRecord ar on ad.FArcRecordID = ar.fid ");
        attachBillSQL.append(" inner join T_REC_RecordBase rb on rb.fid = abd.FArcContentID ");
        attachBillSQL.append(" inner join T_REC_BillType bt on rb.FBillTypeID = bt.fid ");
        attachBillSQL.append(" where ar.fid in(" + arcRecordIds + ") ");
        return attachBillSQL.toString();
    }

    private String getReportSQL(String arcRecordIds) {
        StringBuffer reportSQL = new StringBuffer(500);
        reportSQL.append(" SELECT distinct bt.FBosType,ar.FPeriod,ar.FOrgId,ar.FReportCycleType,ar.FPeriodStartTime,ar.FPeriodEndTime FROM T_REC_ArcRecord ar ");
        reportSQL.append(" inner join T_REC_RecordBase rb on rb.fid = ar.FContentID ");
        reportSQL.append(" inner join T_REC_BillType bt on rb.FBillTypeID = bt.fid ");
        reportSQL.append(" where ar.fid in(" + arcRecordIds + ") ");
        reportSQL.append(" and bt.fbill = 0 ");
        return reportSQL.toString();
    }

    private IRowSet getSqlRowSet(Context ctx, String sql) throws BOSException {
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    private Map<String, List<String>> conversionRowSet(Context ctx, IRowSet rs, boolean isBill) throws SQLException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        while (rs.next()) {
            String bosType = rs.getString("FBosType");
            String billId = "";
            String period = "";
            String OrgId = "";
            String FReportCycleType = "";
            if (isBill) {
                billId = rs.getString("FBillId");
            } else {
                period = rs.getString("FPeriod");
                OrgId = rs.getString("FOrgId");
                FReportCycleType = rs.getString("FReportCycleType");
                billId = period + "," + OrgId + "," + FReportCycleType;
            }
            if (map.containsKey(bosType)) {
                ((List)map.get(bosType)).add(billId);
                continue;
            }
            LinkedList<String> list = new LinkedList<String>();
            list.add(billId);
            map.put(bosType, list);
        }
        return map;
    }

    @Override
    protected boolean _archFinished(Context ctx, String recordId, int num) throws BOSException, EASBizException {
        ArcRecordInfo info = ArcRecordFactory.getLocalInstance(ctx).getArcRecordInfo((IObjectPK)new ObjectUuidPK(recordId));
        int totalNum = info.getTotalNum() - num;
        if (totalNum <= 0) {
            totalNum = 0;
        }
        info.setTotalNum(totalNum);
        ArcRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        return totalNum == 0;
    }

    @Override
    protected void _archFailed(Context ctx, List recordInfoList) throws BOSException, EASBizException {
        if (recordInfoList == null || recordInfoList.size() == 0) {
            logger.error((Object)"recordIdList is null");
            throw new EASBizException(new NumericExceptionSubItem("00", "\u8bf7\u9009\u62e9\u9700\u8981\u5f52\u6863\u7684\u5f52\u6863\u8bb0\u5f55\uff01"));
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("content.*");
        selectorItemCollection.add("content.org.*");
        selectorItemCollection.add("content.billType.*");
        selectorItemCollection.add("org.*");
        selectorItemCollection.add("currency.*");
        selectorItemCollection.add("*");
        entityViewInfo.setSelector(selectorItemCollection);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", recordInfoList.get(0)));
        entityViewInfo.setFilter(filterInfo);
        ArcRecordCollection arcRecordInfoList = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(entityViewInfo);
        if (arcRecordInfoList == null || arcRecordInfoList.size() == 0) {
            logger.error((Object)"arcRecordInfoList.size() == 0");
            throw new EASBizException(new NumericExceptionSubItem("00", "\u8bf7\u9009\u62e9\u9700\u8981\u5f52\u6863\u7684\u5f52\u6863\u8bb0\u5f55\uff01"));
        }
        ArcRecordInfo arcRecordInfo = arcRecordInfoList.get(0);
        if (arcRecordInfo.getContentType().getValue().equals("bill")) {
            ArchSchemeInfo asInfo = this.getArchemeInfo(ctx, arcRecordInfo.getArcSchemeId());
            Map<String, RecordBaseInfo> recordBases = FilingUtils.getContents(ctx, asInfo.getArchemeContent(), arcRecordInfo.getContent(), arcRecordInfo.getOrg());
            Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(arcRecordInfo.getPeriodNum() / 100, arcRecordInfo.getPeriodNum() % 100, arcRecordInfo.getOrg().getAccountPeriodType());
            ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
            RecordBaseInfo info = FilingUtils.getContent(ctx, arcRecordInfo.getContent(), arcRecordInfo.getOrg());
            ArchInfos archInfos = new ArchInfos(ctx, null, info, arcRecordInfo.getOrg(), period, recordBases);
            this.archFailed(ctx, archInfos);
        } else if (arcRecordInfo.getContentType().getValue().equals("report") || arcRecordInfo.getContentType().getValue().equals("otherReport")) {
            Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(arcRecordInfo.getPeriodNum() / 100, arcRecordInfo.getPeriodNum() % 100, arcRecordInfo.getOrg().getAccountPeriodType());
            ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
            ReportArchInfos reportArchInfos = new ReportArchInfos(ctx, arcRecordInfo.getReportCycleType(), arcRecordInfo.getContent(), arcRecordInfo.getOrg(), periodInfo, arcRecordInfo.getCurrency());
            try {
                reportArchInfos.initReportArchInfos();
                String arcRecordNum = FilingUtils.getReportArcRecordNum(ctx, reportArchInfos.getContent(), reportArchInfos.getOrg().getNumber(), periodInfo.getNumber() + "", reportArchInfos.getCurrencyInfo().getIsoCode(), reportArchInfos.getReportCycleType().getValue());
                if (reportArchInfos.getReportArchInfos() != null && reportArchInfos.getReportArchInfos().size() > 0) {
                    ArchUtils.setUsing(reportArchInfos.getReportArchInfos().get(0).getId(), arcRecordNum);
                }
                this.handleReportArchInfos(ctx, reportArchInfos);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        } else if (arcRecordInfo.getContentType().getValue().equals("rptsReport") || arcRecordInfo.getContentType().getValue().equals("qmsReport")) {
            logger.error((Object)"\u5408\u5e76\u62a5\u8868\u6682\u4e0d\u652f\u6301 \u5931\u8d25\u518d\u5f52\u6863");
        }
    }

    private void changeOrginStateFail2Loading(Context ctx, String recordId) {
        logger.error((Object)("\u5931\u8d25\u518d\u5f52\u6863--\u9644\u5c5e\u5355\u636e\u72b6\u6001\u4e3a\u5931\u8d25\u7684\u6539\u4e3a\u5f52\u6863\u4e2d\uff1arecordId[" + recordId + "]"));
        if (StringUtils.isEmpty((String)recordId)) {
            return;
        }
        String detail = "UPDATE T_REC_AchRecordDetail SET FOriginBillState = 3 WHERE FOriginBillState = 0 and FArcRecordID = '" + recordId + "'";
        try {
            DbUtil.execute((Context)ctx, (String)detail);
        }
        catch (Exception e) {
            logger.error((Object)"\u5931\u8d25\u518d\u5f52\u6863--\u9644\u5c5e\u5355\u636e\u72b6\u6001\u4e3a\u5931\u8d25\u7684\u6539\u4e3a\u5f52\u6863\u4e2d", (Throwable)e);
        }
    }

    private void archFailed(Context ctx, ArchInfos archInfos) throws BOSException, EASBizException {
        GenerateRechRecordFacadeFactory.getLocalInstance(ctx).genArcRecord(archInfos);
        this.changeOrginStateFail2Loading(ctx, archInfos.getArcRecordId());
        ArchUtils.setUsing(archInfos.getArcRecordId(), "archFailed");
        archInfos.arcFailed(ctx, archInfos.getArcRecordId());
        if (0 == archInfos.size()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("state"));
            sic.add(new SelectorItemInfo("lastUpdateTime"));
            ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
            arcRecordInfo.setId(BOSUuid.read((String)archInfos.getArcRecordId()));
            arcRecordInfo.setState(ArcStateEnum.ARC_SUCCESS);
            arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            ArcRecordFactory.getLocalInstance(ctx).updatePartial(arcRecordInfo, sic);
            ArchUtils.releaseMutex(archInfos.getArcRecordId());
        }
    }

    @Override
    protected void _execSchemeCurrent(Context ctx, String schemeId, Map propertMap) throws BOSException, EASBizException {
        logger.error((Object)("RecLicenseUtil--class--md5:" + MD5.md5crypt(RecLicenseUtil.class.toString())));
        RecUpgradeFacadeFactory.getLocalInstance(ctx).upgradeRecordBase();
        try {
            RecUpgradeFacadeFactory.getLocalInstance(ctx).upgradeOutputXMLTemplate(null);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        ArchSchemeInfo asInfo = this.getArchemeInfo(ctx, schemeId);
        if (null != propertMap) {
            Set set = propertMap.entrySet();
            for (Map.Entry entry : set) {
                String key = entry.getKey() + "";
                Object value = entry.getValue();
                asInfo.put(key, value);
            }
            String schemeOrg = (String)propertMap.get("schemeOrg");
            if (!StringUtils.isEmpty((String)schemeOrg)) {
                String[] split = schemeOrg.split(",");
                CompanyOrgUnitCollection collection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection("select *, baseCurrency.* where id in " + FormatUtils.str2Sql(split));
                ArchSchemeScopeOrgEntryCollection archSchemeScopeOrgEntryCollection = new ArchSchemeScopeOrgEntryCollection();
                for (int i = 0; i < collection.size(); ++i) {
                    ArchSchemeScopeOrgEntryInfo assorgInfo = new ArchSchemeScopeOrgEntryInfo();
                    assorgInfo.setContainSub(false);
                    assorgInfo.setOrg(collection.get(i));
                    archSchemeScopeOrgEntryCollection.add(assorgInfo);
                }
                asInfo.put("schemeOrg", (Object)archSchemeScopeOrgEntryCollection);
            }
        }
        ArchSchemeScopeOrgEntryCollection orgs = asInfo.getSchemeOrg();
        ArcheSchemeContentEntryCollection contents = asInfo.getArchemeContent();
        try {
            FilingInstanceFactory.getFilingInstance(asInfo.getRecType()).execute(ctx, asInfo, contents, orgs);
        }
        catch (EASBizException e) {
            logger.error((Object)(asInfo.getNumber() + " \u5f52\u6863\u65b9\u6848\u6267\u884c\u53d1\u751f\u9519\u8bef\uff01"), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)(asInfo.getNumber() + " \u5f52\u6863\u65b9\u6848\u6267\u884c\u53d1\u751f\u9519\u8bef\uff01"), (Throwable)e);
            throw new BOSException("\u672a\u77e5\u5f02\u5e38", (Throwable)e);
        }
    }
}

