/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.wssc.util.SafeFilterUtils;
import com.kingdee.eas.el.rec.ArcLogInfo;
import com.kingdee.eas.el.rec.ArcRecordCollection;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcSchLogInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.InterfaceLogInfo;
import com.kingdee.eas.el.rec.app.AbstractArchSysLogServiceFacadeControllerBean;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.tool.RecLogUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class ArchSysLogServiceFacadeControllerBean
extends AbstractArchSysLogServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.app.ArchSysLogServiceFacadeControllerBean");
    private int days = 90;
    private int batchsize = 500;

    @Override
    protected void _writeArcSchLog(Context ctx, String arcRecordId, ArcStateEnum state, String message, String stack) throws BOSException {
        if (StringUtils.isEmpty((String)arcRecordId)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)arcRecordId));
        view.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("creator.id");
        selectorItemCollection.add("lastUpdateUser.id");
        selectorItemCollection.add("id");
        view.setSelector(selectorItemCollection);
        view.setBaseOnSelector(true);
        ArcRecordCollection arcRecordCollection = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(view);
        if (arcRecordCollection.size() > 0) {
            ArcRecordInfo arcRecordInfo = arcRecordCollection.get(0);
            ArcSchLogInfo arcSchLogInfo = new ArcSchLogInfo();
            arcSchLogInfo.setResult(state);
            arcSchLogInfo.setRecordId(arcRecordInfo);
            arcSchLogInfo.setCreator(arcRecordInfo.getCreator());
            arcSchLogInfo.setLastUpdateUser(arcRecordInfo.getLastUpdateUser());
            arcSchLogInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            arcSchLogInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            if (!StringUtils.isEmpty((String)message)) {
                if (message.length() > 1000) {
                    message = message.substring(0, 1000);
                }
                arcSchLogInfo.setMessage(message);
            }
            if (!StringUtils.isEmpty((String)stack)) {
                if (stack.length() > 4000) {
                    stack = stack.substring(0, 4000);
                }
                arcSchLogInfo.setStack(stack);
            }
            RecLogUtils.executeLogRecord(ctx, (CoreBaseInfo)arcSchLogInfo);
        }
    }

    @Override
    protected void _writeArcLog(Context ctx, ArchInfo archInfo, ArcStateEnum state, String message, String stack) throws BOSException {
        if (archInfo == null) {
            return;
        }
        ArcLogInfo arcloginfo = new ArcLogInfo();
        arcloginfo.setResult(state);
        if (!StringUtils.isEmpty((String)message)) {
            if (message.length() > 1000) {
                message = message.substring(0, 1000);
            }
            arcloginfo.setMessage(message);
        }
        if (!StringUtils.isEmpty((String)stack)) {
            if (stack.length() > 4000) {
                stack = stack.substring(0, 4000);
            }
            arcloginfo.setStack(stack);
        }
        arcloginfo.setBillRefid(archInfo.getId());
        arcloginfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        arcloginfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        arcloginfo.setBillId(archInfo.getBillId());
        arcloginfo.setBillNumber(archInfo.getBillNumber());
        RecLogUtils.executeLogRecord(ctx, (CoreBaseInfo)arcloginfo);
    }

    @Override
    protected void _writeInterfaceLog(Context ctx, String address, String api, String param, boolean success, String result, String stack) throws BOSException {
        InterfaceLogInfo interfaceLogInfo = new InterfaceLogInfo();
        interfaceLogInfo.setAddress(address);
        interfaceLogInfo.setApi(api);
        if (!StringUtils.isEmpty((String)param)) {
            if (param.length() > 4000) {
                param = param.substring(0, 4000);
            }
            interfaceLogInfo.setParam(param);
        }
        interfaceLogInfo.setSuccess(success);
        if (!StringUtils.isEmpty((String)result)) {
            if (result.length() > 1000) {
                result = result.substring(0, 1000);
            }
            interfaceLogInfo.setResult(result);
        }
        if (!StringUtils.isEmpty((String)stack)) {
            if (stack.length() > 4000) {
                stack = stack.substring(0, 4000);
            }
            interfaceLogInfo.setStack(stack);
        }
        interfaceLogInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        interfaceLogInfo.setCreatorID(ctx.getCaller().toString());
        RecLogUtils.executeLogRecord(ctx, interfaceLogInfo);
    }

    @Override
    protected void _dumpArcSchLog(Context ctx) throws BOSException {
        String clearDirtyLogSql = "DELETE FROM T_REC_ArcSchLogHis WHERE exists (select 1 from T_REC_ArcSchLog asl where asl.fid = fid)";
        String getLogIDsSql = "SELECT FID FROM T_REC_ArcSchLog WHERE DATEDIFF(Day,FCreateTime,GETDATE()) > " + this.days;
        String insertSql = "INSERT INTO T_REC_ArcSchLogHis SELECT * FROM T_REC_ArcSchLog WHERE FID IN ";
        String deleteSql = "DELETE FROM T_REC_ArcSchLog WHERE FID IN ";
        this.dumpData(ctx, clearDirtyLogSql, getLogIDsSql, insertSql, deleteSql);
    }

    @Override
    protected void _dumpArcLog(Context ctx) throws BOSException {
        String clearDirtyLogSql = "DELETE FROM T_REC_ArcLogHis WHERE exists (select 1 from T_REC_ArcLog al where al.fid = fid)";
        String getLogIDsSql = "SELECT FID FROM T_REC_ArcLog WHERE DATEDIFF(Day,FCreateTime,GETDATE()) > " + this.days;
        String insertSql = "INSERT INTO T_REC_ArcLogHis SELECT * FROM T_REC_ArcLog WHERE FID IN ";
        String deleteSql = "DELETE FROM T_REC_ArcLog WHERE FID IN ";
        this.dumpData(ctx, clearDirtyLogSql, getLogIDsSql, insertSql, deleteSql);
    }

    @Override
    protected void _dumpInterfaceLog(Context ctx) throws BOSException {
        String clearDirtyLogSql = "DELETE FROM T_REC_InterfaceLogHis WHERE exists (select 1 from T_REC_InterfaceLog al where al.fid = fid)";
        String getLogIDsSql = "SELECT FID FROM T_REC_InterfaceLog WHERE DATEDIFF(Day,FCreateTime,GETDATE()) > " + this.days;
        String insertSql = "INSERT INTO T_REC_InterfaceLogHis SELECT * FROM T_REC_InterfaceLog WHERE FID IN ";
        String deleteSql = "DELETE FROM T_REC_InterfaceLog WHERE FID IN ";
        this.dumpData(ctx, clearDirtyLogSql, getLogIDsSql, insertSql, deleteSql);
    }

    private void dumpData(Context ctx, String clearDirtyLogSql, String getLogIDsSql, String insertSql, String deleteSql) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            this.clearDirtyLogDataBatch(cn, clearDirtyLogSql);
            String dumpLogIDs = this.getLogIDs(cn, getLogIDsSql);
            if (StringUtils.isEmpty((String)dumpLogIDs)) {
                logger.info((Object)"Finish dump log, total 0 records.");
                return;
            }
            String tmpIDs = dumpLogIDs.substring(1, dumpLogIDs.length() - 1);
            String[] tmpIDsArr = tmpIDs.split(",");
            if (tmpIDsArr.length > this.batchsize) {
                int i = 0;
                while (i * this.batchsize < tmpIDsArr.length) {
                    StringBuffer tmpDumpIDs = new StringBuffer("(");
                    for (int j = 0; j < this.batchsize && i * this.batchsize + j < tmpIDsArr.length; ++j) {
                        tmpDumpIDs.append(tmpIDsArr[i * this.batchsize + j]).append(",");
                    }
                    String tmpIds = tmpDumpIDs.substring(0, tmpDumpIDs.length() - 1) + ")";
                    insertSql = insertSql + tmpIds;
                    deleteSql = deleteSql + tmpIds;
                    this.transferWLogDataBatch(cn, insertSql, deleteSql);
                    ++i;
                }
            } else {
                insertSql = insertSql + dumpLogIDs;
                deleteSql = deleteSql + dumpLogIDs;
                this.transferWLogDataBatch(cn, insertSql, deleteSql);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDirtyLogDataBatch(Connection cn, String sql) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = cn.prepareStatement(sql);
            ps.execute();
        }
        finally {
            SafeFilterUtils.safeClose((PreparedStatement)ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLogIDs(Connection cn, String tSql) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        String fids;
        block6: {
            fids = "";
            StringBuffer sLogIDs = new StringBuffer();
            ps = null;
            rs = null;
            try {
                ps = cn.prepareStatement(tSql);
                rs = ps.executeQuery();
                while (rs.next()) {
                    String fId = rs.getString(1);
                    if (sLogIDs.length() > 0) {
                        sLogIDs.append("','");
                    }
                    sLogIDs.append(fId);
                }
                if (sLogIDs.length() <= 0) break block6;
                StringBuffer buffer = new StringBuffer();
                buffer.append("('");
                buffer.append(sLogIDs);
                buffer.append("')");
                fids = buffer.toString();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"query getlogIDs error -------");
                }
                catch (Throwable throwable) {
                    SafeFilterUtils.safeClose((PreparedStatement)ps);
                    SafeFilterUtils.safeClose(rs);
                    throw throwable;
                }
                SafeFilterUtils.safeClose((PreparedStatement)ps);
                SafeFilterUtils.safeClose((ResultSet)rs);
            }
        }
        SafeFilterUtils.safeClose((PreparedStatement)ps);
        SafeFilterUtils.safeClose((ResultSet)rs);
        return fids;
    }

    private void transferWLogDataBatch(Connection cn, String insertSql, String deleteSql) throws SQLException {
    }
}

