/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.el.rec.AchRecordDetailCollection;
import com.kingdee.eas.el.rec.AchRecordDetailFactory;
import com.kingdee.eas.el.rec.AchRecordDetailInfo;
import com.kingdee.eas.el.rec.ArcContentTypeEnum;
import com.kingdee.eas.el.rec.ArcLogInfo;
import com.kingdee.eas.el.rec.ArcRecordCollection;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcSchLogInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.ArchPeriodFactory;
import com.kingdee.eas.el.rec.ArchPeriodInfo;
import com.kingdee.eas.el.rec.AttachBillAchDetailCollection;
import com.kingdee.eas.el.rec.AttachBillAchDetailFactory;
import com.kingdee.eas.el.rec.AttachBillAchDetailInfo;
import com.kingdee.eas.el.rec.GenerateRechRecordFacadeFactory;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.ReportCycleType;
import com.kingdee.eas.el.rec.app.AbstractGenerateRechRecordFacadeControllerBean;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.model.ArchInfos;
import com.kingdee.eas.el.rec.model.AttachBillInfo;
import com.kingdee.eas.el.rec.model.MainBillInfo;
import com.kingdee.eas.el.rec.model.RecordInfo;
import com.kingdee.eas.el.rec.model.ReportArchInfo;
import com.kingdee.eas.el.rec.model.ReportArchInfos;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.tool.ArchUtils;
import com.kingdee.eas.el.rec.tool.FormatUtils;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.IBillHandler;
import com.kingdee.eas.el.rec.tool.RECStringUtil;
import com.kingdee.eas.el.rec.tool.RecLogUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GenerateRechRecordFacadeControllerBean
extends AbstractGenerateRechRecordFacadeControllerBean {
    private static final long serialVersionUID = 6294402529458847481L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.app.GenerateRechRecordFacadeControllerBean");
    private Map<String, String> interfaceCacheMap = new HashMap<String, String>();
    private Map<String, String> periodCacheMap = new HashMap<String, String>();
    private static String DUMP_ARCRECORDDETAIL_SQL = "INSERT INTO T_REC_AchRecordDetailDel(FBillId,FBillNumber,FState,FRecordBaseInstID,FArcRecordID,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID)  SELECT FBillId,FBillNumber,FState,FRecordBaseInstID,FArcRecordID,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID FROM T_REC_AchRecordDetail WHERE FID = ?";
    private static String DELETE_ARCRECORDDETAIL_SQL = "DELETE FROM T_REC_AchRecordDetail WHERE FID = ?";
    private static String DUMP_ATTACHBILLACHDETAIL_SQL = "INSERT INTO T_REC_AttachBillAchDetailDel( FBillId,FBillNumber,FState,FOriginsBillId,FArcContentID,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FAchRecordDetailID,FID)  SELECT FBillId,FBillNumber,FState,FOriginsBillId,FArcContentID,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FAchRecordDetailID,FID FROM T_REC_AttachBillAchDetail WHERE FID = ?";
    private static String DELETE_ATTACHBILLACHDETAIL_SQL = "DELETE FROM T_REC_AttachBillAchDetail WHERE FID = ?";

    @Override
    protected RecordInfo _getArcFailInfos(Context ctx, ArchInfos archInfos) throws BOSException, EASBizException {
        RecordInfo failedRecordInfo = new RecordInfo();
        MainBillInfo mainBillInfo = new MainBillInfo();
        AttachBillInfo attachBillInfo = new AttachBillInfo();
        String oql = "where org ='" + archInfos.getOrg().getId().toString() + "' and content='" + archInfos.getContent().getId().toString() + "' and periodId='" + archInfos.getContent().getId().toString() + "' and state=0";
        ArcRecordCollection arcRecordcols = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(oql);
        if (arcRecordcols.size() > 0) {
            String recordId = arcRecordcols.get(0).getId().toString();
            AchRecordDetailCollection arcRecordDetailcols = AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailCollection("where arcRecord = '" + recordId + "' and state =0");
            for (int i = 0; i < arcRecordDetailcols.size(); ++i) {
                Timestamp lastUpdateTime;
                String oribillId = arcRecordDetailcols.get(i).getBillId();
                String billNumber = arcRecordDetailcols.get(i).getBillNumber();
                Timestamp _lastUpdateTime = arcRecordDetailcols.get(i).getLastUpdateTime();
                ObjectUuidPK uuidPK = new ObjectUuidPK(oribillId);
                IObjectValue iov = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(uuidPK.getObjectType(), (IObjectPK)uuidPK);
                if (iov != null && _lastUpdateTime.before(lastUpdateTime = (Timestamp)iov.get("lastUpdateTime"))) {
                    mainBillInfo.setOwnBillId(oribillId);
                    mainBillInfo.setOwnBillNum(billNumber);
                }
                AttachBillAchDetailCollection attachBillCol = AttachBillAchDetailFactory.getLocalInstance(ctx).getAttachBillAchDetailCollection("where originsBillId ='" + oribillId + "' and state=0");
                for (int j = 0; j < attachBillCol.size(); ++j) {
                    String attachBill = attachBillCol.get(j).getBillId();
                    ObjectUuidPK attachBilluuidPK = new ObjectUuidPK(attachBill);
                    IObjectValue _iov = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(uuidPK.getObjectType(), (IObjectPK)attachBilluuidPK);
                    Timestamp attachlastUpdateTime = (Timestamp)_iov.get("lastUpdateTime");
                    Timestamp _attachlastUpdateTime = attachBillCol.get(i).getLastUpdateTime();
                    if (!_attachlastUpdateTime.before(attachlastUpdateTime)) continue;
                    attachBillInfo.setBillId(attachBill);
                    attachBillInfo.setOriBillId(oribillId);
                }
            }
            ArrayList<MainBillInfo> mainBillList = new ArrayList<MainBillInfo>();
            mainBillList.add(mainBillInfo);
            ArrayList<AttachBillInfo> attachBillList = new ArrayList<AttachBillInfo>();
            attachBillList.add(attachBillInfo);
            failedRecordInfo.setAttachBillInfo(attachBillList);
            failedRecordInfo.setMainBillInfo(mainBillList);
        }
        return failedRecordInfo;
    }

    @Override
    protected int _isExcued(Context ctx, RecordBaseInfo content, CompanyOrgUnitInfo org, String periodNumber, ReportCycleType reportCycleType) throws BOSException, EASBizException {
        String contentId = "";
        String orgId = "";
        if (content != null) {
            contentId = content.getId().toString();
        }
        if (org != null) {
            orgId = org.getId().toString();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("content", (Object)contentId));
        filter.getFilterItems().add(new FilterItemInfo("org", (Object)orgId));
        filter.getFilterItems().add(new FilterItemInfo("periodNum", (Object)periodNumber));
        if (reportCycleType != null) {
            filter.getFilterItems().add(new FilterItemInfo("reportCycleType", (Object)reportCycleType.getValue()));
        }
        view.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("id");
        selectorItemCollection.add("state");
        view.setSelector(selectorItemCollection);
        ArcRecordCollection cols = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(view);
        if (null == cols || cols.size() == 0) {
            return 3;
        }
        ArcRecordInfo info = cols.get(0);
        if (ArcStateEnum.ARC_FAIL.equals((Object)info.getState())) {
            return 2;
        }
        if (ArcStateEnum.REVERSE_ARC.equals((Object)info.getState())) {
            return 4;
        }
        if (ArcStateEnum.ARC_SUCCESS.equals((Object)info.getState())) {
            return 1;
        }
        if (ArcStateEnum.ARC_NODATA.equals((Object)info.getState())) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void _genArcRecord(Context ctx, ArchInfos archInfos) throws BOSException, EASBizException {
        ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
        String periodNumber = archInfos.getPeriod() + "";
        ArcRecordCollection arcCols = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(" where content='" + archInfos.getContent().getId().toString() + "' and org ='" + archInfos.getOrg().getId().toString() + "' and periodNum='" + periodNumber + "'");
        if (arcCols.size() > 0) {
            arcRecordInfo = arcCols.get(0);
            arcRecordInfo.setState(ArcStateEnum.ARC_LOADING);
            arcRecordInfo.setFailNum(0);
        } else {
            String arcRecordNum = archInfos.getContent().getBillType().getNumber() + "_" + archInfos.getOrg().getNumber() + "_" + periodNumber;
            arcRecordInfo.setArcRecordNum(arcRecordNum);
            if (null != archInfos.getAsInfo()) {
                arcRecordInfo.setArcSchemeId(archInfos.getAsInfo().getId().toString());
            }
            arcRecordInfo.setPeriodStartTime(new Timestamp(archInfos.getPeriodInfo().getBeginDate().getTime()));
            arcRecordInfo.setPeriodEndTime(new Timestamp(archInfos.getPeriodInfo().getEndDate().getTime()));
            arcRecordInfo.setContent(archInfos.getContent());
            arcRecordInfo.setPeriodNum(archInfos.getPeriod());
            if (this.periodCacheMap == null || this.periodCacheMap.get(periodNumber) == null) {
                String periodId = this.genPeriod(ctx, periodNumber);
                arcRecordInfo.setPeriodId(periodId);
                this.periodCacheMap.put(periodNumber, periodId);
            } else {
                arcRecordInfo.setPeriodId(this.periodCacheMap.get(periodNumber));
            }
            arcRecordInfo.setContentType(archInfos.getArcContentType());
            arcRecordInfo.setOrg(archInfos.getOrg());
            arcRecordInfo.setState(ArcStateEnum.ARC_LOADING);
            BOSUuid id = BOSUuid.create((BOSObjectType)arcRecordInfo.getBOSType());
            arcRecordInfo.setId(id);
        }
        try {
            ArcRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)arcRecordInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)("\u4fdd\u5b58/\u66f4\u65b0\u5355\u636e+\u7ec4\u7ec7+\u671f\u95f4" + arcRecordInfo.getArcRecordNum() + "\u5f52\u6863\u8bb0\u5f55\u5931\u8d25!" + (Object)((Object)e)));
            throw e;
        }
        archInfos.setArcRecordId(arcRecordInfo.getId().toString());
    }

    @Override
    protected Set _updateBillAndReportRecordDetail(Context ctx, String arcRecordId, List Ids, Map param) throws BOSException, EASBizException {
        String stack;
        FilterInfo filterInfo;
        SelectorItemCollection selectorItemCollection;
        EntityViewInfo entityViewInfo;
        HashSet<String> billRecordSet = new HashSet<String>();
        HashMap<String, Map> achRecordDetails = new HashMap<String, Map>();
        HashMap<String, Map> attachBillAchDetails = new HashMap<String, Map>();
        HashMap<String, Map> arcRecords = new HashMap<String, Map>();
        CoreBaseCollection arcLogCollection = new CoreBaseCollection();
        CoreBaseCollection arcSchLogCollection = new CoreBaseCollection();
        for (Object obj : Ids) {
            Map tmpMap;
            String id;
            if (!(obj instanceof Map) || (id = (String)(tmpMap = (Map)obj).get("id")) == null || "".equals(id.trim()) || "null".equals(id.trim())) continue;
            ObjectUuidPK uuidPK = new ObjectUuidPK(id);
            String bosType = uuidPK.getObjectType().toString();
            if ("14CFB21B".equals(bosType)) {
                achRecordDetails.put(id, tmpMap);
                continue;
            }
            if ("B9B44ADE".equals(bosType)) {
                attachBillAchDetails.put(id, tmpMap);
                continue;
            }
            if (!"6B892DF6".equals(bosType)) continue;
            arcRecords.put(id, tmpMap);
        }
        if (achRecordDetails.size() > 0) {
            SelectorItemCollection selectorItemCollection2 = new SelectorItemCollection();
            selectorItemCollection2.add("id");
            selectorItemCollection2.add("state");
            selectorItemCollection2.add("arcRecord.id");
            selectorItemCollection2.add("lastUpdateUser.id");
            selectorItemCollection2.add("creator.id");
            selectorItemCollection2.add("billId");
            selectorItemCollection2.add("billNumber");
            FilterItemCollection filterItem = new FilterItemCollection();
            filterItem.add(new FilterItemInfo("id", achRecordDetails.keySet(), CompareType.INCLUDE));
            AchRecordDetailCollection achRecordDetailColl = ArchUtils.getAchRecordDetailCollectionLimit(ctx, selectorItemCollection2, filterItem, "where a.FArcRecordID in " + FormatUtils.list2Sql(achRecordDetails.keySet()) + "  ");
            CoreBaseCollection coreBaseColl = new CoreBaseCollection();
            for (int i = 0; i < achRecordDetailColl.size(); ++i) {
                AchRecordDetailInfo achRecordDetailInfo = achRecordDetailColl.get(i);
                billRecordSet.add(achRecordDetailInfo.getArcRecord().getId().toString());
                Map result = (Map)achRecordDetails.get(achRecordDetailInfo.getId().toString());
                String id = (String)result.get("id");
                String state = (String)result.get("return");
                int arcState = "1".equals(state) ? 2 : 0;
                String message = (String)result.get("desc");
                String stack2 = (String)result.get("stack");
                UserInfo lastUpdateUser = achRecordDetailInfo.getLastUpdateUser();
                UserInfo creator = achRecordDetailInfo.getCreator();
                String billId = achRecordDetailInfo.getBillId();
                String billNumber = achRecordDetailInfo.getBillNumber();
                ArcLogInfo arcloginfo = new ArcLogInfo();
                arcloginfo.setResult(ArcStateEnum.getEnum(arcState));
                if (ArcStateEnum.ARC_LOADING.equals((Object)achRecordDetailInfo.getState()) || ArcStateEnum.ARC_2BE_DELETED.equals((Object)achRecordDetailInfo.getState())) {
                    achRecordDetailInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                    if (ArcStateEnum.ARC_LOADING.equals((Object)achRecordDetailInfo.getState())) {
                        if (arcState == 2) {
                            achRecordDetailInfo.setState(ArcStateEnum.ARC_SUCCESS);
                            arcloginfo.setResult(ArcStateEnum.ARC_SUCCESS);
                            this.noticeArchSuccess(ctx, achRecordDetailInfo.getBillId());
                        } else if (arcState == 0) {
                            achRecordDetailInfo.setState(ArcStateEnum.ARC_FAIL);
                            arcloginfo.setResult(ArcStateEnum.ARC_FAIL);
                            stack2 = (String)result.get("stack");
                            arcloginfo.setStack(stack2);
                        }
                        coreBaseColl.add((CoreBaseInfo)achRecordDetailInfo);
                    } else if (arcState == 2) {
                        arcloginfo.setResult(ArcStateEnum.ARC_SUCCESS);
                    } else if (arcState == 0) {
                        achRecordDetailInfo.setState(ArcStateEnum.ARC_2BE_DELETED);
                        arcloginfo.setResult(ArcStateEnum.ARC_FAIL);
                        coreBaseColl.add((CoreBaseInfo)achRecordDetailInfo);
                    }
                    if (arcState == 0) {
                        // empty if block
                    }
                }
                arcloginfo.setMessage(message);
                arcloginfo.setStack(stack2);
                arcloginfo.setBillRefid(id);
                arcloginfo.setLastUpdateUser(lastUpdateUser);
                arcloginfo.setCreator(creator);
                arcloginfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                arcloginfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                arcloginfo.setBillId(billId);
                arcloginfo.setBillNumber(billNumber);
                arcLogCollection.add((CoreBaseInfo)arcloginfo);
            }
            try {
                AchRecordDetailFactory.getLocalInstance(ctx).updateBatchPartial(coreBaseColl, selectorItemCollection2);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        if (attachBillAchDetails.size() > 0) {
            entityViewInfo = new EntityViewInfo();
            selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("id");
            selectorItemCollection.add("state");
            selectorItemCollection.add("achRecordDetail.arcRecord.id");
            selectorItemCollection.add("lastUpdateUser.id");
            selectorItemCollection.add("creator.id");
            selectorItemCollection.add("billId");
            selectorItemCollection.add("billNumber");
            entityViewInfo.setSelector(selectorItemCollection);
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", attachBillAchDetails.keySet(), CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            AttachBillAchDetailCollection attachBillAchDetailColl = AttachBillAchDetailFactory.getLocalInstance(ctx).getAttachBillAchDetailCollection(entityViewInfo);
            CoreBaseCollection coreBaseColl = new CoreBaseCollection();
            for (int i = 0; i < attachBillAchDetailColl.size(); ++i) {
                AttachBillAchDetailInfo attachBillAchDetailInfo = attachBillAchDetailColl.get(i);
                billRecordSet.add(attachBillAchDetailInfo.getAchRecordDetail().getArcRecord().getId().toString());
                ArcLogInfo arcloginfo = new ArcLogInfo();
                Map result = (Map)attachBillAchDetails.get(attachBillAchDetailInfo.getId().toString());
                String id = (String)result.get("id");
                String state = (String)result.get("return");
                int arcState = "1".equals(state) ? 2 : 0;
                String message = (String)result.get("desc");
                stack = (String)result.get("stack");
                arcloginfo.setResult(ArcStateEnum.getEnum(arcState));
                UserInfo lastUpdateUser = attachBillAchDetailInfo.getLastUpdateUser();
                UserInfo creator = attachBillAchDetailInfo.getCreator();
                String billId = attachBillAchDetailInfo.getBillId();
                String billNumber = attachBillAchDetailInfo.getBillNumber();
                if (ArcStateEnum.ARC_LOADING.equals((Object)attachBillAchDetailInfo.getState()) || ArcStateEnum.ARC_2BE_DELETED.equals((Object)attachBillAchDetailInfo.getState())) {
                    attachBillAchDetailInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                    if (ArcStateEnum.ARC_LOADING.equals((Object)attachBillAchDetailInfo.getState())) {
                        if (arcState == 2) {
                            attachBillAchDetailInfo.setState(ArcStateEnum.ARC_SUCCESS);
                            arcloginfo.setResult(ArcStateEnum.ARC_SUCCESS);
                            this.noticeArchSuccess(ctx, attachBillAchDetailInfo.getBillId());
                        } else if (arcState == 0) {
                            attachBillAchDetailInfo.setState(ArcStateEnum.ARC_FAIL);
                            arcloginfo.setResult(ArcStateEnum.ARC_FAIL);
                            arcloginfo.setStack(stack);
                        }
                        coreBaseColl.add((CoreBaseInfo)attachBillAchDetailInfo);
                    } else if (arcState == 2) {
                        arcloginfo.setResult(ArcStateEnum.ARC_SUCCESS);
                    } else if (arcState == 0) {
                        attachBillAchDetailInfo.setState(ArcStateEnum.ARC_2BE_DELETED);
                        arcloginfo.setResult(ArcStateEnum.ARC_FAIL);
                        coreBaseColl.add((CoreBaseInfo)attachBillAchDetailInfo);
                    }
                    if (arcState == 0) {
                        // empty if block
                    }
                    if (arcState == 0) {
                        this.changeOrginBillFail(ctx, attachBillAchDetailInfo.getAchRecordDetail().getId());
                    }
                }
                arcloginfo.setMessage(message);
                arcloginfo.setStack(stack);
                arcloginfo.setBillRefid(id);
                arcloginfo.setLastUpdateUser(lastUpdateUser);
                arcloginfo.setCreator(creator);
                arcloginfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                arcloginfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                arcloginfo.setBillId(billId);
                arcloginfo.setBillNumber(billNumber);
                arcLogCollection.add((CoreBaseInfo)arcloginfo);
            }
            try {
                AttachBillAchDetailFactory.getLocalInstance(ctx).updateBatchPartial(coreBaseColl, selectorItemCollection);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        if (arcLogCollection.size() > 0) {
            RecLogUtils.executeLogRecord(ctx, arcLogCollection);
        }
        if (arcRecords.size() > 0) {
            entityViewInfo = new EntityViewInfo();
            selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("id");
            selectorItemCollection.add("state");
            selectorItemCollection.add("lastUpdateTime");
            selectorItemCollection.add("creator.id");
            entityViewInfo.setSelector(selectorItemCollection);
            entityViewInfo.setBaseOnSelector(true);
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", arcRecords.keySet(), CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            ArcRecordCollection arcRecordColl = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(entityViewInfo);
            CoreBaseCollection coreBaseColl = new CoreBaseCollection();
            for (int i = 0; i < arcRecordColl.size(); ++i) {
                ArcRecordInfo arcRecordInfo = arcRecordColl.get(i);
                if (!ArcStateEnum.ARC_LOADING.equals((Object)arcRecordInfo.getState())) continue;
                Map result = (Map)arcRecords.get(arcRecordInfo.getId().toString());
                String id = (String)result.get("id");
                String state = (String)result.get("return");
                int arcState = "1".equals(state) ? 2 : 0;
                String message = (String)result.get("desc");
                ArcSchLogInfo arcSchLogInfo = new ArcSchLogInfo();
                if (arcState == 2) {
                    arcRecordInfo.setState(ArcStateEnum.ARC_SUCCESS);
                    arcSchLogInfo.setResult(ArcStateEnum.ARC_SUCCESS);
                } else if (arcState == 0) {
                    arcRecordInfo.setState(ArcStateEnum.ARC_FAIL);
                    arcSchLogInfo.setResult(ArcStateEnum.ARC_FAIL);
                    stack = (String)result.get("stack");
                    arcSchLogInfo.setStack(stack);
                }
                arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                arcSchLogInfo.setMessage(message);
                arcSchLogInfo.setLastUpdateUser(arcRecordInfo.getLastUpdateUser());
                arcSchLogInfo.setCreator(arcRecordInfo.getCreator());
                arcSchLogInfo.setRecordId(arcRecordInfo);
                arcSchLogInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                arcSchLogInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                arcSchLogCollection.add((CoreBaseInfo)arcSchLogInfo);
                coreBaseColl.add((CoreBaseInfo)arcRecordInfo);
            }
            try {
                ArcRecordFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)coreBaseColl, selectorItemCollection);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            if (arcSchLogCollection.size() > 0) {
                RecLogUtils.executeLogRecord(ctx, arcSchLogCollection);
            }
        }
        return billRecordSet;
    }

    private void changeOrginBillFail(Context ctx, BOSUuid achRecordDetailId) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("originBillState"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        AchRecordDetailInfo achRecordDetailInfo = new AchRecordDetailInfo();
        achRecordDetailInfo.setId(achRecordDetailId);
        achRecordDetailInfo.setOriginBillState(ArcStateEnum.ARC_FAIL);
        achRecordDetailInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        try {
            AchRecordDetailFactory.getLocalInstance(ctx).updatePartial(achRecordDetailInfo, sic);
        }
        catch (Exception e) {
            logger.error((Object)"\u66f4\u65b0\u4e3b\u5355\u7684\u9644\u5c5e\u5355\u636e\u72b6\u6001\u9519\u8bef", (Throwable)e);
        }
    }

    private void changeOrginBillState(Context ctx, String recordId) {
        String detail = "UPDATE T_REC_AchRecordDetail SET FOriginBillState = 2 WHERE FOriginBillState = 3 and FArcRecordID = '" + recordId + "'";
        try {
            DbUtil.execute((Context)ctx, (String)detail);
        }
        catch (Exception e) {
            logger.error((Object)"\u5f52\u6863\u5b8c\u6210\u540e\u5c06\u5f52\u6863\u4e2d\u5904\u7406\u4e3a\u5f52\u6863\u6210\u529f\u9519\u8bef", (Throwable)e);
        }
    }

    private void noticeArchSuccess(Context ctx, String billId) {
        try {
            if (StringUtils.isEmpty((String)billId) || !BOSUuid.isValid((String)billId, (boolean)true)) {
                logger.error((Object)("noticeArchSuccess billid is null or isNotValid:billId" + billId));
                return;
            }
            ObjectUuidPK uuidPK = new ObjectUuidPK(billId);
            String bosType = uuidPK.getObjectType().toString();
            ArrayList<String> billIds = new ArrayList<String>();
            billIds.add(billId);
            String interfaceName = this.interfaceCacheMap.get("bosType");
            if (interfaceName != null && !"".equals(interfaceName)) {
                Class<?> cla = Class.forName(interfaceName);
                IBillHandler billHandle = (IBillHandler)cla.newInstance();
                billHandle.archSuccess(ctx, billIds);
            } else {
                String[] checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)bosType, IBillHandler.class);
                if (null == checkers || checkers.length == 0) {
                    logger.error((Object)("\u6ca1\u6709\u5b9e\u73b0'" + bosType + "'\u7684BillHandler\uff01"));
                } else {
                    this.interfaceCacheMap.put(bosType, checkers[0]);
                    Class<?> cla = Class.forName(checkers[0]);
                    IBillHandler billHandle = (IBillHandler)cla.newInstance();
                    billHandle.archSuccess(ctx, billIds);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"<<<<<---->>>>>", (Throwable)e);
        }
    }

    @Override
    protected void _updateBillArcRecord(Context ctx, Set Ids, Map param) throws BOSException, EASBizException {
        block21: {
            try {
                String loddingRecordSql = "SELECT ar.FID recordid FROM T_REC_ARCRECORD ar LEFT JOIN T_REC_ACHRECORDDETAIL ard on ar.FID = ard.FArcRecordID LEFT JOIN T_REC_ATTACHBILLACHDETAIL aba on ard.FID = aba.FAchRecordDetailID WHERE (ar.FSTATE <> 3 OR ard.FSTATE = 3 OR ard.FSTATE = 4 OR aba.FSTATE = 3 OR aba.FSTATE = 4) AND ar.FID IN (" + RECStringUtil.convertColl2String(Ids) + ") GROUP BY ar.FID";
                IRowSet loddingRecord = DbUtil.executeQuery((Context)ctx, (String)loddingRecordSql);
                while (loddingRecord.next()) {
                    String recordId = loddingRecord.getString("recordid");
                    Ids.remove(recordId);
                }
                if (Ids.size() <= 0) break block21;
                HashMap<String, ArcStateEnum> canUpdateMap = new HashMap<String, ArcStateEnum>();
                String resultRecordSql = "SELECT ar.FID recordid, count(ard.FID) detailsize, sum(ard.FSTATE) detailsum, count(aba.FID) attachsize, sum(aba.FSTATE) attachsum FROM T_REC_ARCRECORD ar LEFT JOIN T_REC_ACHRECORDDETAIL ard on ar.FID = ard.FArcRecordID LEFT JOIN T_REC_ATTACHBILLACHDETAIL aba on ard.FID = aba.FAchRecordDetailID WHERE ar.FID IN (" + RECStringUtil.convertColl2String(Ids) + ") GROUP BY ar.FID";
                IRowSet resultRecord = DbUtil.executeQuery((Context)ctx, (String)resultRecordSql);
                while (resultRecord.next()) {
                    try {
                        String recordId = resultRecord.getString("recordid");
                        int detailsize = resultRecord.getInt("detailsize");
                        int attachsize = resultRecord.getInt("attachsize");
                        String detailsumStr = resultRecord.getString("detailsum");
                        if (StringUtils.isEmpty((String)detailsumStr)) {
                            logger.error((Object)("****recordid****: " + recordId + " \u672a\u67e5\u5230\u4e3b\u5355\u636e\u5f52\u6863\u8bb0\u5f55"));
                            continue;
                        }
                        int detailsum = Integer.parseInt(detailsumStr);
                        if (detailsum >= 0 && detailsum < 2 * detailsize) {
                            canUpdateMap.put(recordId, ArcStateEnum.ARC_FAIL);
                            continue;
                        }
                        if (detailsum != 2 * detailsize) continue;
                        String attachsumStr = resultRecord.getString("attachsum");
                        if (StringUtils.isEmpty((String)attachsumStr)) {
                            canUpdateMap.put(recordId, ArcStateEnum.ARC_SUCCESS);
                            continue;
                        }
                        int attachsum = Integer.parseInt(attachsumStr);
                        if (attachsum >= 0 && attachsum < 2 * attachsize) {
                            canUpdateMap.put(recordId, ArcStateEnum.ARC_FAIL);
                            this.changeOrginBillState(ctx, recordId);
                            continue;
                        }
                        if (attachsum != 2 * attachsize) continue;
                        canUpdateMap.put(recordId, ArcStateEnum.ARC_SUCCESS);
                        this.changeOrginBillState(ctx, recordId);
                    }
                    catch (Exception e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
                ArrayList<String> arcRecordFailedId = new ArrayList<String>();
                if (canUpdateMap.size() <= 0) break block21;
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add("id");
                selectorItemCollection.add("state");
                selectorItemCollection.add("arcNum");
                selectorItemCollection.add("creator.id");
                selectorItemCollection.add("lastUpdateUser.id");
                selectorItemCollection.add("contentType");
                entityViewInfo.setSelector(selectorItemCollection);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", canUpdateMap.keySet(), CompareType.INCLUDE));
                entityViewInfo.setFilter(filterInfo);
                ArcRecordCollection arcRecordColl = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(entityViewInfo);
                CoreBaseCollection canUpdateColl = new CoreBaseCollection();
                CoreBaseCollection arcSchLogColl = new CoreBaseCollection();
                for (int i = 0; i < arcRecordColl.size(); ++i) {
                    ArcRecordInfo arcRecordInfo = arcRecordColl.get(i);
                    ArcStateEnum stateEnum = (ArcStateEnum)((Object)canUpdateMap.get(arcRecordInfo.getId().toString()));
                    arcRecordInfo.setState(stateEnum);
                    arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                    if (ArcStateEnum.ARC_SUCCESS.equals((Object)stateEnum) && ArcContentTypeEnum.BILL.equals((Object)arcRecordInfo.getContentType())) {
                        arcRecordInfo.setFailNum(0);
                        arcRecordInfo.setAttachFailNum(0);
                    }
                    canUpdateColl.add((CoreBaseInfo)arcRecordInfo);
                    ArcSchLogInfo arcSchLogInfo = new ArcSchLogInfo();
                    arcSchLogInfo.setResult(stateEnum);
                    if (ArcStateEnum.ARC_SUCCESS.equals((Object)stateEnum)) {
                        arcSchLogInfo.setMessage("\u5f52\u6863\u6210\u529f\uff01");
                    } else if (ArcStateEnum.ARC_FAIL.equals((Object)stateEnum)) {
                        if (ArcContentTypeEnum.BILL.equals((Object)arcRecordInfo.getContentType())) {
                            arcSchLogInfo.setMessage("\u5355\u636e\u5f52\u6863\u5931\u8d25\uff0c\u8bf7\u5728\u5f52\u6863\u660e\u7ec6\u4e2d\u67e5\u770b\uff01");
                        } else if (null != param) {
                            arcSchLogInfo.setMessage((String)param.get("desc"));
                            arcSchLogInfo.setStack((String)param.get("stack"));
                        } else {
                            arcSchLogInfo.setMessage("\u6863\u6848\u7cfb\u7edf\u8fd4\u56de\u7684\u5f02\u5e38");
                        }
                        arcRecordFailedId.add(arcRecordInfo.getId().toString());
                    }
                    arcSchLogInfo.setRecordId(arcRecordInfo);
                    arcSchLogInfo.setCreator(arcRecordInfo.getCreator());
                    arcSchLogInfo.setLastUpdateUser(arcRecordInfo.getLastUpdateUser());
                    arcSchLogInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    arcSchLogInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                    arcSchLogColl.add((CoreBaseInfo)arcSchLogInfo);
                    String updateSql = "UPDATE T_REC_AchRecordDetail T1 SET FOriginBillState = 2  WHERE T1.FArcRecordID = '" + arcRecordInfo.getId() + "' and T1.FOriginBillState = 3 and not exists (SELECT 1 FROM T_REC_AttachBillAchDetail T2 where T1.Fid = T2.FAchRecordDetailID and T2.FState = 3)";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                }
                try {
                    ArcRecordFactory.getLocalInstance(ctx).updateBatchData(canUpdateColl);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                RecLogUtils.executeLogRecord(ctx, arcSchLogColl);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    @Override
    protected boolean _dumpDeleteBillRecord(Context ctx, String arcRecordId, String billRecordId, boolean isMain) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billRecordId)) {
            if (isMain) {
                GenerateRechRecordFacadeFactory.getLocalInstance(ctx).updateVoucherNum(arcRecordId, 1);
                DbUtil.execute((Context)ctx, (String)DUMP_ARCRECORDDETAIL_SQL, (Object[])new Object[]{billRecordId});
                DbUtil.execute((Context)ctx, (String)DELETE_ARCRECORDDETAIL_SQL, (Object[])new Object[]{billRecordId});
            } else {
                GenerateRechRecordFacadeFactory.getLocalInstance(ctx).updateOriginVcNum(arcRecordId, 1);
                DbUtil.execute((Context)ctx, (String)DUMP_ATTACHBILLACHDETAIL_SQL, (Object[])new Object[]{billRecordId});
                DbUtil.execute((Context)ctx, (String)DELETE_ATTACHBILLACHDETAIL_SQL, (Object[])new Object[]{billRecordId});
            }
            return true;
        }
        return false;
    }

    @Override
    protected void _genReportArchRecord(Context ctx, ReportArchInfos reportArchInfos) throws BOSException, EASBizException {
        ArcRecordInfo arcRecordInfo;
        String periodNum = reportArchInfos.getPeriodInfo().getNumber() + "";
        String oql = " where content = '" + reportArchInfos.getContent().getId().toString() + "' and org = '" + reportArchInfos.getOrg().getId().toString() + "' and periodNum = '" + periodNum + "' and reportCycleType = '" + reportArchInfos.getReportCycleType().getValue() + "' and currency = '" + reportArchInfos.getCurrencyInfo().getId().toString() + "'";
        ArcRecordCollection arcCols = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(oql);
        CoreBaseCollection coreColl = new CoreBaseCollection();
        if (arcCols.size() == 0) {
            if (StringUtils.isEmpty((String)reportArchInfos.getCurrencyInfo().getNumber())) {
                CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo(H.PK(reportArchInfos.getCurrencyInfo().getId().toString()));
                reportArchInfos.setCurrencyInfo(currencyInfo);
            }
            arcRecordInfo = new ArcRecordInfo();
            String arcRecordNum = FilingUtils.getReportArcRecordNum(ctx, reportArchInfos.getContent(), reportArchInfos.getOrg().getNumber(), periodNum, reportArchInfos.getCurrencyInfo().getIsoCode(), reportArchInfos.getReportCycleType().getValue());
            arcRecordInfo.setArcRecordNum(arcRecordNum);
            arcRecordInfo.setReportCycleType(reportArchInfos.getReportCycleType());
            arcRecordInfo.setContent(reportArchInfos.getContent());
            arcRecordInfo.setPeriodNum(reportArchInfos.getPeriodInfo().getNumber());
            arcRecordInfo.setCurrency(reportArchInfos.getCurrencyInfo());
            Date date = reportArchInfos.getPeriodInfo().getBeginDate();
            arcRecordInfo.setPeriodStartTime(new Timestamp(date.getTime()));
            date = reportArchInfos.getPeriodInfo().getEndDate();
            arcRecordInfo.setPeriodEndTime(new Timestamp(date.getTime()));
            if (this.periodCacheMap == null || this.periodCacheMap.get(periodNum) == null) {
                String periodId = this.genPeriod(ctx, periodNum);
                arcRecordInfo.setPeriodId(periodId);
                this.periodCacheMap.put(periodNum, periodId);
            } else {
                arcRecordInfo.setPeriodId(this.periodCacheMap.get(periodNum));
            }
            arcRecordInfo.setContentType(reportArchInfos.getArcContentType());
            arcRecordInfo.setOrg(reportArchInfos.getOrg());
            if (null == reportArchInfos.getReportArchInfos() || reportArchInfos.getReportArchInfos().size() == 0 || null == reportArchInfos.getReportArchInfos().get(0).getData()) {
                arcRecordInfo.setState(ArcStateEnum.ARC_NODATA);
            } else {
                arcRecordInfo.setState(ArcStateEnum.ARC_LOADING);
            }
            BOSUuid id = BOSUuid.create((BOSObjectType)arcRecordInfo.getBOSType());
            arcRecordInfo.setId(id);
            List<XmlBase> reportArchInfoList = reportArchInfos.getReportArchInfos();
            for (int i = 0; i < reportArchInfoList.size(); ++i) {
                ReportArchInfo reportArchInfo = (ReportArchInfo)reportArchInfoList.get(i);
                AchRecordDetailInfo detailInfo = new AchRecordDetailInfo();
                detailInfo.setArcRecord(arcRecordInfo);
                detailInfo.setState(arcRecordInfo.getState());
                BOSUuid bosIdDetail = BOSUuid.create((BOSObjectType)detailInfo.getBOSType());
                String detailId = bosIdDetail.toString();
                detailInfo.setId(bosIdDetail);
                reportArchInfo.setRecordId(id.toString());
                reportArchInfo.setId(detailId);
                coreColl.add((CoreBaseInfo)detailInfo);
            }
        } else {
            arcRecordInfo = arcCols.get(0);
            arcRecordInfo.setState(ArcStateEnum.ARC_LOADING);
            try {
                String delSQL = "DELETE FROM T_REC_AchRecordDetail WHERE FArcRecordID='" + arcRecordInfo.getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)delSQL);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
            List<XmlBase> reportArchInfoList = reportArchInfos.getReportArchInfos();
            for (int i = 0; i < reportArchInfoList.size(); ++i) {
                if (reportArchInfoList.get(i) == null) continue;
                ReportArchInfo reportArchInfo = (ReportArchInfo)reportArchInfoList.get(i);
                AchRecordDetailInfo detailInfo = new AchRecordDetailInfo();
                detailInfo.setArcRecord(arcRecordInfo);
                detailInfo.setState(arcRecordInfo.getState());
                BOSUuid bosIdDetail = BOSUuid.create((BOSObjectType)detailInfo.getBOSType());
                String detailId = bosIdDetail.toString();
                detailInfo.setId(bosIdDetail);
                reportArchInfo.setRecordId(arcRecordInfo.getId().toString());
                reportArchInfo.setId(detailId);
                coreColl.add((CoreBaseInfo)detailInfo);
            }
        }
        try {
            ArcRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)arcRecordInfo);
            AchRecordDetailFactory.getLocalInstance(ctx).save(coreColl);
        }
        catch (EASBizException e) {
            logger.error((Object)"EASBizException \u8bb0\u5f55\u5f52\u6863\u6982\u8981\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"BOSException \u8bb0\u5f55\u5f52\u6863\u6982\u8981\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    protected String genPeriod(Context ctx, String periodNumber) {
        String periodId = "";
        try {
            ArchPeriodInfo info = new ArchPeriodInfo();
            info = ArchPeriodFactory.getLocalInstance(ctx).getArchPeriodCollection("where number='" + periodNumber + "'").get(0);
            if (info != null) {
                periodId = info.getId().toString();
            } else {
                info = new ArchPeriodInfo();
                BOSUuid id = BOSUuid.create((String)"6DAD4F64");
                info.setId(id);
                info.setPeriodYear(Integer.parseInt(periodNumber.substring(0, 4)));
                info.setPeriod(Integer.parseInt(periodNumber.substring(4, 6)));
                info.setNumber(periodNumber);
                info.setName(periodNumber);
                ArchPeriodFactory.getLocalInstance(ctx).addnew(info);
                periodId = id.toString();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("periodNumber:" + periodNumber), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return periodId;
    }

    @Override
    protected void _updateRecordFailNum(Context ctx, String recordId, int num, boolean isMainBill) throws BOSException, EASBizException {
        String sql = "";
        sql = isMainBill ? "update T_REC_ARCRECORD set FLastUpdateTime = now(), FTotalNum = FTotalNum - " + num + ",FailNum = FailNum + " + num + " where FailNum >0 and FId = '" + recordId + "'" : "update T_REC_ARCRECORD set FLastUpdateTime = now(), FTotalNum = FTotalNum - " + num + ", FAttachFailNum = FAttachFailNum + " + num + " where FailNum >0 and FId = '" + recordId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _updateRcordState(Context ctx, String recordId, ArcStateEnum state) throws BOSException, EASBizException {
        String sql = "update T_REC_ARCRECORD set FLastUpdateTime = now(), FState = " + state.getValue() + " where FId = '" + recordId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _updateOriginVcNum(Context ctx, String recordId, int num) throws BOSException, EASBizException {
        String sql = "update T_REC_ARCRECORD set FLastUpdateTime = now(), FTotalNum = FTotalNum - " + num + ", FOriginVCNum = FOriginVCNum - " + num + " where FId = '" + recordId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _updateVoucherNum(Context ctx, String recordId, int num) throws BOSException, EASBizException {
        String sql = "update T_REC_ARCRECORD set FLastUpdateTime = now(), FTotalNum = FTotalNum - " + num + ", FVoucherNum = FVoucherNum - " + num + " where FId = '" + recordId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }
}

