/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.ArcRecordCollection;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.ArchPeriodCollection;
import com.kingdee.eas.el.rec.ArchPeriodFactory;
import com.kingdee.eas.el.rec.ArchSysLogServiceFacadeFactory;
import com.kingdee.eas.el.rec.FilingInstanceFacadeFactory;
import com.kingdee.eas.el.rec.JobCollection;
import com.kingdee.eas.el.rec.JobFactory;
import com.kingdee.eas.el.rec.JobInfo;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.TaskStateEnum;
import com.kingdee.eas.el.rec.app.AbstractJobControllerBean;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelperFactory;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.LockDataUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class JobControllerBean
extends AbstractJobControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.app.JobControllerBean");
    public static AtomicBoolean runingFlg = new AtomicBoolean(false);

    @Override
    protected IObjectValue _getOldestTask(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public void _executeJob(Context context) throws BOSException, EASBizException {
        final Context ctx = (Context)FilingUtils.deeplyCopy((Serializable)context);
        if (runingFlg.get() || !runingFlg.compareAndSet(false, true)) {
            return;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String arch_type = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_TYPE);
                    NoticeArchSysHelperFactory.getInstance(ctx, arch_type).checkService(ctx);
                    String archTime = LockDataUtils.getTimeStr(3);
                    StringBuilder sqlBuilder = new StringBuilder("update t_rec_job set Fstate = '").append("wating").append("' ");
                    sqlBuilder.append("where  Fstate = '").append("running").append("' and FLastUpdateTime < ").append(archTime);
                    DbUtil.execute((Context)ctx, (String)sqlBuilder.toString());
                    LockDataUtils.releaseExpiredLock(ctx);
                    if (ArchConstant.ARCH_SYS_TYPE_INVO.equals(arch_type)) {
                        JobControllerBean.this.updateTaskFlag(ctx);
                    }
                    JobControllerBean.this.whileDoRuningRecord(ctx);
                    String day180 = LockDataUtils.getTimeStr(4320);
                    DbUtil.execute((Context)ctx, (String)("delete from t_rec_interfacelog where fcreatetime < " + day180));
                    Thread.sleep(2000L);
                    JobControllerBean.this.whileDoJob(ctx, TaskStateEnum.WATING);
                    JobControllerBean.this.dumpData(ctx);
                }
                catch (Exception e) {
                    logger.error((Object)("com.kingdee.eas.el.rec.filing.error._executeJob,ctx.hashCode:" + ctx.hashCode() + ",ctx info:" + ctx.toString()), (Throwable)e);
                }
                finally {
                    runingFlg.set(false);
                }
            }
        }).start();
    }

    private void dumpData(final Context ctx) {
        try {
            String latestHisPeriod = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_DATADUMP_PERIOD);
            final String startDumpDataPeriod = this.getDumpDataPeriod(ctx, latestHisPeriod);
            if (StringUtils.isEmpty((String)startDumpDataPeriod)) {
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String dumpDataPeriod = startDumpDataPeriod;
                        do {
                            ArcRecordFactory.getLocalInstance(ctx).dumpData(dumpDataPeriod);
                        } while (!StringUtils.isEmpty((String)(dumpDataPeriod = JobControllerBean.this.getDumpDataPeriod(ctx, dumpDataPeriod))));
                    }
                    catch (Exception e) {
                        logger.error((Object)"com.kingdee.eas.el.rec.filing.error.dumpData.thread", (Throwable)e);
                    }
                }
            }).start();
        }
        catch (Exception e) {
            logger.error((Object)"com.kingdee.eas.el.rec.filing.error.dumpData", (Throwable)e);
        }
    }

    private String getDumpDataPeriod(Context ctx, String latestHisPeriod) throws BOSException {
        String datadumpThreshold = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_DATADUMP_THRESHOLD);
        if (StringUtils.isEmpty((String)datadumpThreshold)) {
            return "";
        }
        int datadumpThresholdIn = Integer.parseInt(datadumpThreshold);
        StringBuilder selectSql = new StringBuilder("select number ");
        if (!StringUtils.isEmpty((String)latestHisPeriod)) {
            int latestHisPeriodIn = Integer.parseInt(latestHisPeriod);
            selectSql.append("where periodYear >= " + latestHisPeriodIn / 100 + " and period >= " + latestHisPeriodIn % 100 + " ");
        }
        selectSql.append("order by periodYear asc,period asc");
        ArchPeriodCollection archPeriodCollection = ArchPeriodFactory.getLocalInstance(ctx).getArchPeriodCollection(selectSql.toString());
        if (StringUtils.isEmpty((String)latestHisPeriod) && archPeriodCollection.size() > datadumpThresholdIn) {
            return archPeriodCollection.get(0).getNumber();
        }
        if (!StringUtils.isEmpty((String)latestHisPeriod) && archPeriodCollection.size() > datadumpThresholdIn + 1) {
            return archPeriodCollection.get(1).getNumber();
        }
        return "";
    }

    private void updateTaskFlag(Context ctx) throws Exception {
        String creatTaskFlag = LockDataUtils.getTimeStr(72);
        ArcRecordCollection loadingArcRecordCollection = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection("select id, contentType where state = 3 and lastUpdateTime < " + creatTaskFlag);
        for (int i = 0; i < loadingArcRecordCollection.size(); ++i) {
            ArcRecordInfo arcRecordInfo = loadingArcRecordCollection.get(i);
            boolean exists = ArcRecordFactory.getLocalInstance(ctx).exists("where id = '" + arcRecordInfo.getId() + "' and state = " + 3 + " and lastUpdateTime < " + creatTaskFlag);
            if (!exists) continue;
            FilingUtils.updateRecordPartial(ctx, arcRecordInfo, new String[0]);
            StringBuilder sqlBuilder = new StringBuilder("update t_rec_job set FState = ? where  FState = ? and FRecordID = ?");
            DbUtil.execute((Context)ctx, (String)sqlBuilder.toString(), (Object[])new Object[]{"running", "wating", arcRecordInfo.getId().toString()});
            FilingInstanceFacadeFactory.getLocalInstance(ctx).getFilingInstance(loadingArcRecordCollection.get(i)).fullReArch(ctx, loadingArcRecordCollection.get(i).getId().toString());
        }
    }

    private void whileDoRuningRecord(Context ctx) throws EASBizException, BOSException {
        String recordId = this.getRecordId(ctx, ArcStateEnum.ARC_LOADING);
        while (!StringUtils.isEmpty((String)recordId)) {
            ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
            arcRecordInfo.setId(BOSUuid.read((String)recordId));
            try {
                FilingInstanceFacadeFactory.getLocalInstance(ctx).getFilingInstance(arcRecordInfo).processFinalStateTx(ctx, recordId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            recordId = this.getRecordId(ctx, ArcStateEnum.ARC_LOADING);
        }
    }

    private String getRecordId(Context ctx, ArcStateEnum state) throws BOSException, EASBizException {
        String archTime = LockDataUtils.getTimeStr(48);
        StringBuilder sqlBuilder = new StringBuilder("select top 1 Fid id from T_REC_ArcRecord where FContentType = 'bill' and ");
        sqlBuilder.append("FState = '").append(state.getValue()).append("' and FLastUpdateTime < ").append(archTime).append(" order by FLastUpdateTime asc");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
            if (rs.next()) {
                return rs.getString("id");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected void _deleteByRecorId(Context ctx, String recordId) throws BOSException, EASBizException {
        JobCollection jobCollection = this.getJobCollection(ctx, "select id where record = '" + recordId + "'");
        for (int i = 0; i < jobCollection.size(); ++i) {
            JobInfo jobInfo = jobCollection.get(i);
            boolean b = LockDataUtils.hasLock(ctx, jobInfo.getId().toString());
            if (b) {
                throw new RecException(RecException.UNKNOWN, new Object[]{"\u8fd8\u6709\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\uff1a" + jobInfo.getId().toString()});
            }
            this.delete(ctx, jobInfo.getId().toString());
        }
    }

    @Override
    protected void _updatePartial(Context ctx, JobInfo jobInfo, String[] property) throws BOSException, EASBizException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        String lastUpdateTimePro = "lastUpdateTime";
        for (int i = 0; i < property.length; ++i) {
            if (lastUpdateTimePro.equals(property[i])) continue;
            selectorItemCollection.add(property[i]);
        }
        jobInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        selectorItemCollection.add(lastUpdateTimePro);
        JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, selectorItemCollection);
    }

    private void whileDoJob(Context ctx, TaskStateEnum taskStateEnum) throws BOSException, EASBizException {
        JobInfo preProcessJobInfo = null;
        JobInfo oldestTask = this.getOldestTask(ctx, taskStateEnum, null);
        while (null != oldestTask) {
            this.handleJob(ctx, preProcessJobInfo, oldestTask);
            preProcessJobInfo = oldestTask;
            if (null != (oldestTask = this.getOldestTask(ctx, taskStateEnum, oldestTask))) continue;
            oldestTask = this.getOldestTask(ctx, taskStateEnum, null);
        }
    }

    private void handleJob(Context ctx, JobInfo preProcessJobInfo, JobInfo jobInfo) {
        boolean successLocked = LockDataUtils.getLock(ctx, jobInfo.getId().toString(), "rec_arch");
        try {
            if (!successLocked) {
                return;
            }
            if ("fail".equals(jobInfo.getState()) || "wating".equals(jobInfo.getState())) {
                ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
                arcRecordInfo.setId(BOSUuid.read((String)jobInfo.getRecord()));
                boolean exists = ArcRecordFactory.getLocalInstance(ctx).exists(H.PK(jobInfo.getRecord()));
                if (exists) {
                    if (null == preProcessJobInfo || !preProcessJobInfo.getRecord().equals(jobInfo.getRecord())) {
                        String easInstanceHome = System.getProperty("EAS_INSTANCE_HOME");
                        ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(jobInfo.getRecord(), ArcStateEnum.ARC_LOADING, "\u5728" + easInstanceHome.substring(easInstanceHome.lastIndexOf("/") + 1) + "\u4e0a\u5f00\u59cb\u5f52\u6863", null);
                    }
                    FilingInstanceFacadeFactory.getLocalInstance(ctx).getFilingInstance(arcRecordInfo).processJob(ctx, jobInfo);
                }
            }
        }
        catch (Exception e) {
            LockDataUtils.releaseLock(ctx, jobInfo.getId().toString());
            logger.error((Object)("com.kingdee.eas.el.rec.filing.error.handleJob:recordId," + jobInfo.getRecord() + ",jobId:" + jobInfo.getId()), (Throwable)e);
        }
    }

    private JobInfo getOldestTask(Context ctx, TaskStateEnum state, JobInfo jobInfo) throws BOSException, EASBizException {
        StringBuilder sqlBuilder = new StringBuilder("select top 1 Fid id from T_REC_Job where ");
        if (null != jobInfo) {
            sqlBuilder.append("FRecordID = '").append(jobInfo.getRecord()).append("' and ");
            sqlBuilder.append("FileFlag = '").append(jobInfo.getFileFlag()).append("' and ");
        }
        sqlBuilder.append("FileFlag is not null and ");
        sqlBuilder.append("FailNum <").append(3).append(" and ");
        sqlBuilder.append("FState = '").append(state.getValue()).append("' order by FCreateTime asc");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
            if (rs.next()) {
                String id = rs.getString("id");
                return this.getJobInfo(ctx, "select * ,content.*, content.billType.*, content.org.longNumber, entry.* where id = '" + id + "'");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

