/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.ArcContentTypeEnum;
import com.kingdee.eas.el.rec.BillTypeFactory;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecUpgradeCollection;
import com.kingdee.eas.el.rec.RecUpgradeFactory;
import com.kingdee.eas.el.rec.RecUpgradeInfo;
import com.kingdee.eas.el.rec.RecordBaseCollection;
import com.kingdee.eas.el.rec.RecordBaseExtendFactory;
import com.kingdee.eas.el.rec.RecordBaseExtendInfo;
import com.kingdee.eas.el.rec.RecordBaseFactory;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.RptDetailType;
import com.kingdee.eas.el.rec.app.AbstractRecUpgradeFacadeControllerBean;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.upgrade.RbOutPutXmlUpgrad_V1;
import com.kingdee.eas.el.rec.upgrade.RbOutPutXmlUpgrad_V10;
import com.kingdee.eas.el.rec.upgrade.RbOutPutXmlUpgrad_V2;
import com.kingdee.eas.el.rec.upgrade.RbOutPutXmlUpgrad_V3;
import com.kingdee.eas.el.rec.upgrade.RbOutPutXmlUpgrad_V4;
import com.kingdee.eas.el.rec.upgrade.RbOutPutXmlUpgrad_V5;
import com.kingdee.eas.el.rec.upgrade.RbOutPutXmlUpgrad_V6;
import com.kingdee.eas.el.rec.upgrade.RbOutPutXmlUpgrad_V7;
import com.kingdee.eas.el.rec.upgrade.RbOutPutXmlUpgrad_V8;
import com.kingdee.eas.el.rec.upgrade.RbOutPutXmlUpgrad_V9;
import com.kingdee.eas.el.rec.upgrade.UpgradFunction;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RecUpgradeFacadeControllerBean
extends AbstractRecUpgradeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.app.RecUpgradeFacadeControllerBean");
    private static final String UGRD = "upgradeRecordBase";
    private static final String UGOXML = "upgradeRecordOutPutXML";
    private static final int V_1 = 1;
    private static final int V_2 = 10;
    private static final int UGRD_CV = 1;
    private static final int UGOXML_CV = 10;
    Map<String, Set<String>> mapMain = null;
    Map<String, Set<String>> mapSub = null;
    static String[] srcFieldArrReport = new String[]{"year", "period", "currency.name"};
    static Map<String, String> mappingMapReport = new HashMap<String, String>();
    static String[] srcFieldArrOR = new String[]{"template.name", "template.number", "number", "name"};
    static Map<String, String> mappingMapOR = new HashMap<String, String>();
    static String[] srcFieldArrHeader_All = new String[]{"dataCenter"};
    static String[] srcFieldArrHeader_All_Report = new String[]{"reportCycleType"};

    public RecUpgradeFacadeControllerBean() {
        mappingMapReport.put("year", "year");
        mappingMapReport.put("period", "periodnum");
        mappingMapReport.put("currency.name", "currency");
        mappingMapOR.put("template.number", "templatenumber");
        mappingMapOR.put("template.name", "reporttype");
        mappingMapOR.put("number", "reportnumber");
        mappingMapOR.put("name", "reportname");
    }

    @Override
    protected boolean _upgradeRecordBase(Context ctx) throws BOSException, EASBizException {
        if (this.hasBeenExceuting(ctx, UGRD, 1) && this.hasBeenExceuting(ctx, UGOXML, 10)) {
            return true;
        }
        this.upgradeRecordBase_V1(ctx);
        this.doUpgradeFunction(ctx, new RbOutPutXmlUpgrad_V1());
        this.doUpgradeFunction(ctx, new RbOutPutXmlUpgrad_V2());
        this.doUpgradeFunction(ctx, new RbOutPutXmlUpgrad_V3());
        this.doUpgradeFunction(ctx, new RbOutPutXmlUpgrad_V4());
        this.doUpgradeFunction(ctx, new RbOutPutXmlUpgrad_V5());
        this.doUpgradeFunction(ctx, new RbOutPutXmlUpgrad_V6());
        this.doUpgradeFunction(ctx, new RbOutPutXmlUpgrad_V7());
        this.doUpgradeFunction(ctx, new RbOutPutXmlUpgrad_V8());
        this.doUpgradeFunction(ctx, new RbOutPutXmlUpgrad_V9());
        this.doUpgradeFunction(ctx, new RbOutPutXmlUpgrad_V10());
        return true;
    }

    private void doUpgradeFunction(Context ctx, UpgradFunction upgradFunction) throws EASBizException, BOSException {
        if (this.hasBeenExceuting(ctx, upgradFunction.getFunctionName(), upgradFunction.getVersion())) {
            return;
        }
        upgradFunction.doUpgrad(ctx);
        this.recordUpgrade(ctx, upgradFunction.getFunctionName(), upgradFunction.getVersion());
    }

    private void upgradeRecordBase_V1(Context ctx) throws BOSException, EASBizException {
        if (this.hasBeenExceuting(ctx, UGRD, 1)) {
            return;
        }
        String defaultSql = "update t_rec_recordbase set FOrgId='00000000-0000-0000-0000-000000000000CCE7AED4' where FRecordType='bill' and FOrgId is null ";
        DbUtil.execute((Context)ctx, (String)defaultSql);
        RecordBaseCollection rbColl = this.getAllRecordBase(ctx);
        Map<String, List<RecordBaseModel>> map = this.classifyRecordBase(rbColl);
        HashMap<RecordBaseModel, List<RecordBaseModel>> upgradeModelMap = new HashMap<RecordBaseModel, List<RecordBaseModel>>();
        for (Map.Entry<String, List<RecordBaseModel>> entry : map.entrySet()) {
            List<RecordBaseModel> typeList = entry.getValue();
            RecordBaseModel topModel = this.getTopRecordBaseModel(ctx, typeList);
            upgradeModelMap.put(topModel, typeList);
        }
        this.doUpgrade(ctx, upgradeModelMap);
        this.recordUpgrade(ctx, UGRD, 1);
        logger.error((Object)("RecUpgradeFacadeControllerBean_upgradeRecordBase--end:" + System.currentTimeMillis()));
    }

    private void recordUpgrade(Context ctx, String function, int version) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("function", (Object)function));
        filter.getFilterItems().add(new FilterItemInfo("version", (Object)version));
        SorterItemInfo sorter = new SorterItemInfo("execTime");
        sorter.setSortType(SortType.DESCEND);
        view.getSorter().add(sorter);
        view.setFilter(filter);
        RecUpgradeCollection coll = RecUpgradeFactory.getLocalInstance(ctx).getRecUpgradeCollection(view);
        RecUpgradeInfo model = new RecUpgradeInfo();
        model.setLastTime(coll == null || coll.size() == 0 ? new Timestamp(System.currentTimeMillis()) : coll.get(0).getExecTime());
        model.setExecTime(new Timestamp(System.currentTimeMillis()));
        model.setOldVersion(version - 1);
        model.setVersion(version);
        model.setFunction(function);
        RecUpgradeFactory.getLocalInstance(ctx).addnew(model);
    }

    private void upgradeOutPutXml_V1(Context ctx) throws BOSException, EASBizException {
        if (this.hasBeenExceuting(ctx, UGOXML, 1)) {
            return;
        }
        this.recordUpgrade(ctx, UGOXML, 1);
        logger.error((Object)("RecUpgradeOutPutxml--end:" + System.currentTimeMillis()));
    }

    private boolean hasBeenExceuting(Context ctx, String function, Integer currentVersion) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("function", (Object)function));
        filter.getFilterItems().add(new FilterItemInfo("version", (Object)currentVersion));
        return RecUpgradeFactory.getLocalInstance(ctx).exists(filter);
    }

    private void doUpgrade(Context ctx, Map<RecordBaseModel, List<RecordBaseModel>> upgradeModelMap) throws EASBizException, BOSException {
        HashSet<String> billTypeIds = new HashSet<String>();
        HashSet<String> rbIds = new HashSet<String>();
        ArrayList<RecordBaseModel> beenDelList = new ArrayList<RecordBaseModel>();
        for (Map.Entry<RecordBaseModel, List<RecordBaseModel>> entry : upgradeModelMap.entrySet()) {
            RecordBaseModel mainModel = entry.getKey();
            List<RecordBaseModel> modelList = entry.getValue();
            for (int i = 0; i < modelList.size(); ++i) {
                RecordBaseModel subModel = modelList.get(i);
                if (subModel.getRecordBaseId().equals(mainModel.getRecordBaseId())) continue;
                if (this.needToUpgrade(ctx, mainModel, subModel)) {
                    this.doExtendUprade(ctx, mainModel, subModel);
                } else {
                    this.doEerge(ctx, mainModel, subModel);
                }
                billTypeIds.add(subModel.getRecordBaseInfo().getBillType().getId().toString());
                rbIds.add(subModel.getRecordBaseId());
                beenDelList.add(subModel);
            }
        }
        if (billTypeIds.size() > 0) {
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("id", billTypeIds, CompareType.INCLUDE));
            BillTypeFactory.getLocalInstance(ctx).delete(filter1);
        }
        if (rbIds.size() > 0) {
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("id", rbIds, CompareType.INCLUDE));
            RecordBaseFactory.getLocalInstance(ctx).delete(filter2);
        }
        logger.error((Object)" doUpgrade success ");
    }

    private void doEerge(Context ctx, RecordBaseModel mainModel, RecordBaseModel subModel) throws BOSException {
        String sql1 = " UPDATE T_REC_ArcheSchemeContentEntry set FArchContentID= ?  where FArchContentID = ?";
        String sql2 = " UPDATE T_REC_ArcRecord SET FContentID = ?  WHERE FContentID = ? ";
        String sql3 = " UPDATE T_REC_AttachBillAchDetail SET FArcContentID = ?  WHERE FArcContentID = ? ";
        Object[] objs = new Object[]{mainModel.getRecordBaseId(), subModel.getRecordBaseId()};
        DbUtil.execute((Context)ctx, (String)sql1, (Object[])objs);
        DbUtil.execute((Context)ctx, (String)sql2, (Object[])objs);
        DbUtil.execute((Context)ctx, (String)sql3, (Object[])objs);
    }

    private void doExtendUprade(Context ctx, RecordBaseModel mainModel, RecordBaseModel subModel) throws BOSException, EASBizException {
        Set<String> orgSet = null;
        orgSet = subModel.getRecordBaseInfo().isIsRefBill() ? this.subBill(ctx, subModel) : this.mainBill(ctx, subModel);
        if (orgSet == null) {
            return;
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        Iterator<String> orgIts = orgSet.iterator();
        while (orgIts.hasNext()) {
            RecordBaseExtendInfo rbExtendInfo = new RecordBaseExtendInfo();
            rbExtendInfo.setPrintTemplate(subModel.getRecordBaseInfo().getPrintTemplate());
            rbExtendInfo.setPrintTemplateName(subModel.getRecordBaseInfo().getPrintTemplateName());
            CompanyOrgUnitInfo orgInfo = new CompanyOrgUnitInfo();
            orgInfo.setId(BOSUuid.read((String)orgIts.next()));
            rbExtendInfo.setOrg(orgInfo);
            rbExtendInfo.setRecordBaseId(mainModel.getRecordBaseInfo());
            colls.add((CoreBaseInfo)rbExtendInfo);
        }
        if (colls.size() > 0) {
            RecordBaseExtendFactory.getLocalInstance(ctx).addnewBatchData(colls);
        }
        this.doEerge(ctx, mainModel, subModel);
    }

    private Set<String> mainBill(Context ctx, RecordBaseModel subModel) throws BOSException {
        if (this.mapMain != null) {
            return this.mapMain.get(subModel.getRecordBaseId());
        }
        this.mapMain = new HashMap<String, Set<String>>();
        StringBuffer buffer1 = new StringBuffer();
        buffer1.append(" SELECT distinct FORGID ,FCONTENTID FROM  ");
        buffer1.append(" T_REC_ARCRECORD where FCONTENTTYPE ='bill' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer1.toString());
        try {
            while (rs.next()) {
                String recordBaseId = rs.getString("FCONTENTID");
                String orgId = rs.getString("FORGID");
                Set<String> set = this.mapMain.get(recordBaseId);
                if (set == null) {
                    set = new HashSet<String>();
                    set.add(orgId);
                    this.mapMain.put(recordBaseId, set);
                    continue;
                }
                set.add(orgId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.mapMain.get(subModel.getRecordBaseId());
    }

    private Set<String> subBill(Context ctx, RecordBaseModel subModel) throws BOSException {
        if (this.mapSub != null) {
            return this.mapSub.get(subModel.getRecordBaseId());
        }
        this.mapSub = new HashMap<String, Set<String>>();
        StringBuffer buffer1 = new StringBuffer();
        buffer1.append(" SELECT distinct rd.forgid ,farccontentid FROM   T_REC_AttachBillAchDetail de  ");
        buffer1.append(" inner join T_REC_AchRecordDetail ar on ar.FID =de.fachrecorddetailid ");
        buffer1.append(" inner join T_REC_ARCRECORD rd on rd.FID = ar.FARCRECORDID where rd.FCONTENTTYPE ='bill' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer1.toString());
        try {
            while (rs.next()) {
                String recordBaseId = rs.getString("farccontentid");
                String orgId = rs.getString("forgid");
                Set<String> set = this.mapSub.get(recordBaseId);
                if (set == null) {
                    set = new HashSet<String>();
                    set.add(orgId);
                    this.mapSub.put(recordBaseId, set);
                    continue;
                }
                set.add(orgId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.mapSub.get(subModel.getRecordBaseId());
    }

    private boolean needToUpgrade(Context ctx, RecordBaseModel mainModel, RecordBaseModel subModel) {
        return (!StringUtils.isBlank((String)mainModel.getRecordBaseInfo().getPrintTemplate()) || !StringUtils.isBlank((String)subModel.getRecordBaseInfo().getPrintTemplate())) && (StringUtils.isBlank((String)mainModel.getRecordBaseInfo().getPrintTemplate()) || !mainModel.getRecordBaseInfo().getPrintTemplate().equals(subModel.getRecordBaseInfo().getPrintTemplate()));
    }

    private Map<String, List<RecordBaseModel>> classifyRecordBase(RecordBaseCollection rbColl) {
        HashMap<String, List<RecordBaseModel>> map = new HashMap<String, List<RecordBaseModel>>();
        for (int i = 0; rbColl != null && i < rbColl.size(); ++i) {
            RecordBaseInfo recordBaseInfo = rbColl.get(i);
            CompanyOrgUnitInfo companyOrgInfo = recordBaseInfo.getOrg();
            RecordBaseModel model = new RecordBaseModel();
            model.setBosType(recordBaseInfo.getBillType().getBosType());
            model.setCustomRelationImpl(recordBaseInfo.getCustomRelationImpl());
            model.setCompanyOrgInfo(companyOrgInfo);
            model.setRecordBaseId(recordBaseInfo.getId() + "");
            model.setRecordBaseInfo(recordBaseInfo);
            model.setDefault(recordBaseInfo.isIsDefault());
            String modelId = recordBaseInfo.getBillType().getBosType() + "--" + recordBaseInfo.getCustomRelationImpl();
            model.setId(modelId);
            ArrayList<RecordBaseModel> typeList = (ArrayList<RecordBaseModel>)map.get(modelId);
            if (typeList == null) {
                typeList = new ArrayList<RecordBaseModel>();
                map.put(modelId, typeList);
            }
            typeList.add(model);
        }
        return map;
    }

    private RecordBaseCollection getAllRecordBase(Context ctx) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)"bill"));
        SelectorItemCollection selector = ev.getSelector();
        selector.add("*");
        selector.add("billType.*");
        selector.add("org.*");
        ev.setSelector(selector);
        ev.setFilter(filter);
        return RecordBaseFactory.getLocalInstance(ctx).getRecordBaseCollection(ev);
    }

    private RecordBaseModel getTopRecordBaseModel(Context ctx, List<RecordBaseModel> typeList) {
        RecordBaseModel topRecordBaseModel = null;
        for (RecordBaseModel model : typeList) {
            String longNumber = model.getCompanyOrgInfo().getLongNumber();
            if (longNumber.contains("!") || !model.isDefault()) continue;
            topRecordBaseModel = model;
            break;
        }
        if (topRecordBaseModel == null) {
            topRecordBaseModel = typeList.get(0);
        }
        return topRecordBaseModel;
    }

    @Override
    protected boolean _elevateRecordBase(Context ctx, String companyId) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _hasUpgrade(Context ctx, String function, int version) throws BOSException, EASBizException {
        return this.hasBeenExceuting(ctx, UGRD, 1) && this.hasBeenExceuting(ctx, UGOXML, 10);
    }

    @Override
    protected boolean _mvOrgMergeRecordBase(Context ctx, List list) throws BOSException, EASBizException {
        if (list == null) {
            // empty if block
        }
        for (int i = 0; i < list.size(); ++i) {
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)list.get(i);
        }
        return false;
    }

    @Override
    protected boolean _upgradeOutputXMLTemplate(Context ctx, String recordBaseId) throws BOSException, EASBizException {
        RecordBaseCollection allColl = new RecordBaseCollection();
        if (StringUtils.isBlank((String)recordBaseId)) {
            allColl = RecordBaseFactory.getLocalInstance(ctx).getRecordBaseCollection();
        } else {
            allColl = new RecordBaseCollection();
            allColl.add(RecordBaseFactory.getLocalInstance(ctx).getRecordBaseInfo(H.PK(recordBaseId)));
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < allColl.size(); ++i) {
            RecordBaseInfo info = allColl.get(i);
            boolean isUpdate = false;
            try {
                isUpdate = this.upgradeOutputXMLTemplate(ctx, info);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                continue;
            }
            if (!isUpdate) continue;
            colls.add((CoreBaseInfo)info);
        }
        RecordBaseFactory.getLocalInstance(ctx).updateBatchData(colls);
        return true;
    }

    private boolean upgradeOutputXMLTemplate(Context ctx, RecordBaseInfo info) throws Exception {
        try {
            String xml = info.getOutPutXMLTemplate();
            if (StringUtils.isBlank((String)xml)) {
                return false;
            }
            Document xmlDoc = this.xml2Document(xml);
            Element root = xmlDoc.getRootElement();
            boolean headlerIsUpdate = this.handleHeader(ctx, info, root);
            Element rule_list = root.element("rule-list");
            boolean bodyIsUpdate = this.handleRule_list(ctx, info, rule_list);
            if (headlerIsUpdate || bodyIsUpdate) {
                info.setOutPutXMLTemplate(UpgradFunction.document2Xml(xmlDoc));
                info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            }
            return headlerIsUpdate || bodyIsUpdate;
        }
        catch (Exception e) {
            logger.error((Object)("[" + info.getNumber() + "] xml\u5347\u7ea7\u5f02\u5e38"), (Throwable)e);
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"[" + info.getNumber() + "] xml\u5347\u7ea7\u5f02\u5e38"});
        }
    }

    private boolean handleRule_list(Context ctx, RecordBaseInfo info, Element rule_list) {
        Element elSrcField;
        boolean isContain;
        boolean bodyIsUpdate = false;
        List list = rule_list.elements("rule");
        if (!ArcContentTypeEnum.BILL.equals((Object)info.getRecordType()) && info.getReportCycleType() != null) {
            for (String key : srcFieldArrReport) {
                isContain = false;
                for (Element el : list) {
                    elSrcField = el.element("srcfield");
                    if (!key.equals(elSrcField.getTextTrim())) continue;
                    if (isContain) {
                        rule_list.remove(el);
                        bodyIsUpdate = true;
                    }
                    isContain = true;
                }
                if (isContain) continue;
                this.addRuleElement(rule_list, key, mappingMapReport);
                bodyIsUpdate = true;
            }
        }
        if ((ArcContentTypeEnum.OtherReport.equals((Object)info.getRecordType()) || ArcContentTypeEnum.RptsReport.equals((Object)info.getRecordType()) || ArcContentTypeEnum.QmsReport.equals((Object)info.getRecordType())) && info.getReportCycleType() != null) {
            for (String key : srcFieldArrOR) {
                isContain = false;
                for (Element el : list) {
                    elSrcField = el.element("srcfield");
                    if (!key.equals(elSrcField.getTextTrim())) continue;
                    if (isContain) {
                        rule_list.remove(el);
                        bodyIsUpdate = true;
                    }
                    isContain = true;
                }
                if (RptDetailType.DXFL.equals((Object)info.getRptDetailType()) || RptDetailType.TZFL.equals((Object)info.getRptDetailType()) || isContain) continue;
                this.addRuleElement(rule_list, key, mappingMapOR);
                bodyIsUpdate = true;
            }
        }
        return bodyIsUpdate;
    }

    private void addRuleElement(Element rule_list, String key, Map<String, String> mappingMap) {
        this.addRuleElement(rule_list, "", key, mappingMap.get(key), "");
    }

    private void addRuleElement(Element rule_list, String tips, String srcfield, String destfield, String format) {
        Element rule = rule_list.addElement("rule");
        if (!StringUtils.isBlank((String)tips)) {
            Element tipsEl = rule.addElement("tips");
            tipsEl.addText(tips);
        }
        Element srcfieldEl = rule.addElement("srcfield");
        srcfieldEl.addText(srcfield);
        Element destfieldEl = rule.addElement("destfield");
        destfieldEl.addText(destfield);
        if (!StringUtils.isBlank((String)format)) {
            Element formatEl = rule.addElement("format");
            formatEl.addText(format);
        }
    }

    private boolean handleHeader(Context ctx, RecordBaseInfo info, Element header) {
        Element field;
        int i;
        boolean isUpdated = false;
        for (i = 0; i < srcFieldArrHeader_All.length; ++i) {
            field = header.element(srcFieldArrHeader_All[i]);
            if (field != null) continue;
            header.addElement(srcFieldArrHeader_All[i]);
            isUpdated = true;
        }
        if (!ArcContentTypeEnum.BILL.equals((Object)info.getRecordType())) {
            for (i = 0; i < srcFieldArrHeader_All_Report.length; ++i) {
                field = header.element(srcFieldArrHeader_All_Report[i]);
                if (field != null) continue;
                header.addElement(srcFieldArrHeader_All_Report[i]);
                isUpdated = true;
            }
        }
        return isUpdated;
    }

    private Document xml2Document(String xml) throws Exception {
        if (null != xml && !"".equals(xml) && xml.indexOf("<") != -1 && xml.lastIndexOf(">") != -1 && xml.lastIndexOf(">") > xml.indexOf("<")) {
            xml = xml.substring(xml.indexOf("<"), xml.lastIndexOf(">") + 1);
        }
        StringReader xmlReader = new StringReader(xml);
        SAXReader saxReader = new SAXReader();
        Document xmlDoc = saxReader.read((Reader)xmlReader);
        return xmlDoc;
    }

    class RecordBaseModel {
        private String id;
        private String bosType;
        private String customRelationImpl;
        private String recordBaseId;
        private RecordBaseInfo recordBaseInfo;
        private CompanyOrgUnitInfo companyOrgInfo;
        private boolean isDefault;

        RecordBaseModel() {
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getBosType() {
            return this.bosType;
        }

        public void setBosType(String bosType) {
            this.bosType = bosType;
        }

        public String getCustomRelationImpl() {
            return this.customRelationImpl;
        }

        public void setCustomRelationImpl(String customRelationImpl) {
            this.customRelationImpl = customRelationImpl;
        }

        public String getRecordBaseId() {
            return this.recordBaseId;
        }

        public void setRecordBaseId(String recordBaseId) {
            this.recordBaseId = recordBaseId;
        }

        public RecordBaseInfo getRecordBaseInfo() {
            return this.recordBaseInfo;
        }

        public void setRecordBaseInfo(RecordBaseInfo recordBaseInfo) {
            this.recordBaseInfo = recordBaseInfo;
        }

        public CompanyOrgUnitInfo getCompanyOrgInfo() {
            return this.companyOrgInfo;
        }

        public void setCompanyOrgInfo(CompanyOrgUnitInfo companyOrgInfo) {
            this.companyOrgInfo = companyOrgInfo;
        }
    }
}

