/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.el.rec.ArcContentTypeEnum;
import com.kingdee.eas.el.rec.BillTypeFactory;
import com.kingdee.eas.el.rec.BillTypeInfo;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseCollection;
import com.kingdee.eas.el.rec.RecordBaseExtendCollection;
import com.kingdee.eas.el.rec.RecordBaseExtendFactory;
import com.kingdee.eas.el.rec.RecordBaseExtendInfo;
import com.kingdee.eas.el.rec.RecordBaseFactory;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.app.AbstractRecordBaseControllerBean;
import com.kingdee.eas.el.rec.ofd.FilingOfdUtils;
import com.kingdee.eas.el.rec.tool.FormatUtils;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.IBillHandler;
import com.kingdee.eas.el.rec.tool.IRefBillHandler;
import com.kingdee.eas.el.rec.tool.RecordBaseUtils;
import com.kingdee.eas.el.rec.tool.engine.ReportParsingEngineUtil;
import com.kingdee.eas.el.rec.tool.engine.gl.GLReportParsingEngineUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RecordBaseControllerBean
extends AbstractRecordBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.app.RecordBaseControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BillTypeInfo billType;
        IObjectPK pk = null;
        RecordBaseInfo info = (RecordBaseInfo)model;
        this.checkNumberDup(ctx, info);
        this.checkDup(ctx, (IObjectValue)info);
        this.checkBillHandller(ctx, (CoreBaseInfo)info);
        if (ArcContentTypeEnum.BILL.equals((Object)info.getRecordType())) {
            RecordBaseUtils.checkPrint(ctx, info);
        }
        if ((billType = info.getBillType()) != null) {
            if (billType.getNumber() == null || billType.getNumber().length() == 0) {
                billType.setNumber(model.get("number") + "");
                billType.setBillName(model.get("billname") + "");
                billType.setName(model.get("billname") + "");
            }
            BillTypeFactory.getLocalInstance(ctx).save((CoreBaseInfo)billType);
        }
        this.addPrintTemplateExtendInfo(ctx, (CoreBaseInfo)info);
        this.addElCertificateExtendInfo(ctx, (CoreBaseInfo)info);
        pk = super._save(ctx, (IObjectValue)info);
        return pk;
    }

    private void checkBillHandller(Context ctx, CoreBaseInfo model) throws RecException {
        String[] checkers;
        if (!ArcContentTypeEnum.BILL.equals((Object)((RecordBaseInfo)model).getRecordType())) {
            return;
        }
        if (((RecordBaseInfo)model).isIsRefBill()) {
            return;
        }
        BillTypeInfo billType = ((RecordBaseInfo)model).getBillType();
        String bosType = billType.getBosType();
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)bosType, IBillHandler.class);
        }
        catch (EASDBException e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{e.getMessage()});
        }
        if (null == checkers || checkers.length == 0) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"\u6ca1\u6709\u5b9e\u73b0com.kingdee.eas.el.rec.tool.IBillHandler,\u4e0d\u80fd\u4f5c\u4e3a\u4e3b\u5355"});
        }
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("org.*");
        view.setSelector(selectorItemCollection);
        RecordBaseCollection recordBaseCollection = this.getRecordBaseCollection(ctx, view);
        if (recordBaseCollection.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u7f16\u7801\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u7ec4\u7ec7[" + recordBaseCollection.get(0).getOrg().getName() + "]\u5df2\u7ecf\u4f7f\u7528\uff01"));
        }
    }

    private void addPrintTemplateExtendInfo(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        RecordBaseInfo recordBaseInfo = (RecordBaseInfo)model;
        if (!ArcContentTypeEnum.BILL.equals((Object)recordBaseInfo.getRecordType())) {
            return;
        }
        CompanyOrgUnitInfo corg = (CompanyOrgUnitInfo)model.get("org");
        if (null == corg) {
            return;
        }
        String createOrgID = corg.getId().toString();
        String extendOrgID = (String)model.get("extendOrgID");
        if (StringUtils.isEmpty((CharSequence)extendOrgID)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)((String)model.get("extendPrintTemplate"))) || StringUtils.isEmpty((CharSequence)((String)model.get("extendPrintTemplateName")))) {
            return;
        }
        if (createOrgID.equals(extendOrgID)) {
            recordBaseInfo.setPrintTemplate((String)model.get("extendPrintTemplate"));
            recordBaseInfo.setPrintTemplateName((String)model.get("extendPrintTemplateName"));
            return;
        }
        RecordBaseExtendCollection recordBaseExtendCollection = RecordBaseExtendFactory.getLocalInstance(ctx).getRecordBaseExtendCollection("where org = '" + extendOrgID + "' and recordBaseId ='" + model.get("id") + "'");
        if (!this.isExtendPrintTemplate(model)) {
            if (recordBaseExtendCollection.size() != 0) {
                RecordBaseExtendFactory.getLocalInstance(ctx).delete(H.PK(recordBaseExtendCollection.get(0).getId()));
            }
        } else {
            RecordBaseExtendInfo recordBaseExtendInfo = null;
            if (recordBaseExtendCollection.size() != 0) {
                recordBaseExtendInfo = recordBaseExtendCollection.get(0);
            } else {
                recordBaseExtendInfo = new RecordBaseExtendInfo();
                CompanyOrgUnitInfo org = new CompanyOrgUnitInfo();
                org.setId(BOSUuid.read((String)extendOrgID));
                recordBaseExtendInfo.setOrg(org);
                recordBaseExtendInfo.setRecordBaseId((RecordBaseInfo)model);
            }
            recordBaseExtendInfo.setPrintTemplateName((String)model.get("extendPrintTemplateName"));
            recordBaseExtendInfo.setPrintTemplate((String)model.get("extendPrintTemplate"));
            RecordBaseExtendFactory.getLocalInstance(ctx).save((CoreBaseInfo)recordBaseExtendInfo);
        }
    }

    private boolean isExtendPrintTemplate(CoreBaseInfo model) {
        if (null == model.get("extendPrintTemplate")) {
            return false;
        }
        return null == model.get("printTemplate") || !model.get("extendPrintTemplate").equals(model.get("printTemplate"));
    }

    private void addElCertificateExtendInfo(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        RecordBaseInfo recordBaseInfo = (RecordBaseInfo)model;
        if (!ArcContentTypeEnum.BILL.equals((Object)recordBaseInfo.getRecordType()) || !FilingOfdUtils.billTypes.contains(recordBaseInfo.getBillType().getBosType())) {
            return;
        }
        CompanyOrgUnitInfo corg = (CompanyOrgUnitInfo)model.get("org");
        if (null == corg) {
            return;
        }
        String extendOrgID = (String)model.get("extendOrgID");
        if (model.get("extendelcertificate") == null) {
            return;
        }
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(H.PK(extendOrgID));
        CompanyOrgUnitInfo createOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(H.PK(corg.getId()));
        String archLongNumber = companyOrgUnitInfo.getLongNumber();
        String creatorLongNumber = createOrg.getLongNumber();
        HashSet<String> set = new HashSet<String>();
        while (archLongNumber.indexOf(creatorLongNumber) > -1 && !creatorLongNumber.equals(archLongNumber) && archLongNumber.lastIndexOf("!") > -1) {
            archLongNumber = archLongNumber.substring(0, archLongNumber.lastIndexOf("!"));
            set.add(archLongNumber);
        }
        set.add(creatorLongNumber);
        String sql = "SELECT T1.FelCertificate, T2.FLONGNUMBER, T2.FLEVEL, T1.FID, T1.FORGID FROM T_REC_RECORDBASEEXTEND  T1 inner join T_ORG_COMPANY T2 on T1.FRecordBaseId = ? and T2.FID = T1.FORGID and T2.FLONGNUMBER IN " + FormatUtils.list2Sql(set) + " order by T2.FLEVEL desc";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{model.getId().toString()});
        boolean isextend = true;
        try {
            if (executeQuery.next()) {
                isextend = !model.get("extendelcertificate").equals(executeQuery.getBoolean(1));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("00", e.getMessage()), (Throwable)e);
        }
        RecordBaseExtendCollection baseExtendCollection = RecordBaseExtendFactory.getLocalInstance(ctx).getRecordBaseExtendCollection("where recordBaseId = '" + model.get("id") + "' and org = '" + extendOrgID + "'");
        RecordBaseExtendInfo info = new RecordBaseExtendInfo();
        if (!isextend) {
            if (baseExtendCollection.size() != 0) {
                String sql1 = "update t_Rec_recordbaseextend set felCertificate = null where fid = ?";
                DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{baseExtendCollection.get(0).getId().toString()});
            }
        } else {
            if (baseExtendCollection.size() == 0) {
                CompanyOrgUnitInfo org = new CompanyOrgUnitInfo();
                org.setId(BOSUuid.read((String)extendOrgID));
                info.setOrg(org);
                info.setRecordBaseId((RecordBaseInfo)model);
            } else {
                info = baseExtendCollection.get(0);
            }
            info.setElCertificate((Boolean)model.get("extendelcertificate"));
            RecordBaseExtendFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return null;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ArcContentTypeEnum.REPORT.equals((Object)((RecordBaseInfo)model).getRecordType())) {
            String collectImpl = ((RecordBaseInfo)model).getCollectImpl();
            if (GLReportParsingEngineUtil.class.getName().equals(collectImpl)) {
                throw new EASBizException(new NumericExceptionSubItem("00", "\u4e0d\u80fd\u65b0\u589e\u9884\u5236\u5f15\u64ce\u7684\u8d26\u7c3f\u62a5\u8868\u5f52\u6863\u5185\u5bb9"));
            }
            try {
                Class<?> collectImplClass = Class.forName(collectImpl);
                if (!(collectImplClass.newInstance() instanceof ReportParsingEngineUtil)) {
                    throw new EASBizException(new NumericExceptionSubItem("00", collectImpl + " \u4e0d\u662fcom.kingdee.eas.el.rec.tool.engine.ReportParsingEngineUtil\u7684\u5b50\u7c7b"));
                }
            }
            catch (ClassNotFoundException e) {
                throw new EASBizException(new NumericExceptionSubItem("00", collectImpl + "\u4e0d\u5b58\u5728"), (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new EASBizException(new NumericExceptionSubItem("00", collectImpl + "IllegalAccessException"), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new EASBizException(new NumericExceptionSubItem("00", collectImpl + "IllegalAccessException"), (Throwable)e);
            }
        }
        return super._addnew(ctx, model);
    }

    private void checkDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (ArcContentTypeEnum.BILL.equals((Object)((RecordBaseInfo)model).getRecordType())) {
            BillTypeInfo billType;
            String customRelationImpl = ((RecordBaseInfo)model).getCustomRelationImpl();
            if (!StringUtils.isEmpty((CharSequence)customRelationImpl)) {
                try {
                    Class<?> customRelationImplClass = Class.forName(customRelationImpl);
                    if (!(customRelationImplClass.newInstance() instanceof IRefBillHandler)) {
                        throw new EASBizException(new NumericExceptionSubItem("00", customRelationImpl + " \u4e0d\u662fcom.kingdee.eas.el.rec.tool.IRefBillHandlerd\u7684\u5b9e\u73b0\u7c7b"));
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new EASBizException(new NumericExceptionSubItem("00", customRelationImpl + "\u4e0d\u5b58\u5728"), (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new EASBizException(new NumericExceptionSubItem("00", customRelationImpl + "IllegalAccessException"), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new EASBizException(new NumericExceptionSubItem("00", customRelationImpl + "IllegalAccessException"), (Throwable)e);
                }
            }
            if ((billType = ((RecordBaseInfo)model).getBillType()) != null && !StringUtils.isEmpty((CharSequence)billType.getBosType())) {
                String sql = "SELECT T2.Fnumber, T2.FID FROM T_REC_BILLTYPE T1 inner join T_rec_recordbase T2 on T1.FID = T2.FBillTypeID and T1.FBosType = ? and T2.FID != ?";
                String recordbaseId = ((RecordBaseInfo)model).getId() == null ? "" : ((RecordBaseInfo)model).getId().toString();
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billType.getBosType(), recordbaseId});
                try {
                    while (executeQuery.next()) {
                        this.checkDup(ctx, model, executeQuery);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"\u5224\u65ad\u540c\u79cd\u5355\u636e\u7c7b\u578b\u662f\u5426\u5b58\u5728\u5f52\u6863\u5185\u5bb9err", (Throwable)e);
                }
            }
        }
    }

    private void checkDup(Context ctx, IObjectValue model, IRowSet executeQuery) throws EASBizException, BOSException, SQLException {
        String customRelationImpl = ((RecordBaseInfo)model).getCustomRelationImpl();
        RecordBaseInfo recordBaseInfo = RecordBaseFactory.getLocalInstance(ctx).getRecordBaseInfo("select *, org.* where id = '" + executeQuery.getString(2) + "'");
        CompanyOrgUnitInfo companyOrgUnitInfo = recordBaseInfo.getOrg();
        CompanyOrgUnitInfo createOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(H.PK(((RecordBaseInfo)model).getOrg().getId()));
        if (companyOrgUnitInfo.getLongNumber().contains(createOrg.getLongNumber()) || createOrg.getLongNumber().contains(companyOrgUnitInfo.getLongNumber())) {
            if (((RecordBaseInfo)model).isIsRefBill()) {
                if (StringUtils.isEmpty((CharSequence)customRelationImpl) && StringUtils.isEmpty((CharSequence)recordBaseInfo.getCustomRelationImpl())) {
                    throw new EASBizException(new NumericExceptionSubItem("00", "\u5355\u636e\u5b9e\u4f53+\u5173\u8054\u65b9\u5f0f\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u7ec4\u7ec7[" + recordBaseInfo.getOrg().getName() + "]\u7684\u5f52\u6863\u5185\u5bb9[" + recordBaseInfo.getName() + "]\u5df2\u7ecf\u4f7f\u7528\uff01"));
                }
                if (StringUtils.isEmpty((CharSequence)customRelationImpl) || StringUtils.isEmpty((CharSequence)recordBaseInfo.getCustomRelationImpl())) {
                    return;
                }
                if (!StringUtils.isEmpty((CharSequence)customRelationImpl) && !StringUtils.isEmpty((CharSequence)recordBaseInfo.getCustomRelationImpl()) && customRelationImpl.equals(recordBaseInfo.getCustomRelationImpl())) {
                    throw new EASBizException(new NumericExceptionSubItem("00", "\u5355\u636e\u5b9e\u4f53+\u5173\u8054\u65b9\u5f0f\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u7ec4\u7ec7[" + recordBaseInfo.getOrg().getName() + "]\u7684\u5f52\u6863\u5185\u5bb9[" + recordBaseInfo.getName() + "]\u5df2\u7ecf\u4f7f\u7528\uff01"));
                }
            } else {
                throw new EASBizException(new NumericExceptionSubItem("00", "\u5355\u636e\u5b9e\u4f53[" + ((RecordBaseInfo)model).getBillType().getBillName() + "]\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u7ec4\u7ec7[" + recordBaseInfo.getOrg().getName() + "]\u7684\u5f52\u6863\u5185\u5bb9[" + recordBaseInfo.getName() + "]\u5df2\u7ecf\u4f7f\u7528\uff01"));
            }
        }
    }

    private boolean checkRelationDup(String cRelation, String relation) {
        if (StringUtils.isEmpty((CharSequence)cRelation) && StringUtils.isEmpty((CharSequence)relation)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)cRelation) || StringUtils.isEmpty((CharSequence)relation)) {
            return false;
        }
        if (!StringUtils.isEmpty((CharSequence)cRelation) && !StringUtils.isEmpty((CharSequence)relation)) {
            return true;
        }
        return true;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RecordBaseInfo recordBaseInfo = RecordBaseFactory.getLocalInstance(ctx).getRecordBaseInfo(pk);
        if (!recordBaseInfo.isIsDefault()) {
            RecordBaseExtendFactory.getLocalInstance(ctx).delete("where recordBaseId = '" + recordBaseInfo.getId().toString() + "'");
            super._delete(ctx, pk);
            BillTypeFactory.getLocalInstance(ctx).delete(H.PK(recordBaseInfo.getBillType().getId()));
        }
    }

    private int getCount(String mainStr, String subStr) {
        int minLength = mainStr.length();
        int subLength = subStr.length();
        int count = 0;
        int index = 0;
        if (minLength >= subLength) {
            while ((index = mainStr.indexOf(subStr, index)) != -1) {
                ++count;
                index += subLength;
            }
            return count;
        }
        return -1;
    }
}

