/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.app.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.el.rec.ArchConfigKeyCollection;
import com.kingdee.eas.el.rec.ArchConfigKeyFactory;
import com.kingdee.eas.el.rec.ArchConfigKeyInfo;
import com.kingdee.eas.el.rec.app.util.LoadArchConfig;
import com.kingdee.eas.el.rec.app.util.RECCacheManager;
import com.kingdee.util.StringUtils;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ArchConfigUtil {
    private static Logger logger = Logger.getLogger((String)ArchConfigUtil.class.getName());

    public static String getPropertiesValue(Context ctx, String key, String deValue) {
        String propertiesValue = ArchConfigUtil.getPropertiesValue(ctx, key);
        return StringUtils.isEmpty((String)propertiesValue) ? deValue : propertiesValue;
    }

    public static String getPropertiesValue(Context ctx, String key) {
        Properties properties = LoadArchConfig.loadProperties(ctx);
        String value = properties.getProperty(key);
        return value;
    }

    public static Properties loadProperties(Context ctx) {
        return LoadArchConfig.loadProperties(ctx);
    }

    public static boolean needClearCache(Context ctx) {
        try {
            ArchConfigKeyCollection coll = ArchConfigKeyFactory.getLocalInstance(ctx).getArchConfigKeyCollection("select *  where key = 'arch.config.lastupdatetime' ");
            ArchConfigKeyInfo lastUpdate = coll.get(0);
            Object cacheObj = RECCacheManager.recCacheService.get("arch_system_properties");
            Properties cfgMap = (Properties)cacheObj;
            String dbId = ctx.getAIS();
            Properties properties = (Properties)cfgMap.get(dbId);
            if (lastUpdate.getDefaultValue().equals(properties.get("arch.config.lastupdatetime").toString().trim())) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)("com.kingdee.eas.el.rec.app.util.ArchConfigUtil.needClearCache;" + e));
        }
        logger.error((Object)"com.kingdee.eas.el.rec.app.util.ArchConfigUtil.needClearCache;--return true");
        return true;
    }

    public static void clearCache(Context ctx) {
        ArchConfigKeyInfo lastUpdate = null;
        try {
            ArchConfigKeyCollection coll = ArchConfigKeyFactory.getLocalInstance(ctx).getArchConfigKeyCollection("select *  where key = 'arch.config.lastupdatetime' ");
            lastUpdate = coll.get(0);
            lastUpdate.setDefaultValue(System.currentTimeMillis() + "");
            ArchConfigKeyFactory.getLocalInstance(ctx).save(lastUpdate);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("clearCache LoadArchConfig get lastupdaate time error " + e);
        }
        ArchConfigUtil.loadProperties(ctx);
    }
}

