/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.filing.instance;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArchSchemeCollection;
import com.kingdee.eas.el.rec.ArchSchemeFactory;
import com.kingdee.eas.el.rec.ArchSchemeInfo;
import com.kingdee.eas.el.rec.ArchSchemeScopeOrgEntryCollection;
import com.kingdee.eas.el.rec.ArcheSchemeContentEntryCollection;
import com.kingdee.eas.el.rec.ArcheSchemeContentEntryInfo;
import com.kingdee.eas.el.rec.CurrencyEntryCollection;
import com.kingdee.eas.el.rec.CurrencyEntryInfo;
import com.kingdee.eas.el.rec.FilingInstanceFacadeFactory;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.RptDetailType;
import com.kingdee.eas.el.rec.filing.instance.FilingReport;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.model.ReportArchInfo;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.outputmodule.archsys.pojo.ArchFormatInfo;
import com.kingdee.eas.el.rec.tool.PeriodUtil;
import com.kingdee.eas.el.rec.tool.engine.ReportParsingEngineUtil;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.util.StringUtils;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractMergeFilingReport
extends FilingReport {
    private static Logger logger = Logger.getLogger(AbstractMergeFilingReport.class);
    protected Map<String, String> periodCacheMap = new HashMap<String, String>();

    @Override
    protected void checkScheme(Context ctx, ArchSchemeInfo asInfo) throws EASBizException {
    }

    @Override
    protected void doExecute(Context ctx, ArchSchemeInfo asInfo, ArcheSchemeContentEntryCollection contents, ArchSchemeScopeOrgEntryCollection orgs) throws Exception {
        PeriodCollection periods = this.getPeriodsForReport(ctx, asInfo, null, null);
        for (int i = 0; i < periods.size(); ++i) {
            List<OrgStructureInfo> orgStructureList = this.getOrgStructureList(ctx, asInfo, periods.get(i));
            this.foreachOrgStructure(ctx, asInfo, orgStructureList, asInfo.getCurrency(), periods.get(i), asInfo.getArchemeContent());
        }
    }

    @Override
    protected PeriodCollection getPeriodsForReport(Context ctx, ArchSchemeInfo asInfo, RecordBaseInfo archContent, CompanyOrgUnitInfo companyOrgUnitInfo) throws RecException {
        try {
            return PeriodUtil.getPeriodsForOtherReport(ctx, asInfo);
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"\u65b9\u6848[" + asInfo.getNumber() + "]\u83b7\u53d6\u5f52\u6863\u671f\u95f4\u5f02\u5e38"});
        }
    }

    protected abstract List<OrgStructureInfo> getOrgStructureList(Context var1, ArchSchemeInfo var2, PeriodInfo var3) throws RecException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException;

    protected void foreachOrgStructure(Context ctx, ArchSchemeInfo asInfo, List<OrgStructureInfo> orgStructureList, CurrencyEntryCollection currencyColl, PeriodInfo periodInfo, ArcheSchemeContentEntryCollection contents) throws Exception {
        for (int i = 0; i < orgStructureList.size(); ++i) {
            OrgStructureInfo orgStructureInfo = orgStructureList.get(i);
            this.foreachCurrency(ctx, asInfo, orgStructureInfo, currencyColl, periodInfo, contents);
        }
    }

    protected void foreachCurrency(Context ctx, ArchSchemeInfo asInfo, OrgStructureInfo orgStructureInfo, CurrencyEntryCollection currencyColl, PeriodInfo periodInfo, ArcheSchemeContentEntryCollection contents) throws Exception {
        for (int i = 0; i < currencyColl.size(); ++i) {
            CurrencyEntryInfo currencyEntryInfo = currencyColl.get(i);
            this.foreachContents(ctx, asInfo, orgStructureInfo, currencyEntryInfo.getCurrency(), periodInfo, contents);
        }
    }

    protected void foreachContents(Context ctx, ArchSchemeInfo asInfo, OrgStructureInfo orgStructureInfo, CurrencyInfo currency, PeriodInfo periodInfo, ArcheSchemeContentEntryCollection contents) throws Exception {
        for (int i = 0; i < contents.size(); ++i) {
            ArcheSchemeContentEntryInfo archeSchemeContentEntryInfo = contents.get(i);
            RecordBaseInfo archContent = archeSchemeContentEntryInfo.getArchContent();
            if (!StringUtils.isEmpty((String)asInfo.getExportFileType())) {
                archContent.setExportFileType(asInfo.getExportFileType());
            }
            ArcRecordInfo baseArcRecordInfo = this.createBaseArcRecordInfo(ctx, asInfo, archContent, asInfo.getOrg(), periodInfo);
            StringBuilder number = this.getArcRecordNum(asInfo, orgStructureInfo, currency, periodInfo, archeSchemeContentEntryInfo.getArchContent());
            baseArcRecordInfo.setArcRecordNum(number.toString());
            baseArcRecordInfo.setCurrency(currency);
            baseArcRecordInfo.setMergeUnitGroup(orgStructureInfo);
            if (!StringUtils.isEmpty((String)archContent.getPrintTemplate())) {
                TemplateInfo templateInfo = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo("where id = '" + archContent.getPrintTemplate() + "'");
                baseArcRecordInfo.setTemplate(templateInfo);
            }
            FilingInstanceFacadeFactory.getLocalInstance(ctx).getFilingInstance(baseArcRecordInfo).arch(ctx, baseArcRecordInfo, periodInfo);
        }
    }

    protected abstract StringBuilder getArcRecordNum(ArchSchemeInfo var1, OrgStructureInfo var2, CurrencyInfo var3, PeriodInfo var4, RecordBaseInfo var5);

    @Override
    protected ReportFilter getReportFilter(ArcRecordInfo recordInfo) {
        return new ReportFilter(recordInfo);
    }

    @Override
    protected InputStream getFileIS(Context ctx, ReportParsingEngineUtil reportParsingEngineUtil, ReportArchInfo reportArchInfo) throws Exception {
        return null;
    }

    @Override
    protected void putFile(Context ctx, ArcRecordInfo recordInfo, ArchFormatInfo formatInfo, List<XmlBase> mainBills) throws Exception {
        super.putFile(ctx, recordInfo, formatInfo, mainBills);
        for (int i = 0; i < mainBills.size(); ++i) {
            IXmlSrcObj data = mainBills.get(i).getData();
            if (null == data) {
                return;
            }
            Map<String, String> orgBound = data.get("orgBound") instanceof Map ? (Map)data.get("orgBound") : new HashMap();
            Map<String, String> template = data.get("template") instanceof Map ? (Map)data.get("template") : new HashMap();
            orgBound.put("number", recordInfo.getMergeUnitGroup().getUnit().getNumber());
            orgBound.put("name", recordInfo.getMergeUnitGroup().getDisplayName());
            data.put("orgBound", orgBound);
            String fname = "";
            fname = null == recordInfo.getTemplate() ? (recordInfo.getContent().getRptDetailType() == RptDetailType.DXFL ? "\u62b5\u6d88\u5206\u5f55" : "\u8c03\u6574\u5206\u5f55") : recordInfo.getTemplate().getName();
            template.put("name", fname);
            data.put("template", template);
            if (recordInfo.getContent().getRptDetailType() == RptDetailType.DXFL || recordInfo.getContent().getRptDetailType() == RptDetailType.TZFL) continue;
            data.put("orgTree", orgBound);
        }
    }

    @Override
    protected ArcRecordInfo getRecordInfo(Context ctx, String recorId) throws Exception {
        return this.getRecordInfo(ctx, recorId, true);
    }

    @Override
    protected ArcRecordInfo getRecordInfo(Context ctx, String recorId, boolean queryChildRelation) throws Exception {
        ArcRecordInfo recordInfo = super.getRecordInfo(ctx, recorId, queryChildRelation);
        ArchSchemeCollection archSchemeCollection = ArchSchemeFactory.getLocalInstance(ctx).getArchSchemeCollection("select exportFileType where id = '" + recordInfo.getArcSchemeId() + "'");
        if (archSchemeCollection.size() > 0) {
            recordInfo.getContent().setExportFileType(archSchemeCollection.get(0).getExportFileType());
        }
        return recordInfo;
    }

    @Override
    protected void fileUpLoad(Context ctx, ArchFormatInfo archFormatInfo, InputStream is, String fileName) throws Exception {
        CompanyOrgUnitInfo org = archFormatInfo.getRecordInfo().getOrg();
        org.setName(archFormatInfo.getRecordInfo().getMergeUnitGroup().getDisplayName());
        org.setNumber(archFormatInfo.getRecordInfo().getMergeUnitGroup().getUnit().getNumber());
        super.fileUpLoad(ctx, archFormatInfo, is, fileName);
    }

    @Override
    protected void noticeSysReArch(Context ctx, ArcRecordInfo recordInfo) throws Exception {
        CompanyOrgUnitInfo org = recordInfo.getOrg();
        org.setName(recordInfo.getMergeUnitGroup().getDisplayName());
        org.setNumber(recordInfo.getMergeUnitGroup().getUnit().getNumber());
        RecordBaseInfo content = recordInfo.getContent();
        if (!content.getRptDetailType().equals((Object)RptDetailType.DXFL) && !content.getRptDetailType().equals((Object)RptDetailType.TZFL)) {
            content.setName(content.getPrintTemplateName());
        }
        super.noticeSysReArch(ctx, recordInfo);
    }

    @Override
    protected void noticeSysArch(Context ctx, ArchFormatInfo archFormatInfo) {
        CompanyOrgUnitInfo org = archFormatInfo.getRecordInfo().getOrg();
        org.setName(archFormatInfo.getRecordInfo().getMergeUnitGroup().getDisplayName());
        org.setNumber(archFormatInfo.getRecordInfo().getMergeUnitGroup().getUnit().getNumber());
        super.noticeSysArch(ctx, archFormatInfo);
    }
}

