/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.license;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.util.SafeFilterUtils;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LoadLicenseFile {
    public static final String FILE_NAME = "rec_license.properties";
    public static final String REC_CACHE_KEY_NAME = "EL_REC_LICENSE";
    public static Map<String, Properties> REC_LICENSE_CACHE = new HashMap<String, Properties>();

    public static Properties loadProperties(Context ctx) throws IOException {
        if (REC_LICENSE_CACHE.get(REC_CACHE_KEY_NAME) != null) {
            if (ArchConfigUtil.needClearCache(ctx)) {
                REC_LICENSE_CACHE = new HashMap<String, Properties>();
            } else {
                return REC_LICENSE_CACHE.get(REC_CACHE_KEY_NAME);
            }
        }
        Properties properties = null;
        String tmp = System.getProperty("java.security.auth.login.config");
        if (tmp == null) {
            properties = new Properties();
            return properties;
        }
        int i = tmp.lastIndexOf("/");
        if (i < 0) {
            properties = new Properties();
            return properties;
        }
        Properties prop = new Properties();
        String path = tmp.substring(0, i) + File.separator;
        String file = path + FILE_NAME;
        LoadLicenseFile.loadPropertie(file, prop);
        if (prop.size() > 0) {
            REC_LICENSE_CACHE.put(REC_CACHE_KEY_NAME, prop);
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropertie(String file, Properties map) throws IOException {
        String safeFile = SafeFilterUtils.headerManipulation((String)file);
        File f = new File(safeFile);
        if (!f.exists()) {
            return;
        }
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(safeFile);
            properties.load(fis);
        }
        finally {
            if (null != fis) {
                fis.close();
            }
        }
        Enumeration<Object> em = properties.keys();
        while (em.hasMoreElements()) {
            Object key = em.nextElement();
            Object value = properties.get(key);
            if (value instanceof String && value != null && !value.toString().matches("[\u4e00-\u9fa5]+")) {
                try {
                    key = new String(((String)key).getBytes("ISO8859-1"), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                try {
                    value = new String(((String)value).getBytes("ISO8859-1"), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    value = properties.get(key);
                }
            }
            Object object = map.put(key, value);
        }
    }
}

