/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.ArcContentTypeEnum;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.ArchSysLogServiceFacadeFactory;
import com.kingdee.eas.el.rec.BillTypeFactory;
import com.kingdee.eas.el.rec.BillTypeInfo;
import com.kingdee.eas.el.rec.GenerateRechRecordFacadeFactory;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.ReportCycleType;
import com.kingdee.eas.el.rec.model.FileInfo;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.model.ReportArchInfo;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.tool.ArchRecordUtils;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.PeriodUtil;
import com.kingdee.eas.el.rec.tool.RECStringUtil;
import com.kingdee.eas.el.rec.tool.RECUtil;
import com.kingdee.eas.el.rec.tool.engine.CslReportParsingEngineUtil;
import com.kingdee.eas.el.rec.tool.engine.ParsingEngineUtil;
import com.kingdee.eas.el.rec.tool.engine.ReportParsingEngineUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportArchInfos {
    private static Logger logger = Logger.getLogger(ReportArchInfos.class);
    private Context ctx;
    private ReportCycleType reportCycleType;
    private RecordBaseInfo content;
    private CompanyOrgUnitInfo org;
    private PeriodInfo periodInfo;
    private List<XmlBase> reportArchInfos;
    private ArcContentTypeEnum arcContentType;
    private CurrencyInfo currencyInfo;
    private ArcRecordInfo arcRecordInfo;

    public ReportArchInfos(Context ctx, ArcRecordInfo arcRecordInfo) {
        this.ctx = ctx;
        this.arcRecordInfo = arcRecordInfo;
        this.reportArchInfos = new ArrayList<XmlBase>();
        this.reportCycleType = arcRecordInfo.getReportCycleType();
        this.content = arcRecordInfo.getContent();
        this.org = arcRecordInfo.getOrg();
        this.arcContentType = arcRecordInfo.getContent().getRecordType();
        if (arcRecordInfo.getCurrency() != null) {
            try {
                this.currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo(H.PK(arcRecordInfo.getCurrency().getId().toString()));
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        } else {
            logger.error((Object)"\u5f52\u6863\u62a5\u8868--\u5e01\u522bReportArchInfos\u6784\u9020--\u5e01\u522b\u4e3a\u7a7a--2\u53c2\u6570");
        }
    }

    public ReportArchInfos(Context ctx, ReportCycleType reportCycleType, RecordBaseInfo content, CompanyOrgUnitInfo org, PeriodInfo periodInfo, CurrencyInfo currencyInfo) {
        this.ctx = ctx;
        this.reportCycleType = reportCycleType;
        this.content = content;
        this.org = org;
        this.periodInfo = periodInfo;
        this.reportArchInfos = new ArrayList<XmlBase>();
        this.arcContentType = content.getRecordType();
        if (currencyInfo != null) {
            try {
                currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo(H.PK(currencyInfo.getId().toString()));
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            this.currencyInfo = currencyInfo;
        } else {
            logger.error((Object)"\u5f52\u6863\u62a5\u8868--\u5e01\u522bReportArchInfos\u6784\u9020--\u5e01\u522b\u4e3a\u7a7a--\u591a\u53c2\u6570");
        }
    }

    public ReportCycleType getReportCycleType() {
        return this.reportCycleType;
    }

    public void setReportCycleType(ReportCycleType reportCycleType) {
        this.reportCycleType = reportCycleType;
    }

    public RecordBaseInfo getContent() {
        return this.content;
    }

    public void setContent(RecordBaseInfo content) {
        this.content = content;
    }

    public CompanyOrgUnitInfo getOrg() {
        return this.org;
    }

    public void setOrg(CompanyOrgUnitInfo org) {
        this.org = org;
    }

    public PeriodInfo getPeriodInfo() {
        return this.periodInfo;
    }

    public void setPeriodInfo(PeriodInfo periodInfo) {
        this.periodInfo = periodInfo;
    }

    public List<XmlBase> getReportArchInfos() {
        return this.reportArchInfos;
    }

    public void setReportArchInfos(List<XmlBase> reportArchInfos) {
        this.reportArchInfos = reportArchInfos;
    }

    public void initReportArchInfos() throws Exception {
        try {
            BillTypeInfo billType = this.content.getBillType();
            String billTypeNumber = null;
            if (billType.getNumber() == null) {
                billType = BillTypeFactory.getLocalInstance(this.ctx).getBillTypeInfo(H.PK(billType.getId()));
                this.content.setBillType(billType);
                billTypeNumber = billType.getNumber();
            } else {
                billTypeNumber = billType.getNumber();
            }
            if (this.content.getRecordType().getValue().equals("otherReport")) {
                this.initOtherReportArchInfo();
                return;
            }
            if (this.content.getRecordType().getValue().equals("rptsReport") || this.content.getRecordType().getValue().equals("qmsReport")) {
                try {
                    this.initRptReportArchInfo();
                }
                catch (Exception e) {
                    ArchSysLogServiceFacadeFactory.getLocalInstance(this.ctx).writeArcSchLog(this.arcRecordInfo.getId().toString(), ArcStateEnum.ARC_FAIL, e.getMessage(), RECStringUtil.exception2String(e));
                    ArchRecordUtils.writeReportLog(this.ctx, this.arcRecordInfo.getId().toString());
                }
                return;
            }
            if (this.content.getRecordType().getValue().equals("qmsReport")) {
                return;
            }
            if ("Subledger".equals(billTypeNumber)) {
                this.doSubledger();
                return;
            }
            ReportArchInfo reportArchInfo = new ReportArchInfo();
            reportArchInfo.setDataCenter(this.ctx.getAIS());
            reportArchInfo.setReportCycleType(this.reportCycleType.getName());
            this.reportArchInfos.add(reportArchInfo);
            reportArchInfo.setDocType(this.content.getXmlDocType());
            String fileName = this.content.getBillType().getNumber() + "_" + this.org.getNumber() + "_" + this.periodInfo.getNumber() + "_" + this.currencyInfo.getIsoCode() + RECUtil.getReportFileType(this.content);
            reportArchInfo.addFileInfo(new FileInfo(null, fileName, fileName));
            PeriodCollection perCol = PeriodUtil.transformToPeriods(this.ctx, this.periodInfo, this.reportCycleType, this.org);
            this.periodInfo.setBeginDate(perCol.get(0).getBeginDate());
            this.periodInfo.setEndDate(perCol.get(perCol.size() - 1).getEndDate());
            ReportFilter reportFilter = new ReportFilter();
            reportFilter.setRecordBaseInfo(this.content);
            reportFilter.setReportCycleType(this.reportCycleType);
            reportFilter.setOrgId(this.org.getId().toString());
            reportFilter.setYear(String.valueOf(this.periodInfo.getPeriodYear()));
            reportFilter.setPeriod(String.valueOf(this.periodInfo.getPeriodNumber()));
            reportFilter.setCurrency(this.currencyInfo);
            reportFilter.setExportFileType(this.content.getExportFileType());
            IXmlSrcObj iXmlSrcObjs = null;
            try {
                iXmlSrcObjs = ((ReportParsingEngineUtil)ParsingEngineUtil.getInstance(this.ctx, this.content)).getReportDataSources(this.ctx, reportFilter);
                reportArchInfo.setData(iXmlSrcObjs);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                GenerateRechRecordFacadeFactory.getLocalInstance(this.ctx).genReportArchRecord(this);
                ReportArchInfo report = (ReportArchInfo)this.reportArchInfos.get(0);
                String reportId = report.getRecordId();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("state"));
                sic.add(new SelectorItemInfo("lastUpdateTime"));
                ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
                arcRecordInfo.setId(BOSUuid.read((String)report.getRecordId()));
                arcRecordInfo.setState(ArcStateEnum.ARC_FAIL);
                arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                ArcRecordFactory.getLocalInstance(this.ctx).updatePartial(arcRecordInfo, sic);
                ArchSysLogServiceFacadeFactory.getLocalInstance(this.ctx).writeArcSchLog(reportId, ArcStateEnum.ARC_FAIL, e.getMessage(), RECStringUtil.exception2String(e));
                ArchRecordUtils.writeReportLog(this.ctx, reportId);
                return;
            }
            if (null == iXmlSrcObjs) {
                logger.error((Object)("iXmlSrcObjs is null[\u65e0\u6570\u636e],reportFilter:" + reportFilter.toString()));
                if (this.periodInfo.getPeriodNumber() > 12) {
                    logger.error((Object)("iXmlSrcObjs is null[\u5927\u4e8e12\u671f\u7684\u6ca1\u6709\u6570\u636e\u4e0d\u5b58\u50a8],reportFilter:" + reportFilter.toString()));
                } else {
                    GenerateRechRecordFacadeFactory.getLocalInstance(this.ctx).genReportArchRecord(this);
                    ReportArchInfo report = (ReportArchInfo)this.reportArchInfos.get(0);
                    String reportId = report.getRecordId();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("state"));
                    sic.add(new SelectorItemInfo("lastUpdateTime"));
                    ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
                    arcRecordInfo.setId(BOSUuid.read((String)reportId));
                    arcRecordInfo.setState(ArcStateEnum.ARC_NODATA);
                    arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                    ArcRecordFactory.getLocalInstance(this.ctx).updatePartial(arcRecordInfo, sic);
                }
            } else {
                GenerateRechRecordFacadeFactory.getLocalInstance(this.ctx).genReportArchRecord(this);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                GenerateRechRecordFacadeFactory.getLocalInstance(this.ctx).genReportArchRecord(this);
                ReportArchInfo report = (ReportArchInfo)this.reportArchInfos.get(0);
                String reportId = report.getRecordId();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("state"));
                sic.add(new SelectorItemInfo("lastUpdateTime"));
                ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
                arcRecordInfo.setId(BOSUuid.read((String)reportId));
                arcRecordInfo.setState(ArcStateEnum.ARC_FAIL);
                arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                ArcRecordFactory.getLocalInstance(this.ctx).updatePartial(arcRecordInfo, sic);
                ArchSysLogServiceFacadeFactory.getLocalInstance(this.ctx).writeArcSchLog(reportId, ArcStateEnum.ARC_FAIL, e.getMessage(), RECStringUtil.exception2String(e));
                ArchRecordUtils.writeReportLog(this.ctx, reportId);
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private void initRptReportArchInfo() throws Exception {
        RecordBaseInfo content = this.arcRecordInfo.getContent();
        BillTypeInfo billType = content.getBillType();
        if (billType.getNumber() == null) {
            billType = BillTypeFactory.getLocalInstance(this.ctx).getBillTypeInfo(H.PK(billType.getId()));
            content.setBillType(billType);
        }
        ReportFilter reportFilter = new ReportFilter(this.arcRecordInfo);
        IXmlSrcObj iXmlSrcObjs = ((CslReportParsingEngineUtil)ParsingEngineUtil.getInstance(this.ctx, content)).getReportDataSources(this.ctx, reportFilter);
        if (null == iXmlSrcObjs) {
            ReportArchInfos.updateArcRecord(this.ctx, this.arcRecordInfo, ArcStateEnum.ARC_NODATA);
            return;
        }
        ReportArchInfo reportArchInfo = new ReportArchInfo();
        reportArchInfo.setDataCenter(this.ctx.getAIS());
        reportArchInfo.setReportCycleType(this.reportCycleType.getName());
        this.reportArchInfos.add(reportArchInfo);
        reportArchInfo.setId(this.arcRecordInfo.getId().toString());
        reportArchInfo.setDocType(content.getXmlDocType());
        reportArchInfo.setData(iXmlSrcObjs);
        String fileName = this.arcRecordInfo.getArcRecordNum() + RECUtil.getReportFileType(content);
        reportArchInfo.addFileInfo(new FileInfo(null, fileName, fileName));
    }

    public static void updateArcRecord(Context ctx, ArcRecordInfo record, ArcStateEnum state) throws EASBizException, BOSException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        record.setLastUpdateUser(userInfo);
        record.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        record.setState(state);
        ArcRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)record);
    }

    private void initOtherReportArchInfo() {
        try {
            BillTypeInfo billType = this.content.getBillType();
            if (billType.getNumber() == null) {
                billType = BillTypeFactory.getLocalInstance(this.ctx).getBillTypeInfo(H.PK(billType.getId()));
                this.content.setBillType(billType);
            }
            ReportArchInfo reportArchInfo = new ReportArchInfo();
            reportArchInfo.setDataCenter(this.ctx.getAIS());
            reportArchInfo.setReportCycleType(this.reportCycleType.getName());
            this.reportArchInfos.add(reportArchInfo);
            reportArchInfo.setDocType(this.content.getXmlDocType());
            String fileName = this.content.getBillType().getNumber() + "_" + this.org.getNumber() + "_" + this.periodInfo.getNumber() + RECUtil.getReportFileType(this.content);
            reportArchInfo.addFileInfo(new FileInfo(null, fileName, fileName));
            ReportFilter reportFilter = new ReportFilter();
            reportFilter.setRecordBaseInfo(this.content);
            reportFilter.setReportCycleType(this.reportCycleType);
            reportFilter.setOrgId(this.org.getId().toString());
            reportFilter.setYear(String.valueOf(this.periodInfo.getPeriodYear()));
            reportFilter.setPeriod(String.valueOf(this.periodInfo.getPeriodNumber()));
            reportFilter.setCurrency(this.currencyInfo);
            reportFilter.setExportFileType(this.content.getExportFileType());
            IXmlSrcObj iXmlSrcObjs = null;
            try {
                iXmlSrcObjs = ((ReportParsingEngineUtil)ParsingEngineUtil.getInstance(this.ctx, this.content)).getReportDataSources(this.ctx, reportFilter);
                reportArchInfo.setData(iXmlSrcObjs);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                GenerateRechRecordFacadeFactory.getLocalInstance(this.ctx).genReportArchRecord(this);
                ReportArchInfo report = (ReportArchInfo)this.reportArchInfos.get(0);
                String reportId = report.getRecordId();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("state"));
                sic.add(new SelectorItemInfo("lastUpdateTime"));
                ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
                arcRecordInfo.setId(BOSUuid.read((String)report.getRecordId()));
                arcRecordInfo.setState(ArcStateEnum.ARC_FAIL);
                arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                ArcRecordFactory.getLocalInstance(this.ctx).updatePartial(arcRecordInfo, sic);
                ArchSysLogServiceFacadeFactory.getLocalInstance(this.ctx).writeArcSchLog(reportId, ArcStateEnum.ARC_FAIL, e.getMessage(), RECStringUtil.exception2String(e));
                ArchRecordUtils.writeReportLog(this.ctx, reportId);
                return;
            }
            if (null == iXmlSrcObjs) {
                logger.error((Object)("iXmlSrcObjs is null[\u65e0\u6570\u636e],reportFilter:" + reportFilter.toString()));
                GenerateRechRecordFacadeFactory.getLocalInstance(this.ctx).genReportArchRecord(this);
                ReportArchInfo report = (ReportArchInfo)this.reportArchInfos.get(0);
                String reportId = report.getRecordId();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("state"));
                sic.add(new SelectorItemInfo("lastUpdateTime"));
                ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
                arcRecordInfo.setId(BOSUuid.read((String)reportId));
                arcRecordInfo.setState(ArcStateEnum.ARC_NODATA);
                arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                ArcRecordFactory.getLocalInstance(this.ctx).updatePartial(arcRecordInfo, sic);
            } else {
                GenerateRechRecordFacadeFactory.getLocalInstance(this.ctx).genReportArchRecord(this);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                GenerateRechRecordFacadeFactory.getLocalInstance(this.ctx).genReportArchRecord(this);
                ReportArchInfo report = (ReportArchInfo)this.reportArchInfos.get(0);
                String reportId = report.getRecordId();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("state"));
                sic.add(new SelectorItemInfo("lastUpdateTime"));
                ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
                arcRecordInfo.setId(BOSUuid.read((String)reportId));
                arcRecordInfo.setState(ArcStateEnum.ARC_FAIL);
                arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                ArcRecordFactory.getLocalInstance(this.ctx).updatePartial(arcRecordInfo, sic);
                ArchSysLogServiceFacadeFactory.getLocalInstance(this.ctx).writeArcSchLog(reportId, ArcStateEnum.ARC_FAIL, e.getMessage(), RECStringUtil.exception2String(e));
                ArchRecordUtils.writeReportLog(this.ctx, reportId);
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private Map<String, AccountViewInfo> getAccountIdByOrg(CompanyOrgUnitInfo company) throws BOSException {
        String companyId = company.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("companyId", (Object)companyId));
        view.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("accountcurrency.*");
        view.setSelector(sic);
        HashMap<String, AccountViewInfo> results = null;
        AccountViewCollection acs = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewCollection(view);
        if (acs != null && acs.size() > 0) {
            results = new HashMap<String, AccountViewInfo>();
            int size = acs.size();
            for (int i = 0; i < size; ++i) {
                AccountViewInfo ac = acs.get(i);
                results.put(ac.getId().toString(), ac);
            }
        }
        return results;
    }

    private void doSubledger() throws Exception {
        try {
            Map<String, AccountViewInfo> acIdSets = this.getAccountIdByOrg(this.org);
            if (acIdSets == null || acIdSets.size() == 0) {
                logger.error((Object)" doSubledger getAccoountIdByOrg is null or size is 0");
                GenerateRechRecordFacadeFactory.getLocalInstance(this.ctx).genReportArchRecord(this);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("state"));
                sic.add(new SelectorItemInfo("lastUpdateTime"));
                ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
                arcRecordInfo.setId(BOSUuid.read((String)this.reportArchInfos.get(0).getId()));
                arcRecordInfo.setState(ArcStateEnum.ARC_NODATA);
                arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                ArcRecordFactory.getLocalInstance(this.ctx).updatePartial(arcRecordInfo, sic);
                return;
            }
            PeriodCollection perCol = PeriodUtil.transformToPeriods(this.ctx, this.periodInfo, this.reportCycleType, this.org);
            this.periodInfo.setBeginDate(perCol.get(0).getBeginDate());
            this.periodInfo.setEndDate(perCol.get(perCol.size() - 1).getEndDate());
            ReportFilter reportFilter = new ReportFilter();
            reportFilter.setRecordBaseInfo(this.content);
            reportFilter.setReportCycleType(this.reportCycleType);
            reportFilter.setOrgId(this.org.getId().toString());
            reportFilter.setYear(String.valueOf(this.periodInfo.getPeriodYear()));
            reportFilter.setPeriod(String.valueOf(this.periodInfo.getPeriodNumber()));
            reportFilter.setCurrency(this.currencyInfo);
            reportFilter.setExportFileType(this.content.getExportFileType());
            HashSet<String> accountIds = null;
            int count = 0;
            StringBuffer buffer = new StringBuffer(1000);
            for (String accountId : acIdSets.keySet()) {
                AccountViewInfo accountViewInfo = acIdSets.get(accountId);
                ReportArchInfo reportArchInfo = new ReportArchInfo();
                reportArchInfo.setDataCenter(this.ctx.getAIS());
                reportArchInfo.setReportCycleType(this.reportCycleType.getName());
                reportArchInfo.setDocType(this.content.getXmlDocType());
                String fileName = this.content.getBillType().getNumber() + "_" + this.org.getNumber() + "_" + this.periodInfo.getNumber() + "_" + ++count + "_" + accountViewInfo.getNumber() + "_" + this.currencyInfo.getIsoCode() + RECUtil.getReportFileType(this.content);
                reportArchInfo.addFileInfo(new FileInfo(null, fileName, fileName));
                accountIds = new HashSet<String>();
                accountIds.add(accountId);
                reportFilter.setAcIdSet(accountIds);
                reportFilter.setAccountName(acIdSets.get(accountId).getName());
                reportFilter.setAccountNumber(acIdSets.get(accountId).getNumber());
                IXmlSrcObj iXmlSrcObjs = null;
                try {
                    iXmlSrcObjs = ((ReportParsingEngineUtil)ParsingEngineUtil.getInstance(this.ctx, this.content)).getReportDataSources(this.ctx, reportFilter);
                    if (iXmlSrcObjs == null && (this.reportArchInfos.size() != 0 || acIdSets.size() != count)) continue;
                    reportArchInfo.setData(iXmlSrcObjs);
                    this.reportArchInfos.add(reportArchInfo);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    buffer.append(e.getMessage());
                }
            }
            if (this.reportArchInfos == null || this.reportArchInfos.size() < 1) {
                logger.error((Object)("iXmlSrcObjs is null or size=0[\u65e0\u6570\u636e],reportFilter:" + reportFilter.toString()));
                if (this.periodInfo.getPeriodNumber() <= 12) {
                    ArcRecordInfo arcRecordInfo;
                    SelectorItemCollection sic;
                    String reportId;
                    ReportArchInfo report;
                    if (!StringUtils.isEmpty((String)buffer.toString())) {
                        GenerateRechRecordFacadeFactory.getLocalInstance(this.ctx).genReportArchRecord(this);
                        report = (ReportArchInfo)this.reportArchInfos.get(0);
                        reportId = report.getRecordId();
                        sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("state"));
                        sic.add(new SelectorItemInfo("lastUpdateTime"));
                        arcRecordInfo = new ArcRecordInfo();
                        arcRecordInfo.setId(BOSUuid.read((String)reportId));
                        arcRecordInfo.setState(ArcStateEnum.ARC_FAIL);
                        arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                        ArcRecordFactory.getLocalInstance(this.ctx).updatePartial(arcRecordInfo, sic);
                        ArchSysLogServiceFacadeFactory.getLocalInstance(this.ctx).writeArcSchLog(reportId, ArcStateEnum.ARC_FAIL, buffer.toString(), buffer.toString());
                        ArchRecordUtils.writeReportLog(this.ctx, reportId);
                    } else {
                        GenerateRechRecordFacadeFactory.getLocalInstance(this.ctx).genReportArchRecord(this);
                        report = (ReportArchInfo)this.reportArchInfos.get(0);
                        reportId = report.getRecordId();
                        sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("state"));
                        sic.add(new SelectorItemInfo("lastUpdateTime"));
                        arcRecordInfo = new ArcRecordInfo();
                        arcRecordInfo.setId(BOSUuid.read((String)reportId));
                        arcRecordInfo.setState(ArcStateEnum.ARC_NODATA);
                        arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                        ArcRecordFactory.getLocalInstance(this.ctx).updatePartial(arcRecordInfo, sic);
                    }
                }
            } else {
                GenerateRechRecordFacadeFactory.getLocalInstance(this.ctx).genReportArchRecord(this);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                GenerateRechRecordFacadeFactory.getLocalInstance(this.ctx).genReportArchRecord(this);
                ReportArchInfo report = (ReportArchInfo)this.reportArchInfos.get(0);
                String reportId = report.getRecordId();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("state"));
                sic.add(new SelectorItemInfo("lastUpdateTime"));
                ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
                arcRecordInfo.setId(BOSUuid.read((String)reportId));
                arcRecordInfo.setState(ArcStateEnum.ARC_FAIL);
                arcRecordInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                ArcRecordFactory.getLocalInstance(this.ctx).updatePartial(arcRecordInfo, sic);
                ArchSysLogServiceFacadeFactory.getLocalInstance(this.ctx).writeArcSchLog(reportId, ArcStateEnum.ARC_FAIL, e.getMessage(), RECStringUtil.exception2String(e));
                ArchRecordUtils.writeReportLog(this.ctx, reportId);
            }
            catch (Exception e1) {
                logger.error((Object)e);
            }
        }
    }

    public ArcContentTypeEnum getArcContentType() {
        return this.arcContentType;
    }

    public void setArcContentType(ArcContentTypeEnum arcContentType) {
        this.arcContentType = arcContentType;
    }

    public void setCurrencyInfo(CurrencyInfo currencyInfo) {
        this.currencyInfo = currencyInfo;
    }

    public CurrencyInfo getCurrencyInfo() {
        return this.currencyInfo;
    }

    public ArcRecordInfo getArcRecordInfo() {
        return this.arcRecordInfo;
    }
}

