/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.model.dataprovider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.AssistActItemInfo;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaFromUnitCatEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FaCurCardPrintCardDataProvider
implements BOSQueryDelegate {
    private Context ctx = null;
    private Set ids = null;
    private IMetaDataPK qpk = null;
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private String companyId = null;
    private int currencyScale = 2;
    private String[] numbers = new String[]{"FA_025", "FA_008", "FA_030"};
    String[] fieldKey = new String[]{"inputTax", "assetValue", "buyValue", "buyAccuDepr", "initEvalValue", "accuDepr", "accuDeprTYear", "neatRemValue", "decValue", "neatValue", "neatAmt", "accuDeprAll", "addonFare", "fairValue", "treatmentIncome", "addons"};

    public FaCurCardPrintCardDataProvider(Context ctx, List id, IMetaDataPK qpk) {
        this.ctx = ctx;
        this.ids = new HashSet(id);
        this.qpk = qpk;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)this.qpk);
            exec.option().isAutoTranslateEnum = true;
            EntityViewInfo ev = new EntityViewInfo();
            ev.setSelector(this.getPrintQuerySelectors());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
            ev.setFilter(filter);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            IFaCurCard iFaCurCard = FaCurCardFactory.getLocalInstance((Context)this.ctx);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            while (iRowSet.next()) {
                Object isUseGroupNumber;
                String currDate = dateFormat.format(new Date());
                iRowSet.updateString("printdate", currDate);
                UserInfo personInfo = UserFactory.getLocalInstance((Context)this.ctx).getUserInfo(this.ctx.getCaller());
                iRowSet.updateString("operator", personInfo.getName());
                String companyId = iRowSet.getString("company.id");
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("baseCurrency.*"));
                sic.add(new SelectorItemInfo("baseCurrency.precision"));
                CompanyOrgUnitInfo curCompanyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
                int baseCurrencyScale = curCompanyInfo.getBaseCurrency().getPrecision();
                String id = iRowSet.getString("id");
                FaCurCardInfo cardInfo = (FaCurCardInfo)iFaCurCard.getValue((IObjectPK)new ObjectUuidPK(id), this.getSelector());
                FaCurCostCenterCollection collection = cardInfo.getFaCurCostCenter();
                StringBuffer costCenterName = new StringBuffer();
                for (int i = 0; i < collection.size(); ++i) {
                    FaCurCostCenterInfo costCenter = collection.get(i);
                    String account = costCenter.getAccountView() == null ? "" : costCenter.getAccountView().getNumber() + "-" + costCenter.getAccountView().getLongName();
                    String scale = costCenter.getApportionScale() == null ? "" : costCenter.getApportionScale().toString() + "%";
                    costCenterName.append(i == 0 ? "" : "; ").append("".equals(account) ? "" : account).append(" ").append(scale).append(" ").append(this.getAsstActLName((FaCostCenterInfo)collection.get(i)));
                }
                if (!"".equals(costCenterName.toString().trim())) {
                    iRowSet.updateString("facurcostcenter.asstActType.name", costCenterName.toString());
                } else {
                    iRowSet.updateString("facurcostcenter.asstActType.name", "");
                }
                HashMap hmParam = FaManageUtils.getFAParameter((Context)this.ctx, (String[])this.numbers, (String)companyId);
                String isDisDeptLName = hmParam.get("FA_025") == null ? "false" : (String)hmParam.get("FA_025");
                FaCurDepartmentCollection departmentColl = cardInfo.getFaCurDepartment();
                StringBuffer departmentsName = new StringBuffer();
                StringBuffer departmentsUsePerson = new StringBuffer();
                int size = departmentColl.size();
                for (int i = 0; i < size; ++i) {
                    FaCurDepartmentInfo departmentInfo = departmentColl.get(i);
                    if (departmentInfo != null && departmentInfo.getUseDepartment() != null) {
                        if ("true".equalsIgnoreCase(isDisDeptLName)) {
                            departmentsName.append(departmentInfo.getUseDepartment().getDisplayName());
                        } else {
                            departmentsName.append(departmentInfo.getUseDepartment().getName());
                        }
                        departmentsName.append("/");
                    }
                    if (departmentInfo == null || departmentInfo.getUsePerson() == null) continue;
                    departmentsUsePerson.append(departmentInfo.getUsePerson().getName());
                    departmentsUsePerson.append("/");
                }
                if (departmentsName.length() > 0) {
                    String departments = departmentsName.substring(0, departmentsName.length() - 1);
                    iRowSet.updateString("facurdepartment.usedepartment.name", departments);
                } else {
                    iRowSet.updateString("facurdepartment.usedepartment.name", "");
                }
                if (departmentsUsePerson.length() > 0) {
                    String personName = departmentsUsePerson.substring(0, departmentsUsePerson.length() - 1);
                    iRowSet.updateString("facurdepartment.useperson.name", personName);
                } else {
                    iRowSet.updateString("facurdepartment.useperson.name", "");
                }
                String accAssetNumber = iRowSet.getString("accountasset.number");
                String accAssetLongName = iRowSet.getString("accountasset.longName");
                if (accAssetNumber != null && accAssetLongName != null) {
                    iRowSet.updateString("accountasset.name", accAssetNumber + "-" + accAssetLongName);
                } else {
                    iRowSet.updateString("accountasset.name", "");
                }
                String accAccuDeprNumber = iRowSet.getString("accountaccudepr.number");
                String accAccuDeprLongName = iRowSet.getString("accountaccudepr.longName");
                if (accAccuDeprNumber != null && accAccuDeprLongName != null) {
                    iRowSet.updateString("accountaccudepr.name", accAccuDeprNumber + "-" + accAccuDeprLongName);
                } else {
                    iRowSet.updateString("accountaccudepr.name", "");
                }
                String accDecValueNumber = iRowSet.getString("accountdecvalue.number");
                String accDecValueLongName = iRowSet.getString("accountdecvalue.longName");
                if (accDecValueNumber != null && accDecValueLongName != null) {
                    iRowSet.updateString("accountdecvalue.name", accDecValueNumber + "-" + accDecValueLongName);
                } else {
                    iRowSet.updateString("accountdecvalue.name", "");
                }
                int quantityScale = Integer.valueOf(hmParam.get("FA_008") == null ? "0" : (String)hmParam.get("FA_008"));
                BigDecimal assetAmt = iRowSet.getBigDecimal("assetAmt");
                iRowSet.updateBigDecimal("assetAmt", assetAmt.setScale(quantityScale, 4));
                int currencyScale = 2;
                currencyScale = iRowSet.getInt("currency.precision");
                BigDecimal originAmt = iRowSet.getBigDecimal("originAmt");
                if (originAmt != null) {
                    iRowSet.updateBigDecimal("originAmt", originAmt.setScale(currencyScale, 4));
                } else {
                    iRowSet.updateBigDecimal("originAmt", ZERO);
                }
                for (int i = 0; i < this.fieldKey.length; ++i) {
                    if (iRowSet.getBigDecimal(this.fieldKey[i]) != null) {
                        iRowSet.updateBigDecimal(this.fieldKey[i], iRowSet.getBigDecimal(this.fieldKey[i]).setScale(baseCurrencyScale, 4));
                        continue;
                    }
                    iRowSet.updateBigDecimal(this.fieldKey[i], ZERO);
                }
                boolean isWorkload = iRowSet.getBoolean("deprmethod.isWorkload");
                if (isWorkload) {
                    if (iRowSet.getBigDecimal("evalLeftPeriod") != null) {
                        iRowSet.updateBigDecimal("evalLeftPeriod", iRowSet.getBigDecimal("evalLeftPeriod").setScale(2));
                    }
                    if (iRowSet.getBigDecimal("useTermCount") != null) {
                        iRowSet.updateBigDecimal("useTermCount", iRowSet.getBigDecimal("useTermCount").setScale(2));
                    }
                    if (iRowSet.getBigDecimal("deprTermCount") != null) {
                        iRowSet.updateBigDecimal("deprTermCount", iRowSet.getBigDecimal("deprTermCount").setScale(2));
                    }
                } else {
                    iRowSet.updateBigDecimal("evalLeftPeriod", iRowSet.getBigDecimal("evalLeftPeriod").setScale(0, 4));
                    iRowSet.updateBigDecimal("useTermCount", iRowSet.getBigDecimal("useTermCount").setScale(0, 4));
                    iRowSet.updateBigDecimal("deprTermCount", iRowSet.getBigDecimal("deprTermCount").setScale(0, 4));
                }
                if (iRowSet.getBigDecimal("neatLeftRate") != null) {
                    iRowSet.updateBigDecimal("neatLeftRate", iRowSet.getBigDecimal("neatLeftRate").setScale(2, 4));
                } else {
                    iRowSet.updateBigDecimal("neatLeftRate", ZERO);
                }
                String currencyId = iRowSet.getString("currency.id");
                CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                int exRateScale = Utils.getExchangRateScale(this.ctx, currencyInfo, Utils.getBaseCurrency(this.ctx, companyId), curCompanyInfo);
                if (iRowSet.getBigDecimal("exRate") != null) {
                    iRowSet.updateBigDecimal("exRate", iRowSet.getBigDecimal("exRate").setScale(exRateScale, 4));
                }
                if (!(hmParam == null || (isUseGroupNumber = hmParam.get("FA_030")) != null && Boolean.valueOf(isUseGroupNumber.toString()).booleanValue())) {
                    iRowSet.updateString("groupNumber", "");
                }
                if (cardInfo.getOriginType() != null) {
                    iRowSet.updateString("originType", cardInfo.getOriginType().toString());
                } else {
                    iRowSet.updateString("originType", "");
                }
                iRowSet.updateString("originunit", FaCurCardPrintCardDataProvider.transferFromUnit(this.ctx, (FaCardInfo)cardInfo));
            }
            iRowSet.beforeFirst();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return iRowSet;
    }

    private SelectorItemCollection getPrintQuerySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("assetcat.name"));
        sic.add(new SelectorItemInfo("assetamt"));
        sic.add(new SelectorItemInfo("measureunit.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("barCode"));
        sic.add(new SelectorItemInfo("assetname"));
        sic.add(new SelectorItemInfo("accountdate"));
        sic.add(new SelectorItemInfo("storecity.name"));
        sic.add(new SelectorItemInfo("economicPurp.name"));
        sic.add(new SelectorItemInfo("specs"));
        sic.add(new SelectorItemInfo("parea"));
        sic.add(new SelectorItemInfo("mfr"));
        sic.add(new SelectorItemInfo("levfrdate"));
        sic.add(new SelectorItemInfo("paperno"));
        sic.add(new SelectorItemInfo("dept.name"));
        sic.add(new SelectorItemInfo("keeper.name"));
        sic.add(new SelectorItemInfo("origintype"));
        sic.add(new SelectorItemInfo("originunit"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("originmethod.name"));
        sic.add(new SelectorItemInfo("useStatus.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("originamt"));
        sic.add(new SelectorItemInfo("treatmentIncome"));
        sic.add(new SelectorItemInfo("fairValue"));
        sic.add(new SelectorItemInfo("addons"));
        sic.add(new SelectorItemInfo("exrate"));
        sic.add(new SelectorItemInfo("assetvalue"));
        sic.add(new SelectorItemInfo("buyvalue"));
        sic.add(new SelectorItemInfo("initEvalValue"));
        sic.add(new SelectorItemInfo("evalLeftPeriod"));
        sic.add(new SelectorItemInfo("accuDeprAll"));
        sic.add(new SelectorItemInfo("buyaccudepr"));
        sic.add(new SelectorItemInfo("useyears"));
        sic.add(new SelectorItemInfo("deliverdate"));
        sic.add(new SelectorItemInfo("startusedate"));
        sic.add(new SelectorItemInfo("usetermcount"));
        sic.add(new SelectorItemInfo("deprtermcount"));
        sic.add(new SelectorItemInfo("accudepr"));
        sic.add(new SelectorItemInfo("neatremvalue"));
        sic.add(new SelectorItemInfo("accudeprtyear"));
        sic.add(new SelectorItemInfo("decvalue"));
        sic.add(new SelectorItemInfo("deprmethod.number"));
        sic.add(new SelectorItemInfo("deprmethod.name"));
        sic.add(new SelectorItemInfo("deprmethod.isWorkload"));
        sic.add(new SelectorItemInfo("measureunitwl.name"));
        sic.add(new SelectorItemInfo("neatvalue"));
        sic.add(new SelectorItemInfo("neatamt"));
        sic.add(new SelectorItemInfo("accountasset.name"));
        sic.add(new SelectorItemInfo("accountasset.number"));
        sic.add(new SelectorItemInfo("accountasset.longName"));
        sic.add(new SelectorItemInfo("accountaccudepr.name"));
        sic.add(new SelectorItemInfo("accountaccudepr.number"));
        sic.add(new SelectorItemInfo("accountaccudepr.longName"));
        sic.add(new SelectorItemInfo("accountdecvalue.name"));
        sic.add(new SelectorItemInfo("accountdecvalue.number"));
        sic.add(new SelectorItemInfo("accountdecvalue.longName"));
        sic.add(new SelectorItemInfo("faCurDepartment.id"));
        sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.number"));
        sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.name"));
        sic.add(new SelectorItemInfo("faCurDepartment.usePerson.number"));
        sic.add(new SelectorItemInfo("faCurDepartment.usePerson.name"));
        sic.add(new SelectorItemInfo("facurfacility.facilitynumber"));
        sic.add(new SelectorItemInfo("facurfacility.id"));
        sic.add(new SelectorItemInfo("facurfacility.facilityname"));
        sic.add(new SelectorItemInfo("facurfacility.facilitymodel"));
        sic.add(new SelectorItemInfo("facurfacility.registerdate"));
        sic.add(new SelectorItemInfo("facurfacility.quantity"));
        sic.add(new SelectorItemInfo("facurfacility.amount"));
        sic.add(new SelectorItemInfo("facurfacility.remark"));
        sic.add(new SelectorItemInfo("facurfacility.measureunit.name"));
        sic.add(new SelectorItemInfo("facurfacility.storeplace.name"));
        sic.add(new SelectorItemInfo("facurfacility.keeper.name"));
        sic.add(new SelectorItemInfo("facurcostcenter.apportionscale"));
        sic.add(new SelectorItemInfo("facurcostcenter.id"));
        sic.add(new SelectorItemInfo("facurcostcenter.accountview.name"));
        sic.add(new SelectorItemInfo("facurcostcenter.asstActType.name"));
        sic.add(new SelectorItemInfo("facurcostcenter.asstActItem.name"));
        sic.add(new SelectorItemInfo("facurcostcenter.remark"));
        sic.add(new SelectorItemInfo("neatLeftRate"));
        sic.add(new SelectorItemInfo("fiAccountDate"));
        sic.add(new SelectorItemInfo("addonFare"));
        sic.add(new SelectorItemInfo("oldNumber"));
        sic.add(new SelectorItemInfo("groupNumber"));
        sic.add(new SelectorItemInfo("inputTax"));
        sic.add(new SelectorItemInfo("creator.name", "operator"));
        sic.add(new SelectorItemInfo("creator.number", "printdate"));
        return sic;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("faCurCostCenter.seq"));
        sic.add(new SelectorItemInfo("faCurCostCenter.apportionScale"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.id"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.number"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.name"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.id"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.number"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.name"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.isLeaf"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.longName"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.id"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.number"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
        sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.id"));
        sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.name"));
        sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.number"));
        sic.add(new SelectorItemInfo("faCurDepartment.usePerson.id"));
        sic.add(new SelectorItemInfo("faCurDepartment.usePerson.name"));
        sic.add(new SelectorItemInfo("faCurDepartment.usePerson.number"));
        sic.add(new SelectorItemInfo("faCurDepartment.usage"));
        sic.add(new SelectorItemInfo("faCurDepartment.remark"));
        sic.add(new SelectorItemInfo("faCurDepartment.id"));
        sic.add(new SelectorItemInfo("originType"));
        sic.add(new SelectorItemInfo("originUnit"));
        return sic;
    }

    private String getAsstActLName(FaCostCenterInfo costCenterInfo) {
        FaCurCostCenterInfo curCostCenter = (FaCurCostCenterInfo)costCenterInfo;
        int size = curCostCenter.getFaCurAsstActComposit().size();
        StringBuffer asstActLName = new StringBuffer("");
        for (int i = 0; i < size; ++i) {
            String asstTypeName = "";
            AsstActTypeInfo asstType = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActType();
            if (asstType != null && asstType.getName() != null) {
                asstTypeName = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActType().getName();
            }
            String asstItemName = "";
            AssistActItemInfo asstItem = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActItem();
            if (asstItem != null && asstItem.getName() != null) {
                asstItemName = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActItem().getName();
            }
            asstActLName.append(asstTypeName);
            asstActLName.append("-");
            asstActLName.append(asstItemName);
            if (i == size - 1) continue;
            asstActLName.append("/");
        }
        return asstActLName.toString();
    }

    private static String transferFromUnit(Context ctx, FaCardInfo cardInfo) {
        FaFromUnitCatEnum item = cardInfo.getOriginType();
        String id = cardInfo.getOriginUnit();
        if (id == null || id.equals("")) {
            return "";
        }
        if ((id = id.trim()).equals("")) {
            return "";
        }
        BOSUuid uuid = null;
        try {
            uuid = BOSUuid.read((String)id);
            if (uuid == null) {
                return "";
            }
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            if (item.getValue() == 2) {
                ICompanyOrgUnit iOrgInner = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitInfo org = iOrgInner.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
                return org != null ? org.getName() : "";
            }
            if (item.getValue() == 1) {
                ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
                CustomerInfo info = iCustomer.getCustomerInfo((IObjectPK)pk, sic);
                return info != null ? info.getName() : "";
            }
            if (item.getValue() == 0) {
                ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
                SupplierInfo info = iSupplier.getSupplierInfo((IObjectPK)pk, sic);
                return info != null ? info.getName() : "";
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static class Utils {
        public static int getExchangRateScale(Context ctx, CurrencyInfo srcCyInfo, CurrencyInfo targetCyInfo, CompanyOrgUnitInfo curCompanyInfo) {
            int rateScale = 4;
            try {
                if (srcCyInfo != null && targetCyInfo != null) {
                    if (srcCyInfo.getId().equals((Object)targetCyInfo.getId())) {
                        rateScale = targetCyInfo.getPrecision();
                    } else {
                        IExchangeRate iExchangeRate;
                        ExchangeRateInfo exchangeRateInfo;
                        String companyID = curCompanyInfo.getId().toString();
                        ExchangeTableInfo exchangeTableInfo = curCompanyInfo.getBaseExchangeTable();
                        if (exchangeTableInfo != null && (exchangeRateInfo = (iExchangeRate = ExchangeRateFactory.getLocalInstance((Context)ctx)).getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTableInfo.getId()), (IObjectPK)new ObjectUuidPK(srcCyInfo.getId()), (IObjectPK)new ObjectUuidPK(targetCyInfo.getId()), (Date)Utils.getCurrentPeriod(ctx, companyID).getEndDate())) != null) {
                            rateScale = exchangeRateInfo.getPrecision();
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return rateScale;
        }

        public static CurrencyInfo getBaseCurrency(Context ctx, String companyID) throws EASBizException, BOSException {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            CompanyOrgUnitInfo curCompanyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
            ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(curCompanyInfo.getBaseCurrency().getId());
            return iCurrency.getCurrencyInfo((IObjectPK)pk);
        }

        public static PeriodInfo getCurrentPeriod(Context ctx, String companyID) throws BOSException, EASBizException {
            PeriodInfo currentPeriod = null;
            ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.FIXEDASSETS.getValue())));
            fic.add(new FilterItemInfo("company.id", (Object)companyID));
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
            sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
            sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
            sic.add(new SelectorItemInfo("currentPeriod.isAdjustPeriod"));
            sic.add(new SelectorItemInfo("currentPeriod.endDate"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.*"));
            SystemStatusCtrolCollection col = ictrol.getSystemStatusCtrolCollection(view);
            if (col.size() > 0) {
                currentPeriod = col.get(0).getCurrentPeriod();
            }
            return currentPeriod;
        }
    }
}

