/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.el.rec.pojo.TreeDataEntity;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class NodeUtils {
    private Context ctx;
    private int maxLevel;
    private String billEntity;
    private String group;
    private BOSObjectType bosType;

    public NodeUtils(Context ctx, int showLevelCount, String billEntity, String group) {
        this.ctx = ctx;
        this.maxLevel = showLevelCount;
        this.billEntity = billEntity;
        this.group = group;
    }

    public NodeUtils(Context ctx, int showLevelCount, BOSObjectType type, String group) {
        this.ctx = ctx;
        this.maxLevel = showLevelCount;
        this.bosType = type;
        this.group = group;
    }

    public String getBillFiledTreeJson(boolean addDefault) throws BOSException {
        return JSONUtils.convertObjectToJson((Context)this.ctx, (Object)this.getBillFiledTree(addDefault));
    }

    public String getBillFiledTreeJson(boolean rootOnly, boolean addDefault) throws BOSException {
        return JSONUtils.convertObjectToJson((Context)this.ctx, (Object)this.getBillFiledTree(rootOnly, addDefault));
    }

    public TreeDataEntity getBillFiledTree(boolean rootOnly, boolean addDefault) {
        ArrayList<TreeDataEntity> childList = new ArrayList<TreeDataEntity>();
        Project.Projects projects = Project.Projects.getProjects((Project[])new Project[]{new Project("tBj8Gt3jAcrgQ8CoPwoByiyY1lE=")}, null);
        EntityObjectInfo entity = null;
        if (this.billEntity != null) {
            entity = (EntityObjectInfo)MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).get(MetaDataTypeList.ENTITY, (IMetaDataPK)MetaDataPK.create((String)this.billEntity), projects);
        } else if (this.bosType != null) {
            entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity(this.bosType);
            this.billEntity = entity.getFullName();
        } else {
            throw new NullPointerException("billEntity is null");
        }
        TreeDataEntity root = new TreeDataEntity();
        root.setId(entity.getFullName());
        root.setParent(true);
        root.setName(this.getAlias(entity));
        root.setBosType(entity.getType().toString());
        if (addDefault) {
            ArrayList<TreeDataEntity> list = new ArrayList<TreeDataEntity>();
            TreeDataEntity fixedTree = this.addFixedTree(root, list);
            childList.add(fixedTree);
            this.addFixedNood(list, fixedTree);
        }
        if (!rootOnly) {
            TreeDataEntity node;
            String curGroup;
            PropertyInfo property;
            int i;
            PropertyCollection properties = entity.getInheritedProperties();
            LinkedList<LinkPropertyInfo> F7 = new LinkedList<LinkPropertyInfo>();
            LinkedList<LinkPropertyInfo> entry = new LinkedList<LinkPropertyInfo>();
            for (i = 0; i < properties.size(); ++i) {
                property = properties.get(i);
                if (property instanceof OwnPropertyInfo) {
                    TreeDataEntity leaf = this.createLeaf(this.group, entity.getFullName(), (OwnPropertyInfo)property);
                    childList.add(leaf);
                    continue;
                }
                if (!(property instanceof LinkPropertyInfo)) continue;
                if (this.isEntry((LinkPropertyInfo)property)) {
                    entry.add((LinkPropertyInfo)property);
                    continue;
                }
                F7.add((LinkPropertyInfo)property);
            }
            for (i = 0; i < entry.size(); ++i) {
                property = (LinkPropertyInfo)entry.get(i);
                curGroup = StringUtils.isEmpty((String)this.group) ? property.getName() : this.group + "." + property.getName();
                node = this.createEntryNode(curGroup, (LinkPropertyInfo)property, entity.getFullName(), 1);
                if (node == null) continue;
                childList.add(node);
            }
            for (i = 0; i < F7.size(); ++i) {
                property = (LinkPropertyInfo)F7.get(i);
                curGroup = StringUtils.isEmpty((String)this.group) ? property.getName() : this.group + "." + property.getName();
                node = this.createF7Node(curGroup, (LinkPropertyInfo)property, entity.getFullName(), 1);
                if (node == null) continue;
                childList.add(node);
            }
            root.setChildren(childList);
        }
        return root;
    }

    private void addFixedNood(List<TreeDataEntity> list, TreeDataEntity root) {
        list.add(new TreeDataEntity(DataType.STRING, false, "__periodYear", false, "\u4f1a\u8ba1\u671f\u95f4\u5e74", "__periodYear", root.getId()));
        list.add(new TreeDataEntity(DataType.STRING, false, "__periodNumber", false, "\u4f1a\u8ba1\u671f\u95f4\u7b2cN\u671f", "__periodNumber", root.getId()));
        list.add(new TreeDataEntity(DataType.STRING, false, "__mainBillNumber", false, "\u5173\u8054\u4e3b\u5355\u7f16\u7801", "__mainBillNumber", root.getId()));
        list.add(new TreeDataEntity(DataType.STRING, false, "__archOrgNumber", false, "\u5f52\u6863\u7ec4\u7ec7\u7f16\u7801", "__archOrgNumber", root.getId()));
        list.add(new TreeDataEntity(DataType.STRING, false, "__archOrgName", false, "\u5f52\u6863\u7ec4\u7ec7\u540d\u79f0", "__archOrgName", root.getId()));
        list.add(new TreeDataEntity(DataType.STRING, false, "__archOrgID", false, "\u5f52\u6863\u7ec4\u7ec7id", "__archOrgID", root.getId()));
        root.setChildren(list);
    }

    private TreeDataEntity addFixedTree(TreeDataEntity root, List<TreeDataEntity> list) {
        TreeDataEntity fixedTree = new TreeDataEntity();
        fixedTree.setId("default_fixed");
        fixedTree.setParentId(root.getId());
        fixedTree.setPId(root.getId());
        fixedTree.setParent(true);
        fixedTree.setName("\u9884\u7f6e\u5b57\u6bb5");
        fixedTree.setNumber("default_fixed");
        return fixedTree;
    }

    public TreeDataEntity getBillFiledTree(boolean addDefault) {
        return this.getBillFiledTree(false, addDefault);
    }

    private TreeDataEntity createEntryNode(String group, LinkPropertyInfo parent, String parentId, int level) {
        TreeDataEntity node;
        String curGroup;
        PropertyInfo property;
        int i;
        TreeDataEntity root = new TreeDataEntity();
        ArrayList<TreeDataEntity> childList = new ArrayList<TreeDataEntity>();
        LinkedList<LinkPropertyInfo> F7 = new LinkedList<LinkPropertyInfo>();
        LinkedList<LinkPropertyInfo> entrys = new LinkedList<LinkPropertyInfo>();
        EntityObjectInfo entity = this.getSupplyEntity(parent);
        root.setId(entity.getFullName());
        root.setParentId(parentId);
        root.setPId(parentId);
        root.setParent(true);
        root.setName(this.getAlias(entity));
        root.setNumber(group);
        if (parentId.equals(entity.getFullName()) || this.billEntity.equals(entity.getFullName())) {
            return null;
        }
        if (this.maxLevel > 0 && level >= this.maxLevel) {
            return root;
        }
        PropertyCollection properties = entity.getInheritedProperties();
        for (i = 0; i < properties.size(); ++i) {
            property = properties.get(i);
            if (property instanceof OwnPropertyInfo) {
                TreeDataEntity leaf = this.createLeaf(group, entity.getFullName(), (OwnPropertyInfo)property);
                childList.add(leaf);
                continue;
            }
            if (!(property instanceof LinkPropertyInfo)) continue;
            if (!this.isEntry((LinkPropertyInfo)property)) {
                F7.add((LinkPropertyInfo)property);
                continue;
            }
            RelationshipInfo ship = ((LinkPropertyInfo)property).getRelationship();
            if (ship.getClientObject() != entity) continue;
            entrys.add((LinkPropertyInfo)property);
        }
        for (i = 0; i < F7.size(); ++i) {
            property = (LinkPropertyInfo)F7.get(i);
            curGroup = StringUtils.isEmpty((String)group) ? property.getName() : group + "." + property.getName();
            node = this.createF7Node(curGroup, (LinkPropertyInfo)property, entity.getFullName(), level + 1);
            if (node == null) continue;
            childList.add(node);
        }
        for (i = 0; i < entrys.size(); ++i) {
            property = (LinkPropertyInfo)entrys.get(i);
            curGroup = StringUtils.isEmpty((String)group) ? property.getName() : group + "." + property.getName();
            node = this.createEntryNode(curGroup, (LinkPropertyInfo)property, entity.getFullName(), level + 1);
            if (node == null) continue;
            childList.add(node);
        }
        root.setChildren(childList);
        return root;
    }

    private TreeDataEntity createF7Node(String group, LinkPropertyInfo parent, String parentId, int level) {
        ArrayList<TreeDataEntity> childList = new ArrayList<TreeDataEntity>();
        EntityObjectInfo entity = this.getSupplyEntity(parent);
        TreeDataEntity root = new TreeDataEntity();
        root.setId(entity.getFullName());
        root.setParentId(parentId);
        root.setPId(parentId);
        root.setParent(true);
        root.setName(parent.getAlias());
        root.setNumber(group);
        if (parentId.equals(entity.getFullName()) || this.billEntity.equals(entity.getFullName())) {
            return null;
        }
        if (this.maxLevel > 0 && level >= this.maxLevel) {
            return root;
        }
        PropertyCollection properties = entity.getInheritedProperties();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo property = properties.get(i);
            if (property instanceof OwnPropertyInfo) {
                TreeDataEntity leaf = this.createLeaf(group, entity.getFullName(), (OwnPropertyInfo)property);
                childList.add(leaf);
                continue;
            }
            if (!(property instanceof LinkPropertyInfo) || this.isEntry((LinkPropertyInfo)property)) continue;
            String curGroup = StringUtils.isEmpty((String)group) ? property.getName() : group + "." + property.getName();
            TreeDataEntity leaf = this.createSubF7Node(curGroup, entity.getFullName(), (LinkPropertyInfo)property);
            childList.add(leaf);
        }
        root.setChildren(childList);
        return root;
    }

    private TreeDataEntity createSubF7Node(String group, String parentId, LinkPropertyInfo subProperty) {
        ArrayList<TreeDataEntity> childList = new ArrayList<TreeDataEntity>();
        EntityObjectInfo entity = this.getSupplyEntity(subProperty);
        TreeDataEntity root = new TreeDataEntity();
        root.setId(entity.getFullName());
        root.setParentId(parentId);
        root.setPId(parentId);
        root.setParent(true);
        root.setName(subProperty.getAlias());
        root.setNumber(group);
        PropertyCollection properties = entity.getInheritedProperties();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo property = properties.get(i);
            if (!(property instanceof OwnPropertyInfo)) continue;
            TreeDataEntity leaf = this.createLeaf(group, entity.getFullName(), (OwnPropertyInfo)property);
            childList.add(leaf);
        }
        root.setChildren(childList);
        return root;
    }

    private TreeDataEntity createLeaf(String group, String parentId, OwnPropertyInfo property) {
        TreeDataEntity node = new TreeDataEntity();
        String id = StringUtils.isEmpty((String)group) ? property.getName() : group + "." + property.getName();
        String name = property.getAlias();
        node.setId(id);
        node.setName(name);
        node.setPId(parentId);
        node.setParentId(parentId);
        node.setParent(false);
        DataType dataType = property.getDataType();
        node.setDataType(dataType);
        if (dataType.isDateTime()) {
            node.setShowFormate("yyyy-MM-dd");
        } else if (DataType.DECIMAL.equals((Object)dataType)) {
            node.setShowFormate("###,##0.0");
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("name", name);
        propMap.put("number", id);
        propMap.put("type", dataType.toString());
        node.setPropMap(propMap);
        return node;
    }

    private String getAlias(EntityObjectInfo entity) {
        String alias = entity.getAlias();
        if (StringUtils.isEmpty((String)alias)) {
            alias = entity.getName();
        }
        return alias;
    }

    private boolean isEntry(LinkPropertyInfo property) {
        RelationshipInfo relationship = property.getRelationship();
        return Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || relationship != null && relationship.getClientObject() != null && RelationshipType.COMPOSITION.equals((Object)relationship.getType()) && (CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality())) && (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()));
    }

    private EntityObjectInfo getSupplyEntity(LinkPropertyInfo property) {
        RelationshipInfo relation = property.getRelationship();
        if (relation != null) {
            return relation.getSupplierObject();
        }
        return null;
    }
}

