/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArchPeriodInfo;
import com.kingdee.eas.el.rec.ArchSchemeInfo;
import com.kingdee.eas.el.rec.DuringType;
import com.kingdee.eas.el.rec.RePortDuringType;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.ReportCycleType;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class PeriodUtil {
    private static Logger logger = Logger.getLogger(PeriodUtil.class);

    public static PeriodCollection transformToPeriods(Context ctx, PeriodInfo periodInfo, ReportCycleType reportCycleType, CompanyOrgUnitInfo org) throws RecException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if ("MONTH".equals(reportCycleType.getValue())) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)periodInfo.getNumber(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)org.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
        } else if ("QUARTER".equals(reportCycleType.getValue())) {
            filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)periodInfo.getPeriodYear(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodQuarter", (Object)periodInfo.getPeriodNumber(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)org.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2");
        } else if ("SEMIANNUAL".equals(reportCycleType.getValue())) {
            filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)periodInfo.getPeriodYear(), CompareType.EQUALS));
            if (periodInfo.getPeriodNumber() == 1) {
                filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)6, CompareType.LESS_EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)7, CompareType.GREATER_EQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)org.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)periodInfo.getPeriodYear(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)org.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
        }
        evi.setFilter(filter);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterItemInfo);
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        PeriodCollection periodCollection = null;
        try {
            periodCollection = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        }
        catch (BOSException e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u62a5\u8868\u671f\u95f4\u8f6c\u6362\u5f02\u5e38"});
        }
        ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        return periodCollection;
    }

    public static int getPeriods(int year, RptPeriodTypeEnum periodType, boolean isSupport13Period) {
        int periods = 0;
        Date date = null;
        try {
            date = BatchHelper.dateFormat.parse(year + "-12-31");
        }
        catch (ParseException e) {
            return periods;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (periodType.getValue() == 3) {
            periods = isSupport13Period ? 13 : 12;
        } else if (periodType.getValue() == 4) {
            periods = 4;
        } else if (periodType.getValue() == 6) {
            periods = 1;
        } else if (periodType.getValue() == 5) {
            periods = 2;
        } else if (periodType.getValue() == 2) {
            periods = calendar.get(3);
        } else if (periodType.getValue() == 1) {
            periods = calendar.get(6);
        }
        return periods;
    }

    public static PeriodCollection getPeriodsForOtherReport(Context ctx, ArchSchemeInfo asInfo) throws BOSException, EASBizException {
        PeriodCollection periodCollection = new PeriodCollection();
        Date date = new Date();
        if ("previous_issue".equals(asInfo.getReportDuringType().getValue()) && "MONTH".equals(asInfo.getReportCycleType().getValue()) || "last_quarter".equals(asInfo.getReportDuringType().getValue()) && "QUARTER".equals(asInfo.getReportCycleType().getValue()) || "last_semiannual".equals(asInfo.getReportDuringType().getValue()) && "SEMIANNUAL".equals(asInfo.getReportCycleType().getValue()) || "last_year".equals(asInfo.getReportDuringType().getValue()) && "ANNUAL".equals(asInfo.getReportCycleType().getValue())) {
            int[] period = PeriodUtil.getLastPeriod(FilingUtils.convertToRptEnum(asInfo.getReportCycleType()), 1);
            PeriodUtil.addPeriod(asInfo, periodCollection, period[0], period[1]);
        } else if ("privious_p_issue".equals(asInfo.getReportDuringType().getValue())) {
            int[] period = PeriodUtil.getLastPeriod(FilingUtils.convertToRptEnum(asInfo.getReportCycleType()), 2);
            PeriodUtil.addPeriod(asInfo, periodCollection, period[0], period[1]);
        } else if ("last_year".equals(asInfo.getReportDuringType().getValue())) {
            Calendar calendar = PeriodUtil.getCalendarTimeIsZero();
            calendar.setTime(date);
            int year = calendar.get(1);
            int periodCount = PeriodUtil.getPeriods(--year, FilingUtils.convertToRptEnum(asInfo.getReportCycleType()), asInfo.isContain13Period());
            for (int i = 1; i <= periodCount; ++i) {
                PeriodUtil.addPeriod(asInfo, periodCollection, year, i);
            }
        } else if ("scope".equals(asInfo.getReportDuringType().getValue())) {
            int startPeriod = asInfo.getStartPeroid();
            int endPeriod = asInfo.getEndPeriod();
            if (startPeriod == 0) {
                startPeriod = endPeriod;
            }
            if (endPeriod == 0) {
                endPeriod = startPeriod;
            }
            int i = 0;
            if (startPeriod <= endPeriod) {
                while (true) {
                    int[] period;
                    int tempPeriod;
                    if ((tempPeriod = (period = PeriodUtil.getLastPeriod(FilingUtils.convertToRptEnum(asInfo.getReportCycleType()), i))[0] * 100 + period[1]) > endPeriod) {
                        ++i;
                        continue;
                    }
                    if (tempPeriod >= startPeriod) {
                        PeriodUtil.addPeriod(asInfo, periodCollection, period[0], period[1]);
                        if (period[1] == 12 && asInfo.isContain13Period()) {
                            PeriodUtil.addPeriod(asInfo, periodCollection, period[0], 13);
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            logger.error((Object)"getPeriodsForOtherReport:periodCollection.size=0");
        }
        return periodCollection;
    }

    private static void addPeriod(ArchSchemeInfo asInfo, PeriodCollection periodCollection, int i2, int i3) {
        PeriodInfo periodInfo = new PeriodInfo();
        periodInfo.setPeriodYear(i2);
        periodInfo.setPeriodNumber(i3);
        periodInfo.setNumber(i2 * 100 + i3);
        periodInfo.setBeginDate(new Date(RPTDateUtil.getPeriodFirstDate((int)i2, (int)i3, (RptPeriodTypeEnum)FilingUtils.convertToRptEnum(asInfo.getReportCycleType())).getTime()));
        periodInfo.setEndDate(new Timestamp(RPTDateUtil.getPeriodLastDate((int)i2, (int)i3, (RptPeriodTypeEnum)FilingUtils.convertToRptEnum(asInfo.getReportCycleType())).getTime()));
        periodCollection.add(periodInfo);
    }

    public static int[] getLastPeriod(RptPeriodTypeEnum t, int last) {
        Calendar c = Calendar.getInstance();
        c.set(5, 15);
        if (t.getValue() == 3) {
            c.set(2, c.get(2) - (last - 1));
        } else if (t.getValue() == 4) {
            c.set(2, c.get(2) - (last * 3 - 1));
        } else if (t.getValue() == 5) {
            c.set(2, c.get(2) - (last * 6 - 1));
        } else if (t.getValue() == 6) {
            c.set(2, c.get(2) - (last * 12 - 1));
        }
        int thismonth = c.get(2);
        do {
            c.add(5, -1);
        } while (c.get(2) == thismonth);
        int[] period = RPTDateUtil.getPeriod((Date)new Date(c.getTimeInMillis()), (RptPeriodTypeEnum)t);
        return period;
    }

    public static PeriodCollection getPeriodsForReport(Context ctx, ArchSchemeInfo asInfo, RecordBaseInfo content, CompanyOrgUnitInfo org) throws BOSException, EASBizException {
        PeriodCollection periodCollection;
        block62: {
            PeriodInfo cPd;
            RePortDuringType rePortDuringType;
            ReportCycleType reportCycleType;
            block66: {
                block68: {
                    int cSYear;
                    block67: {
                        block63: {
                            block65: {
                                int cQYear;
                                block64: {
                                    block61: {
                                        reportCycleType = asInfo.getReportCycleType();
                                        rePortDuringType = asInfo.getReportDuringType();
                                        periodCollection = new PeriodCollection();
                                        String sysNmae = content.getBillType().getPeriodSys();
                                        logger.error((Object)("sysNmae:[" + sysNmae + "],orgId:[" + org.getId().toString() + "]"));
                                        if ("8".equalsIgnoreCase(sysNmae) || StringUtils.isEmpty((String)sysNmae)) {
                                            sysNmae = "6";
                                        }
                                        if ((cPd = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(Integer.parseInt(sysNmae), org.getId().toString())) == null) {
                                            return periodCollection;
                                        }
                                        logger.error((Object)("cPd:" + cPd));
                                        if (!"MONTH".equals(reportCycleType.getValue())) break block61;
                                        if ("previous_issue".equals(rePortDuringType.getValue())) {
                                            PeriodInfo pPd = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)cPd);
                                            if (null == pPd) {
                                                return periodCollection;
                                            }
                                            periodCollection.add(pPd);
                                            while (pPd.getPeriodNumber() >= 13) {
                                                if (null == (pPd = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)pPd))) {
                                                    return periodCollection;
                                                }
                                                periodCollection.add(pPd);
                                            }
                                            PeriodCollection missed = PeriodUtil.missedPeriods(ctx, content, org, pPd);
                                            if (missed != null && missed.size() > 0) {
                                                periodCollection.addCollection(missed);
                                            }
                                        } else if ("privious_p_issue".equals(rePortDuringType.getValue())) {
                                            PeriodInfo ppPd;
                                            PeriodInfo pPd = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)cPd);
                                            if (1 == cPd.getPeriodNumber() && pPd.getPeriodNumber() > 12) {
                                                Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
                                                ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                                                ppPd = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(cPd.getPeriodYear() - 1, 11, org.getAccountPeriodType());
                                                ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
                                                if (null == ppPd) {
                                                    return periodCollection;
                                                }
                                                periodCollection.add(ppPd);
                                            } else {
                                                ppPd = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)pPd);
                                                if (null == ppPd) {
                                                    return periodCollection;
                                                }
                                                periodCollection.add(ppPd);
                                                while (ppPd.getPeriodNumber() >= 13) {
                                                    if (null == (ppPd = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)ppPd))) {
                                                        return periodCollection;
                                                    }
                                                    periodCollection.add(ppPd);
                                                }
                                            }
                                            PeriodCollection missed = PeriodUtil.missedPeriods(ctx, content, org, ppPd);
                                            if (missed != null && missed.size() > 0) {
                                                periodCollection.addCollection(missed);
                                            }
                                        } else if ("last_year".equals(rePortDuringType.getValue())) {
                                            EntityViewInfo evi = new EntityViewInfo();
                                            FilterInfo filter = new FilterInfo();
                                            filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)(cPd.getPeriodYear() - 1), CompareType.EQUALS));
                                            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)org.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
                                            filter.setMaskString("#0 and #1");
                                            evi.setFilter(filter);
                                            evi.getSorter().add(new SorterItemInfo("number"));
                                            Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
                                            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                                            periodCollection = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
                                            ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
                                        } else if ("scope".equals(rePortDuringType.getValue())) {
                                            int startPeriod = asInfo.getStartPeroid();
                                            int endPeriod = asInfo.getEndPeriod();
                                            if (startPeriod == 0) {
                                                startPeriod = endPeriod;
                                            }
                                            if (endPeriod == 0) {
                                                endPeriod = startPeriod;
                                            }
                                            if (startPeriod <= endPeriod) {
                                                int i;
                                                int startYear = startPeriod / 100;
                                                int endYear = endPeriod / 100;
                                                int startNumber = startPeriod % (startYear * 100);
                                                int endNumber = endPeriod % (endYear * 100);
                                                if (startYear == endYear) {
                                                    for (i = startNumber; i <= endNumber; ++i) {
                                                        PeriodInfo periodInfo = new PeriodInfo();
                                                        periodInfo.setPeriodYear(startYear);
                                                        periodInfo.setPeriodQuarter(i);
                                                        periodInfo.setPeriodNumber(i);
                                                        periodInfo.setNumber(startYear * 100 + i);
                                                        periodCollection.add(periodInfo);
                                                    }
                                                } else {
                                                    for (i = startNumber; i <= 12; ++i) {
                                                        PeriodInfo periodInfo = new PeriodInfo();
                                                        periodInfo.setPeriodYear(startYear);
                                                        periodInfo.setPeriodQuarter(i);
                                                        periodInfo.setPeriodNumber(i);
                                                        periodInfo.setNumber(startYear * 100 + i);
                                                        periodCollection.add(periodInfo);
                                                    }
                                                    for (int j = startYear + 1; j < endYear; ++j) {
                                                        for (int i2 = 1; i2 <= 12; ++i2) {
                                                            PeriodInfo periodInfo = new PeriodInfo();
                                                            periodInfo.setPeriodYear(j);
                                                            periodInfo.setPeriodQuarter(i2);
                                                            periodInfo.setPeriodNumber(i2);
                                                            periodInfo.setNumber(j * 100 + i2);
                                                            periodCollection.add(periodInfo);
                                                        }
                                                    }
                                                    for (i = 1; i <= endNumber; ++i) {
                                                        PeriodInfo periodInfo = new PeriodInfo();
                                                        periodInfo.setPeriodYear(endYear);
                                                        periodInfo.setPeriodQuarter(i);
                                                        periodInfo.setPeriodNumber(i);
                                                        periodInfo.setNumber(endYear * 100 + i);
                                                        periodCollection.add(periodInfo);
                                                    }
                                                }
                                            }
                                        }
                                        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.getEnum((int)Integer.parseInt(sysNmae)), (CompanyOrgUnitInfo)org);
                                        if (startPeriod == null) break block62;
                                        for (int i = periodCollection.size() - 1; i >= 0; --i) {
                                            if (periodCollection.get(i).getNumber() >= startPeriod.getNumber() && periodCollection.get(i).getNumber() <= cPd.getNumber()) continue;
                                            periodCollection.remove(periodCollection.get(i));
                                        }
                                        break block62;
                                    }
                                    if (!"QUARTER".equals(reportCycleType.getValue())) break block63;
                                    cQYear = cPd.getPeriodYear();
                                    int cQQuarter = cPd.getPeriodQuarter();
                                    if (!"last_quarter".equals(rePortDuringType.getValue())) break block64;
                                    int pQYear = cQQuarter - 1 == 0 ? cQYear - 1 : cQYear;
                                    int pQQuarter = cQQuarter - 1 == 0 ? 4 : cQQuarter - 1;
                                    PeriodInfo periodInfo = new PeriodInfo();
                                    periodInfo.setPeriodYear(pQYear);
                                    periodInfo.setPeriodQuarter(pQQuarter);
                                    periodInfo.setPeriodNumber(pQQuarter);
                                    periodInfo.setNumber(pQYear * 100 + pQQuarter);
                                    periodCollection.add(periodInfo);
                                    break block62;
                                }
                                if (!"last_year".equals(rePortDuringType.getValue())) break block65;
                                int pQYear = cQYear - 1;
                                for (int i = 1; i <= 4; ++i) {
                                    PeriodInfo periodInfo = new PeriodInfo();
                                    periodInfo.setPeriodYear(pQYear);
                                    periodInfo.setPeriodQuarter(i);
                                    periodInfo.setPeriodNumber(i);
                                    periodInfo.setNumber(pQYear * 100 + i);
                                    periodCollection.add(periodInfo);
                                }
                                break block62;
                            }
                            if (!"scope".equals(rePortDuringType.getValue())) break block62;
                            int startPeriod = asInfo.getStartPeroid();
                            int endPeriod = asInfo.getEndPeriod();
                            if (startPeriod == 0) {
                                startPeriod = endPeriod;
                            }
                            if (endPeriod == 0) {
                                endPeriod = startPeriod;
                            }
                            if (startPeriod <= endPeriod) {
                                int startYear = startPeriod / 100;
                                int endYear = endPeriod / 100;
                                int startNumber = startPeriod % (startYear * 100);
                                int endNumber = endPeriod % (endYear * 100);
                                if (startYear == endYear) {
                                    for (int i = startNumber; i <= endNumber; ++i) {
                                        PeriodInfo periodInfo = new PeriodInfo();
                                        periodInfo.setPeriodYear(startYear);
                                        periodInfo.setPeriodQuarter(i);
                                        periodInfo.setPeriodNumber(i);
                                        periodInfo.setNumber(startYear * 100 + i);
                                        periodCollection.add(periodInfo);
                                    }
                                } else {
                                    int i;
                                    for (i = startNumber; i <= 4; ++i) {
                                        PeriodInfo periodInfo = new PeriodInfo();
                                        periodInfo.setPeriodYear(startYear);
                                        periodInfo.setPeriodQuarter(i);
                                        periodInfo.setPeriodNumber(i);
                                        periodInfo.setNumber(startYear * 100 + i);
                                        periodCollection.add(periodInfo);
                                    }
                                    for (int j = startYear + 1; j < endYear; ++j) {
                                        for (int i3 = 1; i3 <= 4; ++i3) {
                                            PeriodInfo periodInfo = new PeriodInfo();
                                            periodInfo.setPeriodYear(j);
                                            periodInfo.setPeriodQuarter(i3);
                                            periodInfo.setPeriodNumber(i3);
                                            periodInfo.setNumber(j * 100 + i3);
                                            periodCollection.add(periodInfo);
                                        }
                                    }
                                    for (i = 1; i <= endNumber; ++i) {
                                        PeriodInfo periodInfo = new PeriodInfo();
                                        periodInfo.setPeriodYear(endYear);
                                        periodInfo.setPeriodQuarter(i);
                                        periodInfo.setPeriodNumber(i);
                                        periodInfo.setNumber(endYear * 100 + i);
                                        periodCollection.add(periodInfo);
                                    }
                                }
                            }
                            break block62;
                        }
                        if (!"SEMIANNUAL".equals(reportCycleType.getValue())) break block66;
                        cSYear = cPd.getPeriodYear();
                        int cSNumber = cPd.getPeriodNumber();
                        if (!"last_semiannual".equals(rePortDuringType.getValue())) break block67;
                        int pSYear = cSNumber <= 6 ? cSYear - 1 : cSYear;
                        int pSNumber = cSNumber <= 6 ? 2 : 1;
                        PeriodInfo periodInfo = new PeriodInfo();
                        periodInfo.setPeriodYear(pSYear);
                        periodInfo.setPeriodNumber(pSNumber);
                        periodInfo.setNumber(pSYear * 100 + pSNumber);
                        periodCollection.add(periodInfo);
                        break block62;
                    }
                    if (!"last_year".equals(rePortDuringType.getValue())) break block68;
                    int pSYear = cSYear - 1;
                    for (int i = 1; i <= 2; ++i) {
                        PeriodInfo periodInfo = new PeriodInfo();
                        periodInfo.setPeriodYear(pSYear);
                        periodInfo.setPeriodNumber(i);
                        periodInfo.setNumber(pSYear * 100 + i);
                        periodCollection.add(periodInfo);
                    }
                    break block62;
                }
                if (!"scope".equals(rePortDuringType.getValue())) break block62;
                int startPeriod = asInfo.getStartPeroid();
                int endPeriod = asInfo.getEndPeriod();
                if (startPeriod == 0) {
                    startPeriod = endPeriod;
                }
                if (endPeriod == 0) {
                    endPeriod = startPeriod;
                }
                if (startPeriod <= endPeriod) {
                    int startYear = startPeriod / 100;
                    int endYear = endPeriod / 100;
                    int startNumber = startPeriod % (startYear * 100);
                    int endNumber = endPeriod % (endYear * 100);
                    if (startYear == endYear) {
                        for (int i = startNumber; i <= endNumber; ++i) {
                            PeriodInfo periodInfo = new PeriodInfo();
                            periodInfo.setPeriodYear(startYear);
                            periodInfo.setPeriodQuarter(i);
                            periodInfo.setPeriodNumber(i);
                            periodInfo.setNumber(startYear * 100 + i);
                            periodCollection.add(periodInfo);
                        }
                    } else {
                        int i;
                        for (i = startNumber; i <= 2; ++i) {
                            PeriodInfo periodInfo = new PeriodInfo();
                            periodInfo.setPeriodYear(startYear);
                            periodInfo.setPeriodQuarter(i);
                            periodInfo.setPeriodNumber(i);
                            periodInfo.setNumber(startYear * 100 + i);
                            periodCollection.add(periodInfo);
                        }
                        for (int j = startYear + 1; j < endYear; ++j) {
                            for (int i4 = 1; i4 <= 2; ++i4) {
                                PeriodInfo periodInfo = new PeriodInfo();
                                periodInfo.setPeriodYear(j);
                                periodInfo.setPeriodQuarter(i4);
                                periodInfo.setPeriodNumber(i4);
                                periodInfo.setNumber(j * 100 + i4);
                                periodCollection.add(periodInfo);
                            }
                        }
                        for (i = 1; i <= endNumber; ++i) {
                            PeriodInfo periodInfo = new PeriodInfo();
                            periodInfo.setPeriodYear(endYear);
                            periodInfo.setPeriodQuarter(i);
                            periodInfo.setPeriodNumber(i);
                            periodInfo.setNumber(endYear * 100 + i);
                            periodCollection.add(periodInfo);
                        }
                    }
                }
                break block62;
            }
            if ("ANNUAL".equals(reportCycleType.getValue())) {
                int cAYear = cPd.getPeriodYear();
                if ("last_year".equals(rePortDuringType.getValue())) {
                    int pAYear = cAYear - 1;
                    PeriodInfo periodInfo = new PeriodInfo();
                    periodInfo.setPeriodYear(pAYear);
                    periodInfo.setPeriodNumber(1);
                    periodInfo.setNumber(pAYear * 100 + 1);
                    periodCollection.add(periodInfo);
                } else if ("scope".equals(rePortDuringType.getValue())) {
                    int startPeriod = asInfo.getStartPeroid();
                    int endPeriod = asInfo.getEndPeriod();
                    if (startPeriod == 0) {
                        startPeriod = endPeriod;
                    }
                    if (endPeriod == 0) {
                        endPeriod = startPeriod;
                    }
                    if (startPeriod <= endPeriod) {
                        int startYear = startPeriod / 100;
                        int endYear = endPeriod / 100;
                        for (int i = startYear; i <= endYear; ++i) {
                            PeriodInfo periodInfo = new PeriodInfo();
                            periodInfo.setPeriodYear(i);
                            periodInfo.setPeriodNumber(1);
                            periodInfo.setNumber(i * 100 + 1);
                            periodCollection.add(periodInfo);
                        }
                    }
                }
            }
        }
        return periodCollection;
    }

    public static Calendar getCalendarTimeIsZero() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        return calendar;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, CompanyOrgUnitInfo org, ArchPeriodInfo archPeriodInfo) throws BOSException, EASBizException, NumberFormatException {
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(archPeriodInfo.getPeriodYear(), archPeriodInfo.getPeriod(), org.getAccountPeriodType());
        ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        return periodInfo;
    }

    public static PeriodCollection getPeriods(Context ctx, ArchSchemeInfo asInfo, RecordBaseInfo content, CompanyOrgUnitInfo org) throws BOSException, EASBizException, NumberFormatException {
        if (DuringType.LAST_ISSUE.equals((Object)asInfo.getDuringType())) {
            return PeriodUtil.getPeriods(ctx, content, org);
        }
        if (DuringType.SCOPE.equals((Object)asInfo.getDuringType())) {
            return PeriodUtil.getPeriods(ctx, org, asInfo);
        }
        if (DuringType.CURRENT_ISSUE.equals((Object)asInfo.getDuringType())) {
            PeriodInfo cPd = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(Integer.parseInt(content.getBillType().getPeriodSys()), org.getId().toString());
            PeriodCollection coll = new PeriodCollection();
            if (null != cPd) {
                coll.add(cPd);
            }
            return coll;
        }
        return PeriodUtil.getPeriod(ctx, asInfo, content, org);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOtherReportCurrentPeriod(Context ctx, String periodSys, String companyId, ReportCycleType reportCycleType) throws EASBizException, BOSException {
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        try {
            int[] currentP = RPTDateUtil.getPeriod((Date)new Date(), (RptPeriodTypeEnum)FilingUtils.convertToRptEnum(reportCycleType));
            int n = currentP[0] * 100 + currentP[1];
            return n;
        }
        finally {
            ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getReportCurrentPeriod(Context ctx, String periodSys, String companyId, ReportCycleType reportCycleType) throws EASBizException, BOSException {
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        try {
            PeriodInfo cPd = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(Integer.parseInt(periodSys), companyId);
            if (cPd == null) {
                cPd = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(Integer.parseInt("7"), companyId);
            }
            if (reportCycleType.getValue().equals("MONTH")) {
                int n = cPd.getNumber();
                return n;
            }
            if (reportCycleType.getValue().equals("QUARTER")) {
                int n = cPd.getPeriodYear() * 100 + cPd.getPeriodQuarter();
                return n;
            }
            if (reportCycleType.getValue().equals("SEMIANNUAL")) {
                if (cPd.getPeriodQuarter() == 1 || cPd.getPeriodQuarter() == 2) {
                    int n = cPd.getPeriodYear() * 100 + 1;
                    return n;
                }
                int n = cPd.getPeriodYear() * 100 + 2;
                return n;
            }
            if (reportCycleType.getValue().equals("ANNUAL")) {
                int n = cPd.getPeriodYear() * 100 + 1;
                return n;
            }
            int n = cPd.getNumber();
            return n;
        }
        finally {
            ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PeriodInfo getBillCurrentPeriodInfo(Context ctx, String periodSys, String companyId) throws EASBizException, BOSException {
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        try {
            PeriodInfo cPd;
            PeriodInfo periodInfo = cPd = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(Integer.parseInt(periodSys), companyId);
            return periodInfo;
        }
        finally {
            ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBillCurrentPeriod(Context ctx, String periodSys, String companyId) throws EASBizException, BOSException {
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        try {
            PeriodInfo cPd = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(Integer.parseInt(periodSys), companyId);
            if (cPd != null) {
                int n = cPd.getNumber();
                return n;
            }
            logger.error((Object)"getBillCurrentPeriod going error");
            Calendar calendar = PeriodUtil.getCalendarTimeIsZero();
            calendar.setTime(new Date());
            int year = calendar.get(1);
            int month = calendar.get(2);
            int n = year * 100 + month;
            return n;
        }
        finally {
            ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        }
    }

    public static PeriodInfo getLastPeriod(Context ctx, ArchSchemeInfo asInfo, RecordBaseInfo content, CompanyOrgUnitInfo org) throws Exception {
        String sysNmae = content.getBillType().getPeriodSys();
        PeriodInfo cPd = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(Integer.parseInt(sysNmae), org.getId().toString());
        if (null == cPd) {
            throw new Exception("\u83b7\u53d6\u671f\u95f4\u5931\u8d25\uff01");
        }
        PeriodInfo pPd = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)cPd);
        return pPd;
    }

    public static PeriodInfo getLastPeriod(Context ctx, RecordBaseInfo content, CompanyOrgUnitInfo org) throws Exception {
        String sysNmae = content.getBillType().getPeriodSys();
        PeriodInfo cPd = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(Integer.parseInt(sysNmae), org.getId().toString());
        if (null == cPd) {
            throw new Exception("\u83b7\u53d6\u671f\u95f4\u5931\u8d25\uff01");
        }
        PeriodInfo pPd = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)cPd);
        return pPd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PeriodCollection getPeriod(Context ctx, ArchSchemeInfo asInfo, RecordBaseInfo content, CompanyOrgUnitInfo org) throws EASBizException, BOSException {
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        try {
            String sysNmae = content.getBillType().getPeriodSys();
            PeriodInfo cPd = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(Integer.parseInt(sysNmae), org.getId().toString());
            PeriodCollection periods = new PeriodCollection();
            if (null == cPd) {
                PeriodCollection periodCollection = periods;
                return periodCollection;
            }
            PeriodCollection missed = new PeriodCollection();
            PeriodInfo pPd = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)cPd);
            if (DuringType.PREVIOUS_ISSUE.equals((Object)asInfo.getDuringType())) {
                if (null == pPd) {
                    PeriodCollection periodCollection = periods;
                    return periodCollection;
                }
                periods.add(pPd);
                while (pPd.getPeriodNumber() >= 13) {
                    if (null == (pPd = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)pPd))) {
                        PeriodCollection periodCollection = periods;
                        return periodCollection;
                    }
                    periods.add(pPd);
                }
                missed = PeriodUtil.missedPeriods(ctx, content, org, pPd);
            }
            if (DuringType.PREVIOUS_P_ISSUE.equals((Object)asInfo.getDuringType())) {
                if (1 == cPd.getPeriodNumber() && pPd.getPeriodNumber() > 12) {
                    PeriodInfo p = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(cPd.getPeriodYear() - 1, 11, org.getAccountPeriodType());
                    if (null == p) {
                        PeriodCollection periodCollection = periods;
                        return periodCollection;
                    }
                    periods.add(p);
                    missed = PeriodUtil.missedPeriods(ctx, content, org, p);
                    periods.addCollection(missed);
                    PeriodCollection periodCollection = periods;
                    return periodCollection;
                }
                PeriodInfo ppPd = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)pPd);
                if (null == ppPd) {
                    PeriodCollection periodCollection = periods;
                    return periodCollection;
                }
                periods.add(ppPd);
                while (ppPd.getPeriodNumber() >= 13) {
                    if (null == (ppPd = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)ppPd))) {
                        PeriodCollection periodCollection = periods;
                        return periodCollection;
                    }
                    periods.add(ppPd);
                }
                missed = PeriodUtil.missedPeriods(ctx, content, org, ppPd);
            }
            if (missed.size() > 0) {
                periods.addCollection(missed);
            }
            PeriodCollection periodCollection = periods;
            return periodCollection;
        }
        finally {
            ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        }
    }

    private static PeriodCollection missedPeriods(Context ctx, RecordBaseInfo content, CompanyOrgUnitInfo org, PeriodInfo periodInfo) throws EASBizException, BOSException {
        int lastPeriodNum = periodInfo.getNumber() - 1;
        if (periodInfo.getNumber() % 100 == 0) {
            lastPeriodNum = (periodInfo.getNumber() / 100 - 1) * 100 + 12;
        }
        int llastPeriodNum = lastPeriodNum - 1;
        if (lastPeriodNum % 100 == 0) {
            llastPeriodNum = (lastPeriodNum / 100 - 1) * 100 + 12;
        }
        PeriodCollection pds = new PeriodCollection();
        if (!PeriodUtil.excued(ctx, content, org, llastPeriodNum).booleanValue()) {
            return pds;
        }
        if (!PeriodUtil.excued(ctx, content, org, lastPeriodNum).booleanValue()) {
            PeriodInfo period;
            if (lastPeriodNum % 100 == 12) {
                pds = PeriodUtil.missedPeriods(ctx, org, lastPeriodNum);
            }
            if (null != (period = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)periodInfo))) {
                pds.add(period);
            }
        }
        return pds;
    }

    private static PeriodCollection missedPeriods(Context ctx, CompanyOrgUnitInfo org, int periodNum) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)periodNum, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)(periodNum / 100), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)org.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        PeriodCollection coll = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        return coll;
    }

    private static Boolean excued(Context ctx, RecordBaseInfo content, CompanyOrgUnitInfo org, int periodNum) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("content", (Object)content.getId()));
        filter.getFilterItems().add(new FilterItemInfo("org", (Object)org.getId()));
        filter.getFilterItems().add(new FilterItemInfo("periodNum", (Object)periodNum));
        if (content.getRecordType() != null && "report".equals(content.getRecordType().getValue())) {
            filter.getFilterItems().add(new FilterItemInfo("reportCycleType", (Object)"MONTH"));
        }
        entityViewInfo.setFilter(filter);
        try {
            return ArcRecordFactory.getLocalInstance(ctx).exists(filter);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static PeriodCollection getPeriods(Context ctx, RecordBaseInfo content, CompanyOrgUnitInfo org) throws BOSException, EASBizException, NumberFormatException {
        String sysNmae = content.getBillType().getPeriodSys();
        PeriodInfo cPd = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(Integer.parseInt(sysNmae), org.getId().toString());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)(cPd.getPeriodYear() - 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)org.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        PeriodCollection coll = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        return coll;
    }

    public static PeriodCollection getPeriods(Context ctx, CompanyOrgUnitInfo org, ArchSchemeInfo asInfo) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)asInfo.getEndPeriod(), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)asInfo.getStartPeroid(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)org.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        PeriodCollection coll = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        return coll;
    }
}

