/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.customer;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.tool.customer.impl.AppendFunction;
import com.kingdee.eas.el.rec.tool.customer.impl.AppendNoDupFunction;
import com.kingdee.eas.el.rec.tool.customer.impl.AvgFunction;
import com.kingdee.eas.el.rec.tool.customer.impl.DateFormatFunction;
import com.kingdee.eas.el.rec.tool.customer.impl.EntryFunction;
import com.kingdee.eas.el.rec.tool.customer.impl.Field2EntryFunction;
import com.kingdee.eas.el.rec.tool.customer.impl.FormatEntryFunction;
import com.kingdee.eas.el.rec.tool.customer.impl.FormatStrFunction;
import com.kingdee.eas.el.rec.tool.customer.impl.MaxFunction;
import com.kingdee.eas.el.rec.tool.customer.impl.MinFunction;
import com.kingdee.eas.el.rec.tool.customer.impl.OutPutFunction;
import com.kingdee.eas.el.rec.tool.customer.impl.SumFunction;
import com.kingdee.eas.el.rec.tool.customer.impl.VoucherEntryDCFunction;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class CustomerFunction {
    protected Logger logger = Logger.getLogger(this.getClass());
    private static Map<String, CustomerFunction> functions = new HashMap<String, CustomerFunction>(6);

    public abstract String getFunctionName();

    public abstract String getFunctionAlias();

    public abstract String getFunctionDesc();

    public abstract Object execute(Object var1, Object[] var2);

    protected Object getSrcField(String key, Object obj) {
        return CustomerFunction.getSrcFieldBase(key, obj);
    }

    protected Object getSrcField(String[] keys, Object obj) {
        return CustomerFunction.getSrcFieldBase(keys, obj);
    }

    public static final Object getSrcFieldBase(String[] keys, Object forObj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String key = "";
        for (int i = 0; i < keys.length; ++i) {
            key = key + keys[i];
            if ((forObj = CustomerFunction.getSrcFieldBase(keys[i], forObj)) == null) {
                return null;
            }
            IObjectCollection coll = null;
            List list = null;
            if (forObj instanceof IObjectCollection) {
                coll = (IObjectCollection)forObj;
            }
            if (forObj instanceof List) {
                list = (List)forObj;
            }
            if (coll == null && list == null) {
                if (i == keys.length - 1) {
                    map.put(key, forObj);
                    continue;
                }
                key = key + ".";
                continue;
            }
            ArrayList<Object> entryList = new ArrayList<Object>();
            map.put(key, entryList);
            int size = 0;
            if (coll == null) {
                if (list == null) break;
                size = list.size();
                for (int j = 0; j < size; ++j) {
                    if (i + 1 == keys.length) {
                        String[] id = new String[]{"id"};
                        entryList.add(CustomerFunction.getSrcFieldBase(id, list.get(i)));
                        continue;
                    }
                    entryList.add(CustomerFunction.getSrcFieldBase(Arrays.copyOfRange(keys, i + 1, keys.length), list.get(j)));
                }
            } else {
                size = coll.size();
                for (int j = 0; j < size; ++j) {
                    if (i + 1 == keys.length) {
                        String[] id = new String[]{"id"};
                        entryList.add(CustomerFunction.getSrcFieldBase(id, (Object)coll.getObject(i)));
                        continue;
                    }
                    entryList.add(CustomerFunction.getSrcFieldBase(Arrays.copyOfRange(keys, i + 1, keys.length), (Object)coll.getObject(j)));
                }
            }
            break;
        }
        return map;
    }

    public static final Object getSrcFieldBase(String key, Object obj) {
        Object inst;
        Object ret = null;
        if (obj instanceof IObjectValue) {
            inst = (IObjectValue)obj;
            ret = inst.get(key);
        } else if (obj instanceof Map) {
            inst = (Map)obj;
            ret = inst.get(key);
        } else if (obj instanceof IXmlSrcObj) {
            IXmlSrcObj xmlObj = (IXmlSrcObj)obj;
            ret = xmlObj.get(key);
        } else {
            try {
                Method method = obj.getClass().getMethod("get", String.class);
                if (method != null) {
                    Object[] params = new Object[]{key};
                    ret = method.invoke(obj, params);
                }
            }
            catch (Exception method) {
                // empty catch block
            }
        }
        if (ret instanceof Date && ret != null) {
            SimpleDateFormat spdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ret = spdf.format((Date)ret);
        }
        return ret;
    }

    public static final Object putSrcFieldBase(String key, Object value, Object obj) {
        if (obj instanceof IObjectValue) {
            IObjectValue inst = (IObjectValue)obj;
            inst.put(key, value);
        } else if (obj instanceof Map) {
            Map inst = (Map)obj;
            inst.put(key, value);
        } else if (obj instanceof IXmlSrcObj) {
            IXmlSrcObj xmlObj = (IXmlSrcObj)obj;
            xmlObj.put(key, value);
        } else {
            try {
                Method method = obj.getClass().getMethod("put", String.class, Object.class);
                if (method != null) {
                    Object[] params = new Object[]{key, value};
                    method.invoke(obj, params);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public static CustomerFunction getFunctionByName(String name) {
        CustomerFunction function = functions.get(name);
        if (function == null) {
            // empty if block
        }
        return function;
    }

    public static Set<String> getAllLoadedFunctionsName() {
        Set<String> keySet = functions.keySet();
        HashSet<String> retSet = new HashSet<String>(keySet.size());
        retSet.addAll(keySet);
        return retSet;
    }

    static {
        functions.put("append", new AppendFunction());
        functions.put("appendNoDup", new AppendNoDupFunction());
        functions.put("avg", new AvgFunction());
        functions.put("entry", new EntryFunction());
        functions.put("max", new MaxFunction());
        functions.put("min", new MinFunction());
        functions.put("sum", new SumFunction());
        functions.put("formatStr", new FormatStrFunction());
        functions.put("voucherEntryDC", new VoucherEntryDCFunction());
        functions.put("outPut", new OutPutFunction());
        functions.put("formatEntry", new FormatEntryFunction());
        functions.put("field2Entry", new Field2EntryFunction());
        functions.put("dateFormat", new DateFormatFunction());
    }
}

