/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.model.FileStreamInfo;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.KDNoteWebServerHelper;
import com.kingdee.eas.el.rec.tool.engine.ReportParsingEngineUtil;
import com.kingdee.eas.framework.SystemEnum;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class WithoutEntityReportParsingEngineUtil
extends ReportParsingEngineUtil {
    @Override
    public InputStream[] getFileISArray(Context ctx, IXmlSrcObj iXmlSrcObj) throws Exception {
        InputStream[] arr;
        Object fileOutPutIO = iXmlSrcObj.get("fileOutPutIO");
        if (null == fileOutPutIO) {
            return null;
        }
        if (fileOutPutIO instanceof InputStream) {
            arr = new InputStream[]{(InputStream)fileOutPutIO};
        } else if (fileOutPutIO instanceof InputStream[]) {
            arr = (InputStream[])fileOutPutIO;
        } else {
            return null;
        }
        File[] tempFiles = new File[arr.length];
        File[] files = (File[])iXmlSrcObj.get("tempFile");
        for (int i = 0; i < arr.length; ++i) {
            FileStreamInfo fileStreamInfo = this.excel2pdf(iXmlSrcObj, arr[i]);
            if (fileStreamInfo.isTempFile()) {
                if (files[i] != null) {
                    files[i].delete();
                }
                tempFiles[i] = fileStreamInfo.getTempFile();
            }
            arr[i] = fileStreamInfo.getInputStream();
        }
        if (tempFiles[0] != null) {
            iXmlSrcObj.put("tempFile", tempFiles);
        }
        return arr;
    }

    @Override
    public InputStream getFileIS(Context ctx, IXmlSrcObj xmlSrcObj) throws Exception {
        RecordBaseInfo recordBaseInfo = (RecordBaseInfo)xmlSrcObj.get("recordBase");
        Object fileData = xmlSrcObj.get("fileData");
        InputStream is = null;
        if (fileData != null) {
            KDNoteWebServerHelper helper = new KDNoteWebServerHelper();
            is = helper.exportPDF(ctx, recordBaseInfo.getPrintTemplate(), fileData);
        } else {
            is = (InputStream)xmlSrcObj.get("fileOutPutIO");
        }
        FileStreamInfo fileStreamInfo = this.excel2pdf(xmlSrcObj, is);
        if (fileStreamInfo.isTempFile()) {
            FilingUtils.deleteTempFile((File[])xmlSrcObj.get("tempFile"));
            xmlSrcObj.put("tempFile", new File[]{fileStreamInfo.getTempFile()});
        }
        is = fileStreamInfo.getInputStream();
        return is;
    }

    @Override
    public WithoutEntityXmlSrcobj getReportDataSources(Context ctx, ReportFilter info) throws Exception {
        if (!this.isStartSystem(ctx, info)) {
            return null;
        }
        WithoutEntityXmlSrcobj obj = this.createReportDataSources(ctx, info);
        if ((obj = this.initReportDataSources(ctx, info, obj)) == null) {
            logger.error((Object)("initReportDataSources return null:" + info.toString()));
            return null;
        }
        if ((obj = this.fillReportDataSources(ctx, info, obj)) == null) {
            logger.error((Object)("fillReportDataSources return null:" + info.toString()));
            return null;
        }
        if ((obj = this.afterReportDataSources(ctx, info, obj)) == null) {
            logger.error((Object)("afterReportDataSources return null:" + info.toString()));
            return null;
        }
        this.checkSrcObj(obj);
        obj.put("exportFileType", info.getRecordBaseInfo().getExportFileType());
        return obj;
    }

    private void checkSrcObj(WithoutEntityXmlSrcobj obj) throws Exception {
        Iterator<String> it = obj.requireKeys.iterator();
        Map<String, Map<String, Object>> keysMap = obj.keysMap;
        while (it.hasNext()) {
            String key = it.next();
            if (obj.get(key) != null) continue;
            String emptyWarning = keysMap.get(key).get("emptyWarning") + "";
            throw new Exception(emptyWarning);
        }
        if (obj.get("fileData") == null && obj.get("fileOutPutIO") == null) {
            throw new Exception("\u4ea7\u751f\u7684\u62a5\u8868\u6570\u636e\u6e90WithoutEntityXmlSrcobj\u6ca1\u6709\u6587\u4ef6\u4fe1\u606f.");
        }
    }

    public WithoutEntityXmlSrcobj createReportDataSources(Context ctx, ReportFilter info) throws Exception {
        return new WithoutEntityXmlSrcobj();
    }

    public WithoutEntityXmlSrcobj afterReportDataSources(Context ctx, ReportFilter info, WithoutEntityXmlSrcobj obj) throws Exception {
        try {
            HashMap<String, String> currencyMap = new HashMap<String, String>();
            if (info.getCurrency() != null) {
                CurrencyInfo cInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo(H.PK(info.getCurrency().getId()));
                info.setCurrency(cInfo);
                currencyMap.put("id", info.getCurrency().getId().toString());
                currencyMap.put("currencyIsoCode", info.getCurrency().getIsoCode());
                currencyMap.put("name", info.getCurrency().getName());
                obj.put("currency", currencyMap);
                obj.put("currencyName", info.getCurrency().getName());
                obj.put("currencyIsoCode", info.getCurrency().getIsoCode());
            } else {
                logger.error((Object)"$$\u5e01\u522b\u6ca1\u6709\u5440$$");
            }
            obj.put("periodnum", info.getPeriod());
        }
        catch (Exception e) {
            logger.error((Object)("WithoutEntityXmlSrcobj afterReportDataSources put currency" + e.getMessage() + "[" + info.toString() + "]"));
        }
        return obj;
    }

    public WithoutEntityXmlSrcobj initReportDataSources(Context ctx, ReportFilter info, WithoutEntityXmlSrcobj obj) throws Exception {
        HashMap<String, String> orgMap = new HashMap<String, String>();
        FullOrgUnitInfo org = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(H.PK(info.getOrgId()));
        orgMap.put("number", org.getNumber());
        orgMap.put("name", org.getName());
        orgMap.put("id", info.getOrgId());
        obj.put("org", orgMap);
        obj.put("reportType", info.getRecordBaseInfo().getName());
        obj.put("period", info.getPeriod());
        obj.put("year", info.getYear());
        obj.put("fileType", info.getRecordBaseInfo().getExportFileType());
        obj.put("recordBase", info.getRecordBaseInfo());
        try {
            obj.put("currency", info.getCurrency().getName());
        }
        catch (Exception e) {
            logger.error((Object)("WithoutEntityXmlSrcobj put currency" + e.getMessage() + "[" + info.toString() + "]"));
        }
        return obj;
    }

    public boolean isStartSystem(Context ctx, ReportFilter info) throws EASBizException, BOSException {
        SystemEnum systemEnum = SystemEnum.getEnum((int)Integer.parseInt(info.getRecordBaseInfo().getBillType().getPeriodSys()));
        boolean isStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)systemEnum, (IObjectPK)new ObjectStringPK(info.getOrgId()));
        return isStart;
    }

    public abstract WithoutEntityXmlSrcobj fillReportDataSources(Context var1, ReportFilter var2, WithoutEntityXmlSrcobj var3) throws Exception;

    public class WithoutEntityXmlSrcobj
    implements IXmlSrcObj {
        protected Set<String> requireKeys = null;
        protected Map<String, Map<String, Object>> keysMap = null;
        protected Map valueMap = new HashMap();

        public WithoutEntityXmlSrcobj() {
            this.requireKeys = new HashSet<String>();
            this.keysMap = new HashMap<String, Map<String, Object>>();
            HashMap<String, Object> keyDefineMap = new HashMap<String, Object>(2);
            this.requireKeys.add("id");
            this.valueMap.put("id", null);
            this.keysMap.put("id", keyDefineMap);
            keyDefineMap.put("isRequire", true);
            keyDefineMap.put("desc", "\u552f\u4e00\u6807\u8bc6,\u7b49\u6548\u4e8e\u5355\u636eid");
            keyDefineMap.put("emptyWarning", "\u4ea7\u751f\u7684\u62a5\u8868\u6570\u636e\u6e90WithoutEntityXmlSrcobj\u6ca1\u6709\u552f\u4e00\u6807\u8bc6.");
            keyDefineMap = new HashMap(2);
            this.requireKeys.add("org");
            this.valueMap.put("org", null);
            this.keysMap.put("org", keyDefineMap);
            keyDefineMap.put("isRequire", true);
            keyDefineMap.put("desc", "\u62a5\u8868\u5173\u8054\u7684\u7ec4\u7ec7\u4fe1\u606f,\u5e94\u5f53\u662f\u4e00\u4e2amap,\u5f62\u5982{id:xx,number:xxx,name:xyxy}");
            keyDefineMap.put("emptyWarning", "\u4ea7\u751f\u7684\u62a5\u8868\u6570\u636e\u6e90WithoutEntityXmlSrcobj\u6ca1\u6709\u8bbe\u7f6e\u5173\u8054\u7ec4\u7ec7.");
            keyDefineMap = new HashMap(2);
            this.valueMap.put("reportType", null);
            this.keysMap.put("reportType", keyDefineMap);
            keyDefineMap.put("isRequire", false);
            keyDefineMap.put("desc", "\u62a5\u8868\u7c7b\u578b,\u5e94\u8be5\u5b58map,\u5305\u542b\u81f3\u5c11\u5305\u542bname");
            keyDefineMap.put("emptyWarning", "\u4ea7\u751f\u7684\u62a5\u8868\u6570\u636e\u6e90WithoutEntityXmlSrcobj\u6ca1\u6709\u8bbe\u7f6e\u62a5\u8868\u7c7b\u578b.");
            keyDefineMap = new HashMap(2);
            this.requireKeys.add("period");
            this.valueMap.put("period", null);
            this.keysMap.put("period", keyDefineMap);
            keyDefineMap.put("isRequire", true);
            keyDefineMap.put("desc", "\u62a5\u8868\u671f\u95f4");
            keyDefineMap.put("emptyWarning", "\u4ea7\u751f\u7684\u62a5\u8868\u6570\u636e\u6e90WithoutEntityXmlSrcobj\u6ca1\u6709\u8bbe\u7f6e\u62a5\u8868\u671f\u95f4.");
            keyDefineMap = new HashMap(2);
            this.requireKeys.add("year");
            this.valueMap.put("year", null);
            this.keysMap.put("year", keyDefineMap);
            keyDefineMap.put("isRequire", true);
            keyDefineMap.put("desc", "\u62a5\u8868\u5e74\u4efd");
            keyDefineMap.put("emptyWarning", "\u4ea7\u751f\u7684\u62a5\u8868\u6570\u636e\u6e90WithoutEntityXmlSrcobj\u6ca1\u6709\u8bbe\u7f6e\u62a5\u8868\u5e74\u4efd.");
            keyDefineMap = new HashMap(2);
            this.valueMap.put("fileData", null);
            this.keysMap.put("fileData", keyDefineMap);
            keyDefineMap.put("isRequire", false);
            keyDefineMap.put("desc", "\u62a5\u8868\u6587\u4ef6\u4e8c\u8fdb\u5236\u6570\u7ec4,\u4e0efileOutPutIO\u4e8c\u9009\u5176\u4e00");
            keyDefineMap = new HashMap(2);
            this.valueMap.put("fileOutPutIO", null);
            this.keysMap.put("fileOutPutIO", keyDefineMap);
            keyDefineMap.put("isRequire", false);
            keyDefineMap.put("desc", "\u62a5\u8868\u6587\u4ef6io\u6d41,\u4e0efileData\u4e8c\u9009\u5176\u4e00");
            keyDefineMap = new HashMap(2);
            this.requireKeys.add("fileType");
            this.valueMap.put("fileType", null);
            this.keysMap.put("fileType", keyDefineMap);
            keyDefineMap.put("isRequire", true);
            keyDefineMap.put("desc", "\u4ea7\u751f\u7684\u6587\u4ef6\u7684\u683c\u5f0f");
            keyDefineMap.put("emptyWarning", "\u4ea7\u751f\u7684\u62a5\u8868\u6570\u636e\u6e90WithoutEntityXmlSrcobj\u6ca1\u6709\u8bbe\u7f6e\u6587\u4ef6\u683c\u5f0f.");
            keyDefineMap = new HashMap(2);
            this.requireKeys.add("recordBase");
            this.valueMap.put("recordBase", null);
            this.keysMap.put("recordBase", keyDefineMap);
            keyDefineMap.put("isRequire", true);
            keyDefineMap.put("desc", "\u5f52\u6863\u5185\u5bb9\u914d\u7f6e.");
            keyDefineMap.put("emptyWarning", "\u4ea7\u751f\u7684\u62a5\u8868\u6570\u636e\u6e90WithoutEntityXmlSrcobj\u6ca1\u6709\u8bbe\u7f6e\u5f52\u6863\u5185\u5bb9\u914d\u7f6e.");
            keyDefineMap = new HashMap();
            this.requireKeys.add("currency");
            this.valueMap.put("currency", null);
            this.keysMap.put("currency", keyDefineMap);
            keyDefineMap.put("isRequire", true);
            keyDefineMap.put("desc", "\u62a5\u8868\u4f7f\u7528\u7684\u5e01\u522b.\u9ed8\u8ba4\u4f7f\u7528\u516c\u53f8\u7684\u672c\u4f4d\u5e01");
            keyDefineMap.put("emptyWarning", "\u4ea7\u751f\u7684\u62a5\u8868\u6570\u636e\u6e90WithoutEntityXmlSrcobj\u6ca1\u6709\u8bbe\u7f6e\u5f52\u6863\u4f7f\u7528\u7684\u5e01\u522b.");
        }

        @Override
        public Object get(Object key) {
            return this.valueMap.get(key);
        }

        @Override
        public Set keySet() {
            return this.valueMap.keySet();
        }

        @Override
        public void put(String key, Object value) {
            this.valueMap.put(key, value);
        }

        public void putKey(String key, Map<String, Object> keyDefineMap) {
            this.keysMap.put(key, keyDefineMap);
            if (Boolean.TRUE.equals(keyDefineMap.get("isRequire"))) {
                this.requireKeys.add(key);
            }
        }
    }
}

