/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.arap.dataGridExcel;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.el.rec.tool.engine.arap.dataGridExcel.IDataGridExcelAdapter;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.Colour;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;

public class DataGridExcelAdapter
implements IDataGridExcelAdapter {
    @Override
    public WritableSheet createWsheet(WritableSheet wsheet, String title, String[] columnModel, String[] headerModel, List datas, Context ctx) throws BOSException {
        try {
            int j;
            int i;
            WritableFont wfont = new WritableFont(WritableFont.createFont((String)"\u5b8b\u4f53"), 16, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
            WritableCellFormat wcfFC = new WritableCellFormat(wfont);
            wcfFC.setAlignment(Alignment.CENTRE);
            wcfFC.setVerticalAlignment(VerticalAlignment.CENTRE);
            wsheet.addCell((WritableCell)new Label(0, 0, title, (CellFormat)wcfFC));
            WritableFont colfont = new WritableFont(WritableFont.createFont((String)"\u5b8b\u4f53"), 10, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
            WritableCellFormat colFormat = new WritableCellFormat(colfont);
            colFormat.setWrap(true);
            colFormat.setAlignment(Alignment.CENTRE);
            colFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
            colFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
            int nCol = 0;
            int nRow = 1;
            if (headerModel.length > 0) {
                nRow = 2;
            }
            String notHiddenColumn = "";
            for (int i2 = 0; i2 < columnModel.length; ++i2) {
                String[] column = columnModel[i2].split(",");
                boolean isHidden = Boolean.valueOf(column[1]);
                if (isHidden) continue;
                Label cell = new Label(nCol, nRow, column[2]);
                cell.setCellFormat((CellFormat)colFormat);
                wsheet.addCell((WritableCell)cell);
                wsheet.setColumnView(nCol, Double.valueOf(column[3]).intValue() / 6);
                ++nCol;
                notHiddenColumn = notHiddenColumn + columnModel[i2] + ";";
            }
            String[] notHiddenColumnModel = new String[]{};
            if (notHiddenColumn.length() > 0) {
                notHiddenColumnModel = notHiddenColumn.substring(0, notHiddenColumn.length() - 1).split(";");
            }
            for (i = 0; i < notHiddenColumnModel.length; ++i) {
                String[] column = notHiddenColumnModel[i].split(",");
                boolean flag = false;
                for (j = 0; j < headerModel.length; ++j) {
                    String[] header = headerModel[j].split(",");
                    if (!column[0].equals(header[0])) continue;
                    flag = true;
                    wsheet.mergeCells(i, 1, i + Integer.parseInt(header[1]) - 1, 1);
                    String titleText = header[2];
                    if (titleText.indexOf(">") > -1 && titleText.indexOf("<") > -1) {
                        titleText = titleText.substring(titleText.indexOf(">") + 1, titleText.lastIndexOf("<"));
                    }
                    Label cell = new Label(i, 1, titleText);
                    cell.setCellFormat((CellFormat)colFormat);
                    wsheet.addCell((WritableCell)cell);
                    i += Integer.parseInt(header[1]) - 1;
                    break;
                }
                if (flag) continue;
                wsheet.mergeCells(i, 1, i, 2);
                Label cell = new Label(i, 1, column[2]);
                cell.setCellFormat((CellFormat)colFormat);
                wsheet.addCell((WritableCell)cell);
            }
            wsheet.mergeCells(0, 0, nCol - 1, 0);
            for (i = 0; i < datas.size(); ++i) {
                int col = 0;
                Map info = (Map)datas.get(i);
                for (j = 0; j < columnModel.length; ++j) {
                    String dateFormat;
                    String[] column = columnModel[j].split(",");
                    boolean isHidden = Boolean.valueOf(column[1]);
                    if (isHidden) continue;
                    WritableFont cellfont = new WritableFont(WritableFont.createFont((String)"\u5b8b\u4f53"), 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
                    WritableCellFormat cellFormat = new WritableCellFormat(cellfont);
                    cellFormat.setWrap(true);
                    cellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
                    if (column[4] != null) {
                        if (column[4].equals("center")) {
                            cellFormat.setAlignment(Alignment.CENTRE);
                        } else if (column[4].equals("left")) {
                            cellFormat.setAlignment(Alignment.LEFT);
                        } else if (column[4].equals("right")) {
                            cellFormat.setAlignment(Alignment.RIGHT);
                        }
                    }
                    Object value = null;
                    if (info != null && info.get(column[0]) != null) {
                        value = info.get(column[0]);
                    }
                    Label cell = new Label(col, i + nRow + 1, value == null ? null : value.toString());
                    if (value != null && column != null && column.length > 0 && ("numberfield".equals(column[column.length - 1]) || "number".equals(column[column.length - 1]) || "integer".equals(column[column.length - 1])) && value.toString().matches("-?[0-9]+(\\.[0-9]+)?")) {
                        value = Double.valueOf(value.toString());
                    }
                    if (value instanceof java.lang.Number) {
                        cell = new Number(col, i + nRow + 1, (value == null ? null : Double.valueOf(((java.lang.Number)value).doubleValue())).doubleValue());
                    } else if (value instanceof Timestamp) {
                        dateFormat = "yyyy-MM-dd HH:mm:ss";
                        if (column.length > 6 && column[5].equals("date") && column[6] != null) {
                            dateFormat = this.getDateFormat(column[6]);
                        }
                        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
                        String timeString = format.format(value);
                        cell = new Label(col, i + nRow + 1, value == null ? null : timeString);
                    } else if (value instanceof Date) {
                        dateFormat = "yyyy-MM-dd";
                        if (column.length > 6 && column[5].equals("date") && column[6] != null) {
                            dateFormat = this.getDateFormat(column[6].replaceAll("m", "M"));
                        }
                        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
                        String dateString = format.format(value);
                        cell = new Label(col, i + nRow + 1, value == null ? null : dateString);
                    } else if (value instanceof Boolean) {
                        List list = EnumUtils.getEnumList((String)"com.kingdee.eas.base.commonquery.BooleanEnum");
                        for (int index = 0; index < list.size(); ++index) {
                            Enum enumItem = (Enum)list.get(index);
                            if (!enumItem.getName().toLowerCase().equals(value.toString().toLowerCase())) continue;
                            value = enumItem.getAlias(ctx.getLocale());
                        }
                        cell = new Label(col, i + nRow + 1, value == null ? null : value.toString());
                    }
                    cell.setCellFormat((CellFormat)cellFormat);
                    wsheet.addCell((WritableCell)cell);
                    ++col;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        return wsheet;
    }

    private String getDateFormat(String dateFormat) {
        if (dateFormat.indexOf("y") >= 0 && dateFormat.indexOf("y") == dateFormat.lastIndexOf("y") && dateFormat.indexOf("m") >= 0 && dateFormat.indexOf("m") == dateFormat.lastIndexOf("m") && dateFormat.indexOf("d") >= 0 && dateFormat.indexOf("d") == dateFormat.lastIndexOf("d")) {
            dateFormat = dateFormat.replace("y", "yyyy").replace("m", "MM").replace("d", "dd");
        } else if (dateFormat.indexOf("Y") >= 0 && dateFormat.indexOf("Y") == dateFormat.lastIndexOf("Y") && dateFormat.indexOf("m") >= 0 && dateFormat.indexOf("m") == dateFormat.lastIndexOf("m") && dateFormat.indexOf("d") >= 0 && dateFormat.indexOf("d") == dateFormat.lastIndexOf("d")) {
            dateFormat = dateFormat.replace("Y", "yyyy").replace("m", "MM").replace("d", "dd");
        } else if (dateFormat.indexOf("yy") >= 0 && dateFormat.indexOf("yy") == dateFormat.lastIndexOf("yy") && dateFormat.indexOf("mm") >= 0 && dateFormat.indexOf("mm") == dateFormat.lastIndexOf("mm") && dateFormat.indexOf("dd") >= 0 && dateFormat.indexOf("dd") == dateFormat.lastIndexOf("dd")) {
            dateFormat = dateFormat.replace("yy", "yyyy").replace("mm", "MM");
        } else if (dateFormat.indexOf("yy") >= 0 && dateFormat.indexOf("yy") == dateFormat.lastIndexOf("yy") && dateFormat.indexOf("MM") >= 0 && dateFormat.indexOf("MM") == dateFormat.lastIndexOf("MM") && dateFormat.indexOf("dd") >= 0 && dateFormat.indexOf("dd") == dateFormat.lastIndexOf("dd")) {
            dateFormat = dateFormat.replace("yy", "yyyy");
        }
        return dateFormat;
    }
}

