/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.tool.KDNoteWebServerHelper;
import com.kingdee.eas.el.rec.tool.engine.cas.CASRptBaseService;
import com.kingdee.eas.el.rec.tool.engine.cas.provider.CASBankBalanceDataProvider;
import com.kingdee.eas.fi.cas.BankBalanceAdjustCollection;
import com.kingdee.eas.fi.cas.BankBalanceAdjustFactory;
import com.kingdee.eas.fi.cas.BankBalanceCondition;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.BankStmtBookReportInfo;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.model.ExcelTool2007;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CASBankBalanceService
extends CASRptBaseService {
    private Logger logger = Logger.getLogger(this.getClass());
    private ReportFilter reportFilter;

    public CASBankBalanceService(ReportFilter reportFilter) {
        this.reportFilter = reportFilter;
    }

    public CASBankBalanceService() {
    }

    @Override
    protected Set getAllData() throws BOSException {
        Set condition = new HashSet();
        Set exportData = new HashSet();
        try {
            condition = this.genConditions();
            BankBalanceAdjustFactory.getLocalInstance((Context)this.ctx).genBankBalance(condition);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            view.setFilter(filter);
            view.setSelector(sic);
            filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)this.accountBankSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)this.perCol.get(0).getId()));
            sic.add(new SelectorItemInfo("id"));
            BankBalanceAdjustCollection colls = BankBalanceAdjustFactory.getLocalInstance((Context)this.ctx).getBankBalanceAdjustCollection(view);
            if (colls.size() == 0) {
                return exportData;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < colls.size(); ++i) {
                if (i == colls.size() - 1) {
                    sb.append(colls.get(i).getId().toString());
                    continue;
                }
                sb.append(colls.get(i).getId().toString() + ",");
            }
            exportData = BankBalanceAdjustFactory.getLocalInstance((Context)this.ctx).getBalanceAdjustPageInitData(sb.toString());
        }
        catch (EASBizException e) {
            this.logger.error((Object)e);
        }
        return exportData;
    }

    @Override
    protected InputStream getPrint(Set data) {
        Iterator it = data.iterator();
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        ByteArrayInputStream inputStream = null;
        int index = 0;
        ExcelTool2007 excelTool = null;
        while (it.hasNext()) {
            Map result = (Map)it.next();
            StringBuffer queryString = new StringBuffer("");
            queryString.append(CASWebUtil.getResource((Context)this.ctx, (String)"357_OUTSTANDINGUNREACH_EXCEL_COMPANYNAME") + ":");
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)result.get("companyOrg");
            queryString.append(companyOrgUnitInfo.getName());
            queryString.append("," + CASWebUtil.getResource((Context)this.ctx, (String)"387_CASHCONTRASTGLE_ACCOUNTBANKNO") + ":");
            AccountBankInfo accountBankInfo = (AccountBankInfo)result.get("accountBank");
            queryString.append(accountBankInfo.getBankAccountNumber() + " " + accountBankInfo.getName());
            queryString.append(",\u94f6\u884c\u79d1\u76ee:");
            queryString.append(accountBankInfo.getAccount().getNumber() + accountBankInfo.getAccount().getName());
            queryString.append("," + CASWebUtil.getResource((Context)this.ctx, (String)"389_CASHCONTRASTGLE_CURRENCY") + ":");
            CurrencyInfo currencyInfo = (CurrencyInfo)result.get("currencyInfo");
            queryString.append(currencyInfo.getName());
            queryString.append("," + CASWebUtil.getResource((Context)this.ctx, (String)"399_OUTBALANCEADJUST_PERIOD") + ":");
            PeriodInfo periodInfo = (PeriodInfo)result.get("periodInfo");
            queryString.append(periodInfo);
            if (null != excelTool) {
                excelTool.createSheet(accountBankInfo.getBankAccountNumber() + "-" + currencyInfo.getName());
            } else {
                excelTool = new ExcelTool2007(accountBankInfo.getBankAccountNumber() + "-" + currencyInfo.getName());
            }
            int precision = Integer.valueOf(result.get("precision").toString());
            BankStmtBookReportInfo bankStmtBookReportInfo = (BankStmtBookReportInfo)result.get("rptInfo");
            BigDecimal labelEntAdjuest = (BigDecimal)result.get("entBalance");
            labelEntAdjuest = labelEntAdjuest.setScale(precision, 4);
            try {
                this.balanceAdjustEntData2007(excelTool, bankStmtBookReportInfo, this.ctx, labelEntAdjuest.toString(), precision, queryString);
                BigDecimal labelBankAdjuest = (BigDecimal)result.get("bankBalance");
                labelBankAdjuest = labelBankAdjuest.setScale(precision, 4);
                this.balanceAdjustBankData2007(excelTool, bankStmtBookReportInfo, this.ctx, labelBankAdjuest.toString(), precision);
                BankStatementCollection entCollection = (BankStatementCollection)result.get("entprUnreachedColl");
                int entCount = entCollection.size();
                this.entprUnreachedColl2007(excelTool, entCollection, this.ctx, precision);
                JournalCollection bankCollection = (JournalCollection)result.get("bankUnreachedColl");
                this.bankUnreachedColl2007(excelTool, bankCollection, this.ctx, entCount, precision);
                ++index;
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
        if (null == excelTool) {
            return null;
        }
        XSSFWorkbook workbook = excelTool.getWorkbook();
        try {
            workbook.write((OutputStream)boas);
            inputStream = new ByteArrayInputStream(boas.toByteArray());
            boas.close();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        return inputStream;
    }

    private void balanceAdjustEntData2007(ExcelTool2007 excelTool, BankStmtBookReportInfo bankStmtBookReportInfo, Context ctx, String adjuest, int precision, StringBuffer queryString) throws Exception {
        XSSFCell cell = excelTool.getCell(0, 0, excelTool.getQueryTitleStyle());
        cell.setCellValue(queryString.toString());
        XSSFCellStyle style = excelTool.getNormalStyle(2);
        XSSFCellStyle styleLeft = excelTool.getNormalStyle(0);
        XSSFDataFormat format = excelTool.getWorkbook().createDataFormat();
        String value = StringUtils.leftPad((String)"0", (int)precision, (String)"0");
        style.setDataFormat(format.getFormat("#,##0." + value));
        cell = excelTool.getCell(1, 0, excelTool.getHeadStyle());
        cell.setCellValue(CASWebUtil.getResource((Context)ctx, (String)"395_OUTBALANCEADJUST_JOURNAL"));
        XSSFSheet sheet = excelTool.getSheet();
        sheet.setDefaultColumnWidth(20);
        sheet.addMergedRegion(excelTool.getCellRangeAddress(1, 1, 0, 3));
        cell = excelTool.getCell(2, 0, styleLeft);
        cell.setCellValue(CASWebUtil.getResource((Context)ctx, (String)"396_OUTBALANCEADJUST_ENDINGBALANCE"));
        cell = excelTool.getCell(2, 3, style);
        BigDecimal bankBookAmt = bankStmtBookReportInfo.getBankBookAmt();
        bankBookAmt = bankBookAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(bankBookAmt.toString()).doubleValue());
        cell = excelTool.getCell(3, 1, styleLeft);
        cell.setCellValue(CASWebUtil.getResource((Context)ctx, (String)"397_PLUS") + CASWebUtil.getResource((Context)ctx, (String)"398_OUTBALANCEADJUST_BANK_RECEIVED"));
        cell = excelTool.getCell(3, 3, style);
        BigDecimal bankGotAmt = bankStmtBookReportInfo.getBankGotAmt();
        bankBookAmt = bankBookAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(bankGotAmt.toString()).doubleValue());
        sheet.addMergedRegion(excelTool.getCellRangeAddress(2, 2, 1, 2));
        sheet.addMergedRegion(excelTool.getCellRangeAddress(0, 0, 0, 8));
        cell = excelTool.getCell(4, 1, styleLeft);
        cell.setCellValue(CASWebUtil.getResource((Context)ctx, (String)"370_LESS") + CASWebUtil.getResource((Context)ctx, (String)"371_OUTBALANCEADJUST_BANK_PAID"));
        cell = excelTool.getCell(4, 3, style);
        BigDecimal bankPayedAmt = bankStmtBookReportInfo.getBankPayedAmt();
        bankPayedAmt = bankPayedAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(bankPayedAmt.toString()).doubleValue());
        sheet.addMergedRegion(excelTool.getCellRangeAddress(3, 3, 1, 2));
        cell = excelTool.getCell(5, 0, styleLeft);
        cell.setCellValue(CASWebUtil.getResource((Context)ctx, (String)"372_OUTBALANCEADJUST_ENDINGBALANCE_UPDATE"));
        cell = excelTool.getCell(5, 3, style);
        cell.setCellValue(Double.valueOf(adjuest).doubleValue());
    }

    private void balanceAdjustBankData2007(ExcelTool2007 excelTool, BankStmtBookReportInfo bankStmtBookReportInfo, Context ctx, String adjuest, int precision) throws Exception {
        XSSFCellStyle style = excelTool.getNormalStyle(2);
        XSSFCellStyle styleLeft = excelTool.getNormalStyle(0);
        XSSFDataFormat format = excelTool.getWorkbook().createDataFormat();
        String value = StringUtils.leftPad((String)"0", (int)precision, (String)"0");
        style.setDataFormat(format.getFormat("#,##0." + value));
        XSSFCell cell = excelTool.getCell(1, 5, excelTool.getHeadStyle());
        cell.setCellValue(CASWebUtil.getResource((Context)ctx, (String)"373_OUTBALANCEADJUST_BANK_STATEMENTS"));
        XSSFSheet sheet = excelTool.getSheet();
        sheet.addMergedRegion(excelTool.getCellRangeAddress(1, 1, 5, 8));
        cell = excelTool.getCell(2, 5, styleLeft);
        cell.setCellValue(CASWebUtil.getResource((Context)ctx, (String)"396_OUTBALANCEADJUST_ENDINGBALANCE"));
        cell = excelTool.getCell(2, 8, style);
        BigDecimal bankStmtAmt = bankStmtBookReportInfo.getBankStmtAmt();
        bankStmtAmt = bankStmtAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(bankStmtAmt.toString()).doubleValue());
        cell = excelTool.getCell(3, 6, styleLeft);
        cell.setCellValue(CASWebUtil.getResource((Context)ctx, (String)"397_PLUS") + CASWebUtil.getResource((Context)ctx, (String)"374_OUTBALANCEADJUST_COMPANY_RECEIVED"));
        sheet.addMergedRegion(excelTool.getCellRangeAddress(2, 2, 6, 7));
        cell = excelTool.getCell(3, 8, style);
        BigDecimal entprGotAmt = bankStmtBookReportInfo.getEntprGotAmt();
        entprGotAmt = entprGotAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(entprGotAmt.toString()).doubleValue());
        cell = excelTool.getCell(4, 6, styleLeft);
        cell.setCellValue(CASWebUtil.getResource((Context)ctx, (String)"370_LESS") + CASWebUtil.getResource((Context)ctx, (String)"375_OUTBALANCEADJUST_COMPANY_PAID"));
        sheet.addMergedRegion(excelTool.getCellRangeAddress(3, 3, 6, 7));
        cell = excelTool.getCell(4, 8, style);
        BigDecimal entprPayedAmt = bankStmtBookReportInfo.getEntprPayedAmt();
        entprPayedAmt = entprPayedAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(entprPayedAmt.toString()).doubleValue());
        cell = excelTool.getCell(5, 5, styleLeft);
        cell.setCellValue(CASWebUtil.getResource((Context)ctx, (String)"372_OUTBALANCEADJUST_ENDINGBALANCE_UPDATE"));
        cell = excelTool.getCell(5, 8, style);
        cell.setCellValue(Double.valueOf(adjuest).doubleValue());
    }

    private void entprUnreachedColl2007(ExcelTool2007 excelTool, BankStatementCollection entCollection, Context ctx, int precision) throws Exception {
        String[] tableHeader = new String[10];
        tableHeader[0] = CASWebUtil.getResource((Context)ctx, (String)"358_OUTSTANDINGUNREACH_EXCEL_DATE");
        tableHeader[1] = CASWebUtil.getResource((Context)ctx, (String)"352_OUTSTANDINGUNREACH_EXCEL_DESCRIPTION");
        tableHeader[2] = "\u652f\u7968\u53f7";
        tableHeader[3] = CASWebUtil.getResource((Context)ctx, (String)"398_OUTBALANCEADJUST_BANK_RECEIVED");
        tableHeader[4] = CASWebUtil.getResource((Context)ctx, (String)"371_OUTBALANCEADJUST_BANK_PAID");
        excelTool.createTableHeader(tableHeader, 10);
        XSSFCell cell = excelTool.getCell(8, 0, excelTool.getHeadStyle());
        cell.setCellValue(CASWebUtil.getResource((Context)ctx, (String)"376_OUTBALANCEADJUST_TITLE1"));
        XSSFSheet sheet = excelTool.getSheet();
        sheet.addMergedRegion(excelTool.getCellRangeAddress(8, 9, 0, 4));
        XSSFCellStyle styleCenter = excelTool.getNormalStyle(1);
        XSSFCellStyle styleLeft = excelTool.getNormalStyle(0);
        XSSFCellStyle styleRight = excelTool.getNormalStyle(2);
        XSSFDataFormat format = excelTool.getWorkbook().createDataFormat();
        String value = StringUtils.leftPad((String)"0", (int)precision, (String)"0");
        styleRight.setDataFormat(format.getFormat("#,##0." + value));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        int listRowNum = 11;
        for (int i = 0; entCollection != null && i < entCollection.size(); ++i) {
            BankStatementInfo bankStatementInfo = entCollection.get(i);
            cell = excelTool.getCell(i + listRowNum, 0, styleCenter);
            cell.setCellValue(df.format(bankStatementInfo.getCreateDate()));
            cell = excelTool.getCell(i + listRowNum, 1, styleLeft);
            cell.setCellValue(bankStatementInfo.getDescription() == null ? "" : bankStatementInfo.getDescription());
            cell = excelTool.getCell(i + listRowNum, 2, styleLeft);
            cell.setCellValue(bankStatementInfo.getSettleNumber() == null ? "" : bankStatementInfo.getSettleNumber());
            cell = excelTool.getCell(i + listRowNum, 3, styleRight);
            BigDecimal debitAmount = bankStatementInfo.getDebitAmount();
            BigDecimal creditAmount = bankStatementInfo.getCreditAmount();
            debitAmount = debitAmount.setScale(precision, 4);
            cell.setCellValue(Double.valueOf(creditAmount.toString()).doubleValue());
            cell = excelTool.getCell(i + listRowNum, 4, styleRight);
            creditAmount = creditAmount.setScale(precision, 4);
            cell.setCellValue(Double.valueOf(debitAmount.toString()).doubleValue());
        }
    }

    private void bankUnreachedColl2007(ExcelTool2007 excelTool, JournalCollection bankCollection, Context ctx, int entCount, int precision) throws Exception {
        int startNum = 11 + entCount;
        String[] tableHeader = new String[10];
        tableHeader[0] = CASWebUtil.getResource((Context)ctx, (String)"358_OUTSTANDINGUNREACH_EXCEL_DATE");
        tableHeader[1] = "\u51ed\u8bc1\u53f7";
        tableHeader[2] = "\u652f\u7968\u53f7";
        tableHeader[3] = CASWebUtil.getResource((Context)ctx, (String)"352_OUTSTANDINGUNREACH_EXCEL_DESCRIPTION");
        tableHeader[4] = CASWebUtil.getResource((Context)ctx, (String)"374_OUTBALANCEADJUST_COMPANY_RECEIVED");
        tableHeader[5] = CASWebUtil.getResource((Context)ctx, (String)"375_OUTBALANCEADJUST_COMPANY_PAID");
        excelTool.createTableHeader(tableHeader, startNum + 2);
        XSSFCell cell = excelTool.getCell(startNum, 0, excelTool.getHeadStyle());
        cell.setCellValue(CASWebUtil.getResource((Context)ctx, (String)"377_OUTBALANCEADJUST_TITLE2"));
        XSSFSheet sheet = excelTool.getSheet();
        sheet.addMergedRegion(excelTool.getCellRangeAddress(startNum, startNum + 1, 0, 5));
        XSSFCellStyle styleCenter = excelTool.getNormalStyle(1);
        XSSFCellStyle styleLeft = excelTool.getNormalStyle(0);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        int listRowNum = startNum + 3;
        XSSFCellStyle style = excelTool.getNormalStyle(2);
        XSSFDataFormat format = excelTool.getWorkbook().createDataFormat();
        String value = StringUtils.leftPad((String)"0", (int)precision, (String)"0");
        style.setDataFormat(format.getFormat("#,##0." + value));
        for (int i = 0; bankCollection != null && i < bankCollection.size(); ++i) {
            JournalInfo bankStatementInfo = bankCollection.get(i);
            cell = excelTool.getCell(i + listRowNum, 0, styleCenter);
            cell.setCellValue(df.format(bankStatementInfo.getCreateDate()));
            cell = excelTool.getCell(i + listRowNum, 1, styleLeft);
            String voucherNumber = bankStatementInfo.getVoucherNumber() == null ? "" : bankStatementInfo.getVoucherNumber();
            cell.setCellValue(voucherNumber);
            cell = excelTool.getCell(i + listRowNum, 2, styleLeft);
            String settlementNumber = bankStatementInfo.getSettlementNumber() == null ? "" : bankStatementInfo.getSettlementNumber();
            cell.setCellValue(settlementNumber);
            cell = excelTool.getCell(i + listRowNum, 3, styleLeft);
            cell.setCellValue(bankStatementInfo.getDescription() == null ? "" : bankStatementInfo.getDescription());
            cell = excelTool.getCell(i + listRowNum, 4, style);
            BigDecimal debitAmount = bankStatementInfo.getDebitAmount();
            debitAmount = debitAmount.setScale(precision, 4);
            cell.setCellValue(Double.valueOf(debitAmount.toString()).doubleValue());
            cell = excelTool.getCell(i + listRowNum, 5, style);
            BigDecimal creditAmount = bankStatementInfo.getCreditAmount();
            creditAmount = creditAmount.setScale(precision, 4);
            cell.setCellValue(Double.valueOf(creditAmount.toString()).doubleValue());
        }
    }

    protected Set genConditions() throws EASBizException, BOSException {
        HashSet<BankBalanceCondition> conSet = new HashSet<BankBalanceCondition>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.accountBankSet, CompareType.INCLUDE));
        AccountBankCollection bankAccts = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankCollection(view);
        if (bankAccts.size() > 0) {
            for (int index = 0; index < bankAccts.size(); ++index) {
                AccountBankInfo info = bankAccts.get(index);
                if (info.getShareType().getValue() == 1) {
                    info = CASBankBalanceService.getShareBalanceOfAcct(this.ctx, info, null);
                }
                if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency())) {
                    BankBalanceCondition condition = new BankBalanceCondition();
                    condition.setIsForInit(false);
                    if (info.getShareType().getValue() == 1) {
                        condition.setCompanyInfo(info.getShareAcct().getShareBalanceOfAcctCompany());
                    } else {
                        condition.setCompanyInfo(info.getCompany());
                    }
                    condition.setBankId(info.getId().toString());
                    condition.setPeriodId(this.perCol.get(0).getId().toString());
                    condition.setCurrencyId(info.getCurrency().getId().toString());
                    if (this.reportFilter != null && this.reportFilter.getCurrency() != null) {
                        condition.setCurrencyId(this.reportFilter.getCurrency().getId().toString());
                    }
                    conSet.add(condition);
                    continue;
                }
                Set curSet = this.getAccountCurrency(info.getId().toString());
                Iterator it = curSet.iterator();
                while (it.hasNext()) {
                    BankBalanceCondition condition = new BankBalanceCondition();
                    condition.setIsForInit(false);
                    condition.setCompanyInfo(info.getCompany());
                    condition.setBankId(info.getId().toString());
                    condition.setPeriodId(this.perCol.get(0).getId().toString());
                    condition.setCurrencyId((String)it.next());
                    if (this.reportFilter != null && this.reportFilter.getCurrency() != null) {
                        condition.setCurrencyId(this.reportFilter.getCurrency().getId().toString());
                    }
                    conSet.add(condition);
                }
            }
        }
        return conSet;
    }

    private Set getAccountCurrency(String bankAcctId) {
        HashSet<String> idSet = new HashSet<String>();
        try {
            String sSQL = "Select FCurrencyId From T_Cas_Journal Where FAccountBankId = '" + bankAcctId + "' union Select FCurrencyId From T_Cas_BankStatement Where FAccountBankId = '" + bankAcctId + "'";
            ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)this.ctx, (String)sSQL);
            IRowSet rs = exec.executeSQL();
            while (rs.next()) {
                idSet.add(rs.getString("FCurrencyId"));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return idSet;
    }

    private static AccountBankInfo getShareBalanceOfAcct(Context ctx, AccountBankInfo accountbank, String companyid) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.*"));
        selector.add(new SelectorItemInfo("currency.*"));
        selector.add(new SelectorItemInfo("shareAcct.*"));
        selector.add(new SelectorItemInfo("shareAcct.bankAccount.*"));
        selector.add(new SelectorItemInfo("shareType"));
        AccountBankInfo accBankInfo = null;
        accBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountbank.getId().toString()), selector);
        if (accBankInfo.getShareType().getValue() == 0) {
            return accBankInfo;
        }
        SharedAcctInfo sharedAcctInfo = accBankInfo.getShareAcct();
        accBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(sharedAcctInfo.getBankAccount().getId().toString()), selector);
        return accBankInfo;
    }

    @Override
    protected Object getPdfPrint(Set data, String printTemplate) {
        if (data == null || data.size() == 0) {
            return null;
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)SysContext.getSysContext().getCurrentUserInfo())) {
            SysContext.getSysContext().setCurrentUserInfo((UserInfo)this.ctx.get((Object)"UserInfo"));
        }
        CASBankBalanceDataProvider provider = new CASBankBalanceDataProvider(this.ctx, data, this.company, this.perCol);
        KDNoteWebServerHelper kdNoteHelper = new KDNoteWebServerHelper();
        return kdNoteHelper.exportPDFs(this.ctx, printTemplate, provider);
    }
}

