/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CasBankJournalDataProvider
implements BOSQueryDelegate {
    private Set data;
    private Context ctx;
    protected CompanyOrgUnitInfo company;
    protected PeriodCollection perCol;
    private Logger logger = Logger.getLogger(this.getClass());

    public CasBankJournalDataProvider(Context ctx, Set data, CompanyOrgUnitInfo company, PeriodCollection perCol) {
        this.ctx = ctx;
        this.data = data;
        this.company = company;
        this.perCol = perCol;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        Iterator it = this.data.iterator();
        DynamicRowSet drs = null;
        try {
            drs = this.initDrowSet();
            drs.beforeFirst();
            while (it.hasNext()) {
                BigDecimal startBalance;
                JournalCollection coll = (JournalCollection)it.next();
                String bankAcountName = coll.get(0).getAccountBank().getName();
                if (coll.get(0).getCurrency() == null) continue;
                CurrencyInfo currencyinfo = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(coll.get(0).getCurrency().getId().toString()));
                String currency = currencyinfo.getName();
                BigDecimal balance = new BigDecimal(0);
                BigDecimal debitAmount = new BigDecimal(0);
                BigDecimal creditAmount = new BigDecimal(0);
                BigDecimal dayDebitAmount = new BigDecimal(0);
                BigDecimal dayCreditAmount = new BigDecimal(0);
                BigDecimal countDebitAmount = new BigDecimal(0);
                BigDecimal countCreditAmount = new BigDecimal(0);
                HashMap<String, Object> map = new HashMap<String, Object>();
                String periodString = "";
                String dc = "\u501f";
                BigDecimal rate = new BigDecimal(1);
                if (!coll.get(0).getCurrency().getId().equals((Object)this.company.getBaseCurrency().getId())) {
                    rate = this.getExchange(this.company, coll.get(0).getCurrency(), this.company.getBaseCurrency(), this.perCol.get(0).getBeginDate());
                    ExchangeRateInfo eInfo = this.getExRateInfo(coll.get(0).getCurrency(), this.company.getBaseCurrency(), this.company, this.perCol.get(0).getBeginDate());
                    if (eInfo != null && ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)eInfo.getConvertMode())) {
                        rate = Constants.ONE.divide(rate, 20, 4);
                    }
                }
                if ((startBalance = this.getBeginBalanceNew(this.company, coll.get(0).getCurrency(), this.perCol.get(0), coll.get(0).getAccountView(), coll.get(0).getAccountBank(), 2)).compareTo(BigDecimal.ZERO) == -1) {
                    dc = "\u8d37";
                } else if (startBalance.compareTo(BigDecimal.ZERO) == 0) {
                    dc = "\u5e73";
                }
                PeriodInfo period = new PeriodInfo();
                for (int i = 0; i < coll.size(); ++i) {
                    JournalInfo info = coll.get(i);
                    info.setCurrency(currencyinfo);
                    info.setCompany(this.company);
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPeriod())) {
                        period = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(info.getPeriod().getId().toString()));
                        periodString = period.getPeriodYear() + "\u5e74" + period.getPeriodNumber() + "\u671f";
                        info.setPeriod(period);
                    }
                    if (i == 0) {
                        map.put("balance", startBalance.setScale(2, 4).abs().toString());
                        map.put("description", "\u671f\u521d\u4f59\u989d");
                        map.put("isDebit", dc);
                        map.put("date", this.perCol.get(0).getBeginDate());
                        map.put("bankAccount", bankAcountName);
                        map.put("currency", currency);
                        map.put("debitAmount", "");
                        map.put("creditAmount", "");
                        map.put("periodString", periodString);
                        map.put("company", this.company.getName());
                        this.createCountRow(drs, rate, map);
                    }
                    debitAmount = info.getDebitAmount();
                    countDebitAmount = countDebitAmount.add(debitAmount).setScale(2, 4);
                    dayDebitAmount = dayDebitAmount.add(debitAmount).setScale(2, 4);
                    creditAmount = info.getCreditAmount();
                    countCreditAmount = countCreditAmount.add(creditAmount).setScale(2, 4);
                    dayCreditAmount = dayCreditAmount.add(creditAmount).setScale(2, 4);
                    balance = startBalance.add(countDebitAmount.subtract(countCreditAmount)).setScale(2, 4);
                    balance = balance.abs();
                    this.createJournal(drs, info, balance, rate);
                    if (i < coll.size() - 1 && !coll.get(i).getCreateDate().equals(coll.get(i + 1).getCreateDate())) {
                        map.put("balance", balance.toString());
                        map.put("date", coll.get(i).getCreateDate());
                        map.put("description", "\u672c\u65e5\u5408\u8ba1");
                        map.put("debitAmount", dayDebitAmount.toString());
                        map.put("creditAmount", dayCreditAmount.toString());
                        map.put("periodString", periodString);
                        map.put("company", this.company.getName());
                        if (coll.get(i).isIsDebit()) {
                            map.put("isDebit", "\u501f");
                        } else {
                            map.put("isDebit", "\u8d37");
                        }
                        map.put("bankAccount", bankAcountName);
                        map.put("currency", currency);
                        map.put("periodString", periodString);
                        this.createCountRow(drs, rate, map);
                        dayDebitAmount = new BigDecimal(0);
                        dayCreditAmount = new BigDecimal(0);
                    }
                    if (i != coll.size() - 1) continue;
                    map.put("balance", balance.toString());
                    map.put("date", coll.get(i).getCreateDate());
                    map.put("description", "\u672c\u65e5\u5408\u8ba1");
                    map.put("debitAmount", dayDebitAmount.toString());
                    map.put("creditAmount", dayCreditAmount.toString());
                    if (coll.get(i).isIsDebit()) {
                        map.put("isDebit", "\u501f");
                    } else {
                        map.put("isDebit", "\u8d37");
                    }
                    map.put("bankAccount", bankAcountName);
                    map.put("currency", currency);
                    map.put("periodString", periodString);
                    this.createCountRow(drs, rate, map);
                    map.put("date", this.perCol.get(0).getEndDate());
                    map.put("description", "\u672c\u671f\u5408\u8ba1");
                    map.put("debitAmount", countDebitAmount.toString());
                    map.put("creditAmount", countCreditAmount.toString());
                    map.put("bankAccount", bankAcountName);
                    map.put("currency", currency);
                    map.put("periodString", periodString);
                    map.put("company", this.company.getName());
                    this.createCountRow(drs, rate, map);
                }
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            SysUtil.abort();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return drs;
    }

    private void createJournal(DynamicRowSet drs, JournalInfo journal, BigDecimal balance, BigDecimal rate) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            drs.moveToInsertRow();
            CasBankJournalDataProvider.clearRow((IRowSet)drs);
            drs.updateString("company", journal.getCompany().getName());
            drs.updateString("createDate", df.format(journal.getCreateDate()));
            drs.updateString("bizDate", df.format(journal.getBizDate()));
            drs.updateString("voucherType", journal.getVoucherType() != null ? journal.getVoucherType().toString() : "");
            drs.updateString("voucherNumber", journal.getVoucherNumber());
            drs.updateString("creator", journal.getCreator().getName());
            drs.updateString("oppAccountNumber", journal.getOppAccountView() != null ? journal.getOppAccountView().getNumber() + journal.getOppAccountView().getName() : "");
            drs.updateString("billType", journal.getBillType() != null ? journal.getBillType().toString() : "");
            drs.updateString("billNumber", journal.getBillNumber());
            drs.updateString("description", journal.getDescription());
            drs.updateString("settType", journal.getSettlementType() != null ? journal.getSettlementType().getName() : "");
            drs.updateString("settNumber", journal.getSettlementNumber());
            if (journal.isIsDebit()) {
                drs.updateString("dc", "\u501f");
            } else {
                drs.updateString("dc", "\u8d37");
            }
            drs.updateString("debit", journal.getDebitAmount() != null ? journal.getDebitAmount().setScale(2, 4).toString() : "");
            BigDecimal localDebit = null;
            if (journal.getDebitAmount() != null) {
                localDebit = journal.getDebitAmount().multiply(rate).setScale(2, 4);
            }
            drs.updateString("localdebit", localDebit != null ? localDebit.toString() : "");
            drs.updateString("credit", journal.getCreditAmount() != null ? journal.getCreditAmount().setScale(2, 4).toString() : "");
            BigDecimal localCredit = null;
            if (journal.getCreditAmount() != null) {
                localCredit = journal.getCreditAmount().multiply(rate).setScale(2, 4);
            }
            drs.updateString("localCredit", localCredit != null ? localCredit.toString() : "");
            drs.updateString("balance", balance.toString());
            BigDecimal localbalance = null;
            if (balance != null) {
                localbalance = balance.multiply(rate).setScale(2, 4);
            }
            drs.updateString("localBalance", localbalance != null ? localbalance.toString() : "");
            drs.updateString("cash", journal.getCashier() != null ? journal.getCashier().getName() : "");
            String verify = "\u5426";
            if (!journal.getVerifyStatus().equals((Object)VerifyScopeEnum.NOVA)) {
                verify = "\u662f";
            }
            drs.updateString("verify", verify);
            drs.updateString("source", journal.getSource() != null ? journal.getSource().toString() : "");
            drs.updateString("exchange", rate.toString());
            drs.updateString("oppUnit", journal.getOppUnit());
            drs.updateString("oppAcctNumber", journal.getOppAcctNumber());
            drs.updateString("oppBank", journal.getOppBank());
            drs.updateString("currency", journal.getCurrency() != null ? journal.getCurrency().getName() : "");
            drs.updateString("bankAccountView", journal.getAccountView() != null ? journal.getAccountView().getNumber() : "");
            drs.updateString("bankAccount", journal.getAccountBank() != null ? journal.getAccountBank().getName() : "");
            String periodString = journal.getPeriod().getPeriodYear() + "\u5e74" + journal.getPeriod().getPeriodNumber() + "\u671f";
            drs.updateString("intTerm", periodString);
            drs.updateString("startPeriod", periodString);
            drs.updateString("endPeriod", periodString);
            drs.insertRow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createCountRow(DynamicRowSet drs, BigDecimal rate, Map map) {
        try {
            drs.moveToInsertRow();
            CasBankJournalDataProvider.clearRow((IRowSet)drs);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String balance = (String)map.get("balance");
            String debitAmount = (String)map.get("debitAmount");
            String creditAmount = (String)map.get("creditAmount");
            drs.updateString("balance", balance);
            BigDecimal localbalance = null;
            if (balance != null) {
                localbalance = new BigDecimal(balance).multiply(rate).setScale(2, 4);
                drs.updateString("localBalance", localbalance.toString());
            }
            drs.updateString("createDate", df.format((Date)map.get("date")));
            drs.updateString("credit", (String)map.get("creditAmount"));
            BigDecimal localCredit = null;
            if (creditAmount != null && !creditAmount.equals("")) {
                localCredit = new BigDecimal(creditAmount).multiply(rate).setScale(2, 4);
            }
            drs.updateString("localCredit", localCredit != null ? localCredit.toString() : "");
            drs.updateString("debit", (String)map.get("debitAmount"));
            BigDecimal localDebit = null;
            if (debitAmount != null && !debitAmount.equals("")) {
                localDebit = new BigDecimal(debitAmount).multiply(rate).setScale(2, 4);
            }
            drs.updateString("localdebit", localDebit != null ? localDebit.toString() : "");
            drs.updateString("description", (String)map.get("description"));
            drs.updateString("dc", (String)map.get("isDebit"));
            drs.updateString("bankAccount", (String)map.get("bankAccount"));
            drs.updateString("currency", (String)map.get("currency"));
            drs.updateString("intTerm", (String)map.get("periodString"));
            drs.updateString("startPeriod", (String)map.get("periodString"));
            drs.updateString("endPeriod", (String)map.get("periodString"));
            drs.updateString("company", (String)map.get("company"));
            drs.insertRow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DynamicRowSet initDrowSet() throws SQLException {
        String[] keys = new String[]{"id", "company", "creator", "createDate", "bizDate", "voucherType", "voucherNumber", "oppAccountNumber", "billType", "billNumber", "description", "settType", "settNumber", "exchange", "debit", "localDebit", "credit", "localCredit", "dc", "balance", "localBalance", "cash", "verify", "source", "oppUnit", "oppAcctNumber", "oppBank", "bankAccount", "currency", "bankAccountView", "intTerm", "startPeriod", "endPeriod"};
        DynamicRowSet drs = new DynamicRowSet(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            ColInfo ciId = new ColInfo();
            ciId.colType = 12;
            ciId.columnName = keys[i];
            drs.setColInfo(i + 1, ciId);
        }
        return drs;
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    protected BigDecimal getBeginBalanceNew(CompanyOrgUnitInfo companyInfo, CurrencyInfo currencyInfo, PeriodInfo periodInfo, AccountViewInfo accountView, AccountBankInfo accountBank, int type) throws EASBizException, BOSException {
        PeriodInfo period = null;
        String beginDateStr = "";
        String endDateStr = "";
        if (periodInfo.isIsAdjustPeriod()) {
            period = PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)periodInfo.getEndDate(), (CompanyOrgUnitInfo)companyInfo);
            SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
            beginDateStr = s.format(period.getBeginDate());
            endDateStr = s.format(period.getEndDate());
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(periodInfo.getBeginDate());
            cal.add(2, -1);
            Date beginDate = cal.getTime();
            SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
            beginDateStr = s.format(beginDate);
            cal.set(5, cal.getActualMaximum(5));
            Date endDate = cal.getTime();
            endDateStr = s.format(endDate);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection filterItems = filter.getFilterItems();
            filterItems.add(new FilterItemInfo("beginDate", (Object)beginDate));
            filterItems.add(new FilterItemInfo("endDate", (Object)endDate));
            filterItems.add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId()));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            view.setSelector(sic);
            PeriodCollection pColl = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodCollection(view);
            period = pColl != null && pColl.size() > 0 ? pColl.get(0) : periodInfo;
        }
        StringBuffer sql = new StringBuffer();
        if (type == 2) {
            sql.append("select sum(SubResult) Result from (").append("select FMonthStartAmt SubResult from T_CAS_JournalBalance where FIsInit = 0 and FCurrencyId ='").append(currencyInfo.getId().toString()).append("' and FPeriodId ='").append(period.getId().toString()).append("' and FType= ").append(type).append(" and FAccountBankID ='").append(accountBank.getId().toString()).append("' and FCompanyId='").append(companyInfo.getId().toString()).append("' and FAccountViewId ='").append(accountView.getId().toString()).append("' ").append("union all ").append("select sum(FDebitAmount - FCreditAmount)  SubResult from t_cas_JournalSummary  where FCreateDate >={").append(beginDateStr).append("} and ").append("FCreateDate <={").append(endDateStr).append("} and FCurrencyId ='").append(currencyInfo.getId().toString()).append("' and FAccountViewId ='").append(accountView.getId().toString()).append("' and FCompanyId ='").append(companyInfo.getId().toString()).append("' and FAccountBankId ='").append(accountBank.getId().toString()).append("' and FType = ").append(type).append(") SubQuery");
        } else if (type == 1) {
            sql.append("select sum(SubResult) Result from (").append("select FMonthStartAmt SubResult from T_CAS_JournalBalance where FIsInit = 0 and FCurrencyId ='").append(currencyInfo.getId().toString()).append("' and FPeriodId ='").append(period.getId().toString()).append("' and FType= ").append(type).append(" and FCompanyId='").append(companyInfo.getId().toString()).append("' and FAccountViewId ='").append(accountView.getId().toString()).append("' ").append("union all ").append("select sum(FDebitAmount - FCreditAmount)  SubResult from t_cas_JournalSummary  where FCreateDate >={").append(beginDateStr).append("} and ").append("FCreateDate <={").append(endDateStr).append("} and FCurrencyId ='").append(currencyInfo.getId().toString()).append("' and FAccountViewId ='").append(accountView.getId().toString()).append("' and FCompanyId ='").append(companyInfo.getId().toString()).append("' and FType = ").append(type).append(") SubQuery");
        }
        this.logger.error((Object)("\u83b7\u53d6\u671f\u521d\u4f59\u989d\u7684sql\u662f" + sql.toString()));
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)this.ctx, (String)sql.toString());
        IRowSet rs = null;
        rs = exec.executeSQL();
        try {
            BigDecimal result;
            if (rs != null && rs.next() && (result = rs.getBigDecimal("Result")) != null) {
                return result;
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)("\u83b7\u53d6\u671f\u521d\u4f59\u989d\u6267\u884csql\u5931\u8d25" + e));
        }
        return Constants.ZERO;
    }

    protected BigDecimal getExchange(CompanyOrgUnitInfo company, CurrencyInfo sourceCurrency, CurrencyInfo desCurrency, Date date) throws EASBizException, BOSException {
        if (null == date) {
            date = Calendar.getInstance().getTime();
        }
        Object iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrpk = null;
        ObjectUuidPK destCurrpk = null;
        if (desCurrency == null) {
            desCurrency = company.getBaseCurrency();
        }
        if (company.getBaseExchangeTable() == null) {
            throw new BOSException("\u6ca1\u6709\u6c47\u7387\u8868");
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        destCurrpk = new ObjectUuidPK(desCurrency.getId());
        sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId());
        BigDecimal er = this.getBankJournalExchangeCache((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        if (er == null) {
            throw new BOSException("\u83b7\u53d6\u6c47\u7387\u9519\u8bef");
        }
        return er;
    }

    protected ExchangeRateInfo getExRateInfo(CurrencyInfo sourceCurrency, CurrencyInfo desCurrency, CompanyOrgUnitInfo company, Date date) throws BOSException, EASBizException {
        ExchangeTableInfo baseExchangeTable = company.getBaseExchangeTable();
        if (baseExchangeTable == null) {
            throw new BOSException("\u6ca1\u6709\u6c47\u7387\u8868");
        }
        ExchangeRateInfo exRateInfo = null;
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId());
        ObjectUuidPK destCurrpk = new ObjectUuidPK(desCurrency.getId());
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)this.ctx);
        exRateInfo = iExchangRate.getExchangeRateConvertInfo((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, DateTimeUtils.truncateDate((Date)date));
        return exRateInfo;
    }

    protected BigDecimal getBankJournalExchangeCache(IObjectPK excTablepk, IObjectPK sourceCurrpk, IObjectPK destCurrpk, Date date) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        if (excTablepk == null) {
            return null;
        }
        if (sourceCurrpk == null) {
            return null;
        }
        if (destCurrpk == null) {
            return null;
        }
        if (destCurrpk.equals((Object)sourceCurrpk)) {
            return CasConstants.ONE;
        }
        String key = excTablepk.toString() + sourceCurrpk + destCurrpk + date.getTime();
        iexchangRate = ExchangeRateFactory.getLocalInstance((Context)this.ctx);
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo(excTablepk, sourceCurrpk, destCurrpk, date);
        if (erInfo == null) {
            return null;
        }
        return erInfo.getConvertRate();
    }
}

