/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AssItemsForCashRecCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashRecFactory;
import com.kingdee.eas.fi.cas.AssItemsForCashRecInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReceivingBillDataProvider
implements BOSQueryDelegate {
    private static Logger logger = Logger.getLogger((String)ReceivingBillDataProvider.class.getName());
    private static IMetaDataPK qpk = new MetaDataPK("com.kingdee.eas.fi.cas.ReceivingBillTDQuery");
    private Set ids = null;
    private String currentPK = null;
    private String templatePath = "/FI/CAS/RECEIVINGBILL";
    private Context ctx;

    public ReceivingBillDataProvider(Context ctx, Set id) {
        this.ctx = ctx;
        this.ids = id;
    }

    public ReceivingBillDataProvider(Context ctx, List id) {
        this(ctx, new HashSet(id));
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)qpk);
            exec.option().isAutoTranslateEnum = true;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("receivingBill.id", (Object)this.ids, CompareType.INCLUDE));
            ev.setFilter(filter);
            ArrayList param = ds.getParams();
            this.addDataFilter(filter, param);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            while (iRowSet.next()) {
                IPrintIntegration pinfo = PrintIntegrationFactory.getLocalInstance((Context)this.ctx);
                this.currentPK = iRowSet.getString("receivingBill.id");
                int precision = iRowSet.getInt("currency.precision");
                iRowSet.updateBigDecimal("actualAmt", iRowSet.getBigDecimal("actualAmt").setScale(precision, 4));
                String entryID = iRowSet.getString("receivingBillEntry.id");
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filteri = new FilterInfo();
                filteri.getFilterItems().add(new FilterItemInfo("entryParent", (Object)entryID));
                evi.setFilter(filteri);
                evi.getSelector().add(new SelectorItemInfo("*"));
                evi.getSelector().add(new SelectorItemInfo("asstActType.*"));
                AssItemsForCashRecCollection assColl = AssItemsForCashRecFactory.getLocalInstance((Context)this.ctx).getAssItemsForCashRecCollection(evi);
                AssItemsForCashRecInfo infoTmp = null;
                CoreBaseInfo entityInfo = null;
                StringBuffer sf_assName = new StringBuffer();
                StringBuffer sf_assType = new StringBuffer();
                for (int i = 0; i < assColl.size(); ++i) {
                    infoTmp = assColl.get(i);
                    if (infoTmp.getAsstActType() != null) {
                        sf_assType.append(infoTmp.getAsstActType().getName());
                    }
                    if (infoTmp.getFromID() != null && !infoTmp.getFromID().equals("") && (entityInfo = EJBAccessFactory.createRemoteInstance().getEntityInfo(infoTmp.getFromID())) != null && entityInfo.getString("name") != null) {
                        sf_assName.append(entityInfo.getString("name"));
                    }
                    if (i + 1 == assColl.size()) continue;
                    sf_assType.append("\uff1b");
                    sf_assName.append("\uff1b");
                }
                iRowSet.updateString("assName", sf_assName.toString());
                iRowSet.updateString("assType", sf_assType.toString());
                String currencyId = iRowSet.getString("currency.id");
                String companyId = iRowSet.getString("company.id");
                Date bizDate = iRowSet.getDate("receivingBill.bizDate");
                int exRatePrec = this.getExRatePrec(currencyId, null, companyId, bizDate);
                iRowSet.updateBigDecimal("receivingBill.exchangeRate", iRowSet.getBigDecimal("receivingBill.exchangeRate").setScale(exRatePrec, 4));
                iRowSet.updateString("recType.name", iRowSet.getString("recType.name"));
                iRowSet.updateString("settlementType.name", iRowSet.getString("settlementType.name"));
                iRowSet.updateString("person.name", iRowSet.getString("person.name"));
                iRowSet.updateString("adminOrgUnit.name", iRowSet.getString("adminOrgUnit.name"));
                iRowSet.updateString("coreBillNumber", iRowSet.getString("coreBillNumber"));
                iRowSet.updateString("coreBillType.name", iRowSet.getString("coreBillType.name"));
                iRowSet.updateString("contractNum", iRowSet.getString("contractNum"));
                iRowSet.updateString("contractEntrySeq", iRowSet.getString("contractEntrySeq"));
                iRowSet.updateBigDecimal("receivingBill.actRecAmt", iRowSet.getBigDecimal("receivingBill.actRecAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("receivingBill.actRecAmtVc", iRowSet.getBigDecimal("receivingBill.actRecAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("receivingBill.actRecLocAmt", iRowSet.getBigDecimal("receivingBill.actRecLocAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("receivingBill.actRecLocAmtVc", iRowSet.getBigDecimal("receivingBill.actRecLocAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("amount", iRowSet.getBigDecimal("amount").setScale(precision, 4));
                iRowSet.updateBigDecimal("amountVc", iRowSet.getBigDecimal("amountVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("localAmt", iRowSet.getBigDecimal("localAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("localAmtVc", iRowSet.getBigDecimal("localAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("unVcAmount", iRowSet.getBigDecimal("unVcAmount").setScale(precision, 4));
                iRowSet.updateBigDecimal("unVcLocAmount", iRowSet.getBigDecimal("unVcLocAmount").setScale(precision, 4));
                iRowSet.updateBigDecimal("rebate", iRowSet.getBigDecimal("rebate").setScale(precision, 4));
                iRowSet.updateBigDecimal("rebateAmtVc", iRowSet.getBigDecimal("rebateAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("rebateLocAmt", iRowSet.getBigDecimal("rebateLocAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("rebateLocAmtVc", iRowSet.getBigDecimal("rebateLocAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("actualAmtVc", iRowSet.getBigDecimal("actualAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("actualLocAmt", iRowSet.getBigDecimal("actualLocAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("actualLocAmtVc", iRowSet.getBigDecimal("actualLocAmtVc").setScale(precision, 4));
                String billId = iRowSet.getString("id");
                MultiApproveCollection col = CashHelper.getMutiApprove((String)billId);
                for (int i = 1; i <= col.size() && i <= 5; ++i) {
                    MultiApproveInfo info = col.get(i - 1);
                    iRowSet.updateString("censor" + i, info.getCreator().getName());
                }
                if (iRowSet.getString("receivingBill.auditDate") != null) {
                    iRowSet.updateString("receivingBill.auditDate", iRowSet.getString("receivingBill.auditDate").substring(0, 10));
                }
                if (iRowSet.getString("payerType.name") == null) {
                    iRowSet.updateString("payerType.name", "\u5176\u4ed6");
                }
                iRowSet.updateString("sourceBillId", this.getBillNumber(iRowSet.getString("sourceBillId")));
                StringBuffer voucherNumber = new StringBuffer("");
                VoucherCollection colVoucher = null;
                if (!iRowSet.getBoolean("receivingBill.fiVouchered")) continue;
                colVoucher = this.getVoucherCollection(iRowSet.getString("receivingBill.id"));
                if (colVoucher != null && colVoucher.size() > 0) {
                    for (VoucherInfo info : colVoucher) {
                        voucherNumber.append(info.getNumber());
                        voucherNumber.append("  ");
                    }
                }
                iRowSet.updateString("voucherNumber", voucherNumber.toString());
            }
            iRowSet.beforeFirst();
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        return iRowSet;
    }

    private void addDataFilter(FilterInfo filter, ArrayList param) throws BOSException {
        DSParam dp;
        String s;
        if (filter == null || filter.getFilterItems().size() == 0) {
            return;
        }
        if (param == null || param.size() == 0) {
            return;
        }
        FilterInfo datafilter = null;
        if (param != null && param.size() > 0 && (s = (dp = (DSParam)param.get(0)).getColName()) != null && s.equalsIgnoreCase("datafilter")) {
            String f = dp.getAssociateField();
            try {
                datafilter = new FilterInfo(f);
            }
            catch (Exception e) {
                logger.info((Object)f);
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (datafilter != null && datafilter.getFilterItems().size() > 0) {
            filter.mergeFilter(datafilter, "AND");
        }
    }

    private int getExRatePrec(String srcCurrId, String destCurrId, String companyId, java.util.Date date) {
        if (srcCurrId == null || date == null) {
            return 0;
        }
        try {
            CompanyOrgUnitInfo company = null;
            if (destCurrId == null) {
                company = companyId == null ? ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCompany() : CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                destCurrId = company.getBaseCurrency().getId().toString();
            }
            return this.getExchangeRatePrec(srcCurrId, destCurrId, company);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return 0;
    }

    private int getExchangeRatePrec(String sourceCurID, String desCurID, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ObjectUuidPK sourceCurrpk;
        String key = sourceCurID + "+" + desCurID;
        int prec = 3;
        ExchangeRateInfo erInfo = null;
        ExchangeTableInfo baseExchangeTable = company.getBaseExchangeTable();
        if (baseExchangeTable == null) {
            logger.error((Object)"baseExchangeTable is null");
        }
        ObjectUuidPK destCurrpk = new ObjectUuidPK(desCurID);
        ObjectUuidPK excTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)this.ctx);
        erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)(sourceCurrpk = new ObjectUuidPK(sourceCurID)), (IObjectPK)destCurrpk, new java.util.Date(System.currentTimeMillis()));
        if (erInfo != null && erInfo.getExchangeAux() != null) {
            prec = erInfo.getExchangeAux().getPrecision();
        }
        return prec;
    }

    private String getBillNumber(String id) throws Exception {
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BOSUuid bosId = BOSUuid.read((String)id);
        IObjectValue info = DynamicObjectFactory.getLocalInstance((Context)this.ctx).getValue(bosId.getType(), (IObjectPK)pk);
        return info.getString("number");
    }

    private VoucherCollection getVoucherCollection(String billId) throws BOSException, EASBizException {
        String[] srcEntriesID = new String[]{billId};
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)this.ctx);
        BOSObjectType voucherBosType = new VoucherInfo().getBOSType();
        BOTRelationCollection relationColl = iBTPManager.getDestRelation(billId);
        VoucherCollection colVoucher = null;
        if (relationColl != null && !relationColl.isEmpty()) {
            HashSet<String> voucherIds = new HashSet<String>();
            BOTRelationInfo relationInfo = null;
            int size = relationColl.size();
            for (int i = 0; i < size; ++i) {
                relationInfo = relationColl.get(i);
                if (!relationInfo.getDestEntityID().equals(voucherBosType.toString())) continue;
                voucherIds.add(relationInfo.getDestObjectID());
            }
            if (voucherIds != null && voucherIds.size() != 0) {
                IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)this.ctx);
                SelectorItemCollection cel = new SelectorItemCollection();
                cel.add("*");
                cel.add("creator.*");
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().addObjectCollection((IObjectCollection)cel);
                FilterInfo filter = new FilterInfo();
                FilterItemInfo filterItem = new FilterItemInfo("id", voucherIds, CompareType.INCLUDE);
                filter.getFilterItems().add(filterItem);
                view.setFilter(filter);
                colVoucher = iVoucher.getVoucherCollection(view);
            }
        }
        if (colVoucher == null) {
            colVoucher = new VoucherCollection();
        }
        return colVoucher;
    }
}

