/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.cas.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.tool.engine.cas.utils.CASInfoSnapShot;
import com.kingdee.eas.el.rec.tool.engine.cas.utils.CASMultiInfoCollSnapShot;
import com.kingdee.eas.el.rec.tool.engine.cas.utils.CASTDUtils;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStmtBookReportInfo;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fm.common.util.UserDefineColumnCollection;
import com.kingdee.eas.fm.common.util.UserDefineColumnInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CASBankBalanceDataProvider
implements BOSQueryDelegate {
    private Set data;
    private Context ctx;
    protected CompanyOrgUnitInfo company;
    protected PeriodCollection perCol;
    private Logger logger = Logger.getLogger(this.getClass());

    public CASBankBalanceDataProvider(Context ctx, Set data, CompanyOrgUnitInfo company, PeriodCollection perCol) {
        this.ctx = ctx;
        this.data = data;
        this.company = company;
        this.perCol = perCol;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        DynamicRowSet rowSet = null;
        try {
            CASMultiInfoCollSnapShot tkdtss = this.generateRowSet(this.data, (IRowSet)rowSet);
            rowSet = new DynamicRowSet(tkdtss.getTitleKeys().length);
            this.generateMetaData(tkdtss, rowSet);
            Iterator it = this.data.iterator();
            while (it.hasNext()) {
                HashMap mapResultOnlyDetail = new HashMap();
                Map mapResult = (Map)it.next();
                mapResultOnlyDetail.put("entprUnreachedDetails", mapResult.get("entprUnreachedColl"));
                mapResultOnlyDetail.put("bankUnreachedDetails", mapResult.get("bankUnreachedColl"));
                UserDefineColumnCollection udcc = this.getUserDefineColumnCollection(mapResult);
                CASMultiInfoCollSnapShot kdtss = this.generateSnapShot(mapResultOnlyDetail, udcc);
                int scale = EmptyUtil.isEmpty(mapResult.get("precision")) ? 4 : (Integer)mapResult.get("precision");
                CASTDUtils tdUtil = new CASTDUtils();
                tdUtil.fillRowSetForAdjust(kdtss, rowSet, udcc, scale);
            }
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return rowSet;
    }

    private CASMultiInfoCollSnapShot generateRowSet(Set data, IRowSet rowSet) throws SQLException, EASBizException, BOSException {
        Iterator it = data.iterator();
        HashMap<String, Object> mapResultOnlyDetail = new HashMap<String, Object>();
        UserDefineColumnCollection udcc = null;
        BankStatementCollection entprUnreachedColl = new BankStatementCollection();
        JournalCollection bankUnreachedColl = new JournalCollection();
        while (it.hasNext()) {
            Map mapResult = (Map)it.next();
            entprUnreachedColl.addObjectCollection((IObjectCollection)mapResult.get("entprUnreachedColl"));
            bankUnreachedColl.addObjectCollection((IObjectCollection)mapResult.get("bankUnreachedColl"));
            udcc = this.getUserDefineColumnCollection(mapResult);
        }
        mapResultOnlyDetail.put("entprUnreachedDetails", entprUnreachedColl);
        mapResultOnlyDetail.put("bankUnreachedDetails", bankUnreachedColl);
        CASMultiInfoCollSnapShot kdtss = this.generateSnapShot(mapResultOnlyDetail, udcc);
        return kdtss;
    }

    private void generateMetaData(CASInfoSnapShot kdtss, DynamicRowSet drs) throws SQLException {
        String[] keys = kdtss.getTitleKeys();
        for (int i = 0; i < keys.length; ++i) {
            ColInfo ciId = new ColInfo();
            ciId.colType = 12;
            ciId.columnName = keys[i];
            drs.setColInfo(i + 1, ciId);
        }
    }

    protected CASMultiInfoCollSnapShot generateSnapShot(Map infoColls, UserDefineColumnCollection udcc) throws SQLException {
        CASMultiInfoCollSnapShot kdtss = new CASMultiInfoCollSnapShot(infoColls, udcc);
        kdtss.init();
        return kdtss;
    }

    protected UserDefineColumnCollection getUserDefineColumnCollection(Map bankBal) throws EASBizException, BOSException {
        UserDefineColumnCollection udcc = new UserDefineColumnCollection();
        this.getInfoCommon(udcc, bankBal);
        this.getInfoEntBankJounral(udcc, bankBal);
        this.getInfoBankStatmnt(udcc, bankBal);
        return udcc;
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    private void getInfoBankStatmnt(UserDefineColumnCollection udcc, Map bankBal) {
        BankStmtBookReportInfo rptInfo = (BankStmtBookReportInfo)bankBal.get("rptInfo");
        Integer precision = (Integer)bankBal.get("precision");
        UserDefineColumnInfo info = null;
        String title = "\u94f6\u884c\u5bf9\u8d26\u5355.";
        info = new UserDefineColumnInfo();
        info.setName("statmntAmount");
        info.setDescription(title + "\u671f\u672b\u4f59\u989d");
        info.setAlias(title + "\u671f\u672b\u4f59\u989d");
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal bankStmtAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)rptInfo.getBankStmtAmt(), (CurrencyInfo)currencyInfo);
        info.setColumnValue(bankStmtAmt.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("entprGot");
        info.setDescription(title + "\u52a0 \u4f01\u4e1a\u5df2\u6536\u94f6\u884c\u672a\u6536");
        info.setAlias(title + "\u52a0 \u4f01\u4e1a\u5df2\u6536\u94f6\u884c\u672a\u6536");
        currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal entprGotAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)rptInfo.getEntprGotAmt(), (CurrencyInfo)currencyInfo);
        info.setColumnValue(entprGotAmt.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("entprPayed");
        info.setDescription(title + "\u51cf \u4f01\u4e1a\u5df2\u4ed8\u94f6\u884c\u672a\u4ed8");
        info.setAlias(title + "\u51cf \u4f01\u4e1a\u5df2\u4ed8\u94f6\u884c\u672a\u4ed8");
        currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal entprPayedAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)rptInfo.getEntprPayedAmt(), (CurrencyInfo)currencyInfo);
        info.setColumnValue(entprPayedAmt.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("adjustedStatmntAmount");
        info.setDescription(title + "\u8c03\u6574\u540e\u671f\u672b\u4f59\u989d");
        info.setAlias(title + "\u8c03\u6574\u540e\u671f\u672b\u4f59\u989d");
        currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal bankBalance = PrecisionUtil.formatCurrencyPrecision((BigDecimal)((BigDecimal)bankBal.get("bankBalance")), (CurrencyInfo)currencyInfo);
        info.setColumnValue(bankBalance.toString());
        udcc.add((Object)info);
    }

    private void getInfoEntBankJounral(UserDefineColumnCollection udcc, Map bankBal) {
        BankStmtBookReportInfo rptInfo = (BankStmtBookReportInfo)bankBal.get("rptInfo");
        Integer precision = (Integer)bankBal.get("precision");
        UserDefineColumnInfo info = null;
        String title = "\u4f01\u4e1a\u94f6\u884c\u5b58\u6b3e\u65e5\u8bb0\u8d26.";
        info = new UserDefineColumnInfo();
        info.setName("jornalAmount");
        info.setDescription(title + "\u671f\u672b\u4f59\u989d");
        info.setAlias(title + "\u671f\u672b\u4f59\u989d");
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal bankBookAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)rptInfo.getBankBookAmt(), (CurrencyInfo)currencyInfo);
        info.setColumnValue(bankBookAmt.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankGot");
        info.setDescription(title + "\u52a0 \u94f6\u884c\u5df2\u6536\u4f01\u4e1a\u672a\u6536");
        info.setAlias(title + "\u52a0 \u94f6\u884c\u5df2\u6536\u4f01\u4e1a\u672a\u6536");
        currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal bankGotAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)rptInfo.getBankGotAmt(), (CurrencyInfo)currencyInfo);
        info.setColumnValue(bankGotAmt.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankPayed");
        info.setDescription(title + "\u51cf \u94f6\u884c\u5df2\u4ed8\u4f01\u4e1a\u672a\u4ed8");
        info.setAlias(title + "\u51cf \u94f6\u884c\u5df2\u4ed8\u4f01\u4e1a\u672a\u4ed8");
        currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal bankPayedAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)rptInfo.getBankPayedAmt(), (CurrencyInfo)currencyInfo);
        info.setColumnValue(bankPayedAmt.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("adjustedJournalAmount");
        info.setDescription(title + "\u8c03\u6574\u540e\u671f\u672b\u4f59\u989d");
        info.setAlias(title + "\u8c03\u6574\u540e\u671f\u672b\u4f59\u989d");
        currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal entBalance = PrecisionUtil.formatCurrencyPrecision((BigDecimal)((BigDecimal)bankBal.get("entBalance")), (CurrencyInfo)currencyInfo);
        info.setColumnValue(entBalance.toString());
        udcc.add((Object)info);
    }

    private void getInfoCommon(UserDefineColumnCollection udcc, Map bankBal) {
        UserDefineColumnInfo info = null;
        AccountBankInfo bankInfo = (AccountBankInfo)bankBal.get("accountBank");
        PeriodInfo periodInfo = (PeriodInfo)bankBal.get("periodInfo");
        CurrencyInfo currencyInfo = (CurrencyInfo)bankBal.get("currencyInfo");
        Date date = (Date)bankBal.get("bizDate");
        info = new UserDefineColumnInfo();
        info.setName("id");
        info.setDescription("id");
        info.setAlias("id");
        info.setColumnValue((String)bankBal.get("id"));
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankAccount");
        info.setDescription("\u94f6\u884c\u8d26\u6237");
        info.setAlias("\u94f6\u884c\u8d26\u6237");
        info.setColumnValue(bankInfo.getNumber() + " " + bankInfo.getName() + " " + bankInfo.getBankAccountNumber());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankAccountNumber");
        info.setDescription("\u94f6\u884c\u8d26\u53f7");
        info.setAlias("\u94f6\u884c\u8d26\u53f7");
        info.setColumnValue(bankInfo.getBankAccountNumber());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("currency");
        info.setDescription("\u5e01\u522b");
        info.setAlias("\u5e01\u522b");
        info.setColumnValue(currencyInfo.getName());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankAccountView");
        info.setDescription("\u94f6\u884c\u79d1\u76ee");
        info.setAlias("\u94f6\u884c\u79d1\u76ee");
        info.setColumnValue(bankInfo.getAccount().getNumber() + " " + bankInfo.getAccount().getName());
        udcc.add((Object)info);
        if (periodInfo != null) {
            info = new UserDefineColumnInfo();
            info.setName("intTerm");
            info.setDescription("\u671f\u95f4");
            info.setAlias("\u671f\u95f4");
            info.setColumnValue(periodInfo.getPeriodYear() + "\u5e74\u7b2c" + periodInfo.getPeriodNumber() + "\u671f");
            udcc.add((Object)info);
        }
        if (date != null) {
            info = new UserDefineColumnInfo();
            info.setName("bizDate");
            info.setDescription("\u65e5\u671f");
            info.setAlias("\u65e5\u671f");
            info.setColumnValue(date.toString());
            udcc.add((Object)info);
        }
        info = new UserDefineColumnInfo();
        info.setName("Company");
        info.setDescription("\u8d22\u52a1\u7ec4\u7ec7");
        info.setAlias("\u8d22\u52a1\u7ec4\u7ec7");
        if (bankInfo.getCompany() != null) {
            info.setColumnValue(bankInfo.getCompany().getName());
        }
        udcc.add((Object)info);
        String auditName = bankBal.get("audit") == null ? "" : (String)bankBal.get("audit");
        info = new UserDefineColumnInfo();
        info.setName("audit");
        info.setDescription("\u5ba1\u6279\u4eba");
        info.setAlias("\u5ba1\u6279\u4eba");
        info.setColumnValue(auditName);
        udcc.add((Object)info);
        String auditTime = bankBal.get("auditTime") == null ? "" : (String)bankBal.get("auditTime");
        info = new UserDefineColumnInfo();
        info.setName("auditTime");
        info.setDescription("\u5ba1\u6279\u65f6\u95f4");
        info.setAlias("\u5ba1\u6279\u65f6\u95f4");
        info.setColumnValue(auditTime);
        udcc.add((Object)info);
        String transDetailAmtStr = "";
        if (bankBal.get("transDetailAmt") != null) {
            BigDecimal transDetailAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)((BigDecimal)bankBal.get("transDetailAmt")), (CurrencyInfo)currencyInfo);
            transDetailAmtStr = transDetailAmt.toString();
        }
        info = new UserDefineColumnInfo();
        info.setName("transDetailAmt");
        info.setDescription("\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u4f59\u989d");
        info.setAlias("\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u4f59\u989d");
        info.setColumnValue(transDetailAmtStr);
        udcc.add((Object)info);
        String journalDifferenceAmtStr = "";
        if (bankBal.get("journalDifferenceAmt") != null) {
            BigDecimal journalDifferenceAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)((BigDecimal)bankBal.get("journalDifferenceAmt")), (CurrencyInfo)currencyInfo);
            journalDifferenceAmtStr = journalDifferenceAmt.toString();
        }
        info = new UserDefineColumnInfo();
        info.setName("journalDifferenceAmt");
        info.setDescription("\u4e0e\u65e5\u8bb0\u8d26\u5dee\u989d");
        info.setAlias("\u4e0e\u65e5\u8bb0\u8d26\u5dee\u989d");
        info.setColumnValue(journalDifferenceAmtStr);
        udcc.add((Object)info);
    }
}

