/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.cas.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.el.rec.tool.engine.cas.provider.AbstractCASRptPrintProvider;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.util.TDUtils;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CASRptPrintProvider
extends AbstractCASRptPrintProvider {
    private static Logger logger = Logger.getLogger((String)CASRptPrintProvider.class.getName());

    public CASRptPrintProvider(Map<String, Object> params) {
        super(params);
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        if (this.tblMain == null || this.idList != null) {
            try {
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)this.qpk);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(this.idList), CompareType.INCLUDE));
                ev.setFilter(filter);
                exec.setObjectView(ev);
                iRowSet = exec.executeQuery();
                DynamicRowSet drs = this.initDrowSet();
                while (iRowSet.next()) {
                    drs.beforeFirst();
                    drs.moveToInsertRow();
                    int n = drs.getRowSetMetaData().getColumnCount();
                    for (int i = 1; i <= n; ++i) {
                        drs.updateString(i, null);
                    }
                    drs.updateString("voucherType", iRowSet.getString("voucherType"));
                    drs.updateString("voucherNumber", iRowSet.getString("voucherNumber"));
                    drs.updateString("oppAccountNumber", iRowSet.getString("oppAccountViewNumber"));
                    drs.updateString("billType", iRowSet.getString("billType"));
                    drs.updateString("billNumber", iRowSet.getString("billNumber"));
                    drs.updateString("description", iRowSet.getString("description"));
                    drs.updateString("settType", iRowSet.getString("settlementType"));
                    drs.updateString("settNumber", iRowSet.getString("settlementNumber"));
                    drs.updateString("createDate", iRowSet.getString("createDate"));
                    drs.updateString("cash", iRowSet.getString("cashier"));
                    drs.updateString("verify", iRowSet.getString("verifyStatus"));
                    drs.updateString("source", iRowSet.getString("source"));
                    drs.updateString("oppUnit", iRowSet.getString("oppUnit"));
                    drs.updateString("oppAcctNumber", iRowSet.getString("oppAcctNumber"));
                    drs.updateString("oppBank", iRowSet.getString("oppBank"));
                    drs.updateString("currency", iRowSet.getString("currency.name"));
                    drs.updateString("bankAccountView", iRowSet.getString("accountNumber"));
                    drs.updateString("description", iRowSet.getString("description"));
                    this.fillAccount(iRowSet, drs);
                    this.fillAmount(iRowSet, drs);
                    this.fillPeriod(iRowSet, drs);
                }
                iRowSet = drs;
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
        TDUtils td = new TDUtils();
        try {
            boolean val_sumtd = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam("CS098", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
            KDTable tblMainEx = new KDTable();
            tblMainEx = this.tblMain;
            if (!val_sumtd) {
                int i = 0;
                while (i < tblMainEx.getRowCount3()) {
                    if (!(tblMainEx.getCell(i, "description").getValue() != null && (tblMainEx.getCell(i, "description").getValue().equals(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"360_JournalDataProvider", (Locale)this.ctx.getLocale())) || tblMainEx.getCell(i, "description").getValue().equals(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"361_JournalDataProvider", (Locale)this.ctx.getLocale())) || tblMainEx.getCell(i, "description").getValue().equals(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"362_JournalDataProvider", (Locale)this.ctx.getLocale())) || tblMainEx.getCell(i, "description").getValue().equals(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"363_JournalDataProvider", (Locale)this.ctx.getLocale())) || tblMainEx.getCell(i, "description").getValue().equals(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"364_JournalDataProvider", (Locale)this.ctx.getLocale())) || tblMainEx.getCell(i, "description").getValue().equals(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"365_JournalDataProvider", (Locale)this.ctx.getLocale()))))) {
                        tblMainEx.removeRow(i);
                        if (i <= 0) continue;
                        --i;
                        continue;
                    }
                    ++i;
                }
            }
            iRowSet = td.kdTable2RowSet(tblMainEx, this.udcc);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        return iRowSet;
    }

    private DynamicRowSet initDrowSet() throws SQLException {
        String[] keys = new String[]{"id", "company", "createDate", "bizDate", "voucherType", "voucherNumber", "oppAccountNumber", "billType", "billNumber", "description", "settType", "settNumber", "exchange", "debit", "localDebit", "credit", "localCredit", "dc", "balance", "localBalance", "cash", "verify", "source", "oppUnit", "oppAcctNumber", "oppBank", "bankAccount", "currency", "bankAccountView", "intTerm", "startPeriod", "endPeriod"};
        DynamicRowSet drs = new DynamicRowSet(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            ColInfo ciId = new ColInfo();
            ciId.colType = 12;
            ciId.columnName = keys[i];
            drs.setColInfo(i + 1, ciId);
        }
        return drs;
    }

    private void fillAccount(IRowSet iRowSet, DynamicRowSet drs) throws SQLException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)iRowSet.getString("accountBankNumber"), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankCollection(viewInfo);
        if (coll.size() > 0 && coll.get(0) != null && coll.get(0).getName() != null) {
            drs.updateString("bankAccount", coll.get(0).getName());
        }
    }

    private void fillAmount(IRowSet iRowSet, DynamicRowSet drs) throws ParseException, SQLException {
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
        Date date = format1.parse(iRowSet.getString("bizDate"));
        BigDecimal localCredit = null;
        BigDecimal localDebit = null;
        BigDecimal rate = null;
        boolean isIndirectExRate = false;
        if (!iRowSet.getString("currency.id").equals(this.currentCompany.getId().toString())) {
            ExchangeRateInfo exchangeRateInfo = CasRecPayHandler.getExRateInfo((String)iRowSet.getString("currency.id"), null, (CompanyOrgUnitInfo)this.currentCompany, (Date)date);
            if (exchangeRateInfo != null) {
                rate = exchangeRateInfo.getConvertRate();
            }
            isIndirectExRate = CasRecPayHandler.isIndirectExRate((ExchangeRateInfo)exchangeRateInfo);
        }
        if (iRowSet.getString("creditAmount") != null && !iRowSet.getString("creditAmount").equals("0")) {
            drs.updateString("dc", "\u8d37");
            drs.updateString("credit", iRowSet.getString("creditAmount"));
            BigDecimal credit = new BigDecimal(iRowSet.getString("creditAmount"));
            if (rate != null) {
                localCredit = !isIndirectExRate ? credit.multiply(rate.setScale(9)) : credit.divide(rate.setScale(9));
                drs.updateString("localCredit", localCredit.toString());
            }
        }
        if (iRowSet.getString("debitAmount") != null && !iRowSet.getString("debitAmount").equals("0")) {
            drs.updateString("dc", "\u501f");
            drs.updateString("debit", iRowSet.getString("debitAmount"));
            BigDecimal debit = new BigDecimal(iRowSet.getString("debitAmount"));
            if (rate != null) {
                localDebit = !isIndirectExRate ? debit.multiply(rate.setScale(9)) : debit.divide(rate.setScale(9));
                drs.updateString("localdebit", localDebit.toString());
            }
        }
        if (null != rate) {
            drs.updateString("exchange", rate.setScale(9).toString());
        }
    }

    private void fillPeriod(IRowSet iRowSet, DynamicRowSet drs) throws SQLException {
        String period = iRowSet.getString("periodYear") + "\u5e74" + iRowSet.getString("periodNumber") + "\u671f";
        drs.updateString("intTerm", period);
        drs.updateString("startPeriod", period);
        drs.updateString("endPeriod", period);
        drs.insertRow();
    }
}

