/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.service.order.ReleaseService;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;

public class EmmReleaseService
extends ReleaseService {
    private static final long serialVersionUID = 6578298218596737288L;

    public void afterHandle() throws BOSException, EASBizException {
    }

    public void doCheck() throws BOSException, EASBizException {
        HashSet orderSet = (HashSet)this.batchResults.getToDoIdsSet();
        if (orderSet == null || orderSet.size() < 1) {
            return;
        }
        CompanyOrgUnitInfo company = null;
        ManufactureOrderCollection orderCollection = null;
        IManufactureOrder order = ManufactureOrderFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orderSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        orderCollection = order.getManufactureOrderCollection(ev);
        Connection con = null;
        PreparedStatement batchStatementOrder = null;
        try {
            StringBuffer updateSql = new StringBuffer();
            con = EJBFactory.getConnection((Context)this.ctx);
            updateSql.append("update T_MM_ManufactureOrder set FCostObjectID=? where fid=?");
            batchStatementOrder = con.prepareStatement(updateSql.toString());
            ICostObject icostObject = CostObjectFactory.getLocalInstance((Context)this.ctx);
            IMaterialCompanyInfo iMaterialCompanyInfo = MaterialCompanyInfoFactory.getLocalInstance((Context)this.ctx);
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
            MaterialInfo materialInfo = null;
            ManufactureOrderInfo mo = null;
            StorageOrgUnitInfo storageOrgUnit = null;
            boolean isUpdate = false;
            for (int i = 0; i < orderCollection.size(); ++i) {
                mo = (ManufactureOrderInfo)orderCollection.getObject(i);
                materialInfo = mo.getMaterial();
                storageOrgUnit = mo.getStorageOrgUnit();
                if (mo.getCostObject() != null || storageOrgUnit == null) continue;
                OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgUnit.getId().toString(), 4, 1);
                if (orgCol.get(0) != null) {
                    company = (CompanyOrgUnitInfo)orgCol.get(0);
                }
                if (company == null) continue;
                String paramValue = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)storageOrgUnit.getId().toString())), (String)"AutoGenLotCost");
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT mateial.Id, mateial.number, mateial.name, mateial.status, status, accountType,calculateType,createCOByOrder ").append(" WHERE mateial.Id = '").append(materialInfo.getId().toString()).append("' ").append(" AND mateial.status = '1' AND status = '1' ").append(" AND company.Id = '").append(company.getId().toString()).append("'");
                MaterialCompanyInfoCollection mciColl = iMaterialCompanyInfo.getMaterialCompanyInfoCollection(sql.toString());
                if (mciColl.size() == 0) continue;
                MaterialCompanyInfoInfo companyInfo = mciColl.get(0);
                if (companyInfo.getCalculateType().getValue() == 2 && companyInfo.getAccountType().getValue() == 5 || companyInfo.isCreateCOByOrder()) {
                    CostObjectInfo costObjectInfo;
                    if (paramValue.equals("false")) {
                        costObjectInfo = icostObject.getCostObjectByMaterialLotAndOrder(company.getId().toString(), materialInfo.getId().toString(), mo.getLot(), mo.getId().toString());
                        if (costObjectInfo == null) continue;
                        batchStatementOrder.setString(1, costObjectInfo.getId().toString());
                        batchStatementOrder.setString(2, mo.getId().toString());
                        batchStatementOrder.addBatch();
                        isUpdate = true;
                        continue;
                    }
                    costObjectInfo = icostObject.getCostObjectByMaterialLotAndOrder(company.getId().toString(), materialInfo.getId().toString(), mo.getLot(), mo.getId().toString());
                    if (costObjectInfo != null) {
                        batchStatementOrder.setString(1, costObjectInfo.getId().toString());
                        batchStatementOrder.setString(2, mo.getId().toString());
                        batchStatementOrder.addBatch();
                        isUpdate = true;
                        continue;
                    }
                    CostObjectCollection cols = new CostObjectCollection();
                    CostObjectInfo item = new CostObjectInfo();
                    item.setCompany(company);
                    item.setRelatedId(materialInfo.getId());
                    item.setBatchNumber(mo.getLot());
                    item.setStdProductID(materialInfo);
                    item.setOrderID(mo.getId().toString());
                    cols.add(item);
                    icostObject.addnewBybatch((IObjectCollection)cols);
                    CostObjectInfo newCostObjectInfo = icostObject.getCostObjectByMaterialLotAndOrder(company.getId().toString(), materialInfo.getId().toString(), mo.getLot(), mo.getId().toString());
                    if (newCostObjectInfo == null) continue;
                    batchStatementOrder.setString(1, newCostObjectInfo.getId().toString());
                    batchStatementOrder.setString(2, mo.getId().toString());
                    batchStatementOrder.addBatch();
                    isUpdate = true;
                    continue;
                }
                StringBuffer bf = new StringBuffer();
                bf.append("select bill.fid as FID,bill.FCalculateMode as FCalculateMode");
                bf.append(" from T_BD_CostObject bill");
                bf.append(" inner join T_BD_CostObjectEntry entry");
                bf.append(" on bill.fid=entry.fparentid");
                bf.append(" where bill.FIsForbiden =0 and bill.FCompanyID=? and entry.FRelatedID=?");
                bf.append(" and bill.FBatchNumber is null ");
                Connection conn = null;
                PreparedStatement pm = null;
                ResultSet rs = null;
                try {
                    conn = EJBFactory.getConnection((Context)this.ctx);
                    pm = conn.prepareStatement(bf.toString());
                    pm.setString(1, company.getId().toString());
                    pm.setString(2, materialInfo.getId().toString());
                    rs = pm.executeQuery();
                    String costId = null;
                    while (rs.next()) {
                        costId = rs.getString("FID");
                    }
                    if (costId == null || costId.length() <= 0) continue;
                    batchStatementOrder.setString(1, costId);
                    batchStatementOrder.setString(2, mo.getId().toString());
                    batchStatementOrder.addBatch();
                    isUpdate = true;
                    continue;
                }
                catch (SQLException ex) {
                    throw new BOSException((Throwable)ex);
                }
                finally {
                    try {
                        if (null != rs) {
                            rs.close();
                        }
                        if (null != pm) {
                            pm.close();
                        }
                        if (null != conn) {
                            conn.close();
                        }
                    }
                    catch (SQLException ex) {
                        throw new BOSException((Throwable)ex);
                    }
                }
            }
            if (isUpdate) {
                batchStatementOrder.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatementOrder, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatementOrder, (Connection)con);
    }

    public void doIt() throws BOSException, EASBizException {
        this.doCommon();
    }
}

