/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.emm.mo.ManufactureOrderTechnicsExFactory;
import com.kingdee.eas.emm.mo.ManufactureOrderTechnicsExInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.app.service.order.SaveService;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import java.math.BigDecimal;

public class EmmSaveService
extends SaveService {
    private static final long serialVersionUID = -4297815189623726815L;

    public void afterHandle() throws BOSException, EASBizException {
    }

    public void doCheck() throws BOSException, EASBizException {
    }

    public void doIt() throws BOSException, EASBizException {
    }

    public IObjectPK saveSingle() throws BOSException, EASBizException {
        this.setRowStatus(this.model, EntryBaseStatusEnum.TEMPORARILYSAVED);
        this.setSomeQty(this.model);
        IObjectPK pk = super._save(this.ctx, this.model);
        if (this.model instanceof ManufactureOrderInfo) {
            ManufactureOrderInfo tmp = (ManufactureOrderInfo)this.model;
            this.setManufactureTechnicsEx(this.ctx, tmp);
            this.setMFTOrderStockWorckCent(this.ctx, tmp);
        }
        return pk;
    }

    private void setSomeQty(IObjectValue model) {
        ManufactureOrderInfo mo = (ManufactureOrderInfo)model;
        mo.setExtraUpperLimitBase(mo.getExtraUpperLimit());
        mo.setLackLowerLimitBase(mo.getLackLowerLimit());
        mo.setUnToStoreBaseQty(mo.getUnToStoreQty());
    }

    private void setMFTOrderStockWorckCent(Context ctx, ManufactureOrderInfo obj) throws BOSException, EASBizException {
        ManufactureOrderStockCollection manufactureOrderStockCollection = obj.getStocks();
        ManufactureOrderTechnicsCollection manufactureOrderTechnicsCollection = obj.getTechnics();
        for (int i = 0; i < manufactureOrderStockCollection.size(); ++i) {
            WorkCenterInfo workCenterInfo;
            ManufactureOrderStockInfo manufactureOrderStockInfo = manufactureOrderStockCollection.get(i);
            SelectorItemCollection _selector = new SelectorItemCollection();
            boolean flag = false;
            if (manufactureOrderStockInfo.getBaseQty() == null || manufactureOrderStockInfo.getBaseQty().compareTo(BigDecimal.ZERO) == 0) {
                if (manufactureOrderStockInfo.getQty() == null) {
                    manufactureOrderStockInfo.setBaseQty(new BigDecimal(0.0));
                } else {
                    manufactureOrderStockInfo.setBaseQty(manufactureOrderStockInfo.getQty());
                }
                _selector.add(new SelectorItemInfo("baseQty"));
                flag = true;
            }
            if (manufactureOrderStockInfo.getAssociateQty() == null || manufactureOrderStockInfo.getAssociateQty().compareTo(BigDecimal.ZERO) == 0) {
                manufactureOrderStockInfo.setAssociateQty(manufactureOrderStockInfo.getPlannedQty());
                _selector.add(new SelectorItemInfo("associateQty"));
                flag = true;
            }
            if (manufactureOrderStockInfo.getUnIssueQty() == null || manufactureOrderStockInfo.getUnIssueQty().compareTo(BigDecimal.ZERO) == 0) {
                manufactureOrderStockInfo.setUnIssueQty(manufactureOrderStockInfo.getPlannedQty());
                _selector.add(new SelectorItemInfo("unIssueQty"));
                flag = true;
            }
            if (manufactureOrderStockInfo.getUnIssueBaseQty() == null || manufactureOrderStockInfo.getUnIssueBaseQty().compareTo(BigDecimal.ZERO) == 0) {
                manufactureOrderStockInfo.setUnIssueBaseQty(manufactureOrderStockInfo.getPlannedQty());
                _selector.add(new SelectorItemInfo("unIssueBaseQty"));
                flag = true;
            }
            if (flag) {
                ManufactureOrderStockFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)manufactureOrderStockInfo, _selector);
            }
            if ((workCenterInfo = manufactureOrderStockInfo.getWorkcenter()) != null) continue;
            int operationNo = manufactureOrderStockInfo.getOperationNo();
            manufactureOrderStockInfo.setWorkcenter(this.getWorkCenterInfoByOperationNo(manufactureOrderTechnicsCollection, operationNo));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("workcenter"));
            ManufactureOrderStockFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)manufactureOrderStockInfo, selector);
        }
    }

    private WorkCenterInfo getWorkCenterInfoByOperationNo(ManufactureOrderTechnicsCollection manufactureOrderTechnicsCollection, int operationNo) {
        for (int i = 0; i < manufactureOrderTechnicsCollection.size(); ++i) {
            ManufactureOrderTechnicsInfo manufactureOrderTechnicsInfo = manufactureOrderTechnicsCollection.get(i);
            int technicsOperation = manufactureOrderTechnicsInfo.getOperationNo();
            if (technicsOperation != operationNo) continue;
            return manufactureOrderTechnicsInfo.getWorkcenter();
        }
        return null;
    }

    protected void setRowStatus(IObjectValue model, EntryBaseStatusEnum baseStatus) {
        ManufactureOrderInfo mo = (ManufactureOrderInfo)model;
        ManufactureOrderTechnicsCollection technicsCol = mo.getTechnics();
        ManufactureOrderTechnicsInfo technicsInfo = null;
        for (int i = 0; i < technicsCol.size(); ++i) {
            technicsInfo = technicsCol.get(i);
            technicsInfo.setBaseStatus(baseStatus);
        }
    }

    private void setManufactureTechnicsEx(Context ctx, ManufactureOrderInfo obj) throws BOSException, EASBizException {
        ManufactureOrderTechnicsCollection colls = obj.getTechnics();
        for (int n = 0; n < colls.size(); ++n) {
            ManufactureOrderTechnicsInfo techinfo = colls.get(n);
            String manufactororderid = obj.getId().toString();
            FilterInfo filter = new FilterInfo();
            String techid = techinfo.getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("pid", (Object)techid, CompareType.EQUALS));
            boolean isExist = ManufactureOrderTechnicsExFactory.getLocalInstance(ctx).exists(filter);
            if (isExist) continue;
            ManufactureOrderTechnicsExInfo technicsex = new ManufactureOrderTechnicsExInfo();
            technicsex.setParent(manufactororderid);
            technicsex.setPid(techinfo);
            ManufactureOrderTechnicsExFactory.getLocalInstance(ctx).save(technicsex);
        }
    }
}

