/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.emm.mo.EMMManufactureOrderCTL;
import com.kingdee.eas.emm.mo.EMMManufactureOrderChangeEntryCollection;
import com.kingdee.eas.emm.mo.EMMManufactureOrderFlowCTL;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillFactory;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.mo.MOUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.MOUpdaterMOOrder;
import com.kingdee.eas.mm.mo.app.MOUpdaterSaleOrder;
import com.kingdee.eas.mm.mo.app.service.order.AuditService;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class EmmUnAuditService
extends AuditService {
    private static final long serialVersionUID = 2113737998680331176L;

    public void afterHandle() throws BOSException, EASBizException {
        if (this.batchResults.getToDoIdsArray().length > 0) {
            String idStr = SQLUtil.setToString((Set)this.batchResults.getToDoIdsSet());
            EMMManufactureOrderCTL.updateRowStatus(this.ctx, EntryBaseStatusEnum.TEMPORARILYSAVED, idStr);
            this.backWriteRestructBill(this.batchResults.getToDoIdsArray());
        }
    }

    private void backWriteRestructBill(String[] ids) throws BOSException, EASBizException {
        for (int n = 0; n < ids.length; ++n) {
            ManufactureOrderInfo orderinfo = ManufactureOrderFactory.getLocalInstance((Context)this.ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(ids[n]));
            BillTypeInfo billtypeinfo = null;
            String restructBillid = orderinfo.getSourceBillId();
            if (orderinfo.getSourceBillType() != null) {
                billtypeinfo = BillTypeFactory.getLocalInstance((Context)this.ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(orderinfo.getSourceBillType().getId().toString()));
            }
            if (restructBillid == null || billtypeinfo == null || !"675".equals(billtypeinfo.getNumber())) continue;
            RestructReqBillInfo info = RestructReqBillFactory.getLocalInstance(this.ctx).getRestructReqBillInfo((IObjectPK)new ObjectUuidPK(restructBillid));
            BigDecimal retructedqty = info.getRetructedqty() == null ? BigDecimal.ZERO : info.getRetructedqty();
            BigDecimal qty = retructedqty.subtract(orderinfo.getQty());
            info.setRetructedqty(qty);
            if (qty.compareTo(info.getCtructqty()) > 0) {
                throw new ManufactureOrderException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"ERROR_FLAG", (Locale)this.ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"FXGZSQD_NOTPASS", (Locale)this.ctx.getLocale())));
            }
            RestructReqBillFactory.getLocalInstance(this.ctx).update((IObjectPK)new ObjectUuidPK(restructBillid), (CoreBaseInfo)info);
        }
    }

    public void doCheck() throws BOSException, EASBizException {
        Object[] allIDs = this.batchResults.getAllIDs();
        if (allIDs != null && allIDs.length > 0) {
            for (Object allID : allIDs) {
                ManufactureOrderInfo mo = ManufactureOrderFactory.getLocalInstance((Context)this.ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK((String)allID));
                try {
                    EMMManufactureOrderCTL.checkUnAuditInParam(this.ctx, mo);
                }
                catch (SCMBillException ex) {
                    this.batchResults.addError((String)allID, ex.getMessage());
                }
            }
        }
        HashSet set = new HashSet();
        set.addAll(Arrays.asList((Object[])allIDs));
        if (EMMManufactureOrderCTL.checkManufactureOrderChangeBill(this.ctx, set)) {
            String parentNum = "";
            if (this.ctx.get((Object)"EMMMOCE_COLLS") != null) {
                EMMManufactureOrderChangeEntryCollection colls = (EMMManufactureOrderChangeEntryCollection)((Object)this.ctx.get((Object)"EMMMOCE_COLLS"));
                for (int i = 0; i < colls.size(); ++i) {
                    parentNum = parentNum + "\r\n" + colls.get(i).getParent().getNumber();
                }
            }
            this.batchResults.addErrors(Arrays.asList((Object[])allIDs), EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"XMSCDDXYCZXMSCBGD_INFO", (Locale)this.ctx.getLocale()) + parentNum);
        }
        if (EMMManufactureOrderCTL.checkManufactureStockTransferPlanBill(this.ctx, set)) {
            this.batchResults.addErrors(Arrays.asList((Object[])allIDs), EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"XMSCDDXYCZDBJH_INFO", (Locale)this.ctx.getLocale()));
        }
        String idStr = SQLUtil.arrayToString((Object[])this.batchResults.getToDoIdsArray());
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select distinct FSrcObjectID from t_bot_Relation ").append("where FSrcObjectID in (").append(idStr).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)selectSql.toString());
        try {
            String msg = null;
            while (rs != null && rs.next()) {
                msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "HAS_FOLLOWBILL");
                this.batchResults.addError(rs.getString("FSrcObjectID"), msg);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select mo.FID,mo.FBirthType,mor.FChildId from T_MM_ManufactureOrder mo LEFT JOIN T_MM_MOSplitRecord mor ON mo.fid=mor.FParentId where mo.FID in (").append(idStr).append(") ");
        IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            String msg = null;
            while (iRowSet != null && iRowSet.next()) {
                String id = iRowSet.getString("FID");
                int birthType = iRowSet.getInt("FBirthType");
                String childid = iRowSet.getString("FChildId");
                if (birthType == 10 || birthType == 20) {
                    msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "SPLIT_BILL_NO_UNAUDIT");
                    this.batchResults.addError(id, msg);
                    continue;
                }
                if (StringUtils.isEmpty((String)childid)) continue;
                msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "HAS_SPLIT_BILL_NO_UNAUDIT");
                this.batchResults.addError(id, msg);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        this.batchResults = MOUtil.checkMOClose((Context)this.ctx, (BatchActionResults)this.batchResults, (String)idStr, (String)"T_MM_ManufactureOrder", (BatchActionEnum)BatchActionEnum.UNAUDIT);
        MOUpdaterSaleOrder billUpdater = new MOUpdaterSaleOrder(this.ctx);
        billUpdater.setBatchResults(this.batchResults);
        billUpdater.setAuditAction(false);
        billUpdater.execute();
        billUpdater = new MOUpdaterMOOrder(this.ctx);
        billUpdater.setBatchResults(this.batchResults);
        billUpdater.setAuditAction(false);
        billUpdater.execute();
    }

    public void doIt() throws BOSException, EASBizException {
        for (BatchExecuteParamsEntry entrie : this.batchResults.getParamEntries()) {
            this.hasNestingBill(this.ctx, entrie);
        }
        String idStr = SQLUtil.arrayToString((Object[])this.batchResults.getToDoIdsArray());
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_MFTOrderTechnics as t0  ").append("set (FIntoQty,FIntoBaseQty) = ").append("(select 0,0 ").append("from T_MM_ManufactureOrder t1 ").append("where t1.FFirstOperNo = t0.FOperationNo ").append("and t1.FID = t0.FParentID ").append("and t1.FID in (").append(idStr).append(") ").append(") \r\n");
        DbUtil.execute((Context)this.ctx, (String)updateSql.toString());
        LotFacadeFactory.getLocalInstance((Context)this.ctx).manufactureOrderDeleteLotSource(this.batchResults.getToDoIdsArray());
    }

    protected void hasNestingBill(Context ctx, BatchExecuteParamsEntry batchExecuteParamsEntry) throws EASBizException, BOSException {
        if (batchExecuteParamsEntry == null) {
            return;
        }
        for (int i = 0; i < batchExecuteParamsEntry.toArray().length; ++i) {
            String param;
            String string = param = batchExecuteParamsEntry.get(i) == null ? null : batchExecuteParamsEntry.get(i).toString();
            if (param == null) continue;
            String sql = "select top 1 b.fnumber from CT_MO_NestToMOrder a inner join CT_MO_NestingBill b on b.fid = a.CFNestID where 1=1 and a.CFOderID='" + param + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (!rs.next()) continue;
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"DJCZDYDTLJHD_INFO", (Locale)ctx.getLocale()) + "[" + rs.getString("fnumber") + "], " + EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"NOTUNPASS_INFO", (Locale)ctx.getLocale())));
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()), (Throwable)e);
                }
            }
        }
    }
}

