/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.bl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.common.EmmUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BLCJJYJYZKTJBRptServer
extends ReportServerBase {
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private String storage;
    private String project;
    private String trackNumber;
    private String endTrackNumebr;
    private String[] materials;
    private String[] persons;
    private String startDate;
    private String endDate;
    private String storageOrgId;
    private String storageOrgNumber;
    private String storageOrgName;
    private String projectNumber;
    private String projectName;
    private String projectId;
    private String trackNumberId;
    private String trackNumberName;
    private String endTrackNumebrName;
    private String endTrackNumebrId;
    private Context ctx;
    private int opCount;

    private String getString(Context ctx, String name) {
        return EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)name, (Locale)ctx.getLocale());
    }

    protected IRowSet getReportData(String s, RptParams rptparams) throws Exception {
        this.ctx = this.getContext();
        this.initRptParams(rptparams);
        IRowSet rs = null;
        String tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(this.createTempTable());
        StringBuffer sb = new StringBuffer();
        sb.setLength(0);
        sb.append(" /*dialect*/ insert into " + tempTable + " (FPersonID,FPersonNumber,FPersonName)");
        sb.append(" select distinct person.fid,person.fnumber,person.fname_l2 ");
        sb.append("  from t_mm_workcenter wc ");
        sb.append(" inner join T_MM_QualityInspector qi on wc.fid=qi.fparentid");
        sb.append(" inner join t_bd_person person on person.fid=qi.fpersonid");
        sb.append(" inner join t_org_storage sou on sou.fid=wc.fstorageorgunitid");
        sb.append(" where 1=1 ");
        sb.append(this.buildWhereSql());
        sb.append(" order by person.fnumber");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("/*dialect*/ update " + tempTable + " t set (t.FZDJYQty,t.FZDJYBHGQty)=");
        sb.append(" (select sum(pce.FQualifiedAmount),sum(FYieldAmount)+sum(FRepairAmount)+sum(FScrapAmount)");
        sb.append(" from T_SFC_ProdorderComplete pc ");
        sb.append(" inner join T_SFC_ProdorderCompleteEntry pce on pce.fparentid=pc.fid");
        sb.append(" inner join T_MM_MFTOrderTechnics mft on pc.fprodrowid=mft.fid");
        sb.append(" inner join t_pm_user u on u.fid=pc.fauditorid");
        sb.append(" where 1=1 and pc.fbasestatus in (2,3,4)");
        sb.append(" and mft.foperationno=");
        sb.append(" (select max(mft2.foperationno) from T_MM_MFTOrderTechnics mft2 where mft2.fparentid=pc.fprodid)");
        sb.append(" and u.fpersonid =t.fpersonid");
        sb.append(" and pc.fstorageorgunitid='" + this.storageOrgId + "'");
        sb.append(" and pc.faudittime>=to_date('").append(this.startDate.substring(0, 19)).append("','yyyy-MM-dd HH24:mi:ss')  and pc.faudittime<=to_date('").append(this.endDate.substring(0, 19)).append("','yyyy-MM-dd HH24:mi:ss')");
        sb.append(" and pce.fseq=1)");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("/*dialect*/ update " + tempTable + " t set (t.FJYQty)");
        sb.append(" =(select count(mft.foperationid)");
        sb.append(" from T_SFC_ProdorderComplete pc ");
        sb.append(" inner join T_MM_MFTOrderTechnics mft on pc.fprodrowid=mft.fid");
        sb.append(" inner join t_pm_user u on u.fid=pc.fauditorid");
        sb.append(" where 1=1  and pc.fbasestatus in (2,3,4) ");
        sb.append(" and u.fpersonid=t.fpersonid");
        sb.append(" and pc.fstorageorgunitid='" + this.storageOrgId + "'");
        sb.append(" and pc.faudittime>=to_date('").append(this.startDate.substring(0, 19)).append("','yyyy-MM-dd HH24:mi:ss')  and pc.faudittime<=to_date('").append(this.endDate.substring(0, 19)).append("','yyyy-MM-dd HH24:mi:ss')");
        sb.append(" )");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("/*dialect*/ update " + tempTable + " t set (t.FJYBHGQty)=");
        sb.append(" (select sum(FYieldAmount)+sum(FRepairAmount)+sum(FScrapAmount)");
        sb.append(" from T_SFC_ProdorderComplete pc ");
        sb.append(" inner join T_SFC_ProdorderCompleteEntry pce on pce.fparentid=pc.fid");
        sb.append(" inner join T_MM_MFTOrderTechnics mft on pc.fprodrowid=mft.fid");
        sb.append(" inner join t_pm_user u on u.fid=pc.fauditorid");
        sb.append(" where 1=1 and pc.fbasestatus in (2,3,4)");
        sb.append(" and u.fpersonid =t.fpersonid");
        sb.append(" and pc.fstorageorgunitid='" + this.storageOrgId + "'");
        sb.append(" and pc.faudittime>=to_date('").append(this.startDate.substring(0, 19)).append("','yyyy-MM-dd HH24:mi:ss')  and pc.faudittime<=to_date('").append(this.endDate.substring(0, 19)).append("','yyyy-MM-dd HH24:mi:ss')");
        sb.append(" and pce.fseq=1)");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
        DbUtil.execute((Context)this.ctx, (String)("/*dialect*/ update " + tempTable + " set FGXJYQty=nvl(FJYQty,0)-nvl(FZDJYQty,0),FGXJYBHGQty=nvl(FJYBHGQty,0)-nvl(FZDJYBHGQty,0)"));
        DbUtil.execute((Context)this.ctx, (String)("/*dialect*/ update " + tempTable + " set FYCXJYHGL= case when nvl(FJYQty,0)=0 then '' else round((nvl(FJYQty,0)-nvl(FZDJYBHGQty,0))/nvl(FJYQty,0),2)*100 ||'%' end"));
        rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select * from " + tempTable + " order by FPersonNumber"));
        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
        return rs;
    }

    private String buildWhereSql() {
        StringBuffer sql = new StringBuffer();
        if (this.storageOrgId != null) {
            sql.append(" and sou.fid='" + this.storageOrgId + "'");
        }
        if (this.persons != null && this.persons.length > 0) {
            sql.append(" and person.fnumber in (" + EmmUtils.getSqlFromArray((String[])this.persons) + ")");
        }
        return sql.toString();
    }

    private void initRptParams(RptParams params) throws BOSException, SQLException {
        IRowSet rss;
        String[] tmp;
        String sql;
        if (params.getObject("storage") != null) {
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)params.getObject("storage");
            this.storage = sou.getNumber();
            sql = "select fid,fname_l2 as fname  from t_org_storage where fnumber='" + this.storage + "'";
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                this.storageOrgId = rs.getString("fid");
                this.storageOrgName = rs.getString("fname");
            }
        } else {
            this.storage = null;
        }
        if (params.getObject("project") != null) {
            tmp = ((String)params.getObject("project")).split(";");
            this.project = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_project where fnumber='" + this.project + "'";
            rss = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rss.next()) {
                this.projectId = rss.getString("fid");
                this.projectName = rss.getString("fname");
            }
        } else {
            this.project = null;
        }
        if (params.getObject("trackNumber") != null) {
            tmp = ((String)params.getObject("trackNumber")).split(";");
            this.trackNumber = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_trackNumber where fnumber='" + this.trackNumber + "'";
            rss = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rss.next()) {
                this.trackNumberId = rss.getString("fid");
                this.trackNumberName = rss.getString("fname");
            }
        } else {
            this.trackNumber = null;
        }
        if (params.getObject("endTrackNumber") != null) {
            tmp = ((String)params.getObject("endTrackNumber")).split(";");
            this.endTrackNumebr = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_trackNumber where fnumber='" + this.endTrackNumebr + "'";
            IRowSet rsb = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rsb.next()) {
                this.endTrackNumebrId = rsb.getString("fid");
                this.endTrackNumebrName = rsb.getString("fname");
            }
        } else {
            this.endTrackNumebr = null;
        }
        if (params.getObject("material") != null) {
            tmp = ((String)params.getObject("material")).split(";");
            this.materials = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                this.materials[i] = tmp[i].trim();
            }
        } else {
            this.materials = null;
        }
        if (params.getObject("person") != null) {
            tmp = ((String)params.getObject("person")).split(";");
            this.persons = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                this.persons[i] = tmp[i].trim();
            }
        } else {
            this.persons = null;
        }
        this.startDate = params.getObject("startDate") != null ? params.getObject("startDate").toString() : null;
        this.endDate = params.getObject("endDate") != null ? params.getObject("endDate").toString() : null;
    }

    private String createTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_mo_temppsnb1(");
        sql.append("FPersonID varchar(100),");
        sql.append("FPersonNumber varchar(100),");
        sql.append("FPersonName varchar(100),");
        sql.append("FGXJYQty numeric(28,4),");
        sql.append("FGXJYBHGQty numeric(28,4),");
        sql.append("FZDJYQty numeric(28,4),");
        sql.append("FZDJYBHGQty numeric(28,4),");
        sql.append("FJYQty numeric(28,4),");
        sql.append("FJYBHGQty numeric(28,4),");
        sql.append("FYCXJYHGL varchar(100)");
        sql.append(")");
        return sql.toString();
    }

    protected ReportTitles getReportTitles(String s, RptParams rptparams) throws BaseException {
        ReportTitles title = new ReportTitles();
        title.AddTitle(1, this.getString(this.ctx, "XLCJJCYJYZKTJB_TABLE"));
        title.AddTitle(3, this.getString(this.ctx, "STORAGE_NAME") + this.storageOrgName);
        return title;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = new ReportHeader();
        ReportHeader temp = header.addChild("FPersonNumber", this.getString(this.ctx, "JYYBM_NAME"));
        temp = header.addChild("FPersonName", this.getString(this.ctx, "JYYMC_NAME"));
        temp = header.addChild("FGXJYQty", this.getString(this.ctx, "GXJYXM_NAME"));
        temp = header.addChild("FGXJYBHGQty", this.getString(this.ctx, "GXJYBHGXS_NAME"));
        temp.setWidth(150);
        temp = header.addChild("FZDJYQty", this.getString(this.ctx, "ZDJYXS_NAME"));
        temp = header.addChild("FZDJYBHGQty", this.getString(this.ctx, "ZDJYBHGXS_NAME"));
        temp.setWidth(150);
        temp = header.addChild("FJYQty", this.getString(this.ctx, "JYZXS_NAME"));
        temp = header.addChild("FJYBHGQty", this.getString(this.ctx, "JYBHGZXS_NAME"));
        temp.setWidth(150);
        temp = header.addChild("FYCXJYHGL", this.getString(this.ctx, "YCXJYHGL"));
        temp.setWidth(150);
        return header;
    }
}

