/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.bl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.common.EmmUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BLCJSCBZZLZKTJBRptServer
extends ReportServerBase {
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private String storage;
    private String project;
    private String trackNumber;
    private String endTrackNumebr;
    private String[] materials;
    private String[] workCenters;
    private String startDate;
    private String endDate;
    private String storageOrgId;
    private String storageOrgNumber;
    private String storageOrgName;
    private String projectNumber;
    private String projectName;
    private String projectId;
    private String trackNumberId;
    private String trackNumberName;
    private String endTrackNumebrName;
    private String endTrackNumebrId;
    private Context ctx;
    private int opCount;

    private String getString(Context ctx, String name) {
        return EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)name, (Locale)ctx.getLocale());
    }

    protected IRowSet getReportData(String s, RptParams rptparams) throws Exception {
        this.ctx = this.getContext();
        this.initRptParams(rptparams);
        IRowSet rs = null;
        String tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(this.createTempTable());
        StringBuffer sb = new StringBuffer();
        sb.setLength(0);
        sb.append(" /*dialect*/ insert into " + tempTable + "(FWorkCenterID,FWorkCenterNumber,FWorkCenterName)");
        sb.append(" select distinct wc.fid,wc.fnumber,wc.fname_l2");
        sb.append(" from t_mm_workcenter wc");
        sb.append(" left join t_org_storage sou on wc.FStorageOrgUnitID=sou.fid");
        sb.append(" where 1=1 and wc.cfisinside=1");
        sb.append(this.buildWhereSql());
        sb.append(" order by wc.fnumber");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("/*dialect*/ update " + tempTable + " t set (t.FZDJYQty,t.FZDJYBHGQty) =");
        sb.append(" (select sum(mft.FFinishedQty),sum(mft.FFinishedQty)-sum(mft.FPassQty)");
        sb.append(" from T_MM_ManufactureOrder mfo ");
        sb.append(" inner join T_MM_MFTOrderTechnics mft  on mfo.fid = mft.fparentid");
        sb.append(" where 1 = 1");
        sb.append(" and mfo.fbasestatus>3");
        sb.append(" and mft.foperationno =");
        sb.append(" (select max(mft2.foperationno) from T_MM_MFTOrderTechnics mft2 where mft2.fparentid = mfo.fid)");
        sb.append(" and mft.fworkcenterid=t.fworkcenterid and mfo.fstorageorgunitid = '" + this.storageOrgId + "'");
        sb.append(" and mft.CFAcmptime>=to_date('").append(this.startDate.substring(0, 19)).append("','yyyy-MM-dd HH24:mi:ss')  and mft.CFAcmptime<=to_date('").append(this.endDate.substring(0, 19)).append("','yyyy-MM-dd HH24:mi:ss')");
        sb.append(" )");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append("/*dialect*/ update " + tempTable + " t set (t.FJYQty,FJYBHGQty) =");
        sb.append(" (select sum(fqty),sum(fqty)-sum(fpassqty)  from (select max(mft.FFinishedQty) as fqty,max(mft.FPassQty) as fpassqty ,max(mft.fworkcenterid)");
        sb.append("  from T_MM_ManufactureOrder mfo ");
        sb.append("  inner join T_MM_MFTOrderTechnics mft  on mfo.fid = mft.fparentid");
        sb.append(" where 1 = 1 and mfo.fbasestatus>3");
        sb.append(" and mfo.fstorageorgunitid = '" + this.storageOrgId + "'");
        sb.append(" and mft.foperationno =");
        sb.append(" (select max(mft2.foperationno) from T_MM_MFTOrderTechnics mft2 where mft2.fparentid = mfo.fid)");
        sb.append(" and mft.CFAcmptime>=to_date('").append(this.startDate.substring(0, 19)).append("','yyyy-MM-dd HH24:mi:ss')  and mft.CFAcmptime<=to_date('").append(this.endDate.substring(0, 19)).append("','yyyy-MM-dd HH24:mi:ss')");
        sb.append(" and mft.fworkcenterid in (select fworkcenterid from " + tempTable + ")");
        sb.append(" group by mft.fmergeid");
        sb.append(" ) where fworkcenterid=t.fworkcenterid)");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
        DbUtil.execute((Context)this.ctx, (String)("/*dialect*/ update " + tempTable + " set FGXJYQty=nvl(FJYQty,0)-nvl(FZDJYQty,0),FGXJYBHGQty=nvl(FJYBHGQty,0)-nvl(FZDJYBHGQty,0)"));
        DbUtil.execute((Context)this.ctx, (String)("/*dialect*/ update " + tempTable + " set FYCXJYHGL= case when nvl(FJYQty,0)=0 then '' else round((nvl(FJYQty,0)-nvl(FZDJYBHGQty,0))/nvl(FJYQty,0),2)*100 ||'%' end"));
        rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select * from " + tempTable + " order by FWorkCenterNumber"));
        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
        return rs;
    }

    private String buildWhereSql() {
        StringBuffer sql = new StringBuffer();
        if (this.storageOrgId != null) {
            sql.append(" and sou.fid='" + this.storageOrgId + "'");
        }
        if (this.workCenters != null && this.workCenters.length > 0) {
            sql.append(" and wc.fnumber in (" + EmmUtils.getSqlFromArray((String[])this.workCenters) + ")");
        }
        return sql.toString();
    }

    private void initRptParams(RptParams params) throws BOSException, SQLException {
        IRowSet rss;
        String[] tmp;
        String sql;
        if (params.getObject("storage") != null) {
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)params.getObject("storage");
            this.storage = sou.getNumber();
            sql = "select fid,fname_l2 as fname  from t_org_storage where fnumber='" + this.storage + "'";
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                this.storageOrgId = rs.getString("fid");
                this.storageOrgName = rs.getString("fname");
            }
        } else {
            this.storage = null;
        }
        if (params.getObject("project") != null) {
            tmp = ((String)params.getObject("project")).split(";");
            this.project = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_project where fnumber='" + this.project + "'";
            rss = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rss.next()) {
                this.projectId = rss.getString("fid");
                this.projectName = rss.getString("fname");
            }
        } else {
            this.project = null;
        }
        if (params.getObject("trackNumber") != null) {
            tmp = ((String)params.getObject("trackNumber")).split(";");
            this.trackNumber = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_trackNumber where fnumber='" + this.trackNumber + "'";
            rss = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rss.next()) {
                this.trackNumberId = rss.getString("fid");
                this.trackNumberName = rss.getString("fname");
            }
        } else {
            this.trackNumber = null;
        }
        if (params.getObject("endTrackNumber") != null) {
            tmp = ((String)params.getObject("endTrackNumber")).split(";");
            this.endTrackNumebr = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_trackNumber where fnumber='" + this.endTrackNumebr + "'";
            IRowSet rsb = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rsb.next()) {
                this.endTrackNumebrId = rsb.getString("fid");
                this.endTrackNumebrName = rsb.getString("fname");
            }
        } else {
            this.endTrackNumebr = null;
        }
        if (params.getObject("material") != null) {
            tmp = ((String)params.getObject("material")).split(";");
            this.materials = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                this.materials[i] = tmp[i].trim();
            }
        } else {
            this.materials = null;
        }
        if (params.getObject("workCenter") != null) {
            tmp = ((String)params.getObject("workCenter")).split(";");
            this.workCenters = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                this.workCenters[i] = tmp[i].trim();
            }
        } else {
            this.workCenters = null;
        }
        this.startDate = params.getObject("startDate") != null ? params.getObject("startDate").toString() : null;
        if (params.getObject("endDate") != null) {
            this.endDate = params.getObject("endDate").toString();
            this.endDate.replaceAll("00:00:00", "23:59:59");
        } else {
            this.endDate = null;
        }
    }

    private String createTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_mo_temppsnb1(");
        sql.append("FWorkCenterID varchar(100),");
        sql.append("FWorkCenterNumber varchar(100),");
        sql.append("FWorkCenterName varchar(100),");
        sql.append("FGXJYQty numeric(28,4),");
        sql.append("FGXJYBHGQty numeric(28,4),");
        sql.append("FZDJYQty numeric(28,4),");
        sql.append("FZDJYBHGQty numeric(28,4),");
        sql.append("FJYQty numeric(28,4),");
        sql.append("FJYBHGQty numeric(28,4),");
        sql.append("FYCXJYHGL varchar(100)");
        sql.append(")");
        return sql.toString();
    }

    protected ReportTitles getReportTitles(String s, RptParams rptparams) throws BaseException {
        ReportTitles title = new ReportTitles();
        title.AddTitle(1, this.getString(this.ctx, "XLCJSCBZZLZKTJB_TABLE"));
        title.AddTitle(3, this.getString(this.ctx, "STORAGE_NAME") + this.storageOrgName);
        return title;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = new ReportHeader();
        ReportHeader temp = header.addChild("FWorkCenterNumber", this.getString(this.ctx, "BZBM_NAME"));
        temp = header.addChild("FWorkCenterName", this.getString(this.ctx, "BZMC_NAME"));
        temp = header.addChild("FGXJYQty", this.getString(this.ctx, "GXJYXS_NAME"));
        temp = header.addChild("FGXJYBHGQty", this.getString(this.ctx, "GXJYBHGXS_NAME"));
        temp.setWidth(150);
        temp = header.addChild("FZDJYQty", this.getString(this.ctx, "ZDJYXS_NAME"));
        temp = header.addChild("FZDJYBHGQty", this.getString(this.ctx, "ZDJYBHGXS_NAME"));
        temp.setWidth(150);
        temp = header.addChild("FJYQty", this.getString(this.ctx, "JYZXS_NAME"));
        temp = header.addChild("FJYBHGQty", this.getString(this.ctx, "JYBHGZXS_NAME"));
        temp.setWidth(150);
        temp = header.addChild("FYCXJYHGL", this.getString(this.ctx, "YCXXYHGL_NAME"));
        temp.setWidth(150);
        return header;
    }
}

