/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.bl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.common.EmmUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BLJJGSBBRptServer
extends ReportServerBase {
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private String storage;
    private String project;
    private String trackNumber;
    private String endTrackNumebr;
    private String[] materials;
    private String[] workCenters;
    private String[] hbrs;
    private String startDate;
    private String endDate;
    private String storageOrgId;
    private String storageOrgNumber;
    private String storageOrgName;
    private String projectNumber;
    private String projectName;
    private String projectId;
    private String trackNumberId;
    private String trackNumberName;
    private String endTrackNumebrName;
    private String endTrackNumebrId;
    boolean isXLJH = false;
    boolean isGXJH = false;
    private Context ctx;
    private int opCount;

    private String getString(Context ctx, String name) {
        return EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)name, (Locale)ctx.getLocale());
    }

    protected IRowSet getReportData(String s, RptParams rptparams) throws Exception {
        this.ctx = this.getContext();
        this.initRptParams(rptparams);
        IRowSet rs = null;
        String tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(this.createTempTable());
        StringBuffer sb = new StringBuffer();
        sb.setLength(0);
        sb.append(" /*dialect*/ insert into " + tempTable);
        sb.append(" select pro.fid,pro.fnumber,pro.fname_l2,");
        sb.append(" track.fid,track.fnumber,track.fname_l2,");
        sb.append(" endTrack.fid,endTrack.fnumber,endTrack.fname_l2,");
        sb.append(" mat.fid,mat.fnumber,mat.fname_l2,");
        sb.append(" wc.fid as FWorkCenterID,");
        sb.append(" wc.fnumber as FWorkCenterNumber,");
        sb.append(" wc.fname_l2 as FWorkCenterName,");
        sb.append(" max(mft.ffinishedqty) as FFinishQty,");
        sb.append(" u.fname_l2 as FHBR,");
        sb.append(" '' as FJHLX");
        sb.append(" from T_MM_ManufactureOrder mfo");
        sb.append(" inner join T_MM_MFTOrderTechnics mft on mfo.fid=mft.fparentid");
        sb.append(" inner join t_org_storage sou on mfo.FStorageOrgUnitID=sou.fid");
        sb.append(" inner join t_bd_material mat on mfo.fmaterialid=mat.fid");
        sb.append(" inner join t_mm_project pro on mfo.fprojectid=pro.fid");
        sb.append(" inner join t_mm_tracknumber track on mfo.FTrackID=track.fid");
        sb.append(" inner join t_mm_tracknumber endTrack on endTrack.Fid=mfo.CFEndTrackNumberID");
        sb.append(" inner join t_mm_workcenter wc on wc.fid=mft.fworkcenterid");
        sb.append(" inner join t_pm_user u on u.fid=mft.CFFinishUserID");
        sb.append(" where 1=1 and mfo.fbasestatus=8");
        sb.append(this.buildWhereSql());
        sb.append(" and mft.CFAcmptime>=to_date('").append(this.startDate).append("','yyyy-MM-dd HH24:mi:ss')  and mft.CFAcmptime<=to_date('").append(this.endDate).append("','yyyy-MM-dd HH24:mi:ss')");
        sb.append(" group by mft.fmergeid,pro.fid,pro.fnumber,pro.fname_l2,track.fid,track.fnumber,track.fname_l2,");
        sb.append(" endTrack.fid,endTrack.fnumber,endTrack.fname_l2,mat.fid,mat.fnumber,mat.fname_l2,");
        sb.append(" wc.fid,wc.fnumber,wc.fname_l2,u.fname_l2");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
        String rsTempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(this.createTempTable());
        sb.setLength(0);
        sb.append(" /*dialect*/ insert into " + rsTempTable + " ");
        sb.append(" select FProjectID,FProjectNumber,FProjectName,");
        sb.append(" FTrackNumberID,FTrackNumber,FTrackName,");
        sb.append(" FEndTrackNumberId,FEndTrackNumber,FEndTrackName,");
        sb.append(" FMaterialID,FMaterialNumber,FMaterialName,");
        sb.append(" FWorkCenterID,");
        sb.append(" FWorkCenterNumber,");
        sb.append(" FWorkCenterName,");
        sb.append(" sum(FHBQty),");
        sb.append(" FHBR,");
        sb.append(" case when FWorkCenterNumber in ('1','2','3','13') then '").append(this.getString(this.ctx, "XLJH_NAME")).append("' else '").append(this.getString(this.ctx, "GXJH_NAME")).append("' end as FJHLX");
        sb.append(" from " + tempTable + " ");
        sb.append(" group by FProjectID,FProjectNumber,FProjectName,");
        sb.append(" FTrackNumberID,FTrackNumber,FTrackName,");
        sb.append(" FEndTrackNumberId,FEndTrackNumber,FEndTrackName,");
        sb.append(" FMaterialID,FMaterialNumber,FMaterialName,");
        sb.append(" FWorkCenterID,FWorkCenterNumber,FWorkCenterName,");
        sb.append(" FHBR,FJHLX");
        sb.append(" order by FMaterialNumber");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
        rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select * from " + rsTempTable + " order by FMaterialNumber"));
        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
        TempTablePool.getInstance((Context)this.ctx).releaseTable(rsTempTable);
        return rs;
    }

    private String buildWhereSql() {
        StringBuffer sql = new StringBuffer();
        if (this.storageOrgId != null) {
            sql.append(" and sou.fid='" + this.storageOrgId + "'");
        }
        if (this.workCenters != null && this.workCenters.length > 0) {
            sql.append(" and wc.fnumber in (" + EmmUtils.getSqlFromArray((String[])this.workCenters) + ")");
        }
        if (this.hbrs != null && this.hbrs.length > 0) {
            sql.append(" and u.fnumber in (" + EmmUtils.getSqlFromArray((String[])this.hbrs) + ")");
        }
        if (this.materials != null && this.materials.length > 0) {
            sql.append(" and mat.fnumber in (" + EmmUtils.getSqlFromArray((String[])this.materials) + ")");
        }
        if (this.projectId != null) {
            sql.append(" and mfo.fprojectid='" + this.projectId + "'");
        }
        if (this.trackNumberId != null) {
            sql.append(" and mfo.FTrackID='" + this.trackNumberId + "'");
        }
        if (this.endTrackNumebrId != null) {
            sql.append(" and mfo.CFEndTrackNumberID='" + this.endTrackNumebrId + "'");
        }
        return sql.toString();
    }

    private void initRptParams(RptParams params) throws BOSException, SQLException {
        IRowSet rss;
        Object tmp;
        String sql;
        if (params.getObject("storage") != null) {
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)params.getObject("storage");
            this.storage = sou.getNumber();
            sql = "select fid,fname_l2 as fname  from t_org_storage where fnumber='" + this.storage + "'";
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                this.storageOrgId = rs.getString("fid");
                this.storageOrgName = rs.getString("fname");
            }
        } else {
            this.storage = null;
        }
        if (params.getObject("project") != null) {
            tmp = ((String)params.getObject("project")).split(";");
            this.project = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_project where fnumber='" + this.project + "'";
            rss = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rss.next()) {
                this.projectId = rss.getString("fid");
                this.projectName = rss.getString("fname");
            }
        } else {
            this.project = null;
        }
        if (params.getObject("trackNumber") != null) {
            tmp = ((String)params.getObject("trackNumber")).split(";");
            this.trackNumber = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_trackNumber where fnumber='" + this.trackNumber + "'";
            rss = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rss.next()) {
                this.trackNumberId = rss.getString("fid");
                this.trackNumberName = rss.getString("fname");
            }
        } else {
            this.trackNumber = null;
        }
        if (params.getObject("endTrackNumber") != null) {
            tmp = ((String)params.getObject("endTrackNumber")).split(";");
            this.endTrackNumebr = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_trackNumber where fnumber='" + this.endTrackNumebr + "'";
            IRowSet rsb = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rsb.next()) {
                this.endTrackNumebrId = rsb.getString("fid");
                this.endTrackNumebrName = rsb.getString("fname");
            }
        } else {
            this.endTrackNumebr = null;
        }
        if (params.getObject("material") != null) {
            tmp = ((String)params.getObject("material")).split(";");
            this.materials = new String[((String[])tmp).length];
            for (int i = 0; i < ((String[])tmp).length; ++i) {
                this.materials[i] = ((String)tmp[i]).trim();
            }
        } else {
            this.materials = null;
        }
        if (params.getObject("workCenter") != null) {
            tmp = ((String)params.getObject("workCenter")).split(";");
            this.workCenters = new String[((String[])tmp).length];
            for (int i = 0; i < ((Object)tmp).length; ++i) {
                this.workCenters[i] = ((String)tmp[i]).trim();
            }
        } else {
            this.workCenters = null;
        }
        if (params.getObject("month") != null) {
            tmp = params.getObject("month").toString();
            ((String)tmp).replaceAll("00:00:00.0", "00:00:00");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date time = sdf.parse((String)tmp);
                Calendar c = Calendar.getInstance();
                c.setTime(time);
                c.add(2, 0);
                c.set(5, 1);
                this.startDate = sdf.format(c.getTime());
                c.set(5, c.getActualMaximum(5));
                this.endDate = sdf.format(c.getTime());
                this.endDate = this.endDate.replaceAll("00:00:00", "23:59:59");
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        if (params.getObject("hbr") != null) {
            tmp = ((String)params.getObject("hbr")).split(";");
            this.hbrs = new String[((Object)tmp).length];
            for (int i = 0; i < ((Object)tmp).length; ++i) {
                this.hbrs[i] = ((String)tmp[i]).trim();
            }
        } else {
            this.hbrs = null;
        }
        if (params.getObject("workCenter") != null) {
            tmp = ((String)params.getObject("workCenter")).split(";");
            this.workCenters = new String[((Object)tmp).length];
            for (int i = 0; i < ((Object)tmp).length; ++i) {
                this.workCenters[i] = ((String)tmp[i]).trim();
            }
        } else {
            this.workCenters = null;
        }
        if (params.getObject("isXLJH") != null) {
            this.isXLJH = Boolean.parseBoolean(params.getObject("isXLJH").toString());
        }
        if (params.getObject("isGXJH") != null) {
            this.isGXJH = Boolean.parseBoolean(params.getObject("isGXJH").toString());
        }
    }

    private String createTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_mo_temppsnb1(");
        sql.append("FProjectID varchar(100),");
        sql.append("FProjectNumber varchar(100),");
        sql.append("FProjectName varchar(100),");
        sql.append("FTrackNumberID varchar(100),");
        sql.append("FTrackNumber varchar(100),");
        sql.append("FTrackName varchar(100),");
        sql.append("FEndTrackNumberID varchar(100),");
        sql.append("FEndTrackNumber varchar(100),");
        sql.append("FEndTrackName varchar(100),");
        sql.append("FMaterialID varchar(100),");
        sql.append("FMaterialNumber varchar(100),");
        sql.append("FMaterialName varchar(100),");
        sql.append("FWorkCenterID varchar(100),");
        sql.append("FWorkCenterNumber varchar(100),");
        sql.append("FWorkCenterName varchar(100),");
        sql.append("FHBQty numeric(28,4),");
        sql.append("FHBR varchar(100),");
        sql.append("FJHLX varchar(100)");
        sql.append(")");
        return sql.toString();
    }

    protected ReportTitles getReportTitles(String s, RptParams rptparams) throws BaseException {
        ReportTitles title = new ReportTitles();
        title.AddTitle(1, "                                                  " + this.getString(this.ctx, "JJGS_TABLE"));
        title.AddTitle(3, this.getString(this.ctx, "STORAGE_NAME") + this.storageOrgName);
        return title;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = new ReportHeader();
        ReportHeader temp = header.addChild("FProjectName", this.getString(this.ctx, "XMH_NAME"));
        temp.setWidth(240);
        temp = header.addChild("FTrackNumber", this.getString(this.ctx, "KSGZH_NAME"));
        temp = header.addChild("FEndTrackNumber", this.getString(this.ctx, "JSGZH_NAME"));
        temp = header.addChild("FMaterialNumber", this.getString(this.ctx, "CPBM_NAME"));
        temp = header.addChild("FMaterialName", this.getString(this.ctx, "CPMC_NAME"));
        temp = header.addChild("FWorkCenterName", this.getString(this.ctx, "BZ_NAME"));
        temp = header.addChild("FHBQty", this.getString(this.ctx, "HBSL_QTY"));
        temp = header.addChild("FHBR", this.getString(this.ctx, "HBR_NAME"));
        temp = header.addChild("FJHLX", this.getString(this.ctx, "JHLX_TYPE"));
        return header;
    }
}

