/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.common.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.zjbom.BusinessRepEntryCollection;
import com.kingdee.eas.zjbom.BusinessRepEntryInfo;
import com.kingdee.eas.zjbom.BusinessRepInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;

public class EASTask {
    protected Context ctx;
    protected HSSFWorkbook workbook = null;

    public EASTask(Context ctx) throws BOSException {
        this.ctx = ctx;
    }

    public void exec(BusinessRepInfo binfo, OutputStream out) throws BOSException, EASBizException {
        try {
            InputStream is = this.getClass().getResourceAsStream("muban_eas.xls");
            this.workbook = new HSSFWorkbook(is);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.inputData(binfo);
        try {
            this.workbook.write(out);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void inputData(BusinessRepInfo binfo) {
        HSSFSheet sheet = this.workbook.getSheetAt(0);
        int r = -1;
        int c = -1;
        HSSFCellStyle cellStyle = null;
        HSSFRow row = sheet.getRow(2);
        HSSFCell cell = row.getCell(2);
        cell.setCellValue(binfo.getName());
        cell = row.getCell(7);
        cell.setCellValue(binfo.getBatch());
        row = sheet.getRow(3);
        cell = row.getCell(2);
        cell.setCellValue(binfo.getNumber());
        cell = row.getCell(7);
        if (binfo.getCreator() != null && binfo.getCreator().getPerson() != null) {
            PersonInfo per = binfo.getCreator().getPerson();
            cell.setCellValue(per.getName());
        } else if (binfo.getDescription() != null) {
            cell.setCellValue(binfo.getDescription().replaceAll(EASResource.getString((String)"com.kingdee.eas.mm.basedata.EMMEMBasedataResource", (String)"CJR_NAME", (Locale)this.ctx.getLocale()), ""));
        } else {
            cell.setCellValue("");
        }
        row = sheet.getRow(4);
        cell = row.getCell(2);
        cell.setCellValue(binfo.getSenddw());
        row = sheet.getRow(5);
        cell = row.getCell(2);
        cell.setCellValue(binfo.getCsdw());
        BusinessRepEntryCollection bcoll = binfo.getEntrys();
        r = 7;
        for (int i = 0; i < bcoll.size(); ++i) {
            BusinessRepEntryInfo entry = bcoll.get(i);
            if ((row = sheet.getRow(++r)) == null) {
                row = sheet.createRow(r);
            }
            if (cellStyle == null) {
                cellStyle = row.getRowStyle();
            } else {
                row.setRowStyle(cellStyle);
            }
            c = -1;
            cell = row.getCell(++c);
            if (cell == null) {
                cell = row.createCell(c, CellType.STRING);
            }
            cell.setCellValue((double)(i + 1));
            cell = row.getCell(++c);
            if (cell == null) {
                cell = row.createCell(c, CellType.STRING);
            }
            cell.setCellValue(entry.getMno());
            cell = row.getCell(++c);
            if (cell == null) {
                cell = row.createCell(c, CellType.STRING);
            }
            cell.setCellValue(entry.getMname());
            cell = row.getCell(++c);
            if (cell == null) {
                cell = row.createCell(c, CellType.STRING);
            }
            cell.setCellValue(entry.getPmno());
            cell = row.getCell(++c);
            if (cell == null) {
                cell = row.createCell(c, CellType.STRING);
            }
            cell.setCellValue(entry.getPmname());
            cell = row.getCell(++c);
            if (cell == null) {
                cell = row.createCell(c, CellType.STRING);
            }
            String qz = "";
            if (entry.getProject() != null) {
                qz = qz + entry.getProject().getName();
                qz = qz + " \r\n ";
            }
            if (entry.getBegincarno() != null) {
                qz = qz + entry.getBegincarno().getNumber();
            }
            if (entry.getEndcarno() != null) {
                qz = qz + " - ";
                qz = qz + entry.getEndcarno().getNumber();
            }
            cell.setCellValue(qz);
            cell = row.getCell(++c);
            if (cell == null) {
                cell = row.createCell(c, CellType.STRING);
            }
            if (entry.getChangeType() != null) {
                cell.setCellValue(entry.getChangeType().getAlias());
            }
            if ((cell = row.getCell(++c)) == null) {
                cell = row.createCell(c, CellType.STRING);
            }
            cell.setCellValue(entry.getReasonsOfChange());
            cell = row.getCell(++c);
            if (cell == null) {
                cell = row.createCell(c, CellType.STRING);
            }
            cell.setCellValue(entry.getMemo());
            cell = row.getCell(++c);
            if (cell == null) {
                cell = row.createCell(c, CellType.STRING);
            }
            cell.setCellValue(entry.getFlow());
            cell = row.getCell(++c);
            if (cell == null) {
                cell = row.createCell(c, CellType.STRING);
            }
            cell.setCellValue(entry.getGyinfo());
        }
    }
}

