/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.common.utils;

import com.enterprisedt.net.ftp.FTPTransferType;
import com.kingdee.bos.service.netfile.ftp.FTPClient;
import com.kingdee.bos.service.netfile.ftp.FTPException;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.industry.emm.common.utils.KmConfig;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;
import sun.net.ftp.FtpClient;

public class FtpUtil {
    private KmConfig kmConfig;
    private static String FTPDLSB_INFO = EASResource.getString((String)"com.kingdee.eas.mm.basedata.EMMEMBasedataResource", (String)"FTPDLSB_INFO");

    public FtpUtil(KmConfig kmConfig) {
        this.kmConfig = kmConfig;
    }

    public static FtpClient loginFTP(KmConfig kmConfig) {
        String ftpHost = kmConfig.getFtpHost();
        int port = kmConfig.getFtpPort();
        String userName = kmConfig.getFtpUser();
        String passWord = kmConfig.getFtpPassword();
        try {
            FtpClient ftpClient = FtpClient.create();
            InetSocketAddress addr = new InetSocketAddress(ftpHost, port);
            ftpClient.connect(addr);
            ftpClient.login(userName, null, passWord);
            return ftpClient;
        }
        catch (Exception e) {
            throw new RuntimeException(FTPDLSB_INFO, e);
        }
    }

    public void upLoadFileFtp(InputStream is, String fileName) {
        FtpClient ftpClient = FtpUtil.loginFTP(this.kmConfig);
        try {
            String path = this.kmConfig.getFtpPath();
            ftpClient.setBinaryType();
            if (!this.isDirExist(path, ftpClient)) {
                this.createDir(path, ftpClient);
                ftpClient.changeDirectory(path);
            }
            fileName = new String(fileName.getBytes(), "UTF-8");
            TelnetOutputStream telnetOut = (TelnetOutputStream)ftpClient.putFileStream(fileName, true);
            DataOutputStream dataOut = new DataOutputStream(telnetOut);
            byte[] buffer = new byte[0x100000];
            int count = 0;
            while ((count = is.read(buffer)) != -1) {
                dataOut.write(buffer, 0, count);
            }
            telnetOut.close();
            dataOut.close();
            ftpClient.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteFileFtp(String fileName) {
        try {
            String path = this.kmConfig.getFtpPath();
            FtpClient ftpClient = FtpUtil.loginFTP(this.kmConfig);
            ftpClient.setBinaryType();
            ftpClient.changeDirectory(path);
            try {
                ftpClient.deleteFile(fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ftpClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void downloadFileFtp(String fileName, OutputStream outputStream) {
        try {
            String path = this.kmConfig.getFtpPath();
            FtpClient ftpClient = FtpUtil.loginFTP(this.kmConfig);
            ftpClient.setBinaryType();
            ftpClient.changeDirectory(path);
            if (fileName.startsWith("\\") || fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            try {
                TelnetInputStream in = (TelnetInputStream)ftpClient.getFileStream(fileName);
                byte[] bytes = new byte[1024];
                int cnt = 0;
                while ((cnt = in.read(bytes, 0, bytes.length)) != -1) {
                    outputStream.write(bytes, 0, cnt);
                }
                in.close();
            }
            catch (Exception e) {
                ftpClient.close();
                e.printStackTrace();
            }
            ftpClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean createDir(String path, FtpClient ftpClient) throws Exception {
        if (this.isDirExist(path, ftpClient)) {
            return true;
        }
        if (path.indexOf("\\") != -1) {
            int ind = path.lastIndexOf("\\");
            this.createDir(path.substring(0, ind), ftpClient);
        }
        ftpClient.changeDirectory("/");
        ftpClient.makeDirectory(path);
        ftpClient.setBinaryType();
        ftpClient.getLastResponseString();
        return false;
    }

    public boolean isDirExist(String dir, FtpClient ftpClient) {
        try {
            ftpClient.changeDirectory(dir);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IOException, FTPException {
        String fileName = "SZL2BL\\CM2014-003374\\\u4fe1\u53f7\u67dc1\u7ec4\u6210_A\u56fe\u6837\u76ee\u5f55-1.pdf";
        try {
            FTPClient c = new FTPClient("172.18.1.10");
            c.login("csrEas", "csr_Eas123");
            c.chdir("Draws");
            String encoding = "GBK";
            byte[] ibyte = fileName.getBytes();
            if (!(fileName.equals(new String(ibyte, encoding)) || fileName.equals(new String(ibyte, encoding = "ISO-8859-1")) || fileName.equals(new String(ibyte, encoding = "Unicode")) || fileName.equals(new String(ibyte, encoding = "UTF-8")) || fileName.equals(new String(ibyte, encoding = "ANSI|ASCII")) || fileName.equals(new String(ibyte, encoding = "US-ASCII")) || fileName.equals(new String(ibyte, encoding = "UTF-16")) || fileName.equals(new String(ibyte, encoding = "UTF-16BE")) || fileName.equals(new String(ibyte, encoding = "GBK")) || fileName.equals(new String(ibyte, encoding = "GB2312")) || fileName.equals(new String(ibyte, encoding = "ISO-8859-1")))) {
                encoding = "BIG5";
            }
            fileName = new String(new String(fileName.getBytes()).getBytes("UTF-8"), "UTF-8");
            byte[] b = c.get(fileName);
            FileOutputStream out = new FileOutputStream("C:\\Users\\dell\\Desktop\\\u4fe1\u53f7\u67dc1.pdf");
            out.write(b);
            out.flush();
            out.close();
            c.quit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        KmConfig kmConfig = new KmConfig();
        kmConfig.setFtpHost("172.18.1.10");
        kmConfig.setFtpPort(21);
        kmConfig.setFtpUser("csrEas");
        kmConfig.setFtpPassword("csr_Eas123");
        kmConfig.setFtpPath("Draws");
        try {
            com.enterprisedt.net.ftp.FTPClient ftp = new com.enterprisedt.net.ftp.FTPClient();
            ftp.setControlEncoding("GBK");
            ftp.setRemoteHost(kmConfig.getFtpHost());
            ftp.setRemotePort(kmConfig.getFtpPort());
            ftp.connect();
            ftp.login(kmConfig.getFtpUser(), kmConfig.getFtpPassword());
            ftp.setType(FTPTransferType.BINARY);
            byte[] bytes = ftp.get("\\" + kmConfig.getFtpPath() + fileName);
            ftp.quit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

