/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.basedata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.mm.basedata.OrganizeDailyOutputFactory;
import com.kingdee.eas.industry.emm.mm.basedata.OrganizeDailyOutputInfo;
import com.kingdee.eas.industry.emm.mm.basedata.WorkshopDailyOutputFactory;
import com.kingdee.eas.industry.emm.mm.basedata.WorkshopDailyOutputInfo;
import com.kingdee.eas.industry.emm.mm.ps.MasterProductionScheduleInfo;
import com.kingdee.eas.industry.emm.mm.ps.WorkshopScheduleInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class DailyOutputUtils {
    private String RESURL = "com.kingdee.eas.industry.emm.mm.basedata.EMMEMBaseResource";
    private String YYQTYHZZZZZRCLPD_INFO = EASResource.getString((String)this.RESURL, (String)"YYQTYHZZZZZRCLPD_INFO");
    private String YYQTYHZZZCJRCLPD_INFO = EASResource.getString((String)this.RESURL, (String)"YYQTYHZZZCJRCLPD_INFO");
    private String PDZZRCLCC_INFO = EASResource.getString((String)this.RESURL, (String)"PDZZRCLCC_INFO");
    private Context ctx;
    private MasterProductionScheduleInfo mps;
    private WorkshopScheduleInfo ws;
    private OrganizeDailyOutputInfo odo;
    private WorkshopDailyOutputInfo wdo;
    public static final String wdo_param = "WorkshopDailyOutput_Control";
    public static final String odo_param = "OrganizeDailyOutput_Control";
    protected final StringBuilder sql_param = new StringBuilder();
    protected boolean isCheck;
    protected final Set locks;
    protected IMutexServiceControl imute;

    public static DailyOutputUtils initInspection(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        if (ctx == null) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.basedata.EMMEMBaseResource", (String)"SXWCS_ISNOTNULL"));
        }
        DailyOutputUtils ut = new DailyOutputUtils();
        ut.ctx = ctx;
        if (MasterProductionScheduleInfo.class.isInstance(info)) {
            ut.mps = (MasterProductionScheduleInfo)info;
            ut.initODO();
        } else if (WorkshopScheduleInfo.class.isInstance(info)) {
            ut.ws = (WorkshopScheduleInfo)info;
            ut.initWDO();
        }
        return ut;
    }

    private DailyOutputUtils() {
        this.sql_param.append(" select pi.fid").append(" from T_BAS_ParamItem pi ").append(" inner join T_BAS_Param p on p.fid = pi.fkeyid and p.fnumber = ?").append(" where pi.fvalue_l2 = 'false'").append(" and pi.forgunitid = ?");
        this.locks = new HashSet();
        this.locks.clear();
    }

    protected void initODO() throws BOSException, EASBizException {
        String storageid = this.mps.getStorageOrgUnit().getId().toString();
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)this.sql_param.toString(), (Object[])new Object[]{odo_param, storageid});
        boolean bl = this.isCheck = rows.size() == 0;
        if (!this.isCheck) {
            return;
        }
        try {
            this.odo = OrganizeDailyOutputFactory.getLocalInstance(this.ctx).getOrganizeDailyOutputInfo("where storageOrgUnit.id = '" + storageid + "'");
        }
        catch (Exception e) {
            this.isCheck = false;
            return;
        }
        if (!this.addLock(this.odo.getId().toString())) {
            throw new EASBizException(new NumericExceptionSubItem("100", this.YYQTYHZZZZZRCLPD_INFO));
        }
    }

    protected void initWDO() throws BOSException, EASBizException {
        String storageid = this.ws.getStorageOrgUnit().getId().toString();
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)this.sql_param.toString(), (Object[])new Object[]{wdo_param, storageid});
        boolean bl = this.isCheck = rows.size() == 0;
        if (!this.isCheck) {
            return;
        }
        try {
            this.wdo = WorkshopDailyOutputFactory.getLocalInstance(this.ctx).getWorkshopDailyOutputInfo("where storageOrgUnit.id = '" + storageid + "' and workshop.id = '" + this.ws.getWorkCenter().getId().toString() + "'");
        }
        catch (Exception e) {
            this.isCheck = false;
            return;
        }
        if (!this.addLock(this.wdo.getId().toString())) {
            throw new EASBizException(new NumericExceptionSubItem("100", this.YYQTYHZZZCJRCLPD_INFO));
        }
    }

    public void inspection() throws BOSException, EASBizException {
        IRowSet rows;
        String fymd;
        String storageid;
        if (!this.isCheck) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder();
        if (this.odo != null) {
            storageid = this.mps.getStorageOrgUnit().getId().toString();
            sql.setLength(0);
            sql.append("select sum(mps.CFQty) CFQty");
            sql.append(" from CT_PS_MasterProductionSchedule mps ");
            sql.append(" where mps.CFFinishTime is not null");
            sql.append(" and mps.CFStorageOrgUnitID = ?");
            sql.append(" and mps.CFBaseStatus in (").append(2).append(",").append(5).append(",").append(8).append(",").append(4).append(")");
            sql.append(" and to_char(mps.CFFinishTime,'yyyy-MM-dd') = ?");
            sql.append(" group by mps.CFStorageOrgUnitID having sum(mps.CFQty) > ?");
            fymd = df.format(this.mps.getFinishTime());
            rows = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{storageid, fymd, this.odo.getDailyOutput()});
            try {
                if (rows != null && rows.next()) {
                    BigDecimal qty = rows.getBigDecimal("CFQty");
                    String strInfo = EASResource.getString((String)this.RESURL, (String)"CGZZRCLSZS_INFO", (Object[])new Object[]{fymd, qty, this.odo.getDailyOutput()});
                    throw new EASBizException(new NumericExceptionSubItem("100", strInfo));
                }
            }
            catch (SQLException e) {
                throw new BOSException(this.PDZZRCLCC_INFO, (Throwable)e);
            }
        }
        if (this.wdo != null) {
            storageid = this.ws.getStorageOrgUnit().getId().toString();
            sql.setLength(0);
            sql.append("select sum(mps.CFQty) CFQty");
            sql.append(" from CT_PS_WorkshopSchedule ws ");
            sql.append(" left join CT_PS_MasterProductionSchedule mps on ws.CFMpsID = mps.fid");
            sql.append(" where ws.CFPlanFinishTime is not null");
            sql.append(" and ws.CFStorageOrgUnitID = ?");
            sql.append(" and ws.CFWorkCenterID = ?");
            sql.append(" and ws.CFBaseStatus in (").append(2).append(",").append(5).append(",").append(8).append(",").append(4).append(")");
            sql.append(" and to_char(ws.CFPlanFinishTime,'yyyy-MM-dd') = ?");
            sql.append(" group by ws.CFStorageOrgUnitID having sum(mps.CFQty) > ?");
            fymd = df.format(this.ws.getPlanFinishTime());
            rows = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{storageid, this.ws.getWorkCenter().getId().toString(), fymd, this.wdo.getDailyOutput()});
            try {
                if (rows != null && rows.next()) {
                    BigDecimal qty = rows.getBigDecimal("CFQty");
                    String strInfo = EASResource.getString((String)this.RESURL, (String)"CGCJRCLSZS_INFO", (Object[])new Object[]{fymd, qty, this.wdo.getDailyOutput()});
                    throw new EASBizException(new NumericExceptionSubItem("100", strInfo));
                }
            }
            catch (SQLException e) {
                throw new BOSException(this.PDZZRCLCC_INFO, (Throwable)e);
            }
        }
    }

    public void endInspection() throws BOSException {
        if (!this.isCheck) {
            return;
        }
        Iterator it = this.locks.iterator();
        while (it.hasNext()) {
            this.unLock(it.next().toString());
        }
    }

    protected boolean addLock(String id) throws BOSException {
        boolean issucess;
        if (this.imute == null) {
            this.imute = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
        }
        if (issucess = this.imute.requestObjIDForUpdate(id)) {
            this.locks.add(id);
        }
        return issucess;
    }

    protected void unLock(String id) throws BOSException {
        if (this.imute == null) {
            this.imute = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
        }
        this.imute.releaseObjIDForUpdate(id);
    }
}

