/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.mm.basedata.OperationRelationSettingCollection;
import com.kingdee.eas.industry.emm.mm.basedata.OperationRelationSettingEntryCollection;
import com.kingdee.eas.industry.emm.mm.basedata.OperationRelationSettingFactory;
import com.kingdee.eas.industry.emm.mm.basedata.OperationRelationSettingInfo;
import com.kingdee.eas.industry.emm.mm.basedata.app.AbstractOperationRelationSettingControllerBean;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OperationRelationSettingControllerBean
extends AbstractOperationRelationSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.mm.basedata.app.OperationRelationSettingControllerBean");
    private static final long serialVersionUID = -7717237343474085100L;
    private String RESURL = "com.kingdee.eas.industry.emm.mm.EMMEMAnalyResource";

    private String getString(Context ctx, String name) {
        return EASResource.getString((String)this.RESURL, (String)name, (Locale)ctx.getLocale());
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            OperationRelationSettingInfo billInfo = OperationRelationSettingFactory.getLocalInstance(ctx).getOperationRelationSettingInfo(pk);
            String billNumber = null;
            if (billInfo != null) {
                billNumber = billInfo.getNumber();
                if (billNumber == null) {
                    billNumber = "";
                }
                this.checkSameBill(ctx, billInfo);
                if (!BillBaseStatusEnum.SUBMITED.equals((Object)billInfo.getBaseStatus())) {
                    throw new BOSException(this.getPSResource(ctx, "Msg_Not_Submit_ListUI", new String[]{billNumber}));
                }
                billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
                billInfo.setAuditTime(new Date());
                billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
                super._update(ctx, pk, (IObjectValue)billInfo);
            }
        }
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            OperationRelationSettingInfo billInfo = OperationRelationSettingFactory.getLocalInstance(ctx).getOperationRelationSettingInfo(pk);
            this._cancel(ctx, pk, (IObjectValue)billInfo);
        }
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model != null) {
            OperationRelationSettingInfo billInfo = (OperationRelationSettingInfo)model;
            String billNumber = null;
            if (billInfo != null) {
                billNumber = billInfo.getNumber();
                if (billNumber == null) {
                    billNumber = "";
                }
                if (!BillBaseStatusEnum.AUDITED.equals((Object)billInfo.getBaseStatus())) {
                    throw new BOSException(this.getPSResource(ctx, "Msg_Not_Audit_ListUI", new String[]{billNumber}));
                }
                billInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
                billInfo.setDisableTime(new Date());
                billInfo.setDisableUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                super._update(ctx, pk, (IObjectValue)billInfo);
            }
        }
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            OperationRelationSettingInfo billInfo = OperationRelationSettingFactory.getLocalInstance(ctx).getOperationRelationSettingInfo(pk);
            this._cancelCancel(ctx, pk, (IObjectValue)billInfo);
        }
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model != null) {
            OperationRelationSettingInfo billInfo = (OperationRelationSettingInfo)model;
            String billNumber = null;
            if (billInfo != null) {
                billNumber = billInfo.getNumber();
                if (billNumber == null) {
                    billNumber = "";
                }
                if (!BillBaseStatusEnum.CLOSED.equals((Object)billInfo.getBaseStatus())) {
                    throw new BOSException(this.getBDResource(ctx, "Msg_Not_Disable_ListUI", new String[]{billNumber}));
                }
                billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
                billInfo.setDisableTime(null);
                billInfo.setDisableUser(null);
                super._update(ctx, pk, (IObjectValue)billInfo);
            }
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            OperationRelationSettingInfo billInfo = OperationRelationSettingFactory.getLocalInstance(ctx).getOperationRelationSettingInfo(pk);
            String billNumber = null;
            if (billInfo != null) {
                billNumber = billInfo.getNumber();
                if (billNumber == null) {
                    billNumber = "";
                }
                if (!(BillBaseStatusEnum.ADD.equals((Object)billInfo.getBaseStatus()) || BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)billInfo.getBaseStatus()) || BillBaseStatusEnum.SUBMITED.equals((Object)billInfo.getBaseStatus()))) {
                    throw new BOSException(this.getPSResource(ctx, "Msg_Not_Add_Save_Submit_ListUI", new String[]{billNumber}));
                }
            }
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            if (model != null) {
                OperationRelationSettingInfo billInfo = (OperationRelationSettingInfo)model;
                String billNumber = null;
                if (billInfo != null) {
                    billNumber = billInfo.getNumber();
                    if ((billNumber == null || billNumber.trim().length() == 0) && billInfo.getStorageOrgUnit() != null && billInfo.getStorageOrgUnit().getId() != null) {
                        this.setBillNumber(ctx, (IObjectValue)billInfo, billInfo.getStorageOrgUnit().getId().toString());
                    }
                    this.checkData(ctx, (IObjectValue)billInfo);
                    if (BillBaseStatusEnum.SUBMITED.equals((Object)billInfo.getBaseStatus())) {
                        throw new PlanOrderException(PlanOrderException.SUBMITED_SAVE_INFORMATION);
                    }
                    if (!BillBaseStatusEnum.ADD.equals((Object)billInfo.getBaseStatus()) && !BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)billInfo.getBaseStatus())) {
                        throw new BOSException(this.getPSResource(ctx, "Msg_Bill_Not_Add_Save", new String[]{billNumber}));
                    }
                }
                billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            }
        }
        catch (BOSException e) {
            if (e.getCause() == null) {
                throw new BOSException(e.getMessage());
            }
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            if (model != null) {
                OperationRelationSettingInfo billInfo = (OperationRelationSettingInfo)model;
                String billNumber = null;
                if (billInfo != null) {
                    billNumber = billInfo.getNumber();
                    if ((billNumber == null || billNumber.trim().length() == 0) && billInfo.getStorageOrgUnit() != null && billInfo.getStorageOrgUnit().getId() != null) {
                        this.setBillNumber(ctx, (IObjectValue)billInfo, billInfo.getStorageOrgUnit().getId().toString());
                    }
                    this.checkData(ctx, (IObjectValue)billInfo);
                    this.checkDeadLoop(ctx, billInfo);
                    if (!(BillBaseStatusEnum.SUBMITED.equals((Object)billInfo.getBaseStatus()) || BillBaseStatusEnum.ADD.equals((Object)billInfo.getBaseStatus()) || BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)billInfo.getBaseStatus()))) {
                        throw new BOSException(this.getPSResource(ctx, "Msg_Not_Add_Save_Submit_ListUI", new String[]{billNumber}));
                    }
                    billInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                }
            }
        }
        catch (BOSException e) {
            if (e.getCause() == null) {
                throw new BOSException(e.getMessage());
            }
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return super._submit(ctx, model);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            OperationRelationSettingInfo billInfo = OperationRelationSettingFactory.getLocalInstance(ctx).getOperationRelationSettingInfo(pk);
            String billNumber = null;
            if (billInfo != null) {
                billNumber = billInfo.getNumber();
                if (billNumber == null) {
                    billNumber = "";
                }
                if (!BillBaseStatusEnum.AUDITED.equals((Object)billInfo.getBaseStatus())) {
                    throw new BOSException(this.getPSResource(ctx, "Msg_Not_Audit_ListUI", new String[]{billNumber}));
                }
                billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                billInfo.setAuditTime(null);
                billInfo.setAuditor(null);
                super._update(ctx, pk, (IObjectValue)billInfo);
            }
        }
    }

    protected void checkData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model != null) {
            EntityViewInfo entityViewInfo = null;
            FilterInfo filterInfo = null;
            SelectorItemCollection selectorItemCollection = null;
            OperationRelationSettingInfo billInfo = (OperationRelationSettingInfo)model;
            if (billInfo.getNumber() == null || billInfo.getNumber().trim().length() == 0) {
                throw new EASBizException(new NumericExceptionSubItem(this.getString(ctx, "SJXYBTG_INFO"), this.getPSResource(ctx, "Msg_Null_Number", null)));
            }
            String billNumber = billInfo.getNumber();
            entityViewInfo = new EntityViewInfo();
            filterInfo = new FilterInfo();
            selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("id"));
            selectorItemCollection.add(new SelectorItemInfo("number"));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)billNumber, CompareType.EQUALS));
            if (billInfo.getId() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)billInfo.getId().toString(), CompareType.NOTEQUALS));
            }
            entityViewInfo.setFilter(filterInfo);
            entityViewInfo.setSelector(selectorItemCollection);
            OperationRelationSettingCollection sameNumberORSCollection = OperationRelationSettingFactory.getLocalInstance(ctx).getOperationRelationSettingCollection(entityViewInfo);
            if (sameNumberORSCollection != null && sameNumberORSCollection.size() > 0) {
                throw new EASBizException(new NumericExceptionSubItem(this.getString(ctx, "SJXYBTG_INFO"), this.getString(ctx, "XTYCZXTBMDDJ_INFO")));
            }
        }
    }

    protected void checkDeadLoop(Context ctx, OperationRelationSettingInfo billInfo) throws BOSException {
        OperationRelationSettingEntryCollection entrysCollection = billInfo.getEntrys();
        if (entrysCollection == null || entrysCollection.size() == 0) {
            return;
        }
        String billNumber = null;
        if (billInfo != null) {
            billNumber = billInfo.getNumber();
        }
        String operationID = null;
        String operationNumber = null;
        String operationName = null;
        String nextOperationID = null;
        StringBuffer deadLoopPaths = new StringBuffer();
        ArrayList<String> checkPathLoop = new ArrayList<String>();
        ArrayList<String> checkLoop = new ArrayList<String>();
        ArrayList<String> deadPathLoop = new ArrayList<String>();
        for (int row = 0; row < entrysCollection.size(); ++row) {
            if (entrysCollection.get(row) == null) continue;
            int seq = entrysCollection.get(row).getSeq();
            if (entrysCollection.get(row).getOperation() != null) {
                operationID = entrysCollection.get(row).getOperation().getId().toString();
                operationNumber = entrysCollection.get(row).getOperation().getNumber() == null ? "" : entrysCollection.get(row).getOperation().getNumber();
                String string = operationName = entrysCollection.get(row).getOperation().getName() == null ? "" : entrysCollection.get(row).getOperation().getName();
            }
            if (entrysCollection.get(row).getNextOperation() != null) {
                nextOperationID = entrysCollection.get(row).getNextOperation().getId().toString();
            }
            if (operationID == null) {
                throw new BOSException(this.getBDResource(ctx, "Msg_Bill_Entry_WPE_Null", new String[]{billNumber, String.valueOf(seq)}));
            }
            if (nextOperationID == null) {
                throw new BOSException(this.getBDResource(ctx, "Msg_Bill_Entry_NextWPE_Null", new String[]{billNumber, String.valueOf(seq)}));
            }
            checkLoop.clear();
            checkLoop.add(operationID);
            checkPathLoop.add("[" + seq + "] (" + operationNumber + ")" + operationName);
            while (checkLoop.size() > 0) {
                int count = checkLoop.size();
                for (int loop = 0; loop < count; ++loop) {
                    if (checkLoop.get(0) == null) continue;
                    String loopID = checkLoop.get(0).toString();
                    for (int find = 0; find < entrysCollection.size(); ++find) {
                        if (entrysCollection.get(find) == null || entrysCollection.get(find).getOperation() == null || entrysCollection.get(find).getNextOperation() == null || !loopID.equals(entrysCollection.get(find).getNextOperation().getId().toString())) continue;
                        String findID = entrysCollection.get(find).getOperation().getId().toString();
                        String findNumber = entrysCollection.get(find).getOperation().getNumber() == null ? "" : entrysCollection.get(find).getOperation().getNumber();
                        String findName = entrysCollection.get(find).getOperation().getName() == null ? "" : entrysCollection.get(find).getOperation().getName();
                        int findSeq = entrysCollection.get(find).getSeq();
                        if (operationID.equals(findID)) {
                            deadPathLoop.add(checkPathLoop.get(0) + " , [" + findSeq + "] (" + findNumber + ")" + findName);
                            continue;
                        }
                        checkLoop.add(findID);
                        checkPathLoop.add(checkPathLoop.get(0) + " , [" + findSeq + "] (" + findNumber + ")" + findName);
                    }
                    checkLoop.remove(0);
                    checkPathLoop.remove(0);
                }
            }
            if (deadPathLoop == null || deadPathLoop.size() <= 0) continue;
            for (int loop = 0; loop < deadPathLoop.size(); ++loop) {
                deadLoopPaths.append("\r\n").append(deadPathLoop.get(loop));
            }
            throw new BOSException(this.getBDResource(ctx, "Msg_Bill_Entry_DeadLoopPath", new String[]{billNumber, deadLoopPaths.toString()}));
        }
    }

    protected void checkSameBill(Context ctx, OperationRelationSettingInfo billInfo) throws BOSException {
        String workCenterID = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String id = billInfo.getId().toString();
        String billNumber = billInfo.getNumber();
        if (billInfo.getStorageOrgUnit() == null || !(billInfo.getStorageOrgUnit() instanceof StorageOrgUnitInfo)) {
            throw new BOSException(this.getBDResource(ctx, "Msg_Bill_StorageOrgUnit_Null", new String[]{billNumber}));
        }
        if (billInfo.getStorageOrgUnit().getId() == null) {
            throw new BOSException(this.getBDResource(ctx, "Msg_Bill_StorageOrgUnit_Null", new String[]{billNumber}));
        }
        if (billInfo.getProject().getId() == null) {
            throw new BOSException(this.getPSResource(ctx, "Msg_Bill_Project_Null", new String[]{billNumber}));
        }
        String storageOrgUnitID = billInfo.getStorageOrgUnit().getId().toString();
        String projectID = billInfo.getProject().getId().toString();
        if (billInfo.getWorkCenter() != null && billInfo.getWorkCenter() instanceof WorkCenterInfo && billInfo.getWorkCenter().getId() != null) {
            workCenterID = billInfo.getWorkCenter().getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectID, CompareType.EQUALS));
        if (workCenterID != null && workCenterID.trim().length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("workCenter.id", (Object)workCenterID, CompareType.EQUALS));
        }
        entityViewInfo.setFilter(filterInfo);
        OperationRelationSettingCollection ioss = OperationRelationSettingFactory.getLocalInstance(ctx).getOperationRelationSettingCollection(entityViewInfo);
        if (ioss != null && ioss.size() > 0) {
            throw new BOSException(this.getBDResource(ctx, "Msg_Bill_Exists_Same_ORS", new String[]{billNumber}));
        }
    }

    protected String getBDResource(Context ctx, String item, String[] param) {
        if (item == null || item.trim().length() == 0) {
            return null;
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.basedata.BasedataResource", (String)item, (Locale)ctx.getLocale());
        if (msg == null || msg.trim().length() == 0) {
            return null;
        }
        if (param != null) {
            for (int i = 0; i < param.length; ++i) {
                if (param[i] == null) continue;
                msg = msg.replace("{" + i + "}", param[i]);
            }
        }
        return msg;
    }

    protected String getPSResource(Context ctx, String item, String[] param) {
        if (item == null || item.trim().length() == 0) {
            return null;
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.PsResource", (String)item, (Locale)ctx.getLocale());
        if (msg == null || msg.trim().length() == 0) {
            return null;
        }
        if (param != null) {
            for (int i = 0; i < param.length; ++i) {
                if (param[i] == null) continue;
                msg = msg.replace("{" + i + "}", param[i]);
            }
        }
        return msg;
    }

    protected void setBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws Exception {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        if (billNumber != null) {
            billInfo.setString("number", billNumber);
        } else if (billInfo.getString("id") != null) {
            billInfo.setString("number", "AutoNumberFromBTP_" + billInfo.getString("id").toString());
        } else {
            billInfo.setString("number", "AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        }
    }
}

