/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.mo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.common.util.TransactionTypeUtils;
import com.kingdee.eas.industry.emm.mm.mo.AbstractMFOrderBackFlushFacadeControllerBean;
import com.kingdee.eas.industry.emm.mm.mo.MftOrderCreateMaterialReqBill;
import com.kingdee.eas.mm.basedata.IWIPTransferRule;
import com.kingdee.eas.mm.basedata.IWorkCenter;
import com.kingdee.eas.mm.basedata.WIPTransferRuleCollection;
import com.kingdee.eas.mm.basedata.WIPTransferRuleFactory;
import com.kingdee.eas.mm.basedata.WorkCenterCollection;
import com.kingdee.eas.mm.basedata.WorkCenterFactory;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.im.inv.IMaterialReqBill;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MFOrderBackFlushFacadeControllerBean
extends AbstractMFOrderBackFlushFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.mm.mo.MFOrderBackFlushFacadeControllerBean");
    private String RESURL = "com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource";
    protected MftOrderCreateMaterialReqBill createUtil = new MftOrderCreateMaterialReqBill();

    @Override
    protected String _openOperate(Context ctx, Map param) throws BOSException, EASBizException {
        return this.cx(ctx, param);
    }

    protected String cx(Context ctx, Map param) throws BOSException, EASBizException {
        IManufactureOrder imanufactureOrder = ManufactureOrderFactory.getLocalInstance((Context)ctx);
        String id = (String)param.get("id");
        String operateNo = param.get("operateNo").toString();
        String over = (String)param.get("OVER");
        ManufactureOrderInfo manufactureorder = imanufactureOrder.getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(id), MftOrderCreateMaterialReqBill.getOrderSelector());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(MftOrderCreateMaterialReqBill.getOrderStockSelector());
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("parent.id", (Object)id));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("islineStorehouse", (Object)1));
        evi.getFilter().setMaskString("#0 and #1");
        ManufactureOrderStockCollection stocks = new ManufactureOrderStockCollection();
        CoreBaseCollection cores = ManufactureOrderStockFactory.getLocalInstance((Context)ctx).getCollection(evi);
        for (int i = 0; i < cores.size(); ++i) {
            ManufactureOrderStockInfo mftoInfo = (ManufactureOrderStockInfo)cores.get(i);
            stocks.add(mftoInfo);
        }
        manufactureorder.put("stocks", (Object)stocks);
        evi = new EntityViewInfo();
        evi.setSelector(MftOrderCreateMaterialReqBill.getOrderTechnicsSelector());
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("parent.id", (Object)id));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("operationNo", (Object)operateNo));
        CoreBaseCollection technicscol = ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx).getCollection(evi);
        ManufactureOrderTechnicsCollection technics = new ManufactureOrderTechnicsCollection();
        for (int i = 0; i < technicscol.size(); ++i) {
            technics.add((ManufactureOrderTechnicsInfo)technicscol.get(i));
        }
        manufactureorder.put("technics", (Object)technics);
        if (over != null) {
            ManufactureOrderInfo manufactureorderXB = (ManufactureOrderInfo)manufactureorder.clone();
            this.backFlushXB(manufactureorderXB, ctx, operateNo);
        }
        Iterator it = stocks.iterator();
        while (it.hasNext()) {
            ManufactureOrderStockInfo entry = (ManufactureOrderStockInfo)it.next();
            if (operateNo.equals(String.valueOf(entry.getOperationNo())) && entry.isIsBackflush() && entry.getQty().compareTo(entry.getActIssueQty()) > 0) continue;
            it.remove();
        }
        return null;
    }

    protected void backFlushXB(ManufactureOrderInfo manufactureorder, Context ctx, String operateNo) throws EASBizException, BOSException {
        ManufactureOrderStockCollection stocks = manufactureorder.getStocks();
        Iterator it = stocks.iterator();
        while (it.hasNext()) {
            ManufactureOrderStockInfo entry = (ManufactureOrderStockInfo)it.next();
            BigDecimal plannedQty = entry.getPlannedQty();
            BigDecimal actIssQty = entry.getActIssueQty();
            if (operateNo.equals(String.valueOf(entry.getOperationNo())) && Boolean.parseBoolean(entry.get("islinestorehouse").toString()) && plannedQty.compareTo(actIssQty) > 0) continue;
            it.remove();
        }
        if (stocks.size() > 0) {
            CoreBillBaseCollection billcolle = new CoreBillBaseCollection();
            billcolle.add((CoreBillBaseInfo)manufactureorder);
            this.botptransformXB(ctx, billcolle, null);
        }
    }

    protected WarehouseInfo getbackWareHouse(Context ctx, String workcenterid, String storageid) throws EASBizException, BOSException {
        IWorkCenter iworkCenter = WorkCenterFactory.getLocalInstance((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select backWareHouse,number where id='").append(workcenterid);
        sql.append("' and storageOrgUnit.id='").append(storageid).append("'");
        WorkCenterInfo centerInfo = iworkCenter.getWorkCenterInfo(sql.toString());
        WarehouseInfo warehouse = (WarehouseInfo)centerInfo.get("backWareHouse");
        if (warehouse == null) {
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"GZZXMYSZDCCK_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{centerInfo.getNumber()});
            throw new EASBizException(new NumericExceptionSubItem("", strInfo));
        }
        return warehouse;
    }

    protected Map getbackWareHouse(Context ctx, String wcids) throws EASBizException, BOSException {
        HashMap<String, WarehouseInfo> retMap = new HashMap<String, WarehouseInfo>();
        IWorkCenter iworkCenter = WorkCenterFactory.getLocalInstance((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select backWareHouse.*,number,id,storageOrg.id where id in( ").append(wcids).append(")");
        WorkCenterCollection centerInfos = iworkCenter.getWorkCenterCollection(sql.toString());
        int a = centerInfos.size();
        for (int i = 0; i < a; ++i) {
            WorkCenterInfo centerInfo = centerInfos.get(i);
            WarehouseInfo warehouse = (WarehouseInfo)centerInfo.get("backWareHouse");
            if (warehouse == null) {
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"GZZXMYSZDCCK_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{centerInfo.getNumber()});
                throw new EASBizException(new NumericExceptionSubItem("", strInfo));
            }
            retMap.put(centerInfo.getId().toString(), warehouse);
        }
        return retMap;
    }

    protected WarehouseInfo getbackWareHouseXB(Context ctx, String workcenterid, String storageid) throws EASBizException, BOSException {
        IWorkCenter iworkCenter = WorkCenterFactory.getLocalInstance((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select lineStorehouse,number where id='").append(workcenterid);
        sql.append("' and storageOrgUnit.id='").append(storageid).append("'");
        WorkCenterInfo centerInfo = iworkCenter.getWorkCenterInfo(sql.toString());
        WarehouseInfo warehouse = (WarehouseInfo)centerInfo.get("lineStorehouse");
        if (warehouse == null) {
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"GZZXMYSZXBCK_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{centerInfo.getNumber()});
            throw new EASBizException(new NumericExceptionSubItem("", strInfo));
        }
        return warehouse;
    }

    protected Map getbackWareHouseXB(Context ctx, String wcids) throws EASBizException, BOSException {
        HashMap<String, WarehouseInfo> retMap = new HashMap<String, WarehouseInfo>();
        IWorkCenter iworkCenter = WorkCenterFactory.getLocalInstance((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select lineStorehouse.*,number,id,storageOrg.id where id in(").append(wcids).append(")");
        WorkCenterCollection centerInfos = iworkCenter.getWorkCenterCollection(sql.toString());
        int a = centerInfos.size();
        for (int i = 0; i < a; ++i) {
            WorkCenterInfo centerInfo = centerInfos.get(i);
            WarehouseInfo warehouse = (WarehouseInfo)centerInfo.get("lineStorehouse");
            if (warehouse == null) {
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"GZZXMYSZXBCK_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{centerInfo.getNumber()});
                throw new EASBizException(new NumericExceptionSubItem("", strInfo));
            }
            retMap.put(centerInfo.getId().toString(), warehouse);
        }
        return retMap;
    }

    public BOTMappingInfo getBOTPRule(Context ctx, String botpnumber) throws BOSException, EASBizException {
        IBOTMapping botFac = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo botInfo = null;
        BOTMappingCollection botCol = botFac.getBOTMappingCollection("where name='" + botpnumber + "' and extRule.isEffected=1  ");
        if (botCol.size() != 1) {
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"MYZDBMWZHGZSFQY_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{botpnumber});
            throw new EASBizException(new NumericExceptionSubItem("", strInfo));
        }
        botInfo = botCol.get(0);
        return botInfo;
    }

    protected BOTMappingInfo getBOTPRuleFromWIPTransferRule(Context ctx, String storageOrgUnitId, ManufactureOrderStockInfo stockInfo) throws BOSException, EASBizException {
        WIPTransferRuleCollection ruleColl;
        WorkCenterInfo wcInfo = stockInfo.getWorkcenter();
        EntityViewInfo evi = new EntityViewInfo();
        IWIPTransferRule iTransferRule = WIPTransferRuleFactory.getLocalInstance(ctx);
        evi.getFilter().getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId));
        if (wcInfo != null) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("workCenter.id", (Object)wcInfo.getId().toString()));
        }
        if ((ruleColl = iTransferRule.getWIPTransferRuleCollection(evi)) == null || ruleColl.size() < 1) {
            evi.getFilter().setMaskString("#0");
            ruleColl = iTransferRule.getWIPTransferRuleCollection(evi);
            if (ruleColl == null || ruleColl.size() < 1) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0402", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0403", (Locale)ctx.getLocale())));
            }
        }
        BOTMappingInfo btpinfo = ruleColl.get(0).getTansferRule();
        return btpinfo;
    }

    protected boolean getisbackflush(Context ctx, String materialid, String orgid) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select  *  where ").append("material.id='" + materialid + "'");
        sql.append(" and orgUnit.id='" + orgid + "'");
        MaterialPlanInfo info = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanInfo(sql.toString());
        if (info == null) {
            return false;
        }
        return info.isIsBackFlush();
    }

    public void handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws EASBizException, BOSException {
        String workcenterid;
        MaterialReqBillInfo info = (MaterialReqBillInfo)objectValue;
        MaterialReqBillEntryCollection entries = info.getEntry();
        StringBuffer wcids = new StringBuffer();
        for (int a = 0; a < entries.size(); ++a) {
            MaterialReqBillEntryInfo entry = entries.get(a);
            boolean isBackFlush = true;
            entry.put("isBackFlush", (Object)isBackFlush);
            if (entry.getWorkCenter() == null) continue;
            workcenterid = entry.getWorkCenter().getId().toString();
            if (wcids.length() == 0) {
                wcids.append("'").append(workcenterid).append("'");
                continue;
            }
            wcids.append(",").append(workcenterid).append("'");
        }
        Map warehousemap = this.getbackWareHouse(ctx, wcids.toString());
        for (int a = 0; a < entries.size(); ++a) {
            MaterialReqBillEntryInfo entry = entries.get(a);
            if (entry.getWorkCenter() == null) continue;
            workcenterid = entry.getWorkCenter().getId().toString();
            WarehouseInfo backWareHouse = (WarehouseInfo)warehousemap.get(workcenterid);
            entry.put("backFlushWareHouse", (Object)backWareHouse);
            entry.setWarehouse(backWareHouse);
            entry.setLocation(null);
            entry.setSupplyWarehouse(backWareHouse);
            entry.setSupplyLocation(null);
            entry.setStorageOrgUnit(backWareHouse.getStorageOrg());
        }
    }

    public void handleAfterTransformXB(Context ctx, IObjectValue objectValue) throws EASBizException, BOSException {
        MaterialReqBillInfo info = (MaterialReqBillInfo)objectValue;
        MaterialReqBillEntryCollection entries = info.getEntry();
        StringBuffer wcids = new StringBuffer();
        for (int a = 0; a < entries.size(); ++a) {
            MaterialReqBillEntryInfo entry = entries.get(a);
            if (entry.getWorkCenter() == null) continue;
            String workcenterid = entry.getWorkCenter().getId().toString();
            if (wcids.length() == 0) {
                wcids.append("'").append(workcenterid).append("'");
                continue;
            }
            wcids.append(",'").append(workcenterid).append("'");
        }
        Map warehousemap = this.getbackWareHouseXB(ctx, wcids.toString());
        int x = entries.size();
        for (int a = 0; a < x; ++a) {
            WarehouseInfo xbkWareHouse;
            MaterialReqBillEntryInfo entry = entries.get(a);
            if (entry.getWorkCenter() != null) {
                String workcenterid = entry.getWorkCenter().getId().toString();
                xbkWareHouse = (WarehouseInfo)warehousemap.get(workcenterid);
                if (xbkWareHouse == null) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0404", (Locale)ctx.getLocale())));
                }
            } else {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0405", (Locale)ctx.getLocale())));
            }
            entry.setWarehouse(xbkWareHouse);
            entry.setSupplyWarehouse(xbkWareHouse);
            entry.setLocation(null);
            entry.setSupplyLocation(null);
            entry.setStorageOrgUnit(xbkWareHouse.getStorageOrg());
        }
    }

    protected void botptransform(Context ctx, CoreBillBaseCollection coll, BOTMappingInfo botInfo) throws BOSException, EASBizException {
        IMaterialReqBill imaterialReqBill = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        StringBuffer errorMsg = new StringBuffer();
        CoreBaseCollection bills = this.createUtil.createMaterialReqbill(ctx, coll);
        StringBuffer sql = new StringBuffer();
        sql.append("update t_im_materialreqbillentry set fqty=fqty-?,cfactureqty=cfactureqty-?,");
        sql.append("fbaseQty=fbaseQty-?,fissueqty=fissueqty-?,fbaseIssueQty=fbaseIssueQty-? where fsourcebillentryid=?");
        sql.append(" and exists(select 1 from t_im_materialreqbill where fsourcebillid=? and fbasestatus<>4 ");
        sql.append(" and t_im_materialreqbillentry.fparentid=fid)");
        ArrayList<Object[]> param = new ArrayList<Object[]>();
        ArrayList<String> sqls = new ArrayList<String>();
        boolean flag = false;
        for (int i = 0; i < bills.size(); ++i) {
            MaterialReqBillInfo tempInfo = (MaterialReqBillInfo)bills.getObject(i);
            String orgid = tempInfo.getSupplyStoreOrgUnit().getId().toString();
            MaterialReqBillEntryCollection entries = tempInfo.getEntry();
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                BigDecimal issueQty;
                MaterialReqBillEntryInfo entry = (MaterialReqBillEntryInfo)it.next();
                orgid = entry.getStorageOrgUnit().getId().toString();
                this.handleAfterTransform(ctx, entry);
                BigDecimal bigDecimal = issueQty = entry.getIssueQty() == null ? BigDecimal.valueOf(0L) : entry.getIssueQty();
                if (issueQty.compareTo(new BigDecimal(0)) < 0) {
                    it.remove();
                    errorMsg.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0406", (Locale)ctx.getLocale()));
                }
                int ret = this.getMaterialQty(entry, orgid, ctx);
                String entryid = entry.getSourceBillEntryId();
                String billid = entry.getSourceBillId();
                if (ret == 1) {
                    it.remove();
                    String value = entry.getWarehouse() == null ? EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0407", (Locale)ctx.getLocale()) : entry.getWarehouse().getName();
                    String strInfo = ResourceBase.getString((String)this.RESURL, (String)"WLWFCXXQ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{entry.getMaterial().getNumber(), value});
                    errorMsg.append(strInfo).append("\r\n");
                } else if (ret == 2) {
                    StringBuffer tempsql = new StringBuffer();
                    tempsql.append(" update t_im_materialreqbillentry set fqty=0,");
                    tempsql.append(" fbaseQty=0,fissueqty=0,fbaseIssueQty=0,cfactureqty=0 where fsourcebillentryid='").append(entryid).append("'");
                    tempsql.append(" and exists(select 1 from t_im_materialreqbill where fsourcebillid='").append(billid).append("' and fbasestatus<>4 ");
                    tempsql.append(" and t_im_materialreqbillentry.fparentid=fid )");
                    sqls.add(tempsql.toString());
                } else if (ret == 3) {
                    BigDecimal qty = entry.getQty();
                    BigDecimal baseQty = entry.getBaseQty();
                    BigDecimal issueqty = entry.getIssueQty();
                    BigDecimal baseIssueQty = entry.getBaseIssueQty();
                    Object[] params = new Object[]{qty, qty, baseQty, issueqty, baseIssueQty, entryid, billid};
                    param.add(params);
                }
                entry.put("billBaseStatus", (Object)BillBaseStatusEnum.SUBMITED);
                entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            }
            if (entries.size() <= 0) continue;
            tempInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            tempInfo.setSupplyStoreOrgUnit(entries.get(0).getStorageOrgUnit());
            tempInfo.setStorageOrgUnit(entries.get(0).getStorageOrgUnit());
            AutoNumberUtil.initNumber(ctx, (IObjectValue)tempInfo);
            IObjectPK pk = imaterialReqBill.addnew((CoreBaseInfo)tempInfo);
            tempInfo.put("isaudit", (Object)"BACKFLUSH");
            imaterialReqBill.save(pk, (CoreBaseInfo)tempInfo);
            tempInfo = imaterialReqBill.getMaterialReqBillInfo(pk, SCMSelectorFactory.getMaterialReqBillSelector((boolean)true));
            imaterialReqBill.passAudit(pk, (CoreBillBaseInfo)tempInfo);
            if (param.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), param);
            }
            if (sqls.size() > 0) {
                com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, sqls);
            }
            flag = true;
        }
        if (!flag) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0408", (Locale)ctx.getLocale()), errorMsg.toString()));
        }
        MftOrderCreateMaterialReqBill.saveRelation(ctx, bills);
    }

    protected void botptransformXB(Context ctx, CoreBillBaseCollection coll, BOTMappingInfo botInfo) throws BOSException, EASBizException {
        IMaterialReqBill imaterialReqBill = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        StringBuffer errorMsg = new StringBuffer();
        CoreBaseCollection bills = this.createUtil.createMaterialReqbill(ctx, coll);
        boolean flag = false;
        for (int i = 0; i < bills.size(); ++i) {
            MaterialReqBillInfo tempInfo = (MaterialReqBillInfo)bills.getObject(i);
            String orgid = tempInfo.getSupplyStoreOrgUnit().getId().toString();
            MaterialReqBillEntryCollection entries = tempInfo.getEntry();
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                BigDecimal issueQty;
                MaterialReqBillEntryInfo entry = (MaterialReqBillEntryInfo)it.next();
                this.handleAfterTransform(ctx, entry);
                orgid = entry.getStorageOrgUnit().getId().toString();
                int ret = this.getMaterialQtyXB(entry, orgid, ctx);
                if (ret == 1) {
                    it.remove();
                    String value = entry.getWarehouse() == null ? EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0407", (Locale)ctx.getLocale()) : entry.getWarehouse().getName();
                    String strInfo = ResourceBase.getString((String)this.RESURL, (String)"WLWFCXXQ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{entry.getMaterial().getNumber(), value});
                    errorMsg.append(strInfo).append("\r\n");
                }
                BigDecimal bigDecimal = issueQty = entry.getIssueQty() == null ? BigDecimal.valueOf(0L) : entry.getIssueQty();
                if (issueQty.compareTo(new BigDecimal(0)) < 0) {
                    it.remove();
                    errorMsg.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0409", (Locale)ctx.getLocale())).append("\r\n");
                }
                entry.put("billBaseStatus", (Object)BillBaseStatusEnum.SUBMITED);
                entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
                entry.setInvUpdateType(TransactionTypeUtils.getInvUpdateTypeServer((Context)ctx, (TransactionTypeInfo)tempInfo.getTransactionType()));
            }
            if (entries.size() <= 0) continue;
            tempInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            tempInfo.setSupplyStoreOrgUnit(entries.get(0).getStorageOrgUnit());
            tempInfo.setStorageOrgUnit(entries.get(0).getStorageOrgUnit());
            AutoNumberUtil.initNumber(ctx, (IObjectValue)tempInfo);
            IObjectPK pk = imaterialReqBill.addnew((CoreBaseInfo)tempInfo);
            tempInfo.put("isaudit", (Object)"BACKFLUSHXB");
            imaterialReqBill.save(pk, (CoreBaseInfo)tempInfo);
            tempInfo = imaterialReqBill.getMaterialReqBillInfo(pk, SCMSelectorFactory.getMaterialReqBillSelector((boolean)true));
            imaterialReqBill.submit(pk, (CoreBaseInfo)tempInfo);
            ISCMBillParam iSCMBillParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strAutoAudit = iSCMBillParam.getParamByBillTypeID("SCM_Submit_01", this.getMainOrgType((SCMBillBaseInfo)tempInfo).getValue(), tempInfo.getStorageOrgUnit() == null ? null : tempInfo.getStorageOrgUnit().getId().toString(), tempInfo.getBillType() == null ? null : tempInfo.getBillType().getId().toString());
            if (strAutoAudit == null || !"1".equals(strAutoAudit)) {
                imaterialReqBill.passAudit(pk, (CoreBillBaseInfo)tempInfo);
            }
            flag = true;
        }
        if (!flag) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0408", (Locale)ctx.getLocale()), errorMsg.toString()));
        }
        MftOrderCreateMaterialReqBill.saveRelation(ctx, bills);
    }

    protected OrgType getMainOrgType(SCMBillBaseInfo info) {
        return info == null ? null : info.getMainOrgType();
    }

    private void handleAfterTransform(Context ctx, MaterialReqBillEntryInfo entry) throws BOSException {
        String stockId = entry.getSourceBillEntryId();
        StringBuffer sql = new StringBuffer();
        sql.append("select isNull(mos.funissuebaseqty ,0)unissuebaseqty,isNull(mos.funissueqty ,0)unissueqty \r\n");
        sql.append("from T_MM_MFTOrderStock mos \r\n");
        sql.append("where mos.fid='").append(stockId).append("' \r\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                BigDecimal unissuebaseqty = rowSet.getBigDecimal("unissuebaseqty");
                BigDecimal unissueqty = rowSet.getBigDecimal("unissueqty");
                entry.setBaseIssueQty(unissuebaseqty);
                entry.setIssueQty(unissueqty);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected BigDecimal getinventoryQty(String sql, Context ctx) throws BOSException, EASBizException {
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        BigDecimal temp = SysConstant.BIGZERO;
        try {
            if (set.next()) {
                temp = set.getBigDecimal("num");
                if (temp == null) {
                    temp = SysConstant.BIGZERO;
                }
            } else {
                temp = SysConstant.BIGZERO;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0410", (Locale)ctx.getLocale())));
        }
        return temp;
    }

    public int getMaterialQty(MaterialReqBillEntryInfo entry, String orgid, Context ctx) throws EASBizException, BOSException {
        WarehouseInfo warehouse = (WarehouseInfo)entry.get("backFlushWareHouse");
        if (warehouse != null) {
            String materialid = entry.getMaterial().getId().toString();
            String unitid = entry.getUnit().getId().toString();
            BigDecimal qty = entry.getQty();
            String wareHouseid = warehouse.getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append(" select sum(fCurStoreQty)num from  T_IM_Inventory ");
            sql.append(" where");
            sql.append(" fmaterialid='").append(materialid).append("'");
            sql.append(" and  fwarehouseid='").append(wareHouseid).append("'");
            sql.append(" and  funitid='").append(unitid).append("'");
            sql.append(" and  fstoretypeid='").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'");
            sql.append(" and  fstorestatusid='").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("'");
            sql.append(" and  fstorageorgunitid='").append(orgid).append("'");
            BigDecimal tempqty = this.getinventoryQty(sql.toString(), ctx);
            if (tempqty.compareTo(SysConstant.BIGZERO) == 0) {
                return 1;
            }
            if (tempqty.compareTo(qty) >= 0) {
                entry.put("actureQty", (Object)qty);
                return 2;
            }
            BigDecimal rate = entry.getBaseIssueQty().divide(entry.getIssueQty());
            entry.setQty(tempqty);
            entry.put("actureQty", (Object)tempqty);
            entry.setBaseQty(rate.multiply(tempqty));
            entry.setIssueQty(tempqty);
            entry.setBaseIssueQty(rate.multiply(tempqty));
            return 3;
        }
        return 4;
    }

    public int getMaterialQtyXB(MaterialReqBillEntryInfo entry, String orgid, Context ctx) throws EASBizException, BOSException {
        WarehouseInfo warehouse = entry.getWarehouse();
        if (warehouse != null) {
            String materialid = entry.getMaterial().getId().toString();
            String unitid = entry.getUnit().getId().toString();
            BigDecimal qty = entry.getQty();
            String wareHouseid = warehouse.getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append(" select sum(fCurStoreQty)num from  T_IM_Inventory ");
            sql.append(" where");
            sql.append(" fmaterialid='").append(materialid).append("'");
            sql.append(" and  fwarehouseid='").append(wareHouseid).append("'");
            sql.append(" and  funitid='").append(unitid).append("'");
            sql.append(" and  fstoretypeid='").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'");
            sql.append(" and  fstorestatusid='").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("'");
            sql.append(" and  fstorageorgunitid='").append(orgid).append("'");
            BigDecimal tempqty = this.getinventoryQty(sql.toString(), ctx);
            if (tempqty.compareTo(SysConstant.BIGZERO) == 0) {
                return 1;
            }
            if (tempqty.compareTo(qty) >= 0) {
                return 2;
            }
            BigDecimal rate = entry.getBaseIssueQty().divide(entry.getIssueQty());
            entry.setQty(tempqty);
            entry.setBaseQty(rate.multiply(tempqty));
            entry.setIssueQty(tempqty);
            entry.setBaseIssueQty(rate.multiply(tempqty));
            return 3;
        }
        return 4;
    }

    @Override
    protected String _openOperate_required(Context ctx, Map param) throws BOSException, EASBizException {
        return this.cx(ctx, param);
    }
}

