/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.mo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.exception.IMultiException;
import com.kingdee.bos.appframework.exception.IMultiExceptionMessageFormatter;
import com.kingdee.bos.appframework.exception.ValidateErrorFormatter;
import com.kingdee.bos.appframework.exception.ValidateFailedException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.LineResult;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.util.EASMultiException;
import com.kingdee.eas.industry.emm.common.util.TransactionTypeUtils;
import com.kingdee.eas.mm.basedata.IWIPTransferRule;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.basedata.WIPTransferRuleCollection;
import com.kingdee.eas.mm.basedata.WIPTransferRuleFactory;
import com.kingdee.eas.mm.basedata.WorkCenterFactory;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.PickTypeEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MftOrderCreateMaterialReqBill {
    private static String RESURL = "com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource";
    public static final String MM_DMES017 = "MM_DMES017";
    public static final String MM_DMES01701 = "MM_DMES01701";
    public static final String MM_DMES01701ZXJ = "MM_DMES01701ZXJ";
    public static final String MM_DMES017ZXJ = "MM_DMES017ZXJ";
    public static final String MM_DMES021 = "MM_DMES021";
    public static final String MM_DMES02101 = "MM_DMES02101";
    public static final String MM_DMES04101 = "MM_DMES04101";
    public static final String MM_DMES10000 = "MM_DMES10000";
    public Map isClose = new HashMap();
    public Map periods = new HashMap();
    protected Context ctx;
    protected StringBuilder key = new StringBuilder();
    protected String sql_TransactionType = "Select FID From T_SCM_TransactionType Where FNumber=?";
    protected Map ttMap = new HashMap();

    public static CoreBaseCollection create(Context ctx, CoreBillBaseCollection orders) throws EASBizException, BOSException {
        LineResult lRlt;
        int i;
        MftOrderCreateMaterialReqBill mftutil = new MftOrderCreateMaterialReqBill(ctx);
        CoreBaseCollection result = mftutil.create(orders);
        if (result.size() == 0) {
            return result;
        }
        mftutil.autoNumber(ctx, result);
        Result rlt = MaterialReqBillFactory.getLocalInstance((Context)ctx).addnew(result);
        ValidateFailedException ve = new ValidateFailedException();
        boolean bool = true;
        for (i = 0; i < rlt.size(); ++i) {
            lRlt = rlt.getLineResult(i);
            if (lRlt.isSucess() || !bool) continue;
            bool = false;
        }
        for (i = 0; i < rlt.size(); ++i) {
            lRlt = rlt.getLineResult(i);
            if (lRlt.isSucess() && bool || lRlt.isSucess()) continue;
            Exception exc = lRlt.getException();
            ve.addError("\u7b2c" + (i + 1) + "\u6761", result.getObject(i), exc);
        }
        if (ve != null && ve.getErrors().size() > 0) {
            ve.setFormatter((IMultiExceptionMessageFormatter)new ValidateErrorFormatter());
            EASMultiException mulE = new EASMultiException((IMultiException)ve);
            throw mulE;
        }
        MftOrderCreateMaterialReqBill.saveRelation(ctx, result);
        return result;
    }

    public static SelectorItemCollection getOrderSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("transactionType.number"));
        return sic;
    }

    public static SelectorItemCollection getOrderStockSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("workcenter.costCenter.id"));
        sic.add(new SelectorItemInfo("workcenter.backWareHouse.number"));
        sic.add(new SelectorItemInfo("workcenter.backWareHouse.storageOrg.id"));
        sic.add(new SelectorItemInfo("workcenter.lineStorehouse.number"));
        sic.add(new SelectorItemInfo("workcenter.lineStorehouse.storageOrg.id"));
        sic.add(new SelectorItemInfo("workcenter.number"));
        sic.add(new SelectorItemInfo("material.assistUnit.id"));
        sic.add(new SelectorItemInfo("material.number"));
        return sic;
    }

    public static SelectorItemCollection getOrderTechnicsSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    public static void isBCP(Context ctx, MaterialReqBillEntryInfo entry, MaterialReqBillInfo req, TransactionTypeInfo tranType) throws EASBizException, BOSException {
        WarehouseInfo wi = entry.getSupplyWarehouse();
        if (wi != null) {
            String id = wi.getId().toString();
            boolean isBCP = WarehouseFactory.getLocalInstance((Context)ctx).exists("where id = '" + id + "' and warehouseGroup.name = '\u534a\u6210\u54c1\u5e93'");
            if (isBCP && (isBCP = ManufactureOrderFactory.getLocalInstance((Context)ctx).exists("where id = '" + entry.getSourceBillId() + "' and storageOrgUnit.id = 'eE7o1tUFTzyy1rUlrhAQn8znrtQ='"))) {
                req.setTransactionType(tranType);
            }
        }
    }

    public static void saveRelation(Context ctx, CoreBaseCollection reqs) throws BOSException {
        StringBuffer ids = new StringBuffer();
        int size = reqs.size();
        for (int i = 0; i < size; ++i) {
            MaterialReqBillInfo req = (MaterialReqBillInfo)reqs.get(i);
            if (req.getId() == null) continue;
            ids.append(",'").append(req.getId().toString()).append("'");
        }
        if (ids.length() == 0) {
            return;
        }
        String sql = "/*dialect*/ insert into t_bot_relation(FID, FSRCENTITYID, FDESTENTITYID, FSRCOBJECTID, FDESTOBJECTID, FDATE, FOPERATORID, FISEFFECTED, FBOTMAPPINGID, FTYPE)";
        sql = sql + " (select newbosid('59302EC6'),a.* from ";
        sql = sql + "     ( select distinct '1D0D80DD','500AB75E',fSourceBillId,fparentid,sysdate,'UnKnown',1,null,0 ";
        sql = sql + "       from t_im_materialreqbillentry where fparentid in (" + ids.substring(1) + ")";
        sql = sql + "     ) a";
        sql = sql + " )";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected static String getBotp_StockToMaterialReqBill(Context ctx, ManufactureOrderInfo orderinfo) throws BOSException, EASBizException {
        ProductTransactionTypeInfo typeinfo;
        ManufactureOrderStockCollection stockscol = orderinfo.getStocks();
        ManufactureOrderStockInfo stocksinfo = stockscol.get(0);
        if (stocksinfo.getPickType().equals((Object)PickTypeEnum.OTHERSTORAGE)) {
            typeinfo = null;
            if ("8vJD+kZuRLuQlkF2ysZ3b8znrtQ=".equals(orderinfo.getStorageOrgUnit().getId().toString())) {
                return MM_DMES01701ZXJ;
            }
            if ("eE7o1tUFTzyy1rUlrhAQn8znrtQ=".equals(orderinfo.getStorageOrgUnit().getId().toString())) {
                return null;
            }
            if (orderinfo.getTransactionType() != null) {
                typeinfo = ProductTransactionTypeFactory.getLocalInstance((Context)ctx).getProductTransactionTypeInfo((IObjectPK)new ObjectUuidPK(orderinfo.getTransactionType().getId()));
                if (typeinfo.getDeductionBFPoint().getValue() != 30) {
                    return MM_DMES01701;
                }
                return MM_DMES02101;
            }
        } else {
            typeinfo = null;
            if ("8vJD+kZuRLuQlkF2ysZ3b8znrtQ=".equals(orderinfo.getStorageOrgUnit().getId().toString())) {
                return MM_DMES017ZXJ;
            }
            if ("eE7o1tUFTzyy1rUlrhAQn8znrtQ=".equals(orderinfo.getStorageOrgUnit().getId().toString())) {
                return MM_DMES04101;
            }
            if (orderinfo.getTransactionType() != null) {
                typeinfo = ProductTransactionTypeFactory.getLocalInstance((Context)ctx).getProductTransactionTypeInfo((IObjectPK)new ObjectUuidPK(orderinfo.getTransactionType().getId()));
                if (typeinfo.getDeductionBFPoint().getValue() != 30) {
                    return MM_DMES017;
                }
                return MM_DMES021;
            }
        }
        String strInfo = ResourceBase.getString((String)RESURL, (String)"MYZDFHSCDDDZHLLCKD_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{orderinfo.getNumber()});
        throw new EASBizException(new NumericExceptionSubItem("", strInfo));
    }

    public MftOrderCreateMaterialReqBill() {
    }

    public MftOrderCreateMaterialReqBill(Context ctx) {
        this.ctx = ctx;
    }

    public void autoNumber(Context ctx, CoreBaseCollection result) throws EASBizException, BOSException {
        if (result.size() > 0) {
            AutoNumberUtil.initNumber(ctx, (IObjectCollection)result, "storageOrgUnit");
        }
    }

    public CoreBaseCollection create(Context ctx, CoreBillBaseCollection orders, String botpKey) throws EASBizException, BOSException {
        this.ctx = ctx;
        MaterialReqBillInfo req = null;
        CoreBaseCollection result = new CoreBaseCollection();
        HashMap<String, MaterialReqBillInfo> reqMap = new HashMap<String, MaterialReqBillInfo>();
        StringBuilder key = new StringBuilder();
        int size = orders.size();
        for (int i = 0; i < size; ++i) {
            ManufactureOrderInfo moi = (ManufactureOrderInfo)orders.get(i);
            int tsize = moi.getTechnics().size();
            for (int t = 0; t < tsize; ++t) {
                ManufactureOrderTechnicsInfo moti = moi.getTechnics().get(t);
                int ssize = moi.getStocks().size();
                for (int s = 0; s < ssize; ++s) {
                    ManufactureOrderStockInfo mosi = moi.getStocks().get(s);
                    if (mosi.getOperationNo() != moti.getOperationNo()) continue;
                    key.setLength(0);
                    key.append(this.getKey(ctx, botpKey, moi, mosi, moti));
                    req = reqMap.containsKey(key.toString()) ? (MaterialReqBillInfo)reqMap.get(key.toString()) : new MaterialReqBillInfo();
                    MaterialReqBillEntryInfo entry = new MaterialReqBillEntryInfo();
                    this.createByBotp(ctx, botpKey, req, entry, moi, mosi, moti);
                    req.getEntry().add(entry);
                    if (reqMap.containsValue(req)) continue;
                    reqMap.put(key.toString(), req);
                    result.add((CoreBaseInfo)req);
                }
            }
        }
        return result;
    }

    public CoreBaseCollection createMaterialReqbill(Context ctx, CoreBillBaseCollection orders) throws EASBizException, BOSException {
        IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
        this.ctx = ctx;
        CoreBaseCollection result = new CoreBaseCollection();
        HashMap<BOTMappingInfo, CoreBillBaseCollection> ruleNumberBotp = new HashMap<BOTMappingInfo, CoreBillBaseCollection>();
        BTPTransformResult btpresult = new BTPTransformResult();
        int size = orders.size();
        for (int i = 0; i < size; ++i) {
            ManufactureOrderInfo moi = (ManufactureOrderInfo)orders.get(i);
            String storageOrgUnitId = moi.getStorageOrgUnit().getId().toString();
            int tsize = moi.getTechnics().size();
            for (int t = 0; t < tsize; ++t) {
                ManufactureOrderTechnicsInfo moti = moi.getTechnics().get(t);
                int ssize = moi.getStocks().size();
                for (int s = 0; s < ssize; ++s) {
                    ManufactureOrderStockInfo mosi = moi.getStocks().get(s);
                    if (mosi.getOperationNo() != moti.getOperationNo()) continue;
                    BOTMappingInfo btpInfo = this.getBOTPRuleFromWIPTransferRule(ctx, storageOrgUnitId, mosi);
                    if (ruleNumberBotp.get(btpInfo) == null) {
                        ManufactureOrderStockCollection stocks = new ManufactureOrderStockCollection();
                        CoreBillBaseCollection returnCoreBillBaseCollection = new CoreBillBaseCollection();
                        ManufactureOrderInfo moiCopy = (ManufactureOrderInfo)moi.clone();
                        stocks.add(mosi);
                        moiCopy.put("stocks", (Object)stocks);
                        returnCoreBillBaseCollection.add((CoreBillBaseInfo)moiCopy);
                        ruleNumberBotp.put(btpInfo, returnCoreBillBaseCollection);
                        continue;
                    }
                    ManufactureOrderInfo orderinfo = (ManufactureOrderInfo)((CoreBillBaseCollection)ruleNumberBotp.get(btpInfo)).get(0);
                    orderinfo.getStocks().add(mosi);
                }
            }
        }
        for (Map.Entry obj : ruleNumberBotp.entrySet()) {
            BOTMappingInfo btpInfo = (BOTMappingInfo)obj.getKey();
            CoreBillBaseCollection returnCoreBillBaseCollection = (CoreBillBaseCollection)obj.getValue();
            if (returnCoreBillBaseCollection == null || returnCoreBillBaseCollection.size() <= 0) continue;
            btpresult = btp.transform(returnCoreBillBaseCollection, btpInfo);
        }
        for (int i = 0; i < btpresult.getBills().size(); ++i) {
            result.add((CoreBaseInfo)btpresult.getBills().getObject(i));
        }
        return result;
    }

    public void create(Context ctx, MaterialReqBillInfo req, MaterialReqBillEntryInfo entry, ManufactureOrderInfo order, ManufactureOrderStockInfo stock, ManufactureOrderTechnicsInfo technics) throws EASBizException, BOSException {
        WorkCenterInfo wcinfo;
        BigDecimal unIssueQty;
        String mosID;
        CompanyOrgUnitInfo currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        entry.setCompanyOrgUnit(currentCompany);
        entry.setCoreBillEntryID(stock.getId().toString());
        entry.setCoreBillEntrySe(stock.getSeq());
        entry.setCoreBillID(order.getId().toString());
        entry.setSourceBillEntrySeq(stock.getSourceBillEntrySeq());
        Boolean isFromECM = order == null ? false : (order.containsKey("isFromECM") ? (order.get("isFromECM") == null ? false : (order.get("isFromECM") instanceof Boolean ? (Boolean)order.get("isFromECM") : false)) : false);
        String string = stock == null ? null : (mosID = stock.getId() == null ? null : stock.getId().toString());
        BigDecimal bigDecimal = stock == null ? BigDecimal.ZERO : (unIssueQty = stock.getUnIssueQty() == null ? BigDecimal.ZERO : stock.getUnIssueQty());
        BigDecimal unIssueBaseQty = stock == null ? BigDecimal.ZERO : (stock.getUnIssueBaseQty() == null ? BigDecimal.ZERO : stock.getUnIssueBaseQty());
        try {
            if (isFromECM.booleanValue() && mosID != null && mosID.trim().length() > 0) {
                BigDecimal bigDecimal2 = stock == null ? BigDecimal.ZERO : (unIssueQty = stock.getQty() == null ? BigDecimal.ZERO : stock.getQty());
                unIssueBaseQty = stock == null ? BigDecimal.ZERO : (stock.getBaseQty() == null ? BigDecimal.ZERO : stock.getBaseQty());
                StringBuffer sql = new StringBuffer();
                sql.setLength(0);
                sql.append("Select\r\n");
                sql.append("Sum(MRBE.FQty) FIssueQty\r\n");
                sql.append("From T_IM_MaterialReqBillEntry MRBE\r\n");
                sql.append("Inner Join T_IM_MaterialReqBill MRB On MRB.FID=MRBE.FParentID\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And MRBE.FSourceBillEntryID='").append(mosID).append("'\r\n");
                IRowSet issueQtyRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                issueQtyRowSet.next();
                BigDecimal issueQty = issueQtyRowSet.getBigDecimal("FIssueQty") == null ? BigDecimal.ZERO : issueQtyRowSet.getBigDecimal("FIssueQty");
                unIssueQty = unIssueQty.subtract(issueQty);
                unIssueBaseQty = unIssueBaseQty.subtract(issueQty);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        entry.setBaseQty(unIssueBaseQty);
        entry.setQty(unIssueQty);
        entry.setCoreBillNumber(order.getNumber());
        entry.setCoreBillType(order.getBillType());
        entry.setCostObject(order.getCostObject());
        entry.setDemandDate(stock.getDemandTime());
        entry.setLocation(stock.getLocation());
        entry.setProject(order.getProject());
        entry.setSourceBillEntryId(stock.getId().toString());
        entry.setSourceBillId(order.getId().toString());
        entry.put("projectjch", (Object)order.getProjectJCH());
        entry.setStorageOrgUnit(order.getStorageOrgUnit());
        entry.setSupplyLocation(stock.getLocation());
        entry.setSupplyWarehouse(stock.getWarehouse());
        entry.setTrackNumber(order.getTrackNumber());
        entry.setWarehouse(stock.getWarehouse());
        entry.setWorkCenter(stock.getWorkcenter());
        entry.setOperationNo(stock.getOperationNo());
        entry.put("actureQty", (Object)unIssueQty);
        entry.setBaseIssueQty(unIssueBaseQty);
        entry.setIssueQty(unIssueQty);
        if (stock.getMaterial() != null) {
            entry.setAssistUnit(stock.getMaterial().getAssistUnit());
        }
        entry.setBaseUnit(stock.getBaseUnit());
        entry.setMaterial(stock.getMaterial());
        entry.setOperation(stock.getOperation());
        entry.setOrderNumber(order.getNumber());
        entry.setPoBillEntryID(order.getSrcBillEntryID());
        entry.setSourceBillNumber(order.getNumber());
        entry.setUnit(stock.getUnit());
        if (stock.getActIssueQty() == null) {
            entry.setAssociateQty(stock.getPlannedQty());
        } else {
            entry.setAssociateQty(stock.getPlannedQty().subtract(stock.getActIssueQty()));
        }
        entry.setSourceBillType(order.getBillType());
        entry.put("isBackFlush", (Object)stock.isIsBackflush());
        if (stock.getWorkcenter() != null) {
            entry.put("backFlushWareHouse", stock.getWorkcenter().get("backWareHouse"));
        }
        entry.put("reqRemark", (Object)stock.getString("reqRemark"));
        if (stock.getWorkcenter() != null && (wcinfo = WorkCenterFactory.getLocalInstance((Context)ctx).getWorkCenterInfo((IObjectPK)new ObjectUuidPK(stock.getWorkcenter().getId()))).getCostCenter() != null) {
            CostCenterOrgUnitInfo ccInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(wcinfo.getCostCenter().getId()));
            entry.setCostCenterOrgUnit(ccInfo);
        }
        TransactionTypeInfo tranTypeinfo = new TransactionTypeInfo();
        if (req.getTransactionType() == null) {
            tranTypeinfo.setId(BOSUuid.read((String)"vd9rwnnBQc6LRgyfRruUGLAI3Kc="));
            tranTypeinfo.setNumber("442");
            tranTypeinfo.setName(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0394", (Locale)ctx.getLocale()));
        } else {
            tranTypeinfo = req.getTransactionType();
        }
        entry.setInvUpdateType(TransactionTypeUtils.getInvUpdateTypeServer((Context)ctx, (TransactionTypeInfo)tranTypeinfo));
        if (req.getBizDate() == null) {
            BillTypeInfo billType;
            CompanyOrgUnitInfo company = this.getCompanyOrgUnit(ctx, (OrgUnitInfo)stock.getStorageOrgUnit());
            req.setSupplyCompanyOrgUnit(company);
            req.setDemandCompanyOrgUnit(company);
            if (req.getSupplyStoreOrgUnit() == null) {
                req.setSupplyStoreOrgUnit(stock.getStorageOrgUnit());
            }
            req.put("sourcbillnumber", (Object)order.getNumber());
            req.put("endWorkNum", (Object)order.getTrackNumber());
            req.put("startWorkNum", (Object)order.getTrackNumber());
            if (req.getStorageOrgUnit() == null) {
                req.setStorageOrgUnit(stock.getStorageOrgUnit());
            }
            req.setAdminOrgUnit(order.getAdminOrgUnit());
            Date bizDate = this.getBizDate(ctx, currentCompany);
            req.setBizDate(bizDate);
            req.setSourceBillId(order.getId().toString());
            if (req.getTransactionType() == null) {
                TransactionTypeInfo tranType = new TransactionTypeInfo();
                tranType.setId(BOSUuid.read((String)"vd9rwnnBQc6LRgyfRruUGLAI3Kc="));
                tranType.setNumber("442");
                tranType.setName(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0394", (Locale)ctx.getLocale()));
                req.setTransactionType(tranType);
            }
            if (req.getBizType() == null) {
                BizTypeInfo bizType = new BizTypeInfo();
                bizType.setId(BOSUuid.read((String)"0rSFjAEeEADgAAyMwKgSQiQHQ1w="));
                bizType.setName(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0411", (Locale)ctx.getLocale()));
                bizType.setNumber("340");
                req.setBizType(bizType);
            }
            if (req.getBillType() == null) {
                billType = new BillTypeInfo();
                billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0163c0a812fd463ED552"));
                billType.setNumber("104");
                billType.setName(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0395", (Locale)ctx.getLocale()));
                req.setBillType(billType);
            }
            if (req.getSourceBillType() == null) {
                billType = new BillTypeInfo();
                billType.setId(BOSUuid.read((String)"B2aZSVXaSx6qxdfekgCmrEY+1VI="));
                billType.setNumber("670");
                billType.setName(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0095", (Locale)ctx.getLocale()));
                req.setSourceBillType(billType);
            }
            if (stock.getWorkcenter() != null) {
                req.setCostCenterOrgUnit(stock.getWorkcenter().getCostCenter());
            }
            req.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            PeriodInfo period = this.getPeriodInfo(ctx, currentCompany);
            req.setPeriod(period.getPeriodNumber());
            req.setYear(period.getPeriodYear());
            req.setMonth(period.getNumber());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            req.setDay(Integer.parseInt(sdf.format(req.getBizDate())));
        }
        if (stock.getMaterial() != null) {
            entry.put("materialNumber", (Object)stock.getMaterial().getNumber());
        }
        entry.setBizDate(req.getBizDate());
        if (req.getCostCenterOrgUnit() != null) {
            entry.setCostCenterOrgUnit(req.getCostCenterOrgUnit());
        }
        entry.setStorageOrgUnit(req.getStorageOrgUnit());
        entry.put("gongWei", technics.get("gongWei"));
    }

    public void createByBotp(Context ctx, String botpKey, MaterialReqBillInfo req, MaterialReqBillEntryInfo entry, ManufactureOrderInfo order, ManufactureOrderStockInfo stock, ManufactureOrderTechnicsInfo technics) throws EASBizException, BOSException {
        if (MM_DMES01701.equals(botpKey)) {
            this.createByMM_DMES01701(ctx, req, entry, order, stock, technics);
        } else if (MM_DMES02101.equals(botpKey)) {
            this.createByMM_DMES02101(ctx, req, entry, order, stock, technics);
        } else if (MM_DMES017.equals(botpKey)) {
            this.createByMM_DMES017(ctx, req, entry, order, stock, technics);
        } else if (MM_DMES021.equals(botpKey)) {
            this.createByMM_DMES021(ctx, req, entry, order, stock, technics);
        } else if (MM_DMES01701ZXJ.equals(botpKey)) {
            this.createByMM_DMES01701ZXJ(ctx, req, entry, order, stock, technics);
        } else if (MM_DMES017ZXJ.equals(botpKey)) {
            this.createByMM_DMES017ZXJ(ctx, req, entry, order, stock, technics);
        } else if (MM_DMES04101.equals(botpKey)) {
            this.createByMM_DMES04101(ctx, req, entry, order, stock, technics);
        } else if ("MM_DMES01910".equals(botpKey)) {
            this.createByMM_DMES01910(ctx, req, entry, order, stock, technics);
        } else if ("MM_DMES01920".equals(botpKey)) {
            this.createByMM_DMES01920(ctx, req, entry, order, stock, technics);
        } else {
            this.create(ctx, req, entry, order, stock, technics);
        }
    }

    public void createByMM_DMES017(Context ctx, MaterialReqBillInfo req, MaterialReqBillEntryInfo entry, ManufactureOrderInfo order, ManufactureOrderStockInfo stock, ManufactureOrderTechnicsInfo technics) throws EASBizException, BOSException {
        req.setStorageOrgUnit(order.getStorageOrgUnit());
        req.setSupplyStoreOrgUnit(order.getStorageOrgUnit());
        this.create(ctx, req, entry, order, stock, technics);
    }

    public void createByMM_DMES01701(Context ctx, MaterialReqBillInfo req, MaterialReqBillEntryInfo entry, ManufactureOrderInfo order, ManufactureOrderStockInfo stock, ManufactureOrderTechnicsInfo technics) throws EASBizException, BOSException {
        this.create(ctx, req, entry, order, stock, technics);
    }

    public void createByMM_DMES01701ZXJ(Context ctx, MaterialReqBillInfo req, MaterialReqBillEntryInfo entry, ManufactureOrderInfo order, ManufactureOrderStockInfo stock, ManufactureOrderTechnicsInfo technics) throws EASBizException, BOSException {
        String ttnumber;
        TransactionTypeInfo tranType = null;
        tranType = order.getTransactionType() != null ? ("BPBJ".equals(ttnumber = order.getTransactionType().getNumber()) ? this.getTransactionType(ctx, "40602") : ("DX".equals(ttnumber) ? this.getTransactionType(ctx, "40603") : ("LYPJ".equals(ttnumber) ? this.getTransactionType(ctx, "40605") : this.getTransactionType(ctx, "44202")))) : this.getTransactionType(ctx, "44202");
        req.setTransactionType(tranType);
        this.create(ctx, req, entry, order, stock, technics);
    }

    public void createByMM_DMES017ZXJ(Context ctx, MaterialReqBillInfo req, MaterialReqBillEntryInfo entry, ManufactureOrderInfo order, ManufactureOrderStockInfo stock, ManufactureOrderTechnicsInfo technics) throws EASBizException, BOSException {
        req.setStorageOrgUnit(order.getStorageOrgUnit());
        req.setSupplyStoreOrgUnit(order.getStorageOrgUnit());
        this.createByMM_DMES01701ZXJ(ctx, req, entry, order, stock, technics);
    }

    public void createByMM_DMES01910(Context ctx, MaterialReqBillInfo req, MaterialReqBillEntryInfo entry, ManufactureOrderInfo order, ManufactureOrderStockInfo stock, ManufactureOrderTechnicsInfo technics) throws EASBizException, BOSException {
        req.setStorageOrgUnit(order.getStorageOrgUnit());
        req.setSupplyStoreOrgUnit(order.getStorageOrgUnit());
        this.create(ctx, req, entry, order, stock, technics);
        WarehouseInfo wi = null;
        if (stock.getWorkcenter() != null) {
            wi = (WarehouseInfo)stock.getWorkcenter().get("backWareHouse");
        }
        entry.setWarehouse(wi);
        entry.setSupplyWarehouse(wi);
        entry.setLocation(null);
        entry.setSupplyLocation(null);
        entry.setStorageOrgUnit(wi.getStorageOrg());
    }

    public void createByMM_DMES01920(Context ctx, MaterialReqBillInfo req, MaterialReqBillEntryInfo entry, ManufactureOrderInfo order, ManufactureOrderStockInfo stock, ManufactureOrderTechnicsInfo technics) throws EASBizException, BOSException {
        req.setStorageOrgUnit(order.getStorageOrgUnit());
        req.setSupplyStoreOrgUnit(order.getStorageOrgUnit());
        this.create(ctx, req, entry, order, stock, technics);
        WarehouseInfo wi = null;
        if (stock.getWorkcenter() != null) {
            wi = (WarehouseInfo)stock.getWorkcenter().get("lineStorehouse");
        }
        entry.setWarehouse(wi);
        entry.setSupplyWarehouse(wi);
        entry.setLocation(null);
        entry.setSupplyLocation(null);
        entry.setStorageOrgUnit(wi.getStorageOrg());
    }

    public void createByMM_DMES021(Context ctx, MaterialReqBillInfo req, MaterialReqBillEntryInfo entry, ManufactureOrderInfo order, ManufactureOrderStockInfo stock, ManufactureOrderTechnicsInfo technics) throws EASBizException, BOSException {
        req.setStorageOrgUnit(order.getStorageOrgUnit());
        req.setSupplyStoreOrgUnit(order.getStorageOrgUnit());
        this.create(ctx, req, entry, order, stock, technics);
    }

    public void createByMM_DMES02101(Context ctx, MaterialReqBillInfo req, MaterialReqBillEntryInfo entry, ManufactureOrderInfo order, ManufactureOrderStockInfo stock, ManufactureOrderTechnicsInfo technics) throws EASBizException, BOSException {
        this.create(ctx, req, entry, order, stock, technics);
    }

    public void createByMM_DMES04101(Context ctx, MaterialReqBillInfo req, MaterialReqBillEntryInfo entry, ManufactureOrderInfo order, ManufactureOrderStockInfo stock, ManufactureOrderTechnicsInfo technics) throws EASBizException, BOSException {
        req.setStorageOrgUnit(order.getStorageOrgUnit());
        req.setSupplyStoreOrgUnit(order.getStorageOrgUnit());
        this.create(ctx, req, entry, order, stock, technics);
    }

    public Date getBizDate(Context ctx, CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        Date bizDate;
        String key = currentCompany.getId().toString();
        if (this.isClose.containsKey(key)) {
            return (Date)this.isClose.get(key);
        }
        boolean isShuted = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
        Date now = new Date();
        if (isShuted) {
            PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
            bizDate = currentPeriod.getEndDate();
            if ((bizDate = new Date(bizDate.getTime() + 86400000L)).before(now)) {
                bizDate = now;
            }
        } else {
            bizDate = now;
        }
        this.isClose.put(key, bizDate);
        return bizDate;
    }

    public CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, OrgUnitInfo org) throws EASBizException, BOSException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(org.getId().toString(), 4, 1);
        if (orgCol.size() > 0) {
            return (CompanyOrgUnitInfo)orgCol.get(0);
        }
        String strInfo = ResourceBase.getString((String)RESURL, (String)"DQCGZZBHWWHJZWTZZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{org.getName(), org.getNumber()});
        NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", strInfo);
        throw new InterfaceDataBaseException(interfaceException);
    }

    public String getKey(Context ctx, String botpKey, ManufactureOrderInfo moi, ManufactureOrderStockInfo mosi, ManufactureOrderTechnicsInfo moti) {
        this.key.setLength(0);
        if (mosi.getWarehouse() == null || MM_DMES04101.equals(botpKey)) {
            this.key.append(mosi.getId().toString());
        } else {
            if (mosi.getWarehouse() != null) {
                this.key.append(mosi.getWarehouse().getId().toString());
            }
            this.key.append("-");
            if (mosi.getOperation() != null) {
                this.key.append(mosi.getOperation().getId().toString());
            }
            this.key.append("-");
            if (mosi.getStorageOrgUnit() != null) {
                this.key.append(mosi.getStorageOrgUnit().getId().toString());
            }
            this.key.append("-");
            if (mosi.getWorkcenter() != null) {
                this.key.append(mosi.getWorkcenter().getId().toString());
            }
        }
        return this.key.toString();
    }

    public PeriodInfo getPeriodInfo(Context ctx, CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        String key = currentCompany.getId().toString();
        if (this.periods.containsKey(key)) {
            return (PeriodInfo)this.periods.get(key);
        }
        Date bizDate = this.getBizDate(ctx, currentCompany);
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bizDate, (CompanyOrgUnitInfo)currentCompany);
        this.periods.put(key, periodInfo);
        return periodInfo;
    }

    public TransactionTypeInfo getTransactionType(Context ctx, String number) throws BOSException, EASBizException {
        if (this.ttMap.containsKey(number)) {
            return (TransactionTypeInfo)this.ttMap.get(number);
        }
        TransactionTypeInfo tranType = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo("select number where number = '" + number + "'");
        this.ttMap.put(number, tranType);
        return tranType;
    }

    protected BOTMappingInfo getBOTPRuleFromWIPTransferRule(Context ctx, String storageOrgUnitId, ManufactureOrderStockInfo stockInfo) throws BOSException, EASBizException {
        BOTMappingInfo btpinfo;
        WorkCenterInfo wcInfo = stockInfo.getWorkcenter();
        FilterItemInfo wcFilterItem = new FilterItemInfo();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        IWIPTransferRule iTransferRule = WIPTransferRuleFactory.getLocalInstance(ctx);
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)20, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        if (wcInfo != null) {
            wcFilterItem = new FilterItemInfo("workCenter.id", (Object)wcInfo.getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(wcFilterItem);
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("workCenter is null"));
        }
        evi.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        WIPTransferRuleCollection ruleColl = iTransferRule.getWIPTransferRuleCollection(evi);
        if (ruleColl == null || ruleColl.size() < 1) {
            if (filterInfo.getFilterItems().contains(wcFilterItem)) {
                filterInfo.getFilterItems().remove(wcFilterItem);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("workCenter is null"));
            ruleColl = iTransferRule.getWIPTransferRuleCollection(evi);
            if (ruleColl == null || ruleColl.size() < 1) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0402", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0403", (Locale)ctx.getLocale())));
            }
        }
        if ((btpinfo = ruleColl.get(0).getTansferRule()) != null) {
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("rules.*"));
            sic.add(new SelectorItemInfo("revRule.*"));
            sic.add(new SelectorItemInfo("extRule.*"));
            btpinfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK(btpinfo.getId()), sic);
        }
        return btpinfo;
    }

    protected CoreBaseCollection create(CoreBillBaseCollection orders) throws EASBizException, BOSException {
        MaterialReqBillInfo req = null;
        CoreBaseCollection result = new CoreBaseCollection();
        HashMap<String, MaterialReqBillInfo> reqMap = new HashMap<String, MaterialReqBillInfo>();
        StringBuilder key = new StringBuilder();
        int size = orders.size();
        for (int i = 0; i < size; ++i) {
            ManufactureOrderInfo moi = (ManufactureOrderInfo)orders.get(i);
            String botpKey = MftOrderCreateMaterialReqBill.getBotp_StockToMaterialReqBill(this.ctx, moi);
            int tsize = moi.getTechnics().size();
            for (int t = 0; t < tsize; ++t) {
                ManufactureOrderTechnicsInfo moti = moi.getTechnics().get(t);
                int ssize = moi.getStocks().size();
                for (int s = 0; s < ssize; ++s) {
                    ManufactureOrderStockInfo mosi = moi.getStocks().get(s);
                    if (mosi.getOperationNo() != moti.getOperationNo()) continue;
                    key.setLength(0);
                    key.append(this.getKey(this.ctx, botpKey, moi, mosi, moti));
                    if (reqMap.containsKey(key.toString())) {
                        req = (MaterialReqBillInfo)reqMap.get(key.toString());
                    } else {
                        req = new MaterialReqBillInfo();
                        req.setId(BOSUuid.create((String)"500AB75E"));
                    }
                    MaterialReqBillEntryInfo entry = new MaterialReqBillEntryInfo();
                    entry.setId(BOSUuid.create((String)"11774BB4"));
                    this.createByBotp(this.ctx, botpKey, req, entry, moi, mosi, moti);
                    if (mosi.get("gongwei") != null) {
                        entry.put("gongwei", mosi.get("gongwei"));
                    }
                    req.getEntry().add(entry);
                    if (reqMap.containsValue(req)) continue;
                    reqMap.put(key.toString(), req);
                    result.add((CoreBaseInfo)req);
                }
            }
        }
        return result;
    }
}

