/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.mo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.mm.mo.AbstractStockTransferPlanComputingPlatformFacadeControllerBean;
import com.kingdee.eas.industry.emm.mm.mo.AbstractStockTransferPlanInfo;
import com.kingdee.eas.industry.emm.mm.mo.MoveStatusEnum;
import com.kingdee.eas.industry.emm.mm.mo.StockTransferPlanDetial;
import com.kingdee.eas.industry.emm.mm.mo.StockTransferPlanDetialFactory;
import com.kingdee.eas.industry.emm.mm.mo.StockTransferPlanDetialInfo;
import com.kingdee.eas.industry.emm.mm.mo.StockTransferPlanFactory;
import com.kingdee.eas.industry.emm.mm.mo.StockTransferPlanInfo;
import com.kingdee.eas.industry.emm.mo.EMMManufactureOrderEntrysGenFacadeFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class StockTransferPlanComputingPlatformFacadeControllerBean
extends AbstractStockTransferPlanComputingPlatformFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.mm.mo.StockTransferPlanComputingPlatformFacadeControllerBean");

    @Override
    protected void _stockDataCaculate(Context ctx, Map param) throws BOSException, EASBizException {
        List idList = (List)param.get("idList");
        Boolean reCalStock = (Boolean)param.get("reCalStock");
        ArrayList stockIdList = new ArrayList();
        ArrayList<String> technicsIdList = new ArrayList<String>();
        for (int i = 0; i < idList.size(); ++i) {
            if (stockIdList.contains(idList.get(i))) continue;
            stockIdList.add(idList.get(i));
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> stockFilterIdList = new ArrayList<String>();
        try {
            if (reCalStock.booleanValue()) {
                sql.setLength(0);
                sql.append("select distinct mt.fid fid \r\n");
                sql.append("from T_MM_MFTOrderStock STOCKS\r\n");
                sql.append(" Inner Join t_mm_mftordertechnics mt on mt.fparentid = STOCKS.fparentid and mt.foperationno = STOCKS.foperationno \r\n");
                sql.append("where STOCKS.FID in(\r\n");
                sql.append(SQLUtil.arrayToString((Object[])stockIdList.toArray())).append("\r\n");
                sql.append(")\r\n");
                IRowSet ros = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (ros.next()) {
                    String technicsId = ros.getString("fid") == null ? "" : ros.getString("fid");
                    if (technicsId == "" || technicsIdList.contains(technicsId)) continue;
                    technicsIdList.add(technicsId);
                }
                EMMManufactureOrderEntrysGenFacadeFactory.getLocalInstance((Context)ctx).genStocksEntrysByTechID(technicsIdList);
            }
            sql.setLength(0);
            sql.append("select STOCKS.fid fid\r\n");
            sql.append("from T_MM_MFTOrderStock STOCKS\r\n");
            sql.append("where STOCKS.FID in(\r\n");
            sql.append(SQLUtil.arrayToString((Object[])stockIdList.toArray())).append("\r\n");
            sql.append(")\r\n");
            sql.append("And (IsNull(STOCKS.FPickType,0)=\r\n");
            sql.append(3);
            sql.append(" or IsNull(STOCKS.FProvideType,0)=\r\n");
            sql.append(10920);
            sql.append(")\r\n");
            sql.append("And IsNull(STOCKS.FQty,0)!=0\r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String stockId = rs.getString("fid") == null ? "" : rs.getString("fid");
                if (stockId == "" || stockFilterIdList.contains(stockId)) continue;
                stockFilterIdList.add(stockId);
            }
            if (ctx == null || stockFilterIdList == null || stockFilterIdList.isEmpty()) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0412", (Locale)ctx.getLocale())));
            }
            if (stockFilterIdList.size() == 0) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0412", (Locale)ctx.getLocale())));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0413", (Locale)ctx.getLocale())));
        }
        this.addNewStockTransfer(ctx, stockFilterIdList);
    }

    @Override
    protected void _technicsDataCalculate(Context ctx, Map param) throws BOSException, EASBizException {
        List idList = (List)param.get("idList");
        Boolean reCalStock = (Boolean)param.get("reCalStock");
        Boolean isMerge = (Boolean)param.get("isMerge");
        StringBuffer sql = new StringBuffer();
        ArrayList<String> technicsIdList = new ArrayList<String>();
        if (isMerge.booleanValue()) {
            sql.setLength(0);
            sql.append("select fid from T_MM_MFTOrderTechnics where FMergeID\u3000in(\r\n");
            sql.append(SQLUtil.arrayToString((Object[])idList.toArray())).append("\r\n");
            sql.append(")\r\n");
            IRowSet ros = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (ros.next()) {
                    String technicsId = ros.getString("fid") == null ? "" : ros.getString("fid");
                    if (technicsId == "" || technicsIdList.contains(technicsId)) continue;
                    technicsIdList.add(technicsId);
                }
            }
            catch (SQLException e) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0414", (Locale)ctx.getLocale())));
            }
        } else {
            for (int i = 0; i < idList.size(); ++i) {
                if (technicsIdList.contains(idList.get(i))) continue;
                technicsIdList.add((String)idList.get(i));
            }
        }
        ArrayList<String> stockIdList = new ArrayList<String>();
        try {
            sql.setLength(0);
            sql.append("select STOCKS.fid fid\r\n");
            sql.append("from T_MM_ManufactureOrder MANUFACTUREORDER\r\n");
            sql.append("LEFT OUTER JOIN T_MM_MFTOrderStock STOCKS ON MANUFACTUREORDER.FID = STOCKS.FParentID\r\n");
            sql.append("LEFT OUTER JOIN T_MM_MFTOrderTechnics TECHNICS ON MANUFACTUREORDER.FID = TECHNICS.FParentID\r\n");
            sql.append("WHERE TECHNICS.FOperationNo=STOCKS.FOperationNo and TECHNICS.fid in(\r\n");
            sql.append(SQLUtil.arrayToString((Object[])technicsIdList.toArray())).append("\r\n");
            sql.append(")\r\n");
            sql.append("And (IsNull(STOCKS.FPickType,0)=\r\n");
            sql.append(3);
            sql.append(" or IsNull(STOCKS.FProvideType,0)=\r\n");
            sql.append(10920);
            sql.append(")\r\n");
            sql.append("And MANUFACTUREORDER.FBaseStatus not in (1,2)\r\n");
            sql.append("And IsNull(STOCKS.FQty,0)!=0\r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String stockId = rs.getString("fid") == null ? "" : rs.getString("fid");
                if (stockId == "" || stockIdList.contains(stockId)) continue;
                stockIdList.add(stockId);
            }
            if (stockIdList == null || stockIdList.isEmpty()) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0415", (Locale)ctx.getLocale())));
            }
            if (stockIdList.size() == 0) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0415", (Locale)ctx.getLocale())));
            }
            if (reCalStock.booleanValue()) {
                EMMManufactureOrderEntrysGenFacadeFactory.getLocalInstance((Context)ctx).genStocksEntrysByTechID(technicsIdList);
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0416", (Locale)ctx.getLocale())));
        }
        this.addNewStockTransfer(ctx, stockIdList);
    }

    @Override
    protected void _insertDataCaculate(Context ctx, Map param) throws BOSException, EASBizException {
        StorageOrgUnitInfo productOrgUnit = (StorageOrgUnitInfo)param.get("ProductOrgUnit");
        ProjectInfo projectNo = (ProjectInfo)param.get("ProjectNo");
        TrackNumberInfo beginTrackNo = (TrackNumberInfo)param.get("BeginTrackNo");
        TrackNumberInfo endTrackNo = (TrackNumberInfo)param.get("EndTrackNo");
        Date planBeginDate = (Date)param.get("PlanBeginDate");
        Date planEndDate = (Date)param.get("PlanEndDate");
        Boolean reCalStock = (Boolean)param.get("reCalStock");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sql = new StringBuffer();
        ArrayList<String> stockIdList = new ArrayList<String>();
        ArrayList<String> technicsIdList = new ArrayList<String>();
        try {
            if (reCalStock.booleanValue()) {
                sql.setLength(0);
                sql.append("select distinct mt.fid fid from T_MM_ManufactureOrder MANUFACTUREORDER \r\n");
                sql.append(" Inner Join t_mm_mftordertechnics mt on mt.fparentid = MANUFACTUREORDER.fid \r\n");
                sql.append("left outer JOIN T_MM_TrackNumber TRACKNUMBER ON MANUFACTUREORDER.FTrackID = TRACKNUMBER.FID\r\n");
                sql.append("where MANUFACTUREORDER.FProjectID = '").append(projectNo.getId().toString() + "'\r\n");
                sql.append("and MANUFACTUREORDER.FStorageOrgUnitID = '").append(productOrgUnit.getId().toString() + "'\r\n");
                sql.append("and MANUFACTUREORDER.FBaseStatus not in (1,2)\r\n");
                if (beginTrackNo != null) {
                    sql.append("and TRACKNUMBER.Fnumber >= '").append(beginTrackNo.getNumber() + "'\r\n");
                }
                if (endTrackNo != null) {
                    sql.append("and TRACKNUMBER.Fnumber <= '").append(endTrackNo.getNumber() + "'\r\n");
                }
                if (planBeginDate != null) {
                    sql.append("and MANUFACTUREORDER.FPlanBeginDate >= to_date('" + sdf.format(planBeginDate) + " 00:00:00')\r\n");
                }
                if (planEndDate != null) {
                    sql.append("and MANUFACTUREORDER.FPlanBeginDate <= to_date('" + sdf.format(planEndDate) + " 23:59:59')\r\n");
                }
                IRowSet ros = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (ros.next()) {
                    String ftechid = ros.getString("fid") == null ? "" : ros.getString("fid");
                    if (ftechid.equals("") || technicsIdList.contains(ftechid)) continue;
                    technicsIdList.add(ftechid);
                }
                EMMManufactureOrderEntrysGenFacadeFactory.getLocalInstance((Context)ctx).genStocksEntrysByTechID(technicsIdList);
            }
            sql.setLength(0);
            sql.append("select STOCKS.fid fid from T_MM_MFTOrderStock STOCKS\r\n");
            sql.append("inner JOIN T_MM_ManufactureOrder MANUFACTUREORDER ON MANUFACTUREORDER.FID = STOCKS.FParentID\r\n");
            sql.append("INNER JOIN T_MM_TrackNumber TRACKNUMBER ON MANUFACTUREORDER.FTrackID = TRACKNUMBER.FID\r\n");
            sql.append("where MANUFACTUREORDER.FProjectID = '").append(projectNo.getId().toString() + "'\r\n");
            sql.append("and MANUFACTUREORDER.FStorageOrgUnitID = '").append(productOrgUnit.getId().toString() + "'\r\n");
            sql.append("and MANUFACTUREORDER.FBaseStatus not in (1,2)\r\n");
            if (beginTrackNo != null) {
                sql.append("and TRACKNUMBER.Fnumber >= '").append(beginTrackNo.getNumber() + "'\r\n");
            }
            if (endTrackNo != null) {
                sql.append("and TRACKNUMBER.Fnumber <= '").append(endTrackNo.getNumber() + "'\r\n");
            }
            if (planBeginDate != null) {
                sql.append("and MANUFACTUREORDER.FPlanBeginDate >= to_date('" + sdf.format(planBeginDate) + " 00:00:00')\r\n");
            }
            if (planEndDate != null) {
                sql.append("and MANUFACTUREORDER.FPlanBeginDate <= to_date('" + sdf.format(planEndDate) + " 23:59:59')\r\n");
            }
            sql.append("and ((IsNull(STOCKS.FPickType,0)=\r\n");
            sql.append(3);
            sql.append(") or (IsNull(STOCKS.FProvideType,0)=\r\n");
            sql.append(10920);
            sql.append("))\r\n");
            sql.append("And IsNull(STOCKS.FQty,0)!=0\r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String stockId = rs.getString("fid") == null ? "" : rs.getString("fid");
                if (stockId == "" || stockIdList.contains(stockId)) continue;
                stockIdList.add(stockId);
            }
            if (stockIdList == null || stockIdList.isEmpty()) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0415", (Locale)ctx.getLocale())));
            }
            if (stockIdList.size() == 0) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0415", (Locale)ctx.getLocale())));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0417", (Locale)ctx.getLocale())));
        }
        this.addNewStockTransfer(ctx, stockIdList);
    }

    private void addNewStockTransfer(Context ctx, List idList) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select S.fid fid,D.CFIsZj CFIsZj from CT_DIR_DirectFeedingmMaterial D\r\n");
        sql.append("inner JOIN T_MM_MFTOrderStock S ON S.FMaterialID = D.CFMaterialID\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MANU On MANU.FID = S.FParentID\r\n");
        sql.append("where MANU.FProjectID = isnull(D.CFProjectID,MANU.FProjectID) \r\n");
        sql.append("and MANU.FTrackID = isnull(D.CFTrackID,MANU.FTrackID)\r\n");
        sql.append("and D.CFStatus = 1 and S.fid in(\r\n");
        sql.append(SQLUtil.arrayToString((Object[])idList.toArray())).append("\r\n");
        sql.append(")\r\n");
        IRowSet rss = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> removeList = new ArrayList<String>();
        try {
            while (rss.next()) {
                String id;
                String string = id = rss.getString("fid") == null ? "" : rss.getString("fid");
                int isZj = rss.getInt("CFIsZj");
                if (isZj != 1) continue;
                removeList.add(id);
            }
            if (!removeList.isEmpty()) {
                idList.removeAll(removeList);
            }
        }
        catch (SQLException e1) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0418", (Locale)ctx.getLocale())));
        }
        if (ctx == null || idList == null || idList.isEmpty()) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0419", (Locale)ctx.getLocale())));
        }
        if (idList.size() == 0) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0419", (Locale)ctx.getLocale())));
        }
        ArrayList<String> tempTableList = new ArrayList<String>();
        try {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(idList);
            String pbbTempTable = this.createPBBTempTable(ctx);
            int effectedRows = 0;
            tempTableList.add(pbbTempTable);
            sql.setLength(0);
            sql.append(this.getInsertPBBTempTableSQL(pbbTempTable));
            sql.append("Select\r\n");
            sql.append("NewBOSID('12345678') FID,\r\n");
            sql.append("MANU.FID FSourceID,\r\n");
            sql.append("Max(MANU.FStorageOrgUnitID) FStorageOrgUnitID,\r\n");
            sql.append("T.FID  FEntrySourceid,\r\n");
            sql.append("Max(MANU.FProjectID) FProjectID,\r\n");
            sql.append("Max(MANU.FTrackID) FTrackNumberID,\r\n");
            sql.append("T.FMaterialID FMaterialID,\r\n");
            sql.append("Max(T.FUnitID) FUnitID,\r\n");
            sql.append("Sum(T.FPlannedQty) FQty,\r\n");
            sql.append("Max(T.FPickType) FPickType,\r\n");
            sql.append("Max(T.FFlow) FProcessFlow,\r\n");
            sql.append("Max(T.FStorageOrgUnitID) FSupplyStorageOrgUnitID,\r\n");
            sql.append("Null FInWarehouseID,\r\n");
            sql.append("Null FOutWarehouseID,\r\n");
            sql.append("Null FInLocationID,\r\n");
            sql.append("Null FOutLocationID,\r\n");
            sql.append("Max(T.FProvideType) FProvideType\r\n");
            sql.append("From T_MM_MFTOrderStock T\r\n");
            sql.append("Inner Join T_MM_ManufactureOrder MANU On MANU.FID = T.FParentID\r\n");
            sql.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID=MANU.FStorageOrgUnitID and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5' ");
            sql.append(" left join T_ORG_UnitRelation r1 on r1.FFromUnitID=T.FstorageOrgUnitID and r1.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5' ");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("and T.fid in(\r\n");
            sql.append(SQLUtil.arrayToString((Object[])idList.toArray())).append("\r\n");
            sql.append(")\r\n");
            sql.append("And MANU.FBaseStatus not in (1,2)\r\n");
            sql.append("And (IsNull(T.FPickType,0)=\r\n");
            sql.append(3);
            sql.append(" or IsNull(T.FProvideType,0)=\r\n");
            sql.append(10920);
            sql.append(")\r\n");
            sql.append(" and ( isnull(r0.FToUnitID,'*') = isnull(r1.FToUnitID,'*')  or ( isnull(r0.FToUnitID,'*') <> isnull(r1.FToUnitID,'*') ");
            sql.append(" And Exists(Select 1 from T_BAS_MaterialOrgPlanMode a where a.Fsupporgunitid = T.Fstorageorgunitid and a.Fstorageorgunitid = MANU.Fstorageorgunitid and a.Fstatus = 1 and a.Fplanmode = 2) ");
            sql.append(" ))");
            sql.append("Group By\r\n");
            sql.append("T.FID,\r\n");
            sql.append("T.FMaterialID,\r\n");
            sql.append("MANU.FID\r\n");
            effectedRows = this.executeSQL(ctx, sql.toString());
            if (effectedRows <= 0) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0420", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"NoDatas_StockTransferPlan", (Locale)ctx.getLocale())));
            }
            String BDetialTempTable = this.createBeforeDetialTempTable(ctx);
            tempTableList.add(BDetialTempTable);
            sql.setLength(0);
            sql.append("Insert Into ").append(BDetialTempTable).append(" \r\n");
            sql.append("(FID,FSourceID,FStorageOrgUnitID,FSupplyOrgUnitID,FProjectID,FTrackNumberID,FMaterialID,FUnitID,FQty,FProcessFlow) \r\n");
            sql.append(" Select fid,FSourceBillID,Cfstorageorgunitid,Cfsupplysouid,Cfprojectid,Cftraceid,Cfmaterialid,Cfunitid,CFSubmitQTY,Cfprocessflow \r\n");
            sql.append(" from CT_MO_StockTransferPlanDetial a \r\n");
            sql.append(" where a.FEntrySourceBillID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])idList.toArray())).append("\r\n");
            sql.append(")\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("select FID,FEntrySourceBillID,CFSubmitQty  FROM CT_MO_StockTransferPlanDetial\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And FEntrySourceBillID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])idList.toArray())).append("\r\n");
            sql.append(")\r\n");
            IRowSet rowOld = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<String> oldIdList = new ArrayList<String>();
            ArrayList<BigDecimal> oldQtyList = new ArrayList<BigDecimal>();
            while (rowOld.next()) {
                String fid = rowOld.getString("FID") == null ? "" : rowOld.getString("FID");
                BigDecimal submitQty = rowOld.getBigDecimal("CFSubmitQty") == null ? BigDecimal.ZERO : rowOld.getBigDecimal("CFSubmitQty");
                oldIdList.add(fid);
                oldQtyList.add(submitQty);
            }
            sql.setLength(0);
            sql.append("Update CT_MO_StockTransferPlanDetial UT\r\n");
            sql.append("Set\r\n");
            sql.append("CFSubmitQTY=IsNull((\r\n");
            sql.append("Select\r\n");
            sql.append("Sum(T.FQTY)\r\n");
            sql.append("From ").append(pbbTempTable).append(" T\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And T.FSourceID=UT.FSourceBillID\r\n");
            sql.append("And T.FMaterialID=UT.CFMaterialID\r\n");
            sql.append("And T.FProjectID=UT.CFProjectID\r\n");
            sql.append("And T.FTrackNumberID=UT.CFTraceID\r\n");
            sql.append("),0)\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FEntrySourceBillID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])idList.toArray())).append("\r\n");
            sql.append(")\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("select FID,FEntrySourceBillID,CFSubmitQty  FROM CT_MO_StockTransferPlanDetial\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And FEntrySourceBillID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])idList.toArray())).append("\r\n");
            sql.append(")\r\n");
            IRowSet rowNew = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowNew.next()) {
                String newId = rowNew.getString("FID") == null ? "" : rowNew.getString("FID");
                BigDecimal newQty = rowNew.getBigDecimal("CFSubmitQty") == null ? BigDecimal.ZERO : rowNew.getBigDecimal("CFSubmitQty");
                for (int i = 0; i < oldIdList.size(); ++i) {
                    BigDecimal oldQty;
                    if (!oldIdList.get(i).toString().equals(newId) || (oldQty = new BigDecimal(oldQtyList.get(i).toString())).equals(newQty)) continue;
                    sql.setLength(0);
                    sql.append("Update CT_MO_StockTransferPlan\r\n");
                    sql.append("Set\r\n");
                    sql.append("CFSubmitQTY=CFSubmitQTY+").append(newQty.subtract(oldQty) + "\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And FSourceBillID ='").append(newId + "'\r\n");
                    this.executeSQL(ctx, sql.toString());
                }
            }
            sql.setLength(0);
            sql.append("Update T_MM_MFTOrderStock mt\r\n");
            sql.append("Set\r\n");
            sql.append("FTransferPlanQty = IsNull((\r\n");
            sql.append("Select\r\n");
            sql.append("Sum(T.FQTY)\r\n");
            sql.append("From ").append(pbbTempTable).append(" T\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And T.FEntrySourceid=mt.FID\r\n");
            sql.append("And T.FMaterialID=mt.FMaterialID\r\n");
            sql.append("),0)\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And mt.FID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])idList.toArray())).append("\r\n");
            sql.append(")\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Update CT_MO_StockTransferPlanDetial UT\r\n");
            sql.append("Set\r\n");
            sql.append("CFTransferStatus=(\r\n");
            sql.append("Select\r\n");
            sql.append("Max(Case\r\n");
            sql.append("When IsNull(T.CFTransferQTY,0)<=0 Then ").append(0).append("\r\n");
            sql.append("When IsNull(T.CFTransferQTY,0)>0 And IsNull(T.CFTransferQTY,0)<IsNull(T.CFSubmitQTY,0) Then ").append(1).append("\r\n");
            sql.append("When IsNull(T.CFTransferQTY,0)>0 And IsNull(T.CFTransferQTY,0)>=IsNull(T.CFSubmitQTY,0) Then ").append(2).append("\r\n");
            sql.append("End)\r\n");
            sql.append("From CT_MO_StockTransferPlanDetial T\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And T.FID=UT.FID\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FEntrySourceBillID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])idList.toArray())).append("\r\n");
            sql.append(")\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Delete From CT_MO_StockTransferPlanDetial DT\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And DT.FEntrySourceBillID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])idList.toArray())).append("\r\n");
            sql.append(")\r\n");
            sql.append("And IsNull(DT.CFSubmitQTY,0)=0\r\n");
            sql.append("And IsNull(DT.Cftransferqty,0)=0\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Delete From ").append(pbbTempTable).append(" DT\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And Exists (\r\n");
            sql.append("Select\r\n");
            sql.append("1\r\n");
            sql.append("From CT_MO_StockTransferPlanDetial STP\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And STP.FSourceBillID=DT.FSourceID\r\n");
            sql.append("And STP.CFMaterialID=DT.FMaterialID\r\n");
            sql.append("And STP.CFProjectID=DT.FProjectID\r\n");
            sql.append("And STP.CFTraceID=DT.FTrackNumberID\r\n");
            sql.append(")\r\n");
            this.executeSQL(ctx, sql.toString());
            String outWarehouseTempTable = this.createMOSERSTempTable(ctx);
            tempTableList.add(outWarehouseTempTable);
            sql.setLength(0);
            sql.append(this.insertMOSERSTempTableSQL(outWarehouseTempTable));
            sql.append("Select\r\n");
            sql.append("0,\r\n");
            sql.append("T.FID,\r\n");
            sql.append("inv.FDefaultWarehouseID\r\n");
            sql.append("From ").append(pbbTempTable).append(" T\r\n");
            sql.append("Inner Join T_BD_MaterialInventory inv On \r\n");
            sql.append(" 1=1 \r\n");
            sql.append(" where T.FMaterialID = inv.fmaterialid \r\n");
            sql.append(" and T.FStorageOrgUnitID = inv.forgunit \r\n");
            sql.append(" And inv.FStatus=").append(1).append("\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Update ").append(pbbTempTable).append(" UT\r\n");
            sql.append("Set FOutWarehouseID=(\r\n");
            sql.append("Select\r\n");
            sql.append("Max(T.FWarehouseID)\r\n");
            sql.append("From ").append(outWarehouseTempTable).append(" T\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And T.FMOSTOCKID=UT.FID\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Update ").append(pbbTempTable).append(" UT\r\n");
            sql.append("Set FInWarehouseID=(\r\n");
            sql.append("Select\r\n");
            sql.append("Max(MI.FDefaultWarehouseID)\r\n");
            sql.append("From T_BD_MaterialInventory MI\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MI.FMaterialID=UT.FMaterialID\r\n");
            sql.append("And MI.FOrgUnit=UT.FStorageOrgUnitID\r\n");
            sql.append("And MI.FStatus=").append(1).append("\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Update ").append(pbbTempTable).append(" UT\r\n");
            sql.append("Set\r\n");
            sql.append("FOutLocationID=(\r\n");
            sql.append("Select\r\n");
            sql.append("Max(MSA.FLocationID)\r\n");
            sql.append("From T_DB_MaterialStorageAssign MSA\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MSA.FMaterialID=UT.FMaterialID\r\n");
            sql.append("And MSA.FStorageOrgID=UT.FSupplyStorageOrgUnitID\r\n");
            sql.append("And MSA.FWarehouseID=UT.FOutWarehouseID\r\n");
            sql.append("And IsNull(MSA.FIsDefaultLocation,0)=1\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FOutLocationID Is Null\r\n");
            sql.append("And Exists(\r\n");
            sql.append("Select\r\n");
            sql.append("1\r\n");
            sql.append("From T_DB_Warehouse WH\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And WH.FID=UT.FOutWarehouseID\r\n");
            sql.append("And IsNull(WH.FHasLocation,0)=1\r\n");
            sql.append(")\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Update ").append(pbbTempTable).append(" UT\r\n");
            sql.append("Set\r\n");
            sql.append("FOutLocationID=(\r\n");
            sql.append("Select\r\n");
            sql.append("Max(MSA.FLocationID)\r\n");
            sql.append("From T_DB_MaterialStorageAssign MSA\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MSA.FMaterialID=UT.FMaterialID\r\n");
            sql.append("And MSA.FStorageOrgID=UT.FSupplyStorageOrgUnitID\r\n");
            sql.append("And MSA.FWarehouseID=UT.FOutWarehouseID\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FOutLocationID Is Null\r\n");
            sql.append("And Exists(\r\n");
            sql.append("Select\r\n");
            sql.append("1\r\n");
            sql.append("From T_DB_Warehouse WH\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And WH.FID=UT.FOutWarehouseID\r\n");
            sql.append("And IsNull(WH.FHasLocation,0)=1\r\n");
            sql.append(")\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Update ").append(pbbTempTable).append(" UT\r\n");
            sql.append("Set\r\n");
            sql.append("FInLocationID=(\r\n");
            sql.append("Select\r\n");
            sql.append("Max(MSA.FLocationID)\r\n");
            sql.append("From T_DB_MaterialStorageAssign MSA\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MSA.FMaterialID=UT.FMaterialID\r\n");
            sql.append("And MSA.FStorageOrgID=UT.FStorageOrgUnitID\r\n");
            sql.append("And MSA.FWarehouseID=UT.FInWarehouseID\r\n");
            sql.append("And IsNull(MSA.FIsDefaultLocation,0)=1\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FInLocationID Is Null\r\n");
            sql.append("And Exists(\r\n");
            sql.append("Select\r\n");
            sql.append("1\r\n");
            sql.append("From T_DB_Warehouse WH\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And WH.FID=UT.FInWarehouseID\r\n");
            sql.append("And IsNull(WH.FHasLocation,0)=1\r\n");
            sql.append(")\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Update ").append(pbbTempTable).append(" UT\r\n");
            sql.append("Set\r\n");
            sql.append("FInLocationID=(\r\n");
            sql.append("Select\r\n");
            sql.append("Max(MSA.FLocationID)\r\n");
            sql.append("From T_DB_MaterialStorageAssign MSA\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MSA.FMaterialID=UT.FMaterialID\r\n");
            sql.append("And MSA.FStorageOrgID=UT.FStorageOrgUnitID\r\n");
            sql.append("And MSA.FWarehouseID=UT.FInWarehouseID\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FInLocationID Is Null\r\n");
            sql.append("And Exists(\r\n");
            sql.append("Select\r\n");
            sql.append("1\r\n");
            sql.append("From T_DB_Warehouse WH\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And WH.FID=UT.FInWarehouseID\r\n");
            sql.append("And IsNull(WH.FHasLocation,0)=1\r\n");
            sql.append(")\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("FSourceID FSourceID,\r\n");
            sql.append("FStorageOrgUnitID FStorageOrgUnitID,\r\n");
            sql.append("FEntrySourceid FEntrySourceid,\r\n");
            sql.append("FProjectID FProjectID,\r\n");
            sql.append("FTrackNumberID FTrackNumberID,\r\n");
            sql.append("FMaterialID FMaterialID,\r\n");
            sql.append("FUnitID FUnitID,\r\n");
            sql.append("FQty FQty,\r\n");
            sql.append("FProcessFlow FProcessFlow,\r\n");
            sql.append("FSupplyStorageOrgUnitID FSupplyStorageOrgUnitID,\r\n");
            sql.append("FInWarehouseID FInWarehouseID,\r\n");
            sql.append("FOutWarehouseID FOutWarehouseID,\r\n");
            sql.append("FInLocationID FInLocationID,\r\n");
            sql.append("FOutLocationID FOutLocationID\r\n");
            sql.append("From ").append(pbbTempTable).append(" UT\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<String> orderList = new ArrayList<String>();
            if (rowSet != null && rowSet.size() > 0) {
                BillTypeInfo billTypeInfo;
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.clear();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                filterInfo.getFilterItems().clear();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"STP", CompareType.EQUALS));
                entityViewInfo.setFilter(filterInfo);
                entityViewInfo.setSelector(sic);
                BillTypeCollection billTypeCollection = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeCollection(entityViewInfo);
                BillTypeInfo billTypeInfo2 = billTypeCollection == null ? null : (billTypeInfo = billTypeCollection.size() == 0 ? null : billTypeCollection.get(0));
                if (billTypeInfo == null) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0420", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.mo.EMMEMMmmoResource", (String)"0EMMMO-0421", (Locale)ctx.getLocale())));
                }
                CoreBaseCollection addNewSTPCollection = new CoreBaseCollection();
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                Date date = new Date();
                Timestamp timestamp = new Timestamp(date.getTime());
                CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                while (rowSet.next()) {
                    IRowSet rs;
                    CompanyOrgUnitInfo companyOrgUnitInfo;
                    String sourceID = rowSet.getString("FSourceID");
                    if (!orderList.contains(sourceID)) {
                        orderList.add(sourceID);
                    }
                    String sourceEntryID = rowSet.getString("FEntrySourceid");
                    String storageORGUnitID = rowSet.getString("FStorageOrgUnitID");
                    String materialID = rowSet.getString("FMaterialID");
                    String unitID = rowSet.getString("FUnitID");
                    String projectID = rowSet.getString("FProjectID");
                    String trackNumberID = rowSet.getString("FTrackNumberID");
                    String supplyStorageOrgUnitID = rowSet.getString("FSupplyStorageOrgUnitID");
                    String inWarehouseID = rowSet.getString("FInWarehouseID");
                    String outWarehouseID = rowSet.getString("FOutWarehouseID");
                    String outLocationID = rowSet.getString("FOutLocationID");
                    String inLocationID = rowSet.getString("FInLocationID");
                    BigDecimal qty = rowSet.getBigDecimal("FQTY");
                    String processFlow = rowSet.getString("FProcessFlow");
                    String moveInCompanyID = null;
                    String moveOutCompanyID = null;
                    StockTransferPlanDetialInfo stpInfo = new StockTransferPlanDetialInfo();
                    stpInfo.setId(BOSUuid.create((BOSObjectType)new StockTransferPlanDetial().getType()));
                    stpInfo.setBillType(billTypeInfo);
                    stpInfo.setBizDate(date);
                    stpInfo.setCU(ctrlUnitInfo);
                    stpInfo.setSourceBillId(sourceID);
                    stpInfo.setEntrySourceBillID(sourceEntryID);
                    stpInfo.setLastComputeTime(timestamp);
                    stpInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                    stpInfo.setTransferStatus(MoveStatusEnum.WDB);
                    stpInfo.setLastComputeUser(userInfo);
                    stpInfo.setCreator(userInfo);
                    stpInfo.setCreateTime(timestamp);
                    stpInfo.setLastUpdateUser(userInfo);
                    stpInfo.setLastUpdateTime(timestamp);
                    IManufactureOrder iInstance = ManufactureOrderFactory.getLocalInstance((Context)ctx);
                    if (iInstance.exists((IObjectPK)new ObjectUuidPK(sourceID))) {
                        stpInfo.setMo(iInstance.getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(sourceID)));
                    }
                    if (storageORGUnitID != null && storageORGUnitID.trim().length() > 0) {
                        StorageOrgUnitInfo storageOrgUnitInfo = new StorageOrgUnitInfo();
                        companyOrgUnitInfo = new CompanyOrgUnitInfo();
                        storageOrgUnitInfo.setId(BOSUuid.read((String)storageORGUnitID));
                        stpInfo.setStorageOrgUnit(storageOrgUnitInfo);
                        sql.setLength(0);
                        sql.append("Select aa.ftounitid companyOrgUnitID from T_ORG_UnitRelation aa\r\n");
                        sql.append("inner join T_ORG_TypeRelation bb on aa.ftyperelationid = bb.fid\r\n");
                        sql.append("where  aa.ffromunitid = '" + storageORGUnitID + "'\r\n");
                        sql.append(" and bb.ffromtype = 4 and bb.ftotype = 1 and rownum = 1\r\n");
                        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                        if (rs.next()) {
                            String string = moveInCompanyID = rs.getString("companyOrgUnitID") == null ? "" : rs.getString("companyOrgUnitID");
                            if (moveInCompanyID != "") {
                                companyOrgUnitInfo.setId(BOSUuid.read((String)moveInCompanyID));
                                stpInfo.setPrmtMoveInCompanyOrgUnit(companyOrgUnitInfo);
                            }
                        }
                    }
                    if (materialID != null && materialID.trim().length() > 0) {
                        MaterialInfo materialInfo = new MaterialInfo();
                        materialInfo.setId(BOSUuid.read((String)materialID));
                        stpInfo.setMaterial(materialInfo);
                    }
                    if (unitID != null && unitID.trim().length() > 0) {
                        MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
                        measureUnitInfo.setId(BOSUuid.read((String)unitID));
                        stpInfo.setUnit(measureUnitInfo);
                    }
                    if (projectID != null && projectID.trim().length() > 0) {
                        ProjectInfo projectInfo = new ProjectInfo();
                        projectInfo.setId(BOSUuid.read((String)projectID));
                        stpInfo.setProject(projectInfo);
                    }
                    if (trackNumberID != null && trackNumberID.trim().length() > 0) {
                        TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
                        trackNumberInfo.setId(BOSUuid.read((String)trackNumberID));
                        stpInfo.setTrace(trackNumberInfo);
                    }
                    if (supplyStorageOrgUnitID != null && supplyStorageOrgUnitID.trim().length() > 0) {
                        StorageOrgUnitInfo supplySOUInfo = new StorageOrgUnitInfo();
                        companyOrgUnitInfo = new CompanyOrgUnitInfo();
                        supplySOUInfo.setId(BOSUuid.read((String)supplyStorageOrgUnitID));
                        stpInfo.setSupplyStorageOrgUnit(supplySOUInfo);
                        sql.setLength(0);
                        sql.append("Select aa.ftounitid companyOrgUnitID from T_ORG_UnitRelation aa\r\n");
                        sql.append("inner join T_ORG_TypeRelation bb on aa.ftyperelationid = bb.fid\r\n");
                        sql.append("where  aa.ffromunitid = '" + supplyStorageOrgUnitID + "'\r\n");
                        sql.append(" and bb.ffromtype = 4 and bb.ftotype = 1 and rownum = 1\r\n");
                        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                        if (rs.next()) {
                            String string = moveOutCompanyID = rs.getString("companyOrgUnitID") == null ? "" : rs.getString("companyOrgUnitID");
                            if (moveOutCompanyID != "") {
                                companyOrgUnitInfo.setId(BOSUuid.read((String)moveOutCompanyID));
                                stpInfo.setPrmtMoveOutCompanyOrgUnit(companyOrgUnitInfo);
                                if (moveInCompanyID != null && moveInCompanyID != "") {
                                    if (moveInCompanyID.equals(moveOutCompanyID)) {
                                        stpInfo.setCompanyOrgIsSam(true);
                                    } else {
                                        stpInfo.setCompanyOrgIsSam(false);
                                    }
                                }
                            }
                        }
                    }
                    if (inWarehouseID != null && inWarehouseID.trim().length() > 0) {
                        WarehouseInfo moveInWarehouseInfo = new WarehouseInfo();
                        moveInWarehouseInfo.setId(BOSUuid.read((String)inWarehouseID));
                        stpInfo.setMoveInWarehouse(moveInWarehouseInfo);
                    }
                    if (outWarehouseID != null && outWarehouseID.trim().length() > 0) {
                        WarehouseInfo moveOutWarehouseInfo = new WarehouseInfo();
                        moveOutWarehouseInfo.setId(BOSUuid.read((String)outWarehouseID));
                        stpInfo.setMoveOutWarehouse(moveOutWarehouseInfo);
                    }
                    if (outLocationID != null && outLocationID.trim().length() > 0) {
                        LocationInfo moveOutLocationInfo = new LocationInfo();
                        moveOutLocationInfo.setId(BOSUuid.read((String)outLocationID));
                        stpInfo.setMoveOutLocation(moveOutLocationInfo);
                    }
                    if (inLocationID != null && inLocationID.trim().length() > 0) {
                        LocationInfo moveInLocationInfo = new LocationInfo();
                        moveInLocationInfo.setId(BOSUuid.read((String)inLocationID));
                        stpInfo.setMoveInLocation(moveInLocationInfo);
                    }
                    stpInfo.setSubmitQty(qty);
                    stpInfo.setSubmitTransferQty(BigDecimal.ZERO);
                    stpInfo.setTransferQty(BigDecimal.ZERO);
                    stpInfo.setAuditTransferQty(BigDecimal.ZERO);
                    stpInfo.setProcessFlow(processFlow);
                    this.setBillNumber(ctx, (IObjectValue)stpInfo, storageORGUnitID);
                    addNewSTPCollection.add((CoreBaseInfo)stpInfo);
                    BOSObjectType BOTBosType = new BOTRelation().getType();
                    BOSObjectType orderBosType = new ManufactureOrder().getType();
                    BOSObjectType stockTranBosType = new StockTransferPlanDetial().getType();
                    UserInfo curUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                    sql.setLength(0);
                    sql.append("select 1 from T_BOT_Relation \r\n");
                    sql.append("where FSRCObjectID= '");
                    sql.append(sourceID);
                    sql.append("'and FDESTObjectID= '");
                    sql.append(stpInfo.getId().toString());
                    sql.append("';");
                    IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    if (rs2.next()) continue;
                    sql.setLength(0);
                    sql.append("Insert Into T_BOT_Relation(\r\n");
                    sql.append("FID,\r\n");
                    sql.append("FSRCEntityID,\r\n");
                    sql.append("FDESTEntityID,\r\n");
                    sql.append("FSRCObjectID,\r\n");
                    sql.append("FDESTObjectID,\r\n");
                    sql.append("FDate,\r\n");
                    sql.append("FOperatorID,\r\n");
                    sql.append("FIsEffected,\r\n");
                    sql.append("FBOTMappingID,\r\n");
                    sql.append("FType\r\n");
                    sql.append(")\r\n");
                    sql.append("VALUES (\r\n");
                    sql.append("NewBOSID('").append(BOTBosType.toString()).append("'),\r\n");
                    sql.append("'").append(orderBosType.toString()).append("',\r\n");
                    sql.append("'").append(stockTranBosType.toString()).append("',\r\n");
                    sql.append("'").append(sourceID).append("',\r\n");
                    sql.append("'" + stpInfo.getId().toString() + "',\r\n");
                    sql.append(" sysdate,\r\n");
                    sql.append("'").append(curUserInfo.getId().toString()).append("',\r\n");
                    sql.append("1,\r\n");
                    sql.append("Null,\r\n");
                    sql.append("0\r\n");
                    sql.append(")\r\n");
                    this.executeSQL(ctx, sql.toString());
                }
                if (addNewSTPCollection != null && addNewSTPCollection.size() > 0) {
                    StockTransferPlanDetialFactory.getLocalInstance(ctx).addnewBatchData(addNewSTPCollection);
                }
            }
            this.updateTotalStockTransferPlan(ctx, idList, BDetialTempTable);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.releaseTempTable(ctx, tempTableList);
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(idList);
        }
    }

    private void wirteMTFAlrQty(Context ctx, String sourceEntryID, BigDecimal qty) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_MM_MFTOrderStock mt set FTransferPlanQty = \r\n");
        sql.append(" IsNull(mt.FTransferPlanQty,0)+").append(qty).append(" \r\n");
        sql.append(" where mt.fid = '").append(sourceEntryID).append("'\r\n");
        sql.append("And (IsNull(mt.FPickType,0)=\r\n");
        sql.append(3);
        sql.append(" or IsNull(mt.FProvideType,0)=\r\n");
        sql.append(10920);
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
    }

    protected String createPBBTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table PBBTempTable(\r\n");
        sql.append("FID VARCHAR(44),\r\n");
        sql.append("FSourceID VARCHAR(44),\r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44),\r\n");
        sql.append("FEntrySourceid VARCHAR(44),\r\n");
        sql.append("FProjectID VARCHAR(44),\r\n");
        sql.append("FTrackNumberID VARCHAR(44),\r\n");
        sql.append("FMaterialID VARCHAR(44),\r\n");
        sql.append("FUnitID VARCHAR(44),\r\n");
        sql.append("FQty Numeric(28,14),\r\n");
        sql.append("FPickType Int,\r\n");
        sql.append("FProcessFlow NVARCHAR(255),\r\n");
        sql.append("FSupplyStorageOrgUnitID VARCHAR(44),\r\n");
        sql.append("FInWarehouseID VARCHAR(44),\r\n");
        sql.append("FOutWarehouseID VARCHAR(44),\r\n");
        sql.append("FInLocationID VARCHAR(44),\r\n");
        sql.append("FOutLocationID VARCHAR(44),\r\n");
        sql.append("FProvideType Int\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String getInsertPBBTempTableSQL(String pbbTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(pbbTempTableName).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FSourceID,\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FEntrySourceid,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FTrackNumberID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FUnitID,\r\n");
        sql.append("FQty,\r\n");
        sql.append("FPickType,\r\n");
        sql.append("FProcessFlow,\r\n");
        sql.append("FSupplyStorageOrgUnitID,\r\n");
        sql.append("FInWarehouseID,\r\n");
        sql.append("FOutWarehouseID,\r\n");
        sql.append("FInLocationID,\r\n");
        sql.append("FOutLocationID,\r\n");
        sql.append("FProvideType\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String createBeforeDetialTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table BeforeDetialTempTable(\r\n");
        sql.append("FID VARCHAR(44),\r\n");
        sql.append("FSourceID VARCHAR(44),\r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44),\r\n");
        sql.append("FSupplyOrgUnitID VARCHAR(44),\r\n");
        sql.append("FProjectID VARCHAR(44),\r\n");
        sql.append("FTrackNumberID VARCHAR(44),\r\n");
        sql.append("FMaterialID VARCHAR(44),\r\n");
        sql.append("FUnitID VARCHAR(44),\r\n");
        sql.append("FQty Numeric(28,14),\r\n");
        sql.append("FProcessFlow NVARCHAR(255)\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createMOSERSTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOSERTempTable(\r\n");
        sql.append("FROW INT,\r\n");
        sql.append("FMOSTOCKID VARCHAR(44) Null,\r\n");
        sql.append("FWAREHOUSEID VARCHAR(44) NULL\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOSTOCKID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String insertMOSERSTempTableSQL(String mosersTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(mosersTempTable).append("(\r\n");
        sql.append("FROW,\r\n");
        sql.append("FMOSTOCKID,\r\n");
        sql.append("FWAREHOUSEID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    public int executeSQL(Context ctx, String sql) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            long startTime = System.currentTimeMillis();
            int effectedRows = statement.executeUpdate(sql);
            long endTime = System.currentTimeMillis();
            long duration = (endTime - startTime) / 1000L;
            System.out.println("Execute SQL Effected Rows " + effectedRows + " Duration " + duration + " Sec:\r\n" + sql.toString());
            int n = effectedRows;
            return n;
        }
        catch (SQLException e) {
            throw new BOSException(sql, (Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    protected void releaseTempTable(Context ctx, List tempTableList) {
        if (ctx == null || tempTableList == null) {
            return;
        }
        if (tempTableList.size() == 0) {
            return;
        }
        for (int index = 0; index < tempTableList.size(); ++index) {
            String tempTable;
            String string = tempTable = tempTableList.get(index) == null ? null : tempTableList.get(index).toString();
            if (tempTable == null) {
                return;
            }
            if (tempTable.trim().length() == 0) {
                return;
            }
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
    }

    protected void updateTotalStockTransferPlan(Context ctx, List mpsIdList, String BDetialTempTable) throws BOSException, EASBizException {
        if (ctx == null || mpsIdList == null || mpsIdList.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Select FStorageOrgUnitID,FSupplyOrgUnitID,FProjectID,Fmaterialid,FProcessFlow,FNewqty,FOldqty from ( \r\n");
        sql.append(" Select a.Cfstorageorgunitid As FStorageOrgUnitID, \r\n");
        sql.append("  a.Cfsupplysouid As FSupplyOrgUnitID, \r\n");
        sql.append("  a.Cfprojectid As FProjectID, \r\n");
        sql.append(" a.Cfmaterialid As Fmaterialid, \r\n");
        sql.append(" a.Cfprocessflow As FProcessFlow, \r\n");
        sql.append(" Sum(CFSubmitQTY) As FNewqty, \r\n");
        sql.append(" isnull((Select sum(fqty) from ").append(BDetialTempTable).append(" b ");
        sql.append(" where  isnull(b.Fmaterialid,'Null') =  isnull(a.Cfmaterialid,'Null') ");
        sql.append(" and isnull(b.FProjectID,'Null') =  isnull(a.Cfprojectid,'Null')");
        sql.append(" and isnull(b.FStorageOrgUnitID,'Null') =  isnull(a.Cfstorageorgunitid,'Null')");
        sql.append(" and isnull(b.FSupplyOrgUnitID,'Null') =  isnull(a.Cfsupplysouid,'Null')");
        sql.append(" and isnull(b.FProcessFlow,'Null') =  isnull(a.Cfprocessflow,'Null')");
        sql.append("  ),0) As FOldqty \r\n");
        sql.append(" From CT_MO_StockTransferPlanDetial a \r\n");
        sql.append(" Where a.FEntrySourceBillID In (\r\n");
        sql.append(SQLUtil.arrayToString((Object[])mpsIdList.toArray())).append("\r\n");
        sql.append(")\r\n");
        sql.append(" Group By a.Cfstorageorgunitid,a.Cfsupplysouid,a.Cfprojectid,a.Cfmaterialid,a.Cfprocessflow  \r\n");
        sql.append(" ) aa where aa.FNewqty <> aa.FOldqty  \r\n");
        sql.append(" union \r\n");
        sql.append(" Select FStorageOrgUnitID,FSupplyOrgUnitID,FProjectID,Fmaterialid,FProcessFlow,0.00 as FNewqty,sum(fqty) as FOldqty \r\n");
        sql.append(" from ").append(BDetialTempTable).append(" a \r\n");
        sql.append(" where not exists (select 1 from CT_MO_StockTransferPlanDetial b ");
        sql.append(" where b.FEntrySourceBillID In (").append(SQLUtil.arrayToString((Object[])mpsIdList.toArray())).append(")");
        sql.append(" and isnull(b.Cfmaterialid,'Null') =  isnull(a.fmaterialid,'Null')");
        sql.append(" and isnull(b.Cfprojectid,'Null') =  isnull(a.fprojectid,'Null')");
        sql.append(" and isnull(b.Cfstorageorgunitid,'Null') =  isnull(a.FStorageOrgUnitID,'Null')");
        sql.append(" and isnull(b.Cfsupplysouid,'Null') =  isnull(a.FSupplyOrgUnitID,'Null')");
        sql.append(" and isnull(b.Cfprocessflow,'Null') =  isnull(a.fprocessflow,'Null')");
        sql.append(" ) \r\n");
        sql.append(" Group By a.FStorageOrgUnitID,a.FSupplyOrgUnitID,a.FProjectID,a.FMaterialID,a.FProcessFlow \r\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String fplanID = "";
        HashMap<String, Object> sourceMap = new HashMap<String, Object>();
        ArrayList<String> sqlList = new ArrayList<String>();
        if (rowSet != null && rowSet.size() > 0) {
            try {
                while (rowSet.next()) {
                    String FStorageOrgUnitID = rowSet.getString("FStorageOrgUnitID");
                    String FSupplyOrgUnitID = rowSet.getString("FSupplyOrgUnitID");
                    String FProjectID = rowSet.getString("FProjectID");
                    String Fmaterialid = rowSet.getString("Fmaterialid");
                    String FProcessFlow = rowSet.getString("FProcessFlow");
                    BigDecimal FNewqty = rowSet.getBigDecimal("FNewqty");
                    BigDecimal FOldqty = rowSet.getBigDecimal("FOldqty");
                    if (FStorageOrgUnitID == null) {
                        FStorageOrgUnitID = "";
                    }
                    if (FSupplyOrgUnitID == null) {
                        FSupplyOrgUnitID = "";
                    }
                    if (FProjectID == null) {
                        FProjectID = "";
                    }
                    if (Fmaterialid == null) {
                        Fmaterialid = "";
                    }
                    if (FProcessFlow == null) {
                        FProcessFlow = "";
                    }
                    if (FNewqty == null) {
                        FNewqty = new BigDecimal(0);
                    }
                    if (FOldqty == null) {
                        FOldqty = new BigDecimal(0);
                    }
                    if (FNewqty.compareTo(FOldqty) == 0) continue;
                    sql.setLength(0);
                    sql.append(" select fid,CFSubmitQTY As Fqty from CT_MO_StockTransferPlan a ");
                    sql.append(" where a. Cfmaterialid = '").append(Fmaterialid).append("'");
                    if (FProjectID == null || "".equals(FProjectID)) {
                        sql.append(" and a. Cfprojectid is null");
                    } else {
                        sql.append(" and a. Cfprojectid = '").append(FProjectID).append("'");
                    }
                    if (FStorageOrgUnitID == null || "".equals(FStorageOrgUnitID)) {
                        sql.append(" and a. Cfstorageorgunitid is null");
                    } else {
                        sql.append(" and a. Cfstorageorgunitid = '").append(FStorageOrgUnitID).append("'");
                    }
                    if (FSupplyOrgUnitID == null || "".equals(FSupplyOrgUnitID)) {
                        sql.append(" and a. Cfsupplysouid is null");
                    } else {
                        sql.append(" and a. Cfsupplysouid = '").append(FSupplyOrgUnitID).append("'");
                    }
                    if (FProcessFlow == null || "".equals(FProcessFlow)) {
                        sql.append(" and a. Cfprocessflow is null");
                    } else {
                        sql.append(" and a. Cfprocessflow = '").append(FProcessFlow).append("'");
                    }
                    sql.append(" and a. Fsourcefunction ='stocktransferplandetial'");
                    IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    fplanID = "";
                    if (rowSet2 != null && rowSet2.size() > 0) {
                        while (rowSet2.next()) {
                            fplanID = rowSet2.getString("fid");
                        }
                    }
                    sourceMap = new HashMap();
                    sourceMap.put("FStorageOrgUnitID", FStorageOrgUnitID);
                    sourceMap.put("FSupplyOrgUnitID", FSupplyOrgUnitID);
                    sourceMap.put("FProjectID", FProjectID);
                    sourceMap.put("Fmaterialid", Fmaterialid);
                    sourceMap.put("FProcessFlow", FProcessFlow);
                    sourceMap.put("FNewqty", FNewqty);
                    sourceMap.put("FOldqty", FOldqty);
                    sourceMap.put("fplanID", fplanID);
                    if (fplanID == null || fplanID.equals("")) {
                        fplanID = BOSUuid.create((String)"08B2670B").toString();
                        sourceMap.put("fplanID", fplanID);
                        sourceMap.put("isaddInfo", true);
                    } else {
                        sourceMap.put("fplanID", fplanID);
                        sourceMap.put("isaddInfo", false);
                    }
                    List DetialIDList = new ArrayList();
                    DetialIDList = this.createStockTransferPlan(ctx, mpsIdList, sourceMap);
                    if (DetialIDList != null && DetialIDList.size() > 0) {
                        for (int j = 0; j < DetialIDList.size(); ++j) {
                            String fdetialid = DetialIDList.get(j).toString();
                            sql.setLength(0);
                            sql.append("insert into t_bot_relation(FID, FSRCENTITYID, FDESTENTITYID, FSRCOBJECTID, FDESTOBJECTID, FDATE, FOPERATORID, FISEFFECTED, FBOTMAPPINGID, FTYPE)");
                            sql.append(" select newbosid('59302EC6')");
                            sql.append(" ,'9CBCD44C'");
                            sql.append(" ,'08B2670B'");
                            sql.append(",'").append(fdetialid).append("'");
                            sql.append(",'").append(fplanID).append("',");
                            sql.append("sysdate").append(",");
                            sql.append("'UnKnown'").append(",");
                            sql.append("1").append(",");
                            sql.append("''").append(",");
                            sql.append("'0'").append("");
                            sql.append(" from dual where not exists(select 1 from t_bot_relation a where a.FSRCOBJECTID = '").append(fdetialid).append("' and a.FDESTOBJECTID = '").append(fplanID).append("' and a.FSRCENTITYID = '9CBCD44C' and a.FDESTENTITYID = '08B2670B')");
                            sqlList.add(sql.toString());
                        }
                    }
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                }
                if (sqlList.size() > 0) {
                    com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, sqlList);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected List createStockTransferPlan(Context ctx, List mpsIdList, Map sourceMap) throws BOSException, EASBizException {
        if (ctx == null || mpsIdList == null || mpsIdList.size() == 0 || sourceMap == null) {
            return null;
        }
        String fid = null;
        String FStorageOrgUnitID = null;
        String FSupplyOrgUnitID = null;
        String FProjectID = null;
        String Fmaterialid = null;
        String FProcessFlow = null;
        BigDecimal FNewqty = new BigDecimal(0);
        BigDecimal FOldqty = new BigDecimal(0);
        if (sourceMap.get("FStorageOrgUnitID") != null) {
            FStorageOrgUnitID = sourceMap.get("FStorageOrgUnitID").toString();
        }
        if (sourceMap.get("FSupplyOrgUnitID") != null) {
            FSupplyOrgUnitID = sourceMap.get("FSupplyOrgUnitID").toString();
        }
        if (sourceMap.get("FProjectID") != null) {
            FProjectID = sourceMap.get("FProjectID").toString();
        }
        if (sourceMap.get("Fmaterialid") != null) {
            Fmaterialid = sourceMap.get("Fmaterialid").toString();
        }
        if (sourceMap.get("FProcessFlow") != null) {
            FProcessFlow = sourceMap.get("FProcessFlow").toString();
        }
        if (sourceMap.get("FNewqty") != null) {
            FNewqty = new BigDecimal(sourceMap.get("FNewqty").toString());
        }
        if (sourceMap.get("FOldqty") != null) {
            FOldqty = new BigDecimal(sourceMap.get("FOldqty").toString());
        }
        if (sourceMap.get("fplanID") != null) {
            fid = sourceMap.get("fplanID").toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Select a.fid,a.cfsubmitqty as fsubmitqty,a.cftraceid as ftrackid,t.fnumber as ftracknumber   \n");
        sql.append(" from CT_MO_StockTransferPlanDetial a  \n");
        sql.append(" left outer join t_mm_tracknumber t on a.cftraceid = t.fid  \n");
        sql.append(" Where a.FEntrySourceBillID In (\r\n");
        sql.append(SQLUtil.arrayToString((Object[])mpsIdList.toArray())).append("\r\n");
        sql.append(")\r\n");
        if (Fmaterialid == null || "".equals(Fmaterialid)) {
            sql.append(" and a.Cfmaterialid is null \r\n");
        } else {
            sql.append(" and a.Cfmaterialid ='").append(Fmaterialid).append("' \r\n");
        }
        if (FProjectID == null || "".equals(FProjectID)) {
            sql.append(" and a.Cfprojectid is null \r\n");
        } else {
            sql.append(" and a.Cfprojectid ='").append(FProjectID).append("' \r\n");
        }
        if (FStorageOrgUnitID == null || "".equals(FStorageOrgUnitID)) {
            sql.append(" and a.Cfstorageorgunitid is null \r\n");
        } else {
            sql.append(" and a.Cfstorageorgunitid ='").append(FStorageOrgUnitID).append("' \r\n");
        }
        if (FSupplyOrgUnitID == null || "".equals(FSupplyOrgUnitID)) {
            sql.append(" and a.Cfsupplysouid is null \r\n");
        } else {
            sql.append(" and a.Cfsupplysouid ='").append(FSupplyOrgUnitID).append("' \r\n");
        }
        if (FProcessFlow == null || "".equals(FProcessFlow)) {
            sql.append(" and a.Cfprocessflow is null \r\n");
        } else {
            sql.append(" and a.Cfprocessflow ='").append(FProcessFlow).append("' \r\n");
        }
        sql.append(" order by t.fnumber");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int irow = 0;
        Boolean isaddInfo = false;
        isaddInfo = (Boolean)sourceMap.get("isaddInfo");
        AbstractStockTransferPlanInfo stpInfo = null;
        StockTransferPlanDetialInfo stpDetialInfo = new StockTransferPlanDetialInfo();
        ArrayList<String> DetialIDList = new ArrayList<String>();
        if (rowSet != null && rowSet.size() > 0) {
            try {
                while (rowSet.next()) {
                    String fplandetialid = rowSet.getString("fid");
                    String ftrackid = rowSet.getString("ftrackid");
                    String ftracknumber = rowSet.getString("ftracknumber");
                    TrackNumberInfo TrackNumberInfo2 = new TrackNumberInfo();
                    TrackNumberInfo2.setId(BOSUuid.read((String)ftrackid));
                    TrackNumberInfo2.setNumber(ftracknumber);
                    if (isaddInfo.booleanValue()) {
                        if (irow == 0) {
                            ++irow;
                            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                            Date date = new Date();
                            Timestamp timestamp = new Timestamp(date.getTime());
                            CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                            stpInfo = new StockTransferPlanInfo();
                            stpDetialInfo = StockTransferPlanDetialFactory.getLocalInstance(ctx).getStockTransferPlanDetialInfo((IObjectPK)new ObjectUuidPK(fplandetialid));
                            stpInfo.setBillType(stpDetialInfo.getBillType());
                            stpInfo.setBizDate(date);
                            stpInfo.setCU(ctrlUnitInfo);
                            stpInfo.setSourceBillId(fplandetialid);
                            stpInfo.setEntrySourceBillID(stpDetialInfo.getEntrySourceBillID());
                            stpInfo.setSourceFunction("stocktransferplandetial");
                            stpInfo.setLastComputeTime(timestamp);
                            stpInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                            stpInfo.setTransferStatus(MoveStatusEnum.WDB);
                            stpInfo.setLastComputeUser(userInfo);
                            stpInfo.setCreator(userInfo);
                            stpInfo.setCreateTime(timestamp);
                            stpInfo.setLastUpdateUser(userInfo);
                            stpInfo.setLastUpdateTime(timestamp);
                            stpInfo.setStorageOrgUnit(stpDetialInfo.getStorageOrgUnit());
                            stpInfo.setMaterial(stpDetialInfo.getMaterial());
                            stpInfo.setUnit(stpDetialInfo.getUnit());
                            stpInfo.setProject(stpDetialInfo.getProject());
                            stpInfo.setTrace(TrackNumberInfo2);
                            stpInfo.setStartTrace(TrackNumberInfo2);
                            stpInfo.setSupplyStorageOrgUnit(stpDetialInfo.getSupplyStorageOrgUnit());
                            stpInfo.setPrmtMoveInCompanyOrgUnit(stpDetialInfo.getPrmtMoveInCompanyOrgUnit());
                            stpInfo.setPrmtMoveOutCompanyOrgUnit(stpDetialInfo.getPrmtMoveOutCompanyOrgUnit());
                            stpInfo.setCompanyOrgIsSam(stpDetialInfo.getBoolean("companyOrgIsSam"));
                            stpInfo.setMps(null);
                            stpInfo.setMoveInWarehouse(stpDetialInfo.getMoveInWarehouse());
                            stpInfo.setMoveOutWarehouse(stpDetialInfo.getMoveOutWarehouse());
                            stpInfo.setMoveOutLocation(stpDetialInfo.getMoveOutLocation());
                            stpInfo.setMoveInLocation(stpDetialInfo.getMoveInLocation());
                            stpInfo.setSubmitQty(FNewqty.subtract(FOldqty));
                            stpInfo.setSubmitTransferQty(BigDecimal.ZERO);
                            stpInfo.setTransferQty(BigDecimal.ZERO);
                            stpInfo.setAuditTransferQty(BigDecimal.ZERO);
                            stpInfo.setProcessFlow(stpDetialInfo.getProcessFlow());
                            this.setBillNumber(ctx, (IObjectValue)stpInfo, FStorageOrgUnitID);
                            stpInfo.setId(BOSUuid.read((String)fid));
                        } else {
                            if (stpInfo.getTrace().getNumber().compareTo(ftracknumber) < 0) {
                                stpInfo.setTrace(TrackNumberInfo2);
                            }
                            if (stpInfo.getStartTrace().getNumber().compareTo(ftracknumber) > 0) {
                                stpInfo.setStartTrace(TrackNumberInfo2);
                            }
                        }
                    } else {
                        if (irow == 0) {
                            ++irow;
                            SelectorItemCollection sic = new SelectorItemCollection();
                            sic.add(new SelectorItemInfo("*"));
                            sic.add(new SelectorItemInfo("trace.*"));
                            sic.add(new SelectorItemInfo("startTrace.*"));
                            stpInfo = StockTransferPlanFactory.getLocalInstance(ctx).getStockTransferPlanInfo((IObjectPK)new ObjectUuidPK(fid), sic);
                            StringBuffer sqls = new StringBuffer();
                            sqls.setLength(0);
                            sqls.append("select 1 from T_BOT_Relation \r\n");
                            sqls.append("where FSRCObjectID= '");
                            sqls.append(fplandetialid);
                            sqls.append("'and FDESTObjectID= '");
                            sqls.append(fid);
                            sqls.append("';");
                            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqls.toString());
                            if (rs.next()) {
                                stpInfo.setSubmitQty(FNewqty);
                            } else {
                                stpInfo.setSubmitQty(stpInfo.getSubmitQty().add(FNewqty.subtract(FOldqty)));
                            }
                        }
                        if (stpInfo.getTrace().getNumber().compareTo(ftracknumber) < 0) {
                            stpInfo.setTrace(TrackNumberInfo2);
                        }
                        if (stpInfo.getStartTrace().getNumber().compareTo(ftracknumber) > 0) {
                            stpInfo.setStartTrace(TrackNumberInfo2);
                        }
                    }
                    DetialIDList.add(fplandetialid);
                }
                if (stpInfo != null) {
                    if (isaddInfo.booleanValue()) {
                        StockTransferPlanFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)stpInfo);
                    } else {
                        StockTransferPlanFactory.getLocalInstance(ctx).save((CoreBaseInfo)stpInfo);
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return DetialIDList;
    }

    protected void setBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws EASBizException, BOSException {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        if (billNumber != null) {
            billInfo.setString("number", billNumber);
        } else if (billInfo.getString("id") != null) {
            billInfo.setString("number", "AutoNumberFromBTP_" + billInfo.getString("id").toString());
        } else {
            billInfo.setString("number", "AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        }
    }
}

