/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.pm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.common.utils.DateUtil;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class ProjPlanActCompReportServer
extends ReportServerBase {
    private Context ctx;
    private String sou;
    private String souidlist;
    private String project;
    private String projectidlist;
    private String startTime;
    private String endTime;

    protected IRowSet getReportData(String arg0, RptParams Params) throws Exception {
        this.ctx = this.getContext();
        this.initRptParams(Params);
        String tempTableResult = TempTablePool.getInstance((Context)this.getContext()).createTempTable("CREATE TABLE NEWDATA (   Fprojectname VARCHAR(80),  FOrgUnitName VARCHAR(80),  Ftype int,  FDesc VARCHAR(44)," + this.getyearandmonthSql() + "  FStorageOrgUnitId VARCHAR(44),  FProjectId VARCHAR(44)  ) \n");
        int starYear = this.getYear(this.startTime);
        int endYear = this.getYear(this.endTime);
        Date startDate = DateUtil.stringToDateFormat(this.startTime, Constants.FORMAT_MONTH);
        Date endDate = DateUtil.stringToDateFormat(this.endTime, Constants.FORMAT_MONTH);
        int month = DateUtil.getMonth(startDate, endDate) + 1;
        DbUtil.execute((Context)this.getContext(), (String)this.getInsertSqlForResult(tempTableResult, starYear, endYear, month, startDate, endDate));
        DbUtil.execute((Context)this.getContext(), (String)this.getInsertSqlForResult2(tempTableResult, starYear, endYear, month, startDate, endDate));
        IRowSet set = DbUtil.executeQuery((Context)this.getContext(), (String)this.getResultSql(tempTableResult));
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTableResult);
        return set;
    }

    private void initRptParams(RptParams params) throws BOSException {
        int i;
        if (params.getObject("storageOrgUnit") != null) {
            this.sou = (String)params.getObject("storageOrgUnit");
            String soureplace = this.sou.replace(";", "','");
            soureplace = soureplace.replace(" ", "");
            CoreBaseCollection souinfo = StorageOrgUnitFactory.getLocalInstance((Context)this.ctx).getCollection("select fid where number in ('" + soureplace + "')");
            if (souinfo != null && souinfo.size() > 0) {
                for (i = 0; i < souinfo.size(); ++i) {
                    this.souidlist = i == 0 ? "'" + souinfo.get(i).getId().toString() + "'" : this.souidlist + ",'" + souinfo.get(i).getId().toString() + "'";
                }
            }
        } else {
            this.sou = null;
            this.souidlist = null;
        }
        if (params.getObject("project") != null) {
            this.project = (String)params.getObject("project");
            String projectreplace = this.project.replace(";", "','");
            projectreplace = projectreplace.replace(" ", "");
            CoreBaseCollection projectinfo = ProjectFactory.getLocalInstance((Context)this.getContext()).getCollection("select fid,name where number in ('" + projectreplace + "')");
            if (projectinfo != null && projectinfo.size() > 0) {
                for (i = 0; i < projectinfo.size(); ++i) {
                    this.projectidlist = i == 0 ? "'" + projectinfo.get(i).getId().toString() + "'" : this.projectidlist + ",'" + projectinfo.get(i).getId().toString() + "'";
                }
            }
        } else {
            this.project = null;
            this.projectidlist = null;
        }
        this.startTime = (String)params.getObject("startTime");
        this.endTime = (String)params.getObject("endTime");
    }

    private int getYear(String time) {
        String[] strs = time.split("-");
        return Integer.parseInt(strs[0]);
    }

    private int getMonth(String time) {
        String[] strs = time.split("-");
        return Integer.parseInt(strs[1]);
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        String startTime = filter.getString("startTime");
        String endTime = filter.getString("endTime");
        int starYear = this.getYear(startTime);
        int endYear = this.getYear(endTime);
        Date startDate = DateUtil.stringToDateFormat(startTime, Constants.FORMAT_MONTH);
        Date endDate = DateUtil.stringToDateFormat(endTime, Constants.FORMAT_MONTH);
        int month = DateUtil.getMonth(startDate, endDate) + 1;
        ReportHeader reportHeader = super.getReportHeader(reportID, filter);
        ReportHeader projectName = reportHeader.addChild("Fprojectname", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0234", (Locale)this.getContext().getLocale()));
        projectName.setMergeable(true);
        projectName.setWidth(200);
        ReportHeader manufactureOrgUnit = reportHeader.addChild("FOrgUnitName", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0235", (Locale)this.getContext().getLocale()));
        manufactureOrgUnit.setMergeable(true);
        manufactureOrgUnit.setWidth(150);
        reportHeader.addChild("FDesc", "");
        for (int i = starYear; i <= endYear; ++i) {
            ReportHeader yearHeader = reportHeader.addChild("year" + i, Integer.valueOf(i).toString());
            for (int j = 1; j <= month; ++j) {
                Date curDate = null;
                curDate = i == starYear && j == 1 ? startDate : DateUtil.addMonth(startDate, j - 1);
                Calendar curCalendar = Calendar.getInstance();
                curCalendar.setTime(curDate);
                if (i != curCalendar.get(1)) continue;
                ReportHeader monthHeader = yearHeader.addChild("month" + i + j, DateUtil.DateToString(curDate, Constants.FORMAT_MONTH));
                monthHeader.addChild("monthPlan" + i + j, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0240", (Locale)this.getContext().getLocale()));
                monthHeader.addChild("monthActual" + i + j, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0241", (Locale)this.getContext().getLocale()));
            }
        }
        return reportHeader;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        int i;
        String projectname = "";
        String souname = "";
        if (filter.getString("storageOrgUnit") != null) {
            this.sou = filter.getString("storageOrgUnit");
            String soureplace = this.sou.replace(";", "','");
            soureplace = soureplace.replace(" ", "");
            CoreBaseCollection souinfo = StorageOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCollection("select fid,name where number in ('" + soureplace + "')");
            if (souinfo != null && souinfo.size() > 0) {
                for (i = 0; i < souinfo.size(); ++i) {
                    if (i == 0) {
                        this.souidlist = "'" + souinfo.get(i).getId().toString() + "'";
                        souname = souinfo.get(i).get("name").toString();
                        continue;
                    }
                    this.souidlist = this.souidlist + ",'" + souinfo.get(i).getId().toString() + "'";
                    souname = souname + " " + souinfo.get(i).get("name").toString();
                }
            }
        } else {
            this.sou = null;
            this.souidlist = null;
        }
        if (filter.getString("project") != null) {
            this.project = filter.getString("project");
            String projectreplace = this.project.replace(";", "','");
            projectreplace = projectreplace.replace(" ", "");
            CoreBaseCollection projectinfo = ProjectFactory.getLocalInstance((Context)this.getContext()).getCollection("select fid,name where number in ('" + projectreplace + "')");
            if (projectinfo != null && projectinfo.size() > 0) {
                for (i = 0; i < projectinfo.size(); ++i) {
                    if (i == 0) {
                        this.projectidlist = "'" + projectinfo.get(i).getId().toString() + "'";
                        projectname = projectinfo.get(i).get("name").toString();
                        continue;
                    }
                    this.projectidlist = this.projectidlist + ",'" + projectinfo.get(i).getId().toString() + "'";
                    projectname = projectname + " " + projectinfo.get(i).get("name").toString();
                }
            }
        } else {
            this.project = null;
            this.projectidlist = null;
        }
        String startTime = filter.getString("startTime");
        String endTime = filter.getString("endTime");
        ReportTitles reportTitles = new ReportTitles();
        reportTitles.AddTitle(0, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0263", (Locale)this.getContext().getLocale()));
        reportTitles.AddTitle(1, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0244", (Locale)this.getContext().getLocale()) + startTime.substring(0, 7));
        reportTitles.AddTitle(2, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0245", (Locale)this.getContext().getLocale()) + endTime.substring(0, 7));
        reportTitles.AddTitle(3, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0243", (Locale)this.getContext().getLocale()) + souname);
        reportTitles.AddTitle(6, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0264", (Locale)this.getContext().getLocale()) + projectname);
        return reportTitles;
    }

    private String getyearandmonthSql() throws Exception {
        StringBuffer sql = new StringBuffer();
        int starYear = this.getYear(this.startTime);
        int endYear = this.getYear(this.endTime);
        Date startDate = DateUtil.stringToDateFormat(this.startTime, Constants.FORMAT_MONTH);
        Date endDate = DateUtil.stringToDateFormat(this.endTime, Constants.FORMAT_MONTH);
        int month = DateUtil.getMonth(startDate, endDate) + 1;
        for (int i = starYear; i <= endYear; ++i) {
            for (int j = 1; j <= month; ++j) {
                Date curDate = null;
                curDate = i == starYear && j == 1 ? startDate : DateUtil.addMonth(startDate, j - 1);
                Calendar curCalendar = Calendar.getInstance();
                curCalendar.setTime(curDate);
                if (i != curCalendar.get(1)) continue;
                sql.append("monthPlan" + i + "" + j + " varchar(4000) DEFAULT('') , ");
                sql.append("monthActual" + i + "" + j + " varchar(4000) DEFAULT('') , ");
            }
        }
        return sql.toString();
    }

    private StringBuffer getInsertSqlForResult_Header(String tempTableResult) throws Exception {
        StringBuffer sql = new StringBuffer();
        int starYear = this.getYear(this.startTime);
        int endYear = this.getYear(this.endTime);
        Date startDate = DateUtil.stringToDateFormat(this.startTime, Constants.FORMAT_MONTH);
        Date endDate = DateUtil.stringToDateFormat(this.endTime, Constants.FORMAT_MONTH);
        int month = DateUtil.getMonth(startDate, endDate) + 1;
        sql.append("/*dialect*/ insert into " + tempTableResult);
        return sql;
    }

    private String getInsertSqlForResult2(String tempTableResult, int starYear, int endYear, int month, Date startDate, Date endDate) throws Exception {
        StringBuffer sql = this.getInsertSqlForResult_Header(tempTableResult);
        sql.append(" Select  \r\n");
        sql.append(" T_MM_PROJECT.FNAME_L2||'  '||T_MM_PROJECT.fnumber Fprojectname, \r\n");
        sql.append(" T_ORG_STORAGE.FNAME_L2 FOrgUnitName, \r\n");
        sql.append(" 2 As Ftype, \r\n");
        sql.append(" '").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0248", (Locale)this.getContext().getLocale())).append("' As  FDesc , \r\n");
        for (int i = starYear; i <= endYear; ++i) {
            for (int j = 1; j <= month; ++j) {
                Date curDate = null;
                curDate = i == starYear && j == 1 ? startDate : DateUtil.addMonth(startDate, j - 1);
                Calendar curCalendar = Calendar.getInstance();
                curCalendar.setTime(curDate);
                if (i != curCalendar.get(1)) continue;
                String curDateS = new SimpleDateFormat("yyyy-MM").format(curCalendar.getTime());
                sql.append(" (Select wmsys.wm_concat ( to_char(substr(ch.fnumber,length(ch.fnumber) - 3,4) ))  From CT_PM_YEARROLLINGPLANENTRYS ENTRYS inner join t_mm_tracknumber ch  on ENTRYS.CFTRACKNUMBERID = ch.fid  where  \r\n");
                sql.append(" Exists(Select 1 From CT_PM_YearRollingPlan hh where hh.fid = ENTRYS.fparentid and hh.cfbasestatus = 4  \r\n ");
                if (this.souidlist != null && !"".equals(this.souidlist)) {
                    sql.append(" and hh.CFManufactureOrgUnitID in(").append(this.souidlist).append(")  \r\n");
                }
                sql.append(" and hh.Cfprojectid = h.Cfprojectid  \r\n");
                sql.append(") ");
                sql.append(" And to_char(ENTRYS.CFFINISHTIME,'yyyy-MM') = to_char('").append(curDateS).append("')) As monthPlan").append(i + "" + j).append(",  \r\n");
                sql.append(" (Select wmsys.wm_concat ( to_char(substr(ch.fnumber,length(ch.fnumber) - 3,4) ))  From t_mm_manufactureorder a inner join t_mm_mftordertechnics b on b.fparentid = a.fid \r\n");
                sql.append(" inner join t_mm_tracknumber ch  on a.ftrackid = ch.fid \r\n");
                sql.append(" where a.fstorageorgunitid = h.CFManufactureOrgUnitID \r\n");
                sql.append(" and a.fprojectid = h.cfprojectid \r\n");
                sql.append(" And b.foperationid in(Select cfoperationid from ct_bas_prodorgoperation where cfstorageorgunitid = a.fstorageorgunitid) \r\n");
                sql.append(" And b.fbasestatus in(9,14,24) \r\n");
                sql.append(" And to_char(b.cfacmptime,'yyyy-mm') = to_char('").append(curDateS).append("')) as monthActual").append(i + "" + j).append(", \r\n");
            }
        }
        sql.append(" h.CFManufactureOrgUnitID As CFManufactureOrgUnitID, \r\n");
        sql.append(" h.Cfprojectid As Cfprojectid \r\n");
        sql.append(" from CT_PM_YearRollingPlan h \r\n");
        sql.append(" LEFT JOIN T_MM_PROJECT ON T_MM_PROJECT.FID = h.Cfprojectid  \r\n");
        sql.append(" LEFT JOIN T_ORG_STORAGE ON T_ORG_STORAGE.FID = h.CFManufactureOrgUnitID \r\n");
        sql.append(" Where h.cfbasestatus = 4 \r\n");
        if (this.souidlist != null && !"".equals(this.souidlist)) {
            sql.append(" and h.CFManufactureOrgUnitID in(").append(this.souidlist).append(")  \r\n");
        }
        if (this.projectidlist != null && !"".equals(this.projectidlist)) {
            sql.append(" and h.Cfprojectid in(").append(this.projectidlist).append(")  \r\n");
        }
        sql.append(" group by T_MM_PROJECT.FNAME_L2,T_MM_PROJECT.fnumber,T_ORG_STORAGE.FNAME_L2,h.CFManufactureOrgUnitID,h.Cfprojectid  \r\n");
        return sql.toString();
    }

    private String getInsertSqlForResult(String tempTableResult, int starYear, int endYear, int month, Date startDate, Date endDate) throws Exception {
        StringBuffer sql = this.getInsertSqlForResult_Header(tempTableResult);
        sql.append(" Select  \r\n");
        sql.append(" T_MM_PROJECT.FNAME_L2||'  '||T_MM_PROJECT.fnumber Fprojectname,  \r\n");
        sql.append(" T_ORG_STORAGE.FNAME_L2 FOrgUnitName, \r\n");
        sql.append(" 1 As Ftype, \r\n");
        sql.append(" '").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0247", (Locale)this.getContext().getLocale())).append("' As  Ftype , \r\n");
        for (int i = starYear; i <= endYear; ++i) {
            for (int j = 1; j <= month; ++j) {
                Date curDate = null;
                curDate = i == starYear && j == 1 ? startDate : DateUtil.addMonth(startDate, j - 1);
                Calendar curCalendar = Calendar.getInstance();
                curCalendar.setTime(curDate);
                if (i != curCalendar.get(1)) continue;
                String curDateS = new SimpleDateFormat("yyyy-MM").format(curCalendar.getTime());
                sql.append(" to_char((Select Count(distinct(Cftracknumberid)) From CT_PM_YEARROLLINGPLANENTRYS ENTRYS where  \r\n");
                sql.append(" Exists(Select 1 From CT_PM_YearRollingPlan hh where hh.fid = ENTRYS.fparentid and hh.cfbasestatus = 4  \r\n ");
                if (this.souidlist != null && !"".equals(this.souidlist)) {
                    sql.append(" and hh.CFManufactureOrgUnitID in(").append(this.souidlist).append(")  \r\n");
                }
                sql.append(" and hh.Cfprojectid = h.Cfprojectid  \r\n");
                sql.append(") ");
                sql.append(" And to_char(ENTRYS.CFFINISHTIME,'yyyy-MM') = to_char('").append(curDateS).append("'))) As monthPlan").append(i + "" + j).append(",  \r\n");
                sql.append(" to_char((Select Count(distinct(a.ftrackid)) From t_mm_manufactureorder a inner join t_mm_mftordertechnics b on b.fparentid = a.fid \r\n");
                sql.append(" where a.fstorageorgunitid = h.CFManufactureOrgUnitID \r\n");
                sql.append(" and a.fprojectid = h.cfprojectid \r\n");
                sql.append(" And b.foperationid in(Select cfoperationid from ct_bas_prodorgoperation where cfstorageorgunitid = a.fstorageorgunitid) \r\n");
                sql.append(" And b.fbasestatus in(9,14,24) \r\n");
                sql.append(" And  to_char(b.cfacmptime,'yyyy-mm') = to_char('").append(curDateS).append("') )) as monthActual").append(i + "" + j).append(", \r\n");
            }
        }
        sql.append(" h.CFManufactureOrgUnitID As CFManufactureOrgUnitID, \r\n");
        sql.append(" h.Cfprojectid As Cfprojectid \r\n");
        sql.append(" from CT_PM_YearRollingPlan h \r\n");
        sql.append(" LEFT JOIN T_MM_PROJECT ON T_MM_PROJECT.FID = h.Cfprojectid  \r\n");
        sql.append(" LEFT JOIN T_ORG_STORAGE ON T_ORG_STORAGE.FID = h.CFManufactureOrgUnitID \r\n");
        sql.append(" Where h.cfbasestatus = 4 \r\n");
        if (this.souidlist != null && !"".equals(this.souidlist)) {
            sql.append(" and h.CFManufactureOrgUnitID in(").append(this.souidlist).append(")  \r\n");
        }
        if (this.projectidlist != null && !"".equals(this.projectidlist)) {
            sql.append(" and h.Cfprojectid in(").append(this.projectidlist).append(")  \r\n");
        }
        sql.append(" group by T_MM_PROJECT.FNAME_L2,T_MM_PROJECT.fnumber,T_ORG_STORAGE.FNAME_L2,h.CFManufactureOrgUnitID,h.Cfprojectid  \r\n");
        return sql.toString();
    }

    private String getResultSql(String tempTableResult) throws Exception {
        Calendar curCalendar;
        Date curDate;
        int j;
        int i;
        StringBuffer sql = new StringBuffer();
        int starYear = this.getYear(this.startTime);
        int endYear = this.getYear(this.endTime);
        Date startDate = DateUtil.stringToDateFormat(this.startTime, Constants.FORMAT_MONTH);
        Date endDate = DateUtil.stringToDateFormat(this.endTime, Constants.FORMAT_MONTH);
        int month = DateUtil.getMonth(startDate, endDate) + 1;
        sql.append("/*dialect*/ delete from ").append(tempTableResult);
        sql.append(" where Fprojectid in(Select a.Fprojectid from ").append(tempTableResult).append(" a ");
        sql.append(" where a.ftype = 1  ");
        for (i = starYear; i <= endYear; ++i) {
            for (j = 1; j <= month; ++j) {
                curDate = null;
                curDate = i == starYear && j == 1 ? startDate : DateUtil.addMonth(startDate, j - 1);
                curCalendar = Calendar.getInstance();
                curCalendar.setTime(curDate);
                if (i != curCalendar.get(1)) continue;
                sql.append(" and a.monthPlan").append(i + "" + j).append(" = '0'  \r\n");
                sql.append("and a.monthActual").append(i + "" + j).append(" = '0' \r\n");
            }
        }
        sql.append("and exists(Select 1 from   ").append(tempTableResult).append(" b ");
        sql.append(" where b.fstorageorgunitid = a.fstorageorgunitid and b.fprojectid = a.fprojectid and b.ftype = 2 ");
        for (i = starYear; i <= endYear; ++i) {
            for (j = 1; j <= month; ++j) {
                curDate = null;
                curDate = i == starYear && j == 1 ? startDate : DateUtil.addMonth(startDate, j - 1);
                curCalendar = Calendar.getInstance();
                curCalendar.setTime(curDate);
                if (i != curCalendar.get(1)) continue;
                sql.append(" and b.monthPlan").append(i + "" + j).append(" is null  \r\n");
                sql.append("and b.monthActual").append(i + "" + j).append(" is null \r\n");
            }
        }
        sql.append(" )) ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
        sql.delete(0, sql.length());
        sql.append("/*dialect*/ select Fprojectname,FOrgUnitName,FDesc,");
        for (i = starYear; i <= endYear; ++i) {
            for (j = 1; j <= month; ++j) {
                curDate = null;
                curDate = i == starYear && j == 1 ? startDate : DateUtil.addMonth(startDate, j - 1);
                curCalendar = Calendar.getInstance();
                curCalendar.setTime(curDate);
                if (i != curCalendar.get(1)) continue;
                sql.append("monthPlan").append(i + "" + j).append(",  \r\n");
                sql.append("monthActual").append(i + "" + j).append(", \r\n");
            }
        }
        sql.append(" FStorageOrgUnitId from " + tempTableResult);
        sql.append(" order by Fprojectname,FOrgUnitName,Ftype ");
        return sql.toString();
    }
}

