/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.ps.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.netctrl.MutexServiceControlFacadeFactory;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectEntryInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.zj.DivisionWarehouseFacadeFactory;
import com.kingdee.eas.basedata.zj.SqlExcFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.emm.basedata.projectjch.ProjectJCHInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.LineResult;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.industry.emm.imm.DHProjectDetailPlanFactory;
import com.kingdee.eas.industry.emm.imm.DHProjectDetailPlanInfo;
import com.kingdee.eas.industry.emm.mm.basedata.DailyOutputUtils;
import com.kingdee.eas.industry.emm.mm.basedata.OperationScheduleUtils;
import com.kingdee.eas.industry.emm.mm.mo.ManufactureOrderFacadeFactory;
import com.kingdee.eas.industry.emm.mm.pm.DivisionManufacturePlanFactory;
import com.kingdee.eas.industry.emm.mm.pm.DivisionManufacturePlanInfo;
import com.kingdee.eas.industry.emm.mm.ps.MasterProductionSchedule;
import com.kingdee.eas.industry.emm.mm.ps.MasterProductionScheduleCollection;
import com.kingdee.eas.industry.emm.mm.ps.MasterProductionScheduleFacadeFactory;
import com.kingdee.eas.industry.emm.mm.ps.MasterProductionScheduleFactory;
import com.kingdee.eas.industry.emm.mm.ps.MasterProductionScheduleInfo;
import com.kingdee.eas.industry.emm.mm.ps.ProductTypeEnum;
import com.kingdee.eas.industry.emm.mm.ps.ScheduleTypeEnum;
import com.kingdee.eas.industry.emm.mm.ps.WorkshopSchedule;
import com.kingdee.eas.industry.emm.mm.ps.WorkshopScheduleCollection;
import com.kingdee.eas.industry.emm.mm.ps.WorkshopScheduleFactory;
import com.kingdee.eas.industry.emm.mm.ps.WorkshopScheduleInfo;
import com.kingdee.eas.industry.emm.mm.ps.app.AbstractMasterProductionScheduleControllerBean;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomCollection;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.FactoryCalendarInfo;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.common.util.ParamUtil;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.ManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.util.MOProductTransactionTypeUtil;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTaskFactory;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.app.EMMInvUtils;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MasterProductionScheduleControllerBean
extends AbstractMasterProductionScheduleControllerBean
implements IBatchExecute {
    private static final long serialVersionUID = -1855209403544566451L;
    private String RESURL = "com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource";
    CompanyOrgUnitInfo company = null;
    CtrlUnitInfo cu = null;

    public void batchCheck(Context context, BatchActionEnum batchactionenum, BatchActionResults batchactionresults) throws BOSException, EASBizException {
    }

    public void batchExecute(Context context, BatchActionEnum batchactionenum, BatchActionResults batchactionresults) throws BOSException, EASBizException {
    }

    public int executeSQL(Context ctx, String sql) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            long startTime = System.currentTimeMillis();
            int effectedRows = statement.executeUpdate(sql);
            long endTime = System.currentTimeMillis();
            long duration = (endTime - startTime) / 1000L;
            System.out.println("Execute SQL Effected Rows " + effectedRows + " Duration " + duration + " Sec:\r\n" + sql.toString());
            int n = effectedRows;
            return n;
        }
        catch (SQLException e) {
            throw new BOSException(sql, (Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    public int[] executeSQLBatch(Context ctx, String[] sqls) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            for (String sql : sqls) {
                statement.addBatch(sql);
            }
            long startTime = System.currentTimeMillis();
            int[] effectedRows = statement.executeBatch();
            long endTime = System.currentTimeMillis();
            long duration = (endTime - startTime) / 1000L;
            System.out.println("Execute Batch SQL Effected Rows " + effectedRows + " Duration " + duration + " Sec:\r\n" + sqls.toString());
            int[] nArray = effectedRows;
            return nArray;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    @Override
    protected void _assign(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MasterProductionScheduleInfo billInfo;
        boolean isEnabled = ServiceManagerFactory.getServiceManager().isEnable("LOG_SERVICE");
        if (isEnabled) {
            ServiceManagerFactory.getServiceManager().disableService("LOG_SERVICE");
        }
        StringBuffer errorMessage = new StringBuffer();
        errorMessage.setLength(0);
        if (pk != null && (billInfo = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleInfo(pk)) != null && billInfo.getId() != null) {
            DHProjectDetailPlanInfo pdp;
            String traceNumber;
            String projectID;
            ProductTransactionTypeInfo productTranType;
            String productName;
            List allChildMPSIDList;
            String childMPSDeadLoop;
            Map resultMap = MasterProductionScheduleFacadeFactory.getLocalInstance(ctx).checkChildMPSDeadLoop(billInfo);
            String string = resultMap == null ? null : (resultMap.containsKey("ChildMPSDeadLoop") ? (resultMap.get("ChildMPSDeadLoop") == null ? null : resultMap.get("ChildMPSDeadLoop").toString()) : (childMPSDeadLoop = null));
            List list = resultMap == null ? null : (resultMap.containsKey("AllChildMPSIDList") ? (resultMap.get("AllChildMPSIDList") == null ? null : (resultMap.get("AllChildMPSIDList") instanceof List ? (List)resultMap.get("AllChildMPSIDList") : null)) : (allChildMPSIDList = null));
            if (childMPSDeadLoop != null && childMPSDeadLoop.toString().trim().length() > 0) {
                errorMessage.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0006", (Locale)ctx.getLocale())).append("\r\n").append(childMPSDeadLoop);
            }
            if (errorMessage.toString().trim().length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0007", (Locale)ctx.getLocale()), errorMessage.toString()));
            }
            String billNumber = billInfo.getNumber();
            StorageOrgUnitInfo storageOrgUnitInfo = billInfo.getStorageOrgUnit();
            StorageOrgUnitInfo receiveOrgUnitInfo = billInfo.getReceiveOrgUnit();
            MaterialInfo productInfo = billInfo.getProduct();
            ProjectInfo projectInfo = billInfo.getProject();
            TrackNumberInfo traceInfo = billInfo.getTrace();
            TrackNumberInfo endTraceInfo = billInfo.getEndTrace();
            Boolean isMP = billInfo.isIsMP();
            BomInfo bomInfo = billInfo.getBom();
            MaterialInfo coMaterialInfo = billInfo.getCoMaterial();
            MaterialPlanCollection materialPlanCollection = null;
            MaterialPlanInfo materialPlanInfo = null;
            FactoryCalendarInfo factoryCalendarInfo = billInfo.getFCalendar();
            ScheduleTypeEnum scheduleTypeEnum = billInfo.getScheduleType();
            ProductTypeEnum productTypeEnum = billInfo.getProductType() == null ? ProductTypeEnum.STANDARD : (billInfo.getProductType().equals((Object)ProductTypeEnum.NULL) ? ProductTypeEnum.STANDARD : billInfo.getProductType());
            BigDecimal qty = billInfo.getQty();
            Date startTime = billInfo.getStartTime() != null ? new Date(billInfo.getStartTime().getTime()) : null;
            Date finishTime = billInfo.getFinishTime() != null ? new Date(billInfo.getFinishTime().getTime()) : null;
            String sourceBillID = billInfo.getSourceBillId();
            HashMap<String, Object> param = new HashMap<String, Object>();
            ProjectJCHInfo projectJCHInfo = billInfo.getProjectJCH();
            StringBuilder sql = new StringBuilder();
            IRowSet rs = null;
            int effectedRows = 0;
            EntityViewInfo view = null;
            FilterInfo filterInfo = null;
            int leadTime = 0;
            int coMaterialLeadTime = 0;
            int days = 0;
            if (billNumber == null) {
                billNumber = "";
            }
            param.put("TopProduct", billInfo.getTopProduct());
            param.put("AllChildMPSIDList", allChildMPSIDList);
            param.put("MasterProductionScheduleID", billInfo.getId().toString());
            param.put("MasterProductionScheduleNumber", billNumber);
            if (!BillBaseStatusEnum.RELEASED.equals((Object)billInfo.getBaseStatus()) && !BillBaseStatusEnum.AUDITED.equals((Object)billInfo.getBaseStatus())) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Not_Assign_Or_Aduit", new String[]{billNumber})));
            }
            if (storageOrgUnitInfo == null || storageOrgUnitInfo.getId() == null) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_StorageOrgUnit_Null", new String[]{billNumber})));
            }
            param.put("StorageORGUnitID", storageOrgUnitInfo.getId().toString());
            CompanyOrgUnitInfo companyInfo = EMMInvUtils.getCompanyInfoByStorage((Context)ctx, (BOSUuid)storageOrgUnitInfo.getId());
            if (companyInfo != null && companyInfo.getId() != null) {
                param.put("companyID", companyInfo.getId().toString());
            }
            if (receiveOrgUnitInfo != null && receiveOrgUnitInfo.getId() != null) {
                param.put("ReceiveORGUnitID", receiveOrgUnitInfo.getId().toString());
            }
            String productID = productInfo == null ? null : (productInfo.getId() == null ? null : productInfo.getId().toString());
            productInfo = IndustryUtils.isEmptyString(productID) ? null : MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(productID));
            String productNumber = productInfo == null ? null : productInfo.getNumber();
            String string2 = productName = productInfo == null ? null : productInfo.getName();
            if (IndustryUtils.isEmptyString((String)productID)) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_Product_Null", new String[]{billNumber})));
            }
            param.put("ProductID", productID);
            param.put("ProductNumber", productNumber);
            param.put("ProductName", productName);
            MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(productInfo.getId()));
            StorageOrgUnitInfo storageOrgInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageOrgUnitInfo.getId()));
            MaterialPlanInfo materialPlan = this.getMaterialPlanInfo(ctx, materialInfo, storageOrgInfo);
            ProductTransactionTypeInfo productTransactionTypeInfo = productTranType = materialPlan == null ? null : MOProductTransactionTypeUtil.getDefaultTransType((Context)ctx, (MaterialInfo)materialInfo, (MaterialPlanInfo)materialPlan, (StorageOrgUnitInfo)storageOrgInfo, (AdminOrgUnitInfo)materialPlan.getDutyDepartment(), (String)"vGXRx5fFSsCYz9Zv7CzzgyQHQ1w=");
            if (productTranType != null && !productTranType.isIsWPManagement() && materialPlan != null && materialPlan.isIsStorageLimit()) {
                param.put("isLimitedQty", true);
                if (materialPlan.getRcvInHightLimit() != null && !materialPlan.getRcvInHightLimit().equals("")) {
                    param.put("extraRatio", materialPlan.getRcvInHightLimit());
                } else {
                    param.put("extraRatio", BigDecimal.ZERO);
                }
                if (materialPlan.getRcvInLowLimit() != null && !materialPlan.getRcvInLowLimit().equals("")) {
                    param.put("lackRatio", materialPlan.getRcvInLowLimit());
                } else {
                    param.put("lackRatio", BigDecimal.ZERO);
                }
            } else {
                param.put("isLimitedQty", false);
            }
            String string3 = projectInfo == null ? null : (projectID = projectInfo.getId() == null ? null : projectInfo.getId().toString());
            if (IndustryUtils.isEmptyString(projectID)) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_Project_Null", new String[]{billNumber})));
            }
            param.put("ProjectID", projectID);
            String traceID = traceInfo == null ? null : (traceInfo.getId() == null ? null : traceInfo.getId().toString());
            traceInfo = IndustryUtils.isEmptyString(traceID) ? null : TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(traceID));
            String string4 = traceNumber = traceInfo == null ? null : traceInfo.getNumber();
            if (IndustryUtils.isEmptyString((String)traceID)) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_Trace_Null", new String[]{billNumber})));
            }
            param.put("TraceNumber", traceNumber);
            param.put("TraceID", traceID);
            String endTraceID = endTraceInfo == null ? null : (endTraceInfo.getId() == null ? null : endTraceInfo.getId().toString());
            endTraceInfo = IndustryUtils.isEmptyString(endTraceID) ? null : TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(endTraceID));
            String endTraceNumber = endTraceInfo == null ? null : endTraceInfo.getNumber();
            param.put("EndTraceNumber", endTraceNumber);
            param.put("EndTraceID", endTraceID);
            param.put("IsMP", isMP);
            if (isMP.booleanValue()) {
                if (endTraceInfo == null) {
                    String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DJJSGZHBT_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{billNumber});
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), strInfo));
                }
                if (traceNumber != null && endTraceNumber != null && traceNumber.compareTo(endTraceNumber) > 0) {
                    String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DJGZHBXXYDYJSGZH_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{billNumber});
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), strInfo));
                }
            }
            if (bomInfo == null || bomInfo.getId() == null) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_BOM_Null", new String[]{billNumber})));
            }
            param.put("BOMID", bomInfo.getId().toString());
            if (factoryCalendarInfo == null || factoryCalendarInfo.getId() == null) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FactoryCalendar_Null", new String[]{billNumber})));
            }
            param.put("FactoryCalendarID", factoryCalendarInfo.getId().toString());
            if (scheduleTypeEnum == null || ScheduleTypeEnum.NULL.equals((Object)scheduleTypeEnum)) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_Null_ScheduleType", new String[]{billNumber})));
            }
            param.put("ScheduleType", scheduleTypeEnum.getAlias());
            if (productTypeEnum == null || ProductTypeEnum.NULL.equals((Object)productTypeEnum)) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_Null_ProductType", new String[]{billNumber})));
            }
            param.put("ProductType", productTypeEnum.getAlias());
            if (projectJCHInfo != null && projectJCHInfo.getId() != null) {
                param.put("ProjectJCHID", projectJCHInfo.getId().toString());
            }
            if (qty == null || qty.compareTo(new BigDecimal("0")) <= 0) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_QTY_Null", new String[]{billNumber})));
            }
            param.put("QTY", qty.toString());
            if (startTime == null) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_StartTime_Null", new String[]{billNumber})));
            }
            param.put("StartTime", new Timestamp(startTime.getTime()));
            param.put("OriginalStartTime", new Timestamp(startTime.getTime()));
            if (finishTime == null) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FinishTime_Null", new String[]{billNumber})));
            }
            param.put("FinishTime", new Timestamp(finishTime.getTime()));
            if (sourceBillID != null && sourceBillID.trim().length() > 0 && BOSUuid.getBOSObjectType((String)sourceBillID, (boolean)false).equals((Object)new DHProjectDetailPlanInfo().getBOSType()) && (pdp = DHProjectDetailPlanFactory.getLocalInstance((Context)ctx).getDHProjectDetailPlanInfo((IObjectPK)new ObjectUuidPK(sourceBillID))) != null && pdp.getScheduledComDate() != null) {
                Date sourceBillFinishTime = pdp.getScheduledComDate();
                if (OperationScheduleUtils.sdfDate.format(finishTime).compareTo(OperationScheduleUtils.sdfDate.format(sourceBillFinishTime)) > 0) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FinishTime_Must_Less_Equal_Then_SourceBill_FinishTime", new String[]{billNumber, OperationScheduleUtils.sdfDate.format(sourceBillFinishTime)})));
                }
            }
            if (coMaterialInfo == null || coMaterialInfo.getId() == null) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_COMaterial_Null", new String[]{billNumber})));
            }
            param.put("COMaterialID", coMaterialInfo.getId().toString());
            if (!UsedStatusEnum.APPROVED.equals((Object)productInfo.getStatus())) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_Product_Not_Approved", new String[]{billNumber})));
            }
            coMaterialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(coMaterialInfo.getId().toString()));
            view = new EntityViewInfo();
            filterInfo = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("fid"));
            view.setSelector(sic);
            filterInfo.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)coMaterialInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1));
            view.setFilter(filterInfo);
            MaterialCompanyInfoCollection materialCompanyColl = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(view);
            if (materialCompanyColl == null || materialCompanyColl.size() == 0) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0009", (Locale)ctx.getLocale())));
            }
            if (!UsedStatusEnum.APPROVED.equals((Object)coMaterialInfo.getStatus())) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_COMaterial_Not_Approved", new String[]{billNumber})));
            }
            try {
                if (!BomFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(bomInfo.getId().toString()))) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_BOM_Not_Exists", new String[]{billNumber})));
                }
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_BOM_Not_Exists", new String[]{billNumber})));
            }
            bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(bomInfo.getId().toString()));
            if (!BillBaseStatusEnum.AUDITED.equals((Object)bomInfo.getBaseStatus())) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_BOM_Not_Audit", new String[]{billNumber})));
            }
            if (!bomInfo.getBomType().equals((Object)BOMTypeEnum.CfgBOM)) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_BOM_Not_Configurable", new String[]{billNumber})));
            }
            if (bomInfo.getMaterial() == null || !productInfo.getId().toString().equals(bomInfo.getMaterial().getId().toString())) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_BOM_Material_Change", new String[]{billNumber})));
            }
            if (bomInfo.getProject() == null || !projectInfo.getId().toString().equals(bomInfo.getProject().getId().toString())) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_BOM_Project_Change", new String[]{billNumber})));
            }
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("BE.FID\r\n");
            sql.append("From T_MM_BomEntry BE\r\n");
            sql.append("Inner Join T_MM_TrackNumber BTN On BTN.FID=BE.CFBeginCarNOID\r\n");
            sql.append("Inner Join T_MM_TrackNumber ETN On ETN.FID=BE.CFEndCarNOID\r\n");
            sql.append("Where\r\n");
            sql.append("BE.FParentID='").append(bomInfo.getId().toString()).append("'\r\n");
            sql.append("And BTN.FNumber<='").append(traceInfo.getNumber()).append("'\r\n");
            sql.append("And ETN.FNumber>='").append(traceInfo.getNumber()).append("'\r\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs == null || rs.size() == 0) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_BOM_Trace_Change", new String[]{billNumber})));
            }
            String mpsactnrString = this.getParamValue(ctx, "MPSACTNR", param.get("StorageORGUnitID").toString());
            Boolean mpsactnr = mpsactnrString == null ? false : "true".equals(mpsactnrString);
            param.put("MPSACTNR", mpsactnr);
            if (mpsactnr.booleanValue() && !IndustryUtils.isEmptyString((String)traceNumber)) {
                int becc;
                sql.setLength(0);
                sql.append("Select ");
                sql.append("id, ");
                sql.append("parent.id, ");
                sql.append("parent.number, ");
                sql.append("beginCarno.id, ");
                sql.append("beginCarno.number, ");
                sql.append("endCarno.id, ");
                sql.append("endCarno.number ");
                sql.append("Where ");
                sql.append("parent.project.id='").append(projectID).append("' ");
                sql.append("And material.id='").append(productID).append("' ");
                sql.append("And beginCarno.id Is Not Null ");
                sql.append("And endCarno.id Is Not Null ");
                if (!IndustryUtils.isEmptyString((String)endTraceID) && !IndustryUtils.isEmptyString((String)endTraceNumber)) {
                    sql.append("And ( ");
                    sql.append("beginCarno.number>'").append(traceNumber).append("' ");
                    sql.append("Or endCarno.number<'").append(endTraceNumber).append("' ");
                    sql.append(") ");
                } else {
                    sql.append("And ( ");
                    sql.append("beginCarno.number>'").append(traceNumber).append("' ");
                    sql.append("Or endCarno.number<'").append(traceNumber).append("' ");
                    sql.append(") ");
                }
                BomEntryCollection bec = BomEntryFactory.getLocalInstance((Context)ctx).getBomEntryCollection(sql.toString());
                if (bec != null && (becc = bec.size()) > 0) {
                    for (int beci = 0; beci < becc; ++beci) {
                        String etniNumber;
                        String etniID;
                        TrackNumberInfo etni;
                        String stniID;
                        TrackNumberInfo stni;
                        String biID;
                        BomInfo bi;
                        BomEntryInfo bei = bec.get(beci);
                        BomInfo bomInfo2 = bi = bei == null ? null : bei.getParent();
                        String string5 = bi == null ? null : (biID = bi.getId() == null ? null : bi.getId().toString());
                        String biNumber = bi == null ? "" : (bi.getNumber() == null ? "" : bi.getNumber());
                        TrackNumberInfo trackNumberInfo = stni = bei == null ? null : bei.getBeginCarno();
                        String string6 = stni == null ? null : (stniID = stni.getId() == null ? null : stni.getId().toString());
                        String stniNumber = stni == null ? "" : (stni.getNumber() == null ? "" : stni.getNumber());
                        TrackNumberInfo trackNumberInfo2 = etni = bei == null ? null : bei.getEndCarno();
                        String string7 = etni == null ? null : (etniID = etni.getId() == null ? null : etni.getId().toString());
                        String string8 = etni == null ? "" : (etniNumber = etni.getNumber() == null ? "" : etni.getNumber());
                        if (IndustryUtils.isEmptyString((String)biID) || IndustryUtils.isEmptyString((String)stniID) || IndustryUtils.isEmptyString((String)etniID)) continue;
                        String strInfo = ResourceBase.getString((String)this.RESURL, (String)"ZJHDGZHDCGBOM_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{billNumber, biNumber, stniNumber, etniNumber});
                        errorMessage.append(strInfo).append("\r\n");
                    }
                }
                if (errorMessage.toString().trim().length() > 0) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0010", (Locale)ctx.getLocale()), errorMessage.toString()));
                }
            }
            view = new EntityViewInfo();
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)productInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgunit.id", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            view.setFilter(filterInfo);
            materialPlanCollection = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(view);
            if (materialPlanCollection != null && materialPlanCollection.size() > 0 && materialPlanCollection.get(0) != null && materialPlanCollection.get(0) instanceof MaterialPlanInfo) {
                materialPlanInfo = materialPlanCollection.get(0);
                leadTime = materialPlanInfo.getProduceLeadTime();
            }
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("FCE.FWorkDate \"FWorkDate\"\r\n");
            sql.append("From T_MM_FactoryCalendarEntry FCE \r\n");
            sql.append("Inner Join T_MM_FactoryCalendar FC On FC.FID=FCE.FParentID \r\n");
            sql.append("Where\r\n");
            sql.append("FCE.FParentID='").append(param.get("FactoryCalendarID").toString()).append("'\r\n");
            sql.append("And (\r\n");
            sql.append("FCE.FDateType=").append(1).append("\r\n");
            sql.append("Or FCE.FDateType=").append(4).append("\r\n");
            sql.append(")\r\n");
            sql.append("And To_CHAR(FCE.FWorkDate,'YYYY-MM-DD')>='").append(OperationScheduleUtils.sdfDate.format(finishTime)).append("'\r\n");
            sql.append("Order By\r\n");
            sql.append("FCE.FWorkDate ASC\r\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs == null || rs.size() == 0) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FactoryCalendar_Not_Contain_FinishTime", new String[]{billNumber, OperationScheduleUtils.sdfDateTime.format(finishTime)})));
            }
            try {
                rs.next();
                finishTime.setTime(OperationScheduleUtils.sdfDateTime.parse(OperationScheduleUtils.sdfDate.format(rs.getDate("FWorkDate")) + " " + OperationScheduleUtils.sdfTime.format(finishTime)).getTime());
                param.put("FinishTime", new Timestamp(OperationScheduleUtils.sdfDateTime.parse(OperationScheduleUtils.sdfDate.format(rs.getDate("FWorkDate")) + " " + OperationScheduleUtils.sdfTime.format(finishTime)).getTime()));
                param.put("COMaterialFinishTime", new Timestamp(OperationScheduleUtils.sdfDateTime.parse(OperationScheduleUtils.sdfDate.format(rs.getDate("FWorkDate")) + " " + OperationScheduleUtils.sdfTime.format(finishTime)).getTime()));
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("FCE.FWorkDate \"FWorkDate\"\r\n");
            sql.append("From T_MM_FactoryCalendarEntry FCE \r\n");
            sql.append("Inner Join T_MM_FactoryCalendar FC On FC.FID=FCE.FParentID \r\n");
            sql.append("Where\r\n");
            sql.append("FCE.FParentID='").append(param.get("FactoryCalendarID").toString()).append("'\r\n");
            sql.append("And (\r\n");
            sql.append("FCE.FDateType=").append(1).append("\r\n");
            sql.append("Or FCE.FDateType=").append(4).append("\r\n");
            sql.append(")\r\n");
            sql.append("And To_CHAR(FCE.FWorkDate,'YYYY-MM-DD')<='").append(OperationScheduleUtils.sdfDate.format(finishTime)).append("'\r\n");
            sql.append("Order By\r\n");
            sql.append("FCE.FWorkDate DESC\r\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs == null || rs.size() == 0) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FactoryCalendar_Not_Contain_FinishTime", new String[]{billNumber, OperationScheduleUtils.sdfDateTime.format(finishTime)})));
            }
            try {
                days = 0;
                while (rs.next()) {
                    if (days == leadTime) {
                        startTime.setTime(OperationScheduleUtils.sdfDateTime.parse(OperationScheduleUtils.sdfDate.format(rs.getDate("FWorkDate")) + " " + OperationScheduleUtils.sdfTime.format(finishTime)).getTime());
                        param.put("StartTime", new Timestamp(OperationScheduleUtils.sdfDateTime.parse(OperationScheduleUtils.sdfDate.format(rs.getDate("FWorkDate")) + " " + OperationScheduleUtils.sdfTime.format(finishTime)).getTime()));
                        break;
                    }
                    ++days;
                }
                if (days < leadTime) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FactoryCalendar_Not_Contain_CStartTime", new String[]{billNumber})));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
            view = new EntityViewInfo();
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)coMaterialInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgunit.id", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            view.setFilter(filterInfo);
            materialPlanCollection = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(view);
            if (materialPlanCollection != null && materialPlanCollection.size() > 0 && materialPlanCollection.get(0) != null && materialPlanCollection.get(0) instanceof MaterialPlanInfo) {
                materialPlanInfo = materialPlanCollection.get(0);
                coMaterialLeadTime = materialPlanInfo.getProduceLeadTime();
                if (materialPlanInfo.getDutyDepartment() == null) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_COMaterial_Plan_DutyDepartment_Null", new String[]{billNumber})));
                }
            } else {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_COMaterial_Plan_Null", new String[]{billNumber})));
            }
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("FCE.FWorkDate \"FWorkDate\"\r\n");
            sql.append("From T_MM_FactoryCalendarEntry FCE \r\n");
            sql.append("Inner Join T_MM_FactoryCalendar FC On FC.FID=FCE.FParentID \r\n");
            sql.append("Where\r\n");
            sql.append("FCE.FParentID='").append(param.get("FactoryCalendarID").toString()).append("'\r\n");
            sql.append("And (\r\n");
            sql.append("FCE.FDateType=").append(1).append("\r\n");
            sql.append("Or FCE.FDateType=").append(4).append("\r\n");
            sql.append(")\r\n");
            sql.append("And To_CHAR(FCE.FWorkDate,'YYYY-MM-DD')<='").append(OperationScheduleUtils.sdfDate.format(finishTime)).append("'\r\n");
            sql.append("Order By\r\n");
            sql.append("FCE.FWorkDate DESC\r\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs == null || rs.size() == 0) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FactoryCalendar_Not_Contain_FinishTime", new String[]{billNumber, OperationScheduleUtils.sdfDateTime.format(finishTime)})));
            }
            try {
                days = 0;
                while (rs.next()) {
                    if (days == coMaterialLeadTime) {
                        param.put("COMaterialStartTime", new Timestamp(OperationScheduleUtils.sdfDateTime.parse(OperationScheduleUtils.sdfDate.format(rs.getDate("FWorkDate")) + " " + OperationScheduleUtils.sdfTime.format(finishTime)).getTime()));
                        break;
                    }
                    ++days;
                }
                if (days < coMaterialLeadTime) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FactoryCalendar_Not_Contain_CCMStartTime", new String[]{billNumber})));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
            try {
                List newMOIDList;
                String isMPSAssignUseFallbackBOMNumberString;
                ArrayList<String> orsIDList = new ArrayList<String>();
                String scheduleTempTableName = null;
                sql.setLength(0);
                sql.append("Select\r\n");
                sql.append("ORS.FID \"FID\"\r\n");
                sql.append("From CT_BAS_OperationRS ORS\r\n");
                sql.append("Inner Join CT_BAS_OperationRSE ORSE On ORSE.FParentID=ORS.FID\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And ORS.CFStorageOrgUnitID='").append(param.get("StorageORGUnitID").toString()).append("'\r\n");
                sql.append("And ORS.CFProductID='").append(param.get("ProductID").toString()).append("'\r\n");
                sql.append("And ORS.CFProjectID='").append(param.get("ProjectID").toString()).append("'\r\n");
                sql.append("And ORS.CFWorkCenterID Is Null\r\n");
                sql.append("And ORS.CFBaseStatus=").append(4).append("\r\n");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs != null && rs.size() > 0) {
                    rs.next();
                    orsIDList.add(rs.getString("FID"));
                } else {
                    sql.setLength(0);
                    sql.append("Select\r\n");
                    sql.append("ORS.FID \"FID\"\r\n");
                    sql.append("From CT_BAS_OperationRS ORS\r\n");
                    sql.append("Inner Join CT_BAS_OperationRSE ORSE On ORSE.FParentID=ORS.FID\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And ORS.CFStorageOrgUnitID='").append(param.get("StorageORGUnitID").toString()).append("'\r\n");
                    sql.append("And ORS.CFProductID='").append(param.get("ProductID").toString()).append("'\r\n");
                    sql.append("And ORS.CFProjectID='").append(param.get("ProjectID").toString()).append("'\r\n");
                    sql.append("And ORS.CFWorkCenterID Is Not Null\r\n");
                    sql.append("And ORS.CFBaseStatus=").append(4).append("\r\n");
                    sql.append("Group By\r\n");
                    sql.append("ORS.FID\r\n");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    while (rs.next()) {
                        if (orsIDList.contains(rs.getString("FID"))) continue;
                        orsIDList.add(rs.getString("FID"));
                    }
                }
                if (orsIDList != null && orsIDList.size() > 0) {
                    param.put("ORSIDList", orsIDList);
                    scheduleTempTableName = this.createScheduleTempTable(ctx);
                    param.put("ScheduleTempTableName", scheduleTempTableName);
                    this.orsSchedule(ctx, param);
                }
                this.removeManufactureOrder(ctx, param);
                this.removeWorkshopSchedule(ctx, param);
                this.removeBOTPRelation(ctx, param.get("MasterProductionScheduleID").toString());
                String tempTableName = null;
                tempTableName = this.createTempTable(ctx);
                param.put("TempTableName", tempTableName);
                if (!param.get("COMaterialID").toString().equals(param.get("ProductID").toString())) {
                    this.expandCOMaterial(ctx, param);
                }
                Boolean isMPSAssignUseFallbackBOMNumber = (isMPSAssignUseFallbackBOMNumberString = this.getParamValue(ctx, "MPSANCSBOMDFBBOM", param.get("StorageORGUnitID").toString())) == null ? false : "true".equals(isMPSAssignUseFallbackBOMNumberString);
                param.put("MPSANCSBOMDFBBOM", isMPSAssignUseFallbackBOMNumber);
                String fallbackBOMNumber = this.getParamValue(ctx, "MPSAFBBOM", param == null ? null : (param.containsKey("StorageORGUnitID") ? (param.get("StorageORGUnitID") == null ? null : param.get("StorageORGUnitID").toString()) : null));
                param.put("FallbackBOMNumber", fallbackBOMNumber);
                if (this.expandTop(ctx, param) > 0) {
                    this.expandChild(ctx, param);
                    if (param.containsKey("ReceiveORGUnitID") && param.get("ReceiveORGUnitID") != null) {
                        String deleteTempTableName = this.createDeleteTempTable(ctx);
                        param.put("DeleteTempTableName", deleteTempTableName);
                        sql.setLength(0);
                        sql.append(this.insertDeleteTempTableSQL(deleteTempTableName));
                        sql.append("Select\r\n");
                        sql.append("T.FID\r\n");
                        sql.append("From ").append(param.get("TempTableName").toString()).append(" T\r\n");
                        sql.append("Left Join ").append(param.get("TempTableName").toString()).append(" PT On IsNull(PT.FLevel,0)=IsNull(T.FLevel,0) -1\r\n");
                        sql.append("Left Join T_MM_BOM PB On PB.FID=PT.FBOMID\r\n");
                        sql.append("Where\r\n");
                        sql.append("1=1\r\n");
                        sql.append("And T.FLevel>=1\r\n");
                        sql.append("And CHARIndex(' ' || PT.FID || ' ',T.FParentID)>0\r\n");
                        sql.append("And PB.FStorageORGUnitID<>'").append(param.get("ReceiveORGUnitID").toString()).append("'\r\n");
                        effectedRows = this.executeSQL(ctx, sql.toString());
                        if (effectedRows > 0) {
                            sql.setLength(0);
                            sql.append("Update ").append(param.get("TempTableName").toString()).append(" UT\r\n");
                            sql.append("Set FDeleted=1\r\n");
                            sql.append("Where\r\n");
                            sql.append("1=1\r\n");
                            sql.append("And UT.FID In (\r\n");
                            sql.append("Select\r\n");
                            sql.append("T.FID\r\n");
                            sql.append("From ").append(deleteTempTableName).append(" T\r\n");
                            sql.append("Where\r\n");
                            sql.append("1=1\r\n");
                            sql.append(")\r\n");
                            effectedRows = this.executeSQL(ctx, sql.toString());
                        }
                    }
                } else {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_Top_Product_Not_Exists_Routing", new String[]{billNumber})));
                }
                this.removeTempTableInvalidData(ctx, tempTableName);
                this.mergeTempTable(ctx, param);
                this.generateManufactureOrder(ctx, param);
                this.generateManufactureOrderTechnics(ctx, param);
                this.generateManufactureOrderStock(ctx, param);
                Boolean isMSEIssueModeFromBomEntry = IndustryUtils.getMapBooleanData(param, (Object)"MPSAMSEIMFromBE");
                this.updateMOSDatas(ctx, new IObjectPK[]{pk}, isMSEIssueModeFromBomEntry);
                this.generateManufactureOrderExpectOutput(ctx, param);
                this.generateCostObject(ctx, param);
                this.updateProjectTask(ctx, param);
                List list2 = param.containsKey("NewMOIDList") ? (param.get("NewMOIDList") == null ? null : (param.get("NewMOIDList") instanceof List ? (List)param.get("NewMOIDList") : null)) : (newMOIDList = null);
                if (newMOIDList != null && newMOIDList.size() > 0) {
                    sql.setLength(0);
                    sql.append("Update T_MM_ManufactureOrder UT\r\n");
                    sql.append("Set\r\n");
                    sql.append("FSourceBillID=FMPSID,\r\n");
                    sql.append("FBaseStatus=").append(4).append("\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And UT.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
                    sql.append("And UT.FID In (\r\n");
                    sql.append(SQLUtil.arrayToString((Object[])newMOIDList.toArray()));
                    sql.append(")\r\n");
                    this.executeSQL(ctx, sql.toString());
                }
                this.generateWorkshopSchedule(ctx, param);
                this.updateTechnicsEntryTime(ctx, param);
                this.generateBOTPRelation(ctx, param);
                this.motTransferOpenItem(ctx, param);
                this.processChangeVersion(ctx, param);
            }
            catch (EASBizException e) {
                throw e;
            }
            catch (BOSException e) {
                throw e;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                this.releaseTempTable(ctx, param);
            }
            billInfo.setBaseStatus(BillBaseStatusEnum.RELEASED);
            billInfo.setAssignTime(new Date());
            billInfo.setAssignUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            super._update(ctx, pk, (IObjectValue)billInfo);
        }
        if (isEnabled) {
            ServiceManagerFactory.getServiceManager().enableService("LOG_SERVICE");
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer errorMessage = new StringBuffer();
        if (pk != null) {
            MasterProductionScheduleInfo billInfo = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleInfo(pk);
            String billNumber = null;
            if (billInfo != null) {
                String childMPSDeadLoop;
                Map resultMap = MasterProductionScheduleFacadeFactory.getLocalInstance(ctx).checkChildMPSDeadLoop(billInfo);
                Object object = resultMap == null ? null : (resultMap.containsKey("ChildMPSDeadLoop") ? (resultMap.get("ChildMPSDeadLoop") == null ? null : resultMap.get("ChildMPSDeadLoop").toString()) : (childMPSDeadLoop = null));
                if (childMPSDeadLoop != null && childMPSDeadLoop.toString().trim().length() > 0) {
                    errorMessage.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0011", (Locale)ctx.getLocale())).append("\r\n").append(childMPSDeadLoop);
                }
                if (errorMessage.toString().trim().length() > 0) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0007", (Locale)ctx.getLocale()), errorMessage.toString()));
                }
                billNumber = billInfo.getNumber();
                if (billNumber == null) {
                    billNumber = "";
                }
                if (!BillBaseStatusEnum.SUBMITED.equals((Object)billInfo.getBaseStatus())) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0012", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Not_Submit_ListUI", new String[]{billNumber})));
                }
                Date finishTime = new Date(billInfo.getFinishTime().getTime());
                String sourceBillID = billInfo.getSourceBillId();
                String billID = null;
                if ((sourceBillID == null || sourceBillID.trim().length() == 0) && billInfo.getId() != null && billInfo.getId().toString().trim().length() > 0) {
                    billID = billInfo.getId().toString();
                    MasterProductionScheduleInfo mps = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleInfo((IObjectPK)new ObjectUuidPK(billID));
                    if (mps != null && mps.getSourceBillId() != null && mps.getSourceBillId().trim().length() > 0) {
                        sourceBillID = mps.getSourceBillId();
                    }
                }
                if (sourceBillID != null && sourceBillID.trim().length() > 0) {
                    DivisionManufacturePlanInfo dmpInfo;
                    if (BOSUuid.getBOSObjectType((String)sourceBillID, (boolean)false).equals((Object)new DHProjectDetailPlanInfo().getBOSType())) {
                        DHProjectDetailPlanInfo pdp = DHProjectDetailPlanFactory.getLocalInstance((Context)ctx).getDHProjectDetailPlanInfo((IObjectPK)new ObjectUuidPK(sourceBillID));
                        if (pdp != null && pdp.getScheduledComDate() != null) {
                            Date sourceBillFinishTime = pdp.getScheduledComDate();
                            if (OperationScheduleUtils.sdfDate.format(finishTime).compareTo(OperationScheduleUtils.sdfDate.format(sourceBillFinishTime)) > 0) {
                                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FinishTime_Must_Less_Equal_Then_PDP_FinishTime", new String[]{billNumber, OperationScheduleUtils.sdfDate.format(sourceBillFinishTime)})));
                            }
                        }
                    } else if (BOSUuid.getBOSObjectType((String)sourceBillID, (boolean)false).equals((Object)new ProjectTaskInfo().getBOSType())) {
                        ProjectTaskInfo pt = ProjectTaskFactory.getLocalInstance((Context)ctx).getProjectTaskInfo((IObjectPK)new ObjectUuidPK(sourceBillID));
                        if (pt != null && pt.getPlanEndTime() != null) {
                            Timestamp sourceBillFinishTime = pt.getPlanEndTime();
                            if (OperationScheduleUtils.sdfDate.format(finishTime).compareTo(OperationScheduleUtils.sdfDate.format(sourceBillFinishTime)) > 0) {
                                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FinishTime_Must_Less_Equal_Then_PT_FinishTime", new String[]{billNumber, OperationScheduleUtils.sdfDate.format(sourceBillFinishTime)})));
                            }
                        }
                    } else if (BOSUuid.getBOSObjectType((String)sourceBillID, (boolean)false).equals((Object)new DivisionManufacturePlanInfo().getBOSType()) && (dmpInfo = DivisionManufacturePlanFactory.getLocalInstance(ctx).getDivisionManufacturePlanInfo((IObjectPK)new ObjectUuidPK(sourceBillID))) != null && dmpInfo.getFinishTime() != null) {
                        Timestamp sourceBillFinishTime = dmpInfo.getFinishTime();
                        if (OperationScheduleUtils.sdfDate.format(finishTime).compareTo(OperationScheduleUtils.sdfDate.format(sourceBillFinishTime)) > 0) {
                            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"ZJHDJHWGSJDYWCSJ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{billNumber, OperationScheduleUtils.sdfDate.format(sourceBillFinishTime)});
                            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), strInfo));
                        }
                    }
                }
                billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
                billInfo.setAuditTime(new Date());
                billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
                super._update(ctx, pk, (IObjectValue)billInfo);
            }
        }
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            MasterProductionScheduleInfo billInfo = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleInfo(pk);
            this._cancel(ctx, pk, (IObjectValue)billInfo);
        }
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model != null) {
            MasterProductionScheduleInfo billInfo = (MasterProductionScheduleInfo)model;
            String billNumber = null;
            if (billInfo != null) {
                billNumber = billInfo.getNumber();
                if (billNumber == null) {
                    billNumber = "";
                }
                if (!BillBaseStatusEnum.RELEASED.equals((Object)billInfo.getBaseStatus())) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0013", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Not_Assign_ListUI", new String[]{billNumber})));
                }
                billInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
                billInfo.setShutDownTime(new Date());
                billInfo.setShutDownUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                super._update(ctx, pk, (IObjectValue)billInfo);
            }
        }
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            MasterProductionScheduleInfo billInfo = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleInfo(pk);
            this._cancelCancel(ctx, pk, (IObjectValue)billInfo);
        }
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model != null) {
            MasterProductionScheduleInfo billInfo = (MasterProductionScheduleInfo)model;
            String billNumber = null;
            if (billInfo != null) {
                billNumber = billInfo.getNumber();
                if (billNumber == null) {
                    billNumber = "";
                }
                if (!BillBaseStatusEnum.CLOSED.equals((Object)billInfo.getBaseStatus())) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0014", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Not_ShutDown_ListUI", new String[]{billNumber})));
                }
                billInfo.setBaseStatus(BillBaseStatusEnum.RELEASED);
                billInfo.setShutDownTime(null);
                billInfo.setShutDownUser(null);
                super._update(ctx, pk, (IObjectValue)billInfo);
            }
        }
    }

    @Override
    protected String _checkIsAdjustDateOverRange(Context ctx, List idList) throws BOSException, EASBizException {
        StringBuffer errorMessage = new StringBuffer();
        if (idList == null || idList.size() == 0) {
            return errorMessage.toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("MPS.FNumber \"FNumber\",\r\n");
        sql.append("MPS.CFScheduleType \"FScheduleType\",\r\n");
        sql.append("Case IsNull(MPS.CFScheduleType,0)\r\n");
        sql.append("When ").append(1).append(" Then\r\n");
        sql.append("(\r\n");
        sql.append("Select\r\n");
        sql.append("To_CHAR(MAX(MOTE.FEarlistCMPTime),'YYYY-MM-DD')\r\n");
        sql.append("From T_MM_MFTOrderTechnics MOTE\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MOTE.FParentID=MO.FID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FSourceBillID=MPS.FID\r\n");
        sql.append("And IsNull(MO.FBaseStatus,0) In (\r\n");
        sql.append(0).append(",\r\n");
        sql.append(1).append(",\r\n");
        sql.append(2).append(",\r\n");
        sql.append(4).append("\r\n");
        sql.append(")\r\n");
        sql.append("And MOTE.FEarlistCMPTime Is Not Null\r\n");
        sql.append(")\r\n");
        sql.append("When ").append(2).append(" Then\r\n");
        sql.append("(\r\n");
        sql.append("Select\r\n");
        sql.append("To_CHAR(MIN(MOTE.FEarlistWOKTime),'YYYY-MM-DD')\r\n");
        sql.append("From T_MM_MFTOrderTechnics MOTE\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MOTE.FParentID=MO.FID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FSourceBillID=MPS.FID\r\n");
        sql.append("And IsNull(MO.FBaseStatus,0) In (\r\n");
        sql.append(0).append(",\r\n");
        sql.append(1).append(",\r\n");
        sql.append(2).append(",\r\n");
        sql.append(4).append("\r\n");
        sql.append(")\r\n");
        sql.append("And MOTE.FEarlistWOKTime Is Not Null\r\n");
        sql.append(")\r\n");
        sql.append("End \"FAdjustDate\",\r\n");
        sql.append("Case MPS.CFScheduleType\r\n");
        sql.append("When ").append(1).append(" Then To_CHAR(MPS.CFFinishTime,'YYYY-MM-DD')\r\n");
        sql.append("When ").append(2).append(" Then To_CHAR(MPS.CFStartTime,'YYYY-MM-DD')\r\n");
        sql.append("End \"FPlanDate\"\r\n");
        sql.append("From CT_PS_MasterProductionSchedule MPS\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MPS.FID In (\r\n");
        sql.append(SQLUtil.arrayToString((Object[])idList.toArray()));
        sql.append(")\r\n");
        sql.append("And (\r\n");
        sql.append("(\r\n");
        sql.append("IsNull(MPS.CFScheduleType,0)=").append(1).append("\r\n");
        sql.append("And IsNull((\r\n");
        sql.append("Select\r\n");
        sql.append("To_CHAR(Max(MOTE.FEarlistCMPTime),'YYYY-MM-DD')\r\n");
        sql.append("From T_MM_MFTOrderTechnics MOTE\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MOTE.FParentID=MO.FID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FSourceBillID=MPS.FID\r\n");
        sql.append("And IsNull(MO.FBaseStatus,0) In (\r\n");
        sql.append(0).append(",\r\n");
        sql.append(1).append(",\r\n");
        sql.append(2).append(",\r\n");
        sql.append(4).append("\r\n");
        sql.append(")\r\n");
        sql.append("),'0000-00-00')\r\n");
        sql.append(">\r\n");
        sql.append("IsNull(To_CHAR(MPS.CFFinishTime,'YYYY-MM-DD'),'0000-00-00')\r\n");
        sql.append(")\r\n");
        sql.append("Or\r\n");
        sql.append("(\r\n");
        sql.append("IsNull(MPS.CFScheduleType,0)=").append(2).append("\r\n");
        sql.append("And IsNull((\r\n");
        sql.append("Select\r\n");
        sql.append("To_CHAR(Min(MOTE.FEarlistWOKTime),'YYYY-MM-DD')\r\n");
        sql.append("From T_MM_MFTOrderTechnics MOTE\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MOTE.FParentID=MO.FID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FSourceBillID=MPS.FID\r\n");
        sql.append("And IsNull(MO.FBaseStatus,0) In (\r\n");
        sql.append(0).append(",\r\n");
        sql.append(1).append(",\r\n");
        sql.append(2).append(",\r\n");
        sql.append(4).append("\r\n");
        sql.append(")\r\n");
        sql.append("),'0000-00-00')\r\n");
        sql.append("<\r\n");
        sql.append("IsNull(To_CHAR(MPS.CFStartTime,'YYYY-MM-DD'),'0000-00-00')\r\n");
        sql.append(")\r\n");
        sql.append(")\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs != null && rs.size() > 0) {
                while (rs.next()) {
                    String strInfo;
                    String number = rs.getString("FNumber") == null ? "" : rs.getString("FNumber");
                    int scheduleType = rs.getInt("FScheduleType");
                    String adjustTime = rs.getString("FAdjustDate");
                    String planTime = rs.getString("FPlanDate");
                    if (adjustTime == null || planTime == null || adjustTime.trim().length() == 0 || planTime.trim().length() == 0) continue;
                    if (1 == scheduleType) {
                        strInfo = ResourceBase.getString((String)this.RESURL, (String)"ZJHPCLXTZHDZDWGSJ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{number, ScheduleTypeEnum.SF.getAlias(), adjustTime, planTime});
                        errorMessage.append(strInfo).append("\r\n");
                        continue;
                    }
                    if (2 != scheduleType) continue;
                    strInfo = ResourceBase.getString((String)this.RESURL, (String)"ZJHPCLXTZHDZXKGSJ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{number, ScheduleTypeEnum.SF.getAlias(), adjustTime, planTime});
                    errorMessage.append(strInfo).append("\r\n");
                }
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return errorMessage.toString();
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            MasterProductionScheduleInfo billInfo = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleInfo(pk);
            String billNumber = null;
            if (billInfo != null) {
                billNumber = billInfo.getNumber();
                if (billNumber == null) {
                    billNumber = "";
                }
                if (!(BillBaseStatusEnum.ADD.equals((Object)billInfo.getBaseStatus()) || BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)billInfo.getBaseStatus()) || BillBaseStatusEnum.SUBMITED.equals((Object)billInfo.getBaseStatus()))) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0015", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Not_Add_Save_Submit_ListUI", new String[]{billNumber})));
                }
            }
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _regenerateMOS(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            Boolean isMSEIssueModeFromBomEntry;
            String mosersTempTable;
            String mosewhgTempTable;
            String jgjmosewhTempTable;
            String mosewhTempTable;
            String addMOSETempTable;
            String addMOMOTempTable;
            String curMOMOTempTable;
            String newMOMOTempTable;
            String newMOSETempTable;
            block75: {
                Boolean isWarehouseFromBOMEntry;
                Boolean isMOSWarehouseFromOrderStorageOrgUnit;
                String pbomEntryBOMEntryTempTable;
                String storageOrgUnitID;
                block73: {
                    block74: {
                        int insertRows;
                        StringBuffer sql;
                        block71: {
                            block72: {
                                String id;
                                block69: {
                                    block70: {
                                        block67: {
                                            block68: {
                                                MasterProductionScheduleInfo billInfo = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleInfo(pk);
                                                id = pk.toString();
                                                storageOrgUnitID = billInfo != null && billInfo.getStorageOrgUnit() != null && billInfo.getStorageOrgUnit().getId() != null ? billInfo.getStorageOrgUnit().getId().toString() : "Null";
                                                sql = new StringBuffer();
                                                insertRows = 0;
                                                pbomEntryBOMEntryTempTable = null;
                                                newMOSETempTable = null;
                                                newMOMOTempTable = null;
                                                curMOMOTempTable = null;
                                                addMOMOTempTable = null;
                                                addMOSETempTable = null;
                                                mosewhTempTable = null;
                                                jgjmosewhTempTable = null;
                                                mosewhgTempTable = null;
                                                mosersTempTable = null;
                                                String isMSEIssueModeFromBomEntryString = this.getParamValue(ctx, "MPSAMSEIMFromBE", storageOrgUnitID);
                                                isMSEIssueModeFromBomEntry = isMSEIssueModeFromBomEntryString == null ? false : "true".equals(isMSEIssueModeFromBomEntryString);
                                                String isMOSWarehouseFromOrderStorageOrgUnitValue = this.getParamValue(ctx, "MPSGMOSWFOS", storageOrgUnitID);
                                                isMOSWarehouseFromOrderStorageOrgUnit = isMOSWarehouseFromOrderStorageOrgUnitValue == null ? false : "true".equals(isMOSWarehouseFromOrderStorageOrgUnitValue);
                                                ctx.put((Object)"eventSource", (Object)"REGENETATEMOS");
                                                pbomEntryBOMEntryTempTable = this.createPBOMEntryBOMEntryTempTable(ctx);
                                                sql.setLength(0);
                                                sql.append(this.insertPBOMEntryBOMEntryTempTableSQL(pbomEntryBOMEntryTempTable));
                                                sql.append("Select\r\n");
                                                sql.append("PBE.FID,\r\n");
                                                sql.append("Max(BE.FID)\r\n");
                                                sql.append("From T_MM_ManufactureOrder MO\r\n");
                                                sql.append("Inner Join T_MM_PBOM PB On\r\n");
                                                sql.append("1=1\r\n");
                                                sql.append("And PB.FRoutingID=MO.FRoutingID\r\n");
                                                sql.append("And PB.FBOMID=MO.FBOMID\r\n");
                                                sql.append("Inner Join T_MM_PBOMEntry PBE On PBE.FParentID=PB.FID\r\n");
                                                sql.append("Inner Join T_MM_BOMEntry BE On\r\n");
                                                sql.append("1=1\r\n");
                                                sql.append("And BE.FParentID=PBE.CFBOMID\r\n");
                                                sql.append("And BE.FMaterialID=PBE.CFMaterialID\r\n");
                                                sql.append("Left Join T_MM_TrackNumber TN On TN.FID=MO.FTrackID\r\n");
                                                sql.append("Left Join T_MM_TrackNumber STN On STN.FID=PBE.CFSTraceID\r\n");
                                                sql.append("Left Join T_MM_TrackNumber ETN On ETN.FID=PBE.CFETraceID\r\n");
                                                sql.append("Left Join T_MM_TrackNumber BSTN On BSTN.FID=BE.CFBeginCarNOID\r\n");
                                                sql.append("Left Join T_MM_TrackNumber BETN On BETN.FID=BE.CFEndCarNOID\r\n");
                                                sql.append("Where\r\n");
                                                sql.append("1=1\r\n");
                                                sql.append("And MO.FSourceBillID='").append(id).append("'\r\n");
                                                sql.append("And IsNull(STN.FNumber,'Null')<=IsNull(ETN.FNumber,'Null')\r\n");
                                                sql.append("And IsNull(STN.FNumber,'Null')<=IsNull(TN.FNumber,'Null')\r\n");
                                                sql.append("And IsNull(ETN.FNumber,'Null')>=IsNull(TN.FNumber,'Null')\r\n");
                                                sql.append("And IsNull(BSTN.FNumber,'Null')<=IsNull(TN.FNumber,'Null')\r\n");
                                                sql.append("And IsNull(BETN.FNumber,'Null')>=IsNull(TN.FNumber,'Null')\r\n");
                                                sql.append("Group By\r\n");
                                                sql.append("PBE.FID\r\n");
                                                this.executeSQL(ctx, sql.toString());
                                                String isWarehouseFromBOMEntryValue = this.getParamValue(ctx, "GMOSWHFBOM", storageOrgUnitID);
                                                isWarehouseFromBOMEntry = isWarehouseFromBOMEntryValue == null ? false : "true".equals(isWarehouseFromBOMEntryValue);
                                                sql.setLength(0);
                                                newMOSETempTable = this.createNewMOSETempTable(ctx);
                                                sql.append(this.insertNewMOSETempTableSQL(newMOSETempTable));
                                                sql.append("SELECT\r\n");
                                                sql.append("NEWBOSID('ED498839'),\r\n");
                                                sql.append("MO.FID,\r\n");
                                                sql.append("PBE.CFMATERIALID,\r\n");
                                                sql.append("Null,\r\n");
                                                sql.append("Null,\r\n");
                                                sql.append("Case\r\n");
                                                sql.append("When BE.FID Is Null Then M.FBaseUnit\r\n");
                                                sql.append("Else BE.FUnitID\r\n");
                                                sql.append("End,\r\n");
                                                sql.append("Case\r\n");
                                                sql.append("When BE.FID Is Null Then M.FBaseUnit\r\n");
                                                sql.append("Else BE.FBaseUnitID\r\n");
                                                sql.append("End,\r\n");
                                                sql.append("Null,\r\n");
                                                sql.append("Null,\r\n");
                                                if (isWarehouseFromBOMEntry.booleanValue()) {
                                                    sql.append("BE.FDefaultWarehouseID,\r\n");
                                                } else {
                                                    sql.append("Null,\r\n");
                                                }
                                                sql.append("BE.FTransferWarehouseID,\r\n");
                                                sql.append("Null,\r\n");
                                                sql.append("Case\r\n");
                                                sql.append("When BE.FID Is Null Then Null\r\n");
                                                sql.append("Else\r\n");
                                                sql.append("\tCase\r\n");
                                                sql.append("\tWhen BE.FLocationID Is Null\r\n");
                                                sql.append("\tAnd IsNull(BE.FIsBackFlush,0)=1\r\n");
                                                sql.append("\tAnd IsNull(MO.FTransactionTypeID,'Null')<>'Null'\r\n");
                                                sql.append("\tAnd IsNull(PTT.FDefaultBFWarehouseID,'Null')=IsNull(BE.FDefaultWarehouseID,'Null')\r\n");
                                                sql.append("\tAnd IsNull(PTT.FDefaultBFLocationID,'Null')<>'Null'\r\n");
                                                sql.append("\tThen PTT.FDefaultBFLocationID\r\n");
                                                sql.append("\tElse BE.FLocationID\r\n");
                                                sql.append("\tEnd\r\n");
                                                sql.append("End,\r\n");
                                                sql.append("MRWP.FOPERATIONID,\r\n");
                                                sql.append("BE.FSupplyStorageOrgUnitID,\r\n");
                                                sql.append("Case\r\n");
                                                sql.append("When BE.FTransferOrgUnitID Is Null Then BE.FSupplyStorageOrgUnitID\r\n");
                                                sql.append("Else BE.FTransferOrgUnitID\r\n");
                                                sql.append("End,\r\n");
                                                sql.append("Null,\r\n");
                                                sql.append("BE.FID,\r\n");
                                                sql.append("PBE.FID,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("Case\r\n");
                                                sql.append("When BE.FID Is Null Then 0\r\n");
                                                sql.append("Else To_Decimal((BE.FScrapRatio/100),21,8)\r\n");
                                                sql.append("End,\r\n");
                                                sql.append("CASE\r\n");
                                                sql.append("WHEN ISNULL(MP.FISQUOTACONTROL,0)=1 THEN ISNULL(MP.FISSINHIGHTLIMIT,0)\r\n");
                                                sql.append("ELSE 0\r\n");
                                                sql.append("END,\r\n");
                                                sql.append("CASE\r\n");
                                                sql.append("WHEN ISNULL(MP.FISQUOTACONTROL,0)=1 THEN ISNULL(MP.FISSINLOWLIMIT,0)\r\n");
                                                sql.append("ELSE 0\r\n");
                                                sql.append("END,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("Case\r\n");
                                                sql.append("When BE.FID Is Null Then PBE.CFConsumeQuota * MO.FQTY\r\n");
                                                sql.append("Else\r\n");
                                                sql.append("\tCase\r\n");
                                                sql.append("\tWhen BE.FConsumeType=").append(20).append(" Then\r\n");
                                                sql.append("\tRound((((1/BOM.FProductQty) * PBE.CFConsumeQuota) * MO.FCONVRate) * MO.FQTY,IsNull(MU.FQTYPrecision,0))\r\n");
                                                sql.append("\tElse\r\n");
                                                sql.append("\tRound((((((BOM.FProductBaseQty/BE.FBaseProductRate)/BE.FBaseRate)*(BE.FProportion * 0.01)) / BOM.FProductQty) * MO.FCONVRate) * MO.FQTY,IsNull(MU.FQTYPrecision,0))\r\n");
                                                sql.append("\tEnd\r\n");
                                                sql.append("End,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("Case\r\n");
                                                sql.append("When BE.FID Is Null Then PBE.CFConsumeQuota * MO.FQTY\r\n");
                                                sql.append("Else\r\n");
                                                sql.append("\tCase\r\n");
                                                sql.append("\tWhen IsNull(MP.FScrapRateExpression,0)=").append(10610).append(" Then\r\n");
                                                sql.append("\t\tCase\r\n");
                                                sql.append("\t\tWhen BE.FConsumeType=").append(20).append(" Then\r\n");
                                                sql.append("\t\tRound((((((1/BOM.FProductQty) * PBE.CFConsumeQuota) * MO.FCONVRate) * MO.FQTY)/1) -IsNull(BE.FScrapRatio,0),IsNull(MU.FQTYPrecision,0))\r\n");
                                                sql.append("\t\tElse\r\n");
                                                sql.append("\t\tRound((((((((BOM.FProductBaseQty/BE.FBaseProductRate)/BE.FBaseRate)*(BE.FProportion * 0.01)) / BOM.FProductQty) * MO.FCONVRate) * MO.FQTY)/1) -IsNull(BE.FScrapRatio,0),IsNull(MU.FQTYPrecision,0))\r\n");
                                                sql.append("\t\tEnd\r\n");
                                                sql.append("\tElse\r\n");
                                                sql.append("\t\tCase\r\n");
                                                sql.append("\t\tWhen BE.FConsumeType=").append(20).append(" Then\r\n");
                                                sql.append("\t\tRound(((((1/BOM.FProductQty) * PBE.CFConsumeQuota) * MO.FCONVRate) * MO.FQTY)+IsNull(BE.FScrapRatio,0),IsNull(MU.FQTYPrecision,0))\r\n");
                                                sql.append("\t\tElse\r\n");
                                                sql.append("\t\tRound(((((((BOM.FProductBaseQty/BE.FBaseProductRate)/BE.FBaseRate)*(BE.FProportion * 0.01)) / BOM.FProductQty) * MO.FCONVRate) * MO.FQTY)+IsNull(BE.FScrapRatio,0),IsNull(MU.FQTYPrecision,0))\r\n");
                                                sql.append("\t\tEnd\r\n");
                                                sql.append("\tEnd\r\n");
                                                sql.append("End,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("Case\r\n");
                                                sql.append("When BE.FID Is Null Then PBE.CFConsumeQuota\r\n");
                                                sql.append("Else\r\n");
                                                sql.append("\tCase\r\n");
                                                sql.append("\tWhen BE.FConsumeType=").append(20).append(" Then\r\n");
                                                sql.append("\tTo_Decimal(((1/BOM.FProductQty) * PBE.CFConsumeQuota) * MO.FCONVRate,21,8)\r\n");
                                                sql.append("\tElse\r\n");
                                                sql.append("\tTo_Decimal(((((BOM.FProductBaseQty/BE.FBaseProductRate)/BE.FBaseRate)*(BE.FProportion * 0.01)) / BOM.FProductQty) * MO.FCONVRate,21,8)\r\n");
                                                sql.append("\tEnd\r\n");
                                                sql.append("End,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("MO.FPLANBEGINDATE,\r\n");
                                                sql.append("Null,\r\n");
                                                sql.append("BE.FBLKSize,\r\n");
                                                sql.append("BE.FSpecifiedLength,\r\n");
                                                sql.append("BE.FBluePrint_").append(ctx.getLocale()).append(",\r\n");
                                                sql.append("ISNULL(PBE.FSEQ,0),\r\n");
                                                sql.append("ISNULL(PBE.FSEQ,0) * 10,\r\n");
                                                sql.append("Case\r\n");
                                                sql.append("When IsNull(MO.FBaseStatus,0)<=2 Then ").append(2).append("\r\n");
                                                sql.append("Else ").append(4).append("\r\n");
                                                sql.append("End,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("Null,\r\n");
                                                sql.append("Case\r\n");
                                                sql.append("When BE.FID Is Null Then ").append(10910).append("\r\n");
                                                sql.append("Else BE.FProvideType\r\n");
                                                sql.append("End,\r\n");
                                                sql.append("Null,\r\n");
                                                sql.append("MP.FSCRAPRATEEXPRESSION,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("IsNull(BE.FNetWeight,0),\r\n");
                                                sql.append("ISNULL(MRWP.FWPSEQ,MSEQ.FMAXWPSEQ),\r\n");
                                                sql.append("BE.FIssMode,\r\n");
                                                sql.append("0,\r\n");
                                                sql.append("IsNull(BE.FIsBackFlush,0),\r\n");
                                                sql.append("IsNull(MP.FIsQuotaControl,0),\r\n");
                                                sql.append("IsNull(BE.FIsStockTransfer,0),\r\n");
                                                sql.append("IsNull(PBE.cfismustreq,0),\r\n");
                                                sql.append("ISNULL(MI.CFISLINESTOREHOUSE,0),\r\n");
                                                sql.append("ISNULL(PBE.CFISOWNOBJECT,0)\r\n");
                                                sql.append("FROM (\r\n");
                                                sql.append("SELECT\r\n");
                                                sql.append("MOMP.FID FID,\r\n");
                                                sql.append("MOMP.FTRANSACTIONTYPEID FTRANSACTIONTYPEID,\r\n");
                                                sql.append("MOMP.FSTORAGEORGUNITID FSTORAGEORGUNITID,\r\n");
                                                sql.append("MOMP.FTRACKID FTRACKID,\r\n");
                                                sql.append("MOMP.FROUTINGID FROUTINGID,\r\n");
                                                sql.append("MOMP.FBOMID FBOMID,\r\n");
                                                sql.append("MOMP.FPLANBEGINDATE FPLANBEGINDATE,\r\n");
                                                sql.append("MOMP.FPROJECTID FPROJECTID,\r\n");
                                                sql.append("MOMP.FNUMBER FNUMBER,\r\n");
                                                sql.append("MOMP.FQTY FQTY,\r\n");
                                                sql.append("MOMP.FBaseStatus FBaseStatus,\r\n");
                                                sql.append("CASE\r\n");
                                                sql.append("WHEN (MOMP.FBILLCONVRATE IS NOT NULL) AND (MOMP.FPRODUCTCONVRATE IS NOT NULL) THEN\r\n");
                                                sql.append("\tCASE\r\n");
                                                sql.append("\tWHEN ISNULL(MOMP.FBILLCONVRATE,0)=0 OR ISNULL(MOMP.FPRODUCTCONVRATE,0)=0 THEN 0\r\n");
                                                sql.append("\tELSE ROUND(ISNULL(MOMP.FBILLCONVRATE,0)/ISNULL(MOMP.FPRODUCTCONVRATE,0),8)\r\n");
                                                sql.append("\tEND\r\n");
                                                sql.append("ELSE 1\r\n");
                                                sql.append("END FCONVRATE\r\n");
                                                sql.append("FROM(\r\n");
                                                sql.append("\tSELECT\r\n");
                                                sql.append("\tMO.FID FID,\r\n");
                                                sql.append("\tMO.FTRANSACTIONTYPEID FTRANSACTIONTYPEID,\r\n");
                                                sql.append("\tMO.FSTORAGEORGUNITID FSTORAGEORGUNITID,\r\n");
                                                sql.append("\tMO.FTRACKID FTRACKID,\r\n");
                                                sql.append("\tMO.FROUTINGID FROUTINGID,\r\n");
                                                sql.append("\tMO.FBOMID FBOMID,\r\n");
                                                sql.append("\tMO.FPLANBEGINDATE FPLANBEGINDATE,\r\n");
                                                sql.append("\tMO.FPROJECTID FPROJECTID,\r\n");
                                                sql.append("\tMO.FNUMBER FNUMBER,\r\n");
                                                sql.append("\tMO.FQTY FQTY,\r\n");
                                                sql.append("\tMO.FBaseStatus FBaseStatus,\r\n");
                                                sql.append("\t(\r\n");
                                                sql.append("\tSELECT\r\n");
                                                sql.append("\tTop 1\r\n");
                                                sql.append("\tCMU.FBASECONVSRATE\r\n");
                                                sql.append("\tFROM T_BD_MULTIMEASUREUNIT CMU\r\n");
                                                sql.append("\tWHERE\r\n");
                                                sql.append("\t1=1\r\n");
                                                sql.append("\tAND CMU.FMATERIALID=MO.FMATERIALID\r\n");
                                                sql.append("\tAND CMU.FMEASUREUNITID=MO.FUNITID\r\n");
                                                sql.append("\t) FBILLCONVRATE,\r\n");
                                                sql.append("\t(\r\n");
                                                sql.append("\tSELECT\r\n");
                                                sql.append("\tTop 1\r\n");
                                                sql.append("\tCMU.FBASECONVSRATE\r\n");
                                                sql.append("\tFROM T_BD_MULTIMEASUREUNIT CMU\r\n");
                                                sql.append("\tWHERE\r\n");
                                                sql.append("\t1=1\r\n");
                                                sql.append("\tAND CMU.FMATERIALID=MO.FMATERIALID\r\n");
                                                sql.append("\tAND CMU.FMEASUREUNITID=MP.FPRODUCTUNITID\r\n");
                                                sql.append("\t) FPRODUCTCONVRATE\r\n");
                                                sql.append("\tFROM T_MM_MANUFACTUREORDER MO\r\n");
                                                sql.append("\tINNER JOIN CT_PS_MASTERPRODUCTIONSCHEDULE MPS ON MPS.FID=MO.FSOURCEBILLID\r\n");
                                                sql.append("\tLEFT JOIN T_BD_MATERIALPLAN MP ON MO.FMATERIALID=MP.FMATERIALID AND MP.FORGUNIT=MO.FSTORAGEORGUNITID\r\n");
                                                sql.append("\tWHERE\r\n");
                                                sql.append("\t1=1\r\n");
                                                sql.append("\tAND MPS.FID='").append(id).append("'\r\n");
                                                sql.append(") MOMP\r\n");
                                                sql.append(") MO\r\n");
                                                sql.append("LEFT JOIN T_MM_PRODUCTTRANSACTIONTYPE PTT ON PTT.FID=MO.FTRANSACTIONTYPEID\r\n");
                                                sql.append("INNER JOIN T_MM_BOM MOBOM ON MOBOM.FID=MO.FBOMID\r\n");
                                                sql.append("INNER JOIN T_MM_PROJECT P ON P.FID=MO.FPROJECTID\r\n");
                                                sql.append("INNER JOIN T_MM_TRACKNUMBER TN ON TN.FID=MO.FTRACKID\r\n");
                                                sql.append("INNER JOIN T_MM_STANDARDROOTING SR ON SR.FID=MO.FROUTINGID\r\n");
                                                sql.append("INNER JOIN (\r\n");
                                                sql.append("SELECT\r\n");
                                                sql.append("TMRWP.FPARENTID FMATERIALROOTINGID,\r\n");
                                                sql.append("ISNULL(MAX(TMRWP.FWPSEQ),0) FMAXWPSEQ\r\n");
                                                sql.append("FROM T_MM_MATERIALRWP TMRWP\r\n");
                                                sql.append("GROUP BY\r\n");
                                                sql.append("TMRWP.FPARENTID\r\n");
                                                sql.append(") MSEQ ON MSEQ.FMATERIALROOTINGID=SR.FMATERIALROOTINGID\r\n");
                                                sql.append("INNER JOIN T_MM_PBOM PB ON\r\n");
                                                sql.append("1=1\r\n");
                                                sql.append("AND PB.FROUTINGID=MO.FROUTINGID\r\n");
                                                sql.append("AND PB.FBOMID=MO.FBOMID\r\n");
                                                sql.append("INNER JOIN T_MM_BOM PBBOM ON PBBOM.FID=PB.FBOMID\r\n");
                                                sql.append("INNER JOIN T_MM_PBOMENTRY PBE ON PBE.FPARENTID=PB.FID\r\n");
                                                sql.append("Inner Join T_BD_Material M On M.FID=PBE.CFMaterialID\r\n");
                                                sql.append("LEFT JOIN T_MM_MATERIALRWP MRWP ON MRWP.FID=PBE.FROUTINGITEMID\r\n");
                                                sql.append("Left Join ").append(pbomEntryBOMEntryTempTable).append(" PBEBE On PBEBE.FPBOMEntryID=PBE.FID\r\n");
                                                sql.append("Left Join T_MM_BOMEntry BE On BE.FID=PBEBE.FBOMEntryID\r\n");
                                                sql.append("INNER JOIN T_MM_BOM BOM ON BOM.FID=PBE.CFBOMID\r\n");
                                                sql.append("Left JOIN T_BD_MULTIMEASUREUNIT MU ON PBE.CFMATERIALID=MU.FMATERIALID AND BE.FUNITID=MU.FMEASUREUNITID \r\n");
                                                sql.append("INNER JOIN T_BD_MATERIALPLAN MP ON PBE.CFMATERIALID=MP.FMATERIALID AND MP.FORGUNIT=MO.FSTORAGEORGUNITID\r\n");
                                                sql.append("LEFT JOIN T_BD_MATERIALINVENTORY MI ON PBE.CFMATERIALID=MI.FMATERIALID AND MI.FORGUNIT=MO.FSTORAGEORGUNITID\r\n");
                                                sql.append("LEFT JOIN T_BD_MATERIALINVENTORY MIBEMBES ON PBE.CFMATERIALID=MIBEMBES.FMATERIALID AND MIBEMBES.FORGUNIT=BE.FSUPPLYSTORAGEORGUNITID\r\n");
                                                sql.append("LEFT JOIN T_MM_TRACKNUMBER STN ON STN.FID=PBE.CFSTRACEID\r\n");
                                                sql.append("LEFT JOIN T_MM_TRACKNUMBER ETN ON ETN.FID=PBE.CFETRACEID\r\n");
                                                sql.append("WHERE\r\n");
                                                sql.append("1=1\r\n");
                                                String isEnabledBEEDTimeValue = this.getParamValue(ctx, "GMOSBEEDT", storageOrgUnitID);
                                                Boolean isEnabledBEEDTime = isEnabledBEEDTimeValue == null ? false : "true".equals(isEnabledBEEDTimeValue);
                                                if (isEnabledBEEDTime.booleanValue()) {
                                                    sql.append("AND BE.FEFFECTIVEDATE<=MO.FPLANBEGINDATE+BE.FLEADTIME\r\n");
                                                    sql.append("AND BE.FDISABLEDATE>MO.FPLANBEGINDATE+BE.FLEADTIME\r\n");
                                                }
                                                sql.append("AND ISNULL(PBE.CFMATERIALATTR,0)<>10020\r\n");
                                                sql.append("And (\r\n");
                                                sql.append("BE.FID Is Null\r\n");
                                                sql.append("Or (\r\n");
                                                sql.append("BE.FID Is Not Null\r\n");
                                                sql.append("And BE.FOutputType In (\r\n");
                                                sql.append(10710).append(",\r\n");
                                                sql.append(10740).append("\r\n");
                                                sql.append(")\r\n");
                                                sql.append(")\r\n");
                                                sql.append(")\r\n");
                                                sql.append("AND (\r\n");
                                                sql.append("(\r\n");
                                                sql.append("ISNULL(BOM.FBOMTYPE,0)<>40\r\n");
                                                sql.append("AND ISNULL(PB.FPROJECTID,'NULL')=MO.FPROJECTID\r\n");
                                                sql.append(")\r\n");
                                                sql.append("OR ISNULL(BOM.FBOMTYPE,0)=40\r\n");
                                                sql.append(")\r\n");
                                                sql.append("AND (\r\n");
                                                sql.append("(\r\n");
                                                sql.append("BOM.FBOMTYPE=50\r\n");
                                                sql.append("AND ISNULL(STN.FNUMBER,'NULL')<=ISNULL(ETN.FNUMBER,'NULL')\r\n");
                                                sql.append("AND ISNULL(STN.FNUMBER,'NULL')<=ISNULL(TN.FNUMBER,'NULL')\r\n");
                                                sql.append("AND ISNULL(ETN.FNUMBER,'NULL')>=ISNULL(TN.FNUMBER,'NULL')\r\n");
                                                sql.append(")\r\n");
                                                sql.append("OR (\r\n");
                                                sql.append("BOM.FBOMTYPE=45\r\n");
                                                sql.append("AND EXISTS(\r\n");
                                                sql.append("SELECT\r\n");
                                                sql.append("1\r\n");
                                                sql.append("FROM T_MM_ORDERBOMPT TOBT\r\n");
                                                sql.append("WHERE\r\n");
                                                sql.append("1=1\r\n");
                                                sql.append("AND TOBT.FORDERID=BOM.FID\r\n");
                                                sql.append("AND TOBT.FTRACKID=MO.FTRACKID\r\n");
                                                sql.append(")\r\n");
                                                sql.append(")\r\n");
                                                sql.append(")\r\n");
                                                sql.append("ORDER BY\r\n");
                                                sql.append("MO.FNUMBER,\r\n");
                                                sql.append("PBE.FSEQ\r\n");
                                                insertRows = this.executeSQL(ctx, sql.toString());
                                                if (insertRows != 0) break block67;
                                                if (pbomEntryBOMEntryTempTable == null || pbomEntryBOMEntryTempTable.trim().length() <= 0) break block68;
                                                TempTablePool.getInstance((Context)ctx).releaseTable(pbomEntryBOMEntryTempTable);
                                            }
                                            if (newMOSETempTable != null && newMOSETempTable.trim().length() > 0) {
                                                TempTablePool.getInstance((Context)ctx).releaseTable(newMOSETempTable);
                                            }
                                            if (newMOMOTempTable != null && newMOMOTempTable.trim().length() > 0) {
                                                TempTablePool.getInstance((Context)ctx).releaseTable(newMOMOTempTable);
                                            }
                                            if (curMOMOTempTable != null && curMOMOTempTable.trim().length() > 0) {
                                                TempTablePool.getInstance((Context)ctx).releaseTable(curMOMOTempTable);
                                            }
                                            if (addMOMOTempTable != null && addMOMOTempTable.trim().length() > 0) {
                                                TempTablePool.getInstance((Context)ctx).releaseTable(addMOMOTempTable);
                                            }
                                            if (addMOSETempTable != null && addMOSETempTable.trim().length() > 0) {
                                                TempTablePool.getInstance((Context)ctx).releaseTable(addMOSETempTable);
                                            }
                                            if (mosewhTempTable != null && mosewhTempTable.trim().length() > 0) {
                                                TempTablePool.getInstance((Context)ctx).releaseTable(mosewhTempTable);
                                            }
                                            if (mosewhgTempTable != null && mosewhgTempTable.trim().length() > 0) {
                                                TempTablePool.getInstance((Context)ctx).releaseTable(mosewhgTempTable);
                                            }
                                            if (mosersTempTable != null && mosersTempTable.trim().length() > 0) {
                                                TempTablePool.getInstance((Context)ctx).releaseTable(mosersTempTable);
                                            }
                                            if (jgjmosewhTempTable != null && jgjmosewhTempTable.trim().length() > 0) {
                                                TempTablePool.getInstance((Context)ctx).releaseTable(jgjmosewhTempTable);
                                            }
                                            this.updateMOSDatas(ctx, new IObjectPK[]{pk}, isMSEIssueModeFromBomEntry);
                                            return;
                                        }
                                        newMOMOTempTable = this.createNewMOMOTempTable(ctx);
                                        sql.setLength(0);
                                        sql.append(this.insertNewMOMOTempTableSQL(newMOMOTempTable));
                                        sql.append("SELECT\r\n");
                                        sql.append("T.FPARENTID,\r\n");
                                        sql.append("IsNull(M.CFMergeMaterialID,M.FID),\r\n");
                                        sql.append("T.FOPERATIONID,\r\n");
                                        sql.append("SUM(T.FUNITQTY),\r\n");
                                        sql.append("SUM(T.FQTY),\r\n");
                                        sql.append("SUM(T.FPLANNEDQTY)\r\n");
                                        sql.append("FROM ").append(newMOSETempTable).append(" T\r\n");
                                        sql.append("Inner Join T_BD_Material M On M.FID=T.FMaterialID\r\n");
                                        sql.append("WHERE\r\n");
                                        sql.append("1=1\r\n");
                                        sql.append("AND ISNULL(T.FOPERATIONID,'NULL')<>'NULL'\r\n");
                                        sql.append("AND EXISTS(\r\n");
                                        sql.append("SELECT\r\n");
                                        sql.append("1\r\n");
                                        sql.append("FROM T_MM_MFTORDERTECHNICS MOT\r\n");
                                        sql.append("WHERE\r\n");
                                        sql.append("1=1\r\n");
                                        sql.append("AND MOT.FPARENTID=T.FPARENTID\r\n");
                                        sql.append("AND MOT.FOPERATIONID=T.FOPERATIONID\r\n");
                                        sql.append(")\r\n");
                                        sql.append("GROUP BY\r\n");
                                        sql.append("T.FPARENTID,\r\n");
                                        sql.append("IsNull(M.CFMergeMaterialID,M.FID),\r\n");
                                        sql.append("T.FOPERATIONID\r\n");
                                        insertRows = this.executeSQL(ctx, sql.toString());
                                        if (insertRows != 0) break block69;
                                        if (pbomEntryBOMEntryTempTable == null || pbomEntryBOMEntryTempTable.trim().length() <= 0) break block70;
                                        TempTablePool.getInstance((Context)ctx).releaseTable(pbomEntryBOMEntryTempTable);
                                    }
                                    if (newMOSETempTable != null && newMOSETempTable.trim().length() > 0) {
                                        TempTablePool.getInstance((Context)ctx).releaseTable(newMOSETempTable);
                                    }
                                    if (newMOMOTempTable != null && newMOMOTempTable.trim().length() > 0) {
                                        TempTablePool.getInstance((Context)ctx).releaseTable(newMOMOTempTable);
                                    }
                                    if (curMOMOTempTable != null && curMOMOTempTable.trim().length() > 0) {
                                        TempTablePool.getInstance((Context)ctx).releaseTable(curMOMOTempTable);
                                    }
                                    if (addMOMOTempTable != null && addMOMOTempTable.trim().length() > 0) {
                                        TempTablePool.getInstance((Context)ctx).releaseTable(addMOMOTempTable);
                                    }
                                    if (addMOSETempTable != null && addMOSETempTable.trim().length() > 0) {
                                        TempTablePool.getInstance((Context)ctx).releaseTable(addMOSETempTable);
                                    }
                                    if (mosewhTempTable != null && mosewhTempTable.trim().length() > 0) {
                                        TempTablePool.getInstance((Context)ctx).releaseTable(mosewhTempTable);
                                    }
                                    if (mosewhgTempTable != null && mosewhgTempTable.trim().length() > 0) {
                                        TempTablePool.getInstance((Context)ctx).releaseTable(mosewhgTempTable);
                                    }
                                    if (mosersTempTable != null && mosersTempTable.trim().length() > 0) {
                                        TempTablePool.getInstance((Context)ctx).releaseTable(mosersTempTable);
                                    }
                                    if (jgjmosewhTempTable != null && jgjmosewhTempTable.trim().length() > 0) {
                                        TempTablePool.getInstance((Context)ctx).releaseTable(jgjmosewhTempTable);
                                    }
                                    this.updateMOSDatas(ctx, new IObjectPK[]{pk}, isMSEIssueModeFromBomEntry);
                                    return;
                                }
                                curMOMOTempTable = this.createCURMOMOTempTable(ctx);
                                sql.setLength(0);
                                sql.append(this.insertCURMOMOTempTableSQL(curMOMOTempTable));
                                sql.append("SELECT\r\n");
                                sql.append("MO.FID,\r\n");
                                sql.append("IsNull(M.CFMergeMaterialID,M.FID),\r\n");
                                sql.append("OPER.FID,\r\n");
                                sql.append("SUM(MOSE.FUNITQTY),\r\n");
                                sql.append("SUM(MOSE.FQTY),\r\n");
                                sql.append("SUM(MOSE.FPLANNEDQTY)\r\n");
                                sql.append("FROM T_MM_MFTORDERSTOCK MOSE\r\n");
                                sql.append("INNER JOIN T_BD_MATERIAL M ON M.FID=MOSE.FMATERIALID\r\n");
                                sql.append("INNER JOIN T_MM_OPERATION OPER ON OPER.FID=MOSE.FOPERATIONID\r\n");
                                sql.append("INNER JOIN T_MM_MANUFACTUREORDER MO ON MO.FID=MOSE.FPARENTID\r\n");
                                sql.append("INNER JOIN CT_PS_MASTERPRODUCTIONSCHEDULE MPS ON MPS.FID=MO.FSOURCEBILLID\r\n");
                                sql.append("WHERE\r\n");
                                sql.append("1=1\r\n");
                                sql.append("AND MPS.FID='").append(id).append("'\r\n");
                                sql.append("AND ISNULL(MOSE.FOPERATIONID,'NULL')<>'NULL'\r\n");
                                sql.append("GROUP BY\r\n");
                                sql.append("MO.FID,\r\n");
                                sql.append("IsNull(M.CFMergeMaterialID,M.FID),\r\n");
                                sql.append("OPER.FID\r\n");
                                this.executeSQL(ctx, sql.toString());
                                addMOMOTempTable = this.createAddMOMOTempTable(ctx);
                                sql.setLength(0);
                                sql.append(this.insertAddMOMOTempTableSQL(addMOMOTempTable));
                                sql.append("SELECT\r\n");
                                sql.append("NT.FMOID,\r\n");
                                sql.append("NT.FMATERIALID,\r\n");
                                sql.append("NT.FOPERATIONID,\r\n");
                                sql.append("ISNULL(NT.FSUMUNITQTY,0),\r\n");
                                sql.append("ISNULL(NT.FSUMQTY,0),\r\n");
                                sql.append("ISNULL(NT.FSUMPLANNEDQTY,0),\r\n");
                                sql.append("ISNULL(CT.FSUMUNITQTY,0),\r\n");
                                sql.append("ISNULL(CT.FSUMQTY,0),\r\n");
                                sql.append("ISNULL(CT.FSUMPLANNEDQTY,0),\r\n");
                                sql.append("0,\r\n");
                                sql.append("0,\r\n");
                                sql.append("0,\r\n");
                                sql.append("(\r\n");
                                sql.append("SELECT\r\n");
                                sql.append("Top 1\r\n");
                                sql.append("NST.FID\r\n");
                                sql.append("FROM ").append(newMOSETempTable).append(" NST\r\n");
                                sql.append("Inner Join T_BD_Material M On M.FID=NST.FMaterialID\r\n");
                                sql.append("WHERE\r\n");
                                sql.append("1=1\r\n");
                                sql.append("AND NST.FPARENTID=NT.FMOID\r\n");
                                sql.append("AND IsNull(M.CFMergeMaterialID,M.FID)=NT.FMATERIALID\r\n");
                                sql.append("AND NST.FOPERATIONID=NT.FOPERATIONID\r\n");
                                sql.append("),\r\n");
                                sql.append("ISNULL((\r\n");
                                sql.append("SELECT\r\n");
                                sql.append("MAX(MOS.FSEQ)\r\n");
                                sql.append("FROM T_MM_MFTORDERSTOCK MOS\r\n");
                                sql.append("WHERE\r\n");
                                sql.append("1=1\r\n");
                                sql.append("AND MOS.FPARENTID=NT.FMOID\r\n");
                                sql.append("),0)\r\n");
                                sql.append("FROM ").append(newMOMOTempTable).append(" NT\r\n");
                                sql.append("LEFT JOIN ").append(curMOMOTempTable).append(" CT ON\r\n");
                                sql.append("1=1\r\n");
                                sql.append("AND CT.FMOID=NT.FMOID\r\n");
                                sql.append("AND CT.FMATERIALID=NT.FMATERIALID\r\n");
                                sql.append("AND CT.FOPERATIONID=NT.FOPERATIONID\r\n");
                                sql.append("WHERE\r\n");
                                sql.append("1=1\r\n");
                                sql.append("AND ISNULL(CT.FSUMQTY,0)<ISNULL(NT.FSUMQTY,0)\r\n");
                                insertRows = this.executeSQL(ctx, sql.toString());
                                if (insertRows != 0) break block71;
                                if (pbomEntryBOMEntryTempTable == null || pbomEntryBOMEntryTempTable.trim().length() <= 0) break block72;
                                TempTablePool.getInstance((Context)ctx).releaseTable(pbomEntryBOMEntryTempTable);
                            }
                            if (newMOSETempTable != null && newMOSETempTable.trim().length() > 0) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(newMOSETempTable);
                            }
                            if (newMOMOTempTable != null && newMOMOTempTable.trim().length() > 0) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(newMOMOTempTable);
                            }
                            if (curMOMOTempTable != null && curMOMOTempTable.trim().length() > 0) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(curMOMOTempTable);
                            }
                            if (addMOMOTempTable != null && addMOMOTempTable.trim().length() > 0) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(addMOMOTempTable);
                            }
                            if (addMOSETempTable != null && addMOSETempTable.trim().length() > 0) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(addMOSETempTable);
                            }
                            if (mosewhTempTable != null && mosewhTempTable.trim().length() > 0) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(mosewhTempTable);
                            }
                            if (mosewhgTempTable != null && mosewhgTempTable.trim().length() > 0) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(mosewhgTempTable);
                            }
                            if (mosersTempTable != null && mosersTempTable.trim().length() > 0) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(mosersTempTable);
                            }
                            if (jgjmosewhTempTable != null && jgjmosewhTempTable.trim().length() > 0) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(jgjmosewhTempTable);
                            }
                            this.updateMOSDatas(ctx, new IObjectPK[]{pk}, isMSEIssueModeFromBomEntry);
                            return;
                        }
                        sql.setLength(0);
                        sql.append("UPDATE ").append(addMOMOTempTable).append("\r\n");
                        sql.append("SET\r\n");
                        sql.append("FMOREUNITQTY=FSUMUNITQTY -FCURSUMUNITQTY,\r\n");
                        sql.append("FMOREQTY=FSUMQTY -FCURSUMQTY,\r\n");
                        sql.append("FMOREPLANNEDQTY=FSUMPLANNEDQTY -FCURSUMPLANNEDQTY\r\n");
                        this.executeSQL(ctx, sql.toString());
                        addMOSETempTable = this.createMOSTempTable(ctx);
                        sql.setLength(0);
                        sql.append(this.insertMOSTempTableSQL(ctx, addMOSETempTable));
                        sql.append("SELECT\r\n");
                        sql.append("T.FID,\r\n");
                        sql.append("T.FPARENTID,\r\n");
                        sql.append("T.FMATERIALID,\r\n");
                        sql.append("T.FREPLACEMATERIALID,\r\n");
                        sql.append("T.FASSISTPROPERTYID,\r\n");
                        sql.append("T.FUNITID,\r\n");
                        sql.append("T.FBASEUNITID,\r\n");
                        sql.append("T.FASSISTUNITID,\r\n");
                        sql.append("T.FREASONCODEID,\r\n");
                        sql.append("T.FWAREHOUSEID,\r\n");
                        sql.append("T.FRECEIPTSTOCKID,\r\n");
                        sql.append("T.FCOMBINATIONSTOCKID,\r\n");
                        sql.append("T.FLOCATIONID,\r\n");
                        sql.append("T.FOPERATIONID,\r\n");
                        sql.append("T.FSTORAGEORGUNITID,\r\n");
                        sql.append("T.FRECEIPTSTROAGEORGUNITID,\r\n");
                        sql.append("T.FWORKCENTERID,\r\n");
                        sql.append("T.FBOMENTRYID,\r\n");
                        sql.append("T.FSOURCEBILLENTRYID,\r\n");
                        sql.append("T.FASSOCIATEQTY,\r\n");
                        sql.append("T.FLOSSRATIO,\r\n");
                        sql.append("T.FEXTRARATIO,\r\n");
                        sql.append("T.FLACKRATIO,\r\n");
                        sql.append("T.FREPLACERATIO,\r\n");
                        sql.append("T.FUNITREPLACEQTY,\r\n");
                        sql.append("T.CFOPENQTY,\r\n");
                        sql.append("T.CFACTMOVEQTY,\r\n");
                        sql.append("T.CFALRMOVEQTY,\r\n");
                        sql.append("ADDT.FMOREQTY,\r\n");
                        sql.append("T.FBASEQTY,\r\n");
                        sql.append("T.FLOSSQTY,\r\n");
                        sql.append("T.FLOSSBASEQTY,\r\n");
                        sql.append("T.FACTISSUEQTY,\r\n");
                        sql.append("T.FACTISSUEBASEQTY,\r\n");
                        sql.append("T.FACTLOSSQTY,\r\n");
                        sql.append("T.FACTLOSSBASEQTY,\r\n");
                        sql.append("T.FREJECTEDQTY,\r\n");
                        sql.append("T.FREJECTEDBASEQTY,\r\n");
                        sql.append("T.FFEEDINGQTY,\r\n");
                        sql.append("T.FFEEDINGBASEQTY,\r\n");
                        sql.append("T.FSCRAPQTY,\r\n");
                        sql.append("T.FSCRAPBASEQTY,\r\n");
                        sql.append("T.FWIPQTY,\r\n");
                        sql.append("T.FWIPBASEQTY,\r\n");
                        sql.append("ADDT.FMOREPLANNEDQTY,\r\n");
                        sql.append("T.FPLANNEDBASEQTY,\r\n");
                        sql.append("ADDT.FMOREUNITQTY,\r\n");
                        sql.append("T.FUNITBASEQTY,\r\n");
                        sql.append("T.FMATERIALSCRAPQTY,\r\n");
                        sql.append("T.FMATERIALSCRAPBASEQTY,\r\n");
                        sql.append("T.FMATERIALFEEDINGQTY,\r\n");
                        sql.append("T.FMATERIALFEEDINGBASEQTY,\r\n");
                        sql.append("T.FUNISSUEQTY,\r\n");
                        sql.append("T.FUNISSUEBASEQTY,\r\n");
                        sql.append("T.FTOSTOREQTY,\r\n");
                        sql.append("T.FTOSTOREBASEQTY,\r\n");
                        sql.append("T.FORIGINALPLANQTY,\r\n");
                        sql.append("T.FORIGINALPLANBASEQTY,\r\n");
                        sql.append("T.FTOTALRECEIPTQTY,\r\n");
                        sql.append("T.FTOTALRECEIPTBASEQTY,\r\n");
                        sql.append("T.FUNRECEIPTQTY,\r\n");
                        sql.append("T.FUNRECEIPTBASEQTY,\r\n");
                        sql.append("T.FTOTALDIRECTRECEIVEQTY,\r\n");
                        sql.append("T.FTOTALDIRECTRECEIVEBASEQTY,\r\n");
                        sql.append("T.FTOTALDSTRANSFERQTY,\r\n");
                        sql.append("T.FTOTALDSTRANSFERBASEQTY,\r\n");
                        sql.append("T.FDEMANDTIME,\r\n");
                        sql.append("T.FACTUEISSUETIME,\r\n");
                        sql.append("T.FBLKSIZE,\r\n");
                        sql.append("T.FSPECIFIEDLENGTH,\r\n");
                        sql.append("T.FASSYLOCATION_L2,\r\n");
                        sql.append("Null,\r\n");
                        sql.append("ISNULL(ADDT.FMAXSEQ,0)+T.FSEQ,\r\n");
                        sql.append("T.FLINESEQ,\r\n");
                        sql.append("T.FBASESTATUS,\r\n");
                        sql.append("T.FMATREPLACETYPE,\r\n");
                        sql.append("T.FTRANSFERTYPE,\r\n");
                        sql.append("T.FPROVIDETYPE,\r\n");
                        sql.append("T.FPICKTYPE,\r\n");
                        sql.append("T.FSCRAPEXPR,\r\n");
                        sql.append("T.FREPLACEGROUPFLAG,\r\n");
                        sql.append("T.FREPLACEPRIORITY,\r\n");
                        sql.append("T.CFMOVESTATUS,\r\n");
                        sql.append("T.FNEWNETWEIGHT,\r\n");
                        sql.append("T.FOPERATIONNO,\r\n");
                        sql.append("T.FISSUEMODE,\r\n");
                        sql.append("T.FISREPLACED,\r\n");
                        sql.append("T.FISBACKFLUSH,\r\n");
                        sql.append("T.FISQTYLIMIT,\r\n");
                        sql.append("T.FISSTOCKALLOT,\r\n");
                        sql.append("T.CFISMUSTREQ,\r\n");
                        sql.append("T.CFISLINESTOREHOUSE,\r\n");
                        sql.append("T.CFIsOwnObject\r\n");
                        sql.append("FROM ").append(newMOSETempTable).append(" T\r\n");
                        sql.append("INNER JOIN ").append(addMOMOTempTable).append(" ADDT ON ADDT.FMOSID=T.FID\r\n");
                        insertRows = this.executeSQL(ctx, sql.toString());
                        if (insertRows != 0) break block73;
                        if (pbomEntryBOMEntryTempTable == null || pbomEntryBOMEntryTempTable.trim().length() <= 0) break block74;
                        TempTablePool.getInstance((Context)ctx).releaseTable(pbomEntryBOMEntryTempTable);
                    }
                    if (newMOSETempTable != null && newMOSETempTable.trim().length() > 0) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(newMOSETempTable);
                    }
                    if (newMOMOTempTable != null && newMOMOTempTable.trim().length() > 0) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(newMOMOTempTable);
                    }
                    if (curMOMOTempTable != null && curMOMOTempTable.trim().length() > 0) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(curMOMOTempTable);
                    }
                    if (addMOMOTempTable != null && addMOMOTempTable.trim().length() > 0) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(addMOMOTempTable);
                    }
                    if (addMOSETempTable != null && addMOSETempTable.trim().length() > 0) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(addMOSETempTable);
                    }
                    if (mosewhTempTable != null && mosewhTempTable.trim().length() > 0) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(mosewhTempTable);
                    }
                    if (mosewhgTempTable != null && mosewhgTempTable.trim().length() > 0) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(mosewhgTempTable);
                    }
                    if (mosersTempTable != null && mosersTempTable.trim().length() > 0) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(mosersTempTable);
                    }
                    if (jgjmosewhTempTable != null && jgjmosewhTempTable.trim().length() > 0) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(jgjmosewhTempTable);
                    }
                    this.updateMOSDatas(ctx, new IObjectPK[]{pk}, isMSEIssueModeFromBomEntry);
                    return;
                }
                try {
                    this.updateMOSStockOrgUnit(ctx, addMOSETempTable);
                    String defaultWarehouse = this.getParamValue(ctx, "defaultWarehouse", storageOrgUnitID);
                    Boolean defaultWarehousemodel = defaultWarehouse == null ? false : "true".equals(defaultWarehouse);
                    this.updateMOSDatas(ctx, addMOSETempTable, isMSEIssueModeFromBomEntry);
                    this.updateMOSWarehouse(ctx, addMOSETempTable, storageOrgUnitID, isWarehouseFromBOMEntry, defaultWarehousemodel, isMOSWarehouseFromOrderStorageOrgUnit);
                    this.insertMOSData(ctx, addMOSETempTable, true);
                    if (pbomEntryBOMEntryTempTable == null || pbomEntryBOMEntryTempTable.trim().length() <= 0) break block75;
                }
                catch (Exception e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (pbomEntryBOMEntryTempTable != null && pbomEntryBOMEntryTempTable.trim().length() > 0) {
                            TempTablePool.getInstance((Context)ctx).releaseTable(pbomEntryBOMEntryTempTable);
                        }
                        if (newMOSETempTable != null && newMOSETempTable.trim().length() > 0) {
                            TempTablePool.getInstance((Context)ctx).releaseTable(newMOSETempTable);
                        }
                        if (newMOMOTempTable != null && newMOMOTempTable.trim().length() > 0) {
                            TempTablePool.getInstance((Context)ctx).releaseTable(newMOMOTempTable);
                        }
                        if (curMOMOTempTable != null && curMOMOTempTable.trim().length() > 0) {
                            TempTablePool.getInstance((Context)ctx).releaseTable(curMOMOTempTable);
                        }
                        if (addMOMOTempTable != null && addMOMOTempTable.trim().length() > 0) {
                            TempTablePool.getInstance((Context)ctx).releaseTable(addMOMOTempTable);
                        }
                        if (addMOSETempTable != null && addMOSETempTable.trim().length() > 0) {
                            TempTablePool.getInstance((Context)ctx).releaseTable(addMOSETempTable);
                        }
                        if (mosewhTempTable != null && mosewhTempTable.trim().length() > 0) {
                            TempTablePool.getInstance((Context)ctx).releaseTable(mosewhTempTable);
                        }
                        if (mosewhgTempTable != null && mosewhgTempTable.trim().length() > 0) {
                            TempTablePool.getInstance((Context)ctx).releaseTable(mosewhgTempTable);
                        }
                        if (mosersTempTable != null && mosersTempTable.trim().length() > 0) {
                            TempTablePool.getInstance((Context)ctx).releaseTable(mosersTempTable);
                        }
                        if (jgjmosewhTempTable != null && jgjmosewhTempTable.trim().length() > 0) {
                            TempTablePool.getInstance((Context)ctx).releaseTable(jgjmosewhTempTable);
                        }
                        this.updateMOSDatas(ctx, new IObjectPK[]{pk}, isMSEIssueModeFromBomEntry);
                        throw throwable;
                    }
                }
                TempTablePool.getInstance((Context)ctx).releaseTable(pbomEntryBOMEntryTempTable);
            }
            if (newMOSETempTable != null && newMOSETempTable.trim().length() > 0) {
                TempTablePool.getInstance((Context)ctx).releaseTable(newMOSETempTable);
            }
            if (newMOMOTempTable != null && newMOMOTempTable.trim().length() > 0) {
                TempTablePool.getInstance((Context)ctx).releaseTable(newMOMOTempTable);
            }
            if (curMOMOTempTable != null && curMOMOTempTable.trim().length() > 0) {
                TempTablePool.getInstance((Context)ctx).releaseTable(curMOMOTempTable);
            }
            if (addMOMOTempTable != null && addMOMOTempTable.trim().length() > 0) {
                TempTablePool.getInstance((Context)ctx).releaseTable(addMOMOTempTable);
            }
            if (addMOSETempTable != null && addMOSETempTable.trim().length() > 0) {
                TempTablePool.getInstance((Context)ctx).releaseTable(addMOSETempTable);
            }
            if (mosewhTempTable != null && mosewhTempTable.trim().length() > 0) {
                TempTablePool.getInstance((Context)ctx).releaseTable(mosewhTempTable);
            }
            if (mosewhgTempTable != null && mosewhgTempTable.trim().length() > 0) {
                TempTablePool.getInstance((Context)ctx).releaseTable(mosewhgTempTable);
            }
            if (mosersTempTable != null && mosersTempTable.trim().length() > 0) {
                TempTablePool.getInstance((Context)ctx).releaseTable(mosersTempTable);
            }
            if (jgjmosewhTempTable != null && jgjmosewhTempTable.trim().length() > 0) {
                TempTablePool.getInstance((Context)ctx).releaseTable(jgjmosewhTempTable);
            }
            this.updateMOSDatas(ctx, new IObjectPK[]{pk}, isMSEIssueModeFromBomEntry);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model != null) {
            MasterProductionScheduleInfo billInfo = (MasterProductionScheduleInfo)model;
            String billNumber = null;
            if (billInfo != null) {
                DHProjectDetailPlanInfo pdp;
                billNumber = billInfo.getNumber();
                if ((billNumber == null || billNumber.trim().length() == 0) && billInfo.getStorageOrgUnit() != null && billInfo.getStorageOrgUnit().getId() != null) {
                    this.setBillNumber(ctx, (IObjectValue)billInfo, billInfo.getStorageOrgUnit().getId().toString());
                    billNumber = billInfo.getNumber();
                }
                this.checkData(ctx, (IObjectValue)billInfo, "save");
                if (BillBaseStatusEnum.SUBMITED.equals((Object)billInfo.getBaseStatus())) {
                    throw new PlanOrderException(PlanOrderException.SUBMITED_SAVE_INFORMATION);
                }
                if (!BillBaseStatusEnum.ADD.equals((Object)billInfo.getBaseStatus()) && !BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)billInfo.getBaseStatus())) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0000", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_Not_Add_Save", new String[]{billNumber})));
                }
                Date finishTime = new Date(billInfo.getFinishTime().getTime());
                String sourceBillID = billInfo.getSourceBillId();
                String billID = null;
                if ((sourceBillID == null || sourceBillID.trim().length() == 0) && billInfo.getId() != null && billInfo.getId().toString().trim().length() > 0) {
                    billID = billInfo.getId().toString();
                    MasterProductionScheduleInfo mps = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleInfo((IObjectPK)new ObjectUuidPK(billID));
                    if (mps != null && mps.getSourceBillId() != null && mps.getSourceBillId().trim().length() > 0) {
                        sourceBillID = mps.getSourceBillId();
                    }
                }
                if (sourceBillID != null && sourceBillID.trim().length() > 0 && BOSUuid.getBOSObjectType((String)sourceBillID, (boolean)false).equals((Object)new DHProjectDetailPlanInfo().getBOSType()) && sourceBillID != null && sourceBillID.trim().length() > 0 && BOSUuid.getBOSObjectType((String)sourceBillID, (boolean)false).equals((Object)new DHProjectDetailPlanInfo().getBOSType()) && (pdp = DHProjectDetailPlanFactory.getLocalInstance((Context)ctx).getDHProjectDetailPlanInfo((IObjectPK)new ObjectUuidPK(sourceBillID))) != null && pdp.getScheduledComDate() != null) {
                    Date sourceBillFinishTime = pdp.getScheduledComDate();
                    if (OperationScheduleUtils.sdfDate.format(finishTime).compareTo(OperationScheduleUtils.sdfDate.format(sourceBillFinishTime)) > 0) {
                        throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0000", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FinishTime_Must_Less_Equal_Then_SourceBill_FinishTime", new String[]{billNumber, OperationScheduleUtils.sdfDate.format(sourceBillFinishTime)})));
                    }
                }
                billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            }
        }
        return super._save(ctx, model);
    }

    @Override
    protected void _submit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            MasterProductionScheduleInfo billInfo = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleInfo(pk);
            this._submit(ctx, (IObjectValue)billInfo);
        }
        super._submit(ctx, pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DailyOutputUtils ut = DailyOutputUtils.initInspection(ctx, model);
        try {
            if (model != null) {
                MasterProductionScheduleInfo billInfo = (MasterProductionScheduleInfo)model;
                String billNumber = null;
                if (billInfo != null) {
                    DHProjectDetailPlanInfo pdp;
                    billNumber = billInfo.getNumber();
                    if ((billNumber == null || billNumber.trim().length() == 0) && billInfo.getStorageOrgUnit() != null && billInfo.getStorageOrgUnit().getId() != null) {
                        this.setBillNumber(ctx, (IObjectValue)billInfo, billInfo.getStorageOrgUnit().getId().toString());
                        billNumber = billInfo.getNumber();
                    }
                    this.checkData(ctx, (IObjectValue)billInfo, "submit");
                    if (!(BillBaseStatusEnum.SUBMITED.equals((Object)billInfo.getBaseStatus()) || BillBaseStatusEnum.ADD.equals((Object)billInfo.getBaseStatus()) || BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)billInfo.getBaseStatus()))) {
                        throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0001", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Not_Add_Save_Submit_ListUI", new String[]{billNumber})));
                    }
                    Date finishTime = new Date(billInfo.getFinishTime().getTime());
                    String sourceBillID = billInfo.getSourceBillId();
                    String billID = null;
                    if ((sourceBillID == null || sourceBillID.trim().length() == 0) && billInfo.getId() != null && billInfo.getId().toString().trim().length() > 0) {
                        billID = billInfo.getId().toString();
                        MasterProductionScheduleInfo mps = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleInfo((IObjectPK)new ObjectUuidPK(billID));
                        if (mps != null && mps.getSourceBillId() != null && mps.getSourceBillId().trim().length() > 0) {
                            sourceBillID = mps.getSourceBillId();
                        }
                    }
                    if (sourceBillID != null && sourceBillID.trim().length() > 0 && BOSUuid.getBOSObjectType((String)sourceBillID, (boolean)false).equals((Object)new DHProjectDetailPlanInfo().getBOSType()) && sourceBillID != null && sourceBillID.trim().length() > 0 && BOSUuid.getBOSObjectType((String)sourceBillID, (boolean)false).equals((Object)new DHProjectDetailPlanInfo().getBOSType()) && (pdp = DHProjectDetailPlanFactory.getLocalInstance((Context)ctx).getDHProjectDetailPlanInfo((IObjectPK)new ObjectUuidPK(sourceBillID))) != null && pdp.getScheduledComDate() != null) {
                        Date sourceBillFinishTime = pdp.getScheduledComDate();
                        if (OperationScheduleUtils.sdfDate.format(finishTime).compareTo(OperationScheduleUtils.sdfDate.format(sourceBillFinishTime)) > 0) {
                            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0001", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FinishTime_Must_Less_Equal_Then_SourceBill_FinishTime", new String[]{billNumber, OperationScheduleUtils.sdfDate.format(sourceBillFinishTime)})));
                        }
                    }
                    if (billInfo.getProjectJCH() != null) {
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)billInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
                        filterInfo.getFilterItems().add(new FilterItemInfo("trace.id", (Object)billInfo.getTrace().getId().toString(), CompareType.EQUALS));
                        filterInfo.getFilterItems().add(new FilterItemInfo("product.id", (Object)billInfo.getProduct().getId().toString(), CompareType.EQUALS));
                        filterInfo.getFilterItems().add(new FilterItemInfo("projectJCH.id", (Object)billInfo.getProjectJCH().getId().toString(), CompareType.EQUALS));
                        if (billInfo.getId() != null) {
                            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)billInfo.getId().toString(), CompareType.NOTEQUALS));
                        }
                        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)0, CompareType.NOTEQUALS));
                        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)1, CompareType.NOTEQUALS));
                        view.setFilter(filterInfo);
                        MasterProductionScheduleCollection mpss = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleCollection(view);
                        if (mpss != null && mpss.size() > 0) {
                            StringBuffer billNumbers = new StringBuffer();
                            for (int i = 0; i < mpss.size(); ++i) {
                                if (mpss.get(i) == null || mpss.get(i).getNumber() == null) continue;
                                billNumbers.append("\r\n").append(mpss.get(i).getNumber());
                            }
                            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0001", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_Exists_Same_SOU_Trace_Product_JCH_Data", new String[]{billNumber, billNumbers.toString()})));
                        }
                    }
                    billInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                }
            }
            IObjectPK pk = super._submit(ctx, model);
            ut.inspection();
            IObjectPK iObjectPK = pk;
            return iObjectPK;
        }
        finally {
            ut.endInspection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _unAssign(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            MasterProductionScheduleInfo billInfo = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleInfo(pk);
            String billNumber = null;
            if (billInfo != null) {
                billNumber = billInfo.getNumber();
                if (billNumber == null) {
                    billNumber = "";
                }
                EntityViewInfo view = null;
                FilterInfo filterInfo = null;
                StringBuffer sql = new StringBuffer();
                ManufactureOrderCollection mos = null;
                WorkshopScheduleCollection wss = null;
                int row = 0;
                if (!BillBaseStatusEnum.RELEASED.equals((Object)billInfo.getBaseStatus())) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0016", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Not_Assign_ListUI", new String[]{billNumber})));
                }
                view = new EntityViewInfo();
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billInfo.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)0, CompareType.NOTEQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)1, CompareType.NOTEQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)2, CompareType.NOTEQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.NOTEQUALS));
                view.setFilter(filterInfo);
                mos = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderCollection(view);
                if (mos != null && mos.size() > 0) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0016", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Exists_MO_Assign", new String[]{billNumber})));
                }
                view = new EntityViewInfo();
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billInfo.getId().toString(), CompareType.EQUALS));
                sql.setLength(0);
                sql.append("Select\r\n");
                sql.append("MOS.FParentID \"FParentID\"\r\n");
                sql.append("From T_MM_MFTOrderStock MOS\r\n");
                sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=MOS.FParentID\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And MO.FSourceBillID='").append(billInfo.getId().toString()).append("'\r\n");
                sql.append("And Exists(\r\n");
                sql.append("Select\r\n");
                sql.append("1\r\n");
                sql.append("From T_IM_StockTransferBillEntry STBE\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And STBE.FSourceBillEntryID=MOS.FID\r\n");
                sql.append(")\r\n");
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
                sql.setLength(0);
                sql.append("Select\r\n");
                sql.append("MO.FID \"FID\"\r\n");
                sql.append("From T_MM_ManufactureOrder MO\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And MO.FSourceBillID='").append(billInfo.getId().toString()).append("'\r\n");
                sql.append("And Exists(\r\n");
                sql.append("Select\r\n");
                sql.append("1 \"FID\"\r\n");
                sql.append("From CT_MO_FaultRecord FR\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And FR.CFManuOrderID=MO.FID\r\n");
                sql.append(")\r\n");
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
                filterInfo.setMaskString("#0 And ( #1 Or #2 )");
                view.setFilter(filterInfo);
                mos = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderCollection(view);
                if (mos != null && mos.size() > 0) {
                    String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DJSCDSGZJLDSJ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{billNumber});
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0016", (Locale)ctx.getLocale()), strInfo));
                }
                view = new EntityViewInfo();
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billInfo.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)0, CompareType.NOTEQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)1, CompareType.NOTEQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)2, CompareType.NOTEQUALS));
                view.setFilter(filterInfo);
                wss = WorkshopScheduleFactory.getLocalInstance(ctx).getWorkshopScheduleCollection(view);
                if (wss != null && wss.size() > 0) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0016", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Exists_WS_Audit", new String[]{billNumber})));
                }
                view = new EntityViewInfo();
                filterInfo = new FilterInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("CostObject.id"));
                filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billInfo.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)0, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)1, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)2, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", null, CompareType.EQUALS));
                sql.setLength(0);
                sql.append("Select\r\n");
                sql.append("MOS.FParentID \"FParentID\"\r\n");
                sql.append("From T_MM_MFTOrderStock MOS\r\n");
                sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=MOS.FParentID\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And MO.FSourceBillID='").append(billInfo.getId().toString()).append("'\r\n");
                sql.append("And Exists(\r\n");
                sql.append("Select\r\n");
                sql.append("1\r\n");
                sql.append("From T_IM_StockTransferBillEntry STBE\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And STBE.FSourceBillEntryID=MOS.FID\r\n");
                sql.append(")\r\n");
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
                sql.setLength(0);
                sql.append("Select\r\n");
                sql.append("MO.FID \"FID\"\r\n");
                sql.append("From T_MM_ManufactureOrder MO\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And MO.FSourceBillID='").append(billInfo.getId().toString()).append("'\r\n");
                sql.append("And Exists(\r\n");
                sql.append("Select\r\n");
                sql.append("1 \"FID\"\r\n");
                sql.append("From CT_MO_FaultRecord FR\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And FR.CFManuOrderID=MO.FID\r\n");
                sql.append(")\r\n");
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
                filterInfo.getFilterItems().add(new FilterItemInfo("transactionType.name", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0017", (Locale)ctx.getLocale()), CompareType.EQUALS));
                filterInfo.setMaskString("( #0 And ( #1 Or #2 Or #3 Or #4 Or #5 ) And #6 And #7 And #8 )");
                view.setFilter(filterInfo);
                view.setSelector(sic);
                mos = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderCollection(view);
                ArrayList<ObjectUuidPK> unAuditMOIDs = new ArrayList<ObjectUuidPK>();
                ArrayList<ObjectUuidPK> deleteMOIDs = new ArrayList<ObjectUuidPK>();
                ArrayList<ObjectUuidPK> deleteCOIDs = new ArrayList<ObjectUuidPK>();
                ArrayList<String> lockMOIDList = new ArrayList<String>();
                if (mos != null && mos.size() > 0) {
                    for (row = 0; row < mos.size(); ++row) {
                        if (mos.get(row) == null) continue;
                        CostObjectInfo co = mos.get(row).getCostObject();
                        if (co != null && co.getId() != null && !deleteCOIDs.contains(co.getId())) {
                            deleteCOIDs.add(new ObjectUuidPK(co.getId().toString()));
                        }
                        if (BillBaseStatusEnum.AUDITED.equals((Object)mos.get(row).getBaseStatus())) {
                            unAuditMOIDs.add(new ObjectUuidPK(mos.get(row).getId().toString()));
                        }
                        deleteMOIDs.add(new ObjectUuidPK(mos.get(row).getId().toString()));
                        lockMOIDList.add(mos.get(row).getId().toString());
                    }
                    MutexServiceControlFacadeFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(lockMOIDList);
                    try {
                        if (unAuditMOIDs != null && unAuditMOIDs.size() > 0) {
                            ManufactureOrderFactory.getLocalInstance((Context)ctx).unAudit((IObjectPK[])unAuditMOIDs.toArray(new ObjectUuidPK[unAuditMOIDs.size()]));
                        }
                        if (deleteMOIDs != null && deleteMOIDs.size() > 0) {
                            ManufactureOrderFactory.getLocalInstance((Context)ctx).delete((IObjectPK[])deleteMOIDs.toArray(new ObjectUuidPK[deleteMOIDs.size()]));
                        }
                    }
                    finally {
                        MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(lockMOIDList);
                    }
                    if (deleteCOIDs == null || deleteCOIDs.size() > 0) {
                        // empty if block
                    }
                }
                view = new EntityViewInfo();
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billInfo.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)0, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)1, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)2, CompareType.EQUALS));
                filterInfo.setMaskString("( #0 And ( #1 Or #2 Or #3 ) )");
                view.setFilter(filterInfo);
                wss = WorkshopScheduleFactory.getLocalInstance(ctx).getWorkshopScheduleCollection(view);
                ArrayList<ObjectUuidPK> deleteWSIDs = new ArrayList<ObjectUuidPK>();
                ArrayList<String> lockWSIDList = new ArrayList<String>();
                if (wss != null && wss.size() > 0) {
                    for (row = 0; row < wss.size(); ++row) {
                        if (wss.get(row) == null) continue;
                        deleteWSIDs.add(new ObjectUuidPK(wss.get(row).getId().toString()));
                        lockWSIDList.add(wss.get(row).getId().toString());
                    }
                }
                MutexServiceControlFacadeFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(lockWSIDList);
                try {
                    if (deleteWSIDs != null && deleteWSIDs.size() > 0) {
                        WorkshopScheduleFactory.getLocalInstance(ctx).delete((IObjectPK[])deleteWSIDs.toArray(new ObjectUuidPK[deleteWSIDs.size()]));
                    }
                }
                finally {
                    MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(lockWSIDList);
                }
                this.removeBOTPRelation(ctx, billInfo.getId().toString());
                billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
                billInfo.setAssignTime(null);
                billInfo.setAssignUser(null);
                super._update(ctx, pk, (IObjectValue)billInfo);
            }
        }
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            MasterProductionScheduleInfo billInfo = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleInfo(pk);
            String billNumber = null;
            if (billInfo != null) {
                billNumber = billInfo.getNumber();
                if (billNumber == null) {
                    billNumber = "";
                }
                if (!BillBaseStatusEnum.AUDITED.equals((Object)billInfo.getBaseStatus())) {
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0003", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Not_Audit_ListUI", new String[]{billNumber})));
                }
                StringBuffer sql = new StringBuffer();
                sql.append(" select fid from CT_MO_StockTransferPlanDetial where cfmpsid='").append(pk.toString()).append("'");
                IRowSet set2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (set2 != null && set2.size() > 0) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0018", (Locale)ctx.getLocale())));
                }
                billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                billInfo.setAuditTime(null);
                billInfo.setAuditor(null);
                super._update(ctx, pk, (IObjectValue)billInfo);
            }
        }
    }

    protected void checkData(Context ctx, IObjectValue model, String action) throws EASBizException, BOSException {
        if (ctx == null || model == null || IndustryUtils.isEmptyString((String)action)) {
            return;
        }
        EntityViewInfo entityViewInfo = null;
        FilterInfo filterInfo = null;
        SelectorItemCollection selectorItemCollection = null;
        MasterProductionScheduleInfo billInfo = (MasterProductionScheduleInfo)model;
        if (billInfo.getNumber() == null || billInfo.getNumber().trim().length() == 0) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0010", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Null_Number", null)));
        }
        String billNumber = billInfo.getNumber();
        entityViewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("number"));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)billNumber, CompareType.EQUALS));
        if (billInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)billInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        MasterProductionScheduleCollection sameNumberMPSCollection = MasterProductionScheduleFactory.getLocalInstance(ctx).getMasterProductionScheduleCollection(entityViewInfo);
        if (sameNumberMPSCollection != null && sameNumberMPSCollection.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0010", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0019", (Locale)ctx.getLocale())));
        }
        if (billInfo.getStorageOrgUnit() == null) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0010", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_StorageOrgUnit_Null", new String[]{billNumber})));
        }
        if (billInfo.getProduct() == null) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0010", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_Product_Null", new String[]{billNumber})));
        }
        if (billInfo.getCoMaterial() == null && "submit".equalsIgnoreCase(action)) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0010", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_COMaterial_Null", new String[]{billNumber})));
        }
        if (billInfo.getStartTime() == null || billInfo.getStartTime().toString().trim().length() == 0) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0010", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_StartTime_Null", new String[]{billNumber})));
        }
        if (billInfo.getFinishTime() == null || billInfo.getFinishTime().toString().trim().length() == 0) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0010", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FinishTime_Null", new String[]{billNumber})));
        }
        Date finishTime = billInfo.getFinishTime();
        if (OperationScheduleUtils.sdfDate.format(finishTime).compareTo(OperationScheduleUtils.sdfDate.format(new Date())) < 0) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0010", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_FinishTime_Must_Greater_Equal_Then_Today", new String[]{billNumber})));
        }
        if (billInfo.getQty() == null || billInfo.getQty().toString().trim().length() == 0 || billInfo.getQty().equals(BigDecimal.ZERO)) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0010", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_QTY_Null", new String[]{billNumber})));
        }
        if (billInfo.getFCalendar() == null && "submit".equalsIgnoreCase(action)) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0010", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_Null_FactoryCalendar", new String[]{billNumber})));
        }
        if (billInfo.getScheduleType() == null || billInfo.getScheduleType().equals((Object)ScheduleTypeEnum.NULL)) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0010", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_Null_ScheduleType", new String[]{billNumber})));
        }
        if (billInfo.getProductType() == null || billInfo.getProductType().equals((Object)ProductTypeEnum.NULL)) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0010", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_Null_ProductType", new String[]{billNumber})));
        }
    }

    protected void checkIsWarehouseChanged(Context ctx, Map param) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("M.FNumber \"FMaterialNumber\",\r\n");
        sql.append("M.FName_").append(ctx.getLocale()).append(" \"FMaterialName\"\r\n");
        sql.append("From ").append(param.get("MergeTempTableName")).append(" T\r\n");
        sql.append("Inner Join T_BD_Material M On M.FID=T.FMaterialID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From T_MM_ManufactureOrder MO\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FSourceBillID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And MO.FMaterialID=T.FMaterialID\r\n");
        sql.append("And IsNull(MO.CFIsWarehouse,0)<>IsNull(T.FIsWarehousing,0)\r\n");
        sql.append(")\r\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet == null || rowSet.size() == 0) {
            return;
        }
        try {
            StringBuffer errorMessage = new StringBuffer();
            while (rowSet.next()) {
                String materialNumber = rowSet.getString("FMaterialNumber") == null ? "" : rowSet.getString("FMaterialNumber");
                String materialName = rowSet.getString("FMaterialName") == null ? "" : rowSet.getString("FMaterialName");
                errorMessage.append("[").append(materialNumber).append("]").append(materialName);
            }
            if (errorMessage != null && errorMessage.toString().trim().length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0020", (Locale)ctx.getLocale()) + "\r\n" + errorMessage.toString()));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected String createAddMOMOTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table AddMOMOTempTable(\r\n");
        sql.append("FMOID VARCHAR(44) Null,\r\n");
        sql.append("FMATERIALID VARCHAR(44) Null,\r\n");
        sql.append("FOPERATIONID VARCHAR(44) Null,\r\n");
        sql.append("FSUMUNITQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FSUMQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FSUMPLANNEDQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FCURSUMUNITQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FCURSUMQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FCURSUMPLANNEDQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FMOREUNITQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FMOREQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FMOREPLANNEDQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FMOSID VARCHAR(44) Null,\r\n");
        sql.append("FMAXSEQ INT NULL\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOID,FMaterialID,FOperationID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createCURMOMOTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table CURMOMOTempTable(\r\n");
        sql.append("FMOID VARCHAR(44) Null,\r\n");
        sql.append("FMATERIALID VARCHAR(44) Null,\r\n");
        sql.append("FOPERATIONID VARCHAR(44) Null,\r\n");
        sql.append("FSUMUNITQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FSUMQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FSUMPLANNEDQTY NUMERIC(28,10) NULL\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOID,FMaterialID,FOperationID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createDeleteTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table DeleteTempTable(\r\n");
        sql.append("FID VARCHAR(44)\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createIMTTTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table IMTTTempTable(\r\n");
        sql.append("FID VARCHAR(44),\r\n");
        sql.append("FIssueMode INT Null,\r\n");
        sql.append("FTransferType INT Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID,FIssueMode,FTransferType", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createJGJMOSEWHTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ZXJJGJMOSEWHTempTable(\r\n");
        sql.append("FID VARCHAR(44) Null,\r\n");
        sql.append("FMOSID VARCHAR(44) Null,\r\n");
        sql.append("FWarehouseID VARCHAR(44) Null,\r\n");
        sql.append("FNewWarehouseID VARCHAR(44) Null,\r\n");
        sql.append("FNewWarehouseGroupName NVARCHAR(80) Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOSID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createMOSERSTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOSERTempTable(\r\n");
        sql.append("FROW INT,\r\n");
        sql.append("FMOSTOCKID VARCHAR(44) Null,\r\n");
        sql.append("FWAREHOUSEID VARCHAR(44) NULL\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOSTOCKID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createMOSEWHGTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOSEWHGTempTable(\r\n");
        sql.append("FMOSTOCKID VARCHAR(44) Null,\r\n");
        sql.append("FCOUNT INT NULL\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOSTOCKID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createMOSEWHTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOSEWHTempTable(\r\n");
        sql.append("FROW INT Null,\r\n");
        sql.append("FMOSTOCKID VARCHAR(44) Null,\r\n");
        sql.append("FPROVIDETYPE INT Null,\r\n");
        sql.append("FWAREHOUSEID VARCHAR(44) Null,\r\n");
        sql.append("FNEWWAREHOUSEID VARCHAR(44) Null,\r\n");
        sql.append("FDEFAULTWAREHOUSEID VARCHAR(44) NULL\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOSTOCKID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FPROVIDETYPE", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOSTOCKID,FPROVIDETYPE", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createMOSOrgTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOSOrgTempTable(\r\n");
        sql.append("FMOSID VARCHAR(44) Null,\r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44) Null,\r\n");
        sql.append("FDefault Int Default(0)\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOSID,FDefault,FStorageOrgUnitID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createMOSTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOSTempTable(\r\n");
        sql.append("FID VARCHAR(44) Null,\r\n");
        sql.append("FParentID VARCHAR(44) Null,\r\n");
        sql.append("FMaterialID VARCHAR(44) Null,\r\n");
        sql.append("FReplaceMaterialID VARCHAR(44) Null,\r\n");
        sql.append("FASSISTPropertyID VARCHAR(44) Null,\r\n");
        sql.append("FUnitID VARCHAR(44) Null,\r\n");
        sql.append("FBaseUnitID VARCHAR(44) Null,\r\n");
        sql.append("FASSISTUnitID VARCHAR(44) Null,\r\n");
        sql.append("FReasonCodeID VARCHAR(44) Null,\r\n");
        sql.append("FWarehouseID VARCHAR(44) Null,\r\n");
        sql.append("FReceiptStockID VARCHAR(44) Null,\r\n");
        sql.append("FCombinationStockID VARCHAR(44) Null,\r\n");
        sql.append("FLocationID VARCHAR(44) Null,\r\n");
        sql.append("FOperationID VARCHAR(44) Null,\r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44) Null,\r\n");
        sql.append("FReceiptStroageOrgUnitID VARCHAR(44) Null,\r\n");
        sql.append("FWorkCenterID VARCHAR(44) Null,\r\n");
        sql.append("FBOMEntryID VARCHAR(44) Null,\r\n");
        sql.append("FSourceBillEntryID VARCHAR(44) Null,\r\n");
        sql.append("FAssociateQTY Numeric(28,10) Null,\r\n");
        sql.append("FLossRatio Numeric(28,10) Null,\r\n");
        sql.append("FExtraRatio Numeric(28,10) Null,\r\n");
        sql.append("FLackRatio Numeric(28,10) Null,\r\n");
        sql.append("FReplaceRatio Numeric(28,10) Null,\r\n");
        sql.append("FUnitReplaceQTY Numeric(28,10) Null,\r\n");
        sql.append("CFOpenQTY Numeric(28,10) Null,\r\n");
        sql.append("CFACTMoveQTY Numeric(28,10) Null,\r\n");
        sql.append("CFALRMoveQTY Numeric(28,10) Null,\r\n");
        sql.append("FQTY Numeric(28,10) Null,\r\n");
        sql.append("FBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FLossQTY Numeric(28,10) Null,\r\n");
        sql.append("FLossBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FACTIssueQTY Numeric(28,10) Null,\r\n");
        sql.append("FACTIssueBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FACTLossQTY Numeric(28,10) Null,\r\n");
        sql.append("FACTLossBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FRejectedQTY Numeric(28,10) Null,\r\n");
        sql.append("FRejectedBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FFeedingQTY Numeric(28,10) Null,\r\n");
        sql.append("FFeedingBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FScrapQTY Numeric(28,10) Null,\r\n");
        sql.append("FScrapBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FWIPQTY Numeric(28,10) Null,\r\n");
        sql.append("FWIPBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FPlannedQTY Numeric(28,10) Null,\r\n");
        sql.append("FPlannedBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnitQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnitBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FMaterialScrapQTY Numeric(28,10) Null,\r\n");
        sql.append("FMaterialScrapBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FMaterialFeedingQTY Numeric(28,10) Null,\r\n");
        sql.append("FMaterialFeedingBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnIssueQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnIssueBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FToStoreQTY Numeric(28,10) Null,\r\n");
        sql.append("FToStoreBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FOriginalPlanQTY Numeric(28,10) Null,\r\n");
        sql.append("FOriginalPlanBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalReceiptQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalReceiptBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnReceiptQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnReceiptBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalDirectReceiveQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalDirectReceiveBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalDSTransferQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalDSTransferBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FDemandTime DateTime Null,\r\n");
        sql.append("FACTUEIssueTime DateTime Null,\r\n");
        sql.append("FBLKSize NVARCHAR(510) Null,\r\n");
        sql.append("FSpecifiedLength NVARCHAR(510) Null,\r\n");
        sql.append("FASSYLocation_").append(ctx.getLocale()).append(" NVARCHAR(510) Null,\r\n");
        sql.append("FRemark NVARCHAR(150) Null,\r\n");
        sql.append("FSEQ INT Null,\r\n");
        sql.append("FLineSEQ VARCHAR(44) Null,\r\n");
        sql.append("FBaseStatus INT Null,\r\n");
        sql.append("FMATREPlaceType INT Null,\r\n");
        sql.append("FTransferType INT Null,\r\n");
        sql.append("FProvideType INT Null,\r\n");
        sql.append("FPickType INT Null,\r\n");
        sql.append("FScrapEXPR INT Null,\r\n");
        sql.append("FReplaceGroupFlag INT Null,\r\n");
        sql.append("FReplacePriority INT Null,\r\n");
        sql.append("CFMoveStatus INT Null,\r\n");
        sql.append("FNewNetWeight Numeric(28,10),\r\n");
        sql.append("FOperationNO INT Null,\r\n");
        sql.append("FIssueMode INT Null,\r\n");
        sql.append("FIsReplaced INT Null,\r\n");
        sql.append("FIsBackFlush INT Null,\r\n");
        sql.append("FIsQTYLimit INT Null,\r\n");
        sql.append("FIsStockALLOT INT Null,\r\n");
        sql.append("CFIsMustREQ INT Null,\r\n");
        sql.append("CFIsLineStoreHouse INT Null,\r\n");
        sql.append("CFIsOwnObject INT Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FParentID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FProvideType", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FWarehouseID,FLocationID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FStorageOrgUnitID,FMaterialID,FWarehouseID,FLocationID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createMOTMergeTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOTMergeTempTable(\r\n");
        sql.append("FMergeID VARCHAR(44) Null,\r\n");
        sql.append("FMPSID VARCHAR(44) Null,\r\n");
        sql.append("FProjectID VARCHAR(44) Null,\r\n");
        sql.append("FTraceID VARCHAR(44) Null,\r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44) Null,\r\n");
        sql.append("FOperationID VARCHAR(44) Null,\r\n");
        sql.append("FWorkCenterID VARCHAR(44) Null,\r\n");
        sql.append("FBaseStatus INT Null,\r\n");
        sql.append("CFIsXOperation INT Null,\r\n");
        sql.append("FEntrustType INT Null,\r\n");
        sql.append("FMOTID VARCHAR(44) Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOTID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "IsNull(FMPSID,'Null'),IsNull(FProjectID,'Null'),IsNull(FTraceID,'Null'),IsNull(FStorageOrgUnitID,'Null'),IsNull(FOperationID,'Null'),IsNull(FWorkCenterID,'Null'),IsNull(FBaseStatus,0)", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createMOTTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOTTempTable(\r\n");
        sql.append("FID VARCHAR(44) Null,\r\n");
        sql.append("FParentID VARCHAR(44) Null,\r\n");
        sql.append("FWorkCenterID VARCHAR(44) Null,\r\n");
        sql.append("FStorageORGUnitID VARCHAR(44) Null,\r\n");
        sql.append("FADMINORGUnitID VARCHAR(44) Null,\r\n");
        sql.append("FControlStrategyID VARCHAR(44) Null,\r\n");
        sql.append("FMaterialID VARCHAR(44) Null,\r\n");
        sql.append("FAssistPropertyID VARCHAR(44) Null,\r\n");
        sql.append("FUnitID VARCHAR(44) Null,\r\n");
        sql.append("FBaseUnitID VARCHAR(44) Null,\r\n");
        sql.append("FAssistUnitID VARCHAR(44) Null,\r\n");
        sql.append("FOperationID VARCHAR(44) Null,\r\n");
        sql.append("FEntrustSupplierID VARCHAR(44) Null,\r\n");
        sql.append("FSubRoutingID VARCHAR(44) Null,\r\n");
        sql.append("FSourceBillEntryID VARCHAR(44) Null,\r\n");
        sql.append("FMergeID VARCHAR(44) Null,\r\n");
        sql.append("FQueuingTime Numeric(28,10) Null,\r\n");
        sql.append("FPrepareTime Numeric(28,10) Null,\r\n");
        sql.append("FWorkTime Numeric(28,10) Null,\r\n");
        sql.append("FWaitingTime Numeric(28,10) Null,\r\n");
        sql.append("FMovingTime Numeric(28,10) Null,\r\n");
        sql.append("FASSCoefficient Numeric(28,10) Null,\r\n");
        sql.append("CFFixedWorkingTime Numeric(28,10) Null,\r\n");
        sql.append("CFTOTFixedWorkTime Numeric(28,10) Null,\r\n");
        sql.append("FProcessBatch Numeric(28,10) Null,\r\n");
        sql.append("FAssociateQTY Numeric(28,10) Null,\r\n");
        sql.append("FQTY Numeric(28,10) Null,\r\n");
        sql.append("FBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FOperQTY Numeric(28,10) Null,\r\n");
        sql.append("FFinishedQTY Numeric(28,10) Null,\r\n");
        sql.append("FFinishedBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FIntoQTY Numeric(28,10) Null,\r\n");
        sql.append("FIntoBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FOutQTY Numeric(28,10) Null,\r\n");
        sql.append("FOutBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FTestQTY Numeric(28,10) Null,\r\n");
        sql.append("FTestBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FPassQTY Numeric(28,10) Null,\r\n");
        sql.append("FPassBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FScrapQTY Numeric(28,10) Null,\r\n");
        sql.append("FScrapBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FRepairQTY Numeric(28,10) Null,\r\n");
        sql.append("FRepairBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalQTYUpper Numeric(28,10) Null,\r\n");
        sql.append("FTotalBaseQTYUpper Numeric(28,10) Null,\r\n");
        sql.append("FTotalQTYLower Numeric(28,10) Null,\r\n");
        sql.append("FTotalBaseQTYLower Numeric(28,10) Null,\r\n");
        sql.append("FREPReportQTY Numeric(28,10) Null,\r\n");
        sql.append("FREPReportBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FREPMoveInQTY Numeric(28,10) Null,\r\n");
        sql.append("FREPMoveInBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FREPMoveOutQTY Numeric(28,10) Null,\r\n");
        sql.append("FREPMoveOutBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnFinishQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnFinishBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnMoveOutQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnMoveOutBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnTestQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnTestBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalSplitQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalSplitBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalDispatchQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalDispatchBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalMaterialScrapQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalMaterialScrapBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalManufactureScrapQTY Numeric(28,10) Null,\r\n");
        sql.append("FTotalManufactureScrapBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnDispatchQTY Numeric(28,10) Null,\r\n");
        sql.append("FUnDispatchBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FConcessionQTY Numeric(28,10) Null,\r\n");
        sql.append("FConcessionBaseQTY Numeric(28,10) Null,\r\n");
        sql.append("FTheoreticalLaborCost Numeric(28,10) Null,\r\n");
        sql.append("FTheoreticalScrapLaborCost Numeric(28,10) Null,\r\n");
        sql.append("FTheoreticalMATScrapLaborCost Numeric(28,10) Null,\r\n");
        sql.append("FActualLaborCost Numeric(28,10) Null,\r\n");
        sql.append("FActualScrapLaborCost Numeric(28,10) Null,\r\n");
        sql.append("FActualMATScrapLaborCost Numeric(28,10) Null,\r\n");
        sql.append("FEarlistWOKTime DateTime Null,\r\n");
        sql.append("FEarlistCMPTime DateTime Null,\r\n");
        sql.append("FLastWorkTime DateTime Null,\r\n");
        sql.append("FLastCMPTime DateTime Null,\r\n");
        sql.append("FCreateTime DateTime Null,\r\n");
        sql.append("CFPROInstruction NVARCHAR(510) Null,\r\n");
        sql.append("FOperationRemark NVARCHAR(255) Null,\r\n");
        sql.append("FSEQ Int Null,\r\n");
        sql.append("FTimeUnit Int Null,\r\n");
        sql.append("FBaseStatus Int Null,\r\n");
        sql.append("CFPERBaseStatus Int Null,\r\n");
        sql.append("FOperationNO Int Null,\r\n");
        sql.append("FEntrustType Int Null,\r\n");
        sql.append("FValuationType Int Null,\r\n");
        sql.append("FOverrunMeasure Int Null,\r\n");
        sql.append("FIsCheckPoint Int Null,\r\n");
        sql.append("FIsReportPoint Int Null,\r\n");
        sql.append("FIsPickingPoint Int Null,\r\n");
        sql.append("FIsKeyOP Int Null,\r\n");
        sql.append("CFIsXOpertion Int Null,\r\n");
        sql.append("FIsCanMerge Int Null,\r\n");
        sql.append("fopertionPrice Numeric(28,10) Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FParentID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "IsNull(FOperationID,'Null'),IsNull(FWorkCenterID,'Null'),IsNull(FBaseStatus,0)", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createNewMOMOTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table NewMOMOTempTable(\r\n");
        sql.append("FMOID VARCHAR(44) Null,\r\n");
        sql.append("FMATERIALID VARCHAR(44) Null,\r\n");
        sql.append("FOPERATIONID VARCHAR(44) Null,\r\n");
        sql.append("FSUMUNITQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FSUMQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FSUMPLANNEDQTY NUMERIC(28,10) NULL\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOID,FMaterialID,FOperationID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createNewMOSETempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table NewMOSETempTable(\r\n");
        sql.append("FID VARCHAR(44) Null,\r\n");
        sql.append("FPARENTID VARCHAR(44) Null,\r\n");
        sql.append("FMATERIALID VARCHAR(44) Null,\r\n");
        sql.append("FREPLACEMATERIALID VARCHAR(44) Null,\r\n");
        sql.append("FASSISTPROPERTYID VARCHAR(44) Null,\r\n");
        sql.append("FUNITID VARCHAR(44) Null,\r\n");
        sql.append("FBASEUNITID VARCHAR(44) Null,\r\n");
        sql.append("FASSISTUNITID VARCHAR(44) Null,\r\n");
        sql.append("FREASONCODEID VARCHAR(44) Null,\r\n");
        sql.append("FWAREHOUSEID VARCHAR(44) Null,\r\n");
        sql.append("FRECEIPTSTOCKID VARCHAR(44) Null,\r\n");
        sql.append("FCOMBINATIONSTOCKID VARCHAR(44) Null,\r\n");
        sql.append("FLOCATIONID VARCHAR(44) Null,\r\n");
        sql.append("FOPERATIONID VARCHAR(44) Null,\r\n");
        sql.append("FSTORAGEORGUNITID VARCHAR(44) Null,\r\n");
        sql.append("FRECEIPTSTROAGEORGUNITID VARCHAR(44) Null,\r\n");
        sql.append("FWORKCENTERID VARCHAR(44) Null,\r\n");
        sql.append("FBOMENTRYID VARCHAR(44) Null,\r\n");
        sql.append("FSOURCEBILLENTRYID VARCHAR(44) Null,\r\n");
        sql.append("FASSOCIATEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FLOSSRATIO NUMERIC(28,10) Null,\r\n");
        sql.append("FEXTRARATIO NUMERIC(28,10) Null,\r\n");
        sql.append("FLACKRATIO NUMERIC(28,10) Null,\r\n");
        sql.append("FREPLACERATIO NUMERIC(28,10) Null,\r\n");
        sql.append("FUNITREPLACEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("CFOPENQTY NUMERIC(28,10) Null,\r\n");
        sql.append("CFACTMOVEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("CFALRMOVEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FLOSSQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FLOSSBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FACTISSUEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FACTISSUEBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FACTLOSSQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FACTLOSSBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FREJECTEDQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FREJECTEDBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FFEEDINGQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FFEEDINGBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FSCRAPQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FSCRAPBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FWIPQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FWIPBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FPLANNEDQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FPLANNEDBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FUNITQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FUNITBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FMATERIALSCRAPQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FMATERIALSCRAPBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FMATERIALFEEDINGQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FMATERIALFEEDINGBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FUNISSUEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FUNISSUEBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FTOSTOREQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FTOSTOREBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FORIGINALPLANQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FORIGINALPLANBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FTOTALRECEIPTQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FTOTALRECEIPTBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FUNRECEIPTQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FUNRECEIPTBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FTOTALDIRECTRECEIVEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FTOTALDIRECTRECEIVEBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FTOTALDSTRANSFERQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FTOTALDSTRANSFERBASEQTY NUMERIC(28,10) Null,\r\n");
        sql.append("FDEMANDTIME DATETIME Null,\r\n");
        sql.append("FACTUEISSUETIME DATETIME Null,\r\n");
        sql.append("FBLKSIZE NVARCHAR(510) Null,\r\n");
        sql.append("FSPECIFIEDLENGTH NVARCHAR(510) Null,\r\n");
        sql.append("FASSYLOCATION_L2 NVARCHAR(510) Null,\r\n");
        sql.append("FSEQ INT Null,\r\n");
        sql.append("FLINESEQ VARCHAR(44) Null,\r\n");
        sql.append("FBASESTATUS INT Null,\r\n");
        sql.append("FMATREPLACETYPE INT Null,\r\n");
        sql.append("FTRANSFERTYPE INT Null,\r\n");
        sql.append("FPROVIDETYPE INT Null,\r\n");
        sql.append("FPICKTYPE INT Null,\r\n");
        sql.append("FSCRAPEXPR INT Null,\r\n");
        sql.append("FREPLACEGROUPFLAG INT Null,\r\n");
        sql.append("FREPLACEPRIORITY INT Null,\r\n");
        sql.append("CFMOVESTATUS INT Null,\r\n");
        sql.append("FNEWNETWEIGHT NUMERIC(28,10),\r\n");
        sql.append("FOPERATIONNO INT Null,\r\n");
        sql.append("FISSUEMODE INT Null,\r\n");
        sql.append("FISREPLACED INT Null,\r\n");
        sql.append("FISBACKFLUSH INT Null,\r\n");
        sql.append("FISQTYLIMIT INT Null,\r\n");
        sql.append("FISSTOCKALLOT INT Null,\r\n");
        sql.append("CFISMUSTREQ INT Null,\r\n");
        sql.append("CFISLINESTOREHOUSE INT NULL,\r\n");
        sql.append("CFISOWNOBJECT INT Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FParentID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createPBOMEntryBOMEntryTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table PBOMEntryBOMEntryTempTable(\r\n");
        sql.append("FPBOMEntryID VARCHAR(44) Null,\r\n");
        sql.append("FBOMEntryID VARCHAR(44) Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FPBOMEntryID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createPTTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table PTTempTable(\r\n");
        sql.append("FID VARCHAR(44),\r\n");
        sql.append("FPickType INT Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID,FPickType", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createScheduleTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ScheduleTempTable(\r\n");
        sql.append("FID VARCHAR(44) Not Null,\r\n");
        sql.append("FLevel INT Default 0 Not Null,\r\n");
        sql.append("FOperationID VARCHAR(44),\r\n");
        sql.append("FStartTime DateTime,\r\n");
        sql.append("FFinishTime DateTime,\r\n");
        sql.append("FCTID VARCHAR(44),\r\n");
        sql.append("FCTTime DateTime,\r\n");
        sql.append("FOperationTime Numeric(21,8),\r\n");
        sql.append("FTimeUnit INT\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FOperationID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ExpandBOMTempTable(\r\n");
        sql.append("FID VARCHAR(44) Not Null,\r\n");
        sql.append("FParentID VARCHAR(4000),\r\n");
        sql.append("FLevel INT Default 0 Not Null,\r\n");
        sql.append("FStorageORGUnitID VARCHAR(44),\r\n");
        sql.append("FIsLimitedQty INT,\r\n");
        sql.append("FExtraRatio Numeric(21,8),\r\n");
        sql.append("FLackRatio Numeric(21,8),\r\n");
        sql.append("FReceiveORGUnitID VARCHAR(44),\r\n");
        sql.append("FMaterialID VARCHAR(44),\r\n");
        sql.append("FUnitID VARCHAR(44),\r\n");
        sql.append("FBIZTypeID VARCHAR(44),\r\n");
        sql.append("FTransactionTypeID VARCHAR(44),\r\n");
        sql.append("FScheduleType INT,\r\n");
        sql.append("FIsWarehousing INT,\r\n");
        sql.append("FProjectID VARCHAR(44),\r\n");
        sql.append("FTraceID VARCHAR(44),\r\n");
        sql.append("FEndTraceID VARCHAR(44),\r\n");
        sql.append("FBOMID VARCHAR(44),\r\n");
        sql.append("FRoutingID VARCHAR(44),\r\n");
        sql.append("FADMINORGUnitID VARCHAR(44),\r\n");
        sql.append("FDispathUserID VARCHAR(44),\r\n");
        sql.append("FQTY Numeric(21,8),\r\n");
        sql.append("FDeleted INT Default 0 Not Null,\r\n");
        sql.append("FStartDate DateTime,\r\n");
        sql.append("FFinishDate DateTime,\r\n");
        sql.append("FSDFCWorkSeq INT,\r\n");
        sql.append("FMaterialAttribute INT,\r\n");
        sql.append("FIsAudit INT,\r\n");
        sql.append("FCostObjectMOID VARCHAR(44),\r\n");
        sql.append("FCostObjectID VARCHAR(44),\r\n");
        sql.append("FSupplyStorageOrgUnitID VARCHAR(44)\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FCostObjectMOID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FStorageOrgUnitID,FMaterialID,FProjectID,FTraceID,FBOMID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createWarehouseTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table WarehouseTempTable(\r\n");
        sql.append("FID VARCHAR(44) Not Null,\r\n");
        sql.append("FMOStockID VARCHAR(44),\r\n");
        sql.append("FProvideType INT Null,\r\n");
        sql.append("FWarehouseID VARCHAR(44) Null,\r\n");
        sql.append("FNewWarehouseID VARCHAR(44) Null,\r\n");
        sql.append("FDefaultWareHouseID VARCHAR(44) Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOStockID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FProvideType", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOStockID,FProvideType", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected void expandChild(Context ctx, Map param) throws BOSException, EASBizException {
        String fallbackBOMNumber = param.containsKey("FallbackBOMNumber") ? (param.get("FallbackBOMNumber") == null ? null : param.get("FallbackBOMNumber").toString()) : null;
        int level = 0;
        int insertRows = 0;
        int effectedRows = 0;
        StringBuffer sql = new StringBuffer();
        while (this.isExpand(ctx, param.get("TempTableName").toString(), level)) {
            if (level >= 50) {
                throw new BomException(BomException.CYCLE);
            }
            sql.setLength(0);
            sql.append(this.insertTempTableSQL(param.get("TempTableName").toString()));
            sql.append("Select\r\n");
            sql.append("NewBOSID('12345678'),\r\n");
            sql.append("T.FParentID || ' ' || T.FID || ' ',\r\n");
            sql.append("" + (level + 1) + ",\r\n");
            sql.append("T.FStorageORGUnitID,\r\n");
            sql.append("T.FReceiveORGUnitID,\r\n");
            sql.append("BE.FMaterialID,\r\n");
            sql.append("M.FBaseUnit,\r\n");
            sql.append("Case\r\n");
            sql.append("When MP.FProductTRANType Is Not Null And LEN(MP.FProductTRANType)>0 Then\r\n");
            sql.append("\tMPPT.FBIZTypeID\r\n");
            sql.append("Else\r\n");
            sql.append("\tCase\r\n");
            sql.append("\tWhen PT.FID Is Not Null And LEN(PT.FID)>0 Then\r\n");
            sql.append("\t\tPT.FBIZTypeID\r\n");
            sql.append("\tElse\r\n");
            sql.append("\t\tNull\r\n");
            sql.append("\tEnd\r\n");
            sql.append("End,\r\n");
            sql.append("Case\r\n");
            sql.append("When MP.FProductTRANType Is Null Or LEN(MP.FProductTRANType)=0 Then\r\n");
            sql.append("PT.FID\r\n");
            sql.append("Else\r\n");
            sql.append("MP.FProductTRANType\r\n");
            sql.append("End,\r\n");
            sql.append("Case\r\n");
            sql.append("When MP.FProductTRANType Is Not Null And LEN(MP.FProductTRANType)>0 Then\r\n");
            sql.append("\tCase\r\n");
            sql.append("\tWhen IsNull(MPPT.FIsWPManagement,0)=0 Then\r\n");
            sql.append("\t\t10\r\n");
            sql.append("\tElse\r\n");
            sql.append("\t\tMPPT.FScheduleType\r\n");
            sql.append("\tEnd\r\n");
            sql.append("Else\r\n");
            sql.append("\tCase\r\n");
            sql.append("\tWhen PT.FID Is Not Null And LEN(PT.FID)>0 Then\r\n");
            sql.append("\t\tCase\r\n");
            sql.append("\t\tWhen IsNull(PT.FIsWPManagement,0)=0 Then\r\n");
            sql.append("\t\t\t10\r\n");
            sql.append("\t\tElse\r\n");
            sql.append("\t\t\tPT.FScheduleType\r\n");
            sql.append("\t\tEnd\r\n");
            sql.append("\tElse\r\n");
            sql.append("\t\t10\r\n");
            sql.append("\tEnd\r\n");
            sql.append("End,\r\n");
            if (ProductTypeEnum.STANDARD.getAlias().equals(param.get("ProductType").toString())) {
                sql.append("MI.CFIsWarehouse,\r\n");
            } else {
                sql.append("0,\r\n");
            }
            sql.append("T.FProjectID,\r\n");
            sql.append("T.FTraceID,\r\n");
            sql.append("T.FEndTraceID,\r\n");
            sql.append("B.FID,\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("R.FID\r\n");
            sql.append("From T_MM_StandardRooting R\r\n");
            sql.append("Where\r\n");
            sql.append("R.FStatus=60\r\n");
            sql.append("And R.FMaterialID=BE.FMaterialID\r\n");
            sql.append("And R.FStorageORGUnitID='" + param.get("StorageORGUnitID").toString() + "'\r\n");
            sql.append("And R.FIsMainRooting=1\r\n");
            sql.append("),\r\n");
            sql.append("MP.FDutyDepartment,\r\n");
            sql.append("MP.FPlanner,\r\n");
            sql.append("Case\r\n");
            sql.append("When IsNull(B.FProductQTY,0)<=0 Then T.FQTY * BE.FConsumeFixQTY\r\n");
            sql.append("Else\r\n");
            sql.append("(T.FQTY/B.FProductQTY) * BE.FConsumeFixQTY\r\n");
            sql.append("End,\r\n");
            sql.append("Null,\r\n");
            sql.append("T.FStartDate,\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("Case IsNull(FCE.FWorkDateSeq,0)\r\n");
            sql.append("When 0 Then IsNull(FCE.FPreWorkDaySeq,0) -IsNull(LT.FProduceLeadTime,0)\r\n");
            sql.append("Else IsNull(FCE.FWorkDateSeq,0) -IsNull(LT.FProduceLeadTime,0)\r\n");
            sql.append("End\r\n");
            sql.append("From T_MM_FactoryCalendarEntry FCE \r\n");
            sql.append("Where\r\n");
            sql.append("FCE.FParentID='").append(param.get("FactoryCalendarID").toString()).append("'\r\n");
            sql.append("And To_CHAR(FCE.FWorkDate,'YYYY-MM-DD')=To_CHAR(T.FStartDate,'YYYY-MM-DD')\r\n");
            sql.append("),\r\n");
            sql.append("BE.FMaterialProp,\r\n");
            sql.append("1,\r\n");
            sql.append("Case\r\n");
            sql.append("When IsNull(MI.CFIsWarehouse,0)=1 Then Null\r\n");
            sql.append("Else T.FCostObjectMOID\r\n");
            sql.append("End,\r\n");
            sql.append("Null,\r\n");
            sql.append("BE.FSupplyStorageOrgUnitID\r\n");
            sql.append("From " + param.get("TempTableName").toString() + " T\r\n");
            sql.append("Inner Join T_MM_BOMEntry BE On BE.FParentID=T.FBOMID\r\n");
            sql.append("Left Join T_MM_BOM PB On PB.FID=T.FBOMID\r\n");
            sql.append("Left Join T_MM_BOM B\r\n");
            sql.append("On\r\n");
            sql.append("B.FMaterialID=BE.FMaterialID\r\n");
            sql.append("And B.FBOMType=50\r\n");
            sql.append("And B.FBaseStatus=4\r\n");
            sql.append("And B.FProjectID=T.FProjectID\r\n");
            sql.append("And B.FStorageORGUnitID=BE.FSupplyStorageOrgUnitID\r\n");
            sql.append("Inner Join T_BD_Material M On M.FID=BE.FMaterialID\r\n");
            sql.append("Left Join  T_BD_MaterialPlan MP On\r\n");
            sql.append("MP.FORGUnit=T.FStorageORGUnitID\r\n");
            sql.append("And MP.FMaterialID=BE.FMaterialID\r\n");
            sql.append("Left Join T_BD_MaterialInventory MI On MI.FMaterialID=BE.FMaterialID And MI.FORGUnit=T.FStorageORGUnitID\r\n");
            sql.append("Left Join T_MM_ProductTransactionType MPPT On MPPT.FID=MP.FProductTRANType\r\n");
            sql.append("Inner Join T_MM_TrackNumber BTN On BTN.FID=BE.CFBeginCarNOID\r\n");
            sql.append("Inner Join T_MM_TrackNumber ETN On ETN.FID=BE.CFEndCarNOID\r\n");
            sql.append("Inner Join T_MM_TrackNumber TN On TN.FID=T.FTraceID\r\n");
            sql.append("Left Join (\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("PT.FID,\r\n");
            sql.append("PT.FBIZTypeID,\r\n");
            sql.append("PT.FScheduleType,\r\n");
            sql.append("PT.FIsWPManagement\r\n");
            sql.append("From T_MM_ProductTransactionType PT\r\n");
            sql.append("Where\r\n");
            sql.append("PT.FStorageOrgUnitID='" + param.get("StorageORGUnitID").toString() + "'\r\n");
            sql.append("And PT.FBIZTypeID='vGXRx5fFSsCYz9Zv7CzzgyQHQ1w='\r\n");
            sql.append("And PT.FIsDefault=1\r\n");
            sql.append("And PT.FStatus=20\r\n");
            sql.append(") PT On 1=1\r\n");
            sql.append("Left Join T_BD_MaterialPlan LT\r\n");
            sql.append("On LT.FMaterialID=BE.FMaterialID\r\n");
            sql.append("And LT.FORGUnit=BE.FSupplyStorageOrgUnitID\r\n");
            sql.append("Where\r\n");
            sql.append("T.FLevel=" + level + "\r\n");
            sql.append("And T.FBOMID Is Not Null\r\n");
            sql.append("And BTN.FNumber<=TN.FNumber\r\n");
            sql.append("And ETN.FNumber>=TN.FNumber\r\n");
            sql.append("And IsNull(T.FDeleted,0)=0\r\n");
            sql.append("And IsNull(MP.FPlanningMode,0)<>").append(2).append("\r\n");
            insertRows = this.executeSQL(ctx, sql.toString());
            if (insertRows < 1) break;
            sql.setLength(0);
            sql.append("Update " + param.get("TempTableName").toString() + "\r\n");
            sql.append("Set FRoutingID=\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("R.FID\r\n");
            sql.append("From T_MM_StandardRooting R\r\n");
            sql.append("Where\r\n");
            sql.append("R.FStatus=60\r\n");
            sql.append("And R.FMaterialID=" + param.get("TempTableName").toString() + ".FMaterialID\r\n");
            sql.append("And R.FStorageORGUnitID='" + param.get("StorageORGUnitID").toString() + "'\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("FLevel=" + (level + 1) + "\r\n");
            sql.append("And FRoutingID Is Null\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Update " + param.get("TempTableName").toString() + "\r\n");
            sql.append("Set FRoutingID=\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("R.FID\r\n");
            sql.append("From T_MM_StandardRooting R\r\n");
            sql.append("Where\r\n");
            sql.append("R.FNumber='-'\r\n");
            sql.append("And R.FStorageORGUnitID='" + param.get("StorageORGUnitID").toString() + "'\r\n");
            sql.append("),\r\n");
            sql.append("FIsAudit=0\r\n");
            sql.append("Where\r\n");
            sql.append("FLevel=" + (level + 1) + "\r\n");
            sql.append("And FRoutingID Is Null\r\n");
            this.executeSQL(ctx, sql.toString());
            if (fallbackBOMNumber != null && fallbackBOMNumber.trim().length() > 0) {
                sql.setLength(0);
                sql.append("Update " + param.get("TempTableName").toString() + "\r\n");
                sql.append("Set FBOMID=\r\n");
                sql.append("(\r\n");
                sql.append("Select\r\n");
                sql.append("Top 1\r\n");
                sql.append("BOM.FID\r\n");
                sql.append("From T_MM_BOM BOM\r\n");
                sql.append("Where\r\n");
                sql.append("BOM.FNumber='").append(fallbackBOMNumber).append("'\r\n");
                sql.append("And BOM.FStorageORGUnitID='" + param.get("StorageORGUnitID").toString() + "'\r\n");
                sql.append(")\r\n");
                sql.append("Where\r\n");
                sql.append("FLevel=" + (level + 1) + "\r\n");
                sql.append("And FBOMID Is Null\r\n");
                effectedRows = this.executeSQL(ctx, sql.toString());
                if (effectedRows > 0) {
                    // empty if block
                }
            }
            sql.setLength(0);
            sql.append("Update " + param.get("TempTableName").toString() + "\r\n");
            sql.append("Set\r\n");
            sql.append("FStartDate=(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("FCE.FWorkDate\r\n");
            sql.append("From T_MM_FactoryCalendarEntry FCE \r\n");
            sql.append("Where\r\n");
            sql.append("FCE.FParentID='").append(param.get("FactoryCalendarID").toString()).append("'\r\n");
            sql.append("And IsNull(FCE.FWorkDateSeq,0)<>0\r\n");
            sql.append("And IsNull(FCE.FWorkDateSeq,0)=IsNull(").append(param.get("TempTableName").toString()).append(".FSDFCWorkSeq,0)\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("FLevel=" + (level + 1) + "\r\n");
            sql.append("And FFinishDate Is Not Null\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Update " + param.get("TempTableName").toString() + "\r\n");
            sql.append("Set\r\n");
            sql.append("FCostObjectMOID=FID\r\n");
            sql.append("Where\r\n");
            sql.append("FLevel=" + (level + 1) + "\r\n");
            sql.append("And IsNull(FIsWarehousing,0)=1\r\n");
            this.executeSQL(ctx, sql.toString());
            ++level;
        }
    }

    protected void expandCOMaterial(Context ctx, Map param) throws EASBizException, BOSException {
        if (param.get("COMaterialID") != null) {
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append(this.insertTempTableSQL(param.get("TempTableName").toString()));
            sql.append("Select\r\n");
            sql.append("NewBOSID('12345678'),\r\n");
            sql.append("Null,\r\n");
            sql.append("-1,\r\n");
            sql.append("PS.CFStorageORGUnitID,\r\n");
            sql.append("PS.CFReceiveORGUnitID,\r\n");
            sql.append("PS.CFCOMaterialID,\r\n");
            sql.append("M.FBaseUnit,\r\n");
            sql.append("Case\r\n");
            sql.append("When MP.FProductTRANType Is Not Null And LEN(MP.FProductTRANType)>0 Then\r\n");
            sql.append("\tMPPT.FBIZTypeID\r\n");
            sql.append("Else\r\n");
            sql.append("\tCase\r\n");
            sql.append("\tWhen PT.FID Is Not Null And LEN(PT.FID)>0 Then\r\n");
            sql.append("\t\tPT.FBIZTypeID\r\n");
            sql.append("\tElse\r\n");
            sql.append("\t\tNull\r\n");
            sql.append("\tEnd\r\n");
            sql.append("End,\r\n");
            sql.append("Case\r\n");
            sql.append("When MP.FProductTRANType Is Null Or LEN(MP.FProductTRANType)=0 Then\r\n");
            sql.append("\tPT.FID\r\n");
            sql.append("Else\r\n");
            sql.append("\tMP.FProductTRANType\r\n");
            sql.append("End,\r\n");
            sql.append("Case\r\n");
            sql.append("When MP.FProductTRANType Is Not Null And LEN(MP.FProductTRANType)>0 Then\r\n");
            sql.append("\tCase\r\n");
            sql.append("\tWhen IsNull(MPPT.FIsWPManagement,0)=0 Then\r\n");
            sql.append("\t\t10\r\n");
            sql.append("\tElse\r\n");
            sql.append("\t\tMPPT.FScheduleType\r\n");
            sql.append("\tEnd\r\n");
            sql.append("Else\r\n");
            sql.append("\tCase\r\n");
            sql.append("\tWhen PT.FID Is Not Null And LEN(PT.FID)>0 Then\r\n");
            sql.append("\t\tCase\r\n");
            sql.append("\t\tWhen IsNull(PT.FIsWPManagement,0)=0 Then\r\n");
            sql.append("\t\t\t10\r\n");
            sql.append("\t\tElse\r\n");
            sql.append("\t\t\tPT.FScheduleType\r\n");
            sql.append("\t\tEnd\r\n");
            sql.append("\tElse\r\n");
            sql.append("\t\t10\r\n");
            sql.append("\tEnd\r\n");
            sql.append("End,\r\n");
            sql.append("1,\r\n");
            sql.append("PS.CFProjectID,\r\n");
            sql.append("PS.CFTraceID,\r\n");
            sql.append("PS.CFEndTraceID,\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("B.FID\r\n");
            sql.append("From T_MM_BOM B\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And B.FMaterialID=PS.CFCOMaterialID\r\n");
            sql.append("And B.FBOMType=").append(50).append("\r\n");
            sql.append("And B.FBaseStatus=").append(4).append("\r\n");
            sql.append("And B.FProjectID=PS.CFProjectID\r\n");
            sql.append("And B.FStorageORGUnitID='").append(param.get("StorageORGUnitID").toString()).append("'\r\n");
            sql.append("),\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("B.FID\r\n");
            sql.append("From\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("RowNUM FRow,\r\n");
            sql.append("A.FID\r\n");
            sql.append("From\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("R.FID\r\n");
            sql.append("From T_MM_StandardRooting R\r\n");
            sql.append("Where\r\n");
            sql.append("R.FStatus=60\r\n");
            sql.append("And R.FMaterialID='" + param.get("COMaterialID").toString() + "'\r\n");
            sql.append("And R.FStorageORGUnitID='" + param.get("StorageORGUnitID").toString() + "'\r\n");
            sql.append("Order By\r\n");
            sql.append("R.FIsMainRooting DESC,\r\n");
            sql.append("R.FBIZDate DESC\r\n");
            sql.append(") A\r\n");
            sql.append(") B\r\n");
            sql.append("),\r\n");
            sql.append("MP.FDutyDepartment,\r\n");
            sql.append("MP.FPlanner,\r\n");
            sql.append("PS.CFQTY,\r\n");
            sql.append("To_Date('").append(OperationScheduleUtils.sdfDateTime.format((Timestamp)param.get("COMaterialStartTime"))).append("'),\r\n");
            sql.append("To_Date('").append(OperationScheduleUtils.sdfDateTime.format((Timestamp)param.get("COMaterialFinishTime"))).append("'),\r\n");
            sql.append("Null,\r\n");
            sql.append("MP.FMaterialATTR,\r\n");
            sql.append("1,\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("PS.CFStorageORGUnitID\r\n");
            sql.append("From CT_PS_MasterProductionSchedule PS\r\n");
            sql.append("Inner Join T_BD_Material M On M.FID=PS.CFCOMaterialID\r\n");
            sql.append("Inner Join T_BD_MaterialPlan MP On MP.FMaterialID=PS.CFCOMaterialID And MP.FORGUnit=PS.CFStorageORGUnitID\r\n");
            sql.append("Left Join T_MM_ProductTransactionType MPPT On MPPT.FID=MP.FProductTRANType\r\n");
            sql.append("Inner Join T_MM_TrackNumber TN On TN.FID=PS.CFTraceID\r\n");
            sql.append("Left Join (\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("PT.FID,\r\n");
            sql.append("PT.FBIZTypeID,\r\n");
            sql.append("PT.FScheduleType,\r\n");
            sql.append("PT.FIsWPManagement\r\n");
            sql.append("From T_MM_ProductTransactionType PT\r\n");
            sql.append("Where\r\n");
            sql.append("PT.FStorageOrgUnitID='" + param.get("StorageORGUnitID").toString() + "'\r\n");
            sql.append("And PT.FBIZTypeID='vGXRx5fFSsCYz9Zv7CzzgyQHQ1w='\r\n");
            sql.append("And PT.FIsDefault=1\r\n");
            sql.append("And PT.FStatus=20\r\n");
            sql.append(") PT On 1=1\r\n");
            sql.append("Where\r\n");
            sql.append("PS.FID='" + param.get("MasterProductionScheduleID").toString() + "'\r\n");
            sql.append("And MP.FMaterialATTR=10030\r\n");
            int insertRows = this.executeSQL(ctx, sql.toString());
            if (insertRows == 0) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0021", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Generate_COMaterial_MO_Failed", new String[]{param.get("MasterProductionScheduleNumber").toString()})));
            }
            sql.setLength(0);
            sql.append("Update " + param.get("TempTableName").toString() + "\r\n");
            sql.append("Set FRoutingID=\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("R.FID\r\n");
            sql.append("From T_MM_StandardRooting R\r\n");
            sql.append("Where\r\n");
            sql.append("R.FNumber='-'\r\n");
            sql.append("And R.FStorageORGUnitID='" + param.get("StorageORGUnitID").toString() + "'\r\n");
            sql.append("),\r\n");
            sql.append("FIsAudit=0\r\n");
            sql.append("Where\r\n");
            sql.append("FLevel=-1\r\n");
            sql.append("And FRoutingID Is Null\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Update " + param.get("TempTableName").toString() + "\r\n");
            sql.append("Set\r\n");
            sql.append("FCostObjectMOID=FID\r\n");
            sql.append("Where\r\n");
            sql.append("FLevel=-1\r\n");
            this.executeSQL(ctx, sql.toString());
        }
    }

    protected int expandTop(Context ctx, Map param) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(this.insertTempTableSQL(param.get("TempTableName").toString()));
        sql.append("Select\r\n");
        sql.append("NewBOSID('12345678'),\r\n");
        sql.append("(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("' ' || T.FID || ' '\r\n");
        sql.append("From ").append(param.get("TempTableName").toString()).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("IsNull(T.FLevel,0)= -1\r\n");
        sql.append("),\r\n");
        sql.append("0,\r\n");
        sql.append("PS.CFStorageORGUnitID,\r\n");
        sql.append("PS.CFReceiveORGUnitID,\r\n");
        sql.append("PS.CFProductID,\r\n");
        sql.append("M.FBaseUnit,\r\n");
        sql.append("Case\r\n");
        sql.append("When MP.FProductTRANType Is Not Null And LEN(MP.FProductTRANType)>0 Then\r\n");
        sql.append("\tMPPT.FBIZTypeID\r\n");
        sql.append("Else\r\n");
        sql.append("\tCase\r\n");
        sql.append("\tWhen PT.FID Is Not Null And LEN(PT.FID)>0 Then\r\n");
        sql.append("\t\tPT.FBIZTypeID\r\n");
        sql.append("\tElse\r\n");
        sql.append("\t\tNull\r\n");
        sql.append("\tEnd\r\n");
        sql.append("End,\r\n");
        sql.append("Case\r\n");
        sql.append("When MP.FProductTRANType Is Null Or LEN(MP.FProductTRANType)=0 Then\r\n");
        sql.append("\tPT.FID\r\n");
        sql.append("Else\r\n");
        sql.append("\tMP.FProductTRANType\r\n");
        sql.append("End,\r\n");
        sql.append("Case\r\n");
        sql.append("When MP.FProductTRANType Is Not Null And LEN(MP.FProductTRANType)>0 Then\r\n");
        sql.append("\tCase\r\n");
        sql.append("\tWhen IsNull(MPPT.FIsWPManagement,0)=0 Then\r\n");
        sql.append("\t\t10\r\n");
        sql.append("\tElse\r\n");
        sql.append("\t\tMPPT.FScheduleType\r\n");
        sql.append("\tEnd\r\n");
        sql.append("Else\r\n");
        sql.append("\tCase\r\n");
        sql.append("\tWhen PT.FID Is Not Null And LEN(PT.FID)>0 Then\r\n");
        sql.append("\t\tCase\r\n");
        sql.append("\t\tWhen IsNull(PT.FIsWPManagement,0)=0 Then\r\n");
        sql.append("\t\t\t10\r\n");
        sql.append("\t\tElse\r\n");
        sql.append("\t\t\tPT.FScheduleType\r\n");
        sql.append("\t\tEnd\r\n");
        sql.append("\tElse\r\n");
        sql.append("\t\t10\r\n");
        sql.append("\tEnd\r\n");
        sql.append("End,\r\n");
        if (ProductTypeEnum.STANDARD.getAlias().equals(param.get("ProductType").toString())) {
            sql.append("MI.CFIsWarehouse,\r\n");
        } else {
            sql.append("1,\r\n");
        }
        sql.append("PS.CFProjectID,\r\n");
        sql.append("PS.CFTraceID,\r\n");
        sql.append("PS.CFEndTraceID,\r\n");
        sql.append("PS.CFBOMID,\r\n");
        sql.append("(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("B.FID\r\n");
        sql.append("From\r\n");
        sql.append("(\r\n");
        sql.append("Select\r\n");
        sql.append("RowNUM FRow,\r\n");
        sql.append("A.FID\r\n");
        sql.append("From\r\n");
        sql.append("(\r\n");
        sql.append("Select\r\n");
        sql.append("R.FID\r\n");
        sql.append("From T_MM_StandardRooting R\r\n");
        sql.append("Where\r\n");
        sql.append("R.FStatus=60\r\n");
        sql.append("And R.FMaterialID='" + param.get("ProductID").toString() + "'\r\n");
        sql.append("And R.FStorageORGUnitID='" + param.get("StorageORGUnitID").toString() + "'\r\n");
        sql.append("Order By\r\n");
        sql.append("R.FIsMainRooting DESC,\r\n");
        sql.append("R.FBIZDate DESC\r\n");
        sql.append(") A\r\n");
        sql.append(") B\r\n");
        sql.append("),\r\n");
        sql.append("MP.FDutyDepartment,\r\n");
        sql.append("MP.FPlanner,\r\n");
        sql.append("PS.CFQTY,\r\n");
        sql.append("To_Date('").append(OperationScheduleUtils.sdfDateTime.format((Timestamp)param.get("StartTime"))).append("'),\r\n");
        sql.append("To_Date('").append(OperationScheduleUtils.sdfDateTime.format((Timestamp)param.get("FinishTime"))).append("'),\r\n");
        sql.append("Null,\r\n");
        sql.append("MP.FMaterialATTR,\r\n");
        sql.append("1,\r\n");
        sql.append("Case\r\n");
        sql.append("When IsNull(MI.CFIsWarehouse,0)=1 Then Null\r\n");
        sql.append("Else (\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("T.FID\r\n");
        sql.append("From ").append(param.get("TempTableName").toString()).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And IsNull(T.FLevel,0)=-1\r\n");
        sql.append(")\r\n");
        sql.append("End,\r\n");
        sql.append("Null,\r\n");
        sql.append("PS.CFStorageORGUnitID\r\n");
        sql.append("From CT_PS_MasterProductionSchedule PS\r\n");
        sql.append("Inner Join T_BD_Material M On M.FID=PS.CFProductID\r\n");
        sql.append("Left Join T_BD_MaterialPlan MP On MP.FMaterialID=PS.CFProductID And MP.FORGUnit=PS.CFStorageORGUnitID\r\n");
        sql.append("Left Join T_BD_MaterialInventory MI On MI.FMaterialID=PS.CFProductID And MI.FORGUnit=PS.CFStorageORGUnitID\r\n");
        sql.append("Left Join T_MM_ProductTransactionType MPPT On MPPT.FID=MP.FProductTRANType\r\n");
        sql.append("Left Join (\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("PT.FID,\r\n");
        sql.append("PT.FBIZTypeID,\r\n");
        sql.append("PT.FScheduleType,\r\n");
        sql.append("PT.FIsWPManagement\r\n");
        sql.append("From T_MM_ProductTransactionType PT\r\n");
        sql.append("Where\r\n");
        sql.append("PT.FStorageOrgUnitID='" + param.get("StorageORGUnitID").toString() + "'\r\n");
        sql.append("And PT.FBIZTypeID='vGXRx5fFSsCYz9Zv7CzzgyQHQ1w='\r\n");
        sql.append("And PT.FIsDefault=1\r\n");
        sql.append("And PT.FStatus=20\r\n");
        sql.append(") PT On 1=1\r\n");
        sql.append("Where\r\n");
        sql.append("PS.FID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        int insertRows = this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(param.get("TempTableName").toString()).append("\r\n");
        sql.append("Set FRoutingID=\r\n");
        sql.append("(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("R.FID\r\n");
        sql.append("From T_MM_StandardRooting R\r\n");
        sql.append("Where\r\n");
        sql.append("R.FNumber='-'\r\n");
        sql.append("And R.FStorageORGUnitID='").append(param.get("StorageORGUnitID").toString()).append("'\r\n");
        sql.append("),\r\n");
        sql.append("FIsAudit=0\r\n");
        sql.append("Where\r\n");
        sql.append("FLevel=0\r\n");
        sql.append("And FRoutingID Is Null\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update " + param.get("TempTableName").toString() + "\r\n");
        sql.append("Set\r\n");
        sql.append("FCostObjectMOID=FID\r\n");
        sql.append("Where\r\n");
        sql.append("FLevel=0\r\n");
        sql.append("And IsNull(FIsWarehousing,0)=1\r\n");
        this.executeSQL(ctx, sql.toString());
        return insertRows;
    }

    protected void generateBOTPRelation(Context ctx, Map param) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String curUserID = ContextUtil.getCurrentUserInfo((Context)ctx) == null ? "" : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        sql.setLength(0);
        sql.append("Insert Into T_BOT_Relation(\r\n");
        sql.append("FID,\r\n");
        sql.append("FSRCEntityID,\r\n");
        sql.append("FDESTEntityID,\r\n");
        sql.append("FSRCObjectID,\r\n");
        sql.append("FDESTObjectID,\r\n");
        sql.append("FDate,\r\n");
        sql.append("FOperatorID,\r\n");
        sql.append("FIsEffected,\r\n");
        sql.append("FBOTMappingID,\r\n");
        sql.append("FType\r\n");
        sql.append(")\r\n");
        sql.append("Select\r\n");
        sql.append("NewBOSID('").append(new BOTRelation().getType().toString()).append("'),\r\n");
        sql.append("'").append(new MasterProductionSchedule().getType().toString()).append("',\r\n");
        sql.append("'").append(new ManufactureOrder().getType().toString()).append("',\r\n");
        sql.append("'").append(param.get("MasterProductionScheduleID").toString()).append("',\r\n");
        sql.append("MO.FID,\r\n");
        sql.append("CURDate(),\r\n");
        sql.append("'").append(curUserID).append("',\r\n");
        sql.append("1,\r\n");
        sql.append("Null,\r\n");
        sql.append("0\r\n");
        sql.append("From T_MM_ManufactureOrder MO\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FSourceBillID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And (Not Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From T_BOT_Relation BOTP\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And BOTP.FDESTObjectID=MO.FID\r\n");
        sql.append("And BOTP.FSRCObjectID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append(")\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Insert Into T_BOT_Relation(\r\n");
        sql.append("FID,\r\n");
        sql.append("FSRCEntityID,\r\n");
        sql.append("FDESTEntityID,\r\n");
        sql.append("FSRCObjectID,\r\n");
        sql.append("FDESTObjectID,\r\n");
        sql.append("FDate,\r\n");
        sql.append("FOperatorID,\r\n");
        sql.append("FIsEffected,\r\n");
        sql.append("FBOTMappingID,\r\n");
        sql.append("FType\r\n");
        sql.append(")\r\n");
        sql.append("Select\r\n");
        sql.append("NewBOSID('").append(new BOTRelation().getType().toString()).append("'),\r\n");
        sql.append("'").append(new MasterProductionSchedule().getType().toString()).append("',\r\n");
        sql.append("'").append(new WorkshopSchedule().getType().toString()).append("',\r\n");
        sql.append("'").append(param.get("MasterProductionScheduleID").toString()).append("',\r\n");
        sql.append("WS.FID,\r\n");
        sql.append("CURDate(),\r\n");
        sql.append("'").append(curUserID).append("',\r\n");
        sql.append("1,\r\n");
        sql.append("Null,\r\n");
        sql.append("0\r\n");
        sql.append("From CT_PS_WorkshopSchedule WS\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And WS.FSourceBillID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And (Not Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From T_BOT_Relation BOTP\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And BOTP.FDESTObjectID=WS.FID\r\n");
        sql.append("And BOTP.FSRCObjectID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append(")\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
    }

    protected void generateCostObject(Context ctx, Map param) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String paraCompanyID = (String)param.get("companyID");
        String toOrgNumber = "N";
        String toOrgName = "N";
        IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
        if (param.get("StorageORGUnitID") != null) {
            // empty if block
        }
        if (param.get("ReceiveORGUnitID") != null) {
            StorageOrgUnitInfo toSou = iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)param.get("ReceiveORGUnitID").toString())));
            toOrgNumber = toSou.getNumber();
            toOrgName = toSou.getName();
        }
        String curCUID = ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String curUserID = ContextUtil.getCurrentUserInfo((Context)ctx) == null ? "" : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        IRowSet rs = null;
        String storageOrgUnitID = param.containsKey("StorageORGUnitID") ? (param.get("StorageORGUnitID") == null ? null : param.get("StorageORGUnitID").toString()) : null;
        boolean useNewMPRule = "1".equals(this.getParamValue(ctx, "MPSACOR4MP", storageOrgUnitID));
        Boolean isMP = param.containsKey("IsMP") ? (param.get("IsMP") == null ? false : (param.get("IsMP") instanceof Boolean ? (Boolean)param.get("IsMP") : false)) : false;
        String cbNumberSql = " Left(IsNull(TN.FNumber,'N')||";
        if (useNewMPRule && isMP.booleanValue()) {
            cbNumberSql = cbNumberSql + "'_' || IsNull(TN2.FNumber,'N')||";
        }
        cbNumberSql = cbNumberSql + "'_' || IsNull(jch.FNumber,'N')||'_' || IsNull(M.FNumber,'N')||'_' || '" + toOrgNumber + "',80)";
        if (!companyID.equals("ZzYHbHF1SCicBQvENGh+1cznrtQ=")) {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyID)));
            cbNumberSql = cbNumberSql + " || '_" + companyInfo.getNumber() + "'";
        }
        String cbNameSql = " Left(IsNull(TN.FName_l2,'N')||";
        if (useNewMPRule && isMP.booleanValue()) {
            cbNameSql = cbNameSql + "'_' || IsNull(TN2.FName_l2,'N')||";
        }
        cbNameSql = cbNameSql + "'_' || IsNull(jch.FNumber,'N')||'_' || IsNull(M.FName_l2,'N')||'_' || '" + toOrgName + "',80)";
        String tmpMoCostObjectNumber = null;
        try {
            tmpMoCostObjectNumber = TempTablePool.getInstance((Context)ctx).createTempTable("Create Table aaetempTable(\r\nFMOID VARCHAR(44),\r\nFCostObjectNumber NVARCHAR(80), \r\nFCostObjectName NVARCHAR(80),\r\nFProjectID VARCHAR(44)\r\n,FTrackNumberID VARCHAR(44)\r\n,FMaterialID VARCHAR(44)\r\n)");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" Insert Into " + tmpMoCostObjectNumber + " (FMOID,FCostObjectNumber,FCostObjectName,FProjectID,FTrackNumberID,FMaterialID) ");
        sql.append("Select  distinct\r\n");
        sql.append("MO.fid,\r\n");
        sql.append(cbNumberSql + ",\r\n");
        sql.append(cbNameSql + ",\r\n");
        sql.append("p.fid,\r\n");
        sql.append("TN.fid,\r\n");
        sql.append("M.fid\r\n");
        sql.append("From T_MM_ManufactureOrder MO\r\n");
        sql.append("Inner Join T_BD_Material M On M.FID=MO.FMaterialID\r\n");
        sql.append("Inner Join T_MM_TrackNumber TN On TN.FID=MO.FTrackID\r\n");
        if (useNewMPRule && isMP.booleanValue()) {
            sql.append("Inner Join T_MM_TrackNumber TN2 On TN2.FID=MO.CFEndTrackNumberID\r\n");
        }
        sql.append("Inner Join T_MM_Project P On P.FID=MO.FProjectID\r\n");
        sql.append("Left Join t_pro_projectjch jch on mo.FProjectJCHID=jch.fid");
        sql.append(" Inner join t_bd_materialcompanyinfo mc on mc.fmaterialid=mo.fmaterialid and mc.fcompanyid='" + paraCompanyID + "'");
        sql.append(" Where\r\n");
        sql.append(" 1=1\r\n");
        sql.append("And MO.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And MO.FCostObjectID Is Null\r\n");
        sql.append(" And (IsNull(mc.cfiscostobject,0)=1\r\n");
        sql.append(" Or M.FID ='" + param.get("COMaterialID").toString() + "')");
        int i = this.executeSQL(ctx, sql.toString() + "");
        boolean isNoCostObject = false;
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("CMO.FCostObjectID\r\n");
        sql.append("From T_MM_ManufactureOrder CMO\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And CMO.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And CMO.FMaterialID='").append(param.get("COMaterialID").toString()).append("'\r\n");
        sql.append("And CMO.FCostObjectID Is Not Null\r\n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (i == 0 || rs == null || rs.size() <= 0) {
            sql.setLength(0);
            sql.append(" Insert Into " + tmpMoCostObjectNumber + " (FMOID,FCostObjectNumber,FCostObjectName,FProjectID,FTrackNumberID,FMaterialID)");
            sql.append("Select  distinct\r\n");
            sql.append("MO.fid,\r\n");
            sql.append(cbNumberSql + ",\r\n");
            sql.append(cbNameSql + ",\r\n");
            sql.append("p.fid,\r\n");
            sql.append("TN.fid,\r\n");
            sql.append("M.fid\r\n");
            sql.append("From ct_ps_masterproductionschedule MO\r\n");
            sql.append("Inner Join T_BD_Material M On M.FID=MO.cfcomaterialid\r\n");
            sql.append("Inner Join T_MM_TrackNumber TN On TN.FID=MO.cftraceid\r\n");
            if (useNewMPRule && isMP.booleanValue()) {
                sql.append("Inner Join T_MM_TrackNumber TN2 On TN2.FID=MO.CFEndTraceID\r\n");
            }
            sql.append("Inner Join T_MM_Project P On P.FID=MO.cfprojectid\r\n");
            sql.append("Left Join t_pro_projectjch jch on mo.cfprojectjchid=jch.fid");
            sql.append(" where mo.fid='" + param.get("MasterProductionScheduleID").toString() + "'");
            i = this.executeSQL(ctx, sql.toString() + "");
            isNoCostObject = true;
        }
        sql.setLength(0);
        sql.append(this.insertCostObjectSQL(ctx));
        sql.append("Select\r\n");
        sql.append("NewBOSID('").append(new CostObjectInfo().getBOSType().toString()).append("'),\r\n");
        sql.append("'").append(curCUID).append("',\r\n");
        sql.append("'").append(curUserID).append("',\r\n");
        sql.append("'").append(curUserID).append("',\r\n");
        sql.append("'").append(companyID).append("',\r\n");
        sql.append("M.FMaterialGroupID,\r\n");
        sql.append("null,\r\n");
        sql.append("TN.fid,\r\n");
        sql.append("p.fid,\r\n");
        sql.append("null,\r\n");
        sql.append("(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("CCOG.FID\r\n");
        sql.append("From T_BD_CostObjectGroup CCOG\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And CCOG.FNumber=TN.FNumber\r\n");
        sql.append("),\r\n");
        sql.append("M.FID,\r\n");
        sql.append("'").append(param.get("MasterProductionScheduleID").toString()).append("',\r\n");
        sql.append("Now(),\r\n");
        sql.append("Now(),\r\n");
        sql.append("MO.FCostObjectName,\r\n");
        sql.append("MO.FCostObjectNumber,\r\n");
        sql.append("N'\u7531\u4e3b\u8ba1\u5212 ").append(param.get("MasterProductionScheduleNumber").toString()).append(" \u4e0b\u8fbe\u751f\u6210',\r\n");
        sql.append("M.FName_").append(ctx.getLocale()).append(",\r\n");
        sql.append("null,\r\n");
        sql.append("MO.FCostObjectNumber,\r\n");
        sql.append("'").append(param.get("MasterProductionScheduleNumber").toString()).append("',\r\n");
        sql.append("Null,\r\n");
        sql.append("0,\r\n");
        sql.append(4).append(",\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("1,\r\n");
        sql.append("lpt.fid,\r\n");
        sql.append("'" + param.get("StorageORGUnitID").toString() + "'\r\n");
        sql.append("From (\r\n");
        sql.append("Select\r\n");
        sql.append("Max(T.FCostObjectName) FCostObjectName,\r\n");
        sql.append("T.FCostObjectNumber FCostObjectNumber,\r\n");
        sql.append("Max(T.FMaterialID) FMaterialID,\r\n");
        sql.append("Max(T.FTrackNumberID) FTrackNumberID,\r\n");
        sql.append("Max(T.FProjectID) FProjectID\r\n");
        sql.append("From ").append(tmpMoCostObjectNumber).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("Group By\r\n");
        sql.append("T.FCostObjectNumber\r\n");
        sql.append(") MO\r\n");
        sql.append("Inner Join T_BD_Material M On M.FID=MO.FMaterialID\r\n");
        sql.append("Inner Join T_MM_TrackNumber TN On TN.FID=MO.FTrackNumberID\r\n");
        sql.append("Inner Join T_MM_Project P On P.FID=MO.FProjectID\r\n");
        sql.append(" left join ct_pcm_projecttypes lpt on lpt.fid=P.cfprojecttypesid\r\n");
        sql.append(" Where\r\n");
        sql.append(" 1=1\r\n");
        sql.append(" and MO.FCostObjectNumber not in (select fnumber from t_bd_costobject where FCompanyID='" + companyID + "')");
        i = this.executeSQL(ctx, sql.toString() + "");
        sql.setLength(0);
        sql.append(this.insertCostObjectEntrySQL(ctx));
        sql.append("Select\r\n");
        sql.append("NewBOSID('").append(new CostObjectEntryInfo().getBOSType().toString()).append("'),\r\n");
        sql.append("CO.FID,\r\n");
        sql.append("M.fid,\r\n");
        sql.append("1,\r\n");
        sql.append("M.FNumber,\r\n");
        sql.append("M.FName_").append(ctx.getLocale()).append(",\r\n");
        sql.append("1,\r\n");
        sql.append("0,\r\n");
        sql.append("1,\r\n");
        sql.append("CO.FDescription_").append(ctx.getLocale()).append("\r\n");
        sql.append("From T_BD_CostObject CO\r\n");
        sql.append("Inner join (Select distinct FMaterialID,fcostobjectNumber from  " + tmpMoCostObjectNumber + " ) mocoTmp on co.fnumber=mocoTmp.fcostobjectNumber\r\n");
        sql.append("Inner Join T_BD_Material M On M.FID=mocoTmp.FMaterialID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append(" and co.FCompanyID='" + companyID + "'");
        sql.append("And CO.FRelatedID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And (Not Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From T_BD_CostObjectEntry TCOE\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And TCOE.FParentID=CO.FID\r\n");
        sql.append(")\r\n");
        sql.append(")\r\n");
        i = this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update T_MM_ManufactureOrder UT\r\n");
        sql.append("Set (FCostObjectID,flot)=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("CO.FID,CO.fbatchnumber \r\n");
        sql.append("From T_BD_CostObject CO\r\n");
        sql.append("," + tmpMoCostObjectNumber + " mocoTmp\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And mocoTmp.fmoid=UT.FID\r\n");
        sql.append("And CO.fnumber=mocoTmp.FCostObjectNumber\r\n");
        sql.append(" and co.FCompanyID='" + companyID + "'");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And UT.FCostObjectID Is Null\r\n");
        sql.append(" And UT.fid in (select FMOID from " + tmpMoCostObjectNumber + ")");
        i = this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update T_MM_ManufactureOrder UT\r\n");
        sql.append("Set (FCostObjectID,flot)=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("CMO.FCostObjectID,CMO.flot\r\n");
        sql.append("From ").append(param.get("MergeTempTableName").toString()).append(" CTT\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder CMO On CMO.FSourceBillID=CTT.FCostObjectMOID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And CTT.FID=UT.FSourceBillID\r\n");
        sql.append("And CMO.FCostObjectID Is Not Null\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append(" And UT.fid not in (select FMOID from " + tmpMoCostObjectNumber + ")");
        sql.append("And UT.FCostObjectID Is Null\r\n");
        i = this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update T_MM_ManufactureOrder UT\r\n");
        sql.append("Set (FCostObjectID,flot)=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("CMO.FCostObjectID,CMO.flot\r\n");
        sql.append("From T_MM_ManufactureOrder CMO\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And CMO.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From ").append(param.get("MergeTempTableName")).append(" CTCO\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And IsNull(CTCO.FLevel,0)=-1\r\n");
        sql.append("And CMO.FStorageORGUnitID=CTCO.FStorageOrgUnitID\r\n");
        sql.append("And CMO.FMaterialID=CTCO.FMaterialID\r\n");
        sql.append("And CMO.FProjectID=CTCO.FProjectID\r\n");
        sql.append("And CMO.FTrackID=CTCO.FTraceID\r\n");
        sql.append("And CMO.FBOMID=CTCO.FBOMID\r\n");
        sql.append("And IsNull(CMO.CFIsWarehouse,0)=IsNull(CTCO.FIsWarehousing,0)\r\n");
        sql.append(")\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append(" And UT.fid not in (select FMOID from " + tmpMoCostObjectNumber + ")");
        sql.append("And UT.FCostObjectID Is Null\r\n");
        i = this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update T_MM_ManufactureOrder UT\r\n");
        sql.append("Set (FCostObjectID,flot)=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("CMO.FCostObjectID,CMO.flot\r\n");
        sql.append("From T_MM_ManufactureOrder CMO\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And CMO.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And CMO.FMaterialID='").append(param.get("COMaterialID").toString()).append("'\r\n");
        sql.append("And CMO.FCostObjectID Is Not Null\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append(" And UT.fid not in (select FMOID from " + tmpMoCostObjectNumber + ")");
        sql.append("And UT.FCostObjectID Is Null\r\n");
        i = this.executeSQL(ctx, sql.toString());
        if (isNoCostObject) {
            sql.setLength(0);
            sql.append("Update T_MM_ManufactureOrder UT\r\n");
            sql.append("Set (FCostObjectID,flot)=(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("CO.fid,CO.fbatchnumber\r\n");
            sql.append("From " + tmpMoCostObjectNumber + " t");
            sql.append(" inner join t_bd_costobject co on t.FCostObjectNumber=co.fnumber");
            sql.append(" and co.FCompanyID='" + companyID + "' ");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
            sql.append("And UT.FCostObjectID Is Null\r\n");
            i = this.executeSQL(ctx, sql.toString());
        }
        if (isMP.booleanValue()) {
            sql.setLength(0);
            sql.append("Update T_MM_ManufactureOrder UT\r\n");
            sql.append("Set (FCostObjectID,flot)=(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("CO.fid,CO.fbatchnumber\r\n");
            sql.append("From " + tmpMoCostObjectNumber + " t");
            sql.append(" inner join t_bd_costobject co on t.FCostObjectNumber=co.fnumber");
            sql.append(" and co.FCompanyID='" + companyID + "' and t.FMOID = '").append(param.get("MasterProductionScheduleID").toString()).append("'");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
            sql.append(" And Exists(Select 1 from  t_bd_materialcompanyinfo mc where mc.fmaterialid=UT.fmaterialid and mc.fcompanyid='" + paraCompanyID + "' and IsNull(mc.cfiscostobject,0)=0 )");
            i = this.executeSQL(ctx, sql.toString());
        }
    }

    protected void generateManufactureOrder(Context ctx, Map param) throws BOSException, EASBizException {
        String fallbackBOMNumber;
        String string = param.containsKey("FallbackBOMNumber") ? (param.get("FallbackBOMNumber") == null ? null : param.get("FallbackBOMNumber").toString()) : (fallbackBOMNumber = null);
        Boolean isMP = param.containsKey("IsMP") ? (param.get("IsMP") == null ? false : (param.get("IsMP") instanceof Boolean ? (Boolean)param.get("IsMP") : false)) : false;
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("T.FID \"FID\",\r\n");
        sql.append("T.FStorageORGUnitID \"FStorageORGUnitID\",\r\n");
        sql.append("T.FReceiveORGUnitID \"FReceiveORGUnitID\",\r\n");
        sql.append("T.FMaterialID \"FMaterialID\",\r\n");
        sql.append("T.FIsLimitedQty \"FIsLimitedQty\",\r\n");
        sql.append("T.FExtraRatio \"FExtraRatio\",\r\n");
        sql.append("T.FLackRatio \"FLackRatio\",\r\n");
        sql.append("T.FUnitID \"FUnitID\",\r\n");
        sql.append("T.FBIZTypeID \"FBIZTypeID\",\r\n");
        sql.append("T.FTransactionTypeID \"FTransactionTypeID\",\r\n");
        sql.append("T.FScheduleType \"FScheduleType\",\r\n");
        sql.append("T.FIsWarehousing \"FIsWarehousing\",\r\n");
        sql.append("T.FProjectID \"FProjectID\",\r\n");
        sql.append("T.FTraceID \"FTraceID\",\r\n");
        sql.append("T.FEndTraceID \"FEndTraceID\",\r\n");
        sql.append("T.FBOMID \"FBOMID\",\r\n");
        sql.append("B.FNumber \"FBOMNumber\",\r\n");
        sql.append("IsNull(B.FYield,100) \"FYield\",\r\n");
        sql.append("T.FRoutingID \"FRoutingID\",\r\n");
        sql.append("sRoutin.CFAddresseeWorkCen \"faddressWorkID\",\r\n");
        sql.append("T.FADMINORGUnitID \"FADMINORGUnitID\",\r\n");
        sql.append("T.FDispathUserID \"FDispathUserID\",\r\n");
        sql.append("T.FQTY \"FQTY\",\r\n");
        sql.append("T.FStartDate \"FStartDate\",\r\n");
        sql.append("T.FFinishDate \"FFinishDate\",\r\n");
        sql.append("IsNull(T.FIsAudit,0) \"FIsAudit\",\r\n");
        sql.append("T.FCostObjectID \"FCostObjectID\",\r\n");
        sql.append("IsNull((\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("MU.FQTYPrecision\r\n");
        sql.append("From T_BD_MultiMeasureUnit MU\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MU.FMaterialID=T.FMaterialID\r\n");
        sql.append("And MU.FMeasureUnitID=T.FUnitID\r\n");
        sql.append("),2) \"FPrecision\",\r\n");
        sql.append("IsNull((\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("MU.FBaseCONVSRate\r\n");
        sql.append("From T_BD_MultiMeasureUnit MU\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MU.FMaterialID=T.FMaterialID\r\n");
        sql.append("And MU.FMeasureUnitID=T.FUnitID\r\n");
        sql.append("),1) \"FConvertRate\",\r\n");
        sql.append("Case\r\n");
        sql.append("When MP.FRCVInHightLimit Is Null And MP.FRCVInLowLimit Is Null Then 1\r\n");
        sql.append("Else 0\r\n");
        sql.append("End \"FIsUnLimitQTY\",\r\n");
        sql.append("IsNull(MI.CFIsUseWQTS,0) \"FIsEnableSQT\"\r\n");
        sql.append("From ").append(param.get("MergeTempTableName").toString()).append(" T\r\n");
        sql.append("Inner Join T_MM_BOM B On B.FID=T.FBOMID\r\n");
        sql.append("Left Join T_BD_MaterialPlan MP ON MP.FMaterialID=T.FMaterialID And MP.FORGUnit=T.FStorageORGUnitID\r\n");
        sql.append("Left Join T_BD_MaterialInventory MI ON MI.FMaterialID=T.FMaterialID And MI.FORGUnit=T.FStorageORGUnitID\r\n");
        sql.append("Left Join T_MM_StandardRooting sRoutin ON sRoutin.fid=T.FRoutingID\r\n ");
        sql.append("Where\r\n");
        sql.append("IsNull(T.FDeleted,0)=0\r\n");
        if (isMP.booleanValue()) {
            sql.append("And IsNull(MI.CFIsMP,0)=1\r\n");
        } else {
            sql.append("And ((\r\n");
            sql.append("IsNull(T.FLevel,0)>0\r\n");
            sql.append("And IsNull(MI.CFIsMP,0)=0\r\n");
            sql.append(") Or IsNull(T.FLevel,0)<=0\r\n");
            sql.append(")\r\n");
        }
        if (fallbackBOMNumber != null && fallbackBOMNumber.trim().length() > 0) {
            sql.append("And (\r\n");
            sql.append("T.FMaterialAttribute=").append(10030).append("\r\n");
            sql.append("Or T.FMaterialAttribute=").append(10050).append("\r\n");
            sql.append(")\r\n");
        } else {
            sql.append("And (\r\n");
            sql.append("T.FMaterialAttribute=").append(10030).append("\r\n");
            sql.append(")\r\n");
        }
        sql.append("And B.FStorageORGUnitID=T.FStorageORGUnitID\r\n");
        sql.append("And T.FStorageORGUnitID='").append(param.get("StorageORGUnitID").toString()).append("'\r\n");
        if (param.get("COMaterialID").toString().equals(param.get("ProductID").toString())) {
            sql.append("And IsNull(T.FLevel,0)<> -1\r\n");
        }
        sql.append("Order By\r\n");
        sql.append("T.FLevel ASC\r\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet == null || rowSet.size() == 0) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), this.getPSResource(ctx, "Msg_Bill_No_Valid_Data_Generate_MO", new String[]{param.get("MasterProductionScheduleNumber").toString()})));
        }
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        UserInfo curUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Date curDate = new Date();
        Timestamp curTimestamp = new Timestamp(curDate.getTime());
        CtrlUnitInfo curCTRLUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String isSingleBillValue = this.getParamValue(ctx, "SQTMB", param.get("StorageORGUnitID").toString());
        Boolean isSingleBill = isSingleBillValue == null ? false : "true".equals(isSingleBillValue);
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("FID");
                String storageORGUnitID = rowSet.getString("FStorageORGUnitID");
                String materialID = rowSet.getString("FMaterialID");
                String unitID = rowSet.getString("FUnitID");
                String bizTypeID = rowSet.getString("FBIZTypeID");
                String transactionTypeID = rowSet.getString("FTransactionTypeID");
                int scheduleType = rowSet.getInt("FScheduleType");
                Boolean isWarehousing = rowSet.getBoolean("FIsWarehousing");
                String projectID = rowSet.getString("FProjectID");
                String traceID = rowSet.getString("FTraceID");
                String endTraceID = rowSet.getString("FEndTraceID");
                String bomID = rowSet.getString("FBOMID");
                String bomNumber = rowSet.getString("FBOMNumber");
                BigDecimal yield = rowSet.getBigDecimal("FYield");
                String routingID = rowSet.getString("FRoutingID");
                String addressWorkCenterID = rowSet.getString("faddressWorkID");
                String adminORGUnitID = rowSet.getString("FADMINORGUnitID");
                String dispathUserID = rowSet.getString("FDispathUserID");
                int precision = rowSet.getInt("FPrecision");
                BigDecimal qty = rowSet.getBigDecimal("FQTY").setScale(precision, 4);
                Timestamp startDate = rowSet.getTimestamp("FStartDate");
                Timestamp finishDate = rowSet.getTimestamp("FFinishDate");
                Boolean isAudit = rowSet.getBoolean("FIsAudit");
                String costObjectID = rowSet.getString("FCostObjectID");
                BigDecimal convertRate = rowSet.getBigDecimal("FConvertRate") == null ? BigDecimal.ONE : rowSet.getBigDecimal("FConvertRate");
                Boolean isUnLimitQTY = rowSet.getBoolean("FIsUnLimitQTY");
                Boolean isLimitedQty = (Boolean)param.get("isLimitedQty");
                BigDecimal extraRatio = param.get("extraRatio") == null ? BigDecimal.ZERO : (BigDecimal)param.get("extraRatio");
                BigDecimal lackRatio = param.get("lackRatio") == null ? BigDecimal.ZERO : (BigDecimal)param.get("lackRatio");
                Boolean isEnableSQT = rowSet.getBoolean("FIsEnableSQT");
                Boolean isTopMaterial = param.get("ProductID").toString().equals(materialID);
                ManufactureOrderInfo manufactureOrderInfo = new ManufactureOrderInfo();
                manufactureOrderInfo.setBizDate(curDate);
                manufactureOrderInfo.setCU(curCTRLUnitInfo);
                StorageOrgUnitInfo storageOrgUnitInfo = new StorageOrgUnitInfo();
                storageOrgUnitInfo.setId(BOSUuid.read((String)storageORGUnitID));
                manufactureOrderInfo.setStorageOrgUnit(storageOrgUnitInfo);
                MaterialInfo materialInfo = new MaterialInfo();
                materialInfo.setId(BOSUuid.read((String)materialID));
                manufactureOrderInfo.setMaterial(materialInfo);
                MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
                measureUnitInfo.setId(BOSUuid.read((String)unitID));
                manufactureOrderInfo.setUnit(measureUnitInfo);
                manufactureOrderInfo.setBaseUnit(measureUnitInfo);
                BizTypeInfo bizTypeInfo = new BizTypeInfo();
                bizTypeInfo.setId(BOSUuid.read((String)bizTypeID));
                manufactureOrderInfo.setBizType(bizTypeInfo);
                ProductTransactionTypeInfo productTransactionTypeInfo = new ProductTransactionTypeInfo();
                productTransactionTypeInfo.setId(BOSUuid.read((String)transactionTypeID));
                manufactureOrderInfo.setTransactionType(productTransactionTypeInfo);
                if (scheduleType > 0) {
                    manufactureOrderInfo.setScheduleType(com.kingdee.eas.mm.basedata.ScheduleTypeEnum.getEnum((int)scheduleType));
                }
                BillTypeInfo billTypeInfo = new BillTypeInfo();
                billTypeInfo.setId(BOSUuid.read((String)"B2aZSVXaSx6qxdfekgCmrEY+1VI="));
                manufactureOrderInfo.setBillType(billTypeInfo);
                manufactureOrderInfo.setPlanBeginDate(startDate);
                manufactureOrderInfo.setPlanEndDate(finishDate);
                ProjectInfo projectInfo = new ProjectInfo();
                projectInfo.setId(BOSUuid.read((String)projectID));
                manufactureOrderInfo.setProject(projectInfo);
                manufactureOrderInfo.setYear(2199);
                manufactureOrderInfo.setPeriod(1);
                if (param.containsKey("ProjectJCHID") && param.get("ProjectJCHID") != null) {
                    ProjectJCHInfo projectJCHInfo = new ProjectJCHInfo();
                    projectJCHInfo.setId(BOSUuid.read((String)param.get("ProjectJCHID").toString()));
                    manufactureOrderInfo.put("projectJCH", (Object)projectJCHInfo);
                }
                TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
                trackNumberInfo.setId(BOSUuid.read((String)traceID));
                manufactureOrderInfo.setTrackNumber(trackNumberInfo);
                if (endTraceID != null) {
                    TrackNumberInfo endTrackNumberInfo = new TrackNumberInfo();
                    endTrackNumberInfo.setId(BOSUuid.read((String)endTraceID));
                    manufactureOrderInfo.put("endTrackNumber", (Object)endTrackNumberInfo);
                }
                manufactureOrderInfo.setBomID(bomID);
                manufactureOrderInfo.setBomNum(bomNumber);
                StandardRootingInfo standardRootingInfo = new StandardRootingInfo();
                standardRootingInfo.setId(BOSUuid.read((String)routingID));
                manufactureOrderInfo.setRouting(standardRootingInfo);
                if (addressWorkCenterID != null) {
                    WorkCenterInfo wci = new WorkCenterInfo();
                    wci.setId(BOSUuid.read((String)addressWorkCenterID));
                    manufactureOrderInfo.put("addressWorkCenter", (Object)wci);
                }
                AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                adminOrgUnitInfo.setId(BOSUuid.read((String)adminORGUnitID));
                manufactureOrderInfo.setAdminOrgUnit(adminOrgUnitInfo);
                if (dispathUserID != null && dispathUserID.trim().length() > 0) {
                    PersonInfo personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)dispathUserID));
                    manufactureOrderInfo.setDispatcher(personInfo);
                }
                manufactureOrderInfo.put("isWarehouse", (Object)isWarehousing);
                manufactureOrderInfo.put("isUnlimitedQty", (Object)isUnLimitQTY);
                manufactureOrderInfo.put("isLimitedQty", (Object)isLimitedQty);
                manufactureOrderInfo.put("extraRatio", (Object)extraRatio);
                manufactureOrderInfo.put("lackRatio", (Object)lackRatio);
                MasterProductionScheduleInfo masterProductionScheduleInfo = new MasterProductionScheduleInfo();
                masterProductionScheduleInfo.setId(BOSUuid.read((String)param.get("MasterProductionScheduleID").toString()));
                manufactureOrderInfo.put("mpsId", (Object)masterProductionScheduleInfo);
                manufactureOrderInfo.setSourceBillId(id);
                if (costObjectID != null && costObjectID.trim().length() > 0) {
                    CostObjectInfo costObjectInfo = new CostObjectInfo();
                    costObjectInfo.setId(BOSUuid.read((String)costObjectID));
                    manufactureOrderInfo.setCostObject(costObjectInfo);
                    manufactureOrderInfo.setLot(costObjectInfo.getBatchNumber());
                }
                this.setBillNumber(ctx, (IObjectValue)manufactureOrderInfo, storageORGUnitID);
                manufactureOrderInfo.setCreator(curUserInfo);
                manufactureOrderInfo.setCreateTime(curTimestamp);
                manufactureOrderInfo.setLastUpdateUser(curUserInfo);
                manufactureOrderInfo.setLastUpdateTime(curTimestamp);
                manufactureOrderInfo.setModifier(curUserInfo);
                manufactureOrderInfo.setModificationTime(curTimestamp);
                if (isAudit.booleanValue()) {
                    manufactureOrderInfo.setAuditor(curUserInfo);
                    manufactureOrderInfo.setAuditTime(curTimestamp);
                }
                manufactureOrderInfo.setIsLimitedQty(isLimitedQty.booleanValue());
                manufactureOrderInfo.setExtraRatio(extraRatio);
                manufactureOrderInfo.setLackRatio(lackRatio);
                manufactureOrderInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                manufactureOrderInfo.setHasEffected(false);
                BigDecimal actualQty = null;
                if (isSingleBill.booleanValue() && isEnableSQT.booleanValue() && !isTopMaterial.booleanValue()) {
                    if (qty.compareTo(BigDecimal.ONE) >= 0) {
                        actualQty = BigDecimal.ONE;
                        qty = qty.subtract(BigDecimal.ONE);
                    } else {
                        actualQty = qty;
                        qty = BigDecimal.ZERO;
                    }
                } else {
                    actualQty = qty;
                }
                manufactureOrderInfo.setQty(actualQty);
                manufactureOrderInfo.setBaseQty(actualQty.multiply(convertRate).setScale(precision, 4));
                manufactureOrderInfo.setYield(yield);
                manufactureOrderInfo.setDeliveryQty(actualQty.multiply(yield.divide(new BigDecimal(100)).setScale(precision, 4)));
                manufactureOrderInfo.setDeliveryBaseQty(manufactureOrderInfo.getDeliveryQty().multiply(convertRate).setScale(precision));
                BigDecimal extraUpperLimit = extraRatio.divide(new BigDecimal("100.00"), 4, 4).add(new BigDecimal("1.0")).multiply(actualQty);
                manufactureOrderInfo.setExtraUpperLimit(extraUpperLimit);
                manufactureOrderInfo.setExtraUpperLimitBase(manufactureOrderInfo.getExtraUpperLimit().multiply(convertRate).setScale(precision));
                BigDecimal lackLowerLimit = new BigDecimal("1.0").subtract(lackRatio.divide(new BigDecimal("100.00"), 4, 4)).multiply(actualQty);
                manufactureOrderInfo.setLackLowerLimit(lackLowerLimit);
                manufactureOrderInfo.setLackLowerLimitBase(manufactureOrderInfo.getLackLowerLimit().multiply(convertRate).setScale(precision));
                manufactureOrderInfo.setUnRepairQty(manufactureOrderInfo.getQty());
                manufactureOrderInfo.setUnRepairBaseQty(manufactureOrderInfo.getUnRepairQty().multiply(convertRate).setScale(precision));
                if (isUnLimitQTY.booleanValue()) {
                    manufactureOrderInfo.setUnToStoreQty(manufactureOrderInfo.getQty());
                    manufactureOrderInfo.setUnToStoreBaseQty(manufactureOrderInfo.getQty());
                } else {
                    manufactureOrderInfo.setUnToStoreQty(manufactureOrderInfo.getExtraUpperLimit());
                    manufactureOrderInfo.setUnToStoreBaseQty(manufactureOrderInfo.getExtraUpperLimitBase());
                }
                if (isSingleBill.booleanValue() && isEnableSQT.booleanValue() && !isTopMaterial.booleanValue()) {
                    while (qty.compareTo(BigDecimal.ZERO) > 0) {
                        if (qty.compareTo(BigDecimal.ONE) >= 0) {
                            actualQty = BigDecimal.ONE;
                            qty = qty.subtract(BigDecimal.ONE);
                        } else {
                            actualQty = qty;
                            qty = BigDecimal.ZERO;
                        }
                        ManufactureOrderInfo singleManufactureOrderInfo = (ManufactureOrderInfo)manufactureOrderInfo.clone();
                        singleManufactureOrderInfo.setQty(actualQty);
                        singleManufactureOrderInfo.setBaseQty(actualQty.multiply(convertRate).setScale(precision, 4));
                        singleManufactureOrderInfo.setYield(yield);
                        singleManufactureOrderInfo.setDeliveryQty(actualQty.multiply(yield.divide(new BigDecimal(100)).setScale(precision, 4)));
                        singleManufactureOrderInfo.setDeliveryBaseQty(singleManufactureOrderInfo.getDeliveryQty().multiply(convertRate).setScale(precision));
                        singleManufactureOrderInfo.setExtraUpperLimit(actualQty);
                        singleManufactureOrderInfo.setExtraUpperLimitBase(singleManufactureOrderInfo.getExtraUpperLimit().multiply(convertRate).setScale(precision));
                        singleManufactureOrderInfo.setLackLowerLimit(actualQty);
                        singleManufactureOrderInfo.setLackLowerLimitBase(singleManufactureOrderInfo.getLackLowerLimit().multiply(convertRate).setScale(precision));
                        singleManufactureOrderInfo.setUnRepairQty(singleManufactureOrderInfo.getQty());
                        singleManufactureOrderInfo.setUnRepairBaseQty(singleManufactureOrderInfo.getUnRepairQty().multiply(convertRate).setScale(precision));
                        if (isUnLimitQTY.booleanValue()) {
                            singleManufactureOrderInfo.setUnToStoreQty(singleManufactureOrderInfo.getQty());
                            singleManufactureOrderInfo.setUnToStoreBaseQty(singleManufactureOrderInfo.getQty());
                        } else {
                            singleManufactureOrderInfo.setUnToStoreQty(singleManufactureOrderInfo.getExtraUpperLimit());
                            singleManufactureOrderInfo.setUnToStoreBaseQty(singleManufactureOrderInfo.getExtraUpperLimitBase());
                        }
                        this.setBillNumber(ctx, (IObjectValue)singleManufactureOrderInfo, storageORGUnitID);
                        coreBaseCollection.add((CoreBaseInfo)singleManufactureOrderInfo);
                    }
                }
                coreBaseCollection.add((CoreBaseInfo)manufactureOrderInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer errorMessages = new StringBuffer();
        ArrayList<String> newMOIDList = new ArrayList<String>();
        Result result = ManufactureOrderFactory.getLocalInstance((Context)ctx).addnew(coreBaseCollection);
        for (int index = 0; index < result.size(); ++index) {
            String moID;
            LineResult lineResult = result.getLineResult(index);
            if (lineResult == null) continue;
            if (lineResult.getException() != null) {
                errorMessages.append(lineResult.getException().toString());
                continue;
            }
            if (lineResult.getPk() == null || newMOIDList.contains(moID = result.getLineResult(index).getPk().toString())) continue;
            newMOIDList.add(moID);
        }
        if (errorMessages != null && errorMessages.toString().trim().length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0008", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0022", (Locale)ctx.getLocale()) + "\r\n" + errorMessages.toString()));
        }
        param.put("NewMOIDList", newMOIDList);
    }

    protected void generateManufactureOrderExpectOutput(Context ctx, Map param) throws BOSException, EASBizException {
    }

    protected void generateManufactureOrderStock(Context ctx, Map param) throws BOSException, EASBizException {
        List newMOIDList;
        List list = param.containsKey("NewMOIDList") ? (param.get("NewMOIDList") == null ? null : (param.get("NewMOIDList") instanceof List ? (List)param.get("NewMOIDList") : null)) : (newMOIDList = null);
        if (newMOIDList == null) {
            return;
        }
        if (newMOIDList.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        String pbomEntryBOMEntryTempTable = this.createPBOMEntryBOMEntryTempTable(ctx);
        param.put("PBOMEntryBOMEntryTempTable", pbomEntryBOMEntryTempTable);
        sql.setLength(0);
        sql.append(this.insertPBOMEntryBOMEntryTempTableSQL(pbomEntryBOMEntryTempTable));
        sql.append("Select\r\n");
        sql.append("PBE.FID,\r\n");
        sql.append("Max(BE.FID)\r\n");
        sql.append("From T_MM_ManufactureOrder MO\r\n");
        sql.append("Inner Join T_MM_PBOM PB On\r\n");
        sql.append("1=1\r\n");
        sql.append("And PB.FRoutingID=MO.FRoutingID\r\n");
        sql.append("And PB.FBOMID=MO.FBOMID\r\n");
        sql.append("Inner Join T_MM_PBOMEntry PBE On PBE.FParentID=PB.FID\r\n");
        sql.append("Inner Join T_MM_BOMEntry BE On\r\n");
        sql.append("1=1\r\n");
        sql.append("And BE.FParentID=PBE.CFBOMID\r\n");
        sql.append("And BE.FMaterialID=PBE.CFMaterialID\r\n");
        sql.append("Left Join T_MM_TrackNumber TN On TN.FID=MO.FTrackID\r\n");
        sql.append("Left Join T_MM_TrackNumber STN On STN.FID=PBE.CFSTraceID\r\n");
        sql.append("Left Join T_MM_TrackNumber ETN On ETN.FID=PBE.CFETraceID\r\n");
        sql.append("Left Join T_MM_TrackNumber BSTN On BSTN.FID=BE.CFBeginCarNOID\r\n");
        sql.append("Left Join T_MM_TrackNumber BETN On BETN.FID=BE.CFEndCarNOID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And MO.FID In (\r\n");
        sql.append(SQLUtil.arrayToString((Object[])newMOIDList.toArray()));
        sql.append(")\r\n");
        sql.append("And IsNull(STN.FNumber,'Null')<=IsNull(ETN.FNumber,'Null')\r\n");
        sql.append("And IsNull(STN.FNumber,'Null')<=IsNull(TN.FNumber,'Null')\r\n");
        sql.append("And IsNull(ETN.FNumber,'Null')>=IsNull(TN.FNumber,'Null')\r\n");
        sql.append("And IsNull(BSTN.FNumber,'Null')<=IsNull(TN.FNumber,'Null')\r\n");
        sql.append("And IsNull(BETN.FNumber,'Null')>=IsNull(TN.FNumber,'Null')\r\n");
        sql.append("Group By\r\n");
        sql.append("PBE.FID\r\n");
        this.executeSQL(ctx, sql.toString());
        String isWarehouseFromBOMEntryValue = this.getParamValue(ctx, "GMOSWHFBOM", param.get("StorageORGUnitID").toString());
        Boolean isWarehouseFromBOMEntry = isWarehouseFromBOMEntryValue == null ? false : "true".equals(isWarehouseFromBOMEntryValue);
        String isMOSWarehouseFromOrderStorageOrgUnitValue = this.getParamValue(ctx, "MPSGMOSWFOS", param.get("StorageORGUnitID").toString());
        Boolean isMOSWarehouseFromOrderStorageOrgUnit = isMOSWarehouseFromOrderStorageOrgUnitValue == null ? false : "true".equals(isMOSWarehouseFromOrderStorageOrgUnitValue);
        String defaultWarehouse = this.getParamValue(ctx, "defaultWarehouse", param.get("StorageORGUnitID").toString());
        Boolean defaultWarehousemodel = defaultWarehouse == null ? false : "true".equals(defaultWarehouse);
        String mosTempTable = this.createMOSTempTable(ctx);
        param.put("MOSTempTableName", mosTempTable);
        sql.setLength(0);
        sql.append(this.insertMOSTempTableSQL(ctx, mosTempTable));
        sql.append("Select\r\n");
        sql.append("NewBOSID('").append(new ManufactureOrderStockInfo().getBOSType().toString()).append("'),\r\n");
        sql.append("MO.FID,\r\n");
        sql.append("PBE.CFMaterialID,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Case\r\n");
        sql.append("When BE.FID Is Null Then M.FBaseUnit\r\n");
        sql.append("Else BE.FUnitID\r\n");
        sql.append("End,\r\n");
        sql.append("Case\r\n");
        sql.append("When BE.FID Is Null Then M.FBaseUnit\r\n");
        sql.append("Else BE.FBaseUnitID\r\n");
        sql.append("End,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        if (isWarehouseFromBOMEntry.booleanValue()) {
            sql.append("BE.FDefaultWarehouseID,\r\n");
        } else {
            sql.append("Null,\r\n");
        }
        sql.append("BE.FTransferWarehouseID,\r\n");
        sql.append("Null,\r\n");
        sql.append("Case\r\n");
        sql.append("When BE.FID Is Null Then Null\r\n");
        sql.append("Else\r\n");
        sql.append("\tCase\r\n");
        sql.append("\tWhen BE.FLocationID Is Null\r\n");
        sql.append("\tAnd IsNull(BE.FIsBackFlush,0)=1\r\n");
        sql.append("\tAnd IsNull(MO.FTransactionTypeID,'Null')<>'Null'\r\n");
        sql.append("\tAnd IsNull(PTT.FDefaultBFWarehouseID,'Null')=IsNull(BE.FDefaultWarehouseID,'Null')\r\n");
        sql.append("\tAnd IsNull(PTT.FDefaultBFLocationID,'Null')<>'Null'\r\n");
        sql.append("\tThen PTT.FDefaultBFLocationID\r\n");
        sql.append("\tElse BE.FLocationID\r\n");
        sql.append("\tEnd\r\n");
        sql.append("End,\r\n");
        sql.append("Null,\r\n");
        sql.append("BE.FSupplyStorageOrgUnitID,\r\n");
        sql.append("BE.FTransferOrgUnitID,\r\n");
        sql.append("Null,\r\n");
        sql.append("BE.FID,\r\n");
        sql.append("PBE.FID,\r\n");
        sql.append("0,\r\n");
        sql.append("Case\r\n");
        sql.append("When BE.FID Is Null Then 0\r\n");
        sql.append("Else To_Decimal(BE.FScrapRatio/100,21,8)\r\n");
        sql.append("End,\r\n");
        sql.append("Case\r\n");
        sql.append("When IsNull(MP.FIsQuotaControl,0)=1 Then IsNull(MP.FIssInHightLimit,0)\r\n");
        sql.append("Else 0\r\n");
        sql.append("End,\r\n");
        sql.append("Case\r\n");
        sql.append("When IsNull(MP.FIsQuotaControl,0)=1 Then IsNull(MP.FIssInLowLimit,0)\r\n");
        sql.append("Else 0\r\n");
        sql.append("End,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("Case\r\n");
        sql.append("When BE.FID Is Null Then PBE.CFConsumeQuota * MO.FQTY\r\n");
        sql.append("Else\r\n");
        sql.append("\tCase\r\n");
        sql.append("\tWhen BE.FConsumeType=").append(20).append(" Then\r\n");
        sql.append("\tRound((((1/BOM.FProductQty) * PBE.CFConsumeQuota) * MO.FCONVRate) * MO.FQTY,IsNull(MU.FQTYPrecision,0))\r\n");
        sql.append("\tElse\r\n");
        sql.append("\tRound((((((BOM.FProductBaseQty/BE.FBaseProductRate)/BE.FBaseRate)*(BE.FProportion * 0.01)) / BOM.FProductQty) * MO.FCONVRate) * MO.FQTY,IsNull(MU.FQTYPrecision,0))\r\n");
        sql.append("\tEnd\r\n");
        sql.append("End,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("Case\r\n");
        sql.append("When BE.FID Is Null Then PBE.CFConsumeQuota * MO.FQTY\r\n");
        sql.append("Else\r\n");
        sql.append("\tCase\r\n");
        sql.append("\tWhen IsNull(MP.FScrapRateExpression,0)=").append(10610).append(" Then\r\n");
        sql.append("\t\tCase\r\n");
        sql.append("\t\tWhen BE.FConsumeType=").append(20).append(" Then\r\n");
        sql.append("\t\tRound((((((1/BOM.FProductQty) * PBE.CFConsumeQuota) * MO.FCONVRate) * MO.FQTY)/1) -IsNull(BE.FScrapRatio,0),IsNull(MU.FQTYPrecision,0))\r\n");
        sql.append("\t\tElse\r\n");
        sql.append("\t\tRound((((((((BOM.FProductBaseQty/BE.FBaseProductRate)/BE.FBaseRate)*(BE.FProportion * 0.01)) / BOM.FProductQty) * MO.FCONVRate) * MO.FQTY)/1) -IsNull(BE.FScrapRatio,0),IsNull(MU.FQTYPrecision,0))\r\n");
        sql.append("\t\tEnd\r\n");
        sql.append("\tElse\r\n");
        sql.append("\t\tCase\r\n");
        sql.append("\t\tWhen BE.FConsumeType=").append(20).append(" Then\r\n");
        sql.append("\t\tRound(((((1/BOM.FProductQty) * PBE.CFConsumeQuota) * MO.FCONVRate) * MO.FQTY)+IsNull(BE.FScrapRatio,0),IsNull(MU.FQTYPrecision,0))\r\n");
        sql.append("\t\tElse\r\n");
        sql.append("\t\tRound(((((((BOM.FProductBaseQty/BE.FBaseProductRate)/BE.FBaseRate)*(BE.FProportion * 0.01)) / BOM.FProductQty) * MO.FCONVRate) * MO.FQTY)+IsNull(BE.FScrapRatio,0),IsNull(MU.FQTYPrecision,0))\r\n");
        sql.append("\t\tEnd\r\n");
        sql.append("\tEnd\r\n");
        sql.append("End,\r\n");
        sql.append("0,\r\n");
        sql.append("Case\r\n");
        sql.append("When BE.FID Is Null Then PBE.CFConsumeQuota\r\n");
        sql.append("Else\r\n");
        sql.append("\tCase\r\n");
        sql.append("\tWhen BE.FConsumeType=").append(20).append(" Then\r\n");
        sql.append("\tTo_Decimal(((1/BOM.FProductQty) * PBE.CFConsumeQuota) * MO.FCONVRate,21,8)\r\n");
        sql.append("\tElse\r\n");
        sql.append("\tTo_Decimal(((((BOM.FProductBaseQty/BE.FBaseProductRate)/BE.FBaseRate)*(BE.FProportion * 0.01)) / BOM.FProductQty) * MO.FCONVRate,21,8)\r\n");
        sql.append("\tEnd\r\n");
        sql.append("End,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("MO.FPlanBeginDate,\r\n");
        sql.append("Null,\r\n");
        sql.append("BE.FBLKSize,\r\n");
        sql.append("BE.FSpecifiedLength,\r\n");
        sql.append("BE.FBluePrint_").append(ctx.getLocale()).append(",\r\n");
        sql.append("Null,\r\n");
        sql.append("IsNull(PBE.FSEQ,0),\r\n");
        sql.append("IsNull(PBE.FSEQ,0) * 10,\r\n");
        sql.append("Case\r\n");
        sql.append("When IsNull(MO.FBaseStatus,0)<=2 Then ").append(2).append("\r\n");
        sql.append("Else ").append(4).append("\r\n");
        sql.append("End,\r\n");
        sql.append(0).append(",\r\n");
        sql.append("Null,\r\n");
        sql.append("Case\r\n");
        sql.append("When BE.FID Is Null Then ").append(10910).append("\r\n");
        sql.append("Else BE.FProvideType\r\n");
        sql.append("End,\r\n");
        sql.append("Null,\r\n");
        sql.append("MP.FScrapRateExpression,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append(0).append(",\r\n");
        sql.append("IsNull(BE.FNetWeight,0),\r\n");
        sql.append("IsNull(MRWP.FWPSEQ,MSEQ.FMaxWPSEQ),\r\n");
        sql.append("BE.FIssMode,\r\n");
        sql.append("0,\r\n");
        sql.append("IsNull(BE.FIsBackFlush,0),\r\n");
        sql.append("IsNull(MP.FIsQuotaControl,0),\r\n");
        sql.append("IsNull(BE.FIsStockTransfer,0),\r\n");
        sql.append("IsNull(PBE.cfismustreq,0),\r\n");
        sql.append("IsNull(MI.CFIsLineStoreHouse,0),\r\n");
        sql.append("IsNull(PBE.CFIsOwnObject,0)\r\n");
        sql.append("From (\r\n");
        sql.append("Select\r\n");
        sql.append("MOMP.FID \"FID\",\r\n");
        sql.append("MOMP.FTransactionTypeID \"FTransactionTypeID\",\r\n");
        sql.append("MOMP.FStorageOrgUnitID \"FStorageOrgUnitID\",\r\n");
        sql.append("MOMP.FTrackID \"FTrackID\",\r\n");
        sql.append("MOMP.FRoutingID \"FRoutingID\",\r\n");
        sql.append("MOMP.FBOMID \"FBOMID\",\r\n");
        sql.append("MOMP.FPlanBeginDate \"FPlanBeginDate\",\r\n");
        sql.append("MOMP.FProjectID \"FProjectID\",\r\n");
        sql.append("MOMP.FNumber \"FNumber\",\r\n");
        sql.append("MOMP.FQTY \"FQTY\",\r\n");
        sql.append("MOMP.FBaseStatus \"FBaseStatus\",\r\n");
        sql.append("Case\r\n");
        sql.append("When (MOMP.FBillCONVRate Is Not Null) And (MOMP.FProductCONVRate Is Not Null) Then\r\n");
        sql.append("\tCase\r\n");
        sql.append("\tWhen IsNull(MOMP.FBillCONVRate,0)=0 Or IsNull(MOMP.FProductCONVRate,0)=0 Then 0\r\n");
        sql.append("\tElse Round(IsNull(MOMP.FBillCONVRate,0)/IsNull(MOMP.FProductCONVRate,0),8)\r\n");
        sql.append("\tEnd\r\n");
        sql.append("Else 1\r\n");
        sql.append("End \"FCONVRate\"\r\n");
        sql.append("From(\r\n");
        sql.append("\tSelect\r\n");
        sql.append("\tMO.FID \"FID\",\r\n");
        sql.append("\tMO.FTransactionTypeID \"FTransactionTypeID\",\r\n");
        sql.append("\tMO.FStorageOrgUnitID \"FStorageOrgUnitID\",\r\n");
        sql.append("\tMO.FTrackID \"FTrackID\",\r\n");
        sql.append("\tMO.FRoutingID \"FRoutingID\",\r\n");
        sql.append("\tMO.FBOMID \"FBOMID\",\r\n");
        sql.append("\tMO.FPlanBeginDate \"FPlanBeginDate\",\r\n");
        sql.append("\tMO.FProjectID \"FProjectID\",\r\n");
        sql.append("\tMO.FNumber \"FNumber\",\r\n");
        sql.append("\tMO.FQTY \"FQTY\",\r\n");
        sql.append("\tMO.FBaseStatus \"FBaseStatus\",\r\n");
        sql.append("\t(\r\n");
        sql.append("\tSelect\r\n");
        sql.append("\tTop 1\r\n");
        sql.append("\tCMU.FBaseCONVSRate\r\n");
        sql.append("\tFrom T_BD_MultiMeasureUnit CMU\r\n");
        sql.append("\tWhere\r\n");
        sql.append("\t1=1\r\n");
        sql.append("\tAnd CMU.FMaterialID=MO.FMaterialID\r\n");
        sql.append("\tAnd CMU.FMeasureUnitID=MO.FUnitID\r\n");
        sql.append("\t) \"FBillCONVRate\",\r\n");
        sql.append("\t(\r\n");
        sql.append("\tSelect\r\n");
        sql.append("\tTop 1\r\n");
        sql.append("\tCMU.FBaseCONVSRate\r\n");
        sql.append("\tFrom T_BD_MultiMeasureUnit CMU\r\n");
        sql.append("\tWhere\r\n");
        sql.append("\t1=1\r\n");
        sql.append("\tAnd CMU.FMaterialID=MO.FMaterialID\r\n");
        sql.append("\tAnd CMU.FMeasureUnitID=MP.FProductUnitID\r\n");
        sql.append("\t) \"FProductCONVRate\"\r\n");
        sql.append("\tFrom T_MM_ManufactureOrder MO\r\n");
        sql.append("\tLeft Join T_BD_MaterialPlan MP On MO.FMaterialID=MP.FMaterialID And MP.FOrgUnit=MO.FStorageORGUnitID\r\n");
        sql.append("\tWhere\r\n");
        sql.append("\t1=1\r\n");
        sql.append("\tAnd MO.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And MO.FID In (\r\n");
        sql.append(SQLUtil.arrayToString((Object[])newMOIDList.toArray()));
        sql.append(")\r\n");
        sql.append(") MOMP\r\n");
        sql.append(") MO\r\n");
        sql.append("Left Join T_MM_ProductTransactionType PTT On PTT.FID=MO.FTransactionTypeID\r\n");
        sql.append("Inner Join T_MM_TrackNumber TN On TN.FID=MO.FTrackID\r\n");
        sql.append("Inner Join T_MM_StandardRooting SR On SR.FID=MO.FRoutingID\r\n");
        sql.append("Inner Join (\r\n");
        sql.append("Select\r\n");
        sql.append("TMRWP.FParentID FMaterialRootingID,\r\n");
        sql.append("IsNull(Max(TMRWP.FWPSEQ),0) FMaxWPSEQ\r\n");
        sql.append("From T_MM_MaterialRWP TMRWP\r\n");
        sql.append("Group By\r\n");
        sql.append("TMRWP.FParentID\r\n");
        sql.append(") MSEQ On MSEQ.FMaterialRootingID=SR.FMaterialRootingID\r\n");
        sql.append("Inner Join T_MM_PBOM PB On\r\n");
        sql.append("1=1\r\n");
        sql.append("And PB.FRoutingID=MO.FRoutingID\r\n");
        sql.append("And PB.FBOMID=MO.FBOMID\r\n");
        sql.append("Inner Join T_MM_PBOMEntry PBE On PBE.FParentID=PB.FID\r\n");
        sql.append("Inner Join T_BD_Material M On M.FID=PBE.CFMaterialID\r\n");
        sql.append("Left Join T_MM_MaterialRWP MRWP On MRWP.FID=PBE.FRoutingItemID\r\n");
        sql.append("Left Join ").append(pbomEntryBOMEntryTempTable).append(" PBEBE On PBEBE.FPBOMEntryID=PBE.FID\r\n");
        sql.append("Left Join T_MM_BOMEntry BE On BE.FID=PBEBE.FBOMEntryID\r\n");
        sql.append("Inner Join T_MM_BOM BOM On BOM.FID=PBE.CFBOMID\r\n");
        sql.append("Left Join T_BD_MultiMeasureUnit MU On PBE.CFMaterialID=MU.FMaterialID And BE.FUnitID=MU.FMeasureUnitID\r\n");
        sql.append("Inner Join T_BD_MaterialPlan MP On PBE.CFMaterialID=MP.FMaterialID And MP.FOrgUnit=MO.FStorageORGUnitID\r\n");
        sql.append("Left Join T_BD_MaterialInventory MI On PBE.CFMaterialID=MI.FMaterialID And MI.FOrgUnit=MO.FStorageORGUnitID\r\n");
        sql.append("Left Join T_MM_TrackNumber STN On STN.FID=PBE.CFSTraceID\r\n");
        sql.append("Left Join T_MM_TrackNumber ETN On ETN.FID=PBE.CFETraceID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        String isEnabledBEEDTimeValue = this.getParamValue(ctx, "GMOSBEEDT", param.get("StorageORGUnitID").toString());
        Boolean isEnabledBEEDTime = isEnabledBEEDTimeValue == null ? false : "true".equals(isEnabledBEEDTimeValue);
        if (isEnabledBEEDTime.booleanValue()) {
            sql.append("And BE.FEffectiveDate<=ADD_DAYS(MO.FPlanBeginDate,BE.FLeadtime)\r\n");
            sql.append("And BE.FDisableDate>ADD_DAYS(MO.FPlanBeginDate,BE.FLeadtime)\r\n");
        }
        sql.append("And IsNull(PBE.CFMaterialATTR,0)<>").append(10020).append("\r\n");
        sql.append("And (\r\n");
        sql.append("BE.FID Is Null\r\n");
        sql.append("Or (\r\n");
        sql.append("BE.FID Is Not Null\r\n");
        sql.append("And BE.FOutputType In (\r\n");
        sql.append(10710).append(",\r\n");
        sql.append(10740).append("\r\n");
        sql.append(")\r\n");
        sql.append(")\r\n");
        sql.append(")\r\n");
        sql.append("And (\r\n");
        sql.append("(\r\n");
        sql.append("IsNull(BOM.FBOMType,0)<>").append(40).append("\r\n");
        sql.append("And IsNull(PB.FProjectID,'Null')=MO.FProjectID\r\n");
        sql.append(")\r\n");
        sql.append("Or IsNull(BOM.FBOMType,0)=").append(40).append("\r\n");
        sql.append(")\r\n");
        sql.append("And (\r\n");
        sql.append("(\r\n");
        sql.append("BOM.FBOMType=").append(50).append("\r\n");
        sql.append("And IsNull(STN.FNumber,'Null')<=IsNull(ETN.FNumber,'Null')\r\n");
        sql.append("And IsNull(STN.FNumber,'Null')<=IsNull(TN.FNumber,'Null')\r\n");
        sql.append("And IsNull(ETN.FNumber,'Null')>=IsNull(TN.FNumber,'Null')\r\n");
        sql.append(")\r\n");
        sql.append("Or (\r\n");
        sql.append("BOM.FBOMType=").append(45).append("\r\n");
        sql.append("And Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From T_MM_OrderBOMPT TOBT\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And TOBT.FOrderID=BOM.FID\r\n");
        sql.append("And TOBT.FTrackID=MO.FTrackID\r\n");
        sql.append(")\r\n");
        sql.append(")\r\n");
        sql.append(")\r\n");
        sql.append("Order By\r\n");
        sql.append("MO.FNumber,\r\n");
        sql.append("PBE.FSEQ\r\n");
        this.executeSQL(ctx, sql.toString());
        this.updateMOSStockOrgUnit(ctx, mosTempTable);
        String isMSEIssueModeFromBomEntryString = this.getParamValue(ctx, "MPSAMSEIMFromBE", param.get("StorageORGUnitID").toString());
        Boolean isMSEIssueModeFromBomEntry = isMSEIssueModeFromBomEntryString == null ? false : "true".equals(isMSEIssueModeFromBomEntryString);
        param.put("MPSAMSEIMFromBE", isMSEIssueModeFromBomEntry);
        this.updateMOSDatas(ctx, mosTempTable, isMSEIssueModeFromBomEntry);
        this.updateMOSWarehouse(ctx, mosTempTable, param.get("StorageORGUnitID").toString(), isWarehouseFromBOMEntry, defaultWarehousemodel, isMOSWarehouseFromOrderStorageOrgUnit);
        this.insertMOSData(ctx, mosTempTable, false);
    }

    protected void generateManufactureOrderTechnics(Context ctx, Map param) throws BOSException, EASBizException {
        List newMOIDList;
        List list = param.containsKey("NewMOIDList") ? (param.get("NewMOIDList") == null ? null : (param.get("NewMOIDList") instanceof List ? (List)param.get("NewMOIDList") : null)) : (newMOIDList = null);
        if (newMOIDList == null) {
            return;
        }
        if (newMOIDList.size() == 0) {
            return;
        }
        String topProduct = param == null ? null : (param.containsKey("TopProduct") ? (param.get("TopProduct") == null ? null : param.get("TopProduct").toString()) : null);
        String mpsID = param.get("MasterProductionScheduleID").toString();
        StringBuffer sql = new StringBuffer();
        String motTempTable = this.createMOTTempTable(ctx);
        param.put("MOTTempTableName", motTempTable);
        sql.setLength(0);
        sql.append(this.insertMOTTempTableSQL(ctx, motTempTable));
        sql.append("Select\r\n");
        sql.append("NewBOSID('").append(new ManufactureOrderTechnicsInfo().getBOSType().toString()).append("'),\r\n");
        sql.append("MO.FID,\r\n");
        sql.append("MRWP.FWorkCenterID,\r\n");
        sql.append("Case\r\n");
        sql.append("When IsNull(MRWP.FEntrustType,").append(1).append(") In (\r\n");
        sql.append(1).append(",\r\n");
        sql.append(3).append("\r\n");
        sql.append(")\r\n");
        sql.append("Then MO.FStorageORGUnitID\r\n");
        sql.append("Else MRWP.FCOOStorageORGUnitID\r\n");
        sql.append("End,\r\n");
        sql.append("WC.FADMINORGUnitID,\r\n");
        sql.append("MRWP.FControlStrategyID,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("MO.FUnitID,\r\n");
        sql.append("MO.FBaseUnitID,\r\n");
        sql.append("Null,\r\n");
        sql.append("MRWP.FOperationID,\r\n");
        sql.append("MRWP.FEntrustSupplierID,\r\n");
        sql.append("MRWP.FChildRootingID,\r\n");
        sql.append("MRWP.FID,\r\n");
        sql.append("Null,\r\n");
        sql.append("IsNull(MRWP.FQueueTime,0),\r\n");
        sql.append("IsNull(MRWP.FPreparedTime,0),\r\n");
        sql.append("IsNull(MRWP.FMachiningTime,0),\r\n");
        sql.append("IsNull(MRWP.FWaittingTime,0),\r\n");
        sql.append("IsNull(MRWP.FTransferTime,0),\r\n");
        sql.append("0,\r\n");
        sql.append("IsNull(MRWP.CFFixedWorkingTime,0),\r\n");
        sql.append("IsNull(MO.FQTY,0)*IsNull(MRWP.CFFixedWorkingTime,0),\r\n");
        sql.append("IsNull(MRWP.FProcessBatch,0),\r\n");
        sql.append("0,\r\n");
        sql.append("IsNull(MO.FQTY,0),\r\n");
        sql.append("IsNull(MO.FBaseQTY,0),\r\n");
        sql.append("IsNull(MO.FQTY,0),\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("IsNull(MRWP.FRealProductQtyHigh,0),\r\n");
        sql.append("0,\r\n");
        sql.append("IsNull(MRWP.FRealProductQtyLow,0),\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("IsNull(MO.FQTY,0),\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("0,\r\n");
        sql.append("MO.FPlanBeginDate,\r\n");
        sql.append("MO.FPlanEndDate,\r\n");
        sql.append("MO.FPlanBeginDate,\r\n");
        sql.append("MO.FPlanEndDate,\r\n");
        sql.append("Now(),\r\n");
        sql.append("MRWP.CFPROInstruction,\r\n");
        sql.append("MRWP.FOperationRemark_").append(ctx.getLocale()).append(",\r\n");
        sql.append("MRWP.FSEQ,\r\n");
        sql.append("IsNull(MRWP.FTimeUnit,").append(2).append("),\r\n");
        sql.append("Case IsNull(TT.FIsAudit,0)\r\n");
        sql.append("When 0 Then ").append(2).append("\r\n");
        sql.append("When 1 Then ").append(4).append("\r\n");
        sql.append("End,\r\n");
        sql.append(0).append(",\r\n");
        sql.append("MRWP.FWPSEQ,\r\n");
        sql.append("IsNull(MRWP.FEntrustType,").append(1).append("),\r\n");
        sql.append("MRWP.FValuationType,\r\n");
        sql.append("MRWP.FOverrunMeasure,\r\n");
        sql.append("IsNull(MRWP.FIsCheckPoint,0),\r\n");
        sql.append("IsNull(MRWP.FIsReportPoint,0),\r\n");
        sql.append("IsNull(MRWP.FIsPickingPoint,0),\r\n");
        sql.append("IsNull(MRWP.FIsImportantWP,0),\r\n");
        sql.append("IsNull(MRWP.CFIsXOpertion,0),\r\n");
        sql.append("IsNull(MRWP.cfopertionPrice,0)\r\n");
        sql.append("From T_MM_ManufactureOrder MO\r\n");
        sql.append("Inner Join ").append(param.get("MergeTempTableName").toString()).append(" TT On TT.FID=MO.FSourceBillID\r\n");
        sql.append("Inner Join T_MM_StandardRooting SR On SR.FID=MO.FRoutingID\r\n");
        sql.append("Inner Join T_MM_MaterialRWP MRWP On MRWP.FParentID=SR.FMaterialRootingID\r\n");
        sql.append("Inner Join (\r\n");
        sql.append("Select\r\n");
        sql.append("TMRWP.FParentID FMaterialRootingID,\r\n");
        sql.append("IsNull(Max(TMRWP.FWPSEQ),0) FMaxWPSEQ\r\n");
        sql.append("From T_MM_MaterialRWP TMRWP\r\n");
        sql.append("Group By\r\n");
        sql.append("TMRWP.FParentID\r\n");
        sql.append(") MSEQ On MSEQ.FMaterialRootingID=SR.FMaterialRootingID\r\n");
        sql.append("Inner Join T_MM_WorkCenter WC On WC.FID=MRWP.FWorkCenterID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And MO.FID In (\r\n");
        sql.append(SQLUtil.arrayToString((Object[])newMOIDList.toArray()));
        sql.append(")\r\n");
        sql.append("Order By\r\n");
        sql.append("MO.FNumber,\r\n");
        sql.append("MRWP.FWPSEQ\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update T_MM_ManufactureOrder UT\r\n");
        sql.append("Set (\r\n");
        sql.append("FFirstOPERNO,\r\n");
        sql.append("FLastOPERNO\r\n");
        sql.append(")=(\r\n");
        sql.append("Select\r\n");
        sql.append("Min(FOperationNO),\r\n");
        sql.append("Max(FOperationNO)\r\n");
        sql.append("From ").append(motTempTable).append(" MOTE\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MOTE.FParentID=UT.FID\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FID In (\r\n");
        sql.append("Select\r\n");
        sql.append("MOTE.FParentID\r\n");
        sql.append("From ").append(motTempTable).append(" MOTE\r\n");
        sql.append("Group By\r\n");
        sql.append("MOTE.FParentID\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(motTempTable).append(" UT\r\n");
        sql.append("Set (\r\n");
        sql.append("FUnFinishQTY,\r\n");
        sql.append("FUnFinishBaseQTY,\r\n");
        sql.append("FUnMoveOutQTY,\r\n");
        sql.append("FUnMoveOutBaseQTY,\r\n");
        sql.append("FUnTestQTY,\r\n");
        sql.append("FUnTestBaseQTY,\r\n");
        sql.append("FUnDispatchQTY,\r\n");
        sql.append("FIntoQTY,\r\n");
        sql.append("FIntoBaseQTY\r\n");
        sql.append(")=(\r\n");
        sql.append("Select\r\n");
        sql.append("IsNull(MOTE.FQTY,0),\r\n");
        sql.append("IsNull(MOTE.FBaseQTY,0),\r\n");
        sql.append("IsNull(MOTE.FQTY,0),\r\n");
        sql.append("IsNull(MOTE.FBaseQTY,0),\r\n");
        sql.append("IsNull(MOTE.FQTY,0),\r\n");
        sql.append("IsNull(MOTE.FBaseQTY,0),\r\n");
        sql.append("IsNull(MOTE.FQTY,0) -IsNull(MOTE.FTotalSplitQTY,0) -IsNull(FTotalDispatchQTY,0),\r\n");
        sql.append("Case\r\n");
        sql.append("When IsNull(MO.FFirstOPERNO,0)=IsNull(MOTE.FOperationNO,0) Then IsNull(MO.FQTY,0)\r\n");
        sql.append("Else IsNull(MOTE.FIntoQTY,0)\r\n");
        sql.append("End,\r\n");
        sql.append("Case\r\n");
        sql.append("When IsNull(MO.FFirstOPERNO,0)=IsNull(MOTE.FOperationNO,0) Then IsNull(MO.FBaseQTY,0)\r\n");
        sql.append("Else IsNull(MOTE.FIntoBaseQTY,0)\r\n");
        sql.append("End\r\n");
        sql.append("From ").append(motTempTable).append(" MOTE\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=MOTE.FParentID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MOTE.FID=UT.FID\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        this.executeSQL(ctx, sql.toString());
        String paramKey = "MPSMergeType";
        Map params = ParamUtil.getParamHashMap((Context)ctx, (String)param.get("StorageORGUnitID").toString(), (String[])new String[]{"MPSMergeType"});
        String paramValue = (String)params.get("MPSMergeType");
        boolean mpsMergeType_operation_level = true;
        if (paramValue != null && paramValue.equals("1")) {
            mpsMergeType_operation_level = false;
        }
        String motMergeTempTable = this.createMOTMergeTempTable(ctx);
        param.put("MOTMergeTempTableName", motMergeTempTable);
        sql.setLength(0);
        sql.append(this.insertMOTMergeTempTableSQL(motMergeTempTable));
        sql.append("Select\r\n");
        sql.append("NewBOSID('12345678'),\r\n");
        sql.append("MO.FMPSID,\r\n");
        sql.append("MO.FProjectID,\r\n");
        sql.append("MO.FTrackID,\r\n");
        sql.append("MO.FStorageOrgUnitID,\r\n");
        if (mpsMergeType_operation_level) {
            sql.append("MOTE.FOperationID,\r\n");
        } else {
            sql.append("MOTE.FParentID,\r\n");
        }
        sql.append("MOTE.FWorkCenterID,\r\n");
        sql.append("MOTE.FBaseStatus,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null\r\n");
        sql.append("From ").append(motTempTable).append(" MOTE\r\n");
        sql.append("Inner Join T_MM_WorkCenter WC On WC.FID=MOTE.FWorkCenterID\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=MOTE.FParentID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FTrackID Is Not Null\r\n");
        sql.append("And IsNull(MOTE.FEntrustType,0)=").append(1).append("\r\n");
        sql.append("And IsNull(WC.CFIsUnion,0)=1\r\n");
        sql.append("And IsNull(MOTE.CFIsXOpertion,0)=1\r\n");
        sql.append("Group By\r\n");
        sql.append("MO.FMPSID,\r\n");
        sql.append("MO.FProjectID,\r\n");
        sql.append("MO.FTrackID,\r\n");
        sql.append("MO.FStorageOrgUnitID,\r\n");
        if (mpsMergeType_operation_level) {
            sql.append("MOTE.FOperationID,\r\n");
        } else {
            sql.append("MOTE.FParentID,\r\n");
        }
        sql.append("MOTE.FWorkCenterID,\r\n");
        sql.append("MOTE.FBaseStatus\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append(this.insertMOTMergeTempTableSQL(motMergeTempTable));
        sql.append("Select\r\n");
        sql.append("NewBOSID('12345678'),\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("MOTE.FID\r\n");
        sql.append("From ").append(motTempTable).append(" MOTE\r\n");
        sql.append("Inner Join T_MM_WorkCenter WC On WC.FID=MOTE.FWorkCenterID\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=MOTE.FParentID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And (\r\n");
        sql.append("1<>1\r\n");
        sql.append("Or MO.FTrackID Is Null\r\n");
        sql.append("Or IsNull(MOTE.FEntrustType,0)<>").append(1).append("\r\n");
        sql.append("Or IsNull(WC.CFIsUnion,0)<>1\r\n");
        sql.append("Or IsNull(MOTE.CFIsXOpertion,0)<>1\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(motTempTable).append(" UT\r\n");
        sql.append("Set\r\n");
        sql.append("FMergeID=(\r\n");
        sql.append("Select\r\n");
        sql.append("T.FMergeID\r\n");
        sql.append("From ").append(motMergeTempTable).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FMOTID=UT.FID\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FID In (\r\n");
        sql.append("Select\r\n");
        sql.append("T.FMOTID\r\n");
        sql.append("From ").append(motMergeTempTable).append(" T\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(motTempTable).append(" UT\r\n");
        sql.append("Set\r\n");
        sql.append("FMergeID=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("T.FMergeID\r\n");
        sql.append("From ").append(motMergeTempTable).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And IsNull(T.FMPSID,'Null')='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And IsNull(T.FProjectID,'Null')='").append(param.get("ProjectID").toString()).append("'\r\n");
        sql.append("And IsNull(T.FTraceID,'Null')='").append(param.get("TraceID").toString()).append("'\r\n");
        sql.append("And IsNull(T.FStorageOrgUnitID,'Null')='").append(param.get("StorageORGUnitID").toString()).append("'\r\n");
        if (mpsMergeType_operation_level) {
            sql.append("And IsNull(T.FOperationID,'Null')=IsNull(UT.FOperationID,'Null')\r\n");
        } else {
            sql.append("And IsNull(T.FOperationID,'Null')=IsNull(UT.FParentID,'Null')\r\n");
        }
        sql.append("And IsNull(T.FWorkCenterID,'Null')=IsNull(UT.FWorkCenterID,'Null')\r\n");
        sql.append("And IsNull(T.FBaseStatus,0)=IsNull(UT.FBaseStatus,0)\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And IsNull((\r\n");
        sql.append("Select\r\n");
        sql.append("Count(1)\r\n");
        sql.append("From ").append(motMergeTempTable).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FMOTID=UT.FID\r\n");
        sql.append("),0)=0\r\n");
        this.executeSQL(ctx, sql.toString());
        TempTablePool.getInstance((Context)ctx).releaseTable(motMergeTempTable);
        motMergeTempTable = this.createMOTMergeTempTable(ctx);
        param.put("MOTMergeTempTableName", motMergeTempTable);
        sql.setLength(0);
        sql.append(this.insertMOTMergeTempTableSQL(motMergeTempTable));
        sql.append("Select\r\n");
        sql.append("MOTE.FMergeID,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("T.FID\r\n");
        sql.append("From ").append(motTempTable).append(" T\r\n");
        sql.append("Inner Join T_MM_MFTOrderTechnics MOTE On\r\n");
        sql.append("1=1\r\n");
        if (mpsMergeType_operation_level) {
            sql.append("And IsNull(MOTE.FOperationID,'Null')=IsNull(T.FOperationID,'Null')\r\n");
        } else {
            sql.append(" And MOTE.FParentID = T.FParentID\r\n");
        }
        sql.append("And IsNull(MOTE.FWorkCenterID,'Null')=IsNull(T.FWorkCenterID,'Null')\r\n");
        sql.append("And IsNull(MOTE.FBaseStatus,0)=IsNull(T.FBaseStatus,0)\r\n");
        sql.append("And IsNull(MOTE.CFIsXOpertion,0)=1\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=MOTE.FParentID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        if (topProduct != null && topProduct.trim().length() > 0) {
            sql.append("And MO.FMPSID In (\r\n");
            sql.append("Select\r\n");
            sql.append("MPS.FID\r\n");
            sql.append("From CT_PS_MasterProductionSchedule MPS\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And IsNull(MPS.CFTopProduct,'Null')='").append(topProduct).append("'\r\n");
            sql.append(")\r\n");
        } else {
            sql.append("And MO.FMPSID='").append(mpsID).append("'\r\n");
        }
        sql.append("And MO.FProjectID='").append(param.get("ProjectID").toString()).append("'\r\n");
        sql.append("And MO.FTrackID='").append(param.get("TraceID").toString()).append("'\r\n");
        sql.append("And MO.FStorageOrgUnitID='").append(param.get("StorageORGUnitID").toString()).append("'\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(motTempTable).append(" UT\r\n");
        sql.append("Set\r\n");
        sql.append("FMergeID=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("T.FMergeID\r\n");
        sql.append("From ").append(motMergeTempTable).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FMOTID=UT.FID\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FID In (\r\n");
        sql.append("Select\r\n");
        sql.append("T.FMOTID\r\n");
        sql.append("From ").append(motMergeTempTable).append(" T\r\n");
        sql.append("Group By\r\n");
        sql.append("T.FMOTID\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(motTempTable).append(" UT\r\n");
        sql.append("Set (\r\n");
        sql.append("FEarlistWOKTime,\r\n");
        sql.append("FEarlistCMPTime,\r\n");
        sql.append("FLastWorkTime,\r\n");
        sql.append("FLastCMPTime\r\n");
        sql.append(")=(\r\n");
        sql.append("Select\r\n");
        sql.append("Max(MOT.FEarlistWOKTime),\r\n");
        sql.append("Max(MOT.FEarlistCMPTime),\r\n");
        sql.append("Max(MOT.FLastWorkTime),\r\n");
        sql.append("Max(MOT.FLastCMPTime)\r\n");
        sql.append("From T_MM_MFTOrderTechnics MOT\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MOT.FMergeID=UT.FMergeID\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FID In (\r\n");
        sql.append("Select\r\n");
        sql.append("T.FMOTID\r\n");
        sql.append("From ").append(motMergeTempTable).append(" T\r\n");
        sql.append("Group By\r\n");
        sql.append("T.FMOTID\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update T_MM_MFTOrderTechnics UT\r\n");
        sql.append("Set (\r\n");
        sql.append("FEarlistWOKTime,\r\n");
        sql.append("FEarlistCMPTime,\r\n");
        sql.append("FLastWorkTime,\r\n");
        sql.append("FLastCMPTime\r\n");
        sql.append(")=(\r\n");
        sql.append("Select\r\n");
        sql.append("Max(MOT.FEarlistWOKTime),\r\n");
        sql.append("Max(MOT.FEarlistCMPTime),\r\n");
        sql.append("Max(MOT.FLastWorkTime),\r\n");
        sql.append("Max(MOT.FLastCMPTime)\r\n");
        sql.append("From T_MM_MFTOrderTechnics MOT\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MOT.FMergeID=UT.FMergeID\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FMergeID In (\r\n");
        sql.append("Select\r\n");
        sql.append("T.FMergeID\r\n");
        sql.append("From ").append(motMergeTempTable).append(" T\r\n");
        sql.append("Group By\r\n");
        sql.append("T.FMergeID\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        TempTablePool.getInstance((Context)ctx).releaseTable(motMergeTempTable);
        motMergeTempTable = this.createMOTMergeTempTable(ctx);
        param.put("MOTMergeTempTableName", motMergeTempTable);
        sql.setLength(0);
        sql.append(this.insertMOTMergeTempTableSQL(motMergeTempTable));
        sql.append("Select\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("T.FID\r\n");
        sql.append("From ").append(motTempTable).append(" T\r\n");
        sql.append("Inner Join T_MM_MFTOrderTechnics MOTE On\r\n");
        sql.append("1=1\r\n");
        if (mpsMergeType_operation_level) {
            sql.append("And IsNull(MOTE.FOperationID,'Null')=IsNull(T.FOperationID,'Null')\r\n");
        } else {
            sql.append(" And MOTE.FParentID = T.FParentID\r\n");
        }
        sql.append("And IsNull(MOTE.FWorkCenterID,'Null')=IsNull(T.FWorkCenterID,'Null')\r\n");
        sql.append("And IsNull(MOTE.CFIsXOpertion,0)=1\r\n");
        sql.append("And IsNull(MOTE.FBaseStatus,0)>=").append(5).append("\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=MOTE.FParentID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        if (topProduct != null && topProduct.trim().length() > 0) {
            sql.append("And MO.FMPSID In (\r\n");
            sql.append("Select\r\n");
            sql.append("MPS.FID\r\n");
            sql.append("From CT_PS_MasterProductionSchedule MPS\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And IsNull(MPS.CFTopProduct,'Null')='").append(topProduct).append("'\r\n");
            sql.append(")\r\n");
        } else {
            sql.append("And MO.FMPSID='").append(mpsID).append("'\r\n");
        }
        sql.append("And MO.FProjectID='").append(param.get("ProjectID").toString()).append("'\r\n");
        sql.append("And MO.FTrackID='").append(param.get("TraceID").toString()).append("'\r\n");
        sql.append("And MO.FStorageOrgUnitID='").append(param.get("StorageORGUnitID").toString()).append("'\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(motTempTable).append(" UT\r\n");
        sql.append("Set\r\n");
        sql.append("FIsCanMerge=1\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FID In (\r\n");
        sql.append("Select\r\n");
        sql.append("T.FMOTID\r\n");
        sql.append("From ").append(motMergeTempTable).append(" T\r\n");
        sql.append("Group By\r\n");
        sql.append("T.FMOTID\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        if (!mpsMergeType_operation_level) {
            sql.setLength(0);
            sql.append(" select a.fid,");
            sql.append(" (select max(foperationno)");
            sql.append("    from ").append(motTempTable).append("");
            sql.append("   where fparentid = a.fparentid").append(" and cfisxopertion = 1");
            sql.append("          and foperationno < a.foperationno) pno,");
            sql.append(" (select fid");
            sql.append("    from ").append(motTempTable).append("");
            sql.append("   where fparentid = a.fparentid");
            sql.append("       \t and foperationno =");
            sql.append("           (select max(foperationno)");
            sql.append("              from ").append(motTempTable).append("");
            sql.append("             where fparentid = a.fparentid").append(" and cfisxopertion = 1");
            sql.append("               \t\tand foperationno < a.foperationno)) pid,");
            sql.append(" (case");
            sql.append("  when a.fworkcenterid =");
            sql.append("         (select fworkcenterid");
            sql.append("            from ").append(motTempTable).append("");
            sql.append("           where fparentid = a.fparentid ");
            sql.append("                and foperationno = (select max(foperationno)");
            sql.append("              \t\t\t\t\t\t  from ").append(motTempTable).append("");
            sql.append("             \t\t\t\t\t\t where fparentid = a.fparentid").append(" and cfisxopertion = 1");
            sql.append("               \t\t\t\t\t\t\t   and foperationno < a.foperationno))");
            sql.append("  then 0 else 1 end) isfirst");
            sql.append(" from ").append(motTempTable).append(" a");
            sql.append(" inner join ").append(motTempTable).append(" b").append(" on b.fparentid = a.fparentid").append(" and b.foperationno < a.foperationno").append(" and b.fworkcenterid = a.fworkcenterid").append(" and b.cfisxopertion = 1");
            sql.append(" where exists (").append("select 1 from ").append(motTempTable).append(" where fparentid = a.fparentid").append(" and foperationno > b.foperationno and foperationno < a.foperationno").append(" and fworkcenterid != a.fworkcenterid").append(")");
            sql.append(" and a.cfisxopertion = 1");
            sql.append(" group by a.fid,a.fparentid, a.foperationno,a.fworkcenterid");
            sql.append(" order by a.fparentid,a.foperationno");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<String> sqls_up_merge = new ArrayList<String>();
            try {
                while (rows.next()) {
                    sql.setLength(0);
                    sql.append("update ").append(motTempTable);
                    sql.append(" set fmergeid = ");
                    if (rows.getInt("isfirst") == 1) {
                        sql.append("newbosid('12345678')");
                    } else {
                        sql.append("(select fmergeid from ").append(motTempTable).append(" where fid = '").append(rows.getString("pid")).append("'").append(")");
                    }
                    sql.append(" where fid = '").append(rows.getString("fid")).append("'");
                    sqls_up_merge.add(sql.toString());
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (sqls_up_merge.size() > 0) {
                if (sqls_up_merge.size() <= 1000) {
                    String[] up = new String[sqls_up_merge.size()];
                    sqls_up_merge.toArray(up);
                    this.executeSQLBatch(ctx, up);
                } else {
                    ArrayList up_merge = new ArrayList();
                    int size = sqls_up_merge.size();
                    for (int i = 0; i < size; ++i) {
                        up_merge.add(sqls_up_merge.get(i));
                        if (up_merge.size() < 1000) continue;
                        String[] up = new String[up_merge.size()];
                        up_merge.toArray(up);
                        this.executeSQLBatch(ctx, up);
                        up_merge.clear();
                    }
                    if (up_merge.size() > 0) {
                        String[] up = new String[up_merge.size()];
                        up_merge.toArray(up);
                        this.executeSQLBatch(ctx, up);
                        up_merge.clear();
                    }
                }
            }
        }
        this.insertMOTData(ctx, motTempTable);
    }

    protected void generateWorkshopSchedule(Context ctx, Map param) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("T.FWCID \"FWCID\"\r\n");
        sql.append("From (\r\n");
        sql.append("Select\r\n");
        sql.append("PWC.FID \"FWCID\"\r\n");
        sql.append("From T_MM_MFTOrderTechnics MOTE\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=MOTE.FParentID\r\n");
        sql.append("Inner Join T_MM_WorkCenter WC On WC.FID=MOTE.FWorkCenterID\r\n");
        sql.append("Inner Join T_MM_WorkCenter PWC On PWC.FID=WC.FParentWCID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And IsNull(WC.FStatus,0)=").append(20).append("\r\n");
        sql.append("And IsNull(PWC.FStatus,0)=").append(20).append("\r\n");
        sql.append("And IsNull(PWC.CFIsWorkshop,0)=1\r\n");
        sql.append("And IsNull(PWC.CFIsGenerateWS,0)=1\r\n");
        sql.append("And MO.FSourceBillID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("Group By\r\n");
        sql.append("PWC.FID\r\n");
        sql.append(") T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And (Not Exists (\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From CT_PS_WorkshopSchedule WS\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And WS.FSourceBillID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And WS.CFWorkCenterID=T.FWCID\r\n");
        sql.append(")\r\n");
        sql.append(")\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            StorageOrgUnitInfo storageOrgUnitInfo = new StorageOrgUnitInfo();
            storageOrgUnitInfo.setId(BOSUuid.read((String)param.get("StorageORGUnitID").toString()));
            MasterProductionScheduleInfo masterProductionScheduleInfo = new MasterProductionScheduleInfo();
            masterProductionScheduleInfo.setId(BOSUuid.read((String)param.get("MasterProductionScheduleID").toString()));
            FactoryCalendarInfo factoryCalendarInfo = new FactoryCalendarInfo();
            factoryCalendarInfo.setId(BOSUuid.read((String)param.get("FactoryCalendarID").toString()));
            ProjectJCHInfo projectJCHInfo = null;
            if (param.containsKey("ProjectJCHID") && param.get("ProjectJCHID") != null) {
                projectJCHInfo = new ProjectJCHInfo();
                projectJCHInfo.setId(BOSUuid.read((String)param.get("ProjectJCHID").toString()));
            }
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            UserInfo curUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            Date curDate = new Date();
            Timestamp curTimestamp = new Timestamp(curDate.getTime());
            try {
                while (rs.next()) {
                    String workCenterID = rs.getString("FWCID");
                    if (workCenterID == null || workCenterID.trim().length() == 0) continue;
                    WorkshopScheduleInfo workshopScheduleInfo = new WorkshopScheduleInfo();
                    this.setBillNumber(ctx, (IObjectValue)workshopScheduleInfo, param.get("StorageORGUnitID").toString());
                    workshopScheduleInfo.setBizDate(new Date());
                    workshopScheduleInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                    workshopScheduleInfo.setStorageOrgUnit(storageOrgUnitInfo);
                    workshopScheduleInfo.setMps(masterProductionScheduleInfo);
                    WorkCenterInfo workCenterInfo = new WorkCenterInfo();
                    workCenterInfo.setId(BOSUuid.read((String)workCenterID));
                    workshopScheduleInfo.setWorkCenter(workCenterInfo);
                    workshopScheduleInfo.setFCalendar(factoryCalendarInfo);
                    workshopScheduleInfo.put("planStartTime", param.containsKey("OriginalStartTime") ? param.get("OriginalStartTime") : null);
                    workshopScheduleInfo.put("planFinishTime", param.containsKey("FinishTime") ? param.get("FinishTime") : null);
                    if (ScheduleTypeEnum.SF.getAlias().equals(param.get("ScheduleType").toString())) {
                        workshopScheduleInfo.put("scheduleType", (Object)ScheduleTypeEnum.SF);
                    } else if (ScheduleTypeEnum.FS.getAlias().equals(param.get("ScheduleType").toString())) {
                        workshopScheduleInfo.put("scheduleType", (Object)ScheduleTypeEnum.FS);
                    }
                    workshopScheduleInfo.setSourceBillId(param.get("MasterProductionScheduleID").toString());
                    workshopScheduleInfo.put("projectJCH", projectJCHInfo);
                    workshopScheduleInfo.setCreator(curUserInfo);
                    workshopScheduleInfo.setCreateTime(curTimestamp);
                    workshopScheduleInfo.setLastUpdateUser(curUserInfo);
                    workshopScheduleInfo.setLastUpdateTime(curTimestamp);
                    coreBaseCollection.add((CoreBaseInfo)workshopScheduleInfo);
                }
                WorkshopScheduleFactory.getLocalInstance(ctx).addnew(coreBaseCollection);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected String getBDResource(Context ctx, String item, String[] param) {
        if (item == null || item.trim().length() == 0) {
            return null;
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.basedata.BasedataResource", (String)item, (Locale)ctx.getLocale());
        if (msg == null || msg.trim().length() == 0) {
            return null;
        }
        if (param != null) {
            for (int i = 0; i < param.length; ++i) {
                if (param[i] == null) continue;
                msg = msg.replace("{" + i + "}", param[i]);
            }
        }
        return msg;
    }

    protected MaterialPlanInfo getMaterialPlanInfo(Context ctx, MaterialInfo material, StorageOrgUnitInfo storage) throws BOSException {
        if (material == null || storage == null) {
            return null;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("productTranType.*"));
        selectorItemCollection.add(new SelectorItemInfo("productTranType.bizType.id"));
        selectorItemCollection.add(new SelectorItemInfo("productTranType.bizType.number"));
        selectorItemCollection.add(new SelectorItemInfo("productTranType.bizType.name"));
        selectorItemCollection.add(new SelectorItemInfo("planner.*"));
        selectorItemCollection.add(new SelectorItemInfo("dutyDepartment.id"));
        selectorItemCollection.add(new SelectorItemInfo("dutyDepartment.number"));
        selectorItemCollection.add(new SelectorItemInfo("dutyDepartment.name"));
        selectorItemCollection.add(new SelectorItemInfo("planOrg.id"));
        selectorItemCollection.add(new SelectorItemInfo("planOrg.number"));
        selectorItemCollection.add(new SelectorItemInfo("planOrg.name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storage.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        IMaterialPlan iMaterialPlan = MaterialPlanFactory.getLocalInstance((Context)ctx);
        MaterialPlanCollection materialPlanCollection = iMaterialPlan.getMaterialPlanCollection(entityViewInfo);
        if (materialPlanCollection != null && materialPlanCollection.size() > 0) {
            MaterialPlanInfo materialPlanInfo = materialPlanCollection.get(0);
            return materialPlanInfo;
        }
        return null;
    }

    protected String getParamValue(Context ctx, String paramName, String storageOrgUnitID) throws BOSException, EASBizException {
        if (storageOrgUnitID == null) {
            return null;
        }
        String value = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("value"));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)storageOrgUnitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)paramName, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        ParamItemCollection paramItemCollection = ParamItemFactory.getLocalInstance((Context)ctx).getParamItemCollection(entityViewInfo);
        if (paramItemCollection != null && paramItemCollection.size() > 0 && paramItemCollection.get(0) != null) {
            value = paramItemCollection.get(0).getValue() == null ? "" : paramItemCollection.get(0).getValue();
        }
        return value;
    }

    protected String getPSResource(Context ctx, String item, String[] param) {
        if (item == null || item.trim().length() == 0) {
            return null;
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.PsResource", (String)item, (Locale)ctx.getLocale());
        if (msg == null || msg.trim().length() == 0) {
            return null;
        }
        if (param != null) {
            for (int i = 0; i < param.length; ++i) {
                if (param[i] == null) continue;
                msg = msg.replace("{" + i + "}", param[i]);
            }
        }
        return msg;
    }

    protected String insertAddMOMOTempTableSQL(String addMOMOTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(addMOMOTempTable).append("(\r\n");
        sql.append("FMOID,\r\n");
        sql.append("FMATERIALID,\r\n");
        sql.append("FOPERATIONID,\r\n");
        sql.append("FSUMUNITQTY,\r\n");
        sql.append("FSUMQTY,\r\n");
        sql.append("FSUMPLANNEDQTY,\r\n");
        sql.append("FCURSUMUNITQTY,\r\n");
        sql.append("FCURSUMQTY,\r\n");
        sql.append("FCURSUMPLANNEDQTY,\r\n");
        sql.append("FMOREUNITQTY,\r\n");
        sql.append("FMOREQTY,\r\n");
        sql.append("FMOREPLANNEDQTY,\r\n");
        sql.append("FMOSID,\r\n");
        sql.append("FMAXSEQ\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertCostObjectEntrySQL(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into T_BD_CostObjectEntry(\r\n");
        sql.append("FID,\r\n");
        sql.append("FParentID,\r\n");
        sql.append("FRelatedID,\r\n");
        sql.append("FQuotiety,\r\n");
        sql.append("FRelatedNumber,\r\n");
        sql.append("FRelatedName,\r\n");
        sql.append("FSEQ,\r\n");
        sql.append("FIsByProduct,\r\n");
        sql.append("FIsMainProduct,\r\n");
        sql.append("FRemark");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertCostObjectGroupSQL(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into T_BD_CostObjectGroup(\r\n");
        sql.append("FID,\r\n");
        sql.append("FControlUnitID,\r\n");
        sql.append("FCreatorID,\r\n");
        sql.append("FLastUpdateUserID,\r\n");
        sql.append("FCompanyID,\r\n");
        sql.append("FParentID,\r\n");
        sql.append("FCreateTime,\r\n");
        sql.append("FLastUpdateTime,\r\n");
        sql.append("FName_").append(ctx.getLocale()).append(",\r\n");
        sql.append("FNumber,\r\n");
        sql.append("FDescription_").append(ctx.getLocale()).append(",\r\n");
        sql.append("FSimpleName,\r\n");
        sql.append("FLongNumber,\r\n");
        sql.append("FDisplayName_").append(ctx.getLocale()).append(",\r\n");
        sql.append("FLevel,\r\n");
        sql.append("FRelatedType,\r\n");
        sql.append("FCalculateMode,\r\n");
        sql.append("FIsLeaf,\r\n");
        sql.append("FIsAutoInManufacture,\r\n");
        sql.append("FIsUsed\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertCostObjectSQL(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into T_BD_CostObject(\r\n");
        sql.append("FID,\r\n");
        sql.append("FControlUnitID,\r\n");
        sql.append("FCreatorID,\r\n");
        sql.append("FLastUpdateUserID,\r\n");
        sql.append("FCompanyID,\r\n");
        sql.append("FGroupID,\r\n");
        sql.append("FBOMID,\r\n");
        sql.append("FTrackID,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FOrderID,\r\n");
        sql.append("FCOGroupID,\r\n");
        sql.append("FSTDProductIDID,\r\n");
        sql.append("FRelatedID,\r\n");
        sql.append("FCreateTime,\r\n");
        sql.append("FLastUpdateTime,\r\n");
        sql.append("FName_").append(ctx.getLocale()).append(",\r\n");
        sql.append("FNumber,\r\n");
        sql.append("FDescription_").append(ctx.getLocale()).append(",\r\n");
        sql.append("FSimpleName,\r\n");
        sql.append("FOrderNumber,\r\n");
        sql.append("FBatchNumber,\r\n");
        sql.append("FRelatedNumber,\r\n");
        sql.append("FRelatedName,\r\n");
        sql.append("FRelatedType,\r\n");
        sql.append("FCalculateMode,\r\n");
        sql.append("FIsFinished,\r\n");
        sql.append("FIsMoreBOM,\r\n");
        sql.append("FIsForbiden,\r\n");
        sql.append("FIsSYS,\r\n");
        sql.append("cfstatus,\r\n");
        sql.append("cflcmprojecttypeid,\r\n");
        sql.append("cfcostcenterid");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertCURMOMOTempTableSQL(String curMOMOTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(curMOMOTempTable).append("(\r\n");
        sql.append("FMOID,\r\n");
        sql.append("FMATERIALID,\r\n");
        sql.append("FOPERATIONID,\r\n");
        sql.append("FSUMUNITQTY,\r\n");
        sql.append("FSUMQTY,\r\n");
        sql.append("FSUMPLANNEDQTY\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertDeleteTempTableSQL(String deleteTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(deleteTempTableName).append("(\r\n");
        sql.append("FID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertIMTTTempTableSQL(String imttTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(imttTempTableName).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FIssueMode,\r\n");
        sql.append("FTransferType\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertJGJMOSEWHTempTableSQL(Context ctx, String zxjjgjmosewhTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(zxjjgjmosewhTempTable).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FMOSID,\r\n");
        sql.append("FWarehouseID,\r\n");
        sql.append("FNewWarehouseID,\r\n");
        sql.append("FNewWarehouseGroupName\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertManufactureOrderExpectOutputSQL(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into T_MM_MFTOrderExpectOutput(\r\n");
        sql.append("FID,\r\n");
        sql.append("FParentID,\r\n");
        sql.append("FOperationID,\r\n");
        sql.append("FDefaultWarehouseID,\r\n");
        sql.append("FCostObjectID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FAssisPropertyID,\r\n");
        sql.append("FUnitID,\r\n");
        sql.append("FBaseUnitID,\r\n");
        sql.append("FAssistUnitID,\r\n");
        sql.append("FReasonCodeID,\r\n");
        sql.append("FASSCoefficient,\r\n");
        sql.append("FAssociateQTY,\r\n");
        sql.append("FQTY,\r\n");
        sql.append("FBaseQty,\r\n");
        sql.append("FAssistQTY,\r\n");
        sql.append("FAssistBaseQTY,\r\n");
        sql.append("FFinishedQTY,\r\n");
        sql.append("FFinishedBaseQTY,\r\n");
        sql.append("FPassQTY,\r\n");
        sql.append("FPassBaseQTY,\r\n");
        sql.append("FScrapQTY,\r\n");
        sql.append("FScrapBaseQTY,\r\n");
        sql.append("FToStoreQTY,\r\n");
        sql.append("FToStoreBaseQTY,\r\n");
        sql.append("FSEQ,\r\n");
        sql.append("FBaseStatus,\r\n");
        sql.append("FOutputType,\r\n");
        sql.append("FOperationNO,\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertManufactureOrderSQL(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into T_MM_ManufactureOrder(\r\n");
        sql.append("FID,\r\n");
        sql.append("FStorageORGUnitID,\r\n");
        sql.append("FBIZTypeID,\r\n");
        sql.append("FTransactionTypeID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FUnitID,\r\n");
        sql.append("FADMINORGUnitID,\r\n");
        sql.append("FBOMID,\r\n");
        sql.append("FBOMNUM,\r\n");
        sql.append("FRoutingID,\r\n");
        sql.append("FDispatcherID,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FTrackID,\r\n");
        sql.append("FDefaultWarehouseID,\r\n");
        sql.append("FSourceBillID,\r\n");
        sql.append("FBillTypeID,\r\n");
        sql.append("FControlUnitID,\r\n");
        sql.append("FCostObjectID,\r\n");
        sql.append("FAssignUnitID,\r\n");
        sql.append("FMPSID,\r\n");
        sql.append("FProjectJCHID,\r\n");
        sql.append("FNumber,\r\n");
        sql.append("FDescription,\r\n");
        sql.append("FLOT,\r\n");
        sql.append("FBaseStatus,\r\n");
        sql.append("FOldBaseStatus,\r\n");
        sql.append("FScheduleType,\r\n");
        sql.append("FBirthType,\r\n");
        sql.append("FYear,\r\n");
        sql.append("FPeriod,\r\n");
        sql.append("FHasEffected,\r\n");
        sql.append("FIsAutoFinished,\r\n");
        sql.append("FIsMANUFinished,\r\n");
        sql.append("FIsDirectSend,\r\n");
        sql.append("CFIsWarehouse,\r\n");
        sql.append("FBIZDate,\r\n");
        sql.append("FPlanBeginDate,\r\n");
        sql.append("FPlanEndDate,\r\n");
        sql.append("FActureBeginDate,\r\n");
        sql.append("FActureEndDate,\r\n");
        sql.append("FQTY,\r\n");
        sql.append("FBaseQTY,\r\n");
        sql.append("FBaseUnitQTY,\r\n");
        sql.append("FDeliveryQTY,\r\n");
        sql.append("FDeliveryBaseQTY,\r\n");
        sql.append("FExtraRatio,\r\n");
        sql.append("FExtraUpperLimit,\r\n");
        sql.append("FExtraUpperLimitBase,\r\n");
        sql.append("FLackRatio,\r\n");
        sql.append("FLackLowerLimit,\r\n");
        sql.append("FLackLowerLimitBase,\r\n");
        sql.append("FFinishedQTY,\r\n");
        sql.append("FFinishedBaseQTY,\r\n");
        sql.append("FPassQTY,\r\n");
        sql.append("FPassBaseQTY,\r\n");
        sql.append("FScrapQTY,\r\n");
        sql.append("FScrapBaseQTY,\r\n");
        sql.append("FRepairQTY,\r\n");
        sql.append("FRepairBaseQTY,\r\n");
        sql.append("FToStoreQTY,\r\n");
        sql.append("FToStoreBaseQTY,\r\n");
        sql.append("FTestedQTY,\r\n");
        sql.append("FTestedBaseQTY,\r\n");
        sql.append("FUnToStoreQTY,\r\n");
        sql.append("FUnToStoreBaseQTY,\r\n");
        sql.append("FUnTestedQTY,\r\n");
        sql.append("FUnTestedBaseQTY,\r\n");
        sql.append("FLastOPPassQTY,\r\n");
        sql.append("FLastOPPassBaseQTY,\r\n");
        sql.append("FUnRepairQTY,\r\n");
        sql.append("FUnRepairBaseQTY,\r\n");
        sql.append("FTotalDirectSendQTY,\r\n");
        sql.append("FTotalDirectSendBaseQTY,\r\n");
        sql.append("FTotalSplitQTY,\r\n");
        sql.append("FTotalSplitBaseQTY,\r\n");
        sql.append("FConcessionQTY,\r\n");
        sql.append("FConcessionBaseQTY,\r\n");
        sql.append("FIsUnLimitedQTY,\r\n");
        sql.append("FFirstOPERNO,\r\n");
        sql.append("FLastOPERNO,\r\n");
        sql.append("FYield,\r\n");
        sql.append("FCreatorID,\r\n");
        sql.append("FCreateTime,\r\n");
        sql.append("FLastUpdateUserID,\r\n");
        sql.append("FLastUpdateTime,\r\n");
        sql.append("FHandlerID,\r\n");
        sql.append("FModifierID,\r\n");
        sql.append("FModificationTime,\r\n");
        sql.append("FAuditorID,\r\n");
        sql.append("FAuditTime\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertManufactureOrderStockSQL(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into T_MM_MFTOrderStock(\r\n");
        sql.append("FID,\r\n");
        sql.append("FParentID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FReplaceMaterialID,\r\n");
        sql.append("FAssistPropertyID,\r\n");
        sql.append("FUnitID,\r\n");
        sql.append("FBaseUnitID,\r\n");
        sql.append("FAssistUnitID,\r\n");
        sql.append("FReasonCodeID,\r\n");
        sql.append("FWarehouseID,\r\n");
        sql.append("FReceiptStockID,\r\n");
        sql.append("FCombinationStockID,\r\n");
        sql.append("FLocationID,\r\n");
        sql.append("FOperationID,\r\n");
        sql.append("FStorageORGUnitID,\r\n");
        sql.append("FReceiptStroageORGUnitID,\r\n");
        sql.append("FWorkCenterID,\r\n");
        sql.append("FBOMEntryID,\r\n");
        sql.append("FSourceBillEntryID,\r\n");
        sql.append("FAssociateQTY,\r\n");
        sql.append("FLossRatio,\r\n");
        sql.append("FExtraRatio,\r\n");
        sql.append("FLackRatio,\r\n");
        sql.append("FReplaceRatio,\r\n");
        sql.append("FUnitReplaceQTY,\r\n");
        sql.append("CFOpenQTY,\r\n");
        sql.append("CFActMoveQTY,\r\n");
        sql.append("CFALRMoveQTY,\r\n");
        sql.append("FQTY,\r\n");
        sql.append("FBaseQTY,\r\n");
        sql.append("FLossQTY,\r\n");
        sql.append("FLossBaseQTY,\r\n");
        sql.append("FActIssueQTY,\r\n");
        sql.append("FActIssueBaseQTY,\r\n");
        sql.append("FActLossQTY,\r\n");
        sql.append("FActLossBaseQTY,\r\n");
        sql.append("FRejectedQTY,\r\n");
        sql.append("FRejectedBaseQTY,\r\n");
        sql.append("FFeedingQTY,\r\n");
        sql.append("FFeedingBaseQTY,\r\n");
        sql.append("FScrapQTY,\r\n");
        sql.append("FScrapBaseQTY,\r\n");
        sql.append("FWIPQTY,\r\n");
        sql.append("FWIPBaseQTY,\r\n");
        sql.append("FPlannedQTY,\r\n");
        sql.append("FPlannedBaseQTY,\r\n");
        sql.append("FUnitQTY,\r\n");
        sql.append("FUnitBaseQTY,\r\n");
        sql.append("FMaterialScrapQTY,\r\n");
        sql.append("FMaterialScrapBaseQTY,\r\n");
        sql.append("FMaterialFeedingQTY,\r\n");
        sql.append("FMaterialFeedingBaseQTY,\r\n");
        sql.append("FUnIssueQTY,\r\n");
        sql.append("FUnIssueBaseQTY,\r\n");
        sql.append("FToStoreQTY,\r\n");
        sql.append("FToStoreBaseQTY,\r\n");
        sql.append("FOriginalPlanQTY,\r\n");
        sql.append("FOriginalPlanBaseQTY,\r\n");
        sql.append("FTotalReceiptQTY,\r\n");
        sql.append("FTotalReceiptBaseQTY,\r\n");
        sql.append("FUnReceiptQTY,\r\n");
        sql.append("FUnReceiptBaseQTY,\r\n");
        sql.append("FTotalDirectReceiveQTY,\r\n");
        sql.append("FTotalDirectReceiveBaseQTY,\r\n");
        sql.append("FTotalDSTransferQTY,\r\n");
        sql.append("FTotalDSTransferBaseQTY,\r\n");
        sql.append("FDemandTime,\r\n");
        sql.append("FActueIssueTime,\r\n");
        sql.append("FBLKSize,\r\n");
        sql.append("FSpecifiedLength,\r\n");
        sql.append("FASSYLocation_").append(ctx.getLocale()).append(",\r\n");
        sql.append("FRemark,\r\n");
        sql.append("FSEQ,\r\n");
        sql.append("FLineSEQ,\r\n");
        sql.append("FBaseStatus,\r\n");
        sql.append("FMATReplaceType,\r\n");
        sql.append("FTransferType,\r\n");
        sql.append("FProvideType,\r\n");
        sql.append("FPickType,\r\n");
        sql.append("FScrapEXPR,\r\n");
        sql.append("FReplaceGroupFlag,\r\n");
        sql.append("FReplacePriority,\r\n");
        sql.append("CFMoveStatus,\r\n");
        sql.append("FNewNetWeight,\r\n");
        sql.append("FOperationNO,\r\n");
        sql.append("FIssueMode,\r\n");
        sql.append("FIsReplaced,\r\n");
        sql.append("FIsBackFlush,\r\n");
        sql.append("FIsQTYLimit,\r\n");
        sql.append("FIsStockALLOT,\r\n");
        sql.append("CFIsMustREQ,\r\n");
        sql.append("CFIsLineStoreHouse\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertManufactureOrderTechnicsSQL(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into T_MM_MFTOrderTechnics(\r\n");
        sql.append("FID,\r\n");
        sql.append("FParentID,\r\n");
        sql.append("FWorkCenterID,\r\n");
        sql.append("FStorageORGUnitID,\r\n");
        sql.append("FADMINORGUnitID,\r\n");
        sql.append("FControlStrategyID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FAssistPropertyID,\r\n");
        sql.append("FUnitID,\r\n");
        sql.append("FBaseUnitID,\r\n");
        sql.append("FAssistUnitID,\r\n");
        sql.append("FOperationID,\r\n");
        sql.append("FEntrustSupplierID,\r\n");
        sql.append("FSubRoutingID,\r\n");
        sql.append("FSourceBillEntryID,\r\n");
        sql.append("FMergeID,\r\n");
        sql.append("FQueuingTime,\r\n");
        sql.append("FPrepareTime,\r\n");
        sql.append("FWorkTime,\r\n");
        sql.append("FWaitingTime,\r\n");
        sql.append("FMovingTime,\r\n");
        sql.append("FASSCoefficient,\r\n");
        sql.append("CFFixedWorkingTime,\r\n");
        sql.append("CFTOTFixedWorkTime,\r\n");
        sql.append("FProcessBatch,\r\n");
        sql.append("FAssociateQTY,\r\n");
        sql.append("FQTY,\r\n");
        sql.append("FBaseQTY,\r\n");
        sql.append("FOperQTY,\r\n");
        sql.append("FFinishedQTY,\r\n");
        sql.append("FFinishedBaseQTY,\r\n");
        sql.append("FIntoQTY,\r\n");
        sql.append("FIntoBaseQTY,\r\n");
        sql.append("FOutQTY,\r\n");
        sql.append("FOutBaseQTY,\r\n");
        sql.append("FTestQTY,\r\n");
        sql.append("FTestBaseQTY,\r\n");
        sql.append("FPassQTY,\r\n");
        sql.append("FPassBaseQTY,\r\n");
        sql.append("FScrapQTY,\r\n");
        sql.append("FScrapBaseQTY,\r\n");
        sql.append("FRepairQTY,\r\n");
        sql.append("FRepairBaseQTY,\r\n");
        sql.append("FTotalQTYUpper,\r\n");
        sql.append("FTotalBaseQTYUpper,\r\n");
        sql.append("FTotalQTYLower,\r\n");
        sql.append("FTotalBaseQTYLower,\r\n");
        sql.append("FREPReportQTY,\r\n");
        sql.append("FREPReportBaseQTY,\r\n");
        sql.append("FREPMoveInQTY,\r\n");
        sql.append("FREPMoveInBaseQTY,\r\n");
        sql.append("FREPMoveOutQTY,\r\n");
        sql.append("FREPMoveOutBaseQTY,\r\n");
        sql.append("FUnFinishQTY,\r\n");
        sql.append("FUnFinishBaseQTY,\r\n");
        sql.append("FUnMoveOutQTY,\r\n");
        sql.append("FUnMoveOutBaseQTY,\r\n");
        sql.append("FUnTestQTY,\r\n");
        sql.append("FUnTestBaseQTY,\r\n");
        sql.append("FTotalSplitQTY,\r\n");
        sql.append("FTotalSplitBaseQTY,\r\n");
        sql.append("FTotalDispatchQTY,\r\n");
        sql.append("FTotalDispatchBaseQTY,\r\n");
        sql.append("FTotalMaterialScrapQTY,\r\n");
        sql.append("FTotalMaterialScrapBaseQTY,\r\n");
        sql.append("FTotalManufactureScrapQTY,\r\n");
        sql.append("FTotalManufactureScrapBaseQTY,\r\n");
        sql.append("FUnDispatchQTY,\r\n");
        sql.append("FUnDispatchBaseQTY,\r\n");
        sql.append("FConcessionQTY,\r\n");
        sql.append("FConcessionBaseQTY,\r\n");
        sql.append("FTheoreticalLaborCost,\r\n");
        sql.append("FTheoreticalScrapLaborCost,\r\n");
        sql.append("FTheoreticalMATScrapLaborCost,\r\n");
        sql.append("FActualLaborCost,\r\n");
        sql.append("FActualScrapLaborCost,\r\n");
        sql.append("FActualMATScrapLaborCost,\r\n");
        sql.append("FEarlistWOKTime,\r\n");
        sql.append("FEarlistCMPTime,\r\n");
        sql.append("FLastWorkTime,\r\n");
        sql.append("FLastCMPTime,\r\n");
        sql.append("FCreateTime,\r\n");
        sql.append("CFPROInstruction,\r\n");
        sql.append("FOperationRemark_").append(ctx.getLocale()).append(",\r\n");
        sql.append("FSEQ,\r\n");
        sql.append("FTimeUnit,\r\n");
        sql.append("FBaseStatus,\r\n");
        sql.append("CFPERBaseStatus,\r\n");
        sql.append("FOperationNO,\r\n");
        sql.append("FEntrustType,\r\n");
        sql.append("FValuationType,\r\n");
        sql.append("FOverrunMeasure,\r\n");
        sql.append("FIsCheckPoint,\r\n");
        sql.append("FIsReportPoint,\r\n");
        sql.append("FIsPickingPoint,\r\n");
        sql.append("FIsKeyOP,\r\n");
        sql.append("CFIsXOpertion,\r\n");
        sql.append("FIsCanMerge,\r\n");
        sql.append("CFGongWei,\r\n");
        sql.append("cfopertionPrice\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected int insertMOSData(Context ctx, String mosTempTable, Boolean regenerate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(this.insertManufactureOrderStockSQL(ctx));
        sql.append("Select\r\n");
        sql.append("FID,\r\n");
        sql.append("FParentID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FReplaceMaterialID,\r\n");
        sql.append("FASSISTPropertyID,\r\n");
        sql.append("FUnitID,\r\n");
        sql.append("FBaseUnitID,\r\n");
        sql.append("FASSISTUnitID,\r\n");
        sql.append("FReasonCodeID,\r\n");
        sql.append("FWarehouseID,\r\n");
        sql.append("FReceiptStockID,\r\n");
        sql.append("FCombinationStockID,\r\n");
        sql.append("FLocationID,\r\n");
        sql.append("FOperationID,\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FReceiptStroageOrgUnitID,\r\n");
        sql.append("FWorkCenterID,\r\n");
        sql.append("FBOMEntryID,\r\n");
        sql.append("FSourceBillEntryID,\r\n");
        sql.append("FAssociateQTY,\r\n");
        sql.append("FLossRatio,\r\n");
        sql.append("FExtraRatio,\r\n");
        sql.append("FLackRatio,\r\n");
        sql.append("FReplaceRatio,\r\n");
        sql.append("FUnitReplaceQTY,\r\n");
        sql.append("CFOpenQTY,\r\n");
        sql.append("CFACTMoveQTY,\r\n");
        sql.append("CFALRMoveQTY,\r\n");
        sql.append("FQTY,\r\n");
        sql.append("FBaseQTY,\r\n");
        sql.append("FLossQTY,\r\n");
        sql.append("FLossBaseQTY,\r\n");
        sql.append("FACTIssueQTY,\r\n");
        sql.append("FACTIssueBaseQTY,\r\n");
        sql.append("FACTLossQTY,\r\n");
        sql.append("FACTLossBaseQTY,\r\n");
        sql.append("FRejectedQTY,\r\n");
        sql.append("FRejectedBaseQTY,\r\n");
        sql.append("FFeedingQTY,\r\n");
        sql.append("FFeedingBaseQTY,\r\n");
        sql.append("FScrapQTY,\r\n");
        sql.append("FScrapBaseQTY,\r\n");
        sql.append("FWIPQTY,\r\n");
        sql.append("FWIPBaseQTY,\r\n");
        sql.append("FPlannedQTY,\r\n");
        sql.append("FPlannedBaseQTY,\r\n");
        sql.append("FUnitQTY,\r\n");
        sql.append("FUnitBaseQTY,\r\n");
        sql.append("FMaterialScrapQTY,\r\n");
        sql.append("FMaterialScrapBaseQTY,\r\n");
        sql.append("FMaterialFeedingQTY,\r\n");
        sql.append("FMaterialFeedingBaseQTY,\r\n");
        sql.append("FUnIssueQTY,\r\n");
        sql.append("FUnIssueBaseQTY,\r\n");
        sql.append("FToStoreQTY,\r\n");
        sql.append("FToStoreBaseQTY,\r\n");
        sql.append("FOriginalPlanQTY,\r\n");
        sql.append("FOriginalPlanBaseQTY,\r\n");
        sql.append("FTotalReceiptQTY,\r\n");
        sql.append("FTotalReceiptBaseQTY,\r\n");
        sql.append("FUnReceiptQTY,\r\n");
        sql.append("FUnReceiptBaseQTY,\r\n");
        sql.append("FTotalDirectReceiveQTY,\r\n");
        sql.append("FTotalDirectReceiveBaseQTY,\r\n");
        sql.append("FTotalDSTransferQTY,\r\n");
        sql.append("FTotalDSTransferBaseQTY,\r\n");
        sql.append("FDemandTime,\r\n");
        sql.append("FACTUEIssueTime,\r\n");
        sql.append("FBLKSize,\r\n");
        sql.append("FSpecifiedLength,\r\n");
        sql.append("FASSYLocation_").append(ctx.getLocale()).append(",\r\n");
        if (regenerate.booleanValue()) {
            String userName = ctx.getUserName() == null ? "" : ctx.getUserName();
            sql.append("N'" + OperationScheduleUtils.sdfDateTime.format(new Date()) + " " + userName + " \u4e3b\u8ba1\u5212\u91cd\u7b97\u751f\u4ea7\u5907\u6599\u751f\u6210',\r\n");
        } else {
            sql.append("Null,\r\n");
        }
        sql.append("IsNull(FSEQ,0),\r\n");
        sql.append("FLineSEQ,\r\n");
        sql.append("FBaseStatus,\r\n");
        sql.append("FMATREPlaceType,\r\n");
        sql.append("FTransferType,\r\n");
        sql.append("FProvideType,\r\n");
        sql.append("FPickType,\r\n");
        sql.append("FScrapEXPR,\r\n");
        sql.append("FReplaceGroupFlag,\r\n");
        sql.append("FReplacePriority,\r\n");
        sql.append("CFMoveStatus,\r\n");
        sql.append("FNewNetWeight,\r\n");
        sql.append("FOperationNO,\r\n");
        sql.append("FIssueMode,\r\n");
        sql.append("FIsReplaced,\r\n");
        sql.append("FIsBackFlush,\r\n");
        sql.append("FIsQTYLimit,\r\n");
        sql.append("FIsStockALLOT,\r\n");
        sql.append("CFIsMustREQ,\r\n");
        sql.append("CFIsLineStoreHouse\r\n");
        sql.append("From ").append(mosTempTable).append("\r\n");
        int effectedRows = this.executeSQL(ctx, sql.toString());
        return effectedRows;
    }

    protected String insertMOSERSTempTableSQL(String mosersTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(mosersTempTable).append("(\r\n");
        sql.append("FROW,\r\n");
        sql.append("FMOSTOCKID,\r\n");
        sql.append("FWAREHOUSEID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertMOSEWHGTempTableSQL(String mosewhgTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(mosewhgTempTable).append("(\r\n");
        sql.append("FMOSTOCKID,\r\n");
        sql.append("FCOUNT\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertMOSEWHTempTableSQL(String mosewhTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(mosewhTempTable).append("(\r\n");
        sql.append("FROW,\r\n");
        sql.append("FMOSTOCKID,\r\n");
        sql.append("FPROVIDETYPE,\r\n");
        sql.append("FWAREHOUSEID,\r\n");
        sql.append("FNEWWAREHOUSEID,\r\n");
        sql.append("FDEFAULTWAREHOUSEID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertMOSOrgTempTableSQL(String mosOrgTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(mosOrgTempTable).append("(\r\n");
        sql.append("FMOSID,\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FDefault\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertMOSTempTableSQL(Context ctx, String mosTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(mosTempTable).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FParentID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FReplaceMaterialID,\r\n");
        sql.append("FASSISTPropertyID,\r\n");
        sql.append("FUnitID,\r\n");
        sql.append("FBaseUnitID,\r\n");
        sql.append("FASSISTUnitID,\r\n");
        sql.append("FReasonCodeID,\r\n");
        sql.append("FWarehouseID,\r\n");
        sql.append("FReceiptStockID,\r\n");
        sql.append("FCombinationStockID,\r\n");
        sql.append("FLocationID,\r\n");
        sql.append("FOperationID,\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FReceiptStroageOrgUnitID,\r\n");
        sql.append("FWorkCenterID,\r\n");
        sql.append("FBOMEntryID,\r\n");
        sql.append("FSourceBillEntryID,\r\n");
        sql.append("FAssociateQTY,\r\n");
        sql.append("FLossRatio,\r\n");
        sql.append("FExtraRatio,\r\n");
        sql.append("FLackRatio,\r\n");
        sql.append("FReplaceRatio,\r\n");
        sql.append("FUnitReplaceQTY,\r\n");
        sql.append("CFOpenQTY,\r\n");
        sql.append("CFACTMoveQTY,\r\n");
        sql.append("CFALRMoveQTY,\r\n");
        sql.append("FQTY,\r\n");
        sql.append("FBaseQTY,\r\n");
        sql.append("FLossQTY,\r\n");
        sql.append("FLossBaseQTY,\r\n");
        sql.append("FACTIssueQTY,\r\n");
        sql.append("FACTIssueBaseQTY,\r\n");
        sql.append("FACTLossQTY,\r\n");
        sql.append("FACTLossBaseQTY,\r\n");
        sql.append("FRejectedQTY,\r\n");
        sql.append("FRejectedBaseQTY,\r\n");
        sql.append("FFeedingQTY,\r\n");
        sql.append("FFeedingBaseQTY,\r\n");
        sql.append("FScrapQTY,\r\n");
        sql.append("FScrapBaseQTY,\r\n");
        sql.append("FWIPQTY,\r\n");
        sql.append("FWIPBaseQTY,\r\n");
        sql.append("FPlannedQTY,\r\n");
        sql.append("FPlannedBaseQTY,\r\n");
        sql.append("FUnitQTY,\r\n");
        sql.append("FUnitBaseQTY,\r\n");
        sql.append("FMaterialScrapQTY,\r\n");
        sql.append("FMaterialScrapBaseQTY,\r\n");
        sql.append("FMaterialFeedingQTY,\r\n");
        sql.append("FMaterialFeedingBaseQTY,\r\n");
        sql.append("FUnIssueQTY,\r\n");
        sql.append("FUnIssueBaseQTY,\r\n");
        sql.append("FToStoreQTY,\r\n");
        sql.append("FToStoreBaseQTY,\r\n");
        sql.append("FOriginalPlanQTY,\r\n");
        sql.append("FOriginalPlanBaseQTY,\r\n");
        sql.append("FTotalReceiptQTY,\r\n");
        sql.append("FTotalReceiptBaseQTY,\r\n");
        sql.append("FUnReceiptQTY,\r\n");
        sql.append("FUnReceiptBaseQTY,\r\n");
        sql.append("FTotalDirectReceiveQTY,\r\n");
        sql.append("FTotalDirectReceiveBaseQTY,\r\n");
        sql.append("FTotalDSTransferQTY,\r\n");
        sql.append("FTotalDSTransferBaseQTY,\r\n");
        sql.append("FDemandTime,\r\n");
        sql.append("FACTUEIssueTime,\r\n");
        sql.append("FBLKSize,\r\n");
        sql.append("FSpecifiedLength,\r\n");
        sql.append("FASSYLocation_").append(ctx.getLocale()).append(",\r\n");
        sql.append("FRemark,\r\n");
        sql.append("FSEQ,\r\n");
        sql.append("FLineSEQ,\r\n");
        sql.append("FBaseStatus,\r\n");
        sql.append("FMATREPlaceType,\r\n");
        sql.append("FTransferType,\r\n");
        sql.append("FProvideType,\r\n");
        sql.append("FPickType,\r\n");
        sql.append("FScrapEXPR,\r\n");
        sql.append("FReplaceGroupFlag,\r\n");
        sql.append("FReplacePriority,\r\n");
        sql.append("CFMoveStatus,\r\n");
        sql.append("FNewNetWeight,\r\n");
        sql.append("FOperationNO,\r\n");
        sql.append("FIssueMode,\r\n");
        sql.append("FIsReplaced,\r\n");
        sql.append("FIsBackFlush,\r\n");
        sql.append("FIsQTYLimit,\r\n");
        sql.append("FIsStockALLOT,\r\n");
        sql.append("CFIsMustREQ,\r\n");
        sql.append("CFIsLineStoreHouse,\r\n");
        sql.append("CFIsOwnObject\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected int insertMOTData(Context ctx, String motTempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(this.insertManufactureOrderTechnicsSQL(ctx));
        sql.append("Select\r\n");
        sql.append("FID,\r\n");
        sql.append("FParentID,\r\n");
        sql.append("FWorkCenterID,\r\n");
        sql.append("FStorageORGUnitID,\r\n");
        sql.append("FADMINORGUnitID,\r\n");
        sql.append("FControlStrategyID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FAssistPropertyID,\r\n");
        sql.append("FUnitID,\r\n");
        sql.append("FBaseUnitID,\r\n");
        sql.append("FAssistUnitID,\r\n");
        sql.append("FOperationID,\r\n");
        sql.append("FEntrustSupplierID,\r\n");
        sql.append("FSubRoutingID,\r\n");
        sql.append("FSourceBillEntryID,\r\n");
        sql.append("FMergeID,\r\n");
        sql.append("FQueuingTime,\r\n");
        sql.append("FPrepareTime,\r\n");
        sql.append("FWorkTime,\r\n");
        sql.append("FWaitingTime,\r\n");
        sql.append("FMovingTime,\r\n");
        sql.append("FASSCoefficient,\r\n");
        sql.append("CFFixedWorkingTime,\r\n");
        sql.append("CFTOTFixedWorkTime,\r\n");
        sql.append("FProcessBatch,\r\n");
        sql.append("FAssociateQTY,\r\n");
        sql.append("FQTY,\r\n");
        sql.append("FBaseQTY,\r\n");
        sql.append("FOperQTY,\r\n");
        sql.append("FFinishedQTY,\r\n");
        sql.append("FFinishedBaseQTY,\r\n");
        sql.append("FIntoQTY,\r\n");
        sql.append("FIntoBaseQTY,\r\n");
        sql.append("FOutQTY,\r\n");
        sql.append("FOutBaseQTY,\r\n");
        sql.append("FTestQTY,\r\n");
        sql.append("FTestBaseQTY,\r\n");
        sql.append("FPassQTY,\r\n");
        sql.append("FPassBaseQTY,\r\n");
        sql.append("FScrapQTY,\r\n");
        sql.append("FScrapBaseQTY,\r\n");
        sql.append("FRepairQTY,\r\n");
        sql.append("FRepairBaseQTY,\r\n");
        sql.append("FTotalQTYUpper,\r\n");
        sql.append("FTotalBaseQTYUpper,\r\n");
        sql.append("FTotalQTYLower,\r\n");
        sql.append("FTotalBaseQTYLower,\r\n");
        sql.append("FREPReportQTY,\r\n");
        sql.append("FREPReportBaseQTY,\r\n");
        sql.append("FREPMoveInQTY,\r\n");
        sql.append("FREPMoveInBaseQTY,\r\n");
        sql.append("FREPMoveOutQTY,\r\n");
        sql.append("FREPMoveOutBaseQTY,\r\n");
        sql.append("FUnFinishQTY,\r\n");
        sql.append("FUnFinishBaseQTY,\r\n");
        sql.append("FUnMoveOutQTY,\r\n");
        sql.append("FUnMoveOutBaseQTY,\r\n");
        sql.append("FUnTestQTY,\r\n");
        sql.append("FUnTestBaseQTY,\r\n");
        sql.append("FTotalSplitQTY,\r\n");
        sql.append("FTotalSplitBaseQTY,\r\n");
        sql.append("FTotalDispatchQTY,\r\n");
        sql.append("FTotalDispatchBaseQTY,\r\n");
        sql.append("FTotalMaterialScrapQTY,\r\n");
        sql.append("FTotalMaterialScrapBaseQTY,\r\n");
        sql.append("FTotalManufactureScrapQTY,\r\n");
        sql.append("FTotalManufactureScrapBaseQTY,\r\n");
        sql.append("FUnDispatchQTY,\r\n");
        sql.append("FUnDispatchBaseQTY,\r\n");
        sql.append("FConcessionQTY,\r\n");
        sql.append("FConcessionBaseQTY,\r\n");
        sql.append("FTheoreticalLaborCost,\r\n");
        sql.append("FTheoreticalScrapLaborCost,\r\n");
        sql.append("FTheoreticalMATScrapLaborCost,\r\n");
        sql.append("FActualLaborCost,\r\n");
        sql.append("FActualScrapLaborCost,\r\n");
        sql.append("FActualMATScrapLaborCost,\r\n");
        sql.append("FEarlistWOKTime,\r\n");
        sql.append("FEarlistCMPTime,\r\n");
        sql.append("FLastWorkTime,\r\n");
        sql.append("FLastCMPTime,\r\n");
        sql.append("FCreateTime,\r\n");
        sql.append("CFPROInstruction,\r\n");
        sql.append("FOperationRemark,\r\n");
        sql.append("IsNull(FSEQ,0),\r\n");
        sql.append("FTimeUnit,\r\n");
        sql.append("FBaseStatus,\r\n");
        sql.append("CFPERBaseStatus,\r\n");
        sql.append("FOperationNO,\r\n");
        sql.append("FEntrustType,\r\n");
        sql.append("FValuationType,\r\n");
        sql.append("FOverrunMeasure,\r\n");
        sql.append("FIsCheckPoint,\r\n");
        sql.append("FIsReportPoint,\r\n");
        sql.append("FIsPickingPoint,\r\n");
        sql.append("FIsKeyOP,\r\n");
        sql.append("CFIsXOpertion,\r\n");
        sql.append("FIsCanMerge,\r\n");
        sql.append("(select CFGongWei from T_MM_MaterialRWP where fid = ").append(motTempTable).append(".FSourceBillEntryID) CFGongWei,\r\n");
        sql.append(" fopertionPrice\r\n");
        sql.append("From ").append(motTempTable).append("\r\n");
        int effectedRows = this.executeSQL(ctx, sql.toString());
        return effectedRows;
    }

    protected String insertMOTMergeTempTableSQL(String mergeMOTTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(mergeMOTTempTable).append("(\r\n");
        sql.append("FMergeID,\r\n");
        sql.append("FMPSID,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FTraceID,\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FOperationID,\r\n");
        sql.append("FWorkCenterID,\r\n");
        sql.append("FBaseStatus,\r\n");
        sql.append("CFIsXOperation,\r\n");
        sql.append("FEntrustType,\r\n");
        sql.append("FMOTID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertMOTTempTableSQL(Context ctx, String motTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(motTempTable).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FParentID,\r\n");
        sql.append("FWorkCenterID,\r\n");
        sql.append("FStorageORGUnitID,\r\n");
        sql.append("FADMINORGUnitID,\r\n");
        sql.append("FControlStrategyID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FAssistPropertyID,\r\n");
        sql.append("FUnitID,\r\n");
        sql.append("FBaseUnitID,\r\n");
        sql.append("FAssistUnitID,\r\n");
        sql.append("FOperationID,\r\n");
        sql.append("FEntrustSupplierID,\r\n");
        sql.append("FSubRoutingID,\r\n");
        sql.append("FSourceBillEntryID,\r\n");
        sql.append("FMergeID,\r\n");
        sql.append("FQueuingTime,\r\n");
        sql.append("FPrepareTime,\r\n");
        sql.append("FWorkTime,\r\n");
        sql.append("FWaitingTime,\r\n");
        sql.append("FMovingTime,\r\n");
        sql.append("FASSCoefficient,\r\n");
        sql.append("CFFixedWorkingTime,\r\n");
        sql.append("CFTOTFixedWorkTime,\r\n");
        sql.append("FProcessBatch,\r\n");
        sql.append("FAssociateQTY,\r\n");
        sql.append("FQTY,\r\n");
        sql.append("FBaseQTY,\r\n");
        sql.append("FOperQTY,\r\n");
        sql.append("FFinishedQTY,\r\n");
        sql.append("FFinishedBaseQTY,\r\n");
        sql.append("FIntoQTY,\r\n");
        sql.append("FIntoBaseQTY,\r\n");
        sql.append("FOutQTY,\r\n");
        sql.append("FOutBaseQTY,\r\n");
        sql.append("FTestQTY,\r\n");
        sql.append("FTestBaseQTY,\r\n");
        sql.append("FPassQTY,\r\n");
        sql.append("FPassBaseQTY,\r\n");
        sql.append("FScrapQTY,\r\n");
        sql.append("FScrapBaseQTY,\r\n");
        sql.append("FRepairQTY,\r\n");
        sql.append("FRepairBaseQTY,\r\n");
        sql.append("FTotalQTYUpper,\r\n");
        sql.append("FTotalBaseQTYUpper,\r\n");
        sql.append("FTotalQTYLower,\r\n");
        sql.append("FTotalBaseQTYLower,\r\n");
        sql.append("FREPReportQTY,\r\n");
        sql.append("FREPReportBaseQTY,\r\n");
        sql.append("FREPMoveInQTY,\r\n");
        sql.append("FREPMoveInBaseQTY,\r\n");
        sql.append("FREPMoveOutQTY,\r\n");
        sql.append("FREPMoveOutBaseQTY,\r\n");
        sql.append("FUnFinishQTY,\r\n");
        sql.append("FUnFinishBaseQTY,\r\n");
        sql.append("FUnMoveOutQTY,\r\n");
        sql.append("FUnMoveOutBaseQTY,\r\n");
        sql.append("FUnTestQTY,\r\n");
        sql.append("FUnTestBaseQTY,\r\n");
        sql.append("FTotalSplitQTY,\r\n");
        sql.append("FTotalSplitBaseQTY,\r\n");
        sql.append("FTotalDispatchQTY,\r\n");
        sql.append("FTotalDispatchBaseQTY,\r\n");
        sql.append("FTotalMaterialScrapQTY,\r\n");
        sql.append("FTotalMaterialScrapBaseQTY,\r\n");
        sql.append("FTotalManufactureScrapQTY,\r\n");
        sql.append("FTotalManufactureScrapBaseQTY,\r\n");
        sql.append("FUnDispatchQTY,\r\n");
        sql.append("FUnDispatchBaseQTY,\r\n");
        sql.append("FConcessionQTY,\r\n");
        sql.append("FConcessionBaseQTY,\r\n");
        sql.append("FTheoreticalLaborCost,\r\n");
        sql.append("FTheoreticalScrapLaborCost,\r\n");
        sql.append("FTheoreticalMATScrapLaborCost,\r\n");
        sql.append("FActualLaborCost,\r\n");
        sql.append("FActualScrapLaborCost,\r\n");
        sql.append("FActualMATScrapLaborCost,\r\n");
        sql.append("FEarlistWOKTime,\r\n");
        sql.append("FEarlistCMPTime,\r\n");
        sql.append("FLastWorkTime,\r\n");
        sql.append("FLastCMPTime,\r\n");
        sql.append("FCreateTime,\r\n");
        sql.append("CFPROInstruction,\r\n");
        sql.append("FOperationRemark,\r\n");
        sql.append("FSEQ,\r\n");
        sql.append("FTimeUnit,\r\n");
        sql.append("FBaseStatus,\r\n");
        sql.append("CFPERBaseStatus,\r\n");
        sql.append("FOperationNO,\r\n");
        sql.append("FEntrustType,\r\n");
        sql.append("FValuationType,\r\n");
        sql.append("FOverrunMeasure,\r\n");
        sql.append("FIsCheckPoint,\r\n");
        sql.append("FIsReportPoint,\r\n");
        sql.append("FIsPickingPoint,\r\n");
        sql.append("FIsKeyOP,\r\n");
        sql.append("CFIsXOpertion,\r\n");
        sql.append("fopertionPrice\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertNewMOMOTempTableSQL(String newMOMOTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(newMOMOTempTable).append("(\r\n");
        sql.append("FMOID,\r\n");
        sql.append("FMATERIALID,\r\n");
        sql.append("FOPERATIONID,\r\n");
        sql.append("FSUMUNITQTY,\r\n");
        sql.append("FSUMQTY,\r\n");
        sql.append("FSUMPLANNEDQTY\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertNewMOSETempTableSQL(String newMOSETempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(newMOSETempTable).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FPARENTID,\r\n");
        sql.append("FMATERIALID,\r\n");
        sql.append("FREPLACEMATERIALID,\r\n");
        sql.append("FASSISTPROPERTYID,\r\n");
        sql.append("FUNITID,\r\n");
        sql.append("FBASEUNITID,\r\n");
        sql.append("FASSISTUNITID,\r\n");
        sql.append("FREASONCODEID,\r\n");
        sql.append("FWAREHOUSEID,\r\n");
        sql.append("FRECEIPTSTOCKID,\r\n");
        sql.append("FCOMBINATIONSTOCKID,\r\n");
        sql.append("FLOCATIONID,\r\n");
        sql.append("FOPERATIONID,\r\n");
        sql.append("FSTORAGEORGUNITID,\r\n");
        sql.append("FRECEIPTSTROAGEORGUNITID,\r\n");
        sql.append("FWORKCENTERID,\r\n");
        sql.append("FBOMENTRYID,\r\n");
        sql.append("FSOURCEBILLENTRYID,\r\n");
        sql.append("FASSOCIATEQTY,\r\n");
        sql.append("FLOSSRATIO,\r\n");
        sql.append("FEXTRARATIO,\r\n");
        sql.append("FLACKRATIO,\r\n");
        sql.append("FREPLACERATIO,\r\n");
        sql.append("FUNITREPLACEQTY,\r\n");
        sql.append("CFOPENQTY,\r\n");
        sql.append("CFACTMOVEQTY,\r\n");
        sql.append("CFALRMOVEQTY,\r\n");
        sql.append("FQTY,\r\n");
        sql.append("FBASEQTY,\r\n");
        sql.append("FLOSSQTY,\r\n");
        sql.append("FLOSSBASEQTY,\r\n");
        sql.append("FACTISSUEQTY,\r\n");
        sql.append("FACTISSUEBASEQTY,\r\n");
        sql.append("FACTLOSSQTY,\r\n");
        sql.append("FACTLOSSBASEQTY,\r\n");
        sql.append("FREJECTEDQTY,\r\n");
        sql.append("FREJECTEDBASEQTY,\r\n");
        sql.append("FFEEDINGQTY,\r\n");
        sql.append("FFEEDINGBASEQTY,\r\n");
        sql.append("FSCRAPQTY,\r\n");
        sql.append("FSCRAPBASEQTY,\r\n");
        sql.append("FWIPQTY,\r\n");
        sql.append("FWIPBASEQTY,\r\n");
        sql.append("FPLANNEDQTY,\r\n");
        sql.append("FPLANNEDBASEQTY,\r\n");
        sql.append("FUNITQTY,\r\n");
        sql.append("FUNITBASEQTY,\r\n");
        sql.append("FMATERIALSCRAPQTY,\r\n");
        sql.append("FMATERIALSCRAPBASEQTY,\r\n");
        sql.append("FMATERIALFEEDINGQTY,\r\n");
        sql.append("FMATERIALFEEDINGBASEQTY,\r\n");
        sql.append("FUNISSUEQTY,\r\n");
        sql.append("FUNISSUEBASEQTY,\r\n");
        sql.append("FTOSTOREQTY,\r\n");
        sql.append("FTOSTOREBASEQTY,\r\n");
        sql.append("FORIGINALPLANQTY,\r\n");
        sql.append("FORIGINALPLANBASEQTY,\r\n");
        sql.append("FTOTALRECEIPTQTY,\r\n");
        sql.append("FTOTALRECEIPTBASEQTY,\r\n");
        sql.append("FUNRECEIPTQTY,\r\n");
        sql.append("FUNRECEIPTBASEQTY,\r\n");
        sql.append("FTOTALDIRECTRECEIVEQTY,\r\n");
        sql.append("FTOTALDIRECTRECEIVEBASEQTY,\r\n");
        sql.append("FTOTALDSTRANSFERQTY,\r\n");
        sql.append("FTOTALDSTRANSFERBASEQTY,\r\n");
        sql.append("FDEMANDTIME,\r\n");
        sql.append("FACTUEISSUETIME,\r\n");
        sql.append("FBLKSIZE,\r\n");
        sql.append("FSPECIFIEDLENGTH,\r\n");
        sql.append("FASSYLOCATION_L2,\r\n");
        sql.append("FSEQ,\r\n");
        sql.append("FLINESEQ,\r\n");
        sql.append("FBASESTATUS,\r\n");
        sql.append("FMATREPLACETYPE,\r\n");
        sql.append("FTRANSFERTYPE,\r\n");
        sql.append("FPROVIDETYPE,\r\n");
        sql.append("FPICKTYPE,\r\n");
        sql.append("FSCRAPEXPR,\r\n");
        sql.append("FREPLACEGROUPFLAG,\r\n");
        sql.append("FREPLACEPRIORITY,\r\n");
        sql.append("CFMOVESTATUS,\r\n");
        sql.append("FNEWNETWEIGHT,\r\n");
        sql.append("FOPERATIONNO,\r\n");
        sql.append("FISSUEMODE,\r\n");
        sql.append("FISREPLACED,\r\n");
        sql.append("FISBACKFLUSH,\r\n");
        sql.append("FISQTYLIMIT,\r\n");
        sql.append("FISSTOCKALLOT,\r\n");
        sql.append("CFISMUSTREQ,\r\n");
        sql.append("CFISLINESTOREHOUSE,\r\n");
        sql.append("CFISOWNOBJECT\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertPBOMEntryBOMEntryTempTableSQL(String pbomEntryBOMEntryTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(pbomEntryBOMEntryTempTable).append("(\r\n");
        sql.append("FPBOMEntryID,\r\n");
        sql.append("FBOMEntryID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertPTTempTableSQL(String ptTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(ptTempTableName).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FPickType\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertScheduleTempTableSQL(String scheduleTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(scheduleTempTableName).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FLevel,\r\n");
        sql.append("FOperationID,\r\n");
        sql.append("FStartTime,\r\n");
        sql.append("FFinishTime,\r\n");
        sql.append("FCTID,\r\n");
        sql.append("FCTTime,\r\n");
        sql.append("FOperationTime,\r\n");
        sql.append("FTimeUnit\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertTempTableSQL(String tempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(tempTableName).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FParentID,\r\n");
        sql.append("FLevel,\r\n");
        sql.append("FStorageORGUnitID,\r\n");
        sql.append("FReceiveORGUnitID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FUnitID,\r\n");
        sql.append("FBIZTypeID,\r\n");
        sql.append("FTransactionTypeID,\r\n");
        sql.append("FScheduleType,\r\n");
        sql.append("FIsWarehousing,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FTraceID,\r\n");
        sql.append("FEndTraceID,\r\n");
        sql.append("FBOMID,\r\n");
        sql.append("FRoutingID,\r\n");
        sql.append("FADMINORGUnitID,\r\n");
        sql.append("FDispathUserID,\r\n");
        sql.append("FQTY,\r\n");
        sql.append("FStartDate,\r\n");
        sql.append("FFinishDate,\r\n");
        sql.append("FSDFCWorkSeq,\r\n");
        sql.append("FMaterialAttribute,\r\n");
        sql.append("FIsAudit,\r\n");
        sql.append("FCostObjectMOID,\r\n");
        sql.append("FCostObjectID,\r\n");
        sql.append("FSupplyStorageOrgUnitID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertWarehouseTempTableSQL(String warehouseTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(warehouseTempTableName).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FMOStockID,\r\n");
        sql.append("FProvideType,\r\n");
        sql.append("FWarehouseID,\r\n");
        sql.append("FNewWarehouseID,\r\n");
        sql.append("FDefaultWareHouseID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected boolean isExpand(Context ctx, String tempTableName, int level) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("T.FID\r\n");
        sql.append("From " + tempTableName + " T\r\n");
        sql.append("Where\r\n");
        sql.append("T.FLevel=" + level + "\r\n");
        sql.append("And T.FBOMID Is Not Null\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs != null && rs.size() != 0;
    }

    protected void mergeTempTable(Context ctx, Map param) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        int effectedRows = 0;
        sql.setLength(0);
        sql.append("Update ").append(param.get("TempTableName").toString()).append(" UT\r\n");
        sql.append("Set\r\n");
        sql.append("FCostObjectMOID=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("COT.FID\r\n");
        sql.append("From ").append(param.get("TempTableName").toString()).append(" T\r\n");
        sql.append("Inner Join ").append(param.get("TempTableName").toString()).append(" COT On CharIndex(' ' || COT.FID || ' ',T.FParentID)>0\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FID=UT.FID\r\n");
        sql.append("And IsNull(COT.FIsWarehousing,0)=1\r\n");
        sql.append("And IsNull(COT.FDeleted,0)=0\r\n");
        sql.append("And CharIndex(' ' || COT.FID || ' ',T.FParentID)=IsNull((\r\n");
        sql.append("Select\r\n");
        sql.append("Max(CharIndex(' ' || CCOT.FID || ' ',T.FParentID))\r\n");
        sql.append("From ").append(param.get("TempTableName").toString()).append(" CCOT\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And CharIndex(' ' || CCOT.FID || ' ',T.FParentID)>0\r\n");
        sql.append("And IsNull(CCOT.FIsWarehousing,0)=1\r\n");
        sql.append("And IsNull(CCOT.FDeleted,0)=0\r\n");
        sql.append("),0)\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And IsNull(UT.FDeleted,0)=0\r\n");
        sql.append("And IsNull(UT.FIsWarehousing,0)=0\r\n");
        sql.append("And Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From ").append(param.get("TempTableName").toString()).append(" COT\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And COT.FID=UT.FCostObjectMOID\r\n");
        sql.append("And IsNull(COT.FDeleted,0)=1\r\n");
        sql.append(")\r\n");
        effectedRows = this.executeSQL(ctx, sql.toString());
        String mergeIWTempTableName = this.createTempTable(ctx);
        param.put("MergeIWTempTableName", mergeIWTempTableName);
        sql.setLength(0);
        sql.append(this.insertTempTableSQL(mergeIWTempTableName));
        sql.append("Select\r\n");
        sql.append("NewBOSID('12345678'),\r\n");
        sql.append("Max(FParentID),\r\n");
        sql.append("Max(FLevel),\r\n");
        sql.append("FStorageORGUnitID,\r\n");
        sql.append("Max(FReceiveORGUnitID),\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("Max(FUnitID),\r\n");
        sql.append("Max(FBIZTypeID),\r\n");
        sql.append("Max(FTransactionTypeID),\r\n");
        sql.append("Max(FScheduleType),\r\n");
        sql.append("1,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FTraceID,\r\n");
        sql.append("FEndTraceID,\r\n");
        sql.append("FBOMID,\r\n");
        sql.append("Max(FRoutingID),\r\n");
        sql.append("Max(FADMINORGUnitID),\r\n");
        sql.append("Max(FDispathUserID),\r\n");
        sql.append("Sum(IsNull(FQTY,0)),\r\n");
        sql.append("Max(FStartDate),\r\n");
        sql.append("Max(FFinishDate),\r\n");
        sql.append("Max(FSDFCWorkSeq),\r\n");
        sql.append("Max(FMaterialAttribute),\r\n");
        sql.append("Max(FIsAudit),\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Max(FSupplyStorageOrgUnitID)\r\n");
        sql.append("From ").append(param.get("TempTableName").toString()).append("\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And IsNull(FDeleted,0)=0\r\n");
        sql.append("And IsNull(FIsWarehousing,0)=1\r\n");
        sql.append("Group By\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FTraceID,\r\n");
        sql.append("FEndTraceID,\r\n");
        sql.append("FBOMID\r\n");
        sql.append("Having\r\n");
        sql.append("Count(1)>1\r\n");
        effectedRows = this.executeSQL(ctx, sql.toString());
        if (effectedRows >= 0) {
            String mergeIWRelationTempTableName = this.createTempTable(ctx);
            param.put("MergeIWRelationTempTableName", mergeIWRelationTempTableName);
            sql.setLength(0);
            sql.append(this.insertTempTableSQL(mergeIWRelationTempTableName));
            sql.append("Select\r\n");
            sql.append("T.FID,\r\n");
            sql.append("T.FParentID,\r\n");
            sql.append("T.FLevel,\r\n");
            sql.append("T.FStorageORGUnitID,\r\n");
            sql.append("T.FReceiveORGUnitID,\r\n");
            sql.append("T.FMaterialID,\r\n");
            sql.append("T.FUnitID,\r\n");
            sql.append("T.FBIZTypeID,\r\n");
            sql.append("T.FTransactionTypeID,\r\n");
            sql.append("T.FScheduleType,\r\n");
            sql.append("T.FIsWarehousing,\r\n");
            sql.append("T.FProjectID,\r\n");
            sql.append("T.FTraceID,\r\n");
            sql.append("T.FEndTraceID,\r\n");
            sql.append("T.FBOMID,\r\n");
            sql.append("T.FRoutingID,\r\n");
            sql.append("T.FADMINORGUnitID,\r\n");
            sql.append("T.FDispathUserID,\r\n");
            sql.append("T.FQTY,\r\n");
            sql.append("T.FStartDate,\r\n");
            sql.append("T.FFinishDate,\r\n");
            sql.append("T.FSDFCWorkSeq,\r\n");
            sql.append("T.FMaterialAttribute,\r\n");
            sql.append("T.FIsAudit,\r\n");
            sql.append("MT.FID,\r\n");
            sql.append("Null,\r\n");
            sql.append("T.FSupplyStorageOrgUnitID\r\n");
            sql.append("From ").append(mergeIWTempTableName).append(" MT\r\n");
            sql.append("Inner Join ").append(param.get("TempTableName").toString()).append(" T On\r\n");
            sql.append("1=1\r\n");
            sql.append("And MT.FStorageOrgUnitID=T.FStorageOrgUnitID\r\n");
            sql.append("And MT.FMaterialID=T.FMaterialID\r\n");
            sql.append("And MT.FProjectID=T.FProjectID\r\n");
            sql.append("And MT.FTraceID=T.FTraceID\r\n");
            sql.append("And MT.FBOMID=T.FBOMID\r\n");
            sql.append("And IsNull(MT.FDeleted,0)=0\r\n");
            effectedRows = this.executeSQL(ctx, sql.toString());
            if (effectedRows >= 0) {
                sql.setLength(0);
                sql.append("Update ").append(param.get("TempTableName").toString()).append(" UT\r\n");
                sql.append("Set\r\n");
                sql.append("FCostObjectMOID=(\r\n");
                sql.append("Select\r\n");
                sql.append("Top 1\r\n");
                sql.append("MRT.FCostObjectMOID\r\n");
                sql.append("From ").append(mergeIWRelationTempTableName).append(" MRT\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And MRT.FID=UT.FCostObjectMOID\r\n");
                sql.append(")\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And IsNull(UT.FDeleted,0)=0\r\n");
                sql.append("And Exists(\r\n");
                sql.append("Select\r\n");
                sql.append("1\r\n");
                sql.append("From ").append(mergeIWRelationTempTableName).append(" MRT\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And MRT.FID=UT.FCostObjectMOID\r\n");
                sql.append(")\r\n");
                effectedRows = this.executeSQL(ctx, sql.toString());
            }
        }
        String mergeTempTableName = this.createTempTable(ctx);
        param.put("MergeTempTableName", mergeTempTableName);
        sql.setLength(0);
        sql.append(this.insertTempTableSQL(mergeTempTableName));
        sql.append("Select\r\n");
        sql.append("Case IsNull(Max(FIsWarehousing),0)\r\n");
        sql.append("When 1 Then Max(FCostObjectMOID)\r\n");
        sql.append("Else NewBOSID('12345678')\r\n");
        sql.append("End,\r\n");
        sql.append("Max(FParentID),\r\n");
        sql.append("Max(FLevel),\r\n");
        sql.append("FStorageORGUnitID,\r\n");
        sql.append("Max(FReceiveORGUnitID),\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("Max(FUnitID),\r\n");
        sql.append("Max(FBIZTypeID),\r\n");
        sql.append("Max(FTransactionTypeID),\r\n");
        sql.append("Max(FScheduleType),\r\n");
        sql.append("Max(FIsWarehousing),\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FTraceID,\r\n");
        sql.append("FEndTraceID,\r\n");
        sql.append("FBOMID,\r\n");
        sql.append("Max(FRoutingID),\r\n");
        sql.append("Max(FADMINORGUnitID),\r\n");
        sql.append("Max(FDispathUserID),\r\n");
        sql.append("Sum(IsNull(FQTY,0)),\r\n");
        sql.append("Max(FStartDate),\r\n");
        sql.append("Max(FFinishDate),\r\n");
        sql.append("Max(FSDFCWorkSeq),\r\n");
        sql.append("Max(FMaterialAttribute),\r\n");
        sql.append("Max(FIsAudit),\r\n");
        sql.append("Max(FCostObjectMOID),\r\n");
        sql.append("Null,\r\n");
        sql.append("Max(FSupplyStorageOrgUnitID)\r\n");
        sql.append("From ").append(param.get("TempTableName").toString()).append("\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And IsNull(FDeleted,0)=0\r\n");
        sql.append("Group By\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FTraceID,\r\n");
        sql.append("FEndTraceID,\r\n");
        sql.append("FBOMID\r\n");
        effectedRows = this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(mergeTempTableName).append(" UT\r\n");
        sql.append("Set\r\n");
        sql.append("FCostObjectID=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("MO.FCostObjectID\r\n");
        sql.append("From T_MM_ManufactureOrder MO\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FSourceBillID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And MO.FStorageOrgUnitID=UT.FStorageOrgUnitID\r\n");
        sql.append("And MO.FMaterialID=UT.FMaterialID\r\n");
        sql.append("And MO.FProjectID=UT.FProjectID\r\n");
        sql.append("And MO.FTrackID=UT.FTraceID\r\n");
        sql.append("And MO.FBOMID=UT.FBOMID\r\n");
        sql.append("And IsNull(MO.CFIsWarehouse,0)=1\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And IsNull(UT.FIsWarehousing,0)=1\r\n");
        effectedRows = this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(mergeTempTableName).append(" UT\r\n");
        sql.append("Set\r\n");
        sql.append("FCostObjectID=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("COT.FCostObjectID\r\n");
        sql.append("From ").append(mergeTempTableName).append(" COT\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And COT.FID=UT.FCostObjectMOID\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And IsNull(UT.FIsWarehousing,0)=0\r\n");
        effectedRows = this.executeSQL(ctx, sql.toString());
        this.removeTempTableInvalidData(ctx, mergeTempTableName);
        this.updateTempTableQTY(ctx, param);
        this.removeTempTableInvalidData(ctx, mergeTempTableName);
    }

    protected void motTransferOpenItem(Context ctx, Map param) throws BOSException, EASBizException {
        String motTempTable;
        if (ctx == null || param == null) {
            return;
        }
        String string = param == null ? null : (param.containsKey("MOTTempTableName") ? (param.get("MOTTempTableName") == null ? null : param.get("MOTTempTableName").toString()) : (motTempTable = null));
        if (motTempTable == null) {
            return;
        }
        HashMap<String, String> motTransferOpenItemparam = new HashMap<String, String>();
        motTransferOpenItemparam.put("TempTable", motTempTable);
        motTransferOpenItemparam.put("Type", "Auto");
        ManufactureOrderFacadeFactory.getLocalInstance(ctx).transferOpenItem(motTransferOpenItemparam);
    }

    protected void orsSchedule(Context ctx, Map param) throws BOSException, EASBizException {
        if (!param.containsKey("ORSIDList") || param.get("ORSIDList") == null || !ArrayList.class.getName().equals(param.get("ORSIDList").getClass().getName())) {
            return;
        }
        ArrayList orsIDList = (ArrayList)param.get("ORSIDList");
        if (orsIDList.size() == 0) {
            return;
        }
        Map ctMaps = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(this.insertScheduleTempTableSQL(param.get("ScheduleTempTableName").toString()));
        if (ScheduleTypeEnum.SF.getAlias().equals(param.get("ScheduleType").toString())) {
            sql.append("Select\r\n");
            sql.append("NewBOSID('12345678') \"FID\",\r\n");
            sql.append("0 \"FLevel\",\r\n");
            sql.append("R.FOperationID \"FOperationID\",\r\n");
            sql.append("R.FStartTime \"FStartTime\",\r\n");
            sql.append("R.FFinishTime \"FFinishTime\",\r\n");
            sql.append("R.FCTID \"FCTID\",\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("MIN(CTE.FStartTime)\r\n");
            sql.append("From T_MM_ClassTeamEntry CTE\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And CTE.FParentID=R.FCTID\r\n");
            sql.append(") \"FCTTime\",\r\n");
            sql.append("R.FOperationTime \"FOperationTime\",\r\n");
            sql.append("R.FTimeUnit \"FTimeUnit\"\r\n");
            sql.append("From\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("ORSER.FOperationID \"FOperationID\",\r\n");
            sql.append("MPS.CFStartTime \"FStartTime\",\r\n");
            sql.append("MPS.CFFinishTime \"FFinishTime\",\r\n");
            sql.append("Case\r\n");
            sql.append("When WC.FClassTeamID Is Null Then DCT.FID\r\n");
            sql.append("Else WC.FClassTeamID\r\n");
            sql.append("End \"FCTID\",\r\n");
            sql.append("IsNull(ORSER.FOperationTime,0) \"FOperationTime\",\r\n");
            sql.append("ORSER.FTimeUnit \"FTimeUnit\"\r\n");
            sql.append("From\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("ORSE.CFOperationID \"FOperationID\",\r\n");
            sql.append("ORSOPE.CFProcessTime \"FOperationTime\",\r\n");
            sql.append("ORSOPE.CFTimeUnit \"FTimeUnit\"\r\n");
            sql.append("From CT_BAS_OperationRSE ORSE\r\n");
            sql.append("Left Join CT_BAS_OperationRSOPE ORSOPE On ORSOPE.CFOperationID=ORSE.CFOperationID\r\n");
            sql.append("And ORSOPE.FParentID=ORSE.FParentID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And ORSE.FParentID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])orsIDList.toArray()));
            sql.append(")\r\n");
            sql.append("And IsNull(ORSE.CFOperationID,'Null')<>IsNull(ORSE.CFNextOperationID,'Null')\r\n");
            sql.append("And (\r\n");
            sql.append("Not Exists (\r\n");
            sql.append("Select\r\n");
            sql.append("1\r\n");
            sql.append("From CT_BAS_OperationRSE CORSE\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And CORSE.FParentID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])orsIDList.toArray()));
            sql.append(")\r\n");
            sql.append("And CORSE.CFNextOperationID=ORSE.CFOperationID\r\n");
            sql.append(")\r\n");
            sql.append(")\r\n");
            sql.append("Group By\r\n");
            sql.append("ORSE.CFOperationID,\r\n");
            sql.append("ORSOPE.CFProcessTime,\r\n");
            sql.append("ORSOPE.CFTimeUnit\r\n");
            sql.append(") ORSER\r\n");
            sql.append("Inner Join CT_PS_MasterProductionSchedule MPS On MPS.FID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
            sql.append("Inner Join T_MM_Operation OPER On OPER.FID=ORSER.FOperationID\r\n");
            sql.append("Left Join T_MM_WorkCenter WC On WC.FID=OPER.FWorkCenterID\r\n");
            sql.append("Left Join T_MM_ClassTeam DCT On\r\n");
            sql.append("DCT.FStorageOrgUnitID=MPS.CFStorageORGUnitID\r\n");
            sql.append("And DCT.FStatus=").append(20).append("\r\n");
            sql.append("And DCT.FIsDefault=1\r\n");
            sql.append(") R\r\n");
        } else if (ScheduleTypeEnum.FS.getAlias().equals(param.get("ScheduleType").toString())) {
            sql.append("Select\r\n");
            sql.append("NewBOSID('12345678') \"FID\",\r\n");
            sql.append("0 \"FLevel\",\r\n");
            sql.append("R.FOperationID \"FOperationID\",\r\n");
            sql.append("R.FStartTime \"FStartTime\",\r\n");
            sql.append("R.FFinishTime \"FFinishTime\",\r\n");
            sql.append("R.FCTID \"FCTID\",\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("MAX(CTE.FEndTime)\r\n");
            sql.append("From T_MM_ClassTeamEntry CTE\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And CTE.FParentID=R.FCTID\r\n");
            sql.append(") \"FCTTime\",\r\n");
            sql.append("R.FOperationTime \"FOperationTime\",\r\n");
            sql.append("R.FTimeUnit \"FTimeUnit\"\r\n");
            sql.append("From\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("ORSER.FOperationID \"FOperationID\",\r\n");
            sql.append("MPS.CFStartTime \"FStartTime\",\r\n");
            sql.append("MPS.CFFinishTime \"FFinishTime\",\r\n");
            sql.append("Case\r\n");
            sql.append("When WC.FClassTeamID Is Null Then DCT.FID\r\n");
            sql.append("Else WC.FClassTeamID\r\n");
            sql.append("End \"FCTID\",\r\n");
            sql.append("IsNull(ORSER.FOperationTime,0) \"FOperationTime\",\r\n");
            sql.append("ORSER.FTimeUnit \"FTimeUnit\"\r\n");
            sql.append("From\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("ORSE.CFNextOperationID \"FOperationID\",\r\n");
            sql.append("ORSOPE.CFProcessTime \"FOperationTime\",\r\n");
            sql.append("ORSOPE.CFTimeUnit \"FTimeUnit\"\r\n");
            sql.append("From CT_BAS_OperationRSE ORSE\r\n");
            sql.append("Left Join CT_BAS_OperationRSOPE ORSOPE On ORSOPE.CFOperationID=ORSE.CFNextOperationID\r\n");
            sql.append("And ORSOPE.FParentID=ORSE.FParentID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And ORSE.FParentID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])orsIDList.toArray()));
            sql.append(")\r\n");
            sql.append("And IsNull(ORSE.CFOperationID,'Null')<>IsNull(ORSE.CFNextOperationID,'Null')\r\n");
            sql.append("And (\r\n");
            sql.append("Not Exists (\r\n");
            sql.append("Select\r\n");
            sql.append("1\r\n");
            sql.append("From CT_BAS_OperationRSE CORSE\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And CORSE.FParentID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])orsIDList.toArray()));
            sql.append(")\r\n");
            sql.append("And CORSE.CFOperationID=ORSE.CFNextOperationID\r\n");
            sql.append(")\r\n");
            sql.append(")\r\n");
            sql.append("Group By\r\n");
            sql.append("ORSE.CFNextOperationID,\r\n");
            sql.append("ORSOPE.CFProcessTime,\r\n");
            sql.append("ORSOPE.CFTimeUnit\r\n");
            sql.append(") ORSER\r\n");
            sql.append("Inner Join CT_PS_MasterProductionSchedule MPS On MPS.FID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
            sql.append("Inner Join T_MM_Operation OPER On OPER.FID=ORSER.FOperationID\r\n");
            sql.append("Left Join T_MM_WorkCenter WC On WC.FID=OPER.FWorkCenterID\r\n");
            sql.append("Left Join T_MM_ClassTeam DCT On\r\n");
            sql.append("DCT.FStorageOrgUnitID=MPS.CFStorageORGUnitID\r\n");
            sql.append("And DCT.FStatus=").append(20).append("\r\n");
            sql.append("And DCT.FIsDefault=1\r\n");
            sql.append(") R\r\n");
        }
        int insertRows = this.executeSQL(ctx, sql.toString());
        if (insertRows <= 0) {
            return;
        }
        int level = 0;
        IRowSet rs = null;
        while (insertRows > 0) {
            insertRows = 0;
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("FID,\r\n");
            sql.append("FLevel,\r\n");
            sql.append("FOperationID,\r\n");
            sql.append("FStartTime,\r\n");
            sql.append("FFinishTime,\r\n");
            sql.append("FCTID,\r\n");
            sql.append("FCTTime,\r\n");
            sql.append("FOperationTime,\r\n");
            sql.append("FTimeUnit\r\n");
            sql.append("From ").append(param.get("ScheduleTempTableName").toString()).append("\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And FLevel=").append(level).append("\r\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null && rs.size() > 0) {
                try {
                    while (rs.next()) {
                        String id = rs.getString("FID");
                        String operationID = rs.getString("FOperationID");
                        Timestamp startTime = rs.getTimestamp("FStartTime");
                        Timestamp finishTime = rs.getTimestamp("FFinishTime");
                        String ctID = rs.getString("FCTID");
                        Timestamp ctTime = rs.getTimestamp("FCTTime");
                        BigDecimal operationTime = rs.getBigDecimal("FOperationTime") == null ? BigDecimal.ZERO : rs.getBigDecimal("FOperationTime");
                        int timeUnit = rs.getInt("FTimeUnit");
                        if (id == null || id.trim().length() == 0 || operationID == null || operationID.trim().length() == 0 || ctID == null || ctID.trim().length() == 0 || ScheduleTypeEnum.SF.getAlias().equals(param.get("ScheduleType").toString()) && (startTime == null || startTime.toString().trim().length() == 0) || ScheduleTypeEnum.FS.getAlias().equals(param.get("ScheduleType").toString()) && (finishTime == null || finishTime.toString().trim().length() == 0) || timeUnit != 2 && timeUnit != 3 && timeUnit != 4) continue;
                        switch (timeUnit) {
                            case 2: {
                                operationTime = operationTime.multiply(new BigDecimal(3600000));
                                break;
                            }
                            case 3: {
                                operationTime = operationTime.multiply(new BigDecimal(60000));
                                break;
                            }
                            case 4: {
                                operationTime = operationTime.multiply(new BigDecimal(1000));
                            }
                        }
                        ctMaps = OperationScheduleUtils.reloadCT(ctx, ctID, ctMaps);
                        if (ScheduleTypeEnum.SF.getAlias().equals(param.get("ScheduleType").toString())) {
                            if (ctTime != null) {
                                startTime.setTime(OperationScheduleUtils.sdfDateTime.parse(OperationScheduleUtils.sdfDate.format(startTime) + " " + OperationScheduleUtils.sdfTime.format(ctTime)).getTime());
                            }
                            finishTime = (finishTime = OperationScheduleUtils.getScheduleTime(ctx, startTime = OperationScheduleUtils.timeUpdate(ctx, startTime, 0, ctID, param.get("FactoryCalendarID").toString(), ctMaps), operationTime.longValue(), ctID, param.get("FactoryCalendarID").toString(), ctMaps)).compareTo(startTime) == 0 ? finishTime : OperationScheduleUtils.timeUpdate(ctx, finishTime, 1, ctID, param.get("FactoryCalendarID").toString(), ctMaps);
                        } else if (ScheduleTypeEnum.FS.getAlias().equals(param.get("ScheduleType").toString())) {
                            if (ctTime != null) {
                                finishTime.setTime(OperationScheduleUtils.sdfDateTime.parse(OperationScheduleUtils.sdfDate.format(finishTime) + " " + OperationScheduleUtils.sdfTime.format(ctTime)).getTime());
                            }
                            startTime = (startTime = OperationScheduleUtils.getScheduleTime(ctx, finishTime = OperationScheduleUtils.timeUpdate(ctx, finishTime, 1, ctID, param.get("FactoryCalendarID").toString(), ctMaps), operationTime.longValue() * -1L, ctID, param.get("FactoryCalendarID").toString(), ctMaps)).compareTo(finishTime) == 0 ? startTime : OperationScheduleUtils.timeUpdate(ctx, startTime, 0, ctID, param.get("FactoryCalendarID").toString(), ctMaps);
                        }
                        sql.setLength(0);
                        sql.append("Update ").append(param.get("ScheduleTempTableName").toString()).append("\r\n");
                        sql.append("Set\r\n");
                        sql.append("FStartTime=To_Date('").append(OperationScheduleUtils.sdfDateTime.format(startTime)).append("'),\r\n");
                        sql.append("FFinishTime=To_Date('").append(OperationScheduleUtils.sdfDateTime.format(finishTime)).append("')\r\n");
                        sql.append("Where\r\n");
                        sql.append("FID='").append(id).append("'\r\n");
                        sql.append("And FLevel=").append(level).append("\r\n");
                        this.executeSQL(ctx, sql.toString());
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (ParseException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            sql.setLength(0);
            sql.setLength(0);
            sql.append(this.insertScheduleTempTableSQL(param.get("ScheduleTempTableName").toString()));
            if (ScheduleTypeEnum.SF.getAlias().equals(param.get("ScheduleType").toString())) {
                sql.append("Select\r\n");
                sql.append("NewBOSID('12345678') \"FID\",\r\n");
                sql.append(level + 1).append(" \"FLevel\",\r\n");
                sql.append("ORSER.FOperationID \"FOperationID\",\r\n");
                sql.append("(\r\n");
                sql.append("Select\r\n");
                sql.append("Max(CT.FFinishTime)\r\n");
                sql.append("From ").append(param.get("ScheduleTempTableName").toString()).append(" CT\r\n");
                sql.append("Inner Join CT_BAS_OperationRSE CORSE On\r\n");
                sql.append("1=1\r\n");
                sql.append("And CORSE.FParentID In (\r\n");
                sql.append(SQLUtil.arrayToString((Object[])orsIDList.toArray()));
                sql.append(")\r\n");
                sql.append("And CORSE.CFOperationID=CT.FOperationID\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And CT.FLevel=").append(level).append("\r\n");
                sql.append("And CORSE.CFNextOperationID=ORSER.FOperationID\r\n");
                sql.append(") \"FStartTime\",\r\n");
                sql.append("Null \"FFinishTime\",\r\n");
                sql.append("Case\r\n");
                sql.append("When WC.FClassTeamID Is Null Then DCT.FID\r\n");
                sql.append("Else WC.FClassTeamID\r\n");
                sql.append("End \"FCTID\",\r\n");
                sql.append("Null \"FCTTime\",\r\n");
                sql.append("IsNull(ORSER.FOperationTime,0) \"FOperationTime\",\r\n");
                sql.append("ORSER.FTimeUnit \"FTimeUnit\"\r\n");
                sql.append("From\r\n");
                sql.append("(\r\n");
                sql.append("Select\r\n");
                sql.append("ORSE.CFNextOperationID \"FOperationID\",\r\n");
                sql.append("ORSOPE.CFProcessTime \"FOperationTime\",\r\n");
                sql.append("ORSOPE.CFTimeUnit \"FTimeUnit\"\r\n");
                sql.append("From CT_BAS_OperationRSE ORSE\r\n");
                sql.append("Inner Join ").append(param.get("ScheduleTempTableName").toString()).append(" T On\r\n");
                sql.append("1=1\r\n");
                sql.append("And ORSE.CFOperationID=T.FOperationID\r\n");
                sql.append("And ORSE.FParentID In (\r\n");
                sql.append(SQLUtil.arrayToString((Object[])orsIDList.toArray()));
                sql.append(")\r\n");
                sql.append("Left Join CT_BAS_OperationRSOPE ORSOPE On ORSOPE.CFOperationID=ORSE.CFNextOperationID\r\n");
                sql.append("And ORSOPE.FParentID=ORSE.FParentID\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And T.FLevel=").append(level).append("\r\n");
                sql.append("And IsNull(ORSE.CFOperationID,'Null')<>IsNull(ORSE.CFNextOperationID,'Null')\r\n");
                sql.append("Group By\r\n");
                sql.append("ORSE.CFNextOperationID,\r\n");
                sql.append("ORSOPE.CFProcessTime,\r\n");
                sql.append("ORSOPE.CFTimeUnit\r\n");
                sql.append(") ORSER\r\n");
                sql.append("Inner Join CT_PS_MasterProductionSchedule MPS On MPS.FID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
                sql.append("Left Join T_MM_Operation OPER On OPER.FID=ORSER.FOperationID\r\n");
                sql.append("Left Join T_MM_WorkCenter WC On WC.FID=OPER.FWorkCenterID\r\n");
                sql.append("Left Join T_MM_ClassTeam DCT On\r\n");
                sql.append("DCT.FStorageOrgUnitID=MPS.CFStorageORGUnitID\r\n");
                sql.append("And DCT.FStatus=").append(20).append("\r\n");
                sql.append("And DCT.FIsDefault=1\r\n");
            } else if (ScheduleTypeEnum.FS.getAlias().equals(param.get("ScheduleType").toString())) {
                sql.append("Select\r\n");
                sql.append("NewBOSID('12345678') \"FID\",\r\n");
                sql.append(level + 1).append(" \"FLevel\",\r\n");
                sql.append("ORSER.FOperationID \"FOperationID\",\r\n");
                sql.append("Null \"FStartTime\",\r\n");
                sql.append("(\r\n");
                sql.append("Select\r\n");
                sql.append("Min(CT.FStartTime)\r\n");
                sql.append("From ").append(param.get("ScheduleTempTableName").toString()).append(" CT\r\n");
                sql.append("Inner Join CT_BAS_OperationRSE CORSE On\r\n");
                sql.append("1=1\r\n");
                sql.append("And CORSE.FParentID In (\r\n");
                sql.append(SQLUtil.arrayToString((Object[])orsIDList.toArray()));
                sql.append(")\r\n");
                sql.append("And CORSE.CFNextOperationID=CT.FOperationID\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And CT.FLevel=").append(level).append("\r\n");
                sql.append("And CORSE.CFOperationID=ORSER.FOperationID\r\n");
                sql.append(") \"FFinishTime\",\r\n");
                sql.append("Case\r\n");
                sql.append("When WC.FClassTeamID Is Null Then DCT.FID\r\n");
                sql.append("Else WC.FClassTeamID\r\n");
                sql.append("End \"FCTID\",\r\n");
                sql.append("Null \"FCTTime\",\r\n");
                sql.append("IsNull(ORSER.FOperationTime,0) \"FOperationTime\",\r\n");
                sql.append("ORSER.FTimeUnit \"FTimeUnit\"\r\n");
                sql.append("From\r\n");
                sql.append("(\r\n");
                sql.append("Select\r\n");
                sql.append("ORSE.CFOperationID \"FOperationID\",\r\n");
                sql.append("ORSOPE.CFProcessTime \"FOperationTime\",\r\n");
                sql.append("ORSOPE.CFTimeUnit \"FTimeUnit\"\r\n");
                sql.append("From CT_BAS_OperationRSE ORSE\r\n");
                sql.append("Inner Join ").append(param.get("ScheduleTempTableName").toString()).append(" T On\r\n");
                sql.append("1=1\r\n");
                sql.append("And ORSE.CFNextOperationID=T.FOperationID\r\n");
                sql.append("And ORSE.FParentID In (\r\n");
                sql.append(SQLUtil.arrayToString((Object[])orsIDList.toArray()));
                sql.append(")\r\n");
                sql.append("Left Join CT_BAS_OperationRSOPE ORSOPE On ORSOPE.CFOperationID=ORSE.CFOperationID\r\n");
                sql.append("And ORSOPE.FParentID=ORSE.FParentID\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And T.FLevel=").append(level).append("\r\n");
                sql.append("And IsNull(ORSE.CFOperationID,'Null')<>IsNull(ORSE.CFNextOperationID,'Null')\r\n");
                sql.append("Group By\r\n");
                sql.append("ORSE.CFOperationID,\r\n");
                sql.append("ORSOPE.CFProcessTime,\r\n");
                sql.append("ORSOPE.CFTimeUnit\r\n");
                sql.append(") ORSER\r\n");
                sql.append("Inner Join CT_PS_MasterProductionSchedule MPS On MPS.FID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
                sql.append("Left Join T_MM_Operation OPER On OPER.FID=ORSER.FOperationID\r\n");
                sql.append("Left Join T_MM_WorkCenter WC On WC.FID=OPER.FWorkCenterID\r\n");
                sql.append("Left Join T_MM_ClassTeam DCT On\r\n");
                sql.append("DCT.FStorageOrgUnitID=MPS.CFStorageORGUnitID\r\n");
                sql.append("And DCT.FStatus=").append(20).append("\r\n");
                sql.append("And DCT.FIsDefault=1\r\n");
            }
            insertRows = this.executeSQL(ctx, sql.toString());
            ++level;
        }
    }

    protected void processChangeVersion(Context ctx, Map param) throws BOSException, EASBizException {
        String mpsID;
        List newMOIDList;
        if (ctx == null || param == null) {
            return;
        }
        if (param.size() == 0) {
            return;
        }
        List list = param.containsKey("NewMOIDList") ? (param.get("NewMOIDList") == null ? null : (param.get("NewMOIDList") instanceof List ? (List)param.get("NewMOIDList") : null)) : (newMOIDList = null);
        String string = param.containsKey("MasterProductionScheduleID") ? (param.get("MasterProductionScheduleID") == null ? null : param.get("MasterProductionScheduleID").toString()) : (mpsID = null);
        if (newMOIDList == null || mpsID == null) {
            return;
        }
        if (newMOIDList.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        HashMap<String, String> afterChangeVersionMOMap = new HashMap<String, String>();
        HashMap beforeChangeVersionMOMap = new HashMap();
        ArrayList<String> afterChangeVersionMOIDList = new ArrayList<String>();
        ArrayList<String> changeVersionIDList = new ArrayList<String>();
        ArrayList beforeChangeVersionMOIDList = new ArrayList();
        ArrayList<String> deleteMOIDList = new ArrayList<String>();
        ArrayList<String> deleteMRBIDList = new ArrayList<String>();
        ArrayList<String> updateMOIDList = new ArrayList<String>();
        FilterInfo deleteFilterInfo = new FilterInfo();
        try {
            ArrayList<String> beforeMOIDList;
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("MO.FID FAfterMOID,\r\n");
            sql.append("CV.FID FChangeVersionID,\r\n");
            sql.append("SMO.FID FBeforeMOID\r\n");
            sql.append("From T_MM_ManufactureOrder MO\r\n");
            sql.append("Inner Join T_MM_TrackNumber MOTN On MOTN.FID=MO.FTrackID\r\n");
            sql.append("Inner Join CT_BAS_ChangeVersion CV On\r\n");
            sql.append("1=1\r\n");
            sql.append("And CV.CFProjectID=MO.FProjectID\r\n");
            sql.append("And CV.CFAfterMaterialID=MO.FMaterialID\r\n");
            sql.append("Inner Join T_MM_TrackNumber STN On STN.FID=CV.CFStartTrackNumberID\r\n");
            sql.append("Inner Join T_MM_TrackNumber ETN On ETN.FID=CV.CFEndTrackNumberID\r\n");
            sql.append("Inner Join T_MM_ManufactureOrder SMO On\r\n");
            sql.append("1=1\r\n");
            sql.append("And SMO.FMPSID=MO.FMPSID\r\n");
            sql.append("And SMO.FProjectID=CV.CFProjectID\r\n");
            sql.append("And SMO.FMaterialID=CV.CFBeforeMaterialID\r\n");
            sql.append("Inner Join T_MM_TrackNumber SMOTN On SMOTN.FID=SMO.FTrackID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MO.FID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])newMOIDList.toArray()));
            sql.append(")\r\n");
            sql.append("And IsNull(MOTN.FNumber,'Null')>=IsNull(STN.FNumber,'Null')\r\n");
            sql.append("And IsNull(MOTN.FNumber,'Null')<=IsNull(ETN.FNumber,'Null')\r\n");
            sql.append("And IsNull(SMOTN.FNumber,'Null')>=IsNull(STN.FNumber,'Null')\r\n");
            sql.append("And IsNull(SMOTN.FNumber,'Null')<=IsNull(ETN.FNumber,'Null')\r\n");
            sql.append("Order By\r\n");
            sql.append("MO.FID Asc,\r\n");
            sql.append("CV.FCreateTime Desc,\r\n");
            sql.append("CV.FID Asc\r\n");
            IRowSet changeVersionBaseRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (changeVersionBaseRowSet == null) {
                return;
            }
            if (changeVersionBaseRowSet.size() == 0) {
                return;
            }
            while (changeVersionBaseRowSet.next()) {
                String afterMOID = changeVersionBaseRowSet.getString("FAfterMOID");
                String changeVersionID = changeVersionBaseRowSet.getString("FChangeVersionID");
                String beforeMOID = changeVersionBaseRowSet.getString("FBeforeMOID");
                if (afterMOID == null || changeVersionID == null || beforeMOID == null || afterMOID.trim().length() == 0 || changeVersionID.trim().length() == 0 || beforeMOID.trim().length() == 0 || newMOIDList.contains(beforeMOID)) continue;
                afterChangeVersionMOMap.put(afterMOID, changeVersionID);
                if (!afterChangeVersionMOIDList.contains(afterMOID)) {
                    afterChangeVersionMOIDList.add(afterMOID);
                }
                beforeMOIDList = beforeChangeVersionMOMap.containsKey(afterMOID + changeVersionID) ? (beforeChangeVersionMOMap.get(afterMOID + changeVersionID) == null ? new ArrayList<String>() : (beforeChangeVersionMOMap.get(afterMOID + changeVersionID) instanceof List ? (List)beforeChangeVersionMOMap.get(afterMOID + changeVersionID) : new ArrayList<String>())) : new ArrayList<String>();
                beforeMOIDList.add(beforeMOID);
                beforeChangeVersionMOMap.put(afterMOID + changeVersionID, beforeMOIDList);
            }
            if (afterChangeVersionMOIDList.size() == 0) {
                return;
            }
            for (int index = 0; index < afterChangeVersionMOIDList.size(); ++index) {
                String changeVersionID;
                String afterMOID;
                String string2 = afterMOID = afterChangeVersionMOIDList.get(index) == null ? null : afterChangeVersionMOIDList.get(index).toString();
                if (afterMOID == null || afterMOID.trim().length() == 0) continue;
                String string3 = afterChangeVersionMOMap.containsKey(afterMOID) ? (afterChangeVersionMOMap.get(afterMOID) == null ? null : afterChangeVersionMOMap.get(afterMOID).toString()) : (changeVersionID = null);
                if (changeVersionID == null || changeVersionID.trim().length() == 0) continue;
                if (!changeVersionIDList.contains(changeVersionID)) {
                    changeVersionIDList.add(changeVersionID);
                }
                Object object = beforeChangeVersionMOMap.containsKey(afterMOID + changeVersionID) ? (beforeChangeVersionMOMap.get(afterMOID + changeVersionID) == null ? null : (beforeChangeVersionMOMap.get(afterMOID + changeVersionID) instanceof List ? (List)beforeChangeVersionMOMap.get(afterMOID + changeVersionID) : null)) : (beforeMOIDList = null);
                if (beforeMOIDList == null || beforeMOIDList.size() == 0) continue;
                beforeChangeVersionMOIDList.addAll(beforeMOIDList);
            }
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("MO.FID FID\r\n");
            sql.append("From T_MM_ManufactureOrder MO\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MO.FID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])beforeChangeVersionMOIDList.toArray()));
            sql.append(")\r\n");
            sql.append("And IsNull(MO.FBaseStatus,0)<=").append(5).append("\r\n");
            sql.append("And Not Exists (\r\n");
            sql.append("Select\r\n");
            sql.append("1\r\n");
            sql.append("From T_MM_MFTOrderTechnics MOT\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MOT.FParentID=MO.FID\r\n");
            sql.append("And IsNull(MOT.FBaseStatus,0)>").append(5).append("\r\n");
            sql.append(")\r\n");
            sql.append("And Not Exists(\r\n");
            sql.append("Select\r\n");
            sql.append("1\r\n");
            sql.append("From T_IM_MaterialReqBill MRB\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And IsNull(MRB.FBaseStatus,0)>=").append(4).append("\r\n");
            sql.append("And MRB.FSourceBillID=MO.FID\r\n");
            sql.append(")\r\n");
            IRowSet deleteMORowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (deleteMORowSet != null && deleteMORowSet.size() > 0) {
                while (deleteMORowSet.next()) {
                    String id = deleteMORowSet.getString("FID");
                    if (id == null || id.trim().length() == 0 || deleteMOIDList.contains(id)) continue;
                    deleteMOIDList.add(id);
                }
            }
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("MRB.FID FID\r\n");
            sql.append("From T_IM_MaterialReqBill MRB\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And IsNull(MRB.FBaseStatus,0)<").append(4).append("\r\n");
            sql.append("And MRB.FSourceBillID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])deleteMOIDList.toArray()));
            sql.append(")\r\n");
            IRowSet deleteMRBRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (deleteMRBRowSet != null && deleteMRBRowSet.size() > 0) {
                while (deleteMRBRowSet.next()) {
                    String id = deleteMRBRowSet.getString("FID");
                    if (id == null || id.trim().length() == 0 || deleteMRBIDList.contains(id)) continue;
                    deleteMRBIDList.add(id);
                }
            }
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("MO.FID FID\r\n");
            sql.append("From T_MM_ManufactureOrder MO\r\n");
            sql.append("Inner Join T_MM_TrackNumber MOTN On MOTN.FID=MO.FTrackID\r\n");
            sql.append("Inner Join CT_BAS_ChangeVersion CV On\r\n");
            sql.append("1=1\r\n");
            sql.append("And CV.CFProjectID=MO.FProjectID\r\n");
            sql.append("And CV.CFAfterMaterialID=MO.FMaterialID\r\n");
            sql.append("Inner Join T_MM_TrackNumber STN On STN.FID=CV.CFStartTrackNumberID\r\n");
            sql.append("Inner Join T_MM_TrackNumber ETN On ETN.FID=CV.CFEndTrackNumberID\r\n");
            sql.append("Inner Join T_MM_ManufactureOrder SMO On\r\n");
            sql.append("1=1\r\n");
            sql.append("And SMO.FMPSID=MO.FMPSID\r\n");
            sql.append("And SMO.FProjectID=CV.CFProjectID\r\n");
            sql.append("And SMO.FMaterialID=CV.CFBeforeMaterialID\r\n");
            sql.append("Inner Join T_MM_TrackNumber SMOTN On SMOTN.FID=SMO.FTrackID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MO.FID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])afterChangeVersionMOIDList.toArray()));
            sql.append(")\r\n");
            sql.append("And CV.FID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])changeVersionIDList.toArray()));
            sql.append(")\r\n");
            sql.append("And SMO.FID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])beforeChangeVersionMOIDList.toArray()));
            sql.append(")\r\n");
            sql.append("And IsNull(MOTN.FNumber,'Null')>=IsNull(STN.FNumber,'Null')\r\n");
            sql.append("And IsNull(MOTN.FNumber,'Null')<=IsNull(ETN.FNumber,'Null')\r\n");
            sql.append("And IsNull(SMOTN.FNumber,'Null')>=IsNull(STN.FNumber,'Null')\r\n");
            sql.append("And IsNull(SMOTN.FNumber,'Null')<=IsNull(ETN.FNumber,'Null')\r\n");
            sql.append("And (\r\n");
            sql.append("IsNull(SMO.FBaseStatus,0)>").append(5).append("\r\n");
            sql.append("Or Exists (\r\n");
            sql.append("Select\r\n");
            sql.append("1\r\n");
            sql.append("From T_MM_MFTOrderTechnics SMOT\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And SMOT.FParentID=SMO.FID\r\n");
            sql.append("And IsNull(SMOT.FBaseStatus,0)>").append(5).append("\r\n");
            sql.append(")\r\n");
            sql.append("Or Exists(\r\n");
            sql.append("Select\r\n");
            sql.append("1\r\n");
            sql.append("From T_IM_MaterialReqBill SMRB\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And IsNull(SMRB.FBaseStatus,0)>=").append(4).append("\r\n");
            sql.append("And SMRB.FSourceBillID=SMO.FID\r\n");
            sql.append(")\r\n");
            sql.append(")\r\n");
            IRowSet updateMORowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (updateMORowSet != null && updateMORowSet.size() > 0) {
                while (updateMORowSet.next()) {
                    String id = updateMORowSet.getString("FID");
                    if (id == null || id.trim().length() == 0 || updateMOIDList.contains(id)) continue;
                    updateMOIDList.add(id);
                }
            }
            if (deleteMOIDList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(deleteMOIDList);
                deleteFilterInfo.getFilterItems().clear();
                deleteFilterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(deleteMOIDList), CompareType.INCLUDE));
                ManufactureOrderFactory.getLocalInstance((Context)ctx).delete(deleteFilterInfo);
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(deleteMOIDList);
            }
            if (deleteMRBIDList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(deleteMRBIDList);
                deleteFilterInfo.getFilterItems().clear();
                deleteFilterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(deleteMRBIDList), CompareType.INCLUDE));
                MaterialReqBillFactory.getLocalInstance((Context)ctx).delete(deleteFilterInfo);
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(deleteMRBIDList);
            }
            if (updateMOIDList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(updateMOIDList);
                sql.setLength(0);
                sql.append("Update T_MM_MFTOrderStock UT\r\n");
                sql.append("Set FIssueMode=").append(11040).append("\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And UT.FParentID In (\r\n");
                sql.append(SQLUtil.arrayToString((Object[])updateMOIDList.toArray()));
                sql.append(")\r\n");
                sql.append("And  Exists(select 1 from T_MM_MFTOrderStock a where a.fmaterialid = UT.fmaterialid \r\n");
                sql.append("And a.fqty > 0 And a.fparentid in (\r\n");
                sql.append(SQLUtil.arrayToString((Object[])beforeChangeVersionMOIDList.toArray()));
                sql.append("))");
                this.executeSQL(ctx, sql.toString());
                sql.setLength(0);
                sql.append("Update T_MM_MFTOrderStock UT\r\n");
                sql.append("Set FIssueMode=").append(11010).append("\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And UT.FParentID In (\r\n");
                sql.append(SQLUtil.arrayToString((Object[])updateMOIDList.toArray()));
                sql.append(")\r\n");
                sql.append("And Not Exists(select 1 from T_MM_MFTOrderStock a where a.fmaterialid = UT.fmaterialid \r\n");
                sql.append("And a.fqty > 0 And a.fparentid in (\r\n");
                sql.append(SQLUtil.arrayToString((Object[])beforeChangeVersionMOIDList.toArray()));
                sql.append("))");
                this.executeSQL(ctx, sql.toString());
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(updateMOIDList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void refreshWarehouse(Context ctx, String mosTempTable, String inOut, String storageOrgUnitID) throws EASBizException, BOSException {
        if (mosTempTable != null && mosTempTable.trim().length() > 0) {
            String tempTable = DivisionWarehouseFacadeFactory.getLocalInstance(ctx).createTempTable();
            StringBuffer sql = new StringBuffer();
            int effectedRows = 0;
            try {
                sql.setLength(0);
                sql.append(DivisionWarehouseFacadeFactory.getLocalInstance(ctx).insertTempTable(tempTable));
                sql.append("Select\r\n");
                sql.append("T.FID,\r\n");
                sql.append("'").append(storageOrgUnitID == null ? "Null" : storageOrgUnitID).append("',\r\n");
                sql.append("T.FWorkCenterID,\r\n");
                sql.append("T.FMaterialID,\r\n");
                sql.append("Null,\r\n");
                sql.append("Null\r\n");
                sql.append("From ").append(mosTempTable).append(" T\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                effectedRows = this.executeSQL(ctx, sql.toString());
            }
            catch (Exception e) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                throw new BOSException((Throwable)e);
            }
            if (effectedRows > 0) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("TempTable", tempTable);
                param.put("UpdateTable", mosTempTable);
                param.put("UpdateColumn", "FWarehouseID");
                param.put("InOut", inOut);
                DivisionWarehouseFacadeFactory.getLocalInstance(ctx).refreshWarehouse(param);
            }
        }
    }

    protected void releaseTempTable(Context ctx, Map param) {
        if (param == null || param.size() == 0) {
            return;
        }
        if (param.containsKey("TempTableName") && param.get("TempTableName") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.get("TempTableName").toString());
        }
        if (param.containsKey("PBOMEntryBOMEntryTempTable") && param.get("PBOMEntryBOMEntryTempTable") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.get("PBOMEntryBOMEntryTempTable").toString());
        }
        if (param.containsKey("MOTTempTableName") && param.get("MOTTempTableName") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.get("MOTTempTableName").toString());
        }
        if (param.containsKey("MOTMergeTempTableName") && param.get("MOTMergeTempTableName") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.get("MOTMergeTempTableName").toString());
        }
        if (param.containsKey("MOSTempTableName") && param.get("MOSTempTableName") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.get("MOSTempTableName").toString());
        }
        if (param.containsKey("MergeIWTempTableName") && param.get("MergeIWTempTableName") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.get("MergeIWTempTableName").toString());
        }
        if (param.containsKey("MergeIWRelationTempTableName") && param.get("MergeIWRelationTempTableName") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.get("MergeIWRelationTempTableName").toString());
        }
        if (param.containsKey("MergeTempTableName") && param.get("MergeTempTableName") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.get("MergeTempTableName").toString());
        }
        if (param.containsKey("ScheduleTempTableName") && param.get("ScheduleTempTableName") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.get("ScheduleTempTableName").toString());
        }
        if (param.containsKey("WarehouseTempTableName") && param.get("WarehouseTempTableName") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.get("WarehouseTempTableName").toString());
        }
        if (param.containsKey("JGJMOSEWHTempTableName") && param.get("JGJMOSEWHTempTableName") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.get("JGJMOSEWHTempTableName").toString());
        }
        if (param.containsKey("MOSERWHTempTableName") && param.get("MOSERWHTempTableName") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.get("MOSERWHTempTableName").toString());
        }
        if (param.containsKey("DeleteTempTableName") && param.get("DeleteTempTableName") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.get("DeleteTempTableName").toString());
        }
    }

    protected void removeBOTPRelation(Context ctx, String id) throws BOSException {
        if (id == null || id.trim().length() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Delete From T_BOT_Relation\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And FSRCObjectID='").append(id).append("'\r\n");
        sql.append("And FSRCEntityID='").append(new MasterProductionSchedule().getType().toString()).append("'\r\n");
        sql.append("And FDESTEntityID='").append(new ManufactureOrder().getType().toString()).append("'\r\n");
        sql.append("And (Not Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From T_MM_ManufactureOrder MO\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FID=FDESTObjectID\r\n");
        sql.append("))\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Delete From T_BOT_Relation\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And FSRCObjectID='").append(id).append("'\r\n");
        sql.append("And FSRCEntityID='").append(new MasterProductionSchedule().getType().toString()).append("'\r\n");
        sql.append("And FDESTEntityID='").append(new WorkshopSchedule().getType().toString()).append("'\r\n");
        sql.append("And (Not Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From CT_PS_WorkshopSchedule WS\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And WS.FID=FDESTObjectID\r\n");
        sql.append("))\r\n");
        this.executeSQL(ctx, sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeManufactureOrder(Context ctx, Map param) throws BOSException, EASBizException {
        EntityViewInfo view = null;
        FilterInfo filterInfo = null;
        ManufactureOrderCollection mos = null;
        if (this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
        }
        param.get("MasterProductionScheduleID").toString();
        StringBuffer sql = new StringBuffer();
        int row = 0;
        view = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)param.get("MasterProductionScheduleID").toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)0, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)2, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("MOS.FParentID \"FParentID\"\r\n");
        sql.append("From T_MM_MFTOrderStock MOS\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=MOS.FParentID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FSourceBillID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From T_IM_StockTransferBillEntry STBE\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And STBE.FSourceBillEntryID=MOS.FID\r\n");
        sql.append(")\r\n");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("MO.FID \"FID\"\r\n");
        sql.append("From T_MM_ManufactureOrder MO\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FSourceBillID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1 \"FID\"\r\n");
        sql.append("From CT_MO_FaultRecord FR\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And FR.CFManuOrderID=MO.FID\r\n");
        sql.append(")\r\n");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("transactionType.name", (Object)"\u6807\u51c6\u751f\u4ea7", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("srcReqChangeType", (Object)1, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("srcReqChangeType", (Object)2, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("srcReqChangeType", null, CompareType.EQUALS));
        filterInfo.setMaskString("( #0 And ( #1 Or #2 Or #3 Or #4 ) And #5 And #6 And #7 And ( ( #8 And #9 ) Or #10 ))");
        view.setFilter(filterInfo);
        mos = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderCollection(view);
        ArrayList<ObjectUuidPK> unAuditMOIDs = new ArrayList<ObjectUuidPK>();
        ArrayList<ObjectUuidPK> deleteMOIDs = new ArrayList<ObjectUuidPK>();
        ArrayList<ObjectUuidPK> deleteCOIDs = new ArrayList<ObjectUuidPK>();
        ArrayList lockMOIDList = new ArrayList();
        if (mos != null && mos.size() > 0) {
            for (row = 0; row < mos.size(); ++row) {
                if (mos.get(row) == null) continue;
                CostObjectInfo co = mos.get(row).getCostObject();
                if (co != null && co.getId() != null && !deleteCOIDs.contains(co.getId())) {
                    deleteCOIDs.add(new ObjectUuidPK(co.getId().toString()));
                }
                if (BillBaseStatusEnum.AUDITED.equals((Object)mos.get(row).getBaseStatus())) {
                    unAuditMOIDs.add(new ObjectUuidPK(mos.get(row).getId().toString()));
                }
                deleteMOIDs.add(new ObjectUuidPK(mos.get(row).getId().toString()));
            }
            MutexServiceControlFacadeFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(lockMOIDList);
            try {
                if (unAuditMOIDs != null && unAuditMOIDs.size() > 0) {
                    ManufactureOrderFactory.getLocalInstance((Context)ctx).unAudit((IObjectPK[])unAuditMOIDs.toArray(new ObjectUuidPK[unAuditMOIDs.size()]));
                }
                if (deleteMOIDs != null && deleteMOIDs.size() > 0) {
                    ManufactureOrderFactory.getLocalInstance((Context)ctx).delete((IObjectPK[])deleteMOIDs.toArray(new ObjectUuidPK[deleteMOIDs.size()]));
                }
            }
            finally {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(lockMOIDList);
            }
            if (deleteCOIDs == null || deleteCOIDs.size() > 0) {
                // empty if block
            }
        }
    }

    protected void removeTempTableInvalidData(Context ctx, String tempTableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTableName + "\r\n");
        sql.append("Set FDeleted=1\r\n");
        sql.append("Where\r\n");
        sql.append("1<>1\r\n");
        sql.append("Or\r\n");
        sql.append("FStorageORGUnitID Is Null\r\n");
        sql.append("Or\r\n");
        sql.append("LEN(FStorageORGUnitID)=0\r\n");
        sql.append("Or\r\n");
        sql.append("FMaterialID Is Null\r\n");
        sql.append("Or\r\n");
        sql.append("LEN(FMaterialID)=0\r\n");
        sql.append("Or\r\n");
        sql.append("FUnitID Is Null\r\n");
        sql.append("Or\r\n");
        sql.append("LEN(FUnitID)=0\r\n");
        sql.append("Or\r\n");
        sql.append("FBIZTypeID Is Null\r\n");
        sql.append("Or\r\n");
        sql.append("LEN(FBIZTypeID)=0\r\n");
        sql.append("Or\r\n");
        sql.append("FTransactionTypeID Is Null\r\n");
        sql.append("Or\r\n");
        sql.append("LEN(FTransactionTypeID)=0\r\n");
        sql.append("Or\r\n");
        sql.append("FProjectID Is Null\r\n");
        sql.append("Or\r\n");
        sql.append("LEN(FProjectID)=0\r\n");
        sql.append("Or\r\n");
        sql.append("FTraceID Is Null\r\n");
        sql.append("Or\r\n");
        sql.append("LEN(FTraceID)=0\r\n");
        sql.append("Or\r\n");
        sql.append("FBOMID Is Null\r\n");
        sql.append("Or\r\n");
        sql.append("LEN(FBOMID)=0\r\n");
        sql.append("Or\r\n");
        sql.append("FRoutingID Is Null\r\n");
        sql.append("Or\r\n");
        sql.append("LEN(FRoutingID)=0\r\n");
        sql.append("Or\r\n");
        sql.append("FADMINORGUnitID Is Null\r\n");
        sql.append("Or\r\n");
        sql.append("LEN(FADMINORGUnitID)=0\r\n");
        sql.append("Or\r\n");
        sql.append("FQTY Is Null\r\n");
        sql.append("Or\r\n");
        sql.append("FQTY<=0\r\n");
        sql.append("Or\r\n");
        sql.append("FStartDate Is Null\r\n");
        sql.append("Or\r\n");
        sql.append("FFinishDate Is Null\r\n");
        sql.append("Or\r\n");
        sql.append("IsNull(FStorageOrgUnitID,'Null')<>IsNull(FSupplyStorageOrgUnitID,'Null')\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update " + tempTableName + " UT\r\n");
        sql.append("Set FDeleted=1\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And Exists (\r\n");
        sql.append("Select\r\n");
        sql.append("B.FID\r\n");
        sql.append("From T_MM_BOM B\r\n");
        sql.append("Where\r\n");
        sql.append("B.FID=UT.FBOMID\r\n");
        sql.append("And B.FStorageORGUnitID<>UT.FStorageORGUnitID\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update " + tempTableName + " UT\r\n");
        sql.append("Set FDeleted=1\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And (Not Exists (\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From T_ORG_ADMIN AD\r\n");
        sql.append("Where\r\n");
        sql.append("AD.FID=UT.FADMINORGUnitID\r\n");
        sql.append(")\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeWorkshopSchedule(Context ctx, Map param) throws BOSException, EASBizException {
        EntityViewInfo view = null;
        FilterInfo filterInfo = null;
        WorkshopScheduleCollection wss = null;
        int row = 0;
        view = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)param.get("MasterProductionScheduleID").toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)0, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)2, CompareType.EQUALS));
        filterInfo.setMaskString("( #0 And ( #1 Or #2 Or #3 ) )");
        view.setFilter(filterInfo);
        wss = WorkshopScheduleFactory.getLocalInstance(ctx).getWorkshopScheduleCollection(view);
        ArrayList<ObjectUuidPK> deleteWSIDs = new ArrayList<ObjectUuidPK>();
        ArrayList<String> lockWSIDList = new ArrayList<String>();
        if (wss != null && wss.size() > 0) {
            for (row = 0; row < wss.size(); ++row) {
                if (wss.get(row) == null) continue;
                deleteWSIDs.add(new ObjectUuidPK(wss.get(row).getId().toString()));
                lockWSIDList.add(wss.get(row).getId().toString());
            }
            MutexServiceControlFacadeFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(lockWSIDList);
            try {
                if (deleteWSIDs != null && deleteWSIDs.size() > 0) {
                    WorkshopScheduleFactory.getLocalInstance(ctx).delete((IObjectPK[])deleteWSIDs.toArray(new ObjectUuidPK[deleteWSIDs.size()]));
                }
            }
            finally {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(lockWSIDList);
            }
        }
    }

    protected void setBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws EASBizException, BOSException {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        if (billNumber != null) {
            billInfo.setString("number", billNumber);
        } else if (billInfo.getString("id") != null) {
            billInfo.setString("number", "AutoNumberFromBTP_" + billInfo.getString("id").toString());
        } else {
            billInfo.setString("number", "AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        }
    }

    protected void updateMOSDatas(Context ctx, IObjectPK[] pks, Boolean isMSEIssueModeFromBOMEntry) throws BOSException {
    }

    protected void updateMOSDatas(Context ctx, String mosTempTable, Boolean isMSEIssueModeFromBOMEntry) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" T\r\n");
        sql.append("Set FReceiptStroageOrgUnitID=FStorageOrgUnitID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And FReceiptStroageOrgUnitID Is Null\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" T\r\n");
        sql.append("Set FReceiptStroageOrgUnitID=FStorageOrgUnitID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And FProvideType=").append(10920).append("\r\n");
        this.executeSQL(ctx, sql.toString());
        String imttTempTable = this.createIMTTTempTable(ctx);
        sql.setLength(0);
        sql.append(this.insertIMTTTempTableSQL(imttTempTable));
        sql.append("Select\r\n");
        sql.append("T.FID,\r\n");
        if (isMSEIssueModeFromBOMEntry.booleanValue()) {
            sql.append("IsNull(T.FIssueMode,").append(11040).append("),\r\n");
        } else {
            sql.append("Case\r\n");
            sql.append("When IsNull(MIBEMBES.CFIsWarehouse,0)=0 Then ").append(11040).append("\r\n");
            sql.append("When IsNull(MIBEMBES.CFIsWarehouse,0)=1 Then ").append(11010).append("\r\n");
            sql.append("Else IsNull(T.FIssueMode,").append(11040).append(")\r\n");
            sql.append("End,\r\n");
        }
        sql.append("Case\r\n");
        sql.append("When IsNull(T.FIsStockALLOT,0)=1 And IsNull(T.FReceiptStroageOrgUnitID,'Null')<>'Null' Then\r\n");
        sql.append("\tCase\r\n");
        sql.append("\tWhen IsNull(T.FReceiptStroageOrgUnitID,'Null')=IsNull(MO.FStorageOrgUnitID,'Null') Then ").append(2).append("\r\n");
        sql.append("\tElse \r\n");
        sql.append("\t\tCase\r\n");
        sql.append("\t\tWhen IsNull((\r\n");
        sql.append("\t\tSelect\r\n");
        sql.append("\t\tTop 1\r\n");
        sql.append("\t\tOUR.FToUnitID FORGUnitID\r\n");
        sql.append("\t\tFrom T_ORG_UnitRelation OUR\r\n");
        sql.append("\t\tInner Join T_ORG_TypeRelation OTR On OTR.FID=OUR.FTypeRelationID\r\n");
        sql.append("\t\tWhere\r\n");
        sql.append("\t\t1=1\r\n");
        sql.append("\t\tAnd OUR.FFromUnitID=T.FReceiptStroageOrgUnitID\r\n");
        sql.append("\t\tAnd OTR.FFromType=4\r\n");
        sql.append("\t\tAnd OTR.FToType=1\r\n");
        sql.append("\t\t),'1')=IsNull((\r\n");
        sql.append("\t\tSelect\r\n");
        sql.append("\t\tTop 1\r\n");
        sql.append("\t\tOUR.FToUnitID FORGUnitID\r\n");
        sql.append("\t\tFrom T_ORG_UnitRelation OUR\r\n");
        sql.append("\t\tInner Join T_ORG_TypeRelation OTR On OTR.FID=OUR.FTypeRelationID\r\n");
        sql.append("\t\tWhere\r\n");
        sql.append("\t\t1=1\r\n");
        sql.append("\t\tAnd OUR.FFromUnitID=MO.FStorageOrgUnitID\r\n");
        sql.append("\t\tAnd OTR.FFromType=4\r\n");
        sql.append("\t\tAnd OTR.FToType=1\r\n");
        sql.append("\t\t),'2') Then ").append(1).append("\r\n");
        sql.append("\t\tElse ").append(3).append("\r\n");
        sql.append("\t\tEnd\r\n");
        sql.append("\tEnd\r\n");
        sql.append("Else ").append(0).append("\r\n");
        sql.append("End\r\n");
        sql.append("From ").append(mosTempTable).append(" T\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=T.FParentID\r\n");
        sql.append("Left Join T_BD_MaterialInventory MIBEMBES On T.FMaterialID=MIBEMBES.FMaterialID And MIBEMBES.FOrgUnit=T.FStorageOrgUnitID\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" UT\r\n");
        sql.append("Set (\r\n");
        sql.append("FIssueMode,\r\n");
        sql.append("FTransferType\r\n");
        sql.append(")=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("T.FIssueMode,\r\n");
        sql.append("T.FTransferType\r\n");
        sql.append("From ").append(imttTempTable).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FID=UT.FID\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        TempTablePool.getInstance((Context)ctx).releaseTable(imttTempTable);
        String ptTempTable = this.createPTTempTable(ctx);
        sql.setLength(0);
        sql.append(this.insertPTTempTableSQL(ptTempTable));
        sql.append("Select\r\n");
        sql.append("T.FID,\r\n");
        sql.append("Case\r\n");
        sql.append("When IsNull(T.FProvideType,0) In (\r\n");
        sql.append(10910).append(",\r\n");
        sql.append(10920).append("\r\n");
        sql.append(")\r\n");
        sql.append("And IsNull(T.FIssueMode,0)=").append(11010).append("\r\n");
        sql.append("Then ").append(1).append("\r\n");
        sql.append("When IsNull(T.FProvideType,0)=").append(10930).append(" Then\r\n");
        sql.append("\tCase\r\n");
        sql.append("\tWhen (Not Exists(\r\n");
        sql.append("\tSelect\r\n");
        sql.append("\t1\r\n");
        sql.append("\tFrom T_ORG_UnitRelation OUR\r\n");
        sql.append("\tInner Join T_ORG_TypeRelation OTR On OTR.FID=OUR.FTypeRelationID\r\n");
        sql.append("\tWhere\r\n");
        sql.append("\t1=1\r\n");
        sql.append("\tAnd OUR.FFromUnitID=T.FStorageOrgUnitID\r\n");
        sql.append("\tAnd OTR.FFromType=4\r\n");
        sql.append("\tAnd OTR.FToType=1\r\n");
        sql.append("\t)) Or (Not Exists(\r\n");
        sql.append("\tSelect\r\n");
        sql.append("\t1\r\n");
        sql.append("\tFrom T_ORG_UnitRelation OUR\r\n");
        sql.append("\tInner Join T_ORG_TypeRelation OTR On OTR.FID=OUR.FTypeRelationID\r\n");
        sql.append("\tWhere\r\n");
        sql.append("\t1=1\r\n");
        sql.append("\tAnd OUR.FFromUnitID=MO.FStorageOrgUnitID\r\n");
        sql.append("\tAnd OTR.FFromType=4\r\n");
        sql.append("\tAnd OTR.FToType=1\r\n");
        sql.append("\t)) Then ").append(3).append("\r\n");
        sql.append("\tElse\r\n");
        sql.append("\t\tCase\r\n");
        sql.append("\t\tWhen IsNull((\r\n");
        sql.append("\t\tSelect\r\n");
        sql.append("\t\tTop 1\r\n");
        sql.append("\t\tOUR.FToUnitID FORGUnitID\r\n");
        sql.append("\t\tFrom T_ORG_UnitRelation OUR\r\n");
        sql.append("\t\tInner Join T_ORG_TypeRelation OTR On OTR.FID=OUR.FTypeRelationID\r\n");
        sql.append("\t\tWhere\r\n");
        sql.append("\t\t1=1\r\n");
        sql.append("\t\tAnd OUR.FFromUnitID=T.FStorageOrgUnitID\r\n");
        sql.append("\t\tAnd OTR.FFromType=4\r\n");
        sql.append("\t\tAnd OTR.FToType=1\r\n");
        sql.append("\t\t),'Null')=IsNull((\r\n");
        sql.append("\t\tSelect\r\n");
        sql.append("\t\tTop 1\r\n");
        sql.append("\t\tOUR.FToUnitID FORGUnitID\r\n");
        sql.append("\t\tFrom T_ORG_UnitRelation OUR\r\n");
        sql.append("\t\tInner Join T_ORG_TypeRelation OTR On OTR.FID=OUR.FTypeRelationID\r\n");
        sql.append("\t\tWhere\r\n");
        sql.append("\t\t1=1\r\n");
        sql.append("\t\tAnd OUR.FFromUnitID=MO.FStorageOrgUnitID\r\n");
        sql.append("\t\tAnd OTR.FFromType=4\r\n");
        sql.append("\t\tAnd OTR.FToType=1\r\n");
        sql.append("\t\t),'Null') Then ").append(2).append("\r\n");
        sql.append("\t\tElse ").append(3).append("\r\n");
        sql.append("\t\tEnd\r\n");
        sql.append("\tEnd\r\n");
        sql.append("Else ").append(0).append("\r\n");
        sql.append("End\r\n");
        sql.append("From ").append(mosTempTable).append(" T\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=T.FParentID\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" UT\r\n");
        sql.append("Set FPickType=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("T.FPickType\r\n");
        sql.append("From ").append(ptTempTable).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FID=UT.FID\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        TempTablePool.getInstance((Context)ctx).releaseTable(ptTempTable);
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" UT\r\n");
        sql.append("Set (\r\n");
        sql.append("FWorkcenterID,\r\n");
        sql.append("FOperationID\r\n");
        sql.append(")=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("MOTE.FWorkcenterID,\r\n");
        sql.append("MOTE.FOperationID\r\n");
        sql.append("From T_MM_MFTOrderTechnics MOTE\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MOTE.FParentID=UT.FParentID\r\n");
        sql.append("And MOTE.FOperationNO=UT.FOperationNO\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" UT\r\n");
        sql.append("Set\r\n");
        sql.append("FUnReceiptQTY=IsNull(FPlannedQTY,0),\r\n");
        sql.append("FOriginalPlanQTY=IsNull(FPlannedQTY,0)\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" UT\r\n");
        sql.append("Set (\r\n");
        sql.append("FUnitBaseQTY,\r\n");
        sql.append("FBaseQTY,\r\n");
        sql.append("FPlannedBaseQTY,\r\n");
        sql.append("FLossBaseQTY,\r\n");
        sql.append("FUnReceiptBaseQTY,\r\n");
        sql.append("FOriginalPlanBaseQTY,\r\n");
        sql.append("FTotalReceiptBaseQTY\r\n");
        sql.append(")=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("Round(IsNull(FUnitQTY,0)*IsNull(MU.FBaseCONVSRate,0),IsNull(MU.FQTYPrecision,0)),\r\n");
        sql.append("Round(IsNull(FQTY,0)*IsNull(MU.FBaseCONVSRate,0),IsNull(MU.FQTYPrecision,0)),\r\n");
        sql.append("Round(IsNull(FPlannedQTY,0)*IsNull(MU.FBaseCONVSRate,0),IsNull(MU.FQTYPrecision,0)),\r\n");
        sql.append("Round(IsNull(FLossQTY,0)*IsNull(MU.FBaseCONVSRate,0),IsNull(MU.FQTYPrecision,0)),\r\n");
        sql.append("Round(IsNull(FUnReceiptQTY,0)*IsNull(MU.FBaseCONVSRate,0),IsNull(MU.FQTYPrecision,0)),\r\n");
        sql.append("Round(IsNull(FOriginalPlanQTY,0)*IsNull(MU.FBaseCONVSRate,0),IsNull(MU.FQTYPrecision,0)),\r\n");
        sql.append("Round(IsNull(FTotalReceiptQTY,0)*IsNull(MU.FBaseCONVSRate,0),IsNull(MU.FQTYPrecision,0))\r\n");
        sql.append("From ").append(mosTempTable).append(" T\r\n");
        sql.append("Left Join T_BD_MultiMeasureUnit MU On\r\n");
        sql.append("1=1\r\n");
        sql.append("And MU.FMaterialID=T.FMaterialID\r\n");
        sql.append("And MU.FMeasureUnitID=T.FBaseUnitID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FID=UT.FID\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" UT\r\n");
        sql.append("Set (\r\n");
        sql.append("FUnIssueQTY,\r\n");
        sql.append("FUnIssueBaseQTY,\r\n");
        sql.append("FAssociateQTY,\r\n");
        sql.append("FLossQTY\r\n");
        sql.append(")=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("IsNull(FPlannedQTY,0) -IsNull(FActIssueQTY,0) -IsNull(FRejectedQTY,0),\r\n");
        sql.append("IsNull(FPlannedBaseQTY,0) -IsNull(FActIssueBaseQTY,0) -IsNull(FRejectedBaseQTY,0),\r\n");
        sql.append("Round(IsNull(FPlannedBaseQTY,0) * (1+IsNull(FExtraRatio,0)/100),IsNull(MU.FQTYPrecision,0)) -IsNull(FActIssueBaseQTY,0),\r\n");
        sql.append("IsNull(FPlannedQTY,0) -IsNull(FQTY,0)\r\n");
        sql.append("From ").append(mosTempTable).append(" T\r\n");
        sql.append("Left Join T_BD_MultiMeasureUnit MU On\r\n");
        sql.append("1=1\r\n");
        sql.append("And MU.FMaterialID=T.FMaterialID\r\n");
        sql.append("And MU.FMeasureUnitID=T.FBaseUnitID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FID=UT.FID\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
    }

    protected void updateMOSStockOrgUnit(Context ctx, String mosTempTableName) throws BOSException {
        if (mosTempTableName == null) {
            return;
        }
        if (mosTempTableName.trim().length() == 0) {
            return;
        }
        String mosOrgTempTable = this.createMOSOrgTempTable(ctx);
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(this.insertMOSOrgTempTableSQL(mosOrgTempTable));
        sql.append("Select\r\n");
        sql.append("T.FID FMOSID,\r\n");
        sql.append("CR.FToUnitID FStorageOrgUnitID,\r\n");
        sql.append("IsNull(CR.FIsDefault,0) FDefault\r\n");
        sql.append("From ").append(mosTempTableName).append(" T\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=T.FParentID\r\n");
        sql.append("Inner Join T_Org_TypeRelation STR On\r\n");
        sql.append("1=1\r\n");
        sql.append("And STR.FFromType=").append(4).append("\r\n");
        sql.append("And STR.FToType=").append(1).append("\r\n");
        sql.append("Inner Join T_Org_UnitRelation SSR On\r\n");
        sql.append("1=1\r\n");
        sql.append("And SSR.FTypeRelationID=STR.FID\r\n");
        sql.append("And SSR.FFromUnitID=T.FStorageOrgUnitID\r\n");
        sql.append("Inner Join T_Org_UnitRelation SR On\r\n");
        sql.append("1=1\r\n");
        sql.append("And SR.FTypeRelationID=STR.FID\r\n");
        sql.append("And SR.FFromUnitID=MO.FStorageOrgUnitID\r\n");
        sql.append("Inner Join T_Org_TypeRelation CTR On\r\n");
        sql.append("1=1\r\n");
        sql.append("And CTR.FFromType=").append(1).append("\r\n");
        sql.append("And CTR.FToType=").append(4).append("\r\n");
        sql.append("Inner Join T_Org_UnitRelation CR On\r\n");
        sql.append("1=1\r\n");
        sql.append("And CR.FTypeRelationID=CTR.FID\r\n");
        sql.append("And CR.FFromUnitID=SR.FToUnitID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And IsNull(SSR.FToUnitID,'Null')<>IsNull(SR.FToUnitID,'Null')\r\n");
        sql.append("And CR.FToUnitID Is Not Null\r\n");
        int effectRows = this.executeSQL(ctx, sql.toString());
        if (effectRows > 0) {
            sql.setLength(0);
            sql.append("Update ").append(mosTempTableName).append(" UT\r\n");
            sql.append("Set\r\n");
            sql.append("FStorageOrgUnitID=(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("T.FStorageOrgUnitID\r\n");
            sql.append("From ").append(mosOrgTempTable).append(" T\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And T.FMOSID=UT.FID\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FID In (\r\n");
            sql.append("Select\r\n");
            sql.append("T.FMOSID\r\n");
            sql.append("From ").append(mosOrgTempTable).append(" T\r\n");
            sql.append(")\r\n");
            this.executeSQL(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Update ").append(mosTempTableName).append(" UT\r\n");
            sql.append("Set\r\n");
            sql.append("FStorageOrgUnitID=(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("T.FStorageOrgUnitID\r\n");
            sql.append("From ").append(mosOrgTempTable).append(" T\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And T.FMOSID=UT.FID\r\n");
            sql.append("And T.FDefault=1\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FID In (\r\n");
            sql.append("Select\r\n");
            sql.append("T.FMOSID\r\n");
            sql.append("From ").append(mosOrgTempTable).append(" T\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And T.FDefault=1\r\n");
            sql.append(")\r\n");
            this.executeSQL(ctx, sql.toString());
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(mosOrgTempTable);
    }

    protected void updateMOSWarehouse(Context ctx, String mosTempTable, String storageOrgUnitID, Boolean isWarehouseFromBOMEntry, Boolean defaultWarehousemodel, Boolean isMOSWarehouseFromOrderStorageOrgUnit) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String updateMOSTempTable = null;
        if (isWarehouseFromBOMEntry.booleanValue()) {
            updateMOSTempTable = this.createMOSTempTable(ctx);
            sql.setLength(0);
            sql.append(this.insertMOSTempTableSQL(ctx, updateMOSTempTable));
            sql.append("SELECT\r\n");
            sql.append("T.FID,\r\n");
            sql.append("T.FPARENTID,\r\n");
            sql.append("T.FMATERIALID,\r\n");
            sql.append("T.FREPLACEMATERIALID,\r\n");
            sql.append("T.FASSISTPROPERTYID,\r\n");
            sql.append("T.FUNITID,\r\n");
            sql.append("T.FBASEUNITID,\r\n");
            sql.append("T.FASSISTUNITID,\r\n");
            sql.append("T.FREASONCODEID,\r\n");
            sql.append("T.FWAREHOUSEID,\r\n");
            sql.append("T.FRECEIPTSTOCKID,\r\n");
            sql.append("T.FCOMBINATIONSTOCKID,\r\n");
            sql.append("T.FLOCATIONID,\r\n");
            sql.append("T.FOPERATIONID,\r\n");
            sql.append("T.FSTORAGEORGUNITID,\r\n");
            sql.append("T.FRECEIPTSTROAGEORGUNITID,\r\n");
            sql.append("T.FWORKCENTERID,\r\n");
            sql.append("T.FBOMENTRYID,\r\n");
            sql.append("T.FSOURCEBILLENTRYID,\r\n");
            sql.append("T.FASSOCIATEQTY,\r\n");
            sql.append("T.FLOSSRATIO,\r\n");
            sql.append("T.FEXTRARATIO,\r\n");
            sql.append("T.FLACKRATIO,\r\n");
            sql.append("T.FREPLACERATIO,\r\n");
            sql.append("T.FUNITREPLACEQTY,\r\n");
            sql.append("T.CFOPENQTY,\r\n");
            sql.append("T.CFACTMOVEQTY,\r\n");
            sql.append("T.CFALRMOVEQTY,\r\n");
            sql.append("T.FQTY,\r\n");
            sql.append("T.FBASEQTY,\r\n");
            sql.append("T.FLOSSQTY,\r\n");
            sql.append("T.FLOSSBASEQTY,\r\n");
            sql.append("T.FACTISSUEQTY,\r\n");
            sql.append("T.FACTISSUEBASEQTY,\r\n");
            sql.append("T.FACTLOSSQTY,\r\n");
            sql.append("T.FACTLOSSBASEQTY,\r\n");
            sql.append("T.FREJECTEDQTY,\r\n");
            sql.append("T.FREJECTEDBASEQTY,\r\n");
            sql.append("T.FFEEDINGQTY,\r\n");
            sql.append("T.FFEEDINGBASEQTY,\r\n");
            sql.append("T.FSCRAPQTY,\r\n");
            sql.append("T.FSCRAPBASEQTY,\r\n");
            sql.append("T.FWIPQTY,\r\n");
            sql.append("T.FWIPBASEQTY,\r\n");
            sql.append("T.FPLANNEDQTY,\r\n");
            sql.append("T.FPLANNEDBASEQTY,\r\n");
            sql.append("T.FUNITQTY,\r\n");
            sql.append("T.FUNITBASEQTY,\r\n");
            sql.append("T.FMATERIALSCRAPQTY,\r\n");
            sql.append("T.FMATERIALSCRAPBASEQTY,\r\n");
            sql.append("T.FMATERIALFEEDINGQTY,\r\n");
            sql.append("T.FMATERIALFEEDINGBASEQTY,\r\n");
            sql.append("T.FUNISSUEQTY,\r\n");
            sql.append("T.FUNISSUEBASEQTY,\r\n");
            sql.append("T.FTOSTOREQTY,\r\n");
            sql.append("T.FTOSTOREBASEQTY,\r\n");
            sql.append("T.FORIGINALPLANQTY,\r\n");
            sql.append("T.FORIGINALPLANBASEQTY,\r\n");
            sql.append("T.FTOTALRECEIPTQTY,\r\n");
            sql.append("T.FTOTALRECEIPTBASEQTY,\r\n");
            sql.append("T.FUNRECEIPTQTY,\r\n");
            sql.append("T.FUNRECEIPTBASEQTY,\r\n");
            sql.append("T.FTOTALDIRECTRECEIVEQTY,\r\n");
            sql.append("T.FTOTALDIRECTRECEIVEBASEQTY,\r\n");
            sql.append("T.FTOTALDSTRANSFERQTY,\r\n");
            sql.append("T.FTOTALDSTRANSFERBASEQTY,\r\n");
            sql.append("T.FDEMANDTIME,\r\n");
            sql.append("T.FACTUEISSUETIME,\r\n");
            sql.append("T.FBLKSIZE,\r\n");
            sql.append("T.FSPECIFIEDLENGTH,\r\n");
            sql.append("T.FASSYLOCATION_L2,\r\n");
            sql.append("Null,\r\n");
            sql.append("T.FSEQ,\r\n");
            sql.append("T.FLINESEQ,\r\n");
            sql.append("T.FBASESTATUS,\r\n");
            sql.append("T.FMATREPLACETYPE,\r\n");
            sql.append("T.FTRANSFERTYPE,\r\n");
            sql.append("T.FPROVIDETYPE,\r\n");
            sql.append("T.FPICKTYPE,\r\n");
            sql.append("T.FSCRAPEXPR,\r\n");
            sql.append("T.FREPLACEGROUPFLAG,\r\n");
            sql.append("T.FREPLACEPRIORITY,\r\n");
            sql.append("T.CFMOVESTATUS,\r\n");
            sql.append("T.FNEWNETWEIGHT,\r\n");
            sql.append("T.FOPERATIONNO,\r\n");
            sql.append("T.FISSUEMODE,\r\n");
            sql.append("T.FISREPLACED,\r\n");
            sql.append("T.FISBACKFLUSH,\r\n");
            sql.append("T.FISQTYLIMIT,\r\n");
            sql.append("T.FISSTOCKALLOT,\r\n");
            sql.append("T.CFISMUSTREQ,\r\n");
            sql.append("T.CFISLINESTOREHOUSE,\r\n");
            sql.append("T.CFIsOwnObject\r\n");
            sql.append("FROM ").append(mosTempTable).append(" T\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And T.FWarehouseID Is Null\r\n");
            this.executeSQL(ctx, sql.toString());
        } else if (defaultWarehousemodel.booleanValue()) {
            sql.setLength(0);
            sql.append(" update ").append(mosTempTable).append(" tmp");
            sql.append(" set FWarehouseID=");
            sql.append(" (select max(FDefaultWarehouseID) from t_bd_materialinventory T where ");
            sql.append(" T.FMaterialID=tmp.FMaterialID  and  T.forgunit=tmp.FStorageOrgUnitID  and T.fstatus=1)");
            this.executeSQL(ctx, sql.toString());
            if (isMOSWarehouseFromOrderStorageOrgUnit.booleanValue()) {
                sql.setLength(0);
                sql.append("Update ").append(mosTempTable).append(" T\r\n");
                sql.append("Set FWarehouseID=(\r\n");
                sql.append("Select\r\n");
                sql.append("Max(FDefaultWarehouseID)\r\n");
                sql.append("From T_BD_MaterialInventory MI\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And MI.FMaterialID=T.FMaterialID\r\n");
                sql.append("And MI.FOrgUnit='").append(storageOrgUnitID).append("'\r\n");
                sql.append("And MI.FStatus=1\r\n");
                sql.append(")\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And T.FProvideType=").append(10920).append("\r\n");
                this.executeSQL(ctx, sql.toString());
            }
        } else {
            updateMOSTempTable = mosTempTable;
        }
        if (updateMOSTempTable == null) {
            return;
        }
        if (updateMOSTempTable.trim().length() == 0) {
            return;
        }
        if (!defaultWarehousemodel.booleanValue()) {
            this.refreshWarehouse(ctx, updateMOSTempTable, "Out", storageOrgUnitID);
        }
        if (isWarehouseFromBOMEntry.booleanValue()) {
            sql.setLength(0);
            sql.append("Update ").append(mosTempTable).append(" UT\r\n");
            sql.append("Set FWarehouseID=(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("T.FWarehouseID\r\n");
            sql.append("From ").append(updateMOSTempTable).append(" T\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And T.FID=UT.FID\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FID In (\r\n");
            sql.append("Select\r\n");
            sql.append("T.FID\r\n");
            sql.append("From ").append(updateMOSTempTable).append(" T\r\n");
            sql.append(")\r\n");
            this.executeSQL(ctx, sql.toString());
            TempTablePool.getInstance((Context)ctx).releaseTable(updateMOSTempTable);
        }
        String mosersTempTable = this.createMOSERSTempTable(ctx);
        sql.setLength(0);
        sql.append(this.insertMOSERSTempTableSQL(mosersTempTable));
        sql.append("Select\r\n");
        sql.append("ROWNUM,\r\n");
        sql.append("MOSE.FID,\r\n");
        sql.append("MWH.FWarehouseID\r\n");
        sql.append("From ").append(mosTempTable).append(" MOSE\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=MOSE.FParentID\r\n");
        sql.append("Inner Join T_ZJ_ProjectWarehouse PWH On\r\n");
        sql.append("1=1\r\n");
        sql.append("And PWH.FStatus=").append("1").append("\r\n");
        sql.append("And PWH.FProjectID=MO.FProjectID\r\n");
        sql.append("And PWH.FStorageORGUnitID=MOSE.FReceiptStroageORGUnitID\r\n");
        sql.append("Inner Join T_ZJ_MaterialWarehouseSetting MWH On\r\n");
        sql.append("1=1\r\n");
        sql.append("And MWH.FStatus=").append("1").append("\r\n");
        sql.append("And IsNull(MWH.FIsOut,0)=1\r\n");
        sql.append("And MWH.FStorageORGUnitID=MOSE.FReceiptStroageORGUnitID\r\n");
        sql.append("And MWH.FMaterialID=MOSE.FMaterialID\r\n");
        sql.append("Inner Join T_DB_Warehouse WH On WH.FID=MWH.FWarehouseID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And WH.CFWarehouseGroupID=PWH.FWarehouseGroupID\r\n");
        sql.append("And MOSE.FReceiptStroageORGUnitID Is Not Null\r\n");
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" UT\r\n");
        sql.append("Set FReceiptStockID=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("T.FWarehouseID\r\n");
        sql.append("From ").append(mosersTempTable).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FMOSTOCKID=UT.FID\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FProvideType=").append(10920).append("\r\n");
        sql.append("And IsNull((\r\n");
        sql.append("Select\r\n");
        sql.append("Top 2\r\n");
        sql.append("Count(1)\r\n");
        sql.append("From ").append(mosersTempTable).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FMOSTOCKID=UT.FID\r\n");
        sql.append("),0)=1\r\n");
        this.executeSQL(ctx, sql.toString());
        TempTablePool.getInstance((Context)ctx).releaseTable(mosersTempTable);
        String jgjmosewhTempTable = this.createJGJMOSEWHTempTable(ctx);
        sql.setLength(0);
        sql.append(this.insertJGJMOSEWHTempTableSQL(ctx, jgjmosewhTempTable));
        sql.append("Select\r\n");
        sql.append("NewBOSID('12345678'),\r\n");
        sql.append("MOS.FID,\r\n");
        sql.append("MOS.FReceiptStockID,\r\n");
        sql.append("WH.FID,\r\n");
        sql.append("WHG.FName\r\n");
        sql.append("From ").append(mosTempTable).append(" MOS\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder MO On MOS.FParentID=MO.FID\r\n");
        sql.append("Inner Join T_BD_Material M On M.FID=MOS.FMaterialID\r\n");
        sql.append("Inner Join T_ORG_Storage MOSSOU On MOSSOU.FID=MOS.FStorageOrgUnitID\r\n");
        sql.append("Inner Join T_ORG_Storage SOU On SOU.FID=MO.FStorageOrgUnitID\r\n");
        sql.append("Left Join T_ZJ_MaterialWarehouseSetting MWS On\r\n");
        sql.append("1=1\r\n");
        sql.append("And MWS.FStorageOrgUnitID=MOS.FReceiptStroageOrgUnitID\r\n");
        sql.append("And MWS.FMaterialID=MOS.FMaterialID\r\n");
        sql.append("And IsNull(MWS.FIsOut,0)=1\r\n");
        sql.append("And MWS.FStatus=").append("1").append("\r\n");
        sql.append("Left Join T_DB_WareHouse WH On WH.FID=MWS.FWarehouseID\r\n");
        sql.append("Left Join T_BD_WareHouseGroup WHG On WHG.FID=WH.CFWarehouseGroupID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And SOU.FNumber='1.31.00'\r\n");
        sql.append("And IsNull(M.CFIsFastener,0)=1\r\n");
        sql.append("And MOSSOU.FNumber='1.28.00'\r\n");
        sql.append("And MOS.FProvideType=").append(10920).append("\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" UT\r\n");
        sql.append("Set FReceiptStockID=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("T.FNewWarehouseID\r\n");
        sql.append("From ").append(jgjmosewhTempTable).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FMOSID=UT.FID\r\n");
        sql.append("And IsNull(T.FNewWarehouseID,'Null')<>'Null'\r\n");
        sql.append("And IsNull(T.FNewWarehouseGroupName,'Null')='\u7269\u6d41\u90e8\u673a\u8f66\u5e93\u623f'\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From ").append(jgjmosewhTempTable).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FMOSID=UT.FID\r\n");
        sql.append(")\r\n");
        sql.append("And IsNull((\r\n");
        sql.append("Select\r\n");
        sql.append("Top 2\r\n");
        sql.append("Count(Count(1))\r\n");
        sql.append("From ").append(jgjmosewhTempTable).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FMOSID=UT.FID\r\n");
        sql.append("And IsNull(T.FNewWarehouseID,'Null')<>'Null'\r\n");
        sql.append("And IsNull(T.FNewWarehouseGroupName,'Null')='\u7269\u6d41\u90e8\u673a\u8f66\u5e93\u623f'\r\n");
        sql.append("Group By\r\n");
        sql.append("T.FNewWarehouseID\r\n");
        sql.append("),0)=1\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" UT\r\n");
        sql.append("Set FReceiptStockID=Null\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From ").append(jgjmosewhTempTable).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FMOSID=UT.FID\r\n");
        sql.append(")\r\n");
        sql.append("And IsNull((\r\n");
        sql.append("Select\r\n");
        sql.append("Top 2\r\n");
        sql.append("Count(Count(1))\r\n");
        sql.append("From ").append(jgjmosewhTempTable).append(" T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FMOSID=UT.FID\r\n");
        sql.append("And IsNull(T.FNewWarehouseID,'Null')<>'Null'\r\n");
        sql.append("And IsNull(T.FNewWarehouseGroupName,'Null')='\u7269\u6d41\u90e8\u673a\u8f66\u5e93\u623f'\r\n");
        sql.append("Group By\r\n");
        sql.append("T.FNewWarehouseID\r\n");
        sql.append("),0)<>1\r\n");
        this.executeSQL(ctx, sql.toString());
        TempTablePool.getInstance((Context)ctx).releaseTable(jgjmosewhTempTable);
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" UT\r\n");
        sql.append("Set FLocationID=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("MSA.FLocationID\r\n");
        sql.append("From T_DB_MaterialStorageAssign MSA\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MSA.FStorageOrgID=UT.FStorageOrgUnitID\r\n");
        sql.append("And MSA.FMaterialID=UT.FMaterialID\r\n");
        sql.append("And MSA.FWarehouseID=UT.FWarehouseID\r\n");
        sql.append("And MSA.FIsDefaultLocation=1\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FLocationID Is Null\r\n");
        sql.append("And UT.FWarehouseID In (\r\n");
        sql.append("Select\r\n");
        sql.append("MSA.FWarehouseID\r\n");
        sql.append("From T_DB_MaterialStorageAssign MSA\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MSA.FStorageOrgID=UT.FStorageOrgUnitID\r\n");
        sql.append("And MSA.FMaterialID=UT.FMaterialID\r\n");
        sql.append("And MSA.FIsDefaultLocation=1\r\n");
        sql.append(")\r\n");
        sql.append("And UT.FWarehouseID In (\r\n");
        sql.append("Select\r\n");
        sql.append("WH.FID\r\n");
        sql.append("From T_DB_Warehouse WH\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And WH.FHasLocation=1\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" UT\r\n");
        sql.append("Set\r\n");
        sql.append("FLocationID=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("MSA.FLocationID\r\n");
        sql.append("From T_DB_MaterialStorageAssign MSA\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MSA.FStorageOrgID=UT.FStorageOrgUnitID\r\n");
        sql.append("And MSA.FMaterialID=UT.FMaterialID\r\n");
        sql.append("And MSA.FWarehouseID=UT.FWarehouseID\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FLocationID Is Null\r\n");
        sql.append("And (UT.FWarehouseID Not In (\r\n");
        sql.append("Select\r\n");
        sql.append("MSA.FWarehouseID\r\n");
        sql.append("From T_DB_MaterialStorageAssign MSA\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MSA.FStorageOrgID=UT.FStorageOrgUnitID\r\n");
        sql.append("And MSA.FMaterialID=UT.FMaterialID\r\n");
        sql.append("And MSA.FIsDefaultLocation=1\r\n");
        sql.append("))\r\n");
        sql.append("And UT.FWarehouseID In (\r\n");
        sql.append("Select\r\n");
        sql.append("MSA.FWarehouseID\r\n");
        sql.append("From T_DB_MaterialStorageAssign MSA\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MSA.FStorageOrgID=UT.FStorageOrgUnitID\r\n");
        sql.append("And MSA.FMaterialID=UT.FMaterialID\r\n");
        sql.append(")\r\n");
        sql.append("And UT.FWarehouseID In (\r\n");
        sql.append("Select\r\n");
        sql.append("WH.FID\r\n");
        sql.append("From T_DB_Warehouse WH\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And WH.FHasLocation=1\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update ").append(mosTempTable).append(" UT\r\n");
        sql.append("Set\r\n");
        sql.append("FLocationID=(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("L.FID\r\n");
        sql.append("From T_DB_Location L\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And L.FWarehouseID=UT.FWarehouseID\r\n");
        sql.append("And L.FNumber='*'\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FLocationID Is Null\r\n");
        sql.append("And UT.FWarehouseID In (\r\n");
        sql.append("Select\r\n");
        sql.append("WH.FID\r\n");
        sql.append("From T_DB_Warehouse WH\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And WH.FHasLocation=1\r\n");
        sql.append(")\r\n");
        sql.append("And UT.FWarehouseID In (\r\n");
        sql.append("Select\r\n");
        sql.append("L.FWarehouseID\r\n");
        sql.append("From T_DB_Location L\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And L.FNumber='*'\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
    }

    protected void updateProjectTask(Context ctx, Map param) throws BOSException {
        List newMOIDList;
        List list = param.containsKey("NewMOIDList") ? (param.get("NewMOIDList") == null ? null : (param.get("NewMOIDList") instanceof List ? (List)param.get("NewMOIDList") : null)) : (newMOIDList = null);
        if (newMOIDList == null) {
            return;
        }
        if (newMOIDList.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Update T_MM_ProjectTask UT\r\n");
        sql.append("Set FActualBeginTime=(\r\n");
        sql.append("Select\r\n");
        sql.append("Min(MO.FBIZDate)\r\n");
        sql.append("From T_MM_ManufactureOrder MO\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FID In (\r\n");
        sql.append(SQLUtil.arrayToString((Object[])newMOIDList.toArray()));
        sql.append(")\r\n");
        sql.append("And MO.FProjectID=UT.FProjectID\r\n");
        sql.append("And MO.FMaterialID=UT.FMaterialID\r\n");
        sql.append("And MO.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From T_MM_ManufactureOrder MO\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And MO.FID In (\r\n");
        sql.append(SQLUtil.arrayToString((Object[])newMOIDList.toArray()));
        sql.append(")\r\n");
        sql.append("And MO.FProjectID=UT.FProjectID\r\n");
        sql.append("And MO.FMaterialID=UT.FMaterialID\r\n");
        sql.append("And MO.FMPSID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append(")\r\n");
        sql.append("And UT.FFeedbackModeID='8RJ1z1oESdOXmsnCpkmCeppMH64='\r\n");
        sql.append("And Ut.FTaskTypeID='").append("uxqG1JcyTNKWqD8KTZatKppMH64=").append("'\r\n");
        sql.append("And UT.FBaseStatus=").append(5).append("\r\n");
        this.executeSQL(ctx, sql.toString());
    }

    protected void updateTechnicsEntryTime(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        if (param.containsKey("ScheduleTempTableName")) {
            sql.append("Update T_MM_MFTOrderTechnics UT\r\n");
            sql.append("Set (\r\n");
            sql.append("FEarlistWOKTime,\r\n");
            sql.append("FLastWorkTime,\r\n");
            sql.append("FEarlistCMPTime,\r\n");
            sql.append("FLastCMPTime\r\n");
            sql.append(")\r\n");
            sql.append("=\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("ST.FStartTime \"FEarlistWOKTime\",\r\n");
            sql.append("ST.FStartTime \"FLastWorkTime\",\r\n");
            sql.append("ST.FFinishTime \"FEarlistCMPTime\",\r\n");
            sql.append("ST.FFinishTime \"FLastCMPTime\"\r\n");
            sql.append("From ").append(param.get("ScheduleTempTableName").toString()).append(" ST\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And ST.FOperationID=UT.FOperationID\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FID In (\r\n");
            sql.append("Select\r\n");
            sql.append("MOTE.FID\r\n");
            sql.append("From T_MM_ManufactureOrder MO\r\n");
            sql.append("Inner Join T_MM_MFTOrderTechnics MOTE On MOTE.FParentID=MO.FID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MO.FSourceBillID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
            sql.append("And IsNull(MO.FBaseStatus,0) In (\r\n");
            sql.append(0).append(",\r\n");
            sql.append(1).append(",\r\n");
            sql.append(2).append(",\r\n");
            sql.append(4).append("\r\n");
            sql.append(")\r\n");
            sql.append("And IsNull(MOTE.FBaseStatus,0) In (\r\n");
            sql.append(0).append(",\r\n");
            sql.append(1).append(",\r\n");
            sql.append(2).append(",\r\n");
            sql.append(4).append("\r\n");
            sql.append(")\r\n");
            sql.append(")\r\n");
            sql.append("And UT.FOperationID In (\r\n");
            sql.append("Select\r\n");
            sql.append("T.FOperationID\r\n");
            sql.append("From ").append(param.get("ScheduleTempTableName").toString()).append(" T\r\n");
            sql.append(")\r\n");
            this.executeSQL(ctx, sql.toString());
        }
        sql.setLength(0);
        sql.append("Update T_MM_ManufactureOrder\r\n");
        sql.append("Set FPlanBeginDate=(\r\n");
        sql.append("Select\r\n");
        sql.append("Min(MOT.FEarlistWOKTime)\r\n");
        sql.append("From T_MM_MFTOrderTechnics MOT\r\n");
        sql.append("Where\r\n");
        sql.append("MOT.FParentID=T_MM_ManufactureOrder.FID\r\n");
        sql.append("),\r\n");
        sql.append("FPlanEndDate=(\r\n");
        sql.append("Select\r\n");
        sql.append("Max(MOT.FEarlistCMPTime)\r\n");
        sql.append("From T_MM_MFTOrderTechnics MOT\r\n");
        sql.append("Where\r\n");
        sql.append("MOT.FParentID=T_MM_ManufactureOrder.FID\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And FSourceBillID='").append(param.get("MasterProductionScheduleID").toString()).append("'\r\n");
        sql.append("And IsNull(FBaseStatus,0) In (\r\n");
        sql.append(0).append(",\r\n");
        sql.append(1).append(",\r\n");
        sql.append(2).append(",\r\n");
        sql.append(4).append("\r\n");
        sql.append(")\r\n");
        this.executeSQL(ctx, sql.toString());
    }

    protected void updateTempTableQTY(Context ctx, Map param) throws BOSException {
        List allChildMPSIDList = param == null ? null : (param.containsKey("AllChildMPSIDList") ? (param.get("AllChildMPSIDList") == null ? null : (param.get("AllChildMPSIDList") instanceof List ? (List)param.get("AllChildMPSIDList") : null)) : null);
        String mpsID = param.get("MasterProductionScheduleID").toString();
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + param.get("MergeTempTableName") + " T\r\n");
        sql.append("Set\r\n");
        sql.append("FQTY=IsNull(FQTY,0) - IsNull((\r\n");
        sql.append("Select\r\n");
        sql.append("Sum(M.FQty)\r\n");
        sql.append("From T_MM_ManufactureOrder M\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        if (allChildMPSIDList != null && allChildMPSIDList.size() > 0) {
            if (!allChildMPSIDList.contains(mpsID)) {
                allChildMPSIDList.add(mpsID);
            }
            sql.append("And M.FSourceBillID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])allChildMPSIDList.toArray())).append("\r\n");
            sql.append(")\r\n");
        } else {
            sql.append("And M.FSourceBillID='").append(mpsID).append("'\r\n");
        }
        sql.append("And M.FStorageORGUnitID=T.FStorageOrgUnitID\r\n");
        sql.append("And M.FMaterialID=T.FMaterialID\r\n");
        sql.append("And M.FProjectID=T.FProjectID\r\n");
        sql.append("And M.FTrackID=T.FTraceID\r\n");
        sql.append("And M.FBOMID=T.FBOMID\r\n");
        sql.append("),0)\r\n");
        sql.append("Where\r\n");
        sql.append("IsNull(T.FDeleted,0)=0\r\n");
        this.executeSQL(ctx, sql.toString());
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        MasterProductionScheduleInfo info = (MasterProductionScheduleInfo)objectValue;
        if (info != null) {
            BOSUuid uuid;
            BomCollection c = this.getBomByKPPM(ctx, info.getTrace().getId().toString(), info.getStorageOrgUnit().getId().toString(), info.getProduct().getId().toString(), info.getProject().getId().toString());
            if (c != null && c.size() > 0) {
                info.setBom(c.get(0));
            }
            if ((uuid = info.getId()) != null) {
                String sql = "select * from ct_ps_masterproductionschedule a where a.fid='" + uuid.toString() + "'";
                IRowSet rowset = SqlExcFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql);
                try {
                    if (rowset != null && !rowset.next()) {
                        info.setId(null);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        super._handleAfterTransform(ctx, action, objectValue);
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws BOSException, EASBizException {
        MasterProductionScheduleCollection _collection = (MasterProductionScheduleCollection)collection;
        if (_collection != null) {
            for (int n = 0; n < _collection.size(); ++n) {
                BOSUuid uuid;
                MasterProductionScheduleInfo info = _collection.get(n);
                BomCollection c = this.getBomByKPPM(ctx, info.getTrace().getId().toString(), info.getStorageOrgUnit().getId().toString(), info.getProduct().getId().toString(), info.getProject().getId().toString());
                if (c != null && c.size() > 0) {
                    info.setBom(c.get(0));
                }
                if ((uuid = info.getId()) == null) continue;
                String sql = "select * from ct_ps_masterproductionschedule a where a.fid='" + uuid.toString() + "'";
                IRowSet rowset = SqlExcFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql);
                try {
                    if (rowset == null || rowset.next()) continue;
                    info.setId(null);
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        super._handleAfterTransform(ctx, action, collection);
    }

    private BomCollection getBomByKPPM(Context ctx, String traceID, String storageOrgUnitID, String productID, String projectID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        sql.setLength(0);
        sql.append("select\r\n");
        sql.append("h.fid\r\n");
        sql.append("from t_mm_bom h\r\n");
        sql.append("inner join t_mm_bomentry d on d.fparentid=h.fid\r\n");
        sql.append("inner join t_mm_tracknumber btn on btn.fid=d.cfbegincarnoid\r\n");
        sql.append("inner join t_mm_tracknumber etn on etn.fid=d.cfendcarnoid\r\n");
        sql.append("inner join t_mm_tracknumber tn on tn.fid='" + traceID + "'\r\n");
        sql.append("where\r\n");
        sql.append("h.fbomtype=50\r\n");
        sql.append("and h.fstorageorgunitid='" + storageOrgUnitID + "'\r\n");
        sql.append("and h.fmaterialid='" + productID + "'\r\n");
        sql.append("and h.fprojectid='" + projectID + "'\r\n");
        sql.append("and btn.fnumber<=tn.fnumber\r\n");
        sql.append("and etn.fnumber>=tn.fnumber\r\n");
        sql.append("and h.fbasestatus=4\r\n");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        view.setFilter(filterInfo);
        BomCollection boms = BomFactory.getLocalInstance((Context)ctx).getBomCollection(view);
        return boms;
    }
}

