/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.ps.app;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IssuePriorityEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.app.MaterialControllerBean;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.RITypeEnum;
import com.kingdee.eas.basedata.scm.im.inv.RecIssueTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.excel.json.JSONUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.industry.emm.basedata.LocationDefinedFactory;
import com.kingdee.eas.industry.emm.basedata.LocationDefinedInfo;
import com.kingdee.eas.industry.emm.common.util.TransactionTypeUtils;
import com.kingdee.eas.industry.emm.mm.ps.DistributeBillVO;
import com.kingdee.eas.industry.emm.mm.ps.DistributeStatusEnum;
import com.kingdee.eas.industry.emm.mm.ps.app.AbstractMasterProductionScheduleExtFacadeControllerBean;
import com.kingdee.eas.industry.emm.mm.ps.app.MasterProductionScheduleExtCTL;
import com.kingdee.eas.industry.emm.mo.EMMManufactureOrderEntrysGenFacadeFactory;
import com.kingdee.eas.industry.emm.pm.SqlExecuteFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderMappingFacadeFactory;
import com.kingdee.eas.industry.emm.scm.im.inv.DCDeliveryBillEntryCollection;
import com.kingdee.eas.industry.emm.scm.im.inv.DCDeliveryBillEntryFactory;
import com.kingdee.eas.industry.emm.scm.im.inv.DCDeliveryBillEntryInfo;
import com.kingdee.eas.industry.emm.scm.im.inv.IDCDeliveryBillEntry;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.PBOMEntryFactory;
import com.kingdee.eas.mm.basedata.PBOMEntryInfo;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.WorkCenterCollection;
import com.kingdee.eas.mm.basedata.WorkCenterFactory;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.DeliveryPlanSingletonFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.OrderStockTransferTypeEnum;
import com.kingdee.eas.mm.mo.PickTypeEnum;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MasterProductionScheduleExtFacadeControllerBean
extends AbstractMasterProductionScheduleExtFacadeControllerBean {
    private static final long serialVersionUID = -6674581620166898001L;
    private String RESURL = "com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource";
    private String MANUFACTRUEORDER = " select b.fid FID,a.fid ENTRYID from T_MM_MFTOrderTechnics a left join T_MM_ManufactureOrder b on a.fparentid = b.fid  left join t_mm_mftorderstock c on a.foperationno = c.foperationno and a.fparentid = c.fparentid  where #PRODUCEORG# and #PROJECT# and #TRACKNUMBER# and #OPERATION# and #WORKCENTER# and #STATION#  AND a.FBASESTATUS in (5,8,90,10,11,12,13,14,15,16,17,18) and c.fdemandtime between ? and ? ";
    private static final String CALCUTEBOMSTATUS = "32";
    private static final String UNCALCUTEBOMSTATUS = "16";
    private static final String REMARK = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0023");
    private static final String queryPBOM = "Select pd.fmaterialid, pd.fconsumequota * h.fqty as fgxbomqty,pd.fbomitemid,pd.fid fid,'PBOM' as ftype,h.ftrackid trackid,0 as fblqty  from t_mm_manufactureorder h inner join t_mm_mftordertechnics d on h.fid = d.fparentid  inner join t_mm_pbom ph on ph.froutingid = h.froutingid and ph.fprojectid = h.fprojectid and ph.fbomid = h.fbomid  inner join t_mm_standardrooting sh on sh.fid = h.froutingid  inner join t_mm_materialrwp sd on sd.fparentid = sh.fmaterialrootingid and sd.fwpseq = d.foperationno  inner join t_mm_pbomentry pd on pd.fparentid = ph.fid and pd.froutingitemid = sd.fid  left outer join t_mm_tracknumber t1 on t1.fid = h.ftrackid  left outer join t_mm_tracknumber bt on bt.fid = pd.fstraceid  left outer join t_mm_tracknumber et on et.fid = pd.fetraceid  where d.fid in (#ENTRYID#) and bt.fnumber <= t1.fnumber and et.fnumber >= t1.fnumber ";
    private static final String querySTOCK = "Select sd.fmaterialid,0 as fgxbomqty,sd.fbomentryid,'' fid,'STOCK' as ftype,h.ftrackid trackid,sd.fplannedqty as fblqty  from t_mm_manufactureorder h inner join t_mm_mftordertechnics d on h.fid = d.fparentid inner join t_mm_mftorderstock sd  on sd.fparentid = h.fid and sd.foperationno = d.foperationno where d.fid in (#ENTRYID#)";
    private static final String querySTOCKID = "Select sd.fid FID,h.fid orderid  from t_mm_manufactureorder h inner join t_mm_mftordertechnics d on h.fid = d.fparentid inner join t_mm_mftorderstock sd  on sd.fparentid = h.fid and sd.foperationno = d.foperationno where d.fid in (#ENTRYID#) and d.FBASESTATUS in (5,8,90,10,11,12,13,14,15,16,17,18,20,21,22,23,24,26)";
    private static final String unionQuery = " Select fmaterialid cfmaterialid,trackid,sum(fgxbomqty) as fgxbomqty,fbomitemid,max(fid) fid,sum(fblqty) as fblqty from (Select pd.fmaterialid, pd.fconsumequota * h.fqty as fgxbomqty,pd.fbomitemid,pd.fid fid,'PBOM' as ftype,h.ftrackid trackid,0 as fblqty  from t_mm_manufactureorder h inner join t_mm_mftordertechnics d on h.fid = d.fparentid  inner join t_mm_pbom ph on ph.froutingid = h.froutingid and ph.fprojectid = h.fprojectid and ph.fbomid = h.fbomid  inner join t_mm_standardrooting sh on sh.fid = h.froutingid  inner join t_mm_materialrwp sd on sd.fparentid = sh.fmaterialrootingid and sd.fwpseq = d.foperationno  inner join t_mm_pbomentry pd on pd.fparentid = ph.fid and pd.froutingitemid = sd.fid  left outer join t_mm_tracknumber t1 on t1.fid = h.ftrackid  left outer join t_mm_tracknumber bt on bt.fid = pd.fstraceid  left outer join t_mm_tracknumber et on et.fid = pd.fetraceid  where d.fid in (#ENTRYID#) and bt.fnumber <= t1.fnumber and et.fnumber >= t1.fnumber  union Select sd.fmaterialid,0 as fgxbomqty,sd.fbomentryid,'' fid,'STOCK' as ftype,h.ftrackid trackid,sd.fplannedqty as fblqty  from t_mm_manufactureorder h inner join t_mm_mftordertechnics d on h.fid = d.fparentid inner join t_mm_mftorderstock sd  on sd.fparentid = h.fid and sd.foperationno = d.foperationno where d.fid in (#ENTRYID#)) group by fmaterialid,fbomitemid,trackid ";

    @Override
    protected void _regenerateMOS(Context ctx, String orderentryprocessids) throws BOSException, EASBizException {
        String sql = unionQuery.replaceAll("#ENTRYID#", "'" + orderentryprocessids + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> stockpkList = new ArrayList<String>();
        try {
            while (rs.next()) {
                String materialid = rs.getString("CFMATERIALID");
                String bomitemid = rs.getString("FBOMITEMID");
                String pbomid = rs.getString("FID");
                String trackid = rs.getString("trackid");
                BigDecimal fgxbomqty = rs.getBigDecimal("FGXBOMQTY");
                BigDecimal fblqty = rs.getBigDecimal("FBLQTY");
                HashMap<String, Object> infoMap = new HashMap<String, Object>();
                infoMap.put("PROCESSID", orderentryprocessids);
                infoMap.put("MATERIALID", materialid);
                infoMap.put("BOMENTRYID", bomitemid);
                infoMap.put("TRACKID", trackid);
                infoMap.put("QTY", fgxbomqty);
                infoMap.put("BLQTY", fblqty);
                infoMap.put("PBOMENTRYID", pbomid);
                String scrapRatioSql = " select a.fscrapratio from t_mm_bomentry a where fid = ? ";
                IRowSet rsBomEntry = DbUtil.executeQuery((Context)ctx, (String)scrapRatioSql, (Object[])new Object[]{bomitemid});
                BigDecimal scrapratio = BigDecimal.ZERO;
                if (rsBomEntry.next()) {
                    scrapratio = rsBomEntry.getBigDecimal("fscrapratio");
                }
                if (BigDecimal.ZERO.compareTo(fblqty) == 0 && fgxbomqty.compareTo(BigDecimal.ZERO) == 1) {
                    this.addStock(ctx, infoMap, stockpkList, scrapratio);
                } else if (fblqty.compareTo(BigDecimal.ZERO) > 0 && fgxbomqty.compareTo(fblqty) < 0) {
                    this.updateStock(ctx, infoMap, true, stockpkList, scrapratio);
                } else if (fblqty.compareTo(BigDecimal.ZERO) > 0 && fgxbomqty.compareTo(fblqty) > 0) {
                    this.updateStock(ctx, infoMap, false, stockpkList, scrapratio);
                }
                this.delRequestMaterialByStock(ctx, infoMap, stockpkList);
            }
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0024"));
        }
    }

    protected void _regenerateMOSExt(Context ctx, String orderentryprocessids, List<String> stockpkList) throws BOSException, EASBizException {
        String sql = unionQuery.replaceAll("#ENTRYID#", "'" + orderentryprocessids + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String materialid = rs.getString("CFMATERIALID");
                String bomitemid = rs.getString("FBOMITEMID");
                String pbomid = rs.getString("FID");
                BigDecimal fgxbomqty = rs.getBigDecimal("FGXBOMQTY");
                BigDecimal fblqty = rs.getBigDecimal("FBLQTY");
                HashMap<String, Object> infoMap = new HashMap<String, Object>();
                infoMap.put("PROCESSID", orderentryprocessids);
                infoMap.put("MATERIALID", materialid);
                infoMap.put("BOMENTRYID", bomitemid);
                infoMap.put("QTY", fgxbomqty);
                infoMap.put("BLQTY", fblqty);
                infoMap.put("PBOMENTRYID", pbomid);
                String scrapRatioSql = " select a.fscrapratio from t_mm_bomentry a where fid = ? ";
                IRowSet rsBomEntry = DbUtil.executeQuery((Context)ctx, (String)scrapRatioSql, (Object[])new Object[]{bomitemid});
                BigDecimal scrapratio = BigDecimal.ZERO;
                if (rsBomEntry.next()) {
                    scrapratio = rsBomEntry.getBigDecimal("fscrapratio");
                }
                if (BigDecimal.ZERO.compareTo(fblqty) == 0 && fgxbomqty.compareTo(BigDecimal.ZERO) == 1) {
                    this.addStock(ctx, infoMap, stockpkList, scrapratio);
                } else if (fblqty.compareTo(BigDecimal.ZERO) > 0 && fgxbomqty.compareTo(fblqty) < 0) {
                    this.updateStock(ctx, infoMap, true, stockpkList, scrapratio);
                } else if (fblqty.compareTo(BigDecimal.ZERO) > 0 && fgxbomqty.compareTo(fblqty) > 0) {
                    this.updateStock(ctx, infoMap, false, stockpkList, scrapratio);
                }
                this.delRequestMaterialByStock(ctx, infoMap, stockpkList);
            }
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0024"));
        }
    }

    private void delRequestMaterialByStock(Context ctx, Map<String, Object> mapValue, List<String> stockpkList) throws BOSException, EASBizException {
        String processid = (String)mapValue.get("PROCESSID");
        String sql = " Select sd.fid as fid,sd.fqty as fqty from t_mm_manufactureorder h inner join t_mm_mftordertechnics d  on h.fid = d.fparentid inner join t_mm_mftorderstock sd on sd.fparentid = h.fid and sd.foperationno = d.foperationno  where d.fid in (#ENTRYID#) order by sd.factissueqty,sd.fdemandtime desc ";
        sql = sql.replaceAll("#ENTRYID#", "'" + processid + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String tmpsql;
                IRowSet _rs;
                String stockid = rs.getString("fid");
                BigDecimal fqty = rs.getBigDecimal("fqty");
                if (BigDecimal.ZERO.compareTo(fqty) != 0 || (_rs = DbUtil.executeQuery((Context)ctx, (String)(tmpsql = " select count(*) from t_im_materialreqbillentry where fcorebillentryid = '" + stockid + "'"))).size() != 0) continue;
                DbUtil.execute((Context)ctx, (String)("delete from t_mm_mftorderstock where fid = '" + stockid + "'"));
                if (!stockpkList.contains(stockid)) continue;
                stockpkList.remove(stockid);
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void updateStock(Context ctx, Map<String, Object> mapValue, boolean isCompare, List<String> stockpkList, BigDecimal scrapratio) throws BOSException, EASBizException {
        String processid = (String)mapValue.get("PROCESSID");
        String materialid = (String)mapValue.get("MATERIALID");
        BigDecimal qty = (BigDecimal)mapValue.get("QTY");
        BigDecimal blqty = (BigDecimal)mapValue.get("BLQTY");
        ManufactureOrderTechnicsInfo tinfo = (ManufactureOrderTechnicsInfo)ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx).getCoreBillEntryBaseInfo((IObjectPK)new ObjectUuidPK(processid));
        ManufactureOrderInfo orderinfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(tinfo.getParent().getId().toString()));
        boolean considerlossRatio = orderinfo.getTransactionType().isIsConsiderLossRatio();
        BigDecimal zeroQty = BigDecimal.ZERO;
        BigDecimal sumQty = BigDecimal.ZERO;
        BigDecimal negativeValue = new BigDecimal(-1);
        sumQty = isCompare ? blqty.subtract(qty) : qty.subtract(blqty);
        String sql = " Select sd.fid as fid,sd.fplannedqty as fqty,h.fqty as orderqty from t_mm_manufactureorder h inner join t_mm_mftordertechnics d  on h.fid = d.fparentid inner join t_mm_mftorderstock sd on sd.fparentid = h.fid and sd.foperationno = d.foperationno  where d.fid in (#ENTRYID#) and sd.fmaterialid = '" + materialid + "' order by sd.factissueqty,sd.fdemandtime desc ";
        sql = sql.replaceAll("#ENTRYID#", "'" + processid + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (isCompare) {
                while (rs.next() && sumQty.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal fqty = rs.getBigDecimal("fqty");
                    String stockid = rs.getString("fid");
                    BigDecimal orderqty = rs.getBigDecimal("orderqty");
                    BigDecimal unitqty = qty.divide(orderqty);
                    BigDecimal tmpSumQty = sumQty.subtract(fqty);
                    if (tmpSumQty.compareTo(BigDecimal.ZERO) > 0) {
                        String tmpsql = "update t_mm_mftorderstock set fqty=" + zeroQty + " , fbaseqty=" + zeroQty + " , fplannedqty=" + zeroQty + " , fplannedbaseqty=" + zeroQty + ",funitQty=" + unitqty + ",funitBaseQty=" + unitqty + " where fid='" + stockid + "'";
                        DbUtil.execute((Context)ctx, (String)tmpsql);
                        stockpkList.add(stockid);
                        sumQty = tmpSumQty;
                        continue;
                    }
                    BigDecimal plannedbaseqty = BigDecimal.ZERO;
                    plannedbaseqty = considerlossRatio ? qty.divide(orderinfo.getQty()).multiply(scrapratio.add(new BigDecimal(1))) : tmpSumQty.multiply(negativeValue);
                    String tmpsql = "update t_mm_mftorderstock set fqty=" + tmpSumQty.multiply(negativeValue) + " , fbaseqty=" + tmpSumQty.multiply(negativeValue) + " , fplannedqty=" + tmpSumQty.multiply(negativeValue) + " , fplannedbaseqty=" + tmpSumQty.multiply(negativeValue) + ",funitQty=" + unitqty + ",funitBaseQty=" + unitqty + " where fid='" + stockid + "'";
                    DbUtil.execute((Context)ctx, (String)tmpsql);
                    stockpkList.add(stockid);
                    sumQty = BigDecimal.ZERO;
                }
            } else if (rs.next()) {
                BigDecimal fqty = rs.getBigDecimal("fqty");
                String stockid = rs.getString("fid");
                BigDecimal orderqty = rs.getBigDecimal("orderqty");
                BigDecimal unitqty = qty.divide(orderqty);
                String tmpsql = "update t_mm_mftorderstock set fqty=" + sumQty.add(fqty) + " , fbaseqty=" + sumQty.add(fqty) + " , fplannedqty=" + sumQty.add(fqty) + " , fplannedbaseqty=" + sumQty.add(fqty) + ",funitQty=" + unitqty + ",funitBaseQty=" + unitqty + " where fid='" + stockid + "'";
                DbUtil.execute((Context)ctx, (String)tmpsql);
                stockpkList.add(stockid);
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private ManufactureOrderStockInfo getDefaultAddStock() {
        ManufactureOrderStockInfo sinfo = new ManufactureOrderStockInfo();
        sinfo.setReplaceMaterial(null);
        sinfo.setAssistProperty(null);
        sinfo.setAssistUnit(null);
        sinfo.setReasonCode(null);
        sinfo.setWarehouse(null);
        sinfo.setReceiptStock(null);
        sinfo.setCombinationStockID(null);
        sinfo.setLocation(null);
        sinfo.setAssociateQty(BigDecimal.ZERO);
        sinfo.setLossRatio(BigDecimal.ZERO);
        sinfo.setExtraRatio(BigDecimal.ZERO);
        sinfo.setLackRatio(BigDecimal.ZERO);
        sinfo.setReplaceRatio(BigDecimal.ZERO);
        sinfo.setUnitReplaceQty(BigDecimal.ZERO);
        sinfo.setActMoveQty(BigDecimal.ZERO);
        sinfo.setAlrMoveQty(BigDecimal.ZERO);
        sinfo.setLossQty(BigDecimal.ZERO);
        sinfo.setLossBaseQty(BigDecimal.ZERO);
        sinfo.setActIssueBaseQty(BigDecimal.ZERO);
        sinfo.setActIssueQty(BigDecimal.ZERO);
        sinfo.setActLossQty(BigDecimal.ZERO);
        sinfo.setActLossBaseQty(BigDecimal.ZERO);
        sinfo.setRejectedQty(BigDecimal.ZERO);
        sinfo.setRejectedBaseQty(BigDecimal.ZERO);
        sinfo.setFeedingQty(BigDecimal.ZERO);
        sinfo.setFeedingBaseQty(BigDecimal.ZERO);
        sinfo.setScrapQty(BigDecimal.ZERO);
        sinfo.setScrapBaseQty(BigDecimal.ZERO);
        sinfo.setWipQty(BigDecimal.ZERO);
        sinfo.setWipBaseQty(BigDecimal.ZERO);
        sinfo.setUnitQty(BigDecimal.ZERO);
        sinfo.setUnitBaseQty(BigDecimal.ZERO);
        sinfo.setMaterialScrapQty(BigDecimal.ZERO);
        sinfo.setMaterialScrapBaseQty(BigDecimal.ZERO);
        sinfo.setMaterialFeedingQty(BigDecimal.ZERO);
        sinfo.setMaterialFeedingBaseQty(BigDecimal.ZERO);
        sinfo.setUnIssueQty(BigDecimal.ZERO);
        sinfo.setUnIssueBaseQty(BigDecimal.ZERO);
        sinfo.setToStoreQty(BigDecimal.ZERO);
        sinfo.setToStoreBaseQty(BigDecimal.ZERO);
        sinfo.setOriginalPlanQty(BigDecimal.ZERO);
        sinfo.setOriginalPlanBaseQty(BigDecimal.ZERO);
        sinfo.setTotalReceiptQty(BigDecimal.ZERO);
        sinfo.setTotalReceiptBaseQty(BigDecimal.ZERO);
        sinfo.setUnReceiptQty(BigDecimal.ZERO);
        sinfo.setUnReceiptBaseQty(BigDecimal.ZERO);
        sinfo.setTotalDirectReceiveQty(BigDecimal.ZERO);
        sinfo.setTotalDirectReceiveBaseQty(BigDecimal.ZERO);
        sinfo.setTotalDSTransferQty(BigDecimal.ZERO);
        sinfo.setTotalDSTransferBaseQty(BigDecimal.ZERO);
        sinfo.setReplaceGroupFlag(0);
        sinfo.setReplacePriority(0);
        sinfo.setMatReplaceType(null);
        sinfo.setIsReplaced(false);
        sinfo.setActueIssueTime(null);
        return sinfo;
    }

    private void addStock(Context ctx, Map<String, Object> valueMap, List<String> stockpkList, BigDecimal scrapratio) throws BOSException, EASBizException {
        String processid = (String)valueMap.get("PROCESSID");
        String pbomentryid = (String)valueMap.get("PBOMENTRYID");
        String bomentryid = (String)valueMap.get("BOMENTRYID");
        String materialid = (String)valueMap.get("MATERIALID");
        BigDecimal qty = (BigDecimal)valueMap.get("QTY");
        ManufactureOrderTechnicsInfo tinfo = (ManufactureOrderTechnicsInfo)ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx).getCoreBillEntryBaseInfo((IObjectPK)new ObjectUuidPK(processid));
        MaterialInfo materialinfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialid));
        PBOMEntryInfo info = PBOMEntryFactory.getLocalInstance((Context)ctx).getPBOMEntryInfo((IObjectPK)new ObjectUuidPK(pbomentryid));
        BomEntryInfo bomentry = BomEntryFactory.getLocalInstance((Context)ctx).getBomEntryInfo((IObjectPK)new ObjectUuidPK(bomentryid));
        ManufactureOrderInfo orderinfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(tinfo.getParent().getId().toString()));
        boolean considerlossRatio = orderinfo.getTransactionType().isIsConsiderLossRatio();
        ManufactureOrderStockInfo sinfo = this.getDefaultAddStock();
        sinfo.setParent(orderinfo);
        sinfo.setMaterial(materialinfo);
        sinfo.setUnit(materialinfo.getBaseUnit());
        sinfo.setBaseUnit(materialinfo.getBaseUnit());
        sinfo.setOperation(info.getRoutingItem().getOperation());
        sinfo.setStorageOrgUnit(bomentry.getSupplyOrgUnit());
        sinfo.setReceiptStroageOrgUnit(orderinfo.getStorageOrgUnit());
        sinfo.setWorkcenter(tinfo.getWorkcenter());
        sinfo.setBomEntryID(bomentry.getId().toString());
        sinfo.setSourceBillEntryId(pbomentryid);
        sinfo.setUnitQty(qty);
        sinfo.setUnitBaseQty(qty);
        sinfo.setQty(qty.multiply(orderinfo.getQty()));
        sinfo.setBaseQty(qty.multiply(orderinfo.getQty()));
        if (considerlossRatio) {
            sinfo.setPlannedBaseQty(qty.multiply(orderinfo.getQty()).multiply(scrapratio.add(new BigDecimal(1))));
            sinfo.setPlannedQty(qty.multiply(orderinfo.getQty()).multiply(scrapratio.add(new BigDecimal(1))));
        } else {
            sinfo.setPlannedBaseQty(qty.multiply(orderinfo.getQty()));
            sinfo.setPlannedQty(qty.multiply(orderinfo.getQty()));
        }
        sinfo.setDemandTime(orderinfo.getPlanBeginDate());
        sinfo.setBlkSize(bomentry.getBlkSize());
        sinfo.setRemark(REMARK);
        sinfo.setPickDept(orderinfo.getAdminOrgUnit());
        sinfo.setSeq(info.getSeq());
        int linesql = info.getSeq() * 10;
        sinfo.setLineSeq(String.valueOf(linesql));
        int basestatus = orderinfo.getBaseStatus().getValue();
        if (basestatus <= 2) {
            sinfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        } else {
            sinfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
        }
        sinfo.setTransferType(this.getTransferType(ctx, bomentry, orderinfo));
        sinfo.setProvideType(this.getProvideType());
        sinfo.setPickType(this.getPickType());
        sinfo.setNewnetWeight(bomentry.getNetWeight());
        sinfo.setOperationNo(tinfo.getOperationNo());
        sinfo.setIssueMode(bomentry.getIssMode());
        sinfo.setIsBackflush(bomentry.isIsBackFlush());
        sinfo.setScrapExpr(0);
        sinfo.setLossRatio(scrapratio);
        sinfo.setLossQty(sinfo.getPlannedQty().subtract(sinfo.getQty()));
        sinfo.setIsQtyLimit(false);
        sinfo.setIsStockAllot(bomentry.isIsStockTransfer());
        sinfo.setIsMustReq(info.isIsMustReq());
        sinfo.setIslineStorehouse(false);
        sinfo.setIsOwnObject(info.isIsOwnObject());
        ManufactureOrderStockFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)sinfo);
        stockpkList.add(sinfo.getId().toString());
    }

    private PickTypeEnum getPickType() {
        return null;
    }

    private MaterialProvideTypeEnum getProvideType() {
        return MaterialProvideTypeEnum.SPANORGPROVIDE;
    }

    private OrderStockTransferTypeEnum getTransferType(Context ctx, BomEntryInfo bomentry, ManufactureOrderInfo orderinfo) throws BOSException, EASBizException {
        boolean isStockTransfer = bomentry.isIsStockTransfer();
        String transtorageUnit = bomentry.getTransferOrgUnit().getId().toString();
        String orderstorageUnit = orderinfo.getStorageOrgUnit().getId().toString();
        String[] orgIDArray = new String[]{transtorageUnit, orderstorageUnit};
        Map coutMap = PMRPPlannedOrderMappingFacadeFactory.getLocalInstance((Context)ctx).getCouOrgUnit(orgIDArray);
        String tranStorageToFinance = (String)coutMap.get(transtorageUnit);
        String orderStroageToFinance = (String)coutMap.get(orderstorageUnit);
        if (isStockTransfer && transtorageUnit != null) {
            if (transtorageUnit.equals(orderstorageUnit)) {
                return OrderStockTransferTypeEnum.WAREHOUSE;
            }
            if (tranStorageToFinance != null && orderStroageToFinance != null) {
                if (tranStorageToFinance.equals(orderStroageToFinance)) {
                    return OrderStockTransferTypeEnum.STORAGE;
                }
                return OrderStockTransferTypeEnum.FINANCE;
            }
            return OrderStockTransferTypeEnum.STORAGE;
        }
        return null;
    }

    protected ManufactureOrderStockCollection _calcuteDistributePlan(Context ctx, String condition) throws BOSException {
        ManufactureOrderStockCollection coll = new ManufactureOrderStockCollection();
        HashMap mapValue = JSONUtils.convertJsonToObject((String)condition);
        IRowSet rs = this.filterManufactureOrder(ctx, mapValue);
        String calcutebom = (String)mapValue.get("CALCUTEBOM");
        ArrayList<String> stockpkList = new ArrayList();
        if (CALCUTEBOMSTATUS.equals(calcutebom)) {
            this.recaluteOrderStock(ctx, rs);
        }
        stockpkList = this.filterStockList(ctx, mapValue);
        try {
            coll = this.calcuteDistributeQtyNew(ctx, stockpkList, mapValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0025") + e);
        }
        return coll;
    }

    protected String createEntryIdTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOTMergeTempTable(\r\n");
        sql.append("FEntryID VARCHAR(44) Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FEntryID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "IsNull(FEntryID,'Null')", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String insertEntryIDTempTableSQL(String mergeMOTTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(mergeMOTTempTable).append("(\r\n");
        sql.append("FEntryID\r\n");
        sql.append(") values (?)\r\n");
        return sql.toString();
    }

    private ManufactureOrderStockInfo createManufactureOrderStock(IRowSet rs) throws Exception {
        ManufactureOrderStockInfo stockinfo = new ManufactureOrderStockInfo();
        stockinfo.setId(BOSUuid.read((String)rs.getString("entryid")));
        stockinfo.setQty(rs.getBigDecimal("qty"));
        stockinfo.setDemandTime(rs.getTimestamp("demandtime"));
        stockinfo.setPlannedQty(rs.getBigDecimal("plannedqty"));
        stockinfo.setOperationNo(rs.getInt("operationno"));
        ManufactureOrderInfo orderinfo = new ManufactureOrderInfo();
        orderinfo.setId(BOSUuid.read((String)rs.getString("orderid")));
        ProjectInfo project = null;
        TrackNumberInfo track = null;
        if (rs.getString("projectid") != null) {
            project = new ProjectInfo();
            project.setId(BOSUuid.read((String)rs.getString("projectid")));
            project.setNumber(rs.getString("projectnumber"));
        }
        if (rs.getString("trackid") != null) {
            track = new TrackNumberInfo();
            track.setId(BOSUuid.read((String)rs.getString("trackid")));
            track.setNumber(rs.getString("tracknumber"));
        }
        orderinfo.setNumber(rs.getString("ordernumber"));
        orderinfo.setProject(project);
        orderinfo.setTrackNumber(track);
        StorageOrgUnitInfo sInfo = new StorageOrgUnitInfo();
        sInfo.setId(BOSUuid.read((String)rs.getString("storageid")));
        sInfo.setName(rs.getString("storagename"));
        orderinfo.setStorageOrgUnit(sInfo);
        stockinfo.setParent(orderinfo);
        if (rs.getString("warehouseid") != null) {
            WarehouseInfo warehouse = new WarehouseInfo();
            warehouse.setId(BOSUuid.read((String)rs.getString("warehouseid")));
            warehouse.setName(rs.getString("warehousename"));
            stockinfo.setWarehouse(warehouse);
        }
        MaterialInfo material = new MaterialInfo();
        material.setId(BOSUuid.read((String)rs.getString("materialid")));
        material.setName(rs.getString("materialname"));
        material.setNumber(rs.getString("materialnumber"));
        material.setModel(rs.getString("materialmodel"));
        MeasureUnitInfo unitinfo = new MeasureUnitInfo();
        unitinfo.setId(BOSUuid.read((String)rs.getString("unitid")));
        unitinfo.setName(rs.getString("unitname"));
        material.setBaseUnit(unitinfo);
        stockinfo.setMaterial(material);
        StorageOrgUnitInfo storagsinfo = new StorageOrgUnitInfo();
        if (rs.getString("storage2id") != null) {
            storagsinfo.setId(BOSUuid.read((String)rs.getString("storage2id")));
            storagsinfo.setName(rs.getString("storage2name"));
        } else {
            storagsinfo.setId(BOSUuid.read((String)rs.getString("storage1id")));
            storagsinfo.setName(rs.getString("storage1name"));
        }
        stockinfo.setStorageOrgUnit(storagsinfo);
        if (rs.getString("centerid") != null) {
            WorkCenterInfo workcenter = new WorkCenterInfo();
            workcenter.setId(BOSUuid.read((String)rs.getString("centerid")));
            workcenter.setName(rs.getString("centername"));
            stockinfo.setWorkcenter(workcenter);
        }
        stockinfo.put("station.name", (Object)rs.getString("cfgongwei"));
        stockinfo.put("operation.Name", (Object)rs.getString("operationname"));
        return stockinfo;
    }

    private ManufactureOrderStockCollection calcuteDistributeQtyNew(Context ctx, List<String> stockpkList, Map mapValue) throws Exception {
        ManufactureOrderStockCollection resultColls = new ManufactureOrderStockCollection();
        String status = (String)mapValue.get("DISTRIBUTESTATUS");
        String dstatus = (String)mapValue.get("DISTRIBUTEDATE");
        String motMergeTempTable = this.createEntryIdTempTable(ctx);
        String insertSql = this.insertEntryIDTempTableSQL(motMergeTempTable);
        ArrayList<Object[]> param = new ArrayList<Object[]>();
        if (stockpkList != null && stockpkList.size() > 0) {
            for (int n = 0; n < stockpkList.size(); ++n) {
                Object[] params = new Object[]{stockpkList.get(n)};
                param.add(params);
            }
        }
        DbUtil.executeBatch((Context)ctx, (String)insertSql, param);
        StringBuffer sbStr = new StringBuffer();
        sbStr.append("select stock.fid entryid,").append(" stock.fqty qty,").append(" stock.fdemandtime demandtime,").append(" stock.fplannedqty plannedqty,").append(" stock.foperationNo operationno,").append(" a.fid orderid,").append(" a.fnumber ordernumber,").append(" project.fid projectid,").append(" project.fnumber projectnumber,").append(" track.fid trackid,").append(" track.fnumber tracknumber,").append(" storage.fid storageid,").append(" storage.fname_l2 storagename,").append(" warehouse.fid warehouseid,").append(" warehouse.fname_l2 warehousename,").append(" material.fid materialid,").append(" material.fname_l2 materialname,").append(" material.fnumber materialnumber,").append(" material.fmodel materialmodel,").append(" storage1.fid storage1id,").append(" storage1.fname_l2 storage1name,").append(" storage2.fid storage2id,").append(" storage2.fname_l2 storage2name,").append(" center.fid centerid,").append(" center.fname_l2 centername,").append(" unit.fid unitid,").append(" unit.fname_l2 unitname,").append(" tech.flocationdefine cfgongwei,").append(" oper.fname_l2 operationname").append(" from t_mm_mftorderstock stock ").append(" left join t_mm_manufactureOrder a on stock.fparentid = a.fid").append(" left join t_mm_project project on a.fprojectid = project.fid").append(" left join t_mm_tracknumber track on a.ftrackid = track.fid").append(" left join t_org_storage storage on a.fstorageOrgUnitid = storage.fid").append(" left join T_DB_WAREHOUSE warehouse on stock.FWarehouseID = warehouse.FID").append(" left join t_bd_material material on stock.fmaterialid = material.fid").append(" left join t_org_storage storage1 on stock.fstorageOrgUnitid = storage1.fid").append(" left join t_org_storage storage2 on stock.fdispatchorgunitid = storage2.fid").append(" left join t_mm_workcenter center on stock.fworkcenterid = center.fid").append(" left join T_BD_MeasureUnit unit on material.fbaseunit = unit.fid").append(" left join t_mm_mftordertechnics tech on stock.fparentid = tech.fparentid and tech.foperationid = stock.foperationid ").append(" left join t_mm_operation oper on tech.foperationid = oper.fid").append(" where stock.fid in (select fentryid from ").append(motMergeTempTable).append(")");
        IRowSet entryRs = DbUtil.executeQuery((Context)ctx, (String)sbStr.toString());
        sbStr.setLength(0);
        sbStr.append(" select sum(umo.assqty) + sum(umo.qty) qty,umo.entryid entryid").append(" from (select k.FIssueQty assqty, k.fqty qty,k.fsourcebillentryid entryid").append(" from t_im_materialreqbillentry k").append(" left join t_im_materialreqbill e").append(" on e.fid = k.fparentid").append(" where k.fsourcebillentryid in (select fentryid from ").append(motMergeTempTable).append(")").append(" and (k.fbasestatus < 4 or k.fbasestatus is null)").append(" union all").append(" select 0 assqty, k.fqty qty,k.fsourcebillentryid entryid").append(" from t_im_materialreqbillentry k").append(" left join t_im_materialreqbill e").append(" on e.fid = k.fparentid").append(" where k.fsourcebillentryid in (select fentryid from ").append(motMergeTempTable).append(")").append(" and k.fbasestatus = 4) umo").append(" group by umo.entryid");
        IRowSet reqbillRs = DbUtil.executeQuery((Context)ctx, (String)sbStr.toString());
        HashMap<String, BigDecimal> reqMap = new HashMap<String, BigDecimal>();
        while (reqbillRs.next()) {
            reqMap.put(reqbillRs.getString("entryid"), reqbillRs.getBigDecimal("qty"));
        }
        while (entryRs.next()) {
            String trackid;
            ManufactureOrderStockInfo stockinfo = this.createManufactureOrderStock(entryRs);
            String corebillentryid = stockinfo.getId().toString();
            BigDecimal blbaseqty = stockinfo.getPlannedQty();
            BigDecimal qty = BigDecimal.ZERO;
            qty = reqMap.get(corebillentryid) == null ? BigDecimal.ZERO : (BigDecimal)reqMap.get(corebillentryid);
            BigDecimal unqty = blbaseqty.subtract(qty);
            if (BigDecimal.ZERO.compareTo(qty) == 0 && unqty.compareTo(BigDecimal.ZERO) > 0) {
                stockinfo.put("DISTRIBUTESTATUS", (Object)DistributeStatusEnum.UnDistribute);
            } else if (qty.compareTo(BigDecimal.ZERO) > 0 && unqty.compareTo(BigDecimal.ZERO) > 0) {
                stockinfo.put("DISTRIBUTESTATUS", (Object)DistributeStatusEnum.PartDistribute);
            } else if (qty.compareTo(blbaseqty) == 0 || unqty.compareTo(BigDecimal.ZERO) == 0) {
                stockinfo.put("DISTRIBUTESTATUS", (Object)DistributeStatusEnum.AllDistribute);
            } else if (unqty.compareTo(BigDecimal.ZERO) < 0) {
                stockinfo.put("DISTRIBUTESTATUS", (Object)DistributeStatusEnum.AllDistribute);
            } else {
                stockinfo.put("DISTRIBUTESTATUS", (Object)DistributeStatusEnum.UnAllDistribute);
            }
            String materialid = stockinfo.getMaterial().getId().toString();
            String projectid = stockinfo.getParent().getProject() == null ? null : stockinfo.getParent().getProject().getId().toString();
            String string = trackid = stockinfo.getParent().getTrackNumber() == null ? null : stockinfo.getParent().getTrackNumber().getId().toString();
            boolean isDirectMaterial = DeliveryPlanSingletonFactory.getDirectMaterialSingleton(ctx).isDirectMaterial(materialid, projectid, trackid);
            if (isDirectMaterial || !status.equals(((DistributeStatusEnum)((Object)stockinfo.get("DISTRIBUTESTATUS"))).getValue()) && !status.equals("2") || status.equals("2") && !((DistributeStatusEnum)((Object)stockinfo.get("DISTRIBUTESTATUS"))).getValue().equals("0") && !((DistributeStatusEnum)((Object)stockinfo.get("DISTRIBUTESTATUS"))).getValue().equals("1")) continue;
            String warehouseid = stockinfo.getWarehouse() == null ? null : stockinfo.getWarehouse().getId().toString();
            String locationid = stockinfo.getLocation() == null ? null : stockinfo.getLocation().getId().toString();
            BigDecimal inventroyqty = MasterProductionScheduleExtCTL.getInventory(ctx, stockinfo.getMaterial().getId().toString(), projectid, trackid, stockinfo.getStorageOrgUnit().getId().toString(), warehouseid, locationid);
            if (inventroyqty.compareTo(unqty) > 0) {
                stockinfo.put("ISDISTRIBUTE", (Object)Boolean.TRUE);
            } else {
                stockinfo.put("ISDISTRIBUTE", (Object)Boolean.FALSE);
            }
            BigDecimal inventoryCount = inventroyqty;
            if (inventoryCount.compareTo(unqty) >= 0) {
                stockinfo.put("MATERIALCOLOR", (Object)Color.GREEN);
            } else if (inventoryCount.compareTo(unqty) < 0 && inventoryCount.compareTo(BigDecimal.ZERO) > 0) {
                stockinfo.put("MATERIALCOLOR", (Object)Color.YELLOW);
            } else {
                stockinfo.put("MATERIALCOLOR", (Object)Color.RED);
            }
            MaterialInventoryInfo mixpackage = this._getInventoryInfo(ctx, stockinfo.getMaterial().getId().toString(), stockinfo.getStorageOrgUnit().getId().toString());
            stockinfo.put("MIXPACKAGE", (Object)mixpackage.getQtyMinPackage());
            stockinfo.put("BACKFLUSHWAREHOUSE", null);
            stockinfo.put("BACKFLUSHWAREHOUSEQTY", null);
            stockinfo.put("DISTRIBUTEDQTY", (Object)qty);
            stockinfo.put("UNDISTRIBUTEQTY", (Object)unqty);
            stockinfo.put("INVENTORY", (Object)inventroyqty);
            if (dstatus.equals(CALCUTEBOMSTATUS) && this.filterDistributeData(stockinfo)) continue;
            resultColls.add(stockinfo);
        }
        DeliveryPlanSingletonFactory.getDirectMaterialSingleton(ctx).clear();
        return resultColls;
    }

    private SelectorItemCollection getInventorySelectors(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("qtyMinPackage"));
        return sic;
    }

    protected MaterialInventoryInfo _getInventoryInfo(Context ctx, String matid, String ouid) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        MaterialInventoryInfo info = null;
        FilterInfo filterinfo = MaterialControllerBean.getFilterOUMaterial((Context)ctx, (String)"orgUnit.id", (String)ouid, (String)"material.id", (String)matid);
        viewInfo.setFilter(filterinfo);
        this.getInventorySelectors(viewInfo.getSelector());
        MaterialInventoryCollection con = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            for (int i = 0; i < con.size(); ++i) {
                info = con.get(i);
                if (!info.getOrgUnit().getId().toString().equals(ouid)) continue;
                return info;
            }
            return con.get(0);
        }
        return info;
    }

    private ManufactureOrderStockCollection calcuteDistributeQty(Context ctx, List<String> stockpkList, Map mapValue) throws Exception {
        String defaultStartDate;
        SimpleDateFormat _sdf;
        SimpleDateFormat sdf;
        Date requestdate2;
        ManufactureOrderStockCollection resultColls = new ManufactureOrderStockCollection();
        String status = (String)mapValue.get("DISTRIBUTESTATUS");
        String dstatus = (String)mapValue.get("DISTRIBUTEDATE");
        Date requestdate1 = mapValue.get("REQUESTDATE1") == null ? null : new Date(Long.parseLong((String)mapValue.get("REQUESTDATE1")));
        Date date = requestdate2 = mapValue.get("REQUESTDATE2") == null ? null : new Date(Long.parseLong((String)mapValue.get("REQUESTDATE2")));
        if (requestdate1 != null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
            _sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            defaultStartDate = sdf.format(requestdate1);
            defaultStartDate = defaultStartDate + " 00:00:00";
            requestdate1 = _sdf.parse(defaultStartDate);
        }
        if (requestdate2 != null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
            _sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            defaultStartDate = sdf.format(requestdate2);
            defaultStartDate = defaultStartDate + " 23:59:59";
            requestdate2 = _sdf.parse(defaultStartDate);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterinfo = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        set.addAll(stockpkList);
        filterinfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        if (requestdate1 != null) {
            filterinfo.getFilterItems().add(new FilterItemInfo("demandTime", (Object)requestdate1, CompareType.GREATER_EQUALS));
        }
        if (requestdate2 != null) {
            filterinfo.getFilterItems().add(new FilterItemInfo("demandTime", (Object)requestdate2, CompareType.LESS_EQUALS));
        }
        viewInfo.setFilter(filterinfo);
        CoreBillEntryBaseCollection coll = ManufactureOrderStockFactory.getLocalInstance((Context)ctx).getCoreBillEntryBaseCollection(viewInfo);
        for (int n = 0; n < coll.size(); ++n) {
            IRowSet _rs;
            String tracknumberid;
            String projectid;
            String warehouseid;
            ManufactureOrderStockInfo stockinfo = (ManufactureOrderStockInfo)coll.get(n);
            String corebillentryid = stockinfo.getId().toString();
            String sql = " select sum(umo.assqty)+sum(umo.qty) qty from ( select k.fqty assqty, 0 qty from t_im_materialreqbillentry k left join t_im_materialreqbill e on e.fid = k.fparentid where k.fsourcebillentryid = '" + corebillentryid + "' and (k.fbasestatus < 2 or k.fbasestatus is null)  union all select 0 assqty, k.fqty qty from t_im_materialreqbillentry k left join t_im_materialreqbill e on e.fid = k.fparentid where k.fsourcebillentryid = '" + corebillentryid + "' and k.fbasestatus = 2) umo ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            BigDecimal blbaseqty = stockinfo.getPlannedQty();
            BigDecimal qty = BigDecimal.ZERO;
            while (rs.next()) {
                qty = rs.getBigDecimal("qty") == null ? BigDecimal.ZERO : rs.getBigDecimal("qty");
            }
            BigDecimal unqty = blbaseqty.subtract(qty);
            if (BigDecimal.ZERO.compareTo(qty) == 0 && unqty.compareTo(BigDecimal.ZERO) > 0) {
                stockinfo.put("DISTRIBUTESTATUS", (Object)DistributeStatusEnum.UnDistribute);
            } else if (qty.compareTo(BigDecimal.ZERO) > 0 && unqty.compareTo(BigDecimal.ZERO) > 0) {
                stockinfo.put("DISTRIBUTESTATUS", (Object)DistributeStatusEnum.PartDistribute);
            } else if (qty.compareTo(blbaseqty) == 0 || unqty.compareTo(BigDecimal.ZERO) == 0) {
                stockinfo.put("DISTRIBUTESTATUS", (Object)DistributeStatusEnum.AllDistribute);
            } else if (unqty.compareTo(BigDecimal.ZERO) < 0) {
                stockinfo.put("DISTRIBUTESTATUS", (Object)DistributeStatusEnum.AllDistribute);
            } else {
                stockinfo.put("DISTRIBUTESTATUS", (Object)DistributeStatusEnum.UnAllDistribute);
            }
            if (!status.equals(((DistributeStatusEnum)((Object)stockinfo.get("DISTRIBUTESTATUS"))).getValue()) && !status.equals("2") || status.equals("2") && !((DistributeStatusEnum)((Object)stockinfo.get("DISTRIBUTESTATUS"))).getValue().equals("0") && !((DistributeStatusEnum)((Object)stockinfo.get("DISTRIBUTESTATUS"))).getValue().equals("1")) continue;
            String manorderid = stockinfo.getParent().getId().toString();
            ManufactureOrderInfo order = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(manorderid));
            order.setStorageOrgUnit(StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(order.getStorageOrgUnit().getId().toString())));
            stockinfo.setParent(order);
            WarehouseInfo wi = stockinfo.getWarehouse();
            MaterialInfo mi = stockinfo.getMaterial();
            mi = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId().toString()));
            if (mi.getBaseUnit() != null) {
                MeasureUnitInfo baseUnit = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(mi.getBaseUnit().getId().toString()));
                mi.setBaseUnit(baseUnit);
            }
            stockinfo.setMaterial(mi);
            StorageOrgUnitInfo si = stockinfo.getStorageOrgUnit();
            if (stockinfo.getProvideType().compareTo((Object)MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) == 0) {
                stockinfo.setStorageOrgUnit(order.getStorageOrgUnit());
            } else {
                stockinfo.setStorageOrgUnit(StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(si.getId().toString())));
            }
            String string = warehouseid = wi == null ? null : wi.getId().toString();
            if (warehouseid != null) {
                WarehouseInfo warehouse = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectUuidPK(warehouseid));
                stockinfo.setWarehouse(warehouse);
            }
            String string2 = projectid = stockinfo.getParent().getProject() == null ? null : stockinfo.getParent().getProject().getId().toString();
            if (projectid != null) {
                ProjectInfo projectinfo = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(projectid));
                stockinfo.getParent().setProject(projectinfo);
            }
            String string3 = tracknumberid = stockinfo.getParent().getTrackNumber() == null ? null : stockinfo.getParent().getTrackNumber().getId().toString();
            if (tracknumberid != null) {
                TrackNumberInfo tracknumber = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(tracknumberid));
                stockinfo.getParent().setTrackNumber(tracknumber);
            }
            String locationid = stockinfo.getLocation() == null ? null : stockinfo.getLocation().getId().toString();
            BigDecimal inventroyqty = MasterProductionScheduleExtCTL.getInventory(ctx, mi.getId().toString(), projectid, tracknumberid, stockinfo.getStorageOrgUnit().getId().toString(), warehouseid, locationid);
            if (inventroyqty.compareTo(unqty) > 0) {
                stockinfo.put("ISDISTRIBUTE", (Object)Boolean.TRUE);
            } else {
                stockinfo.put("ISDISTRIBUTE", (Object)Boolean.FALSE);
            }
            BigDecimal inventoryCount = inventroyqty;
            if (inventoryCount.compareTo(unqty) >= 0) {
                stockinfo.put("MATERIALCOLOR", (Object)Color.GREEN);
            } else if (inventoryCount.compareTo(unqty) < 0 && inventoryCount.compareTo(BigDecimal.ZERO) > 0) {
                stockinfo.put("MATERIALCOLOR", (Object)Color.YELLOW);
            } else {
                stockinfo.put("MATERIALCOLOR", (Object)Color.RED);
            }
            MaterialInventoryInfo mixpackage = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(mi.getId().toString(), si.getId().toString());
            String workcenterid = stockinfo.getWorkcenter() == null ? null : stockinfo.getWorkcenter().getId().toString();
            int operationNO = stockinfo.getOperationNo();
            String orderid = stockinfo.getParent().getId().toString();
            if (workcenterid != null) {
                WorkCenterInfo workcenterinfo = WorkCenterFactory.getLocalInstance((Context)ctx).getWorkCenterInfo((IObjectPK)new ObjectUuidPK(workcenterid));
                stockinfo.setWorkcenter(workcenterinfo);
            } else {
                String _workcenterid;
                _rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT a.fworkcenterid FROM t_mm_mftordertechnics a WHERE a.FPARENTID='" + orderid + "' AND a.FOPERATIONNO = " + operationNO));
                if (_rs.next() && (_workcenterid = _rs.getString("fworkcenterid")) != null && !"".equals(_workcenterid)) {
                    WorkCenterInfo workcenterinfo = WorkCenterFactory.getLocalInstance((Context)ctx).getWorkCenterInfo((IObjectPK)new ObjectUuidPK(_workcenterid));
                    stockinfo.setWorkcenter(workcenterinfo);
                }
            }
            if (mixpackage != null) {
                stockinfo.put("MIXPACKAGE", (Object)mixpackage.getQtyMinPackage());
            }
            stockinfo.put("BACKFLUSHWAREHOUSE", null);
            stockinfo.put("BACKFLUSHWAREHOUSEQTY", null);
            stockinfo.put("DISTRIBUTEDQTY", (Object)qty);
            stockinfo.put("UNDISTRIBUTEQTY", (Object)unqty);
            stockinfo.put("INVENTORY", (Object)inventroyqty);
            _rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT a.flocationdefine cfgongwei,b.fname_l2 operationname FROM t_mm_mftordertechnics a left join t_mm_operation b on a.foperationid = b.fid WHERE a.FPARENTID='" + orderid + "' AND a.FOPERATIONNO = " + operationNO));
            if (_rs.next()) {
                String locationdefineid = _rs.getString("cfgongwei");
                if (locationdefineid != null && !"".equals(locationdefineid)) {
                    LocationDefinedInfo locationDefined = LocationDefinedFactory.getLocalInstance((Context)ctx).getLocationDefinedInfo((IObjectPK)new ObjectUuidPK(locationdefineid));
                    stockinfo.put("station.name", (Object)locationDefined.getName());
                }
                stockinfo.put("operation.Name", (Object)_rs.getString("operationname"));
            }
            if (dstatus.equals(CALCUTEBOMSTATUS) && this.filterDistributeData(stockinfo)) continue;
            resultColls.add(stockinfo);
        }
        return resultColls;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnitInfoFromOrgUnit(Context ctx, String fstorageOrgUnitID, boolean isthrowsErr) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (fstorageOrgUnitID == null || "".equals(fstorageOrgUnitID)) {
            return null;
        }
        String[] s = new String[]{fstorageOrgUnitID};
        Map companyOrgmap = PMRPPlannedOrderMappingFacadeFactory.getLocalInstance((Context)ctx).getCouOrgUnit(s);
        if (companyOrgmap != null) {
            String fcompID = companyOrgmap.get(fstorageOrgUnitID).toString();
            companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(fcompID));
        }
        if (companyOrgUnitInfo == null && isthrowsErr) {
            StorageOrgUnitInfo storageOrgUnitInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(fstorageOrgUnitID));
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"KCZZMYDYDWTCWZZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{storageOrgUnitInfo.getNumber(), storageOrgUnitInfo.getName()});
            throw new EASBizException(new NumericExceptionSubItem("", strInfo));
        }
        return companyOrgUnitInfo;
    }

    private boolean filterDistributeData(ManufactureOrderStockInfo stockinfo) {
        DistributeStatusEnum status = (DistributeStatusEnum)((Object)stockinfo.get("DISTRIBUTESTATUS"));
        if (!status.equals((Object)DistributeStatusEnum.UnDistribute) && !status.equals((Object)DistributeStatusEnum.PartDistribute)) {
            return true;
        }
        BigDecimal inventory = (BigDecimal)stockinfo.get("INVENTORY");
        BigDecimal unqty = (BigDecimal)stockinfo.get("UNDISTRIBUTEQTY");
        if (unqty.compareTo(BigDecimal.ZERO) == 0 || inventory.compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        return stockinfo.getWarehouse() == null;
    }

    private List<String> filterStockList(Context ctx, Map mapValue) throws BOSException {
        String warehouse = (String)mapValue.get("WAREHOUSE");
        String produceorgs = (String)mapValue.get("PRODUCEORG");
        String distributeorg = (String)mapValue.get("DISTRIBUTEORG");
        String workcenter = (String)mapValue.get("WORKCENTER");
        String projectid = (String)mapValue.get("PROJECT");
        String s_tracknumber = (String)mapValue.get("S_TRACKNUMBER");
        String e_tracknumber = (String)mapValue.get("E_TRACKNUMBER");
        String operation = (String)mapValue.get("OPERATION");
        String station = (String)mapValue.get("STATION");
        String tracknumber = this.verifyTrackNumber(ctx, s_tracknumber, e_tracknumber);
        Date[] arraysdate = new Date[2];
        Date requestdate1 = mapValue.get("REQUESTDATE1") == null ? null : new Date(Long.parseLong((String)mapValue.get("REQUESTDATE1")));
        Date requestdate2 = mapValue.get("REQUESTDATE2") == null ? null : new Date(Long.parseLong((String)mapValue.get("REQUESTDATE2")));
        String defaultStartDate = null;
        Object defaultEndDate = null;
        try {
            SimpleDateFormat _sdf;
            SimpleDateFormat sdf;
            if (requestdate1 != null) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                _sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                defaultStartDate = sdf.format(requestdate1);
                defaultStartDate = defaultStartDate + " 00:00:00";
                requestdate1 = _sdf.parse(defaultStartDate);
                arraysdate[0] = new Timestamp(requestdate1.getTime());
            }
            if (requestdate2 != null) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                _sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                defaultStartDate = sdf.format(requestdate2);
                defaultStartDate = defaultStartDate + " 23:59:59";
                requestdate2 = _sdf.parse(defaultStartDate);
                arraysdate[1] = new Timestamp(requestdate2.getTime());
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        String[] workcenters = workcenter.split(",");
        String motMergeTempTable = this.createStorageTempTable(ctx);
        String insertSql = this.insertMOTMergeTempTableSQL(motMergeTempTable);
        ArrayList<Object[]> param = new ArrayList<Object[]>();
        if (workcenters != null && workcenters.length > 0) {
            for (int n = 0; n < workcenters.length; ++n) {
                Object[] params = new Object[]{workcenters[n].replaceAll("'", "")};
                param.add(params);
            }
        }
        DbUtil.executeBatch((Context)ctx, (String)insertSql, param);
        StringBuffer sbStr = new StringBuffer();
        sbStr.append(" select a.fid stockid,b.fid orderid ").append(" from t_mm_mftorderstock a ").append(" left join t_mm_manufactureorder b on a.fparentid = b.fid ").append(" left join t_mm_mftordertechnics c on a.foperationid = c.foperationid and a.fparentid = c.fparentid ").append(" where 1 = 1 ").append(" and (( a.fstorageorgunitid = ? and a.fprovidetype in (10930, 10910) and a.FISSUEMODE = 11010 )  ").append(" or ( a.fdispatchorgunitid = ? and a.fprovidetype = 10920 and a.FISSUEMODE = 11010 and a.fdispatchorgunitid is not null  ))  ").append(" and b.FBASESTATUS in (5, 8, 90, 10, 11, 12, 13, 14, 15, 16, 17, 18) ").append(" and c.FBASESTATUS in (4 ,5, 8, 90, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 22, 23, 24, 26) ").append(" and c.fworkcenterid in (select FWorkCenterID from ").append(motMergeTempTable).append(")").append(" and a.fdemandtime between ? and ? ").append(" and c.FStorageOrgUnitID = ? ").append(" and #PROJECT# and #TRACKNUMBER# and #OPERATION# and #STATION# and #WAREHOUSE# ");
        String tmpsql = sbStr.toString();
        tmpsql = projectid != null && !"".equals(projectid) ? tmpsql.replaceAll("#PROJECT#", "b.fprojectid in (" + projectid + ")") : tmpsql.replaceAll("#PROJECT#", "1=1");
        tmpsql = operation != null && !"".equals(operation) ? tmpsql.replaceAll("#OPERATION#", "a.FOPERATIONID in (" + operation + ")") : tmpsql.replaceAll("#OPERATION#", "1=1");
        tmpsql = tracknumber != null && !"".equals(tracknumber) ? tmpsql.replaceAll("#TRACKNUMBER#", "b.ftrackid in (" + tracknumber + ")") : tmpsql.replaceAll("#TRACKNUMBER#", "1=1");
        tmpsql = station != null && !"".equals(station) ? tmpsql.replaceAll("#STATION#", "c.cfgongwei in (" + station + ")") : tmpsql.replaceAll("#STATION#", "1=1");
        tmpsql = warehouse != null && !"".equals(warehouse) ? tmpsql.replaceAll("#WAREHOUSE#", "a.fwarehouseid in (" + warehouse + ")") : tmpsql.replaceAll("#WAREHOUSE#", "1=1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)tmpsql, (Object[])new Object[]{distributeorg, distributeorg, arraysdate[0], arraysdate[1], produceorgs});
        HashMap orderMapStock = new HashMap();
        ArrayList<String> orderidList = new ArrayList<String>();
        try {
            while (rs.next()) {
                String stockid = rs.getString("stockid");
                String orderid = rs.getString("orderid");
                if (orderMapStock.get(orderid) == null) {
                    ArrayList<String> stockidList = new ArrayList<String>();
                    stockidList.add(stockid);
                    orderMapStock.put(orderid, stockidList);
                } else {
                    ((List)orderMapStock.get(orderid)).add(stockid);
                }
                orderidList.add(orderid);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        List<String> changeVersionData = this.checkChangeVersion(ctx, orderidList);
        for (String orderid : changeVersionData) {
            orderMapStock.remove(orderid);
        }
        ArrayList<String> stockAllList = new ArrayList<String>();
        for (Map.Entry obj : orderMapStock.entrySet()) {
            stockAllList.addAll((ArrayList)obj.getValue());
        }
        return stockAllList;
    }

    protected String createManufactureOrderIdTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOTMergeTempTable(\r\n");
        sql.append("FManufactureOrderID VARCHAR(44) Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FManufactureOrderID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "IsNull(FManufactureOrderID,'Null')", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String insertManufactureIDTempTableSQL(String mergeMOTTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(mergeMOTTempTable).append("(\r\n");
        sql.append("FManufactureOrderID\r\n");
        sql.append(") values (?)\r\n");
        return sql.toString();
    }

    private List<String> checkChangeVersion(Context ctx, List<String> newMOIDList) throws BOSException {
        String motMergeTempTable = this.createManufactureOrderIdTempTable(ctx);
        String insertSql = this.insertManufactureIDTempTableSQL(motMergeTempTable);
        ArrayList<Object[]> param = new ArrayList<Object[]>();
        if (newMOIDList != null && newMOIDList.size() > 0) {
            for (int n = 0; n < newMOIDList.size(); ++n) {
                Object[] params = new Object[]{newMOIDList.get(n)};
                System.out.println("ID:" + params[0].toString());
                param.add(params);
            }
        }
        DbUtil.executeBatch((Context)ctx, (String)insertSql, param);
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("CV.FID FChangeVersionID,\r\n");
        sql.append("MO.FID FBeforeMOID\r\n");
        sql.append("From T_MM_ManufactureOrder MO\r\n");
        sql.append("Inner Join T_MM_TrackNumber MOTN On MOTN.FID=MO.FTrackID\r\n");
        sql.append("Inner Join CT_BAS_ChangeVersion CV On\r\n");
        sql.append("1=1\r\n");
        sql.append("And CV.CFProjectID=MO.FProjectID\r\n");
        sql.append("And CV.Cfbeforematerialid=MO.FMaterialID\r\n");
        sql.append("Inner Join T_MM_TrackNumber STN On STN.FID=CV.CFStartTrackNumberID\r\n");
        sql.append("Inner Join T_MM_TrackNumber ETN On ETN.FID=CV.CFEndTrackNumberID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append(" and CV.CFStatus = ").append(20).append(" \r\n");
        sql.append("And MO.FID In (");
        sql.append("SELECT FManufactureOrderID FROM ").append(motMergeTempTable);
        sql.append(")\r\n");
        sql.append("And IsNull(MOTN.FNumber,'Null')>=IsNull(STN.FNumber,'Null')\r\n");
        sql.append("And IsNull(MOTN.FNumber,'Null')<=IsNull(ETN.FNumber,'Null')\r\n");
        sql.append("Order By\r\n");
        sql.append("MO.FID Asc,\r\n");
        sql.append("CV.FCreateTime Desc,\r\n");
        sql.append("CV.FID Asc\r\n");
        IRowSet changeVersionBaseRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> pksList = new ArrayList<String>();
        try {
            while (changeVersionBaseRowSet.next()) {
                String fid = changeVersionBaseRowSet.getString("FBeforeMOID");
                pksList.add(fid);
            }
        }
        catch (SQLException ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0026"));
        }
        return pksList;
    }

    protected String insertMOTMergeTempTableSQL(String mergeMOTTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(mergeMOTTempTable).append("(\r\n");
        sql.append("FWorkCenterID\r\n");
        sql.append(") values (?)\r\n");
        return sql.toString();
    }

    protected String createStorageTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOTMergeTempTable(\r\n");
        sql.append("FWorkCenterID VARCHAR(44) Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FWorkCenterID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "IsNull(FWorkCenterID,'Null')", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    private boolean checkIsDirectMaterial(Context ctx, String stockid) throws BOSException, EASBizException {
        boolean bABC;
        boolean isDirectMaterial = false;
        String stocksql = "select a.fmaterialid, b.fprojectid, b.ftrackid, a.fid from t_mm_mftorderstock a  left join t_mm_manufactureorder b  on a.fparentid = b.fid where a.fid=?";
        IRowSet stockrs = DbUtil.executeQuery((Context)ctx, (String)stocksql, (Object[])new String[]{stockid});
        String materialid = null;
        String projectid = null;
        String trackid = null;
        try {
            while (stockrs.next()) {
                materialid = stockrs.getString("fmaterialid");
                projectid = stockrs.getString("fprojectid");
                trackid = stockrs.getString("ftrackid");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String classA = "select * from CT_DIR_DirectFeedingmMaterial where CFMATERIALID =? and cfprojectid is null and CFTRACKID is null AND CFISZJ = 1 AND CFSTATUS = 1";
        String classAB = "select * from CT_DIR_DirectFeedingmMaterial where CFMATERIALID = ? and cfprojectid = ? and CFTRACKID is null AND CFISZJ = 1 AND CFSTATUS = 1";
        String classABC = "select * from CT_DIR_DirectFeedingmMaterial where CFMATERIALID = ? and cfprojectid = ? and CFTRACKID = ? AND CFISZJ = 1 AND CFSTATUS = 1";
        IRowSet rsA = DbUtil.executeQuery((Context)ctx, (String)classA, (Object[])new String[]{materialid});
        IRowSet rsAB = DbUtil.executeQuery((Context)ctx, (String)classAB, (Object[])new String[]{materialid, projectid});
        IRowSet rsABC = DbUtil.executeQuery((Context)ctx, (String)classABC, (Object[])new String[]{materialid, projectid, trackid});
        boolean bA = rsA.size() > 0;
        boolean bAB = rsAB.size() > 0;
        boolean bl = bABC = rsABC.size() > 0;
        if (bA || bAB || bABC) {
            isDirectMaterial = true;
        }
        return isDirectMaterial;
    }

    private void recaluteOrderStock(Context ctx, IRowSet rs) throws BOSException {
        ArrayList<String> technicsids = new ArrayList<String>();
        try {
            while (rs.next()) {
                String technicsid = rs.getString("ENTRYID");
                technicsids.add(technicsid);
            }
            EMMManufactureOrderEntrysGenFacadeFactory.getLocalInstance((Context)ctx).genStocksEntrysByTechID(technicsids);
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0027"));
        }
    }

    private List<String> filterChangeVersionData(Context ctx) throws BOSException {
        List<String> changeVersionIds = this.checkChangeVersion(ctx);
        return changeVersionIds;
    }

    private List<String> checkChangeVersion(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("MO.FID FAfterMOID,\r\n");
        sql.append("CV.FID FChangeVersionID,\r\n");
        sql.append("SMO.FID FBeforeMOID\r\n");
        sql.append("From T_MM_ManufactureOrder MO\r\n");
        sql.append("Inner Join T_MM_TrackNumber MOTN On MOTN.FID=MO.FTrackID\r\n");
        sql.append("Inner Join CT_BAS_ChangeVersion CV On\r\n");
        sql.append("1=1\r\n");
        sql.append("And CV.CFProjectID=MO.FProjectID\r\n");
        sql.append("And CV.CFAfterMaterialID=MO.FMaterialID\r\n");
        sql.append("Inner Join T_MM_TrackNumber STN On STN.FID=CV.CFStartTrackNumberID\r\n");
        sql.append("Inner Join T_MM_TrackNumber ETN On ETN.FID=CV.CFEndTrackNumberID\r\n");
        sql.append("Inner Join T_MM_ManufactureOrder SMO On\r\n");
        sql.append("1=1\r\n");
        sql.append("And SMO.FProjectID=CV.CFProjectID\r\n");
        sql.append("And SMO.FMaterialID=CV.CFBeforeMaterialID\r\n");
        sql.append("Inner Join T_MM_TrackNumber SMOTN On SMOTN.FID=SMO.FTrackID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And IsNull(MOTN.FNumber,'Null')>=IsNull(STN.FNumber,'Null')\r\n");
        sql.append("And IsNull(MOTN.FNumber,'Null')<=IsNull(ETN.FNumber,'Null')\r\n");
        sql.append("And IsNull(SMOTN.FNumber,'Null')>=IsNull(STN.FNumber,'Null')\r\n");
        sql.append("And IsNull(SMOTN.FNumber,'Null')<=IsNull(ETN.FNumber,'Null')\r\n");
        sql.append("Order By\r\n");
        sql.append("MO.FID Asc,\r\n");
        sql.append("CV.FCreateTime Desc,\r\n");
        sql.append("CV.FID Asc\r\n");
        IRowSet changeVersionBaseRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> pksList = new ArrayList<String>();
        try {
            while (changeVersionBaseRowSet.next()) {
                String fid = changeVersionBaseRowSet.getString("FBeforeMOID");
                pksList.add(fid);
            }
        }
        catch (SQLException ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0026"));
        }
        return pksList;
    }

    private IRowSet filterManufactureOrder(Context ctx, Map mapValue) throws BOSException {
        String produceorgs = (String)mapValue.get("PRODUCEORG");
        String projectid = (String)mapValue.get("PROJECT");
        String s_tracknumber = (String)mapValue.get("S_TRACKNUMBER");
        String e_tracknumber = (String)mapValue.get("E_TRACKNUMBER");
        String tracknumber = this.verifyTrackNumber(ctx, s_tracknumber, e_tracknumber);
        String operation = (String)mapValue.get("OPERATION");
        String station = (String)mapValue.get("STATION");
        String workcenter = (String)mapValue.get("WORKCENTER");
        Date[] arraysdate = new Date[2];
        Date requestdate1 = mapValue.get("REQUESTDATE1") == null ? null : new Date(Long.parseLong((String)mapValue.get("REQUESTDATE1")));
        Date requestdate2 = mapValue.get("REQUESTDATE2") == null ? null : new Date(Long.parseLong((String)mapValue.get("REQUESTDATE2")));
        try {
            String defaultStartDate;
            SimpleDateFormat _sdf;
            SimpleDateFormat sdf;
            if (requestdate1 != null) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                _sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                defaultStartDate = sdf.format(requestdate1);
                defaultStartDate = defaultStartDate + " 00:00:00";
                requestdate1 = _sdf.parse(defaultStartDate);
                arraysdate[0] = new Timestamp(requestdate1.getTime());
            }
            if (requestdate2 != null) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                _sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                defaultStartDate = sdf.format(requestdate2);
                defaultStartDate = defaultStartDate + " 23:59:59";
                requestdate2 = _sdf.parse(defaultStartDate);
                arraysdate[1] = new Timestamp(requestdate2.getTime());
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        String tmpsql = this.MANUFACTRUEORDER;
        tmpsql = produceorgs != null && !"".equals(produceorgs) ? tmpsql.replaceAll("#PRODUCEORG#", "a.FStorageOrgUnitID in ('" + produceorgs + "')") : tmpsql.replaceAll("#PRODUCEORG#", "1=1");
        tmpsql = projectid != null && !"".equals(projectid) ? tmpsql.replaceAll("#PROJECT#", "b.fprojectid in (" + projectid + ")") : tmpsql.replaceAll("#PROJECT#", "1=1");
        tmpsql = operation != null && !"".equals(operation) ? tmpsql.replaceAll("#OPERATION#", "a.FOPERATIONID in (" + operation + ")") : tmpsql.replaceAll("#OPERATION#", "1=1");
        tmpsql = workcenter != null && !"".equals(workcenter) ? tmpsql.replaceAll("#WORKCENTER#", "a.fworkcenterid in (" + workcenter + ")") : tmpsql.replaceAll("#WORKCENTER#", "1=1");
        tmpsql = tracknumber != null && !"".equals(tracknumber) ? tmpsql.replaceAll("#TRACKNUMBER#", "b.ftrackid in (" + tracknumber + ")") : tmpsql.replaceAll("#TRACKNUMBER#", "1=1");
        tmpsql = station != null && !"".equals(station) ? tmpsql.replaceAll("#STATION#", "a.cfgongwei in (" + station + ")") : tmpsql.replaceAll("#STATION#", "1=1");
        return DbUtil.executeQuery((Context)ctx, (String)tmpsql, (Object[])new Object[]{arraysdate[0], arraysdate[1]});
    }

    private IRowSet filterManufactureOrderEntryId(Context ctx, Map mapValue) throws BOSException {
        String sqlHead = "/*dialect*/Select sd.fid FID,h.fid orderid from t_mm_manufactureorder h inner join   t_mm_mftordertechnics d on h.fid = d.fparentid inner join t_mm_mftorderstock sd  on sd.fparentid = h.fid and sd.foperationno = d.foperationno where d.fid in ( select a.fid ENTRYID from T_MM_MFTOrderTechnics a left join T_MM_ManufactureOrder b  on a.fparentid = b.fid left join t_mm_bom c on b.fbomid = c.fid where #PRODUCEORG# and #PROJECT# and #TRACKNUMBER# and #OPERATION# and #WORKCENTER# and #STATION#  and sd.fdemandtime >= to_date(?,'YYYY-MM-DD hh24:mi:ss') and sd.fdemandtime <= to_date(?,'YYYY-MM-DD hh24:mi:ss')  AND b.FBASESTATUS in (5,8,90,10,11,12,13,14,15,16,17,18) ) and d.FBASESTATUS in (5,8,90,10,11,12,13,14,15,16,17,18,20,21,22,23,24,26)";
        String produceorgs = (String)mapValue.get("PRODUCEORG");
        String projectid = (String)mapValue.get("PROJECT");
        String s_tracknumber = (String)mapValue.get("S_TRACKNUMBER");
        String e_tracknumber = (String)mapValue.get("E_TRACKNUMBER");
        String tracknumber = this.verifyTrackNumber(ctx, s_tracknumber, e_tracknumber);
        String operation = (String)mapValue.get("OPERATION");
        String station = (String)mapValue.get("STATION");
        String workcenter = (String)mapValue.get("WORKCENTER");
        Date requestdate1 = mapValue.get("REQUESTDATE1") == null ? null : new Date(Long.parseLong((String)mapValue.get("REQUESTDATE1")));
        Date requestdate2 = mapValue.get("REQUESTDATE2") == null ? null : new Date(Long.parseLong((String)mapValue.get("REQUESTDATE2")));
        String defaultStartDate = null;
        String defaultEndDate = null;
        try {
            SimpleDateFormat sdf;
            if (requestdate1 != null) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                defaultStartDate = sdf.format(requestdate1);
                defaultStartDate = defaultStartDate + " 00:00:00";
            }
            if (requestdate2 != null) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                defaultEndDate = sdf.format(requestdate2);
                defaultEndDate = defaultEndDate + " 23:59:59";
            }
        }
        catch (Exception e) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0028"));
        }
        String tmpsql = sqlHead;
        tmpsql = produceorgs != null && !"".equals(produceorgs) ? tmpsql.replaceAll("#PRODUCEORG#", "a.FStorageOrgUnitID in ('" + produceorgs + "')") : tmpsql.replaceAll("#PRODUCEORG#", "1=1");
        tmpsql = projectid != null && !"".equals(projectid) ? tmpsql.replaceAll("#PROJECT#", "b.fprojectid in (" + projectid + ")") : tmpsql.replaceAll("#PROJECT#", "1=1");
        tmpsql = operation != null && !"".equals(operation) ? tmpsql.replaceAll("#OPERATION#", "a.FOPERATIONID in (" + operation + ")") : tmpsql.replaceAll("#OPERATION#", "1=1");
        tmpsql = workcenter != null && !"".equals(workcenter) ? tmpsql.replaceAll("#WORKCENTER#", "a.fworkcenterid in (" + workcenter + ")") : tmpsql.replaceAll("#WORKCENTER#", "1=1");
        tmpsql = tracknumber != null && !"".equals(tracknumber) ? tmpsql.replaceAll("#TRACKNUMBER#", "b.ftrackid in (" + tracknumber + ")") : tmpsql.replaceAll("#TRACKNUMBER#", "1=1");
        tmpsql = station != null && !"".equals(station) ? tmpsql.replaceAll("#STATION#", "a.cfgongwei in (" + station + ")") : tmpsql.replaceAll("#STATION#", "1=1");
        return DbUtil.executeQuery((Context)ctx, (String)tmpsql, (Object[])new Object[]{defaultStartDate, defaultEndDate});
    }

    private String verifyTrackNumber(Context ctx, String s_tracknumber, String e_tracknumber) throws BOSException {
        StringBuffer sbStr = new StringBuffer();
        sbStr.append(" select fnumber,fid from t_mm_tracknumber a ");
        sbStr.append(" where fnumber >= (select fnumber from t_mm_tracknumber b where b.fid = '").append(s_tracknumber).append("') ");
        sbStr.append(" and fnumber <= (select fnumber from t_mm_tracknumber c where c.fid = '").append(e_tracknumber).append("') ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbStr.toString());
        ArrayList<String> arraysList = new ArrayList<String>();
        try {
            while (rs.next()) {
                arraysList.add(rs.getString("fid"));
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        if (arraysList.size() > 0) {
            return SQLUtil.arrayToString((Object[])arraysList.toArray(new String[0]));
        }
        return "";
    }

    public int executeSQL(Context ctx, String sql) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            long startTime = System.currentTimeMillis();
            int effectedRows = statement.executeUpdate(sql);
            long endTime = System.currentTimeMillis();
            int n = effectedRows;
            return n;
        }
        catch (SQLException e) {
            throw new BOSException(sql, (Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    @Override
    protected String _calcuteDistributeBill(Context ctx, String condition) throws BOSException {
        Gson gson = new Gson();
        List volist = (List)gson.fromJson(condition, new TypeToken<List<DistributeBillVO>>(){}.getType());
        String distributetmpTable = MasterProductionScheduleExtCTL.createDistributeBillTempTable(ctx);
        String sql = "Insert Into " + distributetmpTable + " values (?,?,?,?,?,?,?,?)";
        for (int n = 0; n < volist.size(); ++n) {
            DistributeBillVO vo = (DistributeBillVO)volist.get(n);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{vo.getMaterialid(), vo.getStockid(), vo.getWarehouseid(), vo.getBackflushwhid(), vo.getProjectid(), vo.getTracknumberid(), vo.getStorageorgid(), vo.getUndistributeqty()});
        }
        String groupsql = " /*dialect*/select k.*,tbm.fname_l2 materialname,tdw.fname_l2 warehousename,tdwh.fname_l2 backflushwhname, tmp.fname_l2 projectname,tmt.fname_l2 tracknumname,tos.fname_l2 storagename from (  select materialid, warehouseid,backflushid,projectid,tracknumberid,storageorgid,  sum(undistributeqty) unqty,stockid stockids from " + distributetmpTable + " group by materialid, warehouseid,backflushid,projectid,tracknumberid,storageorgid,stockid ) k  left join t_bd_material tbm on k.materialid = tbm.fid  left join t_db_warehouse tdw on k.warehouseid = tdw.fid  left join t_db_warehouse tdwh on k.backflushid = tdwh.fid  left join t_mm_project tmp on k.projectid = tmp.fid  left join t_mm_tracknumber tmt on k.tracknumberid = tmt.fid  left join t_org_storage tos on k.storageorgid = tos.fid ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)groupsql);
        ArrayList<DistributeBillVO> resultList = new ArrayList<DistributeBillVO>();
        try {
            while (rs.next()) {
                BigDecimal qty;
                String materialid = rs.getString("materialid");
                String materialname = rs.getString("materialname");
                String warehouseid = rs.getString("warehouseid");
                String warehousename = rs.getString("warehousename");
                String backflushid = rs.getString("backflushid");
                String backflushwhname = rs.getString("backflushwhname");
                String projectid = rs.getString("projectid");
                String projectname = rs.getString("projectname");
                String tracknumberid = rs.getString("tracknumberid");
                String tracknumname = rs.getString("tracknumname");
                String storageorgid = rs.getString("storageorgid");
                String storagename = rs.getString("storagename");
                String stockids = rs.getString("stockids");
                BigDecimal unqty = rs.getBigDecimal("unqty");
                BigDecimal inventoryqty = MasterProductionScheduleExtCTL.getInventory(ctx, materialid, projectid, tracknumberid, storageorgid, warehouseid, null);
                BigDecimal backflushqty = backflushid == null ? BigDecimal.ZERO : MasterProductionScheduleExtCTL.getInventory(ctx, materialid, projectid, tracknumberid, storageorgid, backflushid, null);
                BigDecimal mixpackage = MasterProductionScheduleExtCTL.getMixPackage(ctx, materialid, storageorgid);
                BigDecimal actualqty = qty = this.calcuteMaybeQty(unqty, inventoryqty, backflushqty, null, mixpackage);
                DistributeBillVO vo = new DistributeBillVO();
                MaterialInfo materialinfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialid));
                MeasureUnitInfo unitinfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(materialinfo.getBaseUnit().getId().toString()));
                vo.setMaterialname(materialname);
                vo.setMaterialmode(materialinfo.getModel());
                vo.setMaterialnumber(materialinfo.getNumber());
                vo.setMaterialunit(unitinfo.getName());
                vo.setUndistributeqty(unqty);
                vo.setMaybedistributeqty(actualqty);
                vo.setActdistributeqtyp(actualqty);
                vo.setBackflushwhname(backflushwhname);
                vo.setWarehousename(warehousename);
                vo.setProjectname(projectname);
                vo.setTracknumbernumber(tracknumname);
                vo.setStorageorgname(storagename);
                vo.setStockid(stockids);
                resultList.add(vo);
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        String str = gson.toJson(resultList);
        return str;
    }

    private BigDecimal calcuteMaybeQty(BigDecimal unqty, BigDecimal inventroyqty, BigDecimal backflushqty, BigDecimal lineedgeqty, BigDecimal mixpackage) {
        BigDecimal zero;
        BigDecimal maybeqty = zero = BigDecimal.ZERO;
        BigDecimal tmpqty = unqty.subtract(backflushqty == null ? zero : backflushqty).subtract(lineedgeqty == null ? zero : lineedgeqty);
        if (tmpqty.compareTo(zero) <= 0) {
            maybeqty = zero;
        } else if (tmpqty.compareTo(BigDecimal.ZERO) > 0 && mixpackage.compareTo(zero) == 0) {
            maybeqty = tmpqty.compareTo(inventroyqty) > 0 ? inventroyqty : tmpqty;
        } else if (tmpqty.compareTo(BigDecimal.ZERO) > 0 && mixpackage.compareTo(zero) > 0) {
            BigDecimal rs = tmpqty.divide(mixpackage);
            maybeqty = mixpackage.multiply(new BigDecimal(Math.floor(rs.doubleValue())));
        }
        return maybeqty;
    }

    private ManufactureOrderStockInfo createManufactureOrderStockInfo(Context ctx, String stockid, BigDecimal actualqty) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterinfo = new FilterInfo();
        StringBuffer sbStr = new StringBuffer("ID in('");
        sbStr.append(stockid);
        sbStr.append("')");
        String tmpStr = sbStr.toString();
        filterinfo.getFilterItems().add(new FilterItemInfo(tmpStr));
        viewInfo.setFilter(filterinfo);
        CoreBillEntryBaseCollection coll = ManufactureOrderStockFactory.getLocalInstance((Context)ctx).getCoreBillEntryBaseCollection(viewInfo);
        ManufactureOrderStockInfo stockinfo = (ManufactureOrderStockInfo)coll.get(0);
        String _sql = " select sum(umo.assqty)+sum(umo.qty) qty from ( select k.fassociateqty assqty, 0 qty from t_im_materialreqbillentry k where k.fcorebillentryid = '" + stockid + "' and k.fbasestatus != 2  union select 0 assqty, k.fqty qty from t_im_materialreqbillentry k where k.fcorebillentryid = '" + stockid + "' and k.fbasestatus = 2) umo ";
        IRowSet _rs = DbUtil.executeQuery((Context)ctx, (String)_sql);
        BigDecimal blbaseqty = stockinfo.getPlannedQty();
        BigDecimal qty = BigDecimal.ZERO;
        try {
            while (_rs.next()) {
                qty = _rs.getBigDecimal("qty") == null ? BigDecimal.ZERO : _rs.getBigDecimal("qty");
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        BigDecimal unqty = blbaseqty.subtract(qty);
        BigDecimal thistimeQty = BigDecimal.ZERO;
        if (actualqty.subtract(unqty).compareTo(BigDecimal.ZERO) >= 0) {
            thistimeQty = unqty;
            actualqty = actualqty.subtract(unqty);
        } else {
            thistimeQty = actualqty;
        }
        stockinfo.setQty(thistimeQty);
        stockinfo.setBaseQty(thistimeQty);
        stockinfo.setPlannedQty(thistimeQty);
        stockinfo.setPlannedBaseQty(thistimeQty);
        stockinfo.setActIssueQty(BigDecimal.ZERO);
        stockinfo.setActIssueBaseQty(BigDecimal.ZERO);
        stockinfo.setUnIssueQty(thistimeQty);
        stockinfo.setUnIssueBaseQty(thistimeQty);
        return stockinfo;
    }

    private String getRuleNumber(Context ctx, ManufactureOrderStockInfo stockinfo) throws BOSException, EASBizException {
        String rulesql = "select b.fname fnumber from T_DIS_DispatchTranRule a left join t_bot_mapping b on a.fchangeruleid = b.fid where a.fpicktype=" + stockinfo.getPickType().getValue() + " and a.fstorageorgunitid='" + stockinfo.getStorageOrgUnit().getId().toString() + "' and a.fstatus = 20";
        IRowSet rulers = DbUtil.executeQuery((Context)ctx, (String)rulesql);
        String fnumber = null;
        try {
            if (rulers.next()) {
                fnumber = rulers.getString("fnumber");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fnumber;
    }

    @Override
    protected void _createMaterialReqBillByBOTP(Context ctx, Map map) throws BOSException, EASBizException {
        Iterator iterMap = map.entrySet().iterator();
        HashMap<String, CoreBillBaseCollection> ruleNumberBotp = new HashMap<String, CoreBillBaseCollection>();
        List<Object> materialreqList = new ArrayList();
        while (iterMap.hasNext()) {
            BigDecimal actualqty;
            Map.Entry obj = iterMap.next();
            String stockid = (String)obj.getKey();
            ManufactureOrderStockInfo stockinfo = this.createManufactureOrderStockInfo(ctx, stockid, actualqty = (BigDecimal)obj.getValue());
            String ruleNumber = this.getRuleNumber(ctx, stockinfo);
            if (ruleNumber == null) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0030")));
            }
            ObjectUuidPK objectUuidPK = new ObjectUuidPK(stockinfo.getParent().getId().toString());
            ManufactureOrderInfo manufactureOrderInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)objectUuidPK);
            String key = manufactureOrderInfo.getNumber() + "#" + ruleNumber;
            if (ruleNumberBotp.get(key) != null) {
                ManufactureOrderInfo orderinfo = (ManufactureOrderInfo)((CoreBillBaseCollection)ruleNumberBotp.get(key)).get(0);
                orderinfo.getStocks().add(stockinfo);
                continue;
            }
            CoreBillBaseCollection returnCoreBillBaseCollection = new CoreBillBaseCollection();
            ManufactureOrderStockCollection manufactureOrderStockCollection = manufactureOrderInfo.getStocks();
            manufactureOrderStockCollection.clear();
            manufactureOrderStockCollection.add(stockinfo);
            returnCoreBillBaseCollection.add((CoreBillBaseInfo)manufactureOrderInfo);
            ruleNumberBotp.put(key, returnCoreBillBaseCollection);
        }
        for (Map.Entry obj : ruleNumberBotp.entrySet()) {
            BOTMappingInfo botMappingInfo;
            String fnumber = ((String)obj.getKey()).split("#")[1];
            CoreBillBaseCollection returnCoreBillBaseCollection = (CoreBillBaseCollection)obj.getValue();
            if (returnCoreBillBaseCollection != null && returnCoreBillBaseCollection.size() > 0 && (botMappingInfo = this.getBOTMappingInfo(ctx, fnumber)) != null) {
                materialreqList = this.botpToMaterialReq(ctx, returnCoreBillBaseCollection, botMappingInfo);
            }
            for (String string : materialreqList) {
                MaterialReqBillInfo info = MaterialReqBillFactory.getLocalInstance((Context)ctx).getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(string));
                this.dealCloseAccount(ctx, info);
                this.dealBatchMaterialReq(ctx, info);
            }
            for (int i = 0; i < materialreqList.size(); ++i) {
                MaterialReqBillInfo materialReqBillInfo = MaterialReqBillFactory.getLocalInstance((Context)ctx).getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK((String)materialreqList.get(i)));
                String value = SCMBillParamFactory.getLocalInstance((Context)ctx).getParamByBillTypeID("SCM_Submit_01", 4, materialReqBillInfo.getStorageOrgUnit().getId().toString(), "50957179-0105-1000-e000-0163c0a812fd463ED552");
                boolean isSaveOrSubmit = this.getSystemParamValue(ctx, materialReqBillInfo.getStorageOrgUnit(), "EMMDP001");
                if (!isSaveOrSubmit) continue;
                if ("1".equals(value)) {
                    MaterialReqBillFactory.getLocalInstance((Context)ctx).submit((String)materialreqList.get(i));
                    continue;
                }
                MaterialReqBillFactory.getLocalInstance((Context)ctx).submit((String)materialreqList.get(i));
                MaterialReqBillFactory.getLocalInstance((Context)ctx).audit((IObjectPK)new ObjectUuidPK((String)materialreqList.get(i)));
            }
        }
    }

    private void dealBatchMaterialReq(Context ctx, MaterialReqBillInfo info) throws EASBizException, BOSException {
        int n;
        String stroageid = info.getSupplyStoreOrgUnit() == null ? "" : info.getSupplyStoreOrgUnit().getId().toString();
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
        ArrayList<MaterialReqBillEntryInfo> result = new ArrayList<MaterialReqBillEntryInfo>();
        block4: for (n = 0; n < info.getEntry().size(); ++n) {
            MaterialReqBillEntryInfo entryInfo = info.getEntry().get(n);
            String materialid = entryInfo.getMaterial() == null ? "" : entryInfo.getMaterial().getId().toString();
            String projectid = entryInfo.getProject() == null ? "" : entryInfo.getProject().getId().toString();
            String tracknumberid = entryInfo.getTrackNumber() == null ? "" : entryInfo.getTrackNumber().getId().toString();
            String warehouseid = entryInfo.getWarehouse() == null ? "" : entryInfo.getWarehouse().getId().toString();
            String lotbatch = entryInfo.getLot();
            MaterialInventoryInfo materialInventoryInfo = iMaterialInventory.getInventoryInfo(materialid, stroageid);
            boolean lotnumber = materialInventoryInfo.isIsLotNumber();
            if (!lotnumber || materialInventoryInfo.getStatus().getValue() != 1) {
                return;
            }
            IssuePriorityEnum issuePriorityenum = materialInventoryInfo.getIssuePriorityMode();
            if (issuePriorityenum.compareTo((Object)IssuePriorityEnum.NOTSELECT) == 0) {
                return;
            }
            BigDecimal qty = entryInfo.getQty() == null ? BigDecimal.ZERO : entryInfo.getQty();
            boolean isSupplyBatch = false;
            try {
                isSupplyBatch = MasterProductionScheduleExtCTL.checkInventoryBatchSupplyLoaction(ctx, materialid, projectid, tracknumberid, stroageid, warehouseid, lotbatch, qty);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            if (isSupplyBatch) {
                return;
            }
            try {
                BigDecimal tmpQty = qty;
                List<Object[]> objList = MasterProductionScheduleExtCTL.getInventoryBatchSupplyLoaction(ctx, materialid, projectid, tracknumberid, stroageid, warehouseid, issuePriorityenum);
                if (objList.size() <= 0) continue;
                for (int m = 0; m < objList.size(); ++m) {
                    String locationid;
                    Object[] obj = objList.get(m);
                    BigDecimal inventoryqty = obj[0] == null ? BigDecimal.ZERO : (BigDecimal)obj[0];
                    String lot = obj[1] == null ? null : (String)obj[1];
                    String string = locationid = obj[3] == null ? null : (String)obj[3];
                    if (BigDecimal.ZERO.compareTo(inventoryqty) == 0) continue;
                    if (inventoryqty.compareTo(tmpQty) >= 0) {
                        entryInfo.setLot(lot);
                        entryInfo.setQty(tmpQty);
                        entryInfo.setBaseQty(tmpQty);
                        entryInfo.setIssueQty(tmpQty);
                        entryInfo.setBaseIssueQty(tmpQty);
                        entryInfo.put("actureQty", (Object)tmpQty);
                        if (locationid != null) {
                            LocationInfo locationinfo = new LocationInfo();
                            locationinfo.setId(BOSUuid.read((String)locationid));
                            entryInfo.setLocation(locationinfo);
                        }
                        result.add(entryInfo);
                        continue block4;
                    }
                    tmpQty = tmpQty.subtract(inventoryqty);
                    MaterialReqBillEntryInfo cloneEntry = (MaterialReqBillEntryInfo)entryInfo.clone();
                    cloneEntry.setId(null);
                    cloneEntry.setQty(inventoryqty);
                    cloneEntry.setBaseQty(inventoryqty);
                    cloneEntry.setIssueQty(inventoryqty);
                    cloneEntry.setBaseIssueQty(inventoryqty);
                    cloneEntry.put("actureQty", (Object)inventoryqty);
                    cloneEntry.setLot(lot);
                    if (locationid != null) {
                        LocationInfo locationinfo = new LocationInfo();
                        locationinfo.setId(BOSUuid.read((String)locationid));
                        cloneEntry.setLocation(locationinfo);
                    }
                    result.add(cloneEntry);
                }
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (result.size() > 0) {
            info.getEntry().clear();
            for (n = 0; n < result.size(); ++n) {
                info.getEntry().add((MaterialReqBillEntryInfo)result.get(n));
            }
        } else {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0031")));
        }
        MaterialReqBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
    }

    protected boolean getSystemParamValue(Context ctx, StorageOrgUnitInfo storage, String paramName) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select fvalue_").append(ctx.getLocale()).append("  value from t_bas_paramitem where  fkeyid in (select fid from t_bas_param where fnumber = '").append(paramName).append("')  ");
        if (storage != null) {
            sb.append(" and forgunitid = '").append(storage.getId().toString()).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        boolean value = false;
        try {
            while (rs.next()) {
                value = new Boolean(rs.getString("value"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return value;
    }

    public MaterialReqBillInfo getMaterialReqBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("transactionType.*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.material.*"));
        sic.add(new SelectorItemInfo("entry.supplyWarehouse.*"));
        MaterialReqBillInfo materialReqBillInfo = MaterialReqBillFactory.getLocalInstance((Context)ctx).getMaterialReqBillInfo(pk, sic);
        return materialReqBillInfo;
    }

    private int getBillAuditLevel2(Context ctx, String inStorageId, String issueStorageId, String billTypeName, String transTypeId) throws BOSException, EASBizException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select head.fid, head.cflevel ");
            sql.append(" from t_zj_WorkflowPersonData head ");
            sql.append(" where head.fname_l2 = '").append(billTypeName).append("'");
            sql.append(" and head.CFTransactionTypeI = '").append(transTypeId).append("'");
            sql.append(" and head.CFInStorageID = '").append(inStorageId).append("'");
            sql.append(" and head.CFIssueStorageID = '").append(issueStorageId).append("'");
            IRowSet rs = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql.toString());
            if (rs.next()) {
                return rs.getInt("cflevel");
            }
            return -1;
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private void checkDistributeBillOrApprove(Context ctx, String id, List<String> approveList, List<String> distributeList) throws EASBizException, BOSException {
        approveList.add(id);
    }

    private RITypeEnum getRITypeEnum(Context ctx, TransactionTypeInfo transactionTypeInfo) throws EASBizException, BOSException {
        RITypeEnum riTypeEnum = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("riType.*");
        transactionTypeInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionTypeInfo.getId()), sic);
        RecIssueTypeInfo recIssueTypeInfo = transactionTypeInfo.getRiType();
        if (recIssueTypeInfo != null) {
            String number = recIssueTypeInfo.getNumber();
            if (number.equals("001")) {
                riTypeEnum = RITypeEnum.PurIn;
            }
            if (number.equals("002")) {
                riTypeEnum = RITypeEnum.PurRt;
            }
            if (number.equals("003")) {
                riTypeEnum = RITypeEnum.SaleOut;
            }
            if (number.equals("004")) {
                riTypeEnum = RITypeEnum.SaleRt;
            }
            if (number.equals("005")) {
                riTypeEnum = RITypeEnum.ReqOut;
            }
            if (number.equals("006")) {
                riTypeEnum = RITypeEnum.ReqRt;
            }
            if (number.equals("007")) {
                riTypeEnum = RITypeEnum.TransIn;
            }
            if (number.equals("008")) {
                riTypeEnum = RITypeEnum.TransOut;
            }
            if (number.equals("009")) {
                riTypeEnum = RITypeEnum.OtherIn;
            }
            if (number.equals("010")) {
                riTypeEnum = RITypeEnum.OtherOut;
            }
            if (number.equals("011")) {
                riTypeEnum = RITypeEnum.ManuIn;
            }
            if (number.equals("012")) {
                riTypeEnum = RITypeEnum.ManuRt;
            }
            if (number.equals("013")) {
                riTypeEnum = RITypeEnum.CheckIn;
            }
            if (number.equals("014")) {
                riTypeEnum = RITypeEnum.CheckRt;
            }
            if (number.equals("015")) {
                riTypeEnum = RITypeEnum.ConsignOut;
            }
            if (number.equals("016")) {
                riTypeEnum = RITypeEnum.consignRt;
            }
        }
        return riTypeEnum;
    }

    private void batchStartDistribution(Context ctx, List<String> ids) throws EASBizException, BOSException {
        this.checkDCDelivery(ctx, ids);
        this.checkDisWarehouse(ctx, ids);
    }

    private void checkDisWarehouse(Context ctx, List<String> ids) throws EASBizException, BOSException {
        String StrSQL = "";
        String fid = "";
        IRowSet rs = null;
        int icount = 0;
        String error = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0032") + "\n";
        if (ids.size() > 0) {
            for (int i = 0; i < ids.size(); ++i) {
                fid = ids.get(i).toString();
                StrSQL = "Select h.fnumber as fnumber from t_im_materialreqbill h  where h.fid = '" + fid + "' and  exists(Select 1 from t_db_warehouse where fid in(Select fsupplywarehouseid from t_im_materialreqbillentry where fparentid ='" + fid + "' ) and cfismacdis = 1) and  exists(Select 1 from t_db_warehouse where fid in(Select fsupplywarehouseid from t_im_materialreqbillentry where fparentid ='" + fid + "' ) and (cfismacdis = 0 or cfismacdis is null)) and exists(Select 1 from T_SCM_TransactionType where fid = h.ftransactiontypeid and Cfismacdis = 1)";
                try {
                    rs = SQLFacadeFactory.getLocalInstance((Context)ctx).getRowset(StrSQL);
                }
                catch (EASBizException e) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0033")));
                }
                try {
                    if (!rs.next()) continue;
                    error = error + rs.getString("fnumber") + "\n";
                    ++icount;
                    continue;
                }
                catch (SQLException e) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0034")));
                }
            }
            if (icount > 0) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0035")));
            }
        }
    }

    private void checkDCDelivery(Context ctx, List<String> ids) throws EASBizException, BOSException {
        IDCDeliveryBillEntry idcd = DCDeliveryBillEntryFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("issuebillid", new HashSet<String>(ids), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)4, CompareType.NOTEQUALS));
        evi.setFilter(filter);
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("issueBillNumber"));
        DCDeliveryBillEntryCollection ec = idcd.getDCDeliveryBillEntryCollection(evi);
        if (ec != null && ec.size() > 0) {
            String error = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0032") + "\n";
            int size = ec.size();
            for (int i = 0; i < size; ++i) {
                DCDeliveryBillEntryInfo ei = ec.get(i);
                if (error.contains(ei.getIssueBillNumber())) continue;
                error = error + ei.getIssueBillNumber() + "\n";
            }
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0036")));
        }
    }

    private void dealCloseAccount(Context ctx, MaterialReqBillInfo info) throws EASBizException, BOSException {
        Timestamp now = new Timestamp(new Date().getTime());
        if (info.getBizDate() == null) {
            info.setBizDate((Date)now);
        }
        Date bizDate = info.getBizDate();
        CompanyOrgUnitInfo cou = null;
        String fcompanyorgid = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" Select fcompanyorgunitid from t_im_materialreqbillentry a where a.fparentid = '").append(info.getId().toString()).append("' and  fcompanyorgunitid is not null and rownum = 1");
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowset.next()) {
                fcompanyorgid = rowset.getString("fcompanyorgunitid");
            }
        }
        catch (SQLException e) {
            throw new InterfaceDataBaseException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0037")));
        }
        if (fcompanyorgid != null) {
            cou = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(fcompanyorgid));
        } else if (info.getStorageOrgUnit() != null) {
            cou = MasterProductionScheduleExtFacadeControllerBean.getCompanyInfo(ctx, info.getStorageOrgUnit());
        }
        if (cou != null) {
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            boolean isShuted = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            if (isShuted) {
                currentPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriodInfo);
            }
            if (currentPeriodInfo == null) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0038")));
            }
            if (bizDate.before(currentPeriodInfo.getBeginDate()) || bizDate.after(currentPeriodInfo.getBeginDate())) {
                info.setBizDate(currentPeriodInfo.getBeginDate());
                info.setYear(currentPeriodInfo.getBeginDate().getYear() + 1900);
                info.setPeriod(currentPeriodInfo.getBeginDate().getMonth() + 1);
            }
        }
        if (info.getEntries() != null) {
            for (int i = 0; i < info.getEntry().size(); ++i) {
                info.getEntry().get(i).setBizDate(info.getBizDate());
            }
        }
        MaterialReqBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
    }

    public static CompanyOrgUnitInfo getCompanyInfo(Context ctx, StorageOrgUnitInfo sou) throws BOSException, EASBizException {
        if (sou == null) {
            return null;
        }
        OrgUnitCollection orgCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(sou.getId().toString(), 4, 1);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)orgCol.get(0);
        return ret;
    }

    private void matchesInventroy(Context ctx, List<String> materialreqList) throws BOSException, EASBizException {
        ArrayList<String> entryids = new ArrayList<String>();
        EntityViewInfo _viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(materialreqList), CompareType.INCLUDE));
        _viewInfo.setFilter(filterInfo);
        MaterialReqBillCollection colls = MaterialReqBillFactory.getLocalInstance((Context)ctx).getMaterialReqBillCollection(_viewInfo);
        for (int n = 0; n < colls.size(); ++n) {
            MaterialReqBillInfo info = colls.get(n);
            MaterialReqBillEntryCollection _colls = info.getEntry();
            for (int m = 0; m < _colls.size(); ++m) {
                MaterialReqBillEntryInfo value = _colls.get(m);
                entryids.add(value.getId().toString());
                MaterialInventoryCollection mccol = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(" where material.id = '" + value.getMaterial().getId().toString() + "' and orgUnit.id = '" + info.getStorageOrgUnit().getId().toString() + "'");
                if (mccol.size() <= 0) continue;
                MaterialInventoryInfo materialinventoryinfo = mccol.get(0);
                WarehouseInfo warehouse = materialinventoryinfo.getDefaultWarehouse();
                value.setWarehouse(warehouse);
            }
            MaterialReqBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
        }
        if (entryids.size() > 0) {
            // empty if block
        }
    }

    protected BOTMappingInfo getBOTMappingInfo(Context ctx, String name) throws BOSException, EASBizException {
        if (name == null) {
            return null;
        }
        if (name.trim().length() == 0) {
            return null;
        }
        BOTMappingInfo botMappingInfo = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("extRule.isEffected", (Object)true, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        BOTMappingCollection botMappingCollection = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingCollection(entityViewInfo);
        if (botMappingCollection != null && botMappingCollection.size() > 0) {
            botMappingInfo = botMappingCollection.get(0);
        }
        if (botMappingInfo == null) {
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"MYZDBMWXZHGZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{name});
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0039"), strInfo));
        }
        return botMappingInfo;
    }

    protected List<String> botpToMaterialReq(Context ctx, CoreBillBaseCollection CollInfo, BOTMappingInfo botInfo) throws BOSException, EASBizException {
        ArrayList<String> materialreqList = new ArrayList<String>();
        IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = null;
        try {
            result = btp.transform(CollInfo, botInfo);
        }
        catch (BTPException e) {
            StringBuffer exceptionMessage = new StringBuffer();
            exceptionMessage.append("BOTP [").append(botInfo == null || botInfo.getName() == null ? "" : botInfo.getName()).append("] \uff0c").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0040")).append(e.getMessage());
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0041"), exceptionMessage.toString()));
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        CollInfo.get(0).get("stocks");
        BOTRelationCollection relations = result.getBOTRelationCollection();
        IObjectCollection bills = result.getBills();
        try {
            for (int a = 0; a < bills.size(); ++a) {
                MaterialReqBillInfo ma = (MaterialReqBillInfo)bills.getObject(a);
                MaterialReqBillEntryCollection reqentrycol = ma.getEntry();
                String orgid = ma.getSupplyStoreOrgUnit().getId().toString();
                TransactionTypeInfo tranTypeinfo = new TransactionTypeInfo();
                if (ma.getTransactionType() == null) {
                    String strInfo = ResourceBase.getString((String)this.RESURL, (String)"ZHGZTDSBMYPZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{botInfo.getName()});
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0041"), strInfo));
                }
                tranTypeinfo = ma.getTransactionType();
                if (ma.getBillType() == null && tranTypeinfo.getBillType() != null) {
                    BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(tranTypeinfo.getBillType().getId()));
                    ma.setBillType(billTypeInfo);
                }
                MaterialReqBillEntryCollection reqentrycol2 = (MaterialReqBillEntryCollection)reqentrycol.clone();
                for (int i = 0; i < reqentrycol2.size(); ++i) {
                    ManufactureOrderInfo manufactureorerInfo;
                    CostCenterOrgUnitInfo ccInfo;
                    WorkCenterInfo wcinfo;
                    MaterialReqBillEntryInfo materialentryinfo = reqentrycol2.get(i);
                    if (materialentryinfo.getMaterial() == null) {
                        reqentrycol.remove(reqentrycol2.get(i));
                        continue;
                    }
                    MaterialReqBillEntryInfo entry = reqentrycol.get(i);
                    boolean isBackFlush = this.getisbackflush(ctx, entry.getMaterial().getId().toString(), orgid);
                    entry.put("isBackFlush", (Object)isBackFlush);
                    if (isBackFlush && entry.getWorkCenter() != null) {
                        String storageid;
                        String workcenterid = entry.getWorkCenter().getId().toString();
                        WarehouseInfo backWareHouse = this.getbackWareHouse(ctx, workcenterid, storageid = ma.getStorageOrgUnit().getId().toString());
                        if (backWareHouse == null) {
                            backWareHouse = this.getdaultwareHose(ma, ctx, entry);
                        }
                        entry.put("backFlushWareHouse", (Object)backWareHouse);
                    }
                    if (entry.getWorkCenter() != null && (wcinfo = WorkCenterFactory.getLocalInstance((Context)ctx).getWorkCenterInfo((IObjectPK)new ObjectUuidPK(entry.getWorkCenter().getId()))).getCostCenter() != null) {
                        ccInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(wcinfo.getCostCenter().getId()));
                        entry.setCostCenterOrgUnit(ccInfo);
                    }
                    if (entry.getSourceBillId() != null && entry.getCostObject() == null && ManufactureOrderFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(entry.getSourceBillId())) && (manufactureorerInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(entry.getSourceBillId()))).getCostObject() != null) {
                        ccInfo = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectInfo((IObjectPK)new ObjectUuidPK(manufactureorerInfo.getCostObject().getId()));
                        entry.setCostObject((CostObjectInfo)ccInfo);
                    }
                    entry.setInvUpdateType(TransactionTypeUtils.getInvUpdateTypeServer((Context)ctx, (TransactionTypeInfo)tranTypeinfo));
                }
                btp.saveRelations((CoreBillBaseInfo)ma, relations);
                materialreqList.add(ma.getId().toString());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return materialreqList;
    }

    protected boolean getisbackflush(Context ctx, String materialid, String orgid) throws EASBizException, BOSException {
        new StringBuffer();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection mpSelectorItemCollection = new SelectorItemCollection();
        mpSelectorItemCollection.add(new SelectorItemInfo("id"));
        mpSelectorItemCollection.add(new SelectorItemInfo("isBackFlush"));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgunit.id", (Object)orgid, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(mpSelectorItemCollection);
        MaterialPlanCollection mpc = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(viewInfo);
        if (mpc == null || mpc.size() == 0) {
            return false;
        }
        MaterialPlanInfo info = mpc.get(0);
        if (info == null) {
            return false;
        }
        return info.isIsBackFlush();
    }

    protected WarehouseInfo getbackWareHouse(Context ctx, String workcenterid, String storageid) throws EASBizException, BOSException {
        if (workcenterid == null || storageid == null || workcenterid.trim().length() == 0 || storageid.trim().length() == 0) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("backWareHouse.id"));
        sic.add(new SelectorItemInfo("backWareHouse.number"));
        sic.add(new SelectorItemInfo("backWareHouse.name"));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)workcenterid, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.setSelector(sic);
        WorkCenterCollection wcs = WorkCenterFactory.getLocalInstance((Context)ctx).getWorkCenterCollection(ev);
        if (wcs == null || wcs.size() == 0) {
            return null;
        }
        WorkCenterInfo wc = wcs.get(0);
        if (wc.get("backWareHouse") == null || !(wc.get("backWareHouse") instanceof WarehouseInfo)) {
            return null;
        }
        return (WarehouseInfo)wc.get("backWareHouse");
    }

    protected WarehouseInfo getdaultwareHose(MaterialReqBillInfo info, Context ctx, MaterialReqBillEntryInfo entry) throws EASBizException, BOSException {
        String sourceBillTypeId = null;
        if (!StringUtils.isEmpty((String)info.getSourceBillId()) && info.getSourceBillType() != null) {
            sourceBillTypeId = info.getSourceBillType().getId().toString();
        }
        if (sourceBillTypeId != null && "B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(sourceBillTypeId)) {
            String srcid = entry.getSourceBillId();
            StringBuffer oql = new StringBuffer();
            oql.append("select transactionType.defaultBFWarehouse.id where id='").append(srcid).append("'");
            ManufactureOrderInfo manufactureOrderInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo(oql.toString());
            return manufactureOrderInfo.getTransactionType().getDefaultBFWarehouse();
        }
        return null;
    }

    @Override
    protected IObjectCollection _queryMaterialReqByStockId(Context ctx, String condition) throws BOSException, EASBizException {
        Gson gson = new Gson();
        List volist = (List)gson.fromJson(condition, new TypeToken<List<DistributeBillVO>>(){}.getType());
        ArrayList<String> pksList = new ArrayList<String>();
        for (int n = 0; n < volist.size(); ++n) {
            DistributeBillVO vo = (DistributeBillVO)volist.get(n);
            String stockid = vo.getStockid();
            pksList.add(stockid);
        }
        String sql = "select k.fid fid from t_im_materialreqbillentry k where k.fsourcebillentryid in (" + SQLUtil.arrayToString((Object[])pksList.toArray(new String[0])) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> idList = new ArrayList<String>();
        try {
            while (rs.next()) {
                idList.add(rs.getString("fid"));
            }
        }
        catch (Exception ex) {
            throw new BOSException("");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("parent"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("issueQty"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("workCenter.name"));
        sic.add(new SelectorItemInfo("operation.name"));
        sic.add(new SelectorItemInfo("entry.demandDate"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("costObject.number"));
        sic.add(new SelectorItemInfo("costObject.name"));
        sic.add(new SelectorItemInfo("demandDate"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("costCenterOrgUnit.number"));
        sic.add(new SelectorItemInfo("costCenterOrgUnit.name"));
        sic.add(new SelectorItemInfo("invUpdateType.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("pendingFlag"));
        sic.add(new SelectorItemInfo("actureQty"));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(sic);
        MaterialReqBillEntryCollection colls = MaterialReqBillEntryFactory.getLocalInstance((Context)ctx).getMaterialReqBillEntryCollection(entityViewInfo);
        return colls;
    }

    @Override
    protected String _matchBatchLocation(Context ctx, List ids) throws BOSException, EASBizException {
        int n;
        ArrayList<MaterialReqBillInfo> otherList = new ArrayList<MaterialReqBillInfo>();
        StringBuffer sbStr = new StringBuffer();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterinfo = new FilterInfo();
        HashSet set = new HashSet();
        set.addAll(ids);
        filterinfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        viewInfo.setFilter(filterinfo);
        MaterialReqBillCollection colls = MaterialReqBillFactory.getLocalInstance((Context)ctx).getMaterialReqBillCollection(viewInfo);
        for (n = 0; n < colls.size(); ++n) {
            MaterialReqBillInfo materialinfo = colls.get(n);
            if (materialinfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
                this.dealBatchMaterialReq(ctx, colls.get(n));
                continue;
            }
            otherList.add(colls.get(n));
        }
        for (n = 0; n < otherList.size(); ++n) {
            sbStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0042"));
            sbStr.append(((MaterialReqBillInfo)otherList.get(n)).getNumber());
            if (n != otherList.size() - 1) {
                sbStr.append(",");
                continue;
            }
            sbStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0043"));
        }
        return sbStr.toString();
    }
}

