/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.restruct;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelation;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.common.util.TransactionTypeUtils;
import com.kingdee.eas.industry.emm.mm.restruct.AbstractRestructReqFacadeControllerBean;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBill;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillEntryCollection;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillEntryInfo;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillInfo;
import com.kingdee.eas.industry.emm.mm.restruct.RestructType;
import com.kingdee.eas.industry.emm.mo.EMMManufactureOrderEntrysGenFacadeFactory;
import com.kingdee.eas.industry.emm.mo.IEMMManufactureOrderEntrysGenFacade;
import com.kingdee.eas.industry.update8.Material8FacadeFactory;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomCollection;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IStandardRooting;
import com.kingdee.eas.mm.basedata.StandardRootingCollection;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.WorkCenterCollection;
import com.kingdee.eas.mm.basedata.WorkCenterFactory;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.MaterialReplaceTypeEnum;
import com.kingdee.eas.mm.mo.PickTypeEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.im.inv.IMaterialReqBill;
import com.kingdee.eas.scm.im.inv.IMaterialReqBillEntry;
import com.kingdee.eas.scm.im.inv.MaterialReqBill;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillPriceInfoEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillPriceInfoEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RestructReqFacadeControllerBean
extends AbstractRestructReqFacadeControllerBean {
    private static final long serialVersionUID = 1079335552268897418L;

    @Override
    protected void _restructReqTranOtherBill(Context ctx, RestructReqBillInfo info, String actionType) throws BOSException, EASBizException {
        if (info == null || StringUtil.isEmptyString((String)actionType)) {
            throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u4f20\u9012\u7684\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u9000\u6599\uff01"));
        }
        if (this.checkAndCopyMaterialReqBill(ctx, info, actionType)) {
            return;
        }
        CoreBillBaseCollection returnCoreBillBaseCollection = new CoreBillBaseCollection();
        RestructReqBillEntryCollection colls = info.getEntrys();
        if (colls != null && colls.size() == 0) {
            throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u4e0d\u5b58\u5728\u5dee\u5f02\u6570\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u5355\u636e\u8f6c\u6362\uff01"));
        }
        returnCoreBillBaseCollection.add((CoreBillBaseInfo)info);
        if ("BACKMATERIAL".equals(actionType)) {
            this.backMaterial(ctx, returnCoreBillBaseCollection);
        }
        if ("REVOKEINV".equals(actionType)) {
            this.revokeinv(ctx, returnCoreBillBaseCollection);
        }
        if ("MFTRESTRUCT".equals(actionType)) {
            this.mftrestruct(ctx, returnCoreBillBaseCollection);
        }
    }

    private boolean checkAndCopyMaterialReqBill(Context ctx, RestructReqBillInfo info, String actionType) throws BOSException, EASBizException {
        if (info.getManufactureorder() != null && StringUtil.equals((String)"BACKMATERIAL", (String)actionType)) {
            String orderID = info.getManufactureorder().getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append(" select \r\n");
            sql.append(" MRE.fid entrid ,MRE.FMaterialID \r\n");
            sql.append(" from T_IM_MaterialReqBill MR\r\n");
            sql.append(" left join  T_IM_Materialreqbillentry MRE \r\n");
            sql.append(" on MR.fid = MRE.Fparentid \r\n");
            sql.append(" where MR.Fbasestatus = 4 \r\n");
            sql.append(" and MRE.Fsourcebillid = ? \r\n");
            sql.append(" union \r\n");
            sql.append(" select \r\n");
            sql.append(" MRE.fid entrid ,MRE.FMaterialID \r\n");
            sql.append(" from T_IM_MaterialReqBill MR \r\n");
            sql.append(" left join  T_IM_Materialreqbillentry MRE \r\n");
            sql.append(" on MR.fid = MRE.Fparentid \r\n");
            sql.append(" inner join T_MM_ManufactureOrder MO \r\n");
            sql.append(" on MO.fid = MRE.Fsourcebillid \r\n");
            sql.append(" INNER JOIN T_MM_ProductTransactionType TC \r\n");
            sql.append(" ON MO.FTransactionTypeID = TC.FID \r\n");
            sql.append(" where MR.Fbasestatus = 4 \r\n");
            sql.append(" and MO.Fsourcebillid = ? \r\n");
            sql.append(" and TC.Fname_L2 like '%\u4e1a\u8054%' \r\n");
            long timeFrom = System.currentTimeMillis();
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orderID, orderID});
            long timeTo = System.currentTimeMillis();
            long duration = (timeTo - timeFrom) / 1000L;
            System.out.println("Execute SQL Duration " + duration + " Sec:\r\n" + sql.toString());
            HashMap<String, String> materialReqBillMap = new HashMap<String, String>();
            try {
                while (rs.next()) {
                    if (materialReqBillMap.containsKey(rs.getString("FMaterialID"))) continue;
                    materialReqBillMap.put(rs.getString("FMaterialID"), rs.getString("entrid"));
                }
            }
            catch (SQLException e) {
                Logger.error((Throwable)e, (String)"----------------------------\u6539\u5236\u7533\u8bf7\u5355\u9000\u6599\u67e5\u8be2\u9886\u6599\u51fa\u5e93\u5355\u51fa\u9519\uff01---------------------------------");
                throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u6539\u5236\u7533\u8bf7\u5355\u9000\u6599\u67e5\u8be2\u9886\u6599\u51fa\u5e93\u5355\u51fa\u9519\uff01" + e.getMessage()));
            }
            if (materialReqBillMap.size() > 0) {
                IMaterialReqBill iMaterialReqBill = MaterialReqBillFactory.getLocalInstance((Context)ctx);
                IMaterialReqBillEntry iMaterialReqBillEntry = MaterialReqBillEntryFactory.getLocalInstance((Context)ctx);
                CoreBaseCollection coll = new CoreBaseCollection();
                Iterator iterator = materialReqBillMap.keySet().iterator();
                BillTypeInfo restructBillTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("wV8Sqe4UQ8eI+vH512lGxUY+1VI="));
                TransactionTypeInfo transactionTypeInfo = this.getTransactionTypeByBotp(ctx);
                RestructReqBillEntryCollection botpcolls = new RestructReqBillEntryCollection();
                CoreBillBaseCollection botpCoreBillBaseCollection = new CoreBillBaseCollection();
                RestructReqBillEntryCollection restructReqBillEntryColl = info.getEntrys();
                ArrayList<String> entryIdList = new ArrayList<String>();
                for (int i = 0; i < restructReqBillEntryColl.size(); ++i) {
                    BigDecimal rejecteQty;
                    RestructReqBillEntryInfo restructReqBillEntryInfo = restructReqBillEntryColl.get(i);
                    BigDecimal bigDecimal = rejecteQty = restructReqBillEntryInfo.getRejecteqty() == null ? BigDecimal.ZERO : restructReqBillEntryInfo.getRejecteqty();
                    if (rejecteQty.compareTo(BigDecimal.ZERO) != 1) continue;
                    MaterialReqBillInfo newInfo = null;
                    if (materialReqBillMap.containsKey(restructReqBillEntryInfo.getMaterial().getId().toString())) {
                        MaterialReqBillEntryInfo entryInfo = iMaterialReqBillEntry.getMaterialReqBillEntryInfo((IObjectPK)new ObjectUuidPK((String)materialReqBillMap.get(restructReqBillEntryInfo.getMaterial().getId().toString())));
                        MaterialReqBillInfo materialReqBillInfo = iMaterialReqBill.getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(entryInfo.getParent().getId()));
                        newInfo = (MaterialReqBillInfo)materialReqBillInfo.clone();
                        MaterialReqBillEntryInfo newEntryInfo = (MaterialReqBillEntryInfo)entryInfo.clone();
                        newInfo.put("isComp", (Object)false);
                        newInfo.setTransactionType(transactionTypeInfo);
                        newInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                        newInfo.setId(BOSUuid.create((String)"500AB75E"));
                        newInfo.setNumber(null);
                        newInfo.setBizDate(new Date());
                        newInfo.setDescription("\u6539\u5236\u7533\u8bf7\u5355\u9000\u6599\u65f6\u751f\u6210\uff01");
                        newInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                        newInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                        newInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                        newInfo.setAuditor(null);
                        newInfo.setAuditTime(null);
                        newInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                        newInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                        newInfo.setSourceBillId(info.getId().toString());
                        newInfo.setSourceBillType(restructBillTypeInfo);
                        MaterialReqBillEntryCollection entrycoll = new MaterialReqBillEntryCollection();
                        newEntryInfo.setId(BOSUuid.create((String)"11774BB4"));
                        newEntryInfo.setAssistQty(restructReqBillEntryInfo.getRejecteqty());
                        newEntryInfo.setBaseQty(restructReqBillEntryInfo.getRejecteqty().subtract(restructReqBillEntryInfo.getRejectedqty()));
                        newEntryInfo.setCoreBillEntryID(restructReqBillEntryInfo.getId().toString());
                        newEntryInfo.setCoreBillID(info.getId().toString());
                        newEntryInfo.setCoreBillNumber(info.getNumber());
                        newEntryInfo.setCoreBillType(info.getBillType());
                        newEntryInfo.setQty(restructReqBillEntryInfo.getRejecteqty().subtract(restructReqBillEntryInfo.getRejectedqty()));
                        newEntryInfo.setIssueQty(restructReqBillEntryInfo.getRejecteqty());
                        newEntryInfo.setSourceBillEntryId(restructReqBillEntryInfo.getId().toString());
                        newEntryInfo.setSourceBillId(info.getId().toString());
                        newEntryInfo.setSourceBillNumber(info.getNumber());
                        newEntryInfo.setSourceBillType(info.getBillType());
                        newEntryInfo.setStorageOrgUnit(restructReqBillEntryInfo.getRejecteorgunit());
                        newEntryInfo.put("wmsstatus", null);
                        MaterialReqBillPriceInfoEntryCollection copypriceColl = newInfo.getPriceInfo();
                        MaterialReqBillPriceInfoEntryCollection priceColl = new MaterialReqBillPriceInfoEntryCollection();
                        for (int j = 0; j < copypriceColl.size(); ++j) {
                            MaterialReqBillPriceInfoEntryInfo entry = copypriceColl.get(j);
                            entry.setId(BOSUuid.create((String)"97A53E9B"));
                            priceColl.add(entry);
                        }
                        entrycoll.add(newEntryInfo);
                        newInfo.put("entry", (Object)entrycoll);
                        newInfo.put("priceInfo", (Object)priceColl);
                        coll.add((CoreBaseInfo)newInfo);
                        entryIdList.add(newEntryInfo.getId().toString());
                        this.createBotRelation(ctx, info.getId().toString(), newInfo.getId().toString());
                        continue;
                    }
                    botpcolls.add(restructReqBillEntryInfo);
                }
                if (coll.size() > 0) {
                    AutoNumberUtil.initNumber(ctx, (IObjectCollection)coll);
                    iMaterialReqBill.saveBatchData(coll);
                }
                if (botpcolls.size() > 0) {
                    info.getEntrys().clear();
                    info.getEntrys().addCollection(botpcolls);
                    botpCoreBillBaseCollection.add((CoreBillBaseInfo)info);
                    this.backMaterial(ctx, botpCoreBillBaseCollection);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private TransactionTypeInfo getTransactionTypeByBotp(Context ctx) throws BOSException, EASBizException {
        BOTMappingInfo botMappingInfo = this.getBOTMappingInfo(ctx, "GZSQ-TL");
        BOTRuleSegmentCollection ruleColl = botMappingInfo.getRules().get(0).getRuleSegments();
        TransactionTypeInfo transactionTypeInfo = null;
        String transcationTypeid = null;
        for (int i = 0; i < ruleColl.size(); ++i) {
            BOTRuleSegmentInfo rulesegmentInfo = ruleColl.get(i);
            String destPropertyName = rulesegmentInfo.getDestPropertyName();
            if (!StringUtil.equals((String)"transactionType", (String)destPropertyName)) continue;
            transcationTypeid = rulesegmentInfo.getRefObjectId();
            break;
        }
        if (!StringUtil.isEmptyString(transcationTypeid)) {
            transactionTypeInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transcationTypeid));
        }
        return transactionTypeInfo;
    }

    private void createBotRelation(Context ctx, String sourceID, String destID) throws EASBizException {
        BOSObjectType BOTBosType = new BOTRelation().getType();
        BOSObjectType restructReqType = new RestructReqBill().getType();
        BOSObjectType materialReqBosType = new MaterialReqBill().getType();
        UserInfo curUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from T_BOT_Relation \r\n");
        sql.append("where FSRCObjectID= '");
        sql.append(sourceID);
        sql.append("'and FDESTObjectID= '");
        sql.append(destID);
        sql.append("';");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (!rs.next()) {
                sql.setLength(0);
                sql.append("Insert Into T_BOT_Relation(\r\n");
                sql.append("FID,\r\n");
                sql.append("FSRCEntityID,\r\n");
                sql.append("FDESTEntityID,\r\n");
                sql.append("FSRCObjectID,\r\n");
                sql.append("FDESTObjectID,\r\n");
                sql.append("FDate,\r\n");
                sql.append("FOperatorID,\r\n");
                sql.append("FIsEffected,\r\n");
                sql.append("FBOTMappingID,\r\n");
                sql.append("FType\r\n");
                sql.append(")\r\n");
                sql.append("VALUES (\r\n");
                sql.append("NewBOSID('").append(BOTBosType.toString()).append("'),\r\n");
                sql.append("'").append(restructReqType.toString()).append("',\r\n");
                sql.append("'").append(materialReqBosType.toString()).append("',\r\n");
                sql.append("'").append(sourceID).append("',\r\n");
                sql.append("'").append(destID).append("',\r\n");
                sql.append(" sysdate,\r\n");
                sql.append("'").append(curUserInfo.getId().toString()).append("',\r\n");
                sql.append("1,\r\n");
                sql.append("Null,\r\n");
                sql.append("0\r\n");
                sql.append(")\r\n");
                this.executeSQL(ctx, sql.toString());
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"----------------------------\u521b\u5efa\u6539\u5236\u7533\u8bf7\u5230\u9886\u6599\u51fa\u5e93\u5355 BOTP\u5173\u8054\u5173\u7cfb\u51fa\u9519\uff01---------------------------------");
            throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u6539\u5236\u7533\u8bf7\u5355\u9000\u6599\u521b\u5efa \u6539\u5236\u7533\u8bf7\u5355-\u9886\u6599\u51fa\u5e93\u5355 BOTP\u5173\u8054\u5173\u7cfb\u51fa\u9519\uff01" + e.getMessage()));
        }
    }

    private void backMaterial(Context ctx, CoreBillBaseCollection returnCoreBillBaseCollection) throws BOSException, EASBizException {
        BOTMappingInfo botMappingInfo = this.getBOTMappingInfo(ctx, "GZSQ-TL");
        if (botMappingInfo != null) {
            this.botpToOtherBill(ctx, returnCoreBillBaseCollection, botMappingInfo);
        }
    }

    private void revokeinv(Context ctx, CoreBillBaseCollection returnCoreBillBaseCollection) throws BOSException, EASBizException {
        BOTMappingInfo botMappingInfo = this.getBOTMappingInfo(ctx, "GZSQ-BFRK");
        if (botMappingInfo != null) {
            List<String> pks = this.botpToOtherBill(ctx, returnCoreBillBaseCollection, botMappingInfo);
            for (int i = 0; i < pks.size(); ++i) {
                OtherInWarehsBillInfo _info = OtherInWarehsBillFactory.getLocalInstance((Context)ctx).getOtherInWarehsBillInfo((IObjectPK)new ObjectUuidPK(pks.get(i)));
                OtherInWarehsBillEntryCollection entrys = _info.getEntry();
                for (int n = 0; n < entrys.size(); ++n) {
                    OtherInWarehsBillEntryInfo entryinfo = entrys.get(n);
                    InvUpdateTypeInfo typeinfo = InvUpdateTypeFactory.getLocalInstance((Context)ctx).getInvUpdateTypeInfo((IObjectPK)new ObjectUuidPK("8r0AAAAEaOjC73rf"));
                    entryinfo.setInvUpdateType(typeinfo);
                }
                OtherInWarehsBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)_info);
            }
        }
    }

    private void mftrestruct(Context ctx, CoreBillBaseCollection returnCoreBillBaseCollection) throws BOSException, EASBizException {
        BOTMappingInfo botMappingInfo = this.getBOTMappingInfo(ctx, "GZSQ-SCGZ");
        if (botMappingInfo != null) {
            List<String> pks = this.botpToOtherBill(ctx, returnCoreBillBaseCollection, botMappingInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("bizType.*"));
            sic.add(new SelectorItemInfo("CU.*"));
            sic.add(new SelectorItemInfo("transactionType.*"));
            sic.add(new SelectorItemInfo("material.*"));
            sic.add(new SelectorItemInfo("storageOrgUnit.*"));
            sic.add(new SelectorItemInfo("project.*"));
            sic.add(new SelectorItemInfo("trackNumber.*"));
            sic.add(new SelectorItemInfo("adminOrgUnit.*"));
            sic.add(new SelectorItemInfo("scheduleType.*"));
            sic.add(new SelectorItemInfo("billType.*"));
            sic.add(new SelectorItemInfo("dispatcher.*"));
            sic.add(new SelectorItemInfo("stocks.*"));
            sic.add(new SelectorItemInfo("technics.*"));
            sic.add(new SelectorItemInfo("expectOutputs.*"));
            IManufactureOrder iManufactureOrder = ManufactureOrderFactory.getLocalInstance((Context)ctx);
            IEMMManufactureOrderEntrysGenFacade iEMMMOEGenFacade = EMMManufactureOrderEntrysGenFacadeFactory.getLocalInstance((Context)ctx);
            for (int n = 0; n < pks.size(); ++n) {
                RestructReqBillInfo srcInfo = (RestructReqBillInfo)returnCoreBillBaseCollection.get(n);
                ManufactureOrderInfo orderinfo = iManufactureOrder.getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(pks.get(n)), sic);
                iEMMMOEGenFacade.genManufactureOrderCostObject(orderinfo);
                this.reSetManfactureOrderInfo(ctx, orderinfo, srcInfo);
                HashMap<String, Object> inparam = new HashMap<String, Object>();
                this.updateStockValue(orderinfo, ctx);
                inparam.put("ManuOrderInfo", orderinfo);
                inparam.put("isSave", Boolean.FALSE);
                iEMMMOEGenFacade.genTechnicsEntrys(inparam);
                this.updateStockLineSeq(orderinfo);
                iManufactureOrder.save((CoreBaseInfo)orderinfo);
            }
        }
    }

    private void updateStockLineSeq(ManufactureOrderInfo orderinfo) {
        int group = 0;
        int lineNum = 0;
        int lineSeq = 0;
        int lastGroup = 0;
        ManufactureOrderStockCollection stocks = orderinfo.getStocks();
        if (stocks == null || stocks.size() == 0) {
            return;
        }
        for (int i = 0; i < stocks.size(); ++i) {
            String linNo = null;
            ManufactureOrderStockInfo stockinfo = stocks.get(i);
            group = stockinfo.getReplaceGroupFlag();
            if (group <= 0) {
                lineNum = 0;
                linNo = Integer.toString(lineSeq += 10);
            } else {
                if (lastGroup == group) {
                    ++lineNum;
                } else {
                    lineSeq += 10;
                    lineNum = 0;
                }
                lastGroup = group;
                linNo = lineNum > 0 ? Integer.toString(lineSeq) + "-" + Integer.toString(lineNum) : Integer.toString(lineSeq);
            }
            stockinfo.setLineSeq(linNo);
        }
    }

    public SCMEntryDataVO getDataVO(Context ctx, StorageOrgUnitInfo storageOrgUnit, MaterialInfo[] materialInfos, SCMEntryDataVO dataVO) throws EASBizException, BOSException {
        if (dataVO == null) {
            dataVO = new SCMEntryDataVO();
        }
        SCMEntryDataVO voResult = new SCMEntryDataVO();
        dataVO.setIsLoadingMaterialInventory(true);
        StorageOrgUnitInfo[] storageOrgUnitInfos = new StorageOrgUnitInfo[materialInfos.length];
        for (int i = 0; i < materialInfos.length; ++i) {
            storageOrgUnitInfos[i] = storageOrgUnit;
        }
        dataVO.setMaterialInfos(materialInfos);
        dataVO.setIsLoadingMaterialPlan(true);
        dataVO.setIsLoadingMaterialInventory(true);
        dataVO.setStorageOrgUnitInfos(storageOrgUnitInfos);
        voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(dataVO);
        Map miInfoMap = voResult.getMaterialInventoryInfos();
        Map mpInfoMap = voResult.getMaterialPlanInfos();
        MeasureUnitInfo[] measureUnitInfos = new MeasureUnitInfo[materialInfos.length];
        MeasureUnitInfo[] measureBaseUnitInfos = new MeasureUnitInfo[materialInfos.length];
        MeasureUnitInfo[] assistBaseUnitInfos = new MeasureUnitInfo[materialInfos.length];
        for (int i = 0; i < materialInfos.length; ++i) {
            measureBaseUnitInfos[i] = materialInfos[i].getBaseUnit();
            measureUnitInfos[i] = materialInfos[i].getBaseUnit();
            String key = materialInfos[i].getId().toString() + storageOrgUnit.getId().toString();
            MaterialPlanInfo mpInfo = (MaterialPlanInfo)mpInfoMap.get(key);
            if (mpInfo == null || mpInfo.getProductUnit() == null) continue;
            measureUnitInfos[i] = mpInfo.getProductUnit();
        }
        dataVO.setIsLoadingMou(true);
        dataVO.setIsLoadingMmuPrecision(true);
        dataVO.setIsLoadingMaterialPlan(false);
        dataVO.setIsLoadingMaterialInventory(false);
        dataVO.setMeasureUnitInfos(measureUnitInfos);
        dataVO.setBaseMeasureUnitInfos(measureBaseUnitInfos);
        dataVO.setAssistMeasureUnitInfos(assistBaseUnitInfos);
        voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(dataVO);
        voResult.setMaterialInventoryInfos(miInfoMap);
        voResult.setMaterialPlanInfos(mpInfoMap);
        return voResult;
    }

    private void backWriteManfactureOrderInfo(Context ctx, ManufactureOrderInfo info, RestructReqBillInfo srcObj) throws BOSException, EASBizException {
        BigDecimal btrcutqty = srcObj.getBtructqty();
        RestructType restructtype = srcObj.getRestructType();
        if (RestructType.mftRestruct.compareTo((Object)restructtype) == 0) {
            BigDecimal totalsplitqty;
            ManufactureOrderInfo orderinfo = srcObj.getManufactureorder();
            String orderid = orderinfo.getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("transactionType.*"));
            sic.add(new SelectorItemInfo("routing.*"));
            sic.add(new SelectorItemInfo("stocks.*"));
            orderinfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(orderid), sic);
            BigDecimal qty = orderinfo.getQty() == null ? BigDecimal.ZERO : orderinfo.getQty();
            BigDecimal bigDecimal = totalsplitqty = orderinfo.getTotalSplitQty() == null ? BigDecimal.ZERO : orderinfo.getTotalSplitQty();
            if (qty.compareTo(btrcutqty) > 0) {
                orderinfo.setTotalSplitQty(totalsplitqty.add(btrcutqty));
                ManufactureOrderTechnicsCollection techColls = orderinfo.getTechnics();
                BigDecimal tmpQty = orderinfo.getQty().subtract(totalsplitqty);
                for (int n = 0; n < techColls.size(); ++n) {
                    BigDecimal totaldispatchqty;
                    ManufactureOrderTechnicsInfo techinfo = techColls.get(n);
                    BigDecimal bigDecimal2 = totaldispatchqty = techinfo.getTotalDispatchQty() == null ? BigDecimal.ZERO : techinfo.getTotalDispatchQty();
                    if (totaldispatchqty.compareTo(tmpQty) <= 0) continue;
                    techinfo.setQty(tmpQty);
                }
                orderinfo.setDeliveryQty(qty.subtract(totalsplitqty));
                BigDecimal actQty = qty.subtract(btrcutqty);
                orderinfo.setQty(actQty);
                orderinfo.setOrderQty(actQty);
                ManufactureOrderStockCollection stocks = orderinfo.getStocks();
                for (int n = 0; n < stocks.size(); ++n) {
                    ManufactureOrderStockInfo stock = stocks.get(n);
                    stock.setPlannedQty(stock.getUnitQty().multiply(actQty));
                    stock.setPlannedBaseQty(stock.getUnitQty().multiply(actQty));
                    stock.setQty(stock.getUnitQty().multiply(actQty));
                    stock.setBaseQty(stock.getUnitQty().multiply(actQty));
                    if (stock.getActIssueQty().compareTo(stock.getPlannedQty()) > 0) {
                        stock.setActIssueQty(stock.getPlannedQty());
                    }
                    BigDecimal totalreceipt = stock.getTotalReceiptQty();
                    if (totalreceipt.compareTo(stock.getPlannedQty()) > 0) {
                        stock.setTotalReceiptQty(stock.getPlannedQty());
                        stock.setTotalReceiptBaseQty(stock.getPlannedQty());
                    }
                    stock.setPickLackQty(stock.getPlannedQty().multiply(BigDecimal.ONE.subtract(stock.getLackRatio())));
                    stock.setPickExtraQty(stock.getPlannedQty().multiply(BigDecimal.ONE.subtract(stock.getExtraRatio())));
                }
            }
            info.setNumber(info.getNumber() + "_1");
            ManufactureOrderFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(orderinfo.getId().toString()), (CoreBaseInfo)orderinfo);
        }
    }

    private void calcQty(BigDecimal qty, ManufactureOrderInfo orderinfo) {
        BigDecimal SplitQty = orderinfo.getTotalSplitQty();
        if (qty != null) {
            BigDecimal yield = new BigDecimal("1.0");
            if (orderinfo.getYield() != null) {
                yield = orderinfo.getYield();
                yield = yield.divide(new BigDecimal("100.00"), 4, 4);
            }
            int unitPrec = this.getUnitPrec(orderinfo);
            BigDecimal deliveryQty = qty.multiply(yield).setScale(unitPrec, 1);
            orderinfo.setDeliveryQty(deliveryQty);
            this.calculateBaseQty(orderinfo, qty);
            if (SplitQty != null) {
                this.calcLimitUpperQty(orderinfo, qty, SplitQty, unitPrec);
                this.calcLimitLowerQty(orderinfo, qty, SplitQty, unitPrec);
            } else {
                this.calcLimitUpperQty(orderinfo, qty, new BigDecimal("0.00"), unitPrec);
                this.calcLimitLowerQty(orderinfo, qty, new BigDecimal("0.00"), unitPrec);
            }
            this.setOrderQty(orderinfo);
        }
    }

    private void setOrderQty(ManufactureOrderInfo orderinfo) {
        BigDecimal qty = orderinfo.getQty();
        BigDecimal totalSplit = orderinfo.getTotalSplitQty();
        qty = qty == null ? new BigDecimal("0") : qty;
        totalSplit = totalSplit == null ? new BigDecimal("0") : totalSplit;
        orderinfo.setOrderQty(qty.subtract(totalSplit));
    }

    private void calcLimitUpperQty(ManufactureOrderInfo orderinfo, BigDecimal qty, BigDecimal SplitQty, int unitPrec) {
        BigDecimal extraRatio = orderinfo.getExtraRatio();
        extraRatio = extraRatio.divide(new BigDecimal("100.00"), 4, 4).add(new BigDecimal("1.0"));
        BigDecimal extraQty = qty.subtract(SplitQty).multiply(extraRatio).setScale(unitPrec, 0);
        orderinfo.setExtraUpperLimit(extraQty);
    }

    private void calcLimitLowerQty(ManufactureOrderInfo orderinfo, BigDecimal qty, BigDecimal SplitQty, int unitPrec) {
        BigDecimal lackRatio = orderinfo.getLackRatio();
        lackRatio = new BigDecimal("1.0").subtract(lackRatio.divide(new BigDecimal("100.00"), 4, 4));
        BigDecimal lackQty = qty.subtract(SplitQty).multiply(lackRatio).setScale(unitPrec, 0);
        orderinfo.setLackLowerLimit(lackQty);
    }

    private void calculateBaseQty(ManufactureOrderInfo orderinfo, BigDecimal qty) {
        if (qty != null && orderinfo.getUnit() != null) {
            int prec = this.getBaseUnitPrec(orderinfo);
            BigDecimal convRate = this.getConvertRate(orderinfo, orderinfo.getUnit());
            BigDecimal baseQty = qty.multiply(convRate).setScale(prec, 4);
            orderinfo.setBaseQty(baseQty);
        }
    }

    private BigDecimal getConvertRate(ManufactureOrderInfo orderinfo, MeasureUnitInfo unitInfo) {
        BigDecimal convRate = new BigDecimal("1.0");
        MaterialInfo material = orderinfo.getMaterial();
        if (material != null && unitInfo != null) {
            String string = material.getId().toString() + unitInfo.getId().toString();
        }
        return convRate;
    }

    private int getBaseUnitPrec(ManufactureOrderInfo orderinfo) {
        return this.getPrec(orderinfo, orderinfo.getBaseUnit());
    }

    private int getPrec(ManufactureOrderInfo orderinfo, MeasureUnitInfo unitInfo) {
        int prec = 2;
        MaterialInfo material = orderinfo.getMaterial();
        if (material != null && unitInfo != null) {
            String string = material.getId().toString() + unitInfo.getId().toString();
        }
        return prec;
    }

    private int getUnitPrec(ManufactureOrderInfo orderinfo) {
        return this.getPrec(orderinfo, orderinfo.getUnit());
    }

    private void reSetManfactureOrderInfo(Context ctx, ManufactureOrderInfo info, RestructReqBillInfo srcObj) throws BOSException, EASBizException {
        int n;
        String materialid = info.getMaterial().getId().toString();
        String storageOrgUnitid = info.getStorageOrgUnit().getId().toString();
        String tracknumberid = null;
        String projectid = null;
        if (info.getTrackNumber() != null) {
            tracknumberid = info.getTrackNumber().getId().toString();
        }
        if (info.getProject() != null) {
            projectid = info.getProject().getId().toString();
        }
        info.setAdminOrgUnit(this.getStorageOrgUnitByMaterialTab(ctx, materialid, storageOrgUnitid));
        info.setSourceBillType(BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("wV8Sqe4UQ8eI+vH512lGxUY+1VI=")));
        info.setSrcBillNum(srcObj.getNumber());
        info.setSourceBillId(srcObj.getId().toString());
        info.setDeliveryQty(srcObj.getCtructqty());
        info.setRemark("\u6539\u5236\u7533\u8bf7\u5355\u751f\u6210");
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (info.getStorageOrgUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitid));
        }
        if (info.getMaterial() != null) {
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialid));
        }
        filter.getFilterItems().add(new FilterItemInfo("isMainRooting", (Object)true));
        viewinfo.setFilter(filter);
        StandardRootingCollection standardcolls = StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingCollection(viewinfo);
        if (standardcolls != null && standardcolls.size() > 0) {
            info.setRouting(standardcolls.get(0));
        }
        StringBuffer _sql = new StringBuffer();
        _sql.append("select a.fid from t_mm_bom a where a.fstorageorgunitid =? and a.fprojectid = ? and a.fmaterialid = ? and fbomtype = 50");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)_sql.toString(), (Object[])new Object[]{storageOrgUnitid, projectid, materialid});
        String bomID = null;
        BomInfo bominfo = null;
        try {
            if (rs.next()) {
                bomID = rs.getString("fid");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bomID == null) {
            return;
        }
        bominfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(bomID), RestructReqFacadeControllerBean.getBomSelectSic());
        BomEntryCollection bomentrys = this._getBomChildEntryInfo(ctx, bominfo, info.getTrackNumber().getNumber());
        bominfo.getEntrys().clear();
        bominfo.getEntrys().addCollection(bomentrys);
        ArrayList<ManufactureOrderStockInfo> delStocks = new ArrayList<ManufactureOrderStockInfo>();
        for (n = 0; n < info.getStocks().size(); ++n) {
            ManufactureOrderStockInfo stockinfo = info.getStocks().get(n);
            MaterialInfo material = stockinfo.getMaterial();
            StorageOrgUnitInfo storage = stockinfo.getStorageOrgUnit();
            if (storage == null) {
                Logger.info((String)"\u751f\u4ea7\u6539\u5236\u751f\u6210\u751f\u4ea7\u5907\u6599\u5b58\u5728\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\u7684\u6570\u636e\uff01");
                throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u751f\u4ea7\u6539\u5236\u751f\u6210\u751f\u4ea7\u5907\u6599\u5b58\u5728\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6539\u5236\u7533\u8bf7\u5dee\u5f02\u6bd4\u5bf9\u5206\u5f55\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7\uff01"));
            }
            SCMEntryDataVO datavo = this.getDataVO(ctx, storage, new MaterialInfo[]{material}, null);
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(material.getId().toString());
            if (datavo != null) {
                stockinfo.setUnit(datavo.getMeasureUnitInfos()[0]);
                stockinfo.setBaseUnit(datavo.getBaseMeasureUnitInfos()[0]);
                String key = material.getId().toString() + storage.getId().toString();
                Map map = RestructReqFacadeControllerBean.getMaterialPlanMap(ctx, idSet, storage);
                MaterialPlanInfo materialPlan = (MaterialPlanInfo)map.get(key);
                if (materialPlan != null) {
                    stockinfo.setProvideType(materialPlan.getProvideType());
                }
            }
            if (srcObj.getBmaterial().getId().toString().equals(stockinfo.getMaterial().getId().toString())) {
                MaterialProvideTypeEnum providetype = this.getProvideByMaterialTab(ctx, srcObj.getBmaterial().getId().toString(), srcObj.getStorageOrgUnit().getId().toString());
                stockinfo.setProvideType(providetype);
                stockinfo.setUnitQty(srcObj.getBtructqty());
            }
            BomEntryInfo bomentry = null;
            if (stockinfo.getQty().compareTo(BigDecimal.ZERO) <= 0) {
                delStocks.add(stockinfo);
                continue;
            }
            if (bominfo != null) {
                BomEntryCollection colls = bominfo.getEntrys();
                for (int m = 0; m < colls.size(); ++m) {
                    BomEntryInfo tmpBomEntryInfo = colls.get(m);
                    if (!tmpBomEntryInfo.getMaterial().getId().toString().equals(stockinfo.getMaterial().getId().toString())) continue;
                    bomentry = tmpBomEntryInfo;
                    break;
                }
            }
            if (bomentry != null) {
                stockinfo.setProvideType(bomentry.getProvideType());
                stockinfo.setStorageOrgUnit(bomentry.getSupplyOrgUnit());
                stockinfo.setWarehouse(bomentry.getDefaultWarehouse());
                stockinfo.setIsBackflush(bomentry.isIsBackFlush());
            }
            RestructReqBillEntryCollection reseColl = srcObj.getEntrys();
            for (int j = 0; j < reseColl.size(); ++j) {
                RestructReqBillEntryInfo restEntryInfo = reseColl.get(j);
                if (!StringUtil.equals((String)material.getId().toString(), (String)restEntryInfo.getMaterial().getId().toString())) continue;
                stockinfo.setUnitQty(restEntryInfo.getCunitqty());
                stockinfo.setQty(restEntryInfo.getCqty());
                stockinfo.setPlannedQty(restEntryInfo.getCqty());
                stockinfo.setBaseUnit(restEntryInfo.getBaseUnit());
                stockinfo.setUnit(restEntryInfo.getBaseUnit());
                break;
            }
            int operationNo = RestructReqFacadeControllerBean.getOperationNoFromPBom(ctx, materialid, projectid, tracknumberid, material.getId().toString());
            stockinfo.setOperationNo(operationNo);
        }
        for (n = 0; n < delStocks.size(); ++n) {
            info.getStocks().remove((ManufactureOrderStockInfo)delStocks.get(n));
        }
    }

    private static int getOperationNoFromPBom(Context ctx, String productid, String projectID, String tracknumberid, String materialid) throws BOSException, EASBizException {
        int wpSeq = 10;
        if (StringUtil.isEmptyString((String)productid) || StringUtil.isEmptyString((String)projectID) || StringUtil.isEmptyString((String)tracknumberid) || StringUtil.isEmptyString((String)materialid)) {
            return wpSeq;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select rootingitem.FWpSeq WpSeq \r\n");
        sql.append(" FROM T_MM_PBOM pbom \r\n");
        sql.append(" LEFT OUTER JOIN T_MM_Bom bom\r\n");
        sql.append(" ON pbom.FBomID = bom.FID\r\n");
        sql.append(" LEFT OUTER JOIN T_MM_PBOMEntry e \r\n");
        sql.append(" ON pbom.FID = e.FParentID \r\n");
        sql.append(" LEFT OUTER JOIN T_MM_MaterialRWP rootingitem \r\n");
        sql.append(" ON e.FRoutingItemID = rootingitem.FID \r\n");
        sql.append(" where bom.fmaterialid = ?  \r\n");
        sql.append(" and pbom.fprojectid = ? \r\n");
        sql.append(" and e.CFSTraceID<=?\r\n");
        sql.append(" and e.CFETraceID>=?\r\n");
        sql.append(" and e.CFMaterialID = ?\r\n");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{productid, projectID, tracknumberid, tracknumberid, materialid});
        try {
            if (rs.next()) {
                wpSeq = rs.getInt("WpSeq");
                return wpSeq;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Logger.error((Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u67e5\u627e\u5de5\u5e8fBOM\u51fa\u9519\uff01"));
        }
        return wpSeq;
    }

    private static Map getMaterialPlanMap(Context ctx, Set idSet, StorageOrgUnitInfo storage) throws BOSException {
        HashMap<String, MaterialPlanInfo> map = new HashMap<String, MaterialPlanInfo>();
        String storageOrgUnitId = storage.getId().toString();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("issMode"));
        selectorItemCollection.add(new SelectorItemInfo("isBackFlush"));
        selectorItemCollection.add(new SelectorItemInfo("isQuotaControl"));
        selectorItemCollection.add(new SelectorItemInfo("productTranType.*"));
        selectorItemCollection.add(new SelectorItemInfo("supplyOrgUnit.id"));
        selectorItemCollection.add(new SelectorItemInfo("supplyOrgUnit.name"));
        selectorItemCollection.add(new SelectorItemInfo("supplyOrgUnit.number"));
        selectorItemCollection.add(new SelectorItemInfo("issInHightLimit"));
        selectorItemCollection.add(new SelectorItemInfo("issInLowLimit"));
        selectorItemCollection.add(new SelectorItemInfo("scrapRateExpression"));
        selectorItemCollection.add(new SelectorItemInfo("scrapRate"));
        selectorItemCollection.add(new SelectorItemInfo("isStockAllot"));
        selectorItemCollection.add(new SelectorItemInfo("fromInvOrg.id"));
        selectorItemCollection.add(new SelectorItemInfo("fromInvOrg.name"));
        selectorItemCollection.add(new SelectorItemInfo("fromInvOrg.number"));
        selectorItemCollection.add(new SelectorItemInfo("fromWarehouse.id"));
        selectorItemCollection.add(new SelectorItemInfo("fromWarehouse.name"));
        selectorItemCollection.add(new SelectorItemInfo("fromWarehouse.number"));
        selectorItemCollection.add(new SelectorItemInfo("provideType"));
        selectorItemCollection.add(new SelectorItemInfo("isolatedRule"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)idSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialPlanCollection materialPlanCollection = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(entityViewInfo);
        if (materialPlanCollection != null && materialPlanCollection.size() > 0) {
            int size = materialPlanCollection.size();
            for (int i = 0; i < size; ++i) {
                MaterialPlanInfo materialPlanInfo = materialPlanCollection.get(i);
                map.put(materialPlanInfo.getMaterial().getId() + storageOrgUnitId, materialPlanInfo);
            }
        }
        return map;
    }

    public MaterialProvideTypeEnum getProvideByMaterialTab(Context ctx, String materialid, String storageid) throws BOSException, EASBizException {
        MaterialPlanInfo materialPlanInfo = Material8FacadeFactory.getLocalInstance((Context)ctx).getPlanInfo(materialid, storageid);
        SelectorItemCollection items = new SelectorItemCollection();
        items.add(new SelectorItemInfo("supplyOrgUnit.*"));
        items.add(new SelectorItemInfo("*"));
        materialPlanInfo = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanInfo((IObjectPK)new ObjectUuidPK(materialPlanInfo.getId().toString()), items);
        return materialPlanInfo.getProvideType();
    }

    private static final SelectorItemCollection getBomSelectSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bomType"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("productQty"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.supplyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entrys.supplyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entrys.beginCarno.id"));
        sic.add(new SelectorItemInfo("entrys.beginCarno.number"));
        sic.add(new SelectorItemInfo("entrys.endCarno.id"));
        sic.add(new SelectorItemInfo("entrys.endCarno.number"));
        sic.add(new SelectorItemInfo("entrys.material.id"));
        sic.add(new SelectorItemInfo("entrys.material.number"));
        sic.add(new SelectorItemInfo("entrys.material.name"));
        sic.add(new SelectorItemInfo("entrys.unit.id"));
        sic.add(new SelectorItemInfo("entrys.unit.number"));
        sic.add(new SelectorItemInfo("entrys.material.baseUnit.id"));
        sic.add(new SelectorItemInfo("entrys.material.baseUnit.number"));
        sic.add(new SelectorItemInfo("entrys.defaultWarehouse.id"));
        sic.add(new SelectorItemInfo("entrys.transferWarehouse.id"));
        return sic;
    }

    public AdminOrgUnitInfo getStorageOrgUnitByMaterialTab(Context ctx, String materialid, String storageid) throws BOSException, EASBizException {
        MaterialPlanInfo materialPlanInfo = Material8FacadeFactory.getLocalInstance((Context)ctx).getPlanInfo(materialid, storageid);
        SelectorItemCollection items = new SelectorItemCollection();
        items.add(new SelectorItemInfo("dutyDepartment.*"));
        materialPlanInfo = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanInfo((IObjectPK)new ObjectUuidPK(materialPlanInfo.getId().toString()), items);
        return materialPlanInfo.getDutyDepartment();
    }

    protected BOTMappingInfo getBOTMappingInfo(Context ctx, String name) throws BOSException, EASBizException {
        if (name == null) {
            return null;
        }
        if (name.trim().length() == 0) {
            return null;
        }
        BOTMappingInfo botMappingInfo = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("extRule.isEffected", (Object)true, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        BOTMappingCollection botMappingCollection = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingCollection(entityViewInfo);
        if (botMappingCollection != null && botMappingCollection.size() > 0) {
            botMappingInfo = botMappingCollection.get(0);
        }
        if (botMappingInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u83b7\u53d6\u7f16\u7801\u89c4\u5219\u5931\u8d25", "\u6ca1\u6709\u627e\u5230\u542f\u7528\u72b6\u6001\u7684\u7f16\u7801\u4e3a " + name + " \u7684\u8f6c\u6362\u89c4\u5219"));
        }
        return botMappingInfo;
    }

    protected List<String> botpToOtherBill(Context ctx, CoreBillBaseCollection CollInfo, BOTMappingInfo botInfo) throws BOSException, EASBizException {
        IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
        ArrayList<String> pks = new ArrayList<String>();
        BTPTransformResult result = null;
        try {
            result = btp.transform(CollInfo, botInfo);
        }
        catch (BTPException e) {
            StringBuffer exceptionMessage = new StringBuffer();
            exceptionMessage.append("BOTP [").append(botInfo == null || botInfo.getName() == null ? "" : botInfo.getName()).append("] \uff0c\u63a8\u5355\u636e\u5931\u8d25,\u9519\u8bef\u4fe1\u606f:").append(e.getMessage());
            throw new EASBizException(new NumericExceptionSubItem("BOTP\u63a8\u5355\u636e\u5931\u8d25", exceptionMessage.toString()));
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        BOTRelationCollection relations = result.getBOTRelationCollection();
        IObjectCollection bills = result.getBills();
        for (int a = 0; a < bills.size(); ++a) {
            SCMBillBaseInfo ma = (SCMBillBaseInfo)bills.getObject(a);
            this.resetOtherValueToBill(ctx, ma);
            IObjectPK pk = btp.saveRelations((CoreBillBaseInfo)ma, relations);
            pks.add(pk.toString());
        }
        return pks;
    }

    private void resetOtherValueToBill(Context ctx, SCMBillBaseInfo ma) throws BOSException, EASBizException {
        BillTypeInfo tranTypeinfo;
        if (ma instanceof MaterialReqBillInfo) {
            this.resetMaterialReq(ctx, (MaterialReqBillInfo)ma);
        } else if (ma instanceof OtherInWarehsBillInfo) {
            TransactionTypeInfo tranTypeinfo2 = ((OtherInWarehsBillInfo)ma).getTransactionType();
            if (ma.getBillType() == null && tranTypeinfo2.getBillType() != null) {
                BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(tranTypeinfo2.getBillType().getId()));
                ma.setBillType(billTypeInfo);
            }
        } else if (ma instanceof ManufactureOrderInfo && (tranTypeinfo = ((ManufactureOrderInfo)ma).getBillType()) == null) {
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"B2aZSVXaSx6qxdfekgCmrEY+1VI="));
            ma.setBillType(billType);
        }
    }

    private void resetMaterialReq(Context ctx, MaterialReqBillInfo ma) throws BOSException, EASBizException {
        MaterialReqBillEntryCollection reqentrycol = ma.getEntry();
        String orgid = ma.getSupplyStoreOrgUnit() == null ? null : ma.getSupplyStoreOrgUnit().getId().toString();
        TransactionTypeInfo tranTypeinfo = ma.getTransactionType();
        if (ma.getBillType() == null && tranTypeinfo.getBillType() != null) {
            BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(tranTypeinfo.getBillType().getId()));
            ma.setBillType(billTypeInfo);
        }
        MaterialReqBillEntryCollection reqentrycol2 = (MaterialReqBillEntryCollection)reqentrycol.clone();
        for (int i = 0; i < reqentrycol2.size(); ++i) {
            ManufactureOrderInfo manufactureorerInfo;
            CostCenterOrgUnitInfo ccInfo;
            WorkCenterInfo wcinfo;
            MaterialReqBillEntryInfo materialentryinfo = reqentrycol2.get(i);
            if (materialentryinfo.getMaterial() == null) {
                reqentrycol.remove(reqentrycol2.get(i));
                continue;
            }
            MaterialReqBillEntryInfo entry = reqentrycol.get(i);
            boolean isBackFlush = this.getisbackflush(ctx, entry.getMaterial().getId().toString(), orgid);
            entry.put("isBackFlush", (Object)isBackFlush);
            if (isBackFlush && entry.getWorkCenter() != null) {
                String storageid;
                String workcenterid = entry.getWorkCenter().getId().toString();
                WarehouseInfo backWareHouse = this.getbackWareHouse(ctx, workcenterid, storageid = ma.getStorageOrgUnit().getId().toString());
                if (backWareHouse == null) {
                    backWareHouse = this.getdaultwareHose(ma, ctx, entry);
                }
                entry.put("backFlushWareHouse", (Object)backWareHouse);
            }
            if (entry.getWorkCenter() != null && (wcinfo = WorkCenterFactory.getLocalInstance((Context)ctx).getWorkCenterInfo((IObjectPK)new ObjectUuidPK(entry.getWorkCenter().getId()))).getCostCenter() != null) {
                ccInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(wcinfo.getCostCenter().getId()));
                entry.setCostCenterOrgUnit(ccInfo);
            }
            if (entry.getSourceBillId() != null && entry.getCostObject() == null && ManufactureOrderFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(entry.getSourceBillId())) && (manufactureorerInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(entry.getSourceBillId()))).getCostObject() != null) {
                ccInfo = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectInfo((IObjectPK)new ObjectUuidPK(manufactureorerInfo.getCostObject().getId()));
                entry.setCostObject((CostObjectInfo)ccInfo);
            }
            entry.setInvUpdateType(TransactionTypeUtils.getInvUpdateTypeServer((Context)ctx, (TransactionTypeInfo)tranTypeinfo));
        }
    }

    protected boolean getisbackflush(Context ctx, String materialid, String orgid) throws EASBizException, BOSException {
        new StringBuffer();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection mpSelectorItemCollection = new SelectorItemCollection();
        mpSelectorItemCollection.add(new SelectorItemInfo("id"));
        mpSelectorItemCollection.add(new SelectorItemInfo("isBackFlush"));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgunit.id", (Object)orgid, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(mpSelectorItemCollection);
        MaterialPlanCollection mpc = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(viewInfo);
        if (mpc == null || mpc.size() == 0) {
            return false;
        }
        MaterialPlanInfo info = mpc.get(0);
        if (info == null) {
            return false;
        }
        return info.isIsBackFlush();
    }

    protected WarehouseInfo getbackWareHouse(Context ctx, String workcenterid, String storageid) throws EASBizException, BOSException {
        if (workcenterid == null || storageid == null || workcenterid.trim().length() == 0 || storageid.trim().length() == 0) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("backWareHouse.id"));
        sic.add(new SelectorItemInfo("backWareHouse.number"));
        sic.add(new SelectorItemInfo("backWareHouse.name"));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)workcenterid, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.setSelector(sic);
        WorkCenterCollection wcs = WorkCenterFactory.getLocalInstance((Context)ctx).getWorkCenterCollection(ev);
        if (wcs == null || wcs.size() == 0) {
            return null;
        }
        WorkCenterInfo wc = wcs.get(0);
        if (wc.get("backWareHouse") == null || !(wc.get("backWareHouse") instanceof WarehouseInfo)) {
            return null;
        }
        return (WarehouseInfo)wc.get("backWareHouse");
    }

    protected WarehouseInfo getdaultwareHose(MaterialReqBillInfo info, Context ctx, MaterialReqBillEntryInfo entry) throws EASBizException, BOSException {
        String sourceBillTypeId = null;
        if (!StringUtils.isEmpty((String)info.getSourceBillId()) && info.getSourceBillType() != null) {
            sourceBillTypeId = info.getSourceBillType().getId().toString();
        }
        if (sourceBillTypeId != null && "B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(sourceBillTypeId)) {
            String srcid = entry.getSourceBillId();
            StringBuffer oql = new StringBuffer();
            oql.append("select transactionType.defaultBFWarehouse.id where id='").append(srcid).append("'");
            ManufactureOrderInfo manufactureOrderInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo(oql.toString());
            return manufactureOrderInfo.getTransactionType().getDefaultBFWarehouse();
        }
        return null;
    }

    protected BomEntryCollection _getBomChildEntryInfo(Context ctx, BomInfo bomInfo, String trackNumber) throws BOSException, EASBizException {
        if (bomInfo == null) {
            return null;
        }
        BomEntryCollection retrunColl = new BomEntryCollection();
        BomEntryCollection bomEntryCollection = bomInfo.getEntrys();
        BomEntryCollection loopBomEntryCollection = (BomEntryCollection)bomEntryCollection.clone();
        BOMTypeEnum bomTypeEnum = bomInfo.getBomType();
        retrunColl = (BomEntryCollection)bomEntryCollection.clone();
        BomInfo childinfo = null;
        ArrayList<String> loopBomEntryIDList = new ArrayList<String>();
        while (loopBomEntryCollection.size() > 0) {
            BomEntryInfo loopBomEntryInfo = loopBomEntryCollection.get(0);
            if (loopBomEntryIDList.contains(loopBomEntryInfo.getId().toString())) {
                loopBomEntryCollection.remove(loopBomEntryInfo);
                continue;
            }
            loopBomEntryIDList.add(loopBomEntryInfo.getId().toString());
            MaterialInfo materialInfo = loopBomEntryInfo.getMaterial();
            StorageOrgUnitInfo storageOrgUnitInfo = loopBomEntryInfo.getSupplyOrgUnit();
            BigDecimal fqty = loopBomEntryInfo.getConsumeFixQty();
            if (fqty != null && fqty.compareTo(BigDecimal.ZERO) > 0) {
                if (trackNumber != null && !"".equals(trackNumber)) {
                    TrackNumberInfo beginTracknumberInfo = loopBomEntryInfo.getBeginCarno();
                    TrackNumberInfo endTracknumberInfo = loopBomEntryInfo.getEndCarno();
                    if (beginTracknumberInfo == null || endTracknumberInfo == null || beginTracknumberInfo.getNumber().compareTo(trackNumber) > 0 || endTracknumberInfo.getNumber().compareTo(trackNumber) < 0) continue;
                }
                if ((childinfo = this.getBomInfo_Child(ctx, materialInfo.getId().toString(), storageOrgUnitInfo.getId().toString(), bomInfo.getProject().getId().toString(), bomTypeEnum.getValue(), RestructReqFacadeControllerBean.getBomSelectSic())) != null && childinfo.getEntrys() != null && childinfo.getEntrys().size() > 0) {
                    for (int j = 0; j < childinfo.getEntrys().size(); ++j) {
                        BomEntryInfo childBomentryInfo = childinfo.getEntrys().get(j);
                        childBomentryInfo.setConsumeFixBaseQty(childBomentryInfo.getConsumeFixBaseQty().multiply(fqty));
                        childBomentryInfo.setConsumeFixQty(childBomentryInfo.getConsumeFixQty().multiply(fqty));
                        loopBomEntryCollection.add(childBomentryInfo);
                        retrunColl.add(childBomentryInfo);
                    }
                }
            }
            loopBomEntryCollection.remove(loopBomEntryInfo);
        }
        return retrunColl;
    }

    private BomInfo getBomInfo_Child(Context ctx, String materialID, String forgUnitID, String fprojectID, int bomTypeEnumValue, SelectorItemCollection sic) throws BOSException, EASBizException {
        BomInfo bomInfo = null;
        String PMRP_USELDBOM = this.getParamValue(ctx, "PMRP_USELDBOM", forgUnitID);
        Boolean is_PMRP_USELDBOM = PMRP_USELDBOM == null ? false : "true".equals(PMRP_USELDBOM);
        int loop = 1;
        if (is_PMRP_USELDBOM.booleanValue()) {
            loop = 2;
        }
        for (int i = 0; i < loop; ++i) {
            BomCollection bomCollection;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)forgUnitID));
            filterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)fprojectID));
            filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4));
            if (is_PMRP_USELDBOM.booleanValue()) {
                if (i == 0) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("bomType", (Object)90));
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("bomType", (Object)50));
                }
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("bomType", (Object)50));
            }
            viewInfo.setFilter(filterInfo);
            if (sic != null && sic.size() > 0) {
                viewInfo.setSelector(sic);
            }
            if ((bomCollection = BomFactory.getLocalInstance((Context)ctx).getBomCollection(viewInfo)) == null || bomCollection.size() <= 0) continue;
            bomInfo = bomCollection.get(0);
            break;
        }
        return bomInfo;
    }

    protected String getParamValue(Context ctx, String paramName, String storageOrgUnitID) throws BOSException, EASBizException {
        if (storageOrgUnitID == null) {
            return null;
        }
        String value = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("value"));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)storageOrgUnitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)paramName, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        ParamItemCollection paramItemCollection = ParamItemFactory.getLocalInstance((Context)ctx).getParamItemCollection(entityViewInfo);
        if (paramItemCollection != null && paramItemCollection.size() > 0 && paramItemCollection.get(0) != null) {
            value = paramItemCollection.get(0).getValue() == null ? "" : paramItemCollection.get(0).getValue();
        }
        return value;
    }

    public int executeSQL(Context ctx, String sql) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            long startTime = System.currentTimeMillis();
            int effectedRows = statement.executeUpdate(sql);
            long endTime = System.currentTimeMillis();
            long duration = (endTime - startTime) / 1000L;
            System.out.println("Execute SQL Effected Rows " + effectedRows + " Duration " + duration + " Sec:\r\n" + sql.toString());
            int n = effectedRows;
            return n;
        }
        catch (SQLException e) {
            throw new BOSException(sql, (Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    private void updateStockValue(ManufactureOrderInfo orderinfo, Context ctx) throws BOSException, EASBizException {
        ManufactureOrderStockCollection stocks = orderinfo.getStocks();
        if (stocks == null || stocks.size() == 0) {
            return;
        }
        for (int i = 0; i < stocks.size(); ++i) {
            ManufactureOrderStockInfo stockinfo = stocks.get(i);
            MaterialInfo material = stockinfo.getMaterial();
            if (stockinfo.getProvideType() != null) {
                if (stockinfo.getProvideType() == MaterialProvideTypeEnum.CURRENTORGPROVIDE) {
                    stockinfo.setPickType(PickTypeEnum.INNERORG);
                } else if (stockinfo.getProvideType() == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE && stockinfo.getStorageOrgUnit() != null && stockinfo.getReceiptStroageOrgUnit() != null && StringUtils.equals((String)stockinfo.getStorageOrgUnit().getId().toString(), (String)stockinfo.getReceiptStroageOrgUnit().getId().toString())) {
                    stockinfo.setPickType(PickTypeEnum.INNERORG);
                } else {
                    StringBuffer sql = new StringBuffer();
                    sql.append("select tm.FProvideType from T_BD_Material t left outer join T_BD_MaterialPlan tm on t.FID = tm.FMaterialID where tm.FOrgUnit = '");
                    sql.append(orderinfo.getStorageOrgUnit().getId().toString() + "'");
                    sql.append(" and t.fid = '");
                    sql.append(material.getId().toString() + "'");
                    IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    try {
                        if (row.next()) {
                            int value = row.getInt("FProvideType");
                            MaterialProvideTypeEnum provideenum = MaterialProvideTypeEnum.getEnum((int)value);
                            if (provideenum == MaterialProvideTypeEnum.CURRENTORGPROVIDE) {
                                stockinfo.setPickType(PickTypeEnum.INNERORG);
                            } else if (provideenum == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE && stockinfo.getStorageOrgUnit() != null && stockinfo.getReceiptStroageOrgUnit() != null && StringUtils.equals((String)stockinfo.getStorageOrgUnit().getId().toString(), (String)stockinfo.getReceiptStroageOrgUnit().getId().toString())) {
                                stockinfo.setPickType(PickTypeEnum.INNERORG);
                            } else {
                                stockinfo.setPickType(PickTypeEnum.OTHERSTORAGE);
                            }
                            stockinfo.setProvideType(MaterialProvideTypeEnum.getEnum((int)value));
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            IStandardRooting routing = StandardRootingFactory.getLocalInstance((Context)ctx);
            EntityViewInfo rootingviewInfo = new EntityViewInfo();
            FilterInfo rootingfilter = new FilterInfo();
            rootingfilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orderinfo.getStorageOrgUnit().getId().toString()));
            rootingfilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)orderinfo.getMaterial().getId().toString()));
            rootingviewInfo.setFilter(rootingfilter);
            CoreBaseCollection rootingcol = routing.getCollection(rootingviewInfo);
            if (rootingcol != null && rootingcol.size() > 0) {
                StandardRootingInfo standardRootingInfo = (StandardRootingInfo)rootingcol.get(0);
                orderinfo.setRouting(standardRootingInfo);
            }
            if (orderinfo.getRouting() == null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orderinfo.getStorageOrgUnit().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)"-"));
                viewInfo.setFilter(filter);
                CoreBaseCollection col = routing.getCollection(viewInfo);
                if (col != null && col.size() > 0) {
                    StandardRootingInfo standardRootingInfo = (StandardRootingInfo)col.get(0);
                    orderinfo.setRouting(standardRootingInfo);
                }
            }
            if (orderinfo.getBomNum() == null) {
                orderinfo.setBomNum("-");
            }
            if (stockinfo.getActIssueQty() == null) {
                stockinfo.setActIssueQty(BigDecimal.ZERO);
                stockinfo.setActIssueBaseQty(BigDecimal.ZERO);
            }
            if (stockinfo.getUnit() == null) {
                MaterialInfo info = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId().toString()));
                stockinfo.setUnit(info.getBaseUnit());
                stockinfo.setBaseUnit(info.getBaseUnit());
            }
            stockinfo.setUnIssueQty(stockinfo.getPlannedQty().subtract(stockinfo.getActIssueQty()));
            stockinfo.setUnIssueBaseQty(stockinfo.getPlannedBaseQty().subtract(stockinfo.getActIssueBaseQty()));
            stockinfo.setAssociateQty(stockinfo.getQty());
            stockinfo.setMatReplaceType(MaterialReplaceTypeEnum.NONE);
            stockinfo.setOriginalPlanQty(stockinfo.getPlannedQty());
            stockinfo.setOriginalPlanBaseQty(stockinfo.getPlannedQty());
            boolean isfind = false;
            ManufactureOrderTechnicsInfo updateTechInfo = null;
            if (orderinfo.getTechnics() != null && orderinfo.getTechnics().size() > 0) {
                updateTechInfo = orderinfo.getTechnics().get(0);
                isfind = true;
            }
            if (!isfind) continue;
            stockinfo.setDemandTime(updateTechInfo.getEarlistWoktime());
        }
    }
}

