/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.restruct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLog;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillEntryCollection;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillEntryInfo;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillFactory;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillInfo;
import com.kingdee.eas.industry.emm.mm.restruct.RestructType;
import com.kingdee.eas.industry.emm.mm.restruct.app.AbstractRestructReqBillControllerBean;
import com.kingdee.eas.industry.update8.Material8FacadeFactory;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillEntryBaseCollection;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class RestructReqBillControllerBean
extends AbstractRestructReqBillControllerBean {
    private static final long serialVersionUID = -7339736936128072596L;

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
        this._writeLogs(ctx, model, "addnew", "\u65b0\u589e");
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RestructReqBillInfo restruct = (RestructReqBillInfo)model;
        MaterialInfo binfo = restruct.getBmaterial();
        MaterialInfo cinfo = restruct.getCmaterial();
        StringBuffer sql = new StringBuffer();
        sql.append("select tm.FManufactureStrategyID from T_BD_Material t left outer join T_BD_MaterialPlan tm on t.FID = tm.FMaterialID where tm.FOrgUnit = '");
        sql.append(restruct.getStorageOrgUnit().getId().toString() + "'");
        sql.append(" and t.fid in(");
        sql.append("'" + binfo.getId().toString()).append("',").append("'" + cinfo.getId().toString() + "')");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int i = 0;
        String[] rn = new String[2];
        try {
            while (row.next()) {
                rn[i] = row.getString("FManufactureStrategyID");
                ++i;
            }
            if (!rn[0].equals(rn[1])) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.restruct.EMMEMMmrestructResource", (String)"ManufactureStrategy_diff")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
        if (restruct.getBproject() != null && restruct.getCproject() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.restruct.EMMEMMmrestructResource", (String)"Project_diff")));
        }
        if (restruct.getBtracknumber() != null && restruct.getCtracknumber() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.restruct.EMMEMMmrestructResource", (String)"Track_diff")));
        }
        super._save(ctx, pk, model);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._submit(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RestructReqBillInfo model = this.getRestructReqBillInfo(ctx, pk);
        this._writeLogs(ctx, (IObjectValue)model, "delete", "\u5220\u9664");
        super._delete(ctx, pk);
    }

    public void passAudit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        RestructReqBillInfo info = this.getRestructReqBillInfo(ctx, pk);
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        info.setAuditTime(new Timestamp(new Date().getTime()));
        this.writeBackManufactureOrder(ctx, info, "Audit");
        RestructReqBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
        info.setNumber(info.getNumber() + "_1");
        this._writeLogs(ctx, (IObjectValue)info, "audit", "\u5ba1\u6838");
        super.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    private void writeBackManufactureOrder(Context ctx, RestructReqBillInfo info, String action) throws BOSException, EASBizException {
        BigDecimal btrcutqty = info.getBtructqty();
        RestructType restructtype = info.getRestructType();
        if (RestructType.mftRestruct.compareTo((Object)restructtype) == 0) {
            BigDecimal totalsplitqty;
            IManufactureOrder iMnufactureOrder = ManufactureOrderFactory.getLocalInstance((Context)ctx);
            ManufactureOrderInfo orderinfo = info.getManufactureorder();
            String orderid = orderinfo.getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("transactionType.*"));
            sic.add(new SelectorItemInfo("routing.*"));
            sic.add(new SelectorItemInfo("stocks.*"));
            sic.add(new SelectorItemInfo("technics.totalDispatchQty"));
            sic.add(new SelectorItemInfo("technics.operQty"));
            orderinfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(orderid), sic);
            BigDecimal qty = orderinfo.getQty() == null ? BigDecimal.ZERO : orderinfo.getQty();
            BigDecimal bigDecimal = totalsplitqty = orderinfo.getTotalSplitQty() == null ? BigDecimal.ZERO : orderinfo.getTotalSplitQty();
            if (StringUtil.equals((String)"Audit", (String)action)) {
                if (qty.compareTo(btrcutqty) >= 0) {
                    totalsplitqty = totalsplitqty.add(btrcutqty);
                    orderinfo.setTotalSplitQty(totalsplitqty);
                    ManufactureOrderTechnicsCollection techColls = orderinfo.getTechnics();
                    BigDecimal actQty = qty.subtract(totalsplitqty);
                    orderinfo.setExtraUpperLimit(actQty.multiply(BigDecimal.ONE.add(orderinfo.getExtraRatio())));
                    orderinfo.setExtraUpperLimitBase(actQty.multiply(BigDecimal.ONE.add(orderinfo.getExtraRatio())));
                    orderinfo.setLackLowerLimit(actQty.multiply(BigDecimal.ONE.subtract(orderinfo.getLackRatio())));
                    orderinfo.setLackLowerLimitBase(actQty.multiply(BigDecimal.ONE.subtract(orderinfo.getLackRatio())));
                    for (int n = 0; n < techColls.size(); ++n) {
                        BigDecimal totaldispatchqty;
                        ManufactureOrderTechnicsInfo techinfo = techColls.get(n);
                        BigDecimal bigDecimal2 = totaldispatchqty = techinfo.getTotalDispatchQty() == null ? BigDecimal.ZERO : techinfo.getTotalDispatchQty();
                        if (totaldispatchqty.compareTo(actQty) > 0) continue;
                        techinfo.setOperQty(actQty);
                    }
                    orderinfo.setDeliveryQty(actQty);
                    orderinfo.setOrderQty(actQty);
                    ManufactureOrderStockCollection stocks = orderinfo.getStocks();
                    for (int n = 0; n < stocks.size(); ++n) {
                        ManufactureOrderStockInfo stock = stocks.get(n);
                        stock.setPlannedQty(stock.getUnitQty().multiply(actQty));
                        stock.setPlannedBaseQty(stock.getUnitQty().multiply(actQty));
                        stock.setQty(stock.getUnitQty().multiply(actQty));
                        stock.setBaseQty(stock.getUnitQty().multiply(actQty));
                        if (stock.getActIssueQty().compareTo(stock.getPlannedQty()) > 0) {
                            stock.setActIssueQty(stock.getPlannedQty());
                        }
                        stock.setUnIssueQty(stock.getPlannedQty().subtract(stock.getActIssueQty()));
                        stock.setPickLackQty(stock.getPlannedQty().multiply(BigDecimal.ONE.subtract(stock.getLackRatio())));
                        stock.setPickLackBaseQty(stock.getPlannedQty().multiply(BigDecimal.ONE.subtract(stock.getLackRatio())));
                        stock.setPickExtraQty(stock.getPlannedQty().multiply(BigDecimal.ONE.add(stock.getExtraRatio())));
                        stock.setPickExtraBaseQty(stock.getPlannedQty().multiply(BigDecimal.ONE.add(stock.getExtraRatio())));
                    }
                    if (qty.compareTo(totalsplitqty) == 0) {
                        info.setLastMFTStatus(orderinfo.getBaseStatus());
                        orderinfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
                    }
                }
            } else if (StringUtil.equals((String)"UnAudit", (String)action) && qty.compareTo(btrcutqty) >= 0) {
                totalsplitqty = totalsplitqty.subtract(btrcutqty);
                orderinfo.setTotalSplitQty(totalsplitqty);
                ManufactureOrderTechnicsCollection techColls = orderinfo.getTechnics();
                for (int n = 0; n < techColls.size(); ++n) {
                    BigDecimal operQty;
                    ManufactureOrderTechnicsInfo techinfo = techColls.get(n);
                    BigDecimal bigDecimal3 = operQty = techinfo.getOperQty() == null ? BigDecimal.ZERO : techinfo.getOperQty();
                    if (operQty.subtract(qty).compareTo(BigDecimal.ZERO) != -1) continue;
                    techinfo.setOperQty(operQty.add(btrcutqty));
                }
                orderinfo.setDeliveryQty(orderinfo.getDeliveryQty().add(btrcutqty));
                BigDecimal orderQty = orderinfo.getOrderQty() == null ? BigDecimal.ZERO : orderinfo.getOrderQty();
                orderinfo.setOrderQty(orderQty.add(btrcutqty));
                orderinfo.setExtraUpperLimit(orderQty.multiply(BigDecimal.ONE.add(orderinfo.getExtraRatio())));
                orderinfo.setExtraUpperLimitBase(orderQty.multiply(BigDecimal.ONE.add(orderinfo.getExtraRatio())));
                orderinfo.setLackLowerLimit(orderQty.multiply(BigDecimal.ONE.subtract(orderinfo.getLackRatio())));
                orderinfo.setLackLowerLimitBase(orderQty.multiply(BigDecimal.ONE.subtract(orderinfo.getLackRatio())));
                ManufactureOrderStockCollection stocks = orderinfo.getStocks();
                for (int n = 0; n < stocks.size(); ++n) {
                    ManufactureOrderStockInfo stock = stocks.get(n);
                    stock.setPlannedQty(stock.getUnitQty().multiply(qty));
                    stock.setPlannedBaseQty(stock.getUnitQty().multiply(qty));
                    stock.setQty(stock.getUnitQty().multiply(qty));
                    stock.setBaseQty(stock.getUnitQty().multiply(qty));
                    BigDecimal actIssueBaseQty = stock.getActIssueBaseQty() == null ? BigDecimal.ZERO : stock.getActIssueBaseQty();
                    StringBuffer sql = new StringBuffer();
                    sql.append(" select IsNull(sum(e.fqty),0) qty from \r\n");
                    sql.append(" T_IM_MaterialReqBillEntry e\r\n");
                    sql.append(" inner join T_IM_MaterialReqBill t on e.fparentid = t.fid\r\n");
                    sql.append(" LEFT OUTER JOIN T_SCM_TransactionType tsc on t.FTransactionTypeID = tsc.fid \r\n");
                    sql.append(" left join T_IM_RecIssueType ri on tsc.fritypeid = ri.fid \r\n");
                    sql.append(" where FSourceBillEntryID = ?\r\n");
                    sql.append(" and ri.fnumber = '005' \r\n");
                    IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{stock.getId().toString()});
                    BigDecimal reqIssueQty = BigDecimal.ZERO;
                    try {
                        while (rs.next()) {
                            reqIssueQty = rs.getBigDecimal("qty");
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        throw new EASBizException(new NumericExceptionSubItem("", "\u83b7\u53d6\u751f\u4ea7\u8ba2\u5355\u4e0b\u6e38\u9886\u6599\u51fa\u5e93\u5355\u5206\u5f55\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
                    }
                    if (reqIssueQty.compareTo(actIssueBaseQty) == 1) {
                        stock.setActIssueBaseQty(reqIssueQty);
                    }
                    stock.setPickLackQty(stock.getPlannedQty().multiply(BigDecimal.ONE.subtract(stock.getLackRatio())));
                    stock.setPickLackBaseQty(stock.getPlannedQty().multiply(BigDecimal.ONE.subtract(stock.getLackRatio())));
                    stock.setPickExtraQty(stock.getPlannedQty().multiply(BigDecimal.ONE.add(stock.getExtraRatio())));
                    stock.setPickExtraBaseQty(stock.getPlannedQty().multiply(BigDecimal.ONE.add(stock.getExtraRatio())));
                }
                if (BillBaseStatusEnum.CLOSED == orderinfo.getBaseStatus()) {
                    orderinfo.setBaseStatus(info.getLastMFTStatus());
                }
            }
            iMnufactureOrder.update((IObjectPK)new ObjectUuidPK(orderinfo.getId().toString()), (CoreBaseInfo)orderinfo);
        }
    }

    protected void _audit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._audit(ctx, pk, model);
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._audit(ctx, pk);
    }

    public void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RestructReqBillInfo info = this.getRestructReqBillInfo(ctx, pk);
        String idStr = info.getId().toString();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select distinct FSrcObjectID from t_bot_Relation ").append("where FSrcObjectID in('").append(idStr).append("') ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            String msg = null;
            while (rs != null && rs.next()) {
                msg = "\u6539\u5236\u7533\u8bf7\u5355\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff01";
            }
            if (msg != null) {
                throw new EASBizException(new NumericExceptionSubItem("", msg));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        this.writeBackManufactureOrder(ctx, info, "UnAudit");
        info.setAuditor(null);
        info.setAuditTime(null);
        info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        RestructReqBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
        this._writeLogs(ctx, (IObjectValue)info, "unAudit", "\u53cd\u5ba1\u6838");
    }

    @Override
    protected IObjectCollection _diffCompare(Context ctx, RestructReqBillInfo restructreq) throws BOSException, EASBizException {
        String storageunitorgid = restructreq.getStorageOrgUnit().getId().toString();
        RestructType resType = restructreq.getRestructType();
        String orderid = null;
        if (restructreq.getManufactureorder() != null) {
            orderid = restructreq.getManufactureorder().getId().toString();
        }
        String bmaterialid = restructreq.getBmaterial().getId().toString();
        String bprojectid = null;
        if (restructreq.getBproject() != null) {
            bprojectid = restructreq.getBproject().getId().toString();
        }
        String btracknumberid = null;
        if (restructreq.getBtracknumber() != null) {
            btracknumberid = restructreq.getBtracknumber().getId().toString();
        }
        BigDecimal btructqty = restructreq.getBtructqty();
        String cmaterialid = restructreq.getCmaterial().getId().toString();
        String cprojectid = null;
        if (restructreq.getCproject() != null) {
            cprojectid = restructreq.getCproject().getId().toString();
        }
        String ctracknumberid = null;
        if (restructreq.getCtracknumber() != null) {
            ctracknumberid = restructreq.getCtracknumber().getId().toString();
        }
        BigDecimal ctructqty = restructreq.getCtructqty();
        boolean isExtend = restructreq.isIsextend();
        int extendLevel = 0;
        if (isExtend) {
            extendLevel = restructreq.getExtendLevel();
        }
        ArrayList<String> tempTableList = new ArrayList<String>();
        RestructReqBillEntryCollection colls = restructreq.getEntrys() == null ? new RestructReqBillEntryCollection() : restructreq.getEntrys();
        HashMap<String, RestructReqBillEntryInfo> map = new HashMap<String, RestructReqBillEntryInfo>();
        if (colls.size() > 0) {
            for (int n = 0; n < colls.size(); ++n) {
                if (colls.get(n).getMaterial() == null) continue;
                map.put(colls.get(n).getMaterial().getId().toString(), colls.get(n));
            }
        }
        colls.clear();
        try {
            String bTableName = null;
            bTableName = StringUtil.isEmptyString((String)orderid) ? this._bomMulLevelExpl(ctx, storageunitorgid, bprojectid, btracknumberid, bmaterialid) : this.insertOederAndYelian2TempTable(ctx, orderid);
            String cTableName = this._bomMulLevelExpl(ctx, storageunitorgid, cprojectid, ctracknumberid, cmaterialid);
            if (bTableName == null) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u6539\u5236\u524d\u4ea7\u54c1\u65e0\u6cd5\u5c55\u5f00!"));
            }
            tempTableList.add(bTableName);
            if (cTableName == null) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u6539\u5236\u540e\u4ea7\u54c1\u65e0\u6cd5\u5c55\u5f00!"));
            }
            tempTableList.add(cTableName);
            StringBuffer sql = new StringBuffer();
            IRowSet rs = null;
            if (isExtend) {
                if (extendLevel != 0) {
                    sql.append(" select fmaterialid,FSUPPLYORGID,fname,sum(fqty1) bqty, \r\n");
                    sql.append(" sum(fqty2) cqty,sum(bf) bf ,sum(af) af \r\n");
                    sql.append(" from( \r\n");
                    sql.append(" select fmaterialid,b.fname_l2 fname,FSUPPLYORGID,fqty fqty1,0 fqty2,1 bf,0 af from  \r\n");
                    sql.append(bTableName).append(" a \r\n");
                    sql.append(" left join t_bd_material b on a.fmaterialid = b.fid \r\n");
                    sql.append(" where flevel <= ? \r\n");
                    sql.append(" union \r\n");
                    sql.append(" select fmaterialid,b.fname_l2 fname,FSUPPLYORGID,0 fqty1,fqty fqty2 ,0 bf,1 af from \r\n");
                    sql.append(cTableName).append(" a \r\n");
                    sql.append(" left join t_bd_material b on a.fmaterialid = b.fid \r\n");
                    sql.append(" where flevel <= ? \r\n");
                    sql.append(" )\r\n");
                    sql.append(" group by fmaterialid,FSUPPLYORGID,fname \r\n");
                    rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{extendLevel, extendLevel});
                } else {
                    sql.append(" select fmaterialid,FSUPPLYORGID,fname,sum(fqty1) bqty,\r\n");
                    sql.append(" sum(fqty2) cqty ,sum(bf) bf ,sum(af) af\r\n");
                    sql.append(" from(\r\n");
                    sql.append(" select fmaterialid,b.fname_l2 fname,FSUPPLYORGID,fqty fqty1,0 fqty2,1 bf,0 af from\r\n");
                    sql.append(bTableName).append(" a\r\n");
                    sql.append(" left join t_bd_material b on a.fmaterialid = b.fid\r\n");
                    sql.append(" union\r\n");
                    sql.append(" select fmaterialid,b.fname_l2 fname,FSUPPLYORGID,0 fqty1,fqty fqty2 ,0 bf,1 af from\r\n");
                    sql.append(cTableName).append(" a\r\n");
                    sql.append(" left join t_bd_material b on a.fmaterialid = b.fid\r\n");
                    sql.append(" )\r\n");
                    sql.append(" group by fmaterialid,FSUPPLYORGID,fname\r\n");
                    rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
                }
            } else {
                sql.append(" select fmaterialid,FSUPPLYORGID,fname,sum(fqty1) bqty,\r\n");
                sql.append(" sum(fqty2) cqty ,sum(bf) bf ,sum(af) af \r\n");
                sql.append(" from(\r\n");
                sql.append(" select fmaterialid,b.fname_l2 fname,FSUPPLYORGID,fqty fqty1,0 fqty2 ,1 bf,0 af from\r\n");
                sql.append(bTableName).append(" a\r\n");
                sql.append(" left join t_bd_material b on a.fmaterialid = b.fid\r\n");
                sql.append(" where flevel = 1\r\n");
                sql.append(" union\r\n");
                sql.append(" select fmaterialid,b.fname_l2 fname,FSUPPLYORGID,0 fqty1,fqty fqty2 ,0 bf,1 af from\r\n");
                sql.append(cTableName).append(" a\r\n");
                sql.append(" left join t_bd_material b on a.fmaterialid = b.fid\r\n");
                sql.append(" where flevel = 1\r\n");
                sql.append(" )\r\n");
                sql.append(" group by fmaterialid,FSUPPLYORGID,fname\r\n");
                rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
            }
            RestructReqBillEntryInfo restructBProduct = null;
            if (map.get(restructreq.getBmaterial().getId().toString()) == null) {
                restructBProduct = new RestructReqBillEntryInfo();
                restructBProduct.setIsauto(true);
            } else {
                restructBProduct = (RestructReqBillEntryInfo)map.get(restructreq.getBmaterial().getId().toString());
                restructBProduct.setIsauto(true);
            }
            restructBProduct.setMaterial(restructreq.getBmaterial());
            restructBProduct.setMaterialcode(restructreq.getBmaterial().getNumber());
            restructBProduct.setMaterialmodel(restructreq.getBmaterial().getModel());
            restructBProduct.setMeasuerunit(restructreq.getBmaterial().getBaseUnit() == null ? "" : restructreq.getBmaterial().getBaseUnit().getName());
            restructBProduct.setBunitqty(BigDecimal.ZERO);
            restructBProduct.setBqty(BigDecimal.ZERO);
            restructBProduct.setCunitqty(BigDecimal.ZERO);
            restructBProduct.setCqty(BigDecimal.ZERO);
            restructBProduct.setRevokeqty(BigDecimal.ZERO);
            restructBProduct.setBissueqty(BigDecimal.ZERO);
            restructBProduct.setIssueqty(btructqty);
            restructBProduct.setRejecteqty(BigDecimal.ZERO);
            restructBProduct.setBaseUnit(restructreq.getBmaterial().getBaseUnit());
            restructBProduct.setUnit(restructreq.getBmaterial().getBaseUnit());
            restructBProduct.setIssuedqty(BigDecimal.ZERO);
            restructBProduct.setRevokedqty(BigDecimal.ZERO);
            restructBProduct.setRejectedqty(BigDecimal.ZERO);
            if (resType.compareTo((Object)RestructType.storageRestruct) == 0) {
                restructBProduct.setRejecteorgunit(this.getStorageOrgUnitByMaterialTab(ctx, restructreq.getBmaterial(), restructreq.getStorageOrgUnit()));
            } else {
                restructBProduct.setRejecteorgunit(this.getStorageOrgUnitByMftOrder(ctx, restructreq.getBmaterial().getId().toString(), orderid));
            }
            if (resType.compareTo((Object)RestructType.storageRestruct) == 0) {
                colls.add(restructBProduct);
            }
            while (rs.next()) {
                BigDecimal bqty = rs.getBigDecimal("bqty") == null ? BigDecimal.ZERO : rs.getBigDecimal("bqty");
                BigDecimal cqty = rs.getBigDecimal("cqty") == null ? BigDecimal.ZERO : rs.getBigDecimal("cqty");
                BigDecimal bqtyTotal = bqty.multiply(btructqty);
                BigDecimal cqtyTotal = cqty.multiply(ctructqty);
                String supplyorgid = rs.getString("FSUPPLYORGID");
                int af = rs.getInt("af");
                int bf = rs.getInt("bf");
                boolean beforeAfter = false;
                if (af > 0) {
                    beforeAfter = true;
                }
                RestructReqBillEntryInfo entry = null;
                MaterialInfo material = new MaterialInfo();
                if (rs.getString("fmaterialid") == null) continue;
                material.setId(BOSUuid.read((String)rs.getString("fmaterialid")));
                material.setName(rs.getString("fname"));
                SelectorItemCollection _items = new SelectorItemCollection();
                _items.add(new SelectorItemInfo("baseUnit.*"));
                _items.add(new SelectorItemInfo("model"));
                _items.add(new SelectorItemInfo("id"));
                _items.add(new SelectorItemInfo("name"));
                _items.add(new SelectorItemInfo("number"));
                material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId().toString()), _items);
                entry = map.get(material.getId().toString()) == null ? new RestructReqBillEntryInfo() : (RestructReqBillEntryInfo)map.get(material.getId().toString());
                entry.setMaterial(material);
                entry.setMaterialcode(material.getNumber());
                entry.setMaterialmodel(material.getModel());
                entry.setBaseUnit(material.getBaseUnit());
                entry.setUnit(material.getBaseUnit());
                entry.setMeasuerunit(material.getBaseUnit() == null ? "" : material.getBaseUnit().getName());
                entry.setBunitqty(bqty);
                entry.setBqty(bqtyTotal);
                entry.setCunitqty(cqty);
                entry.setCqty(cqtyTotal);
                entry.setRevokeqty(entry.getRevokeqty() == null ? BigDecimal.ZERO : entry.getRevokeqty());
                if (resType.compareTo((Object)RestructType.storageRestruct) == 0) {
                    entry.setBissueqty(bqtyTotal);
                    if (bqty.compareTo(BigDecimal.ZERO) > 0 && cqty.compareTo(BigDecimal.ZERO) > 0 && cqtyTotal.add(entry.getRevokeqty()).compareTo(bqtyTotal) > 0) {
                        entry.setIssueqty(cqtyTotal.subtract(bqtyTotal).add(entry.getRevokeqty()));
                    } else if (bqty.compareTo(BigDecimal.ZERO) > 0 && cqty.compareTo(BigDecimal.ZERO) > 0 && cqtyTotal.add(entry.getRevokeqty()).compareTo(bqtyTotal) <= 0) {
                        entry.setIssueqty(BigDecimal.ZERO);
                    } else if (bqty.compareTo(BigDecimal.ZERO) == 0 && cqty.compareTo(BigDecimal.ZERO) > 0) {
                        entry.setIssueqty(cqtyTotal);
                    } else if (bqty.compareTo(BigDecimal.ZERO) > 0 && cqty.compareTo(BigDecimal.ZERO) == 0) {
                        entry.setIssueqty(BigDecimal.ZERO);
                    } else {
                        entry.setIssueqty(btructqty);
                    }
                    if (bqty.compareTo(BigDecimal.ZERO) > 0 && cqty.compareTo(BigDecimal.ZERO) > 0 && bqtyTotal.compareTo(cqtyTotal) > 0) {
                        entry.setRejecteqty(bqtyTotal.subtract(cqtyTotal).subtract(entry.getRevokeqty()));
                    } else if (bqty.compareTo(BigDecimal.ZERO) > 0 && cqty.compareTo(BigDecimal.ZERO) > 0 && bqty.compareTo(cqty) <= 0) {
                        entry.setRejecteqty(BigDecimal.ZERO);
                    } else if (cqty.compareTo(BigDecimal.ZERO) > 0 && bqty.compareTo(BigDecimal.ZERO) == 0) {
                        entry.setRejecteqty(BigDecimal.ZERO);
                    } else if (cqty.compareTo(BigDecimal.ZERO) == 0 && bqty.compareTo(BigDecimal.ZERO) > 0) {
                        entry.setRejecteqty(bqtyTotal.subtract(entry.getRevokeqty() == null ? BigDecimal.ZERO : entry.getRevokeqty()));
                    }
                    if (beforeAfter) {
                        StorageOrgUnitInfo info = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(supplyorgid));
                        entry.setRejecteorgunit(info);
                    } else {
                        entry.setRejecteorgunit(this.getStorageOrgUnitByMaterialTab(ctx, entry.getMaterial(), restructreq.getStorageOrgUnit()));
                    }
                } else {
                    BigDecimal actIssueQty = this.getIssueQtyByManufactureOrder(ctx, orderid, material.getId().toString());
                    if (actIssueQty.compareTo(bqtyTotal) >= 0) {
                        entry.setBissueqty(bqtyTotal);
                    } else {
                        entry.setBissueqty(actIssueQty);
                    }
                    if (bqty.compareTo(BigDecimal.ZERO) > 0 && cqty.compareTo(BigDecimal.ZERO) <= 0) {
                        entry.setIssueqty(BigDecimal.ZERO);
                    } else if (cqty.compareTo(BigDecimal.ZERO) > 0) {
                        entry.setIssueqty(cqtyTotal);
                    }
                    ManufactureOrderInfo orderInfo = null;
                    if (!StringUtil.isEmptyString((String)orderid)) {
                        orderInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(orderid));
                    }
                    if (bqty.compareTo(BigDecimal.ZERO) > 0 && cqty.compareTo(BigDecimal.ZERO) > 0 && entry.getBissueqty().subtract(entry.getRevokeqty()).compareTo(entry.getBunitqty().multiply(orderInfo.getQty().subtract(restructreq.getBtructqty()))) >= 0) {
                        entry.setRejecteqty(entry.getBissueqty().subtract(entry.getRevokeqty()).subtract(entry.getBunitqty().multiply(orderInfo.getQty().subtract(restructreq.getBtructqty()))));
                    } else if (bqty.compareTo(BigDecimal.ZERO) > 0 && cqty.compareTo(BigDecimal.ZERO) > 0 && entry.getBissueqty().subtract(entry.getRevokeqty()).compareTo(entry.getBunitqty().multiply(orderInfo.getQty().subtract(restructreq.getBtructqty()))) < 0) {
                        entry.setRejecteqty(BigDecimal.ZERO);
                    } else if (cqty.compareTo(BigDecimal.ZERO) > 0 && bqty.compareTo(BigDecimal.ZERO) <= 0) {
                        entry.setRejecteqty(BigDecimal.ZERO);
                    } else if (cqty.compareTo(BigDecimal.ZERO) <= 0 && bqty.compareTo(BigDecimal.ZERO) > 0) {
                        entry.setRejecteqty(entry.getBissueqty().subtract(entry.getRevokeqty()));
                    }
                    if (beforeAfter) {
                        StorageOrgUnitInfo info = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(supplyorgid));
                        entry.setRejecteorgunit(info);
                    } else {
                        entry.setRejecteorgunit(this.getStorageOrgUnitByMftOrder(ctx, entry.getMaterial().getId().toString(), orderid));
                    }
                }
                entry.setIssuedqty(BigDecimal.ZERO);
                entry.setRevokedqty(BigDecimal.ZERO);
                entry.setRejectedqty(BigDecimal.ZERO);
                entry.setIsauto(true);
                colls.add(entry);
            }
        }
        catch (Exception ex) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u5dee\u5f02\u5bf9\u6bd4\uff1a" + ex.getMessage()));
        }
        finally {
            this.releaseTempTable(ctx, tempTableList);
        }
        return colls;
    }

    public StorageOrgUnitInfo getStorageOrgUnitByMaterialTab(Context ctx, MaterialInfo material, StorageOrgUnitInfo storage) throws BOSException, EASBizException {
        String materialid = material.getId().toString();
        String storageid = storage.getId().toString();
        MaterialPlanInfo materialPlanInfo = Material8FacadeFactory.getLocalInstance((Context)ctx).getPlanInfo(materialid, storageid);
        SelectorItemCollection items = new SelectorItemCollection();
        items.add(new SelectorItemInfo("supplyOrgUnit.*"));
        if (materialPlanInfo != null) {
            materialPlanInfo = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanInfo((IObjectPK)new ObjectUuidPK(materialPlanInfo.getId().toString()), items);
            return materialPlanInfo.getSupplyOrgUnit();
        }
        throw new EASBizException(new NumericExceptionSubItem("", "\u7269\u6599[" + material.getName() + "]\u5728\u5e93\u5b58\u7ec4\u7ec7[" + storage.getName() + "]\u4e2d\u6ca1\u6709\u7ef4\u62a4\u8ba1\u5212\u8d44\u6599!"));
    }

    public StorageOrgUnitInfo getStorageOrgUnitByMftOrder(Context ctx, String materialid, String orderid) throws BOSException {
        StorageOrgUnitInfo storageinfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sicOper = new SelectorItemCollection();
        sicOper.add("*");
        sicOper.add("storageOrgUnit.id");
        sicOper.add("storageOrgUnit.name");
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)orderid, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(sicOper);
        SCMBillEntryBaseCollection stocks = ManufactureOrderStockFactory.getLocalInstance((Context)ctx).getSCMBillEntryBaseCollection(view);
        if (stocks.size() > 0) {
            storageinfo = ((ManufactureOrderStockInfo)stocks.get(0)).getStorageOrgUnit();
        }
        return storageinfo;
    }

    protected String insertOederAndYelian2TempTable(Context ctx, String orderid) throws BOSException, EASBizException {
        if (StringUtil.isEmptyString((String)orderid)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        String stocksTempTable = this.createExpandZZBOMTempTable(ctx);
        sql.setLength(0);
        sql.append(this.getInsertExpandZZBOMTempTableSQL(stocksTempTable));
        sql.append(" select  MO.Fbomid as fbomid, \r\n");
        sql.append(" 1 as Flevel, \r\n");
        sql.append(" '.' as FLevelChar,\r\n");
        sql.append(" MO.Fstorageorgunitid as FStorageOrgUnitID,\r\n");
        sql.append(" MTO.Fstorageorgunitid as FsupplyOrgid,\r\n");
        sql.append(" MTO.Fmaterialid as FMaterialID,\r\n");
        sql.append(" MTO.FUnitQty as FQty,\r\n");
        sql.append(" mp.fmaterialattr as Fsource,\r\n");
        sql.append(" tr.fnumber as FTrackNumber,\r\n");
        sql.append(" MTO.Funitqty as FavgQty,\r\n");
        sql.append(" MO.Fprojectid as Fprojectid,\r\n");
        sql.append(" MTO.Fseq as Fseq,\r\n");
        sql.append(" MTO.Fprovidetype FProvideType\r\n");
        sql.append(" from T_MM_ManufactureOrder MO\r\n");
        sql.append(" left join T_MM_MFTOrderStock MTO\r\n");
        sql.append(" on MO.fid = MTO.Fparentid\r\n");
        sql.append(" left join t_bd_materialplan mp\r\n");
        sql.append(" on mp.fmaterialid = MTO.FMATERIALID \r\n");
        sql.append(" and mp.forgunit = MTO.Fstorageorgunitid \r\n");
        sql.append(" left join t_mm_tracknumber tr \r\n");
        sql.append(" on MO.Ftrackid = tr.fid\r\n");
        sql.append(" where MO.fid = ?\r\n");
        sql.append("union all\r\n");
        sql.append(" select  MO.Fbomid as fbomid, \r\n");
        sql.append(" 1 as Flevel, \r\n");
        sql.append(" '.' as FLevelChar,\r\n");
        sql.append(" MO.Fstorageorgunitid as FStorageOrgUnitID,\r\n");
        sql.append(" MTO.Fstorageorgunitid as FsupplyOrgid,\r\n");
        sql.append(" MTO.Fmaterialid as FMaterialID,\r\n");
        sql.append(" MTO.FUnitQty as FQty,\r\n");
        sql.append(" mp.fmaterialattr as Fsource,\r\n");
        sql.append(" tr.fnumber as FTrackNumber,\r\n");
        sql.append(" MTO.Funitqty as FavgQty,\r\n");
        sql.append(" MO.Fprojectid as Fprojectid,\r\n");
        sql.append(" MTO.Fseq as Fseq,\r\n");
        sql.append(" MTO.Fprovidetype FProvideType\r\n");
        sql.append(" from T_MM_ManufactureOrder MO\r\n");
        sql.append(" left join T_MM_MFTOrderStock MTO\r\n");
        sql.append(" on MO.fid = MTO.Fparentid\r\n");
        sql.append(" left join t_bd_materialplan mp\r\n");
        sql.append(" on mp.fmaterialid = MTO.FMATERIALID \r\n");
        sql.append(" and mp.forgunit = MTO.Fstorageorgunitid \r\n");
        sql.append(" left join t_mm_tracknumber tr \r\n");
        sql.append(" on MO.Ftrackid = tr.fid\r\n");
        sql.append(" INNER JOIN T_MM_ProductTransactionType TC\r\n");
        sql.append(" ON MO.FTransactionTypeID = TC.FID\r\n");
        sql.append(" where MO.Fsourcebillid = ?\r\n");
        sql.append(" and TC.Fname_L2 like '%\u4e1a\u8054%' \r\n");
        sql.append(" and MO.FBIRTHTYPE = 0 \r\n");
        long timeFrom = System.currentTimeMillis();
        int effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orderid, orderid});
        long timeTo = System.currentTimeMillis();
        long duration = (timeTo - timeFrom) / 1000L;
        System.out.println("Execute SQL Effected Rows " + effectedRows + " Duration " + duration + " Sec:\r\n" + sql.toString());
        return stocksTempTable;
    }

    @Override
    protected String _bomMulLevelExpl(Context ctx, String storageorgunitid, String projectid, String tracknumberid, String materialid) throws BOSException, EASBizException {
        String useLDBOM = this.getParamValue(ctx, "PMRP_USELDBOM", storageorgunitid);
        Boolean is_PMRP_USELDBOM = useLDBOM == null ? false : "true".equals(useLDBOM);
        StringBuffer _sql = new StringBuffer();
        IRowSet rs = null;
        if (projectid != null && !projectid.equals("") && tracknumberid != null && !tracknumberid.equals("")) {
            if (is_PMRP_USELDBOM.booleanValue()) {
                _sql.append("select a.fid from t_mm_bom a where a.fstorageorgunitid =? and a.fprojectid = ? and a.fmaterialid = ? and fbomtype = 90");
                rs = SQLUtils.executeQuery((Context)ctx, (String)_sql.toString(), (Object[])new Object[]{storageorgunitid, projectid, materialid});
            } else {
                _sql.append("select a.fid from t_mm_bom a where a.fstorageorgunitid =? and a.fprojectid = ? and a.fmaterialid = ? and fbomtype = 80");
                rs = SQLUtils.executeQuery((Context)ctx, (String)_sql.toString(), (Object[])new Object[]{storageorgunitid, projectid, materialid});
            }
        } else if (projectid != null && tracknumberid == null) {
            _sql.append("select a.fid from t_mm_bom a where a.fstorageorgunitid =? and a.fprojectid = ? and a.fmaterialid = ? and fbomtype in (40,50,80,45)");
            rs = SQLUtils.executeQuery((Context)ctx, (String)_sql.toString(), (Object[])new Object[]{storageorgunitid, projectid, materialid});
        } else if (tracknumberid != null && projectid == null) {
            _sql.append("select a.fid from t_mm_bom a where a.fstorageorgunitid =? and a.fmaterialid = ? and fbomtype = 45");
            rs = SQLUtils.executeQuery((Context)ctx, (String)_sql.toString(), (Object[])new Object[]{storageorgunitid, materialid});
        } else if (tracknumberid == null && projectid == null) {
            _sql.append("select a.fid from t_mm_bom a where a.fstorageorgunitid =? and a.fmaterialid = ? and fbomtype = 40");
            rs = SQLUtils.executeQuery((Context)ctx, (String)_sql.toString(), (Object[])new Object[]{storageorgunitid, materialid});
        }
        String bomID = null;
        try {
            if (!rs.next()) {
                return null;
            }
            bomID = rs.getString("fid");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        TrackNumberInfo trackNumberInfo = null;
        if (tracknumberid != null && !tracknumberid.equals("")) {
            trackNumberInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(tracknumberid));
        }
        StringBuffer sql = new StringBuffer();
        String levelChar = ".";
        String expandZZBOMTempTable = this.createExpandZZBOMTempTable(ctx);
        try {
            int effectedRows = 0;
            int level = 1;
            sql.setLength(0);
            sql.append(this.getInsertExpandZZBOMTempTableSQL(expandZZBOMTempTable));
            sql.append(" SELECT h.fid as fbomid, \r\n");
            sql.append(" ").append(level).append(" as FLevel, \r\n");
            sql.append(" '").append(levelChar).append("' as FLevelChar, \r\n");
            sql.append(" h.fstorageorgunitid as FStorageOrgUnitID, \r\n");
            sql.append(" d.fsupplystorageorgunitid as FsupplyOrgid, \r\n");
            sql.append(" d.fmaterialid as FMaterialID, \r\n");
            sql.append(" d.fconsumefixqty as FQty, \r\n");
            sql.append(" d.FMATERIALPROP As Fsource , \r\n");
            if (trackNumberInfo != null && trackNumberInfo.getNumber() != null) {
                sql.append(" '").append(trackNumberInfo.getNumber()).append("' As FTrackNumber, \r\n");
            } else {
                sql.append(" '").append("").append("' As FTrackNumber, \r\n");
            }
            sql.append(" d.fconsumefixqty As FavgQty, \r\n");
            if (projectid != null) {
                sql.append(" '").append(projectid).append("' As Fprojectid, \r\n");
            } else {
                sql.append(" '").append("").append("' As Fprojectid, \r\n");
            }
            sql.append(" d.Fseq,  \r\n");
            sql.append(" d.FProvideType As FProvideType  \r\n");
            sql.append(" FROM  t_mm_bom h \r\n");
            sql.append(" left outer Join t_mm_bomentry d on h.fid = d.fparentid \r\n");
            sql.append(" left outer join t_mm_tracknumber bt on d.fbegincarnoid = bt.fid \r\n");
            sql.append(" left outer join t_mm_tracknumber et on d.fendcarnoid = et.fid \r\n");
            sql.append(" WHERE h.fid = '").append(bomID).append("' \r\n");
            if (trackNumberInfo != null && trackNumberInfo.getNumber() != null) {
                sql.append(" and bt.fnumber <= '").append(trackNumberInfo.getNumber()).append("' and et.fnumber >= '").append(trackNumberInfo.getNumber()).append("' \r\n");
            }
            if ((effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString())) > 0) {
                while (level < 50) {
                    sql.setLength(0);
                    ++level;
                    levelChar = levelChar + ".";
                    sql.append(this.getInsertExpandZZBOMTempTableSQL(expandZZBOMTempTable));
                    sql.append(" SELECT h.fid as fbomid, \r\n");
                    sql.append(" ").append(level).append(" as FLevel, \r\n");
                    sql.append(" '").append(levelChar).append("' as FLevelChar, \r\n");
                    sql.append(" h.fstorageorgunitid as FStorageOrgUnitID, \r\n");
                    sql.append(" d.fsupplystorageorgunitid as FsupplyOrgid, \r\n");
                    sql.append(" d.fmaterialid as FMaterialID, \r\n");
                    sql.append(" d.fconsumefixqty * tp.Fqty as FQty, \r\n");
                    sql.append(" d.FMATERIALPROP As Fsource , \r\n");
                    if (trackNumberInfo != null && trackNumberInfo.getNumber() != null) {
                        sql.append(" '").append(trackNumberInfo.getNumber()).append("' As FTrackNumber, \r\n");
                    } else {
                        sql.append(" '").append("").append("' As FTrackNumber, \r\n");
                    }
                    sql.append(" d.fconsumefixqty As FavgQty, \r\n");
                    if (projectid != null) {
                        sql.append(" '").append(projectid).append("' As Fprojectid, \r\n");
                    } else {
                        sql.append(" '").append("").append("' As Fprojectid, \r\n");
                    }
                    sql.append(" d.Fseq,  \r\n");
                    sql.append(" d.FProvideType As FProvideType  \r\n");
                    sql.append(" FROM  ").append(expandZZBOMTempTable).append(" tp  \r\n");
                    sql.append(" Inner Join t_mm_bom h  \r\n");
                    if (is_PMRP_USELDBOM.booleanValue()) {
                        sql.append(" on tp.Fmaterialid = h.fmaterialid And tp.FsupplyOrgid = h.fstorageorgunitid and h.fbomtype = 90 and h.fbasestatus = 4  \r\n");
                    } else {
                        sql.append(" on tp.Fmaterialid = h.fmaterialid And tp.FsupplyOrgid = h.fstorageorgunitid and h.fbomtype = 50 and h.fbasestatus = 4  \r\n");
                    }
                    sql.append(" Inner Join t_mm_bomentry d on h.fid = d.fparentid \r\n");
                    sql.append(" Inner join t_mm_tracknumber bt on d.fbegincarnoid = bt.fid \r\n");
                    sql.append(" Inner join t_mm_tracknumber et on d.fendcarnoid = et.fid \r\n");
                    sql.append(" WHERE tp.FLevel = '").append(level - 1).append("' \r\n");
                    if (projectid != null) {
                        sql.append(" And h.fprojectid = '").append(projectid).append("' \r\n");
                    }
                    if (trackNumberInfo != null && trackNumberInfo.getNumber() != null) {
                        sql.append(" and bt.fnumber <= '").append(trackNumberInfo.getNumber()).append("' and et.fnumber >= '").append(trackNumberInfo.getNumber()).append("' \r\n");
                    }
                    SQLUtils.execute((Context)ctx, (String)sql.toString());
                }
            }
            return expandZZBOMTempTable;
        }
        catch (Exception ex) {
            return expandZZBOMTempTable;
        }
    }

    protected void releaseTempTable(Context ctx, List tempTableList) {
        if (ctx == null || tempTableList == null) {
            return;
        }
        if (tempTableList.size() == 0) {
            return;
        }
        for (int index = 0; index < tempTableList.size(); ++index) {
            String tempTable;
            String string = tempTable = tempTableList.get(index) == null ? null : tempTableList.get(index).toString();
            if (tempTable == null) {
                return;
            }
            if (tempTable.trim().length() == 0) {
                return;
            }
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
    }

    protected String createExpandZZBOMTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ExpandZZBOMTempTable(\r\n");
        sql.append("fbomid  VARCHAR(44), \r\n");
        sql.append("FLevel Int,\r\n");
        sql.append("FLevelChar  NVARCHAR(100), \r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44),\r\n");
        sql.append("FsupplyOrgid VARCHAR(44),\r\n");
        sql.append("FMaterialID VARCHAR(44),\r\n");
        sql.append("FQty Numeric(28,14),\r\n");
        sql.append("Fsource NVARCHAR(30),\r\n");
        sql.append("FTrackNumber NVARCHAR(80),\r\n");
        sql.append("FavgQty Numeric(28,14),\r\n");
        sql.append("Fprojectid VARCHAR(44),\r\n");
        sql.append("FSeq Int, \r\n");
        sql.append("FProvideType Int, \r\n");
        sql.append("FEndTrackNumberID VARCHAR(44) \r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMaterialID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FLevel", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String getInsertExpandZZBOMTempTableSQL(String expandZZBOMTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(expandZZBOMTempTableName).append("(\r\n");
        sql.append("fbomid ,\r\n");
        sql.append("FLevel ,\r\n");
        sql.append("FLevelChar ,\r\n");
        sql.append("FStorageOrgUnitID ,\r\n");
        sql.append("FsupplyOrgid ,\r\n");
        sql.append("FMaterialID ,\r\n");
        sql.append("FQty ,\r\n");
        sql.append("Fsource ,\r\n");
        sql.append("FTrackNumber ,\r\n");
        sql.append("FavgQty, \r\n");
        sql.append("Fprojectid,\r\n");
        sql.append("FSeq,\r\n");
        sql.append("FProvideType\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    private BigDecimal getIssueQtyByManufactureOrder(Context ctx, String orderid, String materialid) throws BOSException, EASBizException {
        BigDecimal issueqty = BigDecimal.ZERO;
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo filterinfo = new FilterInfo();
        FilterItemInfo item1 = new FilterItemInfo("parent", (Object)orderid, CompareType.EQUALS);
        FilterItemInfo item2 = new FilterItemInfo("material", (Object)materialid, CompareType.EQUALS);
        filterinfo.getFilterItems().add(item1);
        filterinfo.getFilterItems().add(item2);
        viewinfo.setFilter(filterinfo);
        SCMBillEntryBaseCollection colls = ManufactureOrderStockFactory.getLocalInstance((Context)ctx).getSCMBillEntryBaseCollection(viewinfo);
        for (int n = 0; n < colls.size(); ++n) {
            ManufactureOrderStockInfo stockinfo = (ManufactureOrderStockInfo)colls.get(n);
            issueqty = issueqty.add(stockinfo.getActIssueQty());
        }
        return issueqty;
    }

    protected String getParamValue(Context ctx, String paramName, String storageOrgUnitID) throws BOSException, EASBizException {
        if (storageOrgUnitID == null) {
            return null;
        }
        String value = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("value"));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)storageOrgUnitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)paramName, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        ParamItemCollection paramItemCollection = ParamItemFactory.getLocalInstance((Context)ctx).getParamItemCollection(entityViewInfo);
        if (paramItemCollection != null && paramItemCollection.size() > 0 && paramItemCollection.get(0) != null) {
            value = paramItemCollection.get(0).getValue() == null ? "" : paramItemCollection.get(0).getValue();
        }
        return value;
    }

    @Override
    protected void _writeLogs(Context ctx, IObjectValue model, String methodName, String methodAlias) throws BOSException, EASBizException {
        String cuID;
        String userNumber;
        String userID;
        RestructReqBillInfo info = (RestructReqBillInfo)model;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String string = userInfo == null ? null : (userID = userInfo.getId() == null ? null : userInfo.getId().toString());
        String string2 = userInfo == null ? null : (userNumber = userInfo.getNumber() == null ? null : userInfo.getNumber());
        String userName = userInfo == null ? null : (userInfo.getName() == null ? null : userInfo.getName());
        String clientIP = ContextUtil.getClientIP((Context)ctx);
        String clientName = ContextUtil.getClientName((Context)ctx);
        CompanyOrgUnitInfo companyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyName = companyInfo == null ? null : (companyInfo.getName() == null ? null : companyInfo.getName());
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String string3 = cuInfo == null ? null : (cuID = cuInfo.getId() == null ? null : cuInfo.getId().toString());
        if (userID == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into T_Log_App(\r\n");
        sql.append("FID,\r\n");
        sql.append("FUserID,\r\n");
        sql.append("FUserName,\r\n");
        sql.append("FOCCURTime,\r\n");
        sql.append("FClientIP,\r\n");
        sql.append("FClientName,\r\n");
        sql.append("FEntityID,\r\n");
        sql.append("FCompanyName_L2,\r\n");
        sql.append("FEntityName,\r\n");
        sql.append("FEntityAlias_L2,\r\n");
        sql.append("FMethodName,\r\n");
        sql.append("FMethodAlias_L2,\r\n");
        sql.append("FInstanceID,\r\n");
        sql.append("FInstanceNO,\r\n");
        sql.append("FItemName,\r\n");
        sql.append("FUserNumber,\r\n");
        sql.append("FCUID,\r\n");
        sql.append("FIsSuccessed,\r\n");
        sql.append("FInstanceDetail,\r\n");
        sql.append("FUserType_L2,\r\n");
        sql.append("FMethodDescription_L2\r\n");
        sql.append(")\r\n");
        sql.append("Select\r\n");
        sql.append("NewBOSID('").append(new AppLog().getType().toString()).append("'),\r\n");
        if (userID != null) {
            sql.append("'").append(userID).append("',\r\n");
        } else {
            sql.append("Null,\r\n");
        }
        if (userName != null) {
            sql.append("'").append(userName).append("',\r\n");
        } else {
            sql.append("Null,\r\n");
        }
        sql.append("Now(),\r\n");
        if (clientIP != null) {
            sql.append("N'").append(clientIP).append("',\r\n");
        } else {
            sql.append("Null,\r\n");
        }
        if (clientName != null) {
            sql.append("N'").append(clientName).append("',\r\n");
        } else {
            sql.append("Null,\r\n");
        }
        sql.append("'").append(info.getBOSType().toString()).append("',\r\n");
        if (companyName != null) {
            sql.append("N'").append(companyName).append("',\r\n");
        } else {
            sql.append("Null,\r\n");
        }
        sql.append("N'RestructReqBill',\r\n");
        sql.append("N'\u6539\u5236\u7533\u8bf7\u5355',\r\n");
        sql.append("N'").append(methodName).append("',\r\n");
        sql.append("N'").append(methodAlias).append("',\r\n");
        sql.append("Null,\r\n");
        sql.append("N'").append(info.getNumber()).append("',\r\n");
        sql.append("Null,\r\n");
        if (userNumber != null) {
            sql.append("'").append(userNumber).append("',\r\n");
        } else {
            sql.append("Null,\r\n");
        }
        if (cuID != null) {
            sql.append("'").append(cuID).append("',\r\n");
        } else {
            sql.append("Null,\r\n");
        }
        sql.append("1,\r\n");
        sql.append("Null,\r\n");
        sql.append("Case U.FType\r\n");
        sql.append("When 10 Then N'\u7cfb\u7edf\u7528\u6237'\r\n");
        sql.append("When 20 Then N'\u804c\u5458'\r\n");
        sql.append("When 30 Then N'\u5ba2\u6237'\r\n");
        sql.append("When 40 Then N'\u4f9b\u5e94\u5546'\r\n");
        sql.append("When 50 Then N'\u5176\u4ed6'\r\n");
        sql.append("When 60 Then N'\u8ba4\u8bc1\u7ba1\u7406\u5458'\r\n");
        sql.append("When 70 Then N'\u5ba1\u8ba1\u7ba1\u7406\u5458'\r\n");
        sql.append("End,\r\n");
        sql.append("N'").append(methodAlias).append("'\r\n");
        sql.append("From T_PM_User U\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And U.FID='").append(userID).append("'\r\n");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }
}

