/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.fcs.algorithm.method;

import com.kingdee.eas.industry.emm.project.fcs.algorithm.method.MovingAverageAlgorithm;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;

public class WeightedMovingAverageAlgorithm
extends MovingAverageAlgorithm {
    private double[] factors;

    public WeightedMovingAverageAlgorithm(double[] source, int forcastPeriod, int step, double[] factors) {
        super(source, forcastPeriod, step);
        this.factors = factors;
        if (factors == null) {
            throw new IllegalArgumentException("factors data can not be null");
        }
        if (factors.length != step) {
            throw new IllegalArgumentException("factors length should equal step");
        }
    }

    public double[] getFactors() {
        return this.factors;
    }

    public void setFactors(double[] factors) {
        this.factors = factors;
    }

    @Override
    public BigDecimal[] calc() {
        int i;
        ArrayList<BigDecimal> buffer = new ArrayList<BigDecimal>();
        for (int i2 = 0; i2 < this.source.length; ++i2) {
            buffer.add(this.source[i2]);
        }
        int index = this.step;
        BigDecimal stepDB = new BigDecimal(this.step);
        MathContext mc = new MathContext(this.scale, this.roundingMode);
        while (true) {
            BigDecimal sum = BigDecimal.ZERO;
            i = index - this.step;
            int j = 0;
            while (i < index) {
                sum = sum.add(new BigDecimal(this.factors[j]).multiply((BigDecimal)buffer.get(i)));
                ++i;
                ++j;
            }
            buffer.add(sum.divide(stepDB, mc));
            if (buffer.size() == this.forcastPeriod + this.source.length) break;
            ++index;
        }
        BigDecimal[] ret = new BigDecimal[this.forcastPeriod];
        for (i = this.source.length; i < buffer.size(); ++i) {
            ret[i - this.source.length] = ((BigDecimal)buffer.get(i)).setScale(this.scale, this.roundingMode);
        }
        return ret;
    }
}

