/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.fcs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.common.utils.DateUtil;
import com.kingdee.eas.industry.emm.project.fcs.ChartBaseTypeEnum;
import com.kingdee.eas.industry.emm.project.fcs.SaleDataSourceEnum;
import com.kingdee.eas.industry.emm.project.fcs.SaleForeCastBaseEntryInfo;
import com.kingdee.eas.industry.emm.project.fcs.SaleForeCastEntryCollection;
import com.kingdee.eas.industry.emm.project.fcs.SaleForeCastEntryInfo;
import com.kingdee.eas.industry.emm.project.fcs.SaleForeCastInfo;
import com.kingdee.eas.industry.emm.project.fcs.SaleForeCastWeightEntryCollection;
import com.kingdee.eas.industry.emm.project.fcs.YCModelEnum;
import com.kingdee.eas.industry.emm.project.fcs.algorithm.Calculator;
import com.kingdee.eas.industry.emm.project.fcs.app.AbstractSaleForeCastControllerBean;
import com.kingdee.eas.industry.emm.project.fcs.periodUnitEnum;
import com.kingdee.eas.mm.planning.ISopBill;
import com.kingdee.eas.mm.planning.ISopDayPlan;
import com.kingdee.eas.mm.planning.ISopPlan;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPPlanVersionInfo;
import com.kingdee.eas.mm.planning.SopBillFactory;
import com.kingdee.eas.mm.planning.SopBillInfo;
import com.kingdee.eas.mm.planning.SopDayPlanFactory;
import com.kingdee.eas.mm.planning.SopDayPlanInfo;
import com.kingdee.eas.mm.planning.SopPlanFactory;
import com.kingdee.eas.mm.planning.SopPlanInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SaleForeCastControllerBean
extends AbstractSaleForeCastControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.project.fcs.app.SaleForeCastControllerBean");
    protected DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    protected SaleForeCastInfo _YC(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeMap<java.util.Date, BigDecimal> sums;
        if (model == null) {
            return null;
        }
        SaleForeCastInfo info = (SaleForeCastInfo)model;
        if (info.getMaterial() != null && info.getMaterial().getBaseUnit() != null && info.getMaterial().getBaseUnit().getName() == null) {
            MeasureUnitInfo unitinfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getBaseUnit().getId()));
            info.getMaterial().setBaseUnit(unitinfo);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        try {
            sums = this.setBaseEntrys(ctx, info);
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u83b7\u53d6\u9500\u552e\u6570\u636e\u5931\u8d25\uff01"), (Throwable)e);
        }
        BigDecimal[] datas = sums.values().toArray(new BigDecimal[0]);
        double[] source = new double[datas.length];
        for (int i = 0; i < datas.length; ++i) {
            source[i] = datas[i].doubleValue();
        }
        YCModelEnum ycModel = info.getYCModel();
        BigDecimal[] forcastDatas = null;
        if (YCModelEnum.AVE.equals((Object)ycModel)) {
            forcastDatas = Calculator.runMovingAvgAlgorithm(source, source.length, info.getPeriodCount());
        } else if (YCModelEnum.AddAVE.equals((Object)ycModel)) {
            SaleForeCastWeightEntryCollection entrys = info.getWeightEntry();
            double[] factors = new double[entrys.size()];
            for (int i = 0; i < entrys.size(); ++i) {
                factors[i] = entrys.get(i).getWeight().doubleValue();
            }
            forcastDatas = Calculator.runWeightedMovingAvgAlgorithm(source, source.length, info.getAddPeriodCount(), factors);
        } else if (YCModelEnum.TrendAVE.equals((Object)ycModel)) {
            forcastDatas = Calculator.runTrendMovingAvgAlgorithm(source, source.length, info.getPeriodCount());
        } else if (YCModelEnum.OneExpo.equals((Object)ycModel)) {
            forcastDatas = Calculator.runExponentialSmoothingAlgotithm(source, 3, info.getSerial().doubleValue());
        } else if (YCModelEnum.TwoExpo.equals((Object)ycModel)) {
            forcastDatas = Calculator.runQuadraticExponentialSmoothingAlgotithm(source, source.length, info.getSerial().doubleValue());
        } else if (YCModelEnum.ThreeExpo.equals((Object)ycModel)) {
            forcastDatas = Calculator.runCubicExponentialSmoothingAlgotithm(source, source.length, info.getSerial().doubleValue());
        }
        ChartBaseTypeEnum baseType = info.getChartBasetype();
        int idx = 0;
        Calendar cal = Calendar.getInstance();
        info.getBaseEntry().clear();
        info.getEntrys().clear();
        for (java.util.Date date : sums.keySet()) {
            SaleForeCastBaseEntryInfo entry = new SaleForeCastBaseEntryInfo();
            entry.setMaterial(info.getMaterial());
            entry.setUnit(info.getMaterial().getBaseUnit());
            entry.setPeriod(format.format(date));
            entry.setQty(sums.get(date));
            info.getBaseEntry().add(entry);
            SaleForeCastEntryInfo entry2 = new SaleForeCastEntryInfo();
            cal.setTime(date);
            cal.add(1, 1);
            entry2.setMaterial(info.getMaterial());
            entry2.setUnit(info.getMaterial().getBaseUnit());
            entry2.setPeriod(format.format(cal.getTime()));
            entry2.setQty(forcastDatas[idx++]);
            periodUnitEnum pu = info.getPeriodUnit();
            entry2.setBeginDate(cal.getTime());
            java.util.Date end = null;
            cal.setTime(cal.getTime());
            if (periodUnitEnum.YEAR.equals((Object)pu)) {
                cal.set(2, 11);
                cal.set(5, 31);
                end = cal.getTime();
            } else if (periodUnitEnum.MONTH.equals((Object)pu)) {
                cal.add(2, 1);
                cal.add(5, -1);
                end = cal.getTime();
            } else if (periodUnitEnum.WEEKEND.equals((Object)pu)) {
                cal.set(7, 1);
                end = cal.getTime();
            }
            entry2.setEndDate(end);
            info.getEntrys().add(entry2);
        }
        if (ChartBaseTypeEnum.LastYear.equals((Object)baseType) || ChartBaseTypeEnum.SetPeriod.equals((Object)baseType)) {
            // empty if block
        }
        info.put("BASE_VALUES", "");
        return info;
    }

    protected TreeMap<java.util.Date, BigDecimal> setBaseEntrys(Context ctx, SaleForeCastInfo info) throws BOSException, EASBizException, SQLException {
        Object[] objectArray;
        java.util.Date beginDate = info.getSaleDataBeginDate();
        java.util.Date endDate = info.getSaleDataEndDate();
        MaterialInfo materialInfo = info.getMaterial();
        periodUnitEnum pu = info.getPeriodUnit();
        SaleDataSourceEnum dataSource = info.getSaleDataSource();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder();
        if (SaleDataSourceEnum.SaleIssue.equals((Object)dataSource)) {
            sql.append("SELECT FQTY AS QTY,B.FACTBIZDATE AS ORDERDATE FROM T_IM_SaleIssueEntry E\r\n");
            sql.append("INNER JOIN T_IM_SaleIssueBill B ON E.FPARENTID = B.FID\r\n");
            sql.append("WHERE E.FMATERIALID = ? AND E.FSTORAGEORGUNITID = ? AND B.FACTBIZDATE >= to_date('");
            sql.append(format.format(beginDate)).append(" 00:00:00");
            sql.append("') AND B.FACTBIZDATE <= to_date('");
            sql.append(format.format(endDate)).append(" 23:59:59");
            sql.append("')\r\n");
            sql.append("ORDER BY B.FACTBIZDATE DESC");
        } else if (SaleDataSourceEnum.SaleOrder.equals((Object)dataSource)) {
            sql.append("SELECT E.FQTY AS QTY ,B.FBizDate AS ORDERDATE FROM T_SD_SaleOrderEntry E\r\n");
            sql.append("INNER JOIN T_SD_SaleOrder B ON E.FPARENTID = B.FID\r\n");
            sql.append("WHERE E.FMATERIALID = ? ");
            if (info.getSaleOrgUnit() != null) {
                sql.append("AND B.FSaleOrgUnitID = ? ");
            }
            sql.append("AND B.FBizDate >= to_date('");
            sql.append(format.format(beginDate)).append(" 00:00:00");
            sql.append("') AND B.FBizDate <= to_date('");
            sql.append(format.format(endDate)).append(" 23:59:59");
            sql.append("')\r\n");
            sql.append("ORDER BY B.FBizDate DESC");
        }
        String string = sql.toString();
        if (info.getSaleOrgUnit() == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = materialInfo.getId().toString();
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = materialInfo.getId().toString();
            objectArray = objectArray3;
            objectArray3[1] = info.getSaleOrgUnit().getId();
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)string, (Object[])objectArray);
        List<java.util.Date[]> xAxis = this.getXAxis(pu, beginDate, endDate);
        TreeMap<java.util.Date, BigDecimal> sums = new TreeMap<java.util.Date, BigDecimal>();
        while (rs.next()) {
            BigDecimal qty = rs.getBigDecimal("QTY");
            Date date = rs.getDate("ORDERDATE");
            java.util.Date[] pair = xAxis.get(xAxis.size() - 1);
            while (date.compareTo(pair[0]) < 0 || date.compareTo(pair[1]) > 0) {
                xAxis.remove(xAxis.size() - 1);
                pair = xAxis.get(xAxis.size() - 1);
            }
            BigDecimal sum = sums.get(pair[0]);
            if (sum == null) {
                sum = BigDecimal.ZERO;
            }
            sum = sum.add(qty);
            sums.put(pair[0], sum);
        }
        return sums;
    }

    private List<java.util.Date[]> getXAxis(periodUnitEnum pu, java.util.Date beginDate, java.util.Date endDate) {
        ArrayList<java.util.Date[]> ret;
        block4: {
            Calendar cal;
            block5: {
                block3: {
                    ret = new ArrayList<java.util.Date[]>();
                    cal = Calendar.getInstance();
                    if (!periodUnitEnum.YEAR.equals((Object)pu)) break block3;
                    while (beginDate.compareTo(endDate) < 0) {
                        cal.setTime(beginDate);
                        cal.set(2, 0);
                        cal.set(5, 1);
                        this.adjust2Start(cal);
                        java.util.Date d0 = cal.getTime();
                        cal.set(2, 11);
                        cal.set(5, 31);
                        this.adjust2End(cal);
                        java.util.Date d1 = cal.getTime();
                        ret.add(new java.util.Date[]{d0, d1});
                        cal.setTime(d0);
                        cal.add(1, 1);
                        beginDate = cal.getTime();
                    }
                    break block4;
                }
                if (!periodUnitEnum.MONTH.equals((Object)pu)) break block5;
                while (beginDate.compareTo(endDate) < 0) {
                    cal.setTime(beginDate);
                    cal.set(5, 1);
                    this.adjust2Start(cal);
                    java.util.Date d0 = cal.getTime();
                    cal.add(2, 1);
                    cal.add(5, -1);
                    this.adjust2End(cal);
                    java.util.Date d1 = cal.getTime();
                    ret.add(new java.util.Date[]{d0, d1});
                    cal.add(5, 1);
                    beginDate = cal.getTime();
                }
                break block4;
            }
            if (!periodUnitEnum.WEEKEND.equals((Object)pu)) break block4;
            while (beginDate.compareTo(endDate) < 0) {
                cal.setTime(beginDate);
                cal.set(7, 2);
                this.adjust2Start(cal);
                java.util.Date d0 = cal.getTime();
                cal.set(7, 1);
                this.adjust2End(cal);
                java.util.Date d1 = cal.getTime();
                ret.add(new java.util.Date[]{d0, d1});
                cal.add(5, 1);
                beginDate = cal.getTime();
            }
        }
        return ret;
    }

    private void adjust2Start(Calendar cal) {
        cal.set(9, 0);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
    }

    private void adjust2End(Calendar cal) {
        cal.set(9, 1);
        cal.set(10, 11);
        cal.set(12, 59);
        cal.set(13, 59);
    }

    protected List getWorkDayList(Context ctx, java.util.Date beginDate, java.util.Date endDate, String orgUnitID) throws BOSException, EASBizException {
        ArrayList<java.util.Date> workDayList = new ArrayList<java.util.Date>();
        String beginDateStr = this.sdf.format(beginDate);
        String endDateStr = this.sdf.format(endDate);
        StringBuffer sql = new StringBuffer();
        sql.append(" Select d.fworkDate ");
        sql.append(" from t_mm_factorycalendar h ");
        sql.append(" inner join t_mm_factorycalendarentry d on h.fid = d.fparentid ");
        sql.append(" where h.fstorageorgunitid = '" + orgUnitID + "' ");
        sql.append(" and h.fisdefault = 1 ");
        sql.append(" And d.fworkdate >= to_date('" + beginDateStr + "')");
        sql.append(" and d.fworkdate <= to_date('" + endDateStr + "')");
        sql.append(" and d.fdatetype = 1 ");
        sql.append(" order by d.fworkdate ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                workDayList.add(rs.getDate("fworkDate"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (workDayList == null || workDayList.size() < 1) {
            long size = DateUtil.dateDiff(beginDate, endDate) / 86400000L + 1L;
            int i = 0;
            while ((long)i < size) {
                if (i == 0) {
                    workDayList.add(beginDate);
                } else {
                    beginDate = DateUtil.addDay(beginDate, 1);
                    workDayList.add(beginDate);
                }
                ++i;
            }
        }
        return workDayList;
    }

    @Override
    protected void _sop(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialInfo m;
        java.util.Date ycEndDate;
        if (model == null) {
            return;
        }
        SaleForeCastInfo info = (SaleForeCastInfo)model;
        if (info.getPeriodUnit().equals((Object)periodUnitEnum.YEAR)) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("\u8f6c\u6362 \u9519\u8bef", "\u7cfb\u7edf\u6682\u65f6\u4e0d\u652f\u6301\u5bf9\u5468\u671f\u4e3a\u5e74\u7684\u9884\u6d4b\u8fdb\u884c\u8f6c\u6362\u5230\u9500\u552e\u8ba1\u5212\uff01");
            throw new InterfaceDataBaseException(interfaceException);
        }
        java.util.Date ycBeginDate = info.getYCBeginDate();
        if (this.checkExistData(ctx, ycBeginDate, ycEndDate = info.getYCEndDate(), (m = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()))).getId().toString(), info.getStorageOrgUnit().getId().toString())) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("\u8f6c\u6362 \u9519\u8bef", "\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728\u6b64\u9884\u6d4b\u671f\u95f4\u7684SOP\u6570\u636e\uff0c\u8bf7\u5148\u67e5\u8bc1\uff01");
            throw new InterfaceDataBaseException(interfaceException);
        }
        IObjectPK pk = null;
        pk = info.getId() == null ? this._addnew(ctx, model) : this._save(ctx, model);
        SaleForeCastEntryCollection entrys = info.getEntrys();
        BigDecimal totalQty = BigDecimal.ZERO;
        for (int i = 0; i < entrys.size(); ++i) {
            SaleForeCastEntryInfo entryInfo = entrys.get(i);
            totalQty = totalQty.add(entryInfo.getQty());
        }
        SopBillInfo bill = new SopBillInfo();
        bill.setStorageOrgUnit(info.getStorageOrgUnit());
        bill.setSupplyStorageOrgUnit(info.getStorageOrgUnit());
        bill.setMaterial(m);
        SOPPlanVersionInfo sinfo = (SOPPlanVersionInfo)model.get("__planVersion");
        if (sinfo == null) {
            sinfo = new SOPPlanVersionInfo();
            sinfo.setId(BOSUuid.read((String)"MhhE36S+Qcy2gimEuZuUj5eYTjA="));
        }
        bill.setPlanVersion(sinfo);
        bill.setBopDate(new java.util.Date());
        bill.setBop(totalQty);
        bill.setBaseBop(totalQty);
        bill.setAssistUnit(m.getBaseUnit());
        bill.setBaseUnit(m.getBaseUnit());
        ISopBill billCtrl = SopBillFactory.getLocalInstance((Context)ctx);
        IObjectPK billID = billCtrl.addnew(bill);
        ISopPlan planCtrl = SopPlanFactory.getLocalInstance((Context)ctx);
        ISopDayPlan planDayCtrl = SopDayPlanFactory.getLocalInstance((Context)ctx);
        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMdd");
        String periodNumberStr = null;
        String monthPeriodNumberStr = null;
        String weekPeriodNumberStr = null;
        HashMap<String, SopPlanInfo> cachePlanInfoMap = new HashMap<String, SopPlanInfo>();
        for (int i = 0; i < entrys.size(); ++i) {
            java.util.Date endDate;
            SaleForeCastEntryInfo entryInfo = entrys.get(i);
            java.util.Date beginDate = entryInfo.getBeginDate();
            List workDayList = this.getWorkDayList(ctx, beginDate, endDate = entryInfo.getEndDate(), info.getStorageOrgUnit().toString());
            if (workDayList == null || workDayList.size() < 1) {
                String beginDateStr = this.sdf.format(beginDate);
                String endDateStr = this.sdf.format(endDate);
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("\u8f6c\u6362 \u9519\u8bef", "\u8bf7\u5148\u7ef4\u62a4\u65e5\u671f[" + beginDateStr + "]-[" + endDateStr + "]\u5bf9\u5e94\u7684\u5de5\u5382\u65e5\u5386");
                throw new InterfaceDataBaseException(interfaceException);
            }
            BigDecimal qty = entryInfo.getQty();
            BigDecimal avgQty = qty.divide(new BigDecimal(workDayList.size()), 4);
            for (int j = 0; j < workDayList.size(); ++j) {
                java.util.Date workDate = (java.util.Date)workDayList.get(j);
                int year = DateUtil.getYear(workDate);
                int period = DateUtil.getMonth(workDate);
                int week = DateUtil.getWeek(workDate);
                SopDayPlanInfo sopDayPlanInfo = new SopDayPlanInfo();
                sopDayPlanInfo.setParent(bill);
                sopDayPlanInfo.setBaseProdTheoryQty(BigDecimal.ZERO);
                sopDayPlanInfo.setBaseProductionQty(BigDecimal.ZERO);
                sopDayPlanInfo.setBaseSalesQty(avgQty);
                sopDayPlanInfo.setBaseTargetInvQty(BigDecimal.ZERO);
                periodNumberStr = sd.format(workDate);
                int periodNumber = Integer.parseInt(periodNumberStr);
                sopDayPlanInfo.setPeriodNumber(periodNumber);
                sopDayPlanInfo.setProdTheoryQty(BigDecimal.ZERO);
                sopDayPlanInfo.setProductionQty(BigDecimal.ZERO);
                sopDayPlanInfo.setSalesQty(avgQty);
                planDayCtrl.addnew(sopDayPlanInfo);
                periodNumberStr = year + "";
                periodNumberStr = period > 9 ? periodNumberStr + period : periodNumberStr + "0" + period;
                monthPeriodNumberStr = periodNumberStr + "Month";
                SopPlanInfo sopPlanInfo = null;
                if (cachePlanInfoMap != null && cachePlanInfoMap.containsKey(monthPeriodNumberStr)) {
                    sopPlanInfo = (SopPlanInfo)cachePlanInfoMap.get(monthPeriodNumberStr);
                } else {
                    sopPlanInfo = new SopPlanInfo();
                    sopPlanInfo.setParent(bill);
                    sopPlanInfo.setBaseProdTheoryQty(BigDecimal.ZERO);
                    sopPlanInfo.setBaseProductionQty(BigDecimal.ZERO);
                    sopPlanInfo.setBaseSalesQty(BigDecimal.ZERO);
                    sopPlanInfo.setBaseTargetInvQty(BigDecimal.ZERO);
                    sopPlanInfo.setEditMode(SOPEditModeEnum.MONTHLY);
                    sopPlanInfo.setPeriod(period);
                    sopPlanInfo.setYear(year);
                    periodNumber = Integer.parseInt(periodNumberStr);
                    sopPlanInfo.setPeriodNumber(periodNumber);
                    sopPlanInfo.setProdTheoryQty(BigDecimal.ZERO);
                    sopPlanInfo.setProductionQty(BigDecimal.ZERO);
                    sopPlanInfo.setSalesQty(BigDecimal.ZERO);
                }
                sopPlanInfo.setSalesQty(sopPlanInfo.getSalesQty().add(avgQty));
                sopPlanInfo.setBaseSalesQty(sopPlanInfo.getBaseSalesQty().add(avgQty));
                if (sopPlanInfo.getId() == null) {
                    planCtrl.addnew((CoreBaseInfo)sopPlanInfo);
                } else {
                    planCtrl.save((CoreBaseInfo)sopPlanInfo);
                }
                cachePlanInfoMap.put(monthPeriodNumberStr, sopPlanInfo);
                periodNumberStr = year + "";
                periodNumberStr = period > 9 ? periodNumberStr + week : periodNumberStr + "0" + week;
                weekPeriodNumberStr = periodNumberStr + "WEEK";
                if (cachePlanInfoMap != null && cachePlanInfoMap.containsKey(weekPeriodNumberStr)) {
                    sopPlanInfo = (SopPlanInfo)cachePlanInfoMap.get(weekPeriodNumberStr);
                } else {
                    sopPlanInfo = new SopPlanInfo();
                    sopPlanInfo.setParent(bill);
                    sopPlanInfo.setBaseProdTheoryQty(BigDecimal.ZERO);
                    sopPlanInfo.setBaseProductionQty(BigDecimal.ZERO);
                    sopPlanInfo.setBaseSalesQty(BigDecimal.ZERO);
                    sopPlanInfo.setBaseTargetInvQty(BigDecimal.ZERO);
                    sopPlanInfo.setEditMode(SOPEditModeEnum.WEEKLY);
                    sopPlanInfo.setPeriod(week);
                    sopPlanInfo.setYear(year);
                    periodNumber = Integer.parseInt(periodNumberStr);
                    sopPlanInfo.setPeriodNumber(periodNumber);
                    sopPlanInfo.setProdTheoryQty(BigDecimal.ZERO);
                    sopPlanInfo.setProductionQty(BigDecimal.ZERO);
                    sopPlanInfo.setSalesQty(BigDecimal.ZERO);
                }
                sopPlanInfo.setSalesQty(sopPlanInfo.getSalesQty().add(avgQty));
                sopPlanInfo.setBaseSalesQty(sopPlanInfo.getBaseSalesQty().add(avgQty));
                if (sopPlanInfo.getId() == null) {
                    planCtrl.addnew((CoreBaseInfo)sopPlanInfo);
                } else {
                    planCtrl.save((CoreBaseInfo)sopPlanInfo);
                }
                cachePlanInfoMap.put(weekPeriodNumberStr, sopPlanInfo);
            }
        }
    }

    protected boolean checkExistData(Context ctx, java.util.Date beginDate, java.util.Date endDate, String materialID, String orgUnitID) throws BOSException, EASBizException {
        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMdd");
        StringBuffer sql = new StringBuffer();
        sql.append(" Select d.fid ");
        sql.append(" from t_mm_sopbill h ");
        sql.append(" inner join t_mm_sopdayplan d on h.fid = d.fparentid ");
        sql.append(" where h.fstorageorgunitid = '" + orgUnitID + "' ");
        sql.append(" and h.fmaterialid = '" + materialID + "' ");
        sql.append(" And d.fperiodnumber >= " + sd.format(beginDate) + "");
        sql.append(" And d.fperiodnumber <= " + sd.format(endDate) + "");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

