/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.fcs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.industry.emm.project.fcs.PriceModeEnum;
import com.kingdee.eas.industry.emm.project.fcs.app.AbstractSaleMaterialABCFacadeControllerBean;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPSysParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SaleMaterialABCFacadeControllerBean
extends AbstractSaleMaterialABCFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.project.fcs.app.SaleMaterialABCFacadeControllerBean");
    private static final String resClassName = "com.kingdee.eas.industry.emm.project.fcs.SaleMaterialABCResource";
    public List<String> storageOrgUnitNumberList = null;
    public List<String> supplyOrgUnitNumberList = null;
    public String beginMaterialNumber = null;
    public String endMaterialNumber = null;
    public BigDecimal aPercent = null;
    public BigDecimal bPercent = null;
    public BigDecimal cPercent = null;
    public String planVersionID = null;
    public PriceModeEnum priceMode = null;
    public int numOfPeriod = 0;
    public List<Integer> periodNumberList = null;

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    private List<String> arrayToList(String[] aa) {
        if (aa == null || aa.length < 1) {
            return null;
        }
        ArrayList<String> returnList = new ArrayList<String>();
        for (int i = 0; i < aa.length; ++i) {
            returnList.add(aa[i]);
        }
        return returnList;
    }

    public void initParams(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.storageOrgUnitNumberList = new ArrayList<String>();
        this.supplyOrgUnitNumberList = new ArrayList<String>();
        this.periodNumberList = new ArrayList<Integer>();
        this.beginMaterialNumber = null;
        this.endMaterialNumber = null;
        this.aPercent = null;
        this.bPercent = null;
        this.cPercent = null;
        this.planVersionID = null;
        this.priceMode = null;
        this.numOfPeriod = 0;
        if (params.getString("StoragergUnit") != null) {
            this.storageOrgUnitNumberList = this.arrayToList(params.getString("StoragergUnit").split(";"));
        }
        if (params.getString("supplyOrgUnit") != null) {
            this.supplyOrgUnitNumberList = this.arrayToList(params.getString("supplyOrgUnit").split(";"));
        }
        if (params.getString("beginMaterial") != null) {
            this.beginMaterialNumber = params.getString("beginMaterial");
        }
        if (params.getString("endMaterial") != null) {
            this.endMaterialNumber = params.getString("endMaterial");
        }
        if (params.getString("aPercent") != null) {
            this.aPercent = new BigDecimal(params.getString("aPercent"));
        }
        if (params.getString("bPercent") != null) {
            this.bPercent = new BigDecimal(params.getString("bPercent"));
        }
        if (params.getString("cPercent") != null) {
            this.cPercent = new BigDecimal(params.getString("cPercent"));
        }
        if (params.getString("planVersion") != null) {
            this.planVersionID = this.getPlanVersionID(ctx, params.getString("planVersion"));
        }
        if (params.getString("priceMode") != null) {
            this.priceMode = PriceModeEnum.getEnum(Integer.parseInt(params.getString("priceMode")));
        }
        if (params.getString("SOPPlanTerm") != null && params.getString("numOfPeriod") != null) {
            String SOPPlanTerm = params.getString("SOPPlanTerm");
            String orgID = this.getOrgUnitID(ctx);
            SOPSysParams SOPParams = SOPFacadeFactory.getLocalInstance((Context)ctx).getSOPSysParams(orgID);
            SOPPeriod curPeriod = SOPFacadeFactory.getLocalInstance((Context)ctx).getCurrentPeriod(SOPEditModeEnum.MONTHLY, orgID);
            SOPPeriod[] periods = curPeriod.periodRange(SOPParams.getSOPMonthHorizon());
            for (int i = 0; i < periods.length; ++i) {
                if (!periods[i].toString().equals(SOPPlanTerm)) continue;
                SOPPeriod selectePeriod = periods[i];
                this.numOfPeriod = Integer.parseInt(params.getString("numOfPeriod"));
                SOPPeriod[] periodRange = selectePeriod.forwardPeriods(this.numOfPeriod);
                for (int j = 0; j < periodRange.length; ++j) {
                    this.periodNumberList.add(periodRange[j].toNumber());
                }
            }
        }
    }

    protected String getPlanVersionID(Context ctx, String name) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_mm_sopplanversion where fname = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{name});
        try {
            if (rs.next()) {
                return rs.getString("fid");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    protected String getOrgUnitID(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_org_storage where fnumber in (").append(SQLUtil.arrayToString((Object[])this.storageOrgUnitNumberList.toArray())).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return rs.getString("fid");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String precision = params.getString("currPrecision");
        this.initParams(ctx, params);
        this.dropTempTable(params.getString("expandBomTempTable"), ctx);
        String salePlanTempTable = null;
        String expandBomTempTable = null;
        try {
            salePlanTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.createSalePlanTempTableSql());
            params.setString("salePlanTempTable", salePlanTempTable);
            this.buildSalePlanTempTable(ctx, salePlanTempTable, params);
            expandBomTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.createExpandBomTempTableSql());
            params.setString("expandBomTempTable", expandBomTempTable);
            this.expandBom(ctx, salePlanTempTable, expandBomTempTable, params);
            this.dropTempTable(params.getString("salePlanTempTable"), ctx);
            String countSql = "select count(1) cc from " + expandBomTempTable;
            RptRowSet rs = this.executeQuery(countSql, null, ctx);
            rs.next();
            int count = rs.getInt(0);
            RptTableHeader header = new RptTableHeader();
            RptTableColumn col = null;
            col = new RptTableColumn("FmaterialNumber");
            col.setWidth(200);
            header.addColumn(col);
            col = new RptTableColumn("FmaterialName");
            col.setWidth(200);
            header.addColumn(col);
            col = new RptTableColumn("FmaterialModel");
            col.setWidth(200);
            header.addColumn(col);
            col = new RptTableColumn("FQty");
            col.setWidth(100);
            col.setAligment(2);
            col.setFormatPattern(RptCellFormatter.getNumberFormat((int)2, (boolean)true));
            header.addColumn(col);
            col = new RptTableColumn("Fprice");
            col.setWidth(100);
            col.setAligment(2);
            col.setFormatPattern(RptCellFormatter.getNumberFormat((int)2, (boolean)true));
            header.addColumn(col);
            col = new RptTableColumn("Famount");
            col.setWidth(100);
            col.setAligment(2);
            col.setFormatPattern(RptCellFormatter.getNumberFormat((int)2, (boolean)true));
            header.addColumn(col);
            col = new RptTableColumn("FunitName");
            col.setWidth(50);
            header.addColumn(col);
            col = new RptTableColumn("FPercentMaterial");
            col.setWidth(100);
            col.setAligment(2);
            col.setFormatPattern(RptCellFormatter.getNumberFormat((int)4, (boolean)true));
            header.addColumn(col);
            col = new RptTableColumn("FABC");
            col.setWidth(100);
            col.setAligment(2);
            col.setFormatPattern("@=?C:$_");
            header.addColumn(col);
            header.setLabels((Object[][])new Object[][]{{this.getHeaderResource("FmaterialNumber", ctx), this.getHeaderResource("FmaterialName", ctx), this.getHeaderResource("FmaterialModel", ctx), this.getHeaderResource("FQty", ctx), this.getHeaderResource("Fprice", ctx), this.getHeaderResource("Famount", ctx), this.getHeaderResource("FunitName", ctx), this.getHeaderResource("FPercentMaterial", ctx), this.getHeaderResource("FABC", ctx)}});
            RptParams result = new RptParams();
            result.setString("tempTable", expandBomTempTable);
            result.setObject("header", (Object)header);
            result.setInt("verticalCount", count);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (salePlanTempTable != null && !"".equals(salePlanTempTable)) {
                this.dropTempTable(salePlanTempTable, ctx);
            }
            if (expandBomTempTable != null && !"".equals(expandBomTempTable)) {
                this.dropTempTable(expandBomTempTable, ctx);
            }
            params.setString("salePlanTempTable", null);
            params.setString("expandBomTempTable", null);
            throw new BOSException((Throwable)e);
        }
    }

    public String getHeaderResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    public int executeSQL(Context ctx, String sql) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            long startTime = System.currentTimeMillis();
            int effectedRows = statement.executeUpdate(sql);
            long endTime = System.currentTimeMillis();
            long duration = (endTime - startTime) / 1000L;
            System.out.println("Execute SQL Effected Rows " + effectedRows + " Duration " + duration + " Sec:\r\n" + sql.toString());
            int n = effectedRows;
            return n;
        }
        catch (SQLException e) {
            throw new BOSException(sql, (Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    private void buildSalePlanTempTable(Context ctx, String salePlanTempTable, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert Into ").append(salePlanTempTable).append("(");
        sql.append(" qty ");
        sql.append(",materialid");
        sql.append(",baseUnitID");
        sql.append(",sulpplyOrgUnitID");
        sql.append(" )");
        sql.append(" Select sum(d.fsalesqty) As fsalesqty,h.fmaterialid,h.fbaseunitid as fbaseunitid,h.fsupplystorageorgunitid ");
        sql.append(" from t_mm_sopbill h ");
        sql.append(" inner join t_mm_sopplan d on h.fid = d.fparentid ");
        sql.append(" inner join t_bd_material m on m.fid = h.fmaterialid ");
        sql.append(" inner join t_org_storage s on s.fid = h.fstorageorgunitid ");
        sql.append(" inner join t_org_storage s2 on s2.fid = h.fsupplystorageorgunitid ");
        sql.append(" where 1 = 1 ");
        if (this.beginMaterialNumber != null) {
            sql.append(" and m.fnumber >= '" + this.beginMaterialNumber + "' ");
        }
        if (this.endMaterialNumber != null) {
            sql.append(" and m.fnumber <= '" + this.endMaterialNumber + "' ");
        }
        if (this.storageOrgUnitNumberList != null && this.storageOrgUnitNumberList.size() > 0) {
            sql.append(" and s.fnumber in (" + SQLUtil.arrayToString((Object[])this.storageOrgUnitNumberList.toArray()) + ") ");
        }
        if (this.supplyOrgUnitNumberList != null && this.supplyOrgUnitNumberList.size() > 0) {
            sql.append(" and s2.fnumber in (" + SQLUtil.arrayToString((Object[])this.supplyOrgUnitNumberList.toArray()) + ") ");
        }
        if (this.planVersionID != null) {
            sql.append(" and h.fplanversionid = '" + this.planVersionID + "' ");
        }
        if (this.periodNumberList != null && this.periodNumberList.size() > 0) {
            sql.append(" and ( ");
            for (int i = 0; i < this.periodNumberList.size(); ++i) {
                sql.append(" d.fperiodnumber = " + this.periodNumberList.get(i) + "  ");
                if (i >= this.periodNumberList.size() - 1) continue;
                sql.append(" or ");
            }
            sql.append(" ) ");
        }
        sql.append(" and d.feditmode = 20 ");
        sql.append(" group by h.fmaterialid,h.fbaseunitid,h.fsupplystorageorgunitid ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void expandBom(Context ctx, String salePlanTempTable, String bomexpandTempTable, RptParams params) throws BOSException {
        MMUtils.createTableIndex((Context)ctx, (String)bomexpandTempTable, (String[])new String[]{"Flevel"});
        MMUtils.createTableIndex((Context)ctx, (String)bomexpandTempTable, (String[])new String[]{"materialid,sulpplyOrgUnitID"});
        int effectedRows = 0;
        StringBuilder sb = new StringBuilder();
        for (int level = 0; level < 50; ++level) {
            effectedRows = 0;
            sb.setLength(0);
            sb.append(this.getInsertTableSQL(bomexpandTempTable)).append(" \r\n");
            sb.append(" Select \r\n");
            if (level == 0) {
                sb.append("  Sum(a.qty * bomentry.fconsumefixqty) As qty  ");
                sb.append(", bomentry.fmaterialid As materialid ");
                sb.append(", bomentry.funitid As baseUnitID ");
                sb.append(", bomentry.fsupplystorageorgunitid As sulpplyOrgUnitID ");
                if (this.priceMode != null && this.priceMode.equals((Object)PriceModeEnum.StandPrice)) {
                    sb.append(", isnull(mc.fstandardcost,0) As price");
                    sb.append(", Sum(isnull(mc.fstandardcost,0) * (a.qty * bomentry.fconsumefixqty))  As amount");
                } else {
                    sb.append(", 0 As price");
                    sb.append(", 0  As amount");
                }
                sb.append(", bomentry.fmaterialprop As materialAttr  ");
                sb.append(", " + level + " As Flevel  ");
                sb.append(" From t_mm_bom bom");
                sb.append(" inner Join ").append(salePlanTempTable).append(" a on a.materialid = bom.fmaterialid and a.sulpplyOrgUnitID = bom.FStorageorgUnitID  ");
                sb.append(" inner Join  t_mm_bomentry bomentry on bomentry.fparentid = bom.fid ");
                if (this.priceMode != null && this.priceMode.equals((Object)PriceModeEnum.StandPrice)) {
                    sb.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID = bomentry.fsupplystorageorgunitid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                    sb.append(" left outer join t_bd_materialcompanyinfo mc on mc.fmaterialid = bomentry.fmaterialid and mc.fcompanyid = r0.FToUnitID ");
                }
                sb.append(" where bom.fbasestatus = 4");
                sb.append(" and bomentry.fconsumefixqty > 0");
                sb.append(" and  bom.fbomtype = ").append(40).append(" \r\n");
                sb.append(" group By bomentry.fmaterialid ");
                sb.append(", bomentry.funitid  ");
                sb.append(", bomentry.fsupplystorageorgunitid ");
                if (this.priceMode != null && this.priceMode.equals((Object)PriceModeEnum.StandPrice)) {
                    sb.append(", mc.fstandardcost ");
                }
                sb.append(", bomentry.fmaterialprop  ");
            } else {
                sb.append("  Sum(a.qty * bomentry.fconsumefixqty) As qty  ");
                sb.append(", bomentry.fmaterialid As materialid ");
                sb.append(", bomentry.funitid As baseUnitID ");
                sb.append(", bomentry.fsupplystorageorgunitid As sulpplyOrgUnitID ");
                if (this.priceMode != null && this.priceMode.equals((Object)PriceModeEnum.StandPrice)) {
                    sb.append(", isnull(mc.fstandardcost,0) As price");
                    sb.append(", Sum(isnull(mc.fstandardcost,0) * (a.qty * bomentry.fconsumefixqty))  As amount");
                } else {
                    sb.append(", 0 As price");
                    sb.append(", 0  As amount");
                }
                sb.append(", bomentry.fmaterialprop As materialAttr  ");
                sb.append(", " + level + " As Flevel  ");
                sb.append(" From t_mm_bom bom");
                sb.append(" inner Join ").append(bomexpandTempTable).append(" a on a.materialid = bom.fmaterialid and a.sulpplyOrgUnitID = bom.fstorageorgunitid   ");
                sb.append(" inner Join  t_mm_bomentry bomentry on bomentry.fparentid = bom.fid ");
                if (this.priceMode != null && this.priceMode.equals((Object)PriceModeEnum.StandPrice)) {
                    sb.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID = bomentry.fsupplystorageorgunitid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                    sb.append(" left outer join t_bd_materialcompanyinfo mc on mc.fmaterialid = bomentry.fmaterialid and mc.fcompanyid = r0.FToUnitID ");
                }
                sb.append(" where bom.fbasestatus = 4");
                sb.append(" and a.Flevel = " + (level - 1) + "");
                sb.append(" and bomentry.fconsumefixqty > 0");
                sb.append(" and  bom.fbomtype = ").append(40).append(" \r\n");
                sb.append(" group By bomentry.fmaterialid ");
                sb.append(", bomentry.funitid  ");
                sb.append(", bomentry.fsupplystorageorgunitid ");
                if (this.priceMode != null && this.priceMode.equals((Object)PriceModeEnum.StandPrice)) {
                    sb.append(", mc.fstandardcost ");
                }
                sb.append(", bomentry.fmaterialprop  ");
            }
            effectedRows = this.executeSQL(ctx, sb.toString());
            if (effectedRows <= 0) break;
        }
        sb.setLength(0);
        sb.append(" delete from  ").append(bomexpandTempTable).append("  ");
        sb.append(" where materialAttr not in(10040,10050) ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        if (this.priceMode != null && this.priceMode.equals((Object)PriceModeEnum.NewPurPrice)) {
            sb.setLength(0);
            sb.append(" update ").append(bomexpandTempTable).append(" a ");
            sb.append(" set price = isnull(( ");
            sb.append(" Select top 1 sd.FTaxPrice ");
            sb.append(" from t_sm_purorder sh ");
            sb.append(" inner join t_sm_purorderentry sd on sh.fid = sd.fparentid ");
            sb.append(" where sh.fbasestatus in(4,7) ");
            sb.append(" and sd.fmaterialid = a.materialid ");
            sb.append(" order by sh.faudittime desc ),0) ");
            DbUtil.execute((Context)ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" update ").append(bomexpandTempTable).append(" a ");
            sb.append(" set amount = price * qty ");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        } else if (this.priceMode != null && this.priceMode.equals((Object)PriceModeEnum.NewAPPrice)) {
            sb.setLength(0);
            sb.append(" update ").append(bomexpandTempTable).append(" a ");
            sb.append(" set price = isnull(( ");
            sb.append(" Select top 1 sd.FTaxPrice ");
            sb.append(" from T_AP_OtherBill sh ");
            sb.append(" inner join t_Ap_Otherbillentry sd on sh.fid = sd.fparentid ");
            sb.append(" where sh.fbillstatus in(4,7) ");
            sb.append(" and sd.fmaterialid = a.materialid ");
            sb.append(" order by sh.fauditdate desc ),0) ");
            DbUtil.execute((Context)ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" update ").append(bomexpandTempTable).append(" a ");
            sb.append(" set amount = price * qty ");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        sb.setLength(0);
        sb.append(" Select sum(amount) As amount from ").append(bomexpandTempTable).append("  ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        BigDecimal totalAmount = BigDecimal.ZERO;
        try {
            if (rs.next() && (totalAmount = rs.getBigDecimal("amount")).compareTo(BigDecimal.ZERO) > 0) {
                sb.setLength(0);
                sb.append(" update ").append(bomexpandTempTable).append(" a ");
                sb.append(" set FPercentMaterial = round(a.amount / " + totalAmount + ",4) ");
                DbUtil.execute((Context)ctx, (String)sb.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptParams pp = new RptParams();
        pp.setObject("title", (Object)new Timestamp(System.currentTimeMillis()));
        return pp;
    }

    private String createSalePlanTempTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("\r\n qty NUMERIC(21,8) DEFAULT 0 ");
        sql.append(",\r\n materialid varchar(44)");
        sql.append(",\r\n baseUnitID varchar(44)");
        sql.append(",\r\n sulpplyOrgUnitID varchar(44)");
        sql.append(")");
        return sql.toString();
    }

    private String createExpandBomTempTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("\r\n qty NUMERIC(21,8) DEFAULT 0 ");
        sql.append(",\r\n materialid varchar(44)");
        sql.append(",\r\n baseUnitID varchar(44)");
        sql.append(",\r\n sulpplyOrgUnitID varchar(44)");
        sql.append(",\r\n price NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\n amount NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\n materialAttr Int ");
        sql.append(",\r\n Flevel Int ");
        sql.append(",\r\n FPercentMaterial NUMERIC(21,8) DEFAULT 0");
        sql.append(")");
        return sql.toString();
    }

    protected String getInsertTableSQL(String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert Into ").append(tableName).append("(\r\n");
        sb.append("\r\n qty  ");
        sb.append(",\r\n materialid ");
        sb.append(",\r\n baseUnitID ");
        sb.append(",\r\n sulpplyOrgUnitID ");
        sb.append(",\r\n price");
        sb.append(",\r\n amount");
        sb.append(",\r\n materialAttr  ");
        sb.append(",\r\n Flevel  ");
        sb.append(")");
        return sb.toString();
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("select Material.fnumber As FmaterialNumber ,");
        sqlbf.append(" Material.fname_l2 As FmaterialName ,");
        sqlbf.append(" Material.fmodel As FmaterialModel ,");
        sqlbf.append(" temp.qty As FQty ,");
        sqlbf.append(" temp.price As Fprice ,");
        sqlbf.append(" temp.amount As Famount ,");
        sqlbf.append(" unit.fname_l2 As FunitName ,");
        sqlbf.append(" temp.FPercentMaterial As FPercentMaterial ,");
        sqlbf.append(" '' As FABC ");
        sqlbf.append(" from ");
        sqlbf.append(params.getString("tempTable")).append(" AS temp ");
        sqlbf.append(" left outer join T_BD_Material  Material ON temp.materialid = Material.fid ");
        sqlbf.append(" left outer join t_bd_measureunit  unit ON unit.fid = temp.baseUnitID ");
        sqlbf.append(" order by temp.amount DESC");
        RptRowSet rs = this.executeQuery(sqlbf.toString(), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }
}

