/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.webservice.AbstractWSDesignBomWebServiceFacadeControllerBean;
import com.kingdee.eas.industry.webservice.WSDesignBomInfo;
import com.kingdee.eas.mm.basedata.DesignModeCollection;
import com.kingdee.eas.mm.basedata.DesignModeFactory;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.zjbom.BusinessChangeTypeEnum;
import com.kingdee.eas.zjbom.BusinessRepCollection;
import com.kingdee.eas.zjbom.BusinessRepEntryFactory;
import com.kingdee.eas.zjbom.BusinessRepEntryInfo;
import com.kingdee.eas.zjbom.BusinessRepFactory;
import com.kingdee.eas.zjbom.BusinessRepInfo;
import com.kingdee.eas.zjbom.DesignBOMBillCollection;
import com.kingdee.eas.zjbom.DesignBOMBillFactory;
import com.kingdee.eas.zjbom.DesignBOMBillInfo;
import com.kingdee.eas.zjbom.IDesignBOMBill;
import com.kingdee.eas.zjbom.app.util.BomBotpUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WSDesignBomWebServiceFacadeControllerBean
extends AbstractWSDesignBomWebServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.webservice.WSDesignBomWebServiceFacadeControllerBean");

    @Override
    protected String[] _importDesignBom(Context ctx, IObjectCollection wswsDesignBom) throws BOSException, EASBizException {
        if (wswsDesignBom.size() == 0 || wswsDesignBom == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"QSXLHSJBOMCS_LESS", (Locale)ctx.getLocale()));
        }
        System.out.print("---------------webservice start import DesignBom-------------------");
        CoreBaseCollection coreBaseCol = new CoreBaseCollection();
        IDesignBOMBill idb = DesignBOMBillFactory.getLocalInstance(ctx);
        String[] result = new String[wswsDesignBom.size()];
        for (int i = 0; i < wswsDesignBom.size(); ++i) {
            System.out.println(wswsDesignBom.getClass() + ":" + wswsDesignBom.getObject(i).toString() + ";");
            WSDesignBomInfo wsDesignBomInfo = (WSDesignBomInfo)wswsDesignBom.getObject(i);
            String error = "";
            if (wsDesignBomInfo.getDesignno() == null || wsDesignBomInfo.getDesignno().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJRGHNUMBER_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)wsDesignBomInfo.getDesignno(), CompareType.EQUALS));
            if (!UserFactory.getLocalInstance((Context)ctx).exists(filter)) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJRGHBCZ_NOT_EXIST", (Locale)ctx.getLocale(), (Object[])new Object[]{wsDesignBomInfo.getDesignno()});
                result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfoByNumber(wsDesignBomInfo.getDesignno());
            FullOrgUnitInfo fullOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(userInfo.getDefOrgUnit().getId()));
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (fullOrg.getCU() != null) {
                cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(fullOrg.getCU().getId()));
            }
            if (!WSDesignBomWebServiceFacadeControllerBean.hasPermission(ctx, "emm_mm_zjbom_designbom_AddNew", new ObjectUuidPK(cu.getId()), userInfo.getId().toString())) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJRMYZZSJBXZQXZ_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{userInfo.getName(), cu.getName()});
                result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsDesignBomInfo.getSourceBillId() == null || wsDesignBomInfo.getSourceBillId().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"PLMSJBOMID_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsDesignBomInfo.getDesigner() == null || wsDesignBomInfo.getDesigner().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJRXMNAME_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsDesignBomInfo.getName() == null || wsDesignBomInfo.getName().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LJMCBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsDesignBomInfo.getParentNo() == null || wsDesignBomInfo.getParentNo().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SSLJBMBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsDesignBomInfo.getParentName() == null || wsDesignBomInfo.getParentName().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SSLJMCBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsDesignBomInfo.getPartNo() == null || wsDesignBomInfo.getPartNo().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LJBMBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsDesignBomInfo.getPMUnitname() == null || wsDesignBomInfo.getPMUnitname().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SSLJJLDWMCB_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsDesignBomInfo.getSeqNo() != null && !wsDesignBomInfo.getSeqNo().equals("")) {
                if (!WSDesignBomWebServiceFacadeControllerBean.isInteteger(wsDesignBomInfo.getSeqNo())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"ZHPXHGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                    continue;
                }
            } else {
                wsDesignBomInfo.setSeqNo("0");
            }
            if (wsDesignBomInfo.getBz() != null && !wsDesignBomInfo.getBz().equals("")) {
                if (!wsDesignBomInfo.getBz().equals("0") && !wsDesignBomInfo.getBz().equals("1")) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JYBZHZNWLY_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                    continue;
                }
            } else {
                wsDesignBomInfo.setBz("0");
            }
            if (wsDesignBomInfo.getDesigndate() != null && !wsDesignBomInfo.getDesigndate().equals("")) {
                if (!WSDesignBomWebServiceFacadeControllerBean.isDate(wsDesignBomInfo.getDesigndate())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJRIGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                    continue;
                }
            } else {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJRQDATE_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsDesignBomInfo.getWeight() != null && !wsDesignBomInfo.getWeight().equals("")) {
                if (!WSDesignBomWebServiceFacadeControllerBean.isPosNumber(wsDesignBomInfo.getWeight())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"DZHGSHBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                    continue;
                }
            }
            if (wsDesignBomInfo.getParentQty() != null && !wsDesignBomInfo.getParentQty().equals("")) {
                if (!WSDesignBomWebServiceFacadeControllerBean.isPosNumber(wsDesignBomInfo.getParentQty())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SSLJSLGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                    continue;
                }
            } else {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SSLJSHL_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsDesignBomInfo.getQuantity() != null && !wsDesignBomInfo.getQuantity().equals("")) {
                if (!WSDesignBomWebServiceFacadeControllerBean.isPosNumber(wsDesignBomInfo.getQuantity())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"ZHPSHUL_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                    continue;
                }
            } else {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"ZHSHLBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsDesignBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            String designResult = this.addNewDesignBom(ctx, wsDesignBomInfo, userInfo, cu, coreBaseCol);
            if (coreBaseCol.size() > 0) {
                int size = coreBaseCol.size();
                for (int j = 0; j < size; ++j) {
                    idb.save(coreBaseCol.get(j));
                }
            }
            result[i] = designResult;
        }
        return result;
    }

    private String addNewDesignBom(Context ctx, WSDesignBomInfo wsDesignBomInfo, UserInfo userInfo, CtrlUnitInfo cu, CoreBaseCollection coreBaseCol) throws BOSException, EASBizException {
        DesignBOMBillInfo newInfo = new DesignBOMBillInfo();
        IDesignBOMBill idb = DesignBOMBillFactory.getLocalInstance(ctx);
        DesignBOMBillCollection designCol = idb.getDesignBOMBillCollection("select id where sourceBillId ='" + wsDesignBomInfo.getSourceBillId() + "'");
        BOSUuid pk = null;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        if (designCol != null && designCol.size() > 0) {
            pk = designCol.get(0).getId();
            newInfo = idb.getDesignBOMBillInfo((IObjectPK)new ObjectUuidPK(pk));
            if (newInfo.getState().equals((Object)BillBaseStatusEnum.AUDITED)) {
                BOTMappingInfo dbbBotp = BomBotpUtil.getBOTP(ctx, "MM_BR003");
                BusinessRepCollection coll = BomBotpUtil.createBillByBOTP8808(ctx, newInfo, dbbBotp);
                BusinessRepInfo brInfo = new BusinessRepInfo();
                if (coll != null && coll.size() > 0) {
                    brInfo = coll.get(0);
                }
                brInfo.setCU(newInfo.getCU());
                brInfo.setState(BillBaseStatusEnum.TEMPORARILYSAVED);
                BusinessRepEntryInfo breInfo = BusinessRepEntryFactory.getLocalInstance(ctx).getBusinessRepEntryInfo((IObjectPK)new ObjectUuidPK(brInfo.getEntrys().get(0).getId()));
                breInfo.setMno(wsDesignBomInfo.getPartNo());
                breInfo.setMname(wsDesignBomInfo.getName());
                breInfo.setUnitname(wsDesignBomInfo.getUnit());
                breInfo.setZpxh(new BigDecimal(wsDesignBomInfo.getSeqNo()));
                if (wsDesignBomInfo.getWeight() != null && !wsDesignBomInfo.getWeight().equals("")) {
                    breInfo.setWeight(new BigDecimal(wsDesignBomInfo.getWeight()));
                }
                breInfo.setQty(new BigDecimal(wsDesignBomInfo.getQuantity()));
                breInfo.setPQty(new BigDecimal(wsDesignBomInfo.getParentQty()));
                breInfo.setPmno(wsDesignBomInfo.getParentNo());
                breInfo.setPmname(wsDesignBomInfo.getParentName());
                breInfo.setParentchartno(wsDesignBomInfo.getParentchartno());
                breInfo.setPUnitname(wsDesignBomInfo.getPMUnitname());
                breInfo.setCmno(wsDesignBomInfo.getStuffNo());
                breInfo.setCmname(wsDesignBomInfo.getStruffName());
                if (wsDesignBomInfo.getMakeFlow() != null && !wsDesignBomInfo.getMakeFlow().equals("")) {
                    breInfo.setFlow(wsDesignBomInfo.getMakeFlow());
                    breInfo.setFlowerid(userInfo);
                    breInfo.setFlowedate(new Timestamp(System.currentTimeMillis()));
                }
                breInfo.setGyinfo(wsDesignBomInfo.getGtmeno());
                breInfo.setCZ(wsDesignBomInfo.getCZ());
                breInfo.setProjectNumberPDM(wsDesignBomInfo.getProjectNo());
                breInfo.setProjectNamePDM(wsDesignBomInfo.getProjectName());
                breInfo.setBegincarnoPDM(wsDesignBomInfo.getBeginCarNo());
                breInfo.setEndcarnoPDM(wsDesignBomInfo.getEndCarNo());
                breInfo.setChangeType(BusinessChangeTypeEnum.BOMCHANGE);
                if (wsDesignBomInfo.getDesignMode() != null && !wsDesignBomInfo.getDesignMode().equals("")) {
                    DesignModeCollection designModeCol = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeCollection("select id where number='" + wsDesignBomInfo.getDesignMode() + "'");
                    if (designModeCol.size() > 0) {
                        DesignModeInfo designMode = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeInfo((IObjectPK)new ObjectUuidPK(designModeCol.get(0).getId()));
                        if (!designMode.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
                            return wsDesignBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SHJMSHWQY_NOT_ACTIVE", (Locale)ctx.getLocale(), (Object[])new Object[]{designMode.getName()});
                        }
                        breInfo.setDesignMode(designMode);
                    } else {
                        return wsDesignBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJMOSHBMEAS_NOT_EXIST", (Locale)ctx.getLocale());
                    }
                }
                breInfo.setChartno(wsDesignBomInfo.getChartno());
                breInfo.setParentchartno(wsDesignBomInfo.getParentchartno());
                breInfo.setRegisteredMark(wsDesignBomInfo.getRegisteredMark());
                breInfo.setWarrantNumber(wsDesignBomInfo.getWarrantNumber());
                breInfo.setBz(wsDesignBomInfo.getBz());
                breInfo.setSourcebillentryid(wsDesignBomInfo.getSourceBillId());
                breInfo.setPLMID(wsDesignBomInfo.getSourceBillId());
                BusinessRepFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(brInfo.getId()), (CoreBaseInfo)brInfo);
                pk = breInfo.getId();
                return wsDesignBomInfo.getSourceBillId() + ",1," + pk.toString();
            }
        } else {
            pk = BOSUuid.create((String)"64455A59");
            newInfo.setId(pk);
            newInfo.setCreator(userInfo);
            newInfo.setCreateTime(now);
            newInfo.setBizDate(now);
            newInfo.setLastUpdateUser(userInfo);
            newInfo.setLastUpdateTime(now);
            newInfo.setCU(cu);
        }
        newInfo.setGtmeno(wsDesignBomInfo.getGtmeno());
        newInfo.setPartDesc(wsDesignBomInfo.getPartDesc());
        newInfo.setModel(wsDesignBomInfo.getModel());
        newInfo.setCZ(wsDesignBomInfo.getCZ());
        newInfo.setRegisteredMark(wsDesignBomInfo.getRegisteredMark());
        newInfo.setMeno(wsDesignBomInfo.getMeno());
        newInfo.setParentchartno(wsDesignBomInfo.getParentchartno());
        Date designDate = Date.valueOf(wsDesignBomInfo.getDesigndate());
        newInfo.setDesigndate(designDate);
        newInfo.setDesigner(wsDesignBomInfo.getDesigner());
        newInfo.setDesignno(wsDesignBomInfo.getDesignno());
        newInfo.setEndCarNo(wsDesignBomInfo.getEndCarNo());
        newInfo.setBeginCarNo(wsDesignBomInfo.getBeginCarNo());
        newInfo.setProjectNo(wsDesignBomInfo.getProjectNo());
        newInfo.setProjectName(wsDesignBomInfo.getProjectName());
        newInfo.setBz(wsDesignBomInfo.getBz());
        newInfo.setChartno(wsDesignBomInfo.getChartno());
        newInfo.setParentName(wsDesignBomInfo.getParentName());
        newInfo.setStruffName(wsDesignBomInfo.getStruffName());
        newInfo.setNote(wsDesignBomInfo.getNote());
        if (wsDesignBomInfo.getMakeFlow() != null && !wsDesignBomInfo.getMakeFlow().equals("")) {
            newInfo.setMakeFlow(wsDesignBomInfo.getMakeFlow());
            newInfo.setFlowWrite(userInfo);
            newInfo.setFlowDate(new Timestamp(System.currentTimeMillis()));
        }
        newInfo.setStuffNo(wsDesignBomInfo.getStuffNo());
        newInfo.setUnit(wsDesignBomInfo.getUnit());
        if (wsDesignBomInfo.getWeight() != null && !wsDesignBomInfo.getWeight().equals("")) {
            newInfo.setWeight(new BigDecimal(wsDesignBomInfo.getWeight()));
        }
        newInfo.setQuantity(new BigDecimal(wsDesignBomInfo.getQuantity()));
        newInfo.setName(wsDesignBomInfo.getName());
        newInfo.setParentNo(wsDesignBomInfo.getParentNo());
        newInfo.setSeqNo(new Integer(wsDesignBomInfo.getSeqNo()));
        newInfo.setPartNo(wsDesignBomInfo.getPartNo());
        newInfo.setBatch(wsDesignBomInfo.getBatch());
        newInfo.setSourceBillId(wsDesignBomInfo.getSourceBillId());
        if (wsDesignBomInfo.getDesignMode() != null && !wsDesignBomInfo.getDesignMode().equals("")) {
            DesignModeCollection designModeCol = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeCollection("select id where number='" + wsDesignBomInfo.getDesignMode() + "'");
            if (designModeCol.size() > 0) {
                DesignModeInfo designMode = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeInfo((IObjectPK)new ObjectUuidPK(designModeCol.get(0).getId()));
                if (!designMode.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
                    return wsDesignBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SHJMSHWQY_NOT_ACTIVE", (Locale)ctx.getLocale(), (Object[])new Object[]{designMode.getName()});
                }
                newInfo.setDesignMode(designMode);
            } else {
                return wsDesignBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJMOSHBMEAS_NOT_EXIST", (Locale)ctx.getLocale());
            }
        }
        newInfo.setParentQty(new BigDecimal(wsDesignBomInfo.getParentQty()));
        newInfo.setPMUnit(wsDesignBomInfo.getPMUnitname());
        newInfo.setWarrantNumber(wsDesignBomInfo.getWarrantNumber());
        if (wsDesignBomInfo.getNumber() != null) {
            newInfo.setNumber(wsDesignBomInfo.getNumber());
        } else {
            String billNumber = "";
            CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule((IObjectValue)newInfo, cu.getId().toString());
            if (ruleInfo != null) {
                billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)newInfo, ruleInfo);
            }
            if (!billNumber.equals("")) {
                newInfo.setNumber(billNumber);
            }
        }
        coreBaseCol.add((CoreBaseInfo)newInfo);
        return wsDesignBomInfo.getSourceBillId() + ",1," + pk.toString();
    }

    public static boolean isPosNumber(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\d+(\\.\\d+)?$");
        return pattern.matcher(string).matches();
    }

    public static boolean isDate(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$");
        return pattern.matcher(string).matches();
    }

    public static boolean isInteteger(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[1-9]\\d*|0$");
        return pattern.matcher(string).matches();
    }

    public static boolean hasPermission(Context ctx, String permItemName, ObjectUuidPK orgIdPK, String userId) throws EASBizException, BOSException {
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        return PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgIdPK, permItemName);
    }
}

