/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IObjectBase;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.IBomEntry;
import com.kingdee.eas.mm.basedata.IMRWorkProcesEntry;
import com.kingdee.eas.mm.basedata.IOrderBOMPT;
import com.kingdee.eas.mm.basedata.IStandardRooting;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryFactory;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryInfo;
import com.kingdee.eas.mm.basedata.OrderBOMPTFactory;
import com.kingdee.eas.mm.basedata.OrderBOMPTInfo;
import com.kingdee.eas.mm.basedata.PBOMEntryCollection;
import com.kingdee.eas.mm.basedata.PBOMEntryInfo;
import com.kingdee.eas.mm.basedata.PBOMFactory;
import com.kingdee.eas.mm.basedata.PBOMInfo;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.basedata.StandardRootingTreeFacadeFactory;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class PBomDataTransfer
extends AbstractDataTransmission {
    private static String BOM_NAME = "bom.name";
    private static String BOM_NUMBER = "bom.number";
    private static String ENTRY_PARTNUMBER = "pbomEntry.partNumber";
    private static String ENTRY_ASSEMBLESEQ = "pbomEntry.assembleSeq";
    private static String ENTRY_ORDERSEQ = "pbomEntry.orderSeq";
    private static String ENTRY_ISMUSTREQ = "pbomEntry.isMustReq";
    private static String ENTRY_ISSUEMODE = "pbomEntry.issueMode";
    private static String ENTRY_STARTTRACENUMBER = "startTrackNumber.number";
    private static String ENTRY_ENDTRACENUMBER = "endTrackNumber.number";
    private static String ENTRY_CONSUMEQUOTA = "pbomEntry.consumeQuota";
    private static String ENTRY_CONSUMERATE = "pbomEntry.consumeRate";
    private static String ENTRY_MATERIAL_NAME = "pbomEntry_material.name";
    private static String ENTRY_MATERIAL_NUMBER = "pbomEntry_material.number";
    private static String MATERIAL_NAME = "routing_material.name";
    private static String MATERIAL_NUMBER = "routing_material.number";
    private static String PBOM_NAME = "name";
    private static String PBOM_NUMBER = "number";
    private static String PROJECT_NUMBER = "project.number";
    private static String ROUTING_NAME = "routing.name";
    private static String ROUTING_NUMBER = "routing.number";
    private static String ROUTINGITEM_NAME = "pbomEntry_operation.name";
    private static String ROUTINGITEM_NUMBER = "pbomEntry_operation.number";
    private static String ROUTINGITEM_WPSEQ = "pbomEntry_routingItem.wpSeq";
    private static String STORAGE_NUMBER = "storageOrgUnitNumber";
    private static String TRACK_NUMBER = "trackNumber.number";
    protected static final String COL_TEMPLATEENTRIES_NAME = "name";
    protected static final String COL_TEMPLATEENTRIES_NUMBER = "number";
    protected static final String TEMPLATENUMBER = "PBOMTemplate";
    private BomInfo bomInfo = null;
    private IBom IBom = null;
    private IBomEntry IBomEntry = null;
    private IMaterial IMaterial = null;
    private IOrderBOMPT IOrderBOMPT = null;
    private IProject IProject = null;
    private IStorageOrgUnit IStorageOrgUnit = null;
    private ITrackNumber ITrackNumber = null;
    private IMRWorkProcesEntry IWorkEntry = null;
    private IStandardRooting standardRooting = null;
    private StandardRootingInfo standardRootingInfo = null;
    private StorageOrgUnitInfo storageOrg = null;
    protected IRowSet templateEntries = null;
    Map boms = new HashMap();

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable ht = new Hashtable();
        try {
            this.putToHashtable(ht, STORAGE_NUMBER, rs.getString("STORAGEORGUNIT.NUMBER"));
            this.putToHashtable(ht, PBOM_NUMBER, rs.getString("NUMBER"));
            this.putToHashtable(ht, PBOM_NAME, rs.getString("NAME"));
            this.putToHashtable(ht, ROUTING_NUMBER, rs.getString("ROUTING.NUMBER"));
            this.putToHashtable(ht, ROUTING_NAME, rs.getString("ROUTING.NAME"));
            this.putToHashtable(ht, BOM_NUMBER, rs.getString("BOM.NUMBER"));
            this.putToHashtable(ht, BOM_NAME, rs.getString("BOM.NAME"));
            this.putToHashtable(ht, MATERIAL_NUMBER, rs.getString("MATERIAL.NUMBER"));
            this.putToHashtable(ht, MATERIAL_NAME, rs.getString("MATERIAL.NAME"));
            this.putToHashtable(ht, PROJECT_NUMBER, rs.getString("PROJECT.NUMBER"));
            this.putToHashtable(ht, TRACK_NUMBER, rs.getString("TRACKNUMBER.NUMBER"));
            this.putToHashtable(ht, ENTRY_MATERIAL_NUMBER, rs.getString("MATERIAL1.NUMBER"));
            this.putToHashtable(ht, ENTRY_MATERIAL_NAME, rs.getString("MATERIAL1.NAME"));
            this.putToHashtable(ht, ROUTINGITEM_WPSEQ, rs.getString("ROUTINGITEM.WPSEQ"));
            this.putToHashtable(ht, ROUTINGITEM_NUMBER, rs.getString("OPERATION.NUMBER"));
            this.putToHashtable(ht, ROUTINGITEM_NAME, rs.getString("OPERATION.NAME"));
            this.putToHashtable(ht, ENTRY_CONSUMEQUOTA, rs.getString("PBOMENTRY.CONSUMEQUOTA"));
            this.putToHashtable(ht, ENTRY_CONSUMERATE, rs.getString("PBOMENTRY.CONSUMERATE"));
            this.putToHashtable(ht, ENTRY_STARTTRACENUMBER, rs.getString(ENTRY_STARTTRACENUMBER.toUpperCase()));
            this.putToHashtable(ht, ENTRY_ENDTRACENUMBER, rs.getString(ENTRY_ENDTRACENUMBER.toUpperCase()));
            this.putToHashtable(ht, ENTRY_PARTNUMBER, rs.getString(ENTRY_PARTNUMBER.toUpperCase()));
            this.putToHashtable(ht, ENTRY_ASSEMBLESEQ, rs.getString(ENTRY_ASSEMBLESEQ.toUpperCase()));
            this.putToHashtable(ht, ENTRY_ORDERSEQ, rs.getString(ENTRY_ORDERSEQ.toUpperCase()));
            this.putToHashtable(ht, ENTRY_ISMUSTREQ, rs.getString(ENTRY_ISMUSTREQ.toUpperCase()));
            if (rs.getString(ENTRY_ISSUEMODE.toUpperCase()) != null && rs.getString(ENTRY_ISSUEMODE.toUpperCase()).trim().length() > 0) {
                this.putToHashtable(ht, ENTRY_ISSUEMODE, MaterialIssueModeEnum.getEnum((int)rs.getInt(ENTRY_ISSUEMODE.toUpperCase())).getAlias());
            } else {
                this.putToHashtable(ht, ENTRY_ISSUEMODE, rs.getString(ENTRY_ISSUEMODE.toUpperCase()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return ht;
    }

    public CodingRuleInfo getCodingRuleInfo(Context ctx, StorageOrgUnitInfo orgUnitInfo) throws TaskExternalException {
        CodingRuleInfo ruleInfo = null;
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new PBOMInfo(), orgUnitInfo.getId().toString());
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return ruleInfo;
    }

    public String getMainField() {
        return COL_TEMPLATEENTRIES_NUMBER;
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isEmpty(DataToken dt) {
        return dt != null && dt.data != null && dt.data instanceof String && dt.data.toString().trim().equals("");
    }

    public void putToHashtable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        DataToken obj;
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        PBOMInfo baseInfo = null;
        this.bomInfo = new BomInfo();
        this.standardRootingInfo = new StandardRootingInfo();
        this.storageOrg = new StorageOrgUnitInfo();
        this.regenerateTemplateEntries(ctx);
        Hashtable headData = (Hashtable)hsData.get(new Integer(0));
        if (mode == 128 && !this.isEmpty(obj = (DataToken)headData.get(PBOM_NUMBER))) {
            String number = obj.data.toString().trim();
            try {
                baseInfo = (PBOMInfo)PBOMFactory.getLocalInstance((Context)ctx).getValue("select *,routing.materialRooting.number where number = '" + number + "'");
                this.standardRootingInfo = baseInfo.getRouting();
                this.storageOrg = baseInfo.getStorageOrgUnit();
                this.bomInfo = baseInfo.getBom();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (baseInfo == null) {
            baseInfo = new PBOMInfo();
        }
        this.dealHeadField(ctx, baseInfo, headData);
        this.dealEntryField(ctx, baseInfo, hsData);
        return baseInfo;
    }

    private void checkExitsByStorageAndStanderRountAndBom(Context ctx, String storageId, String standerRountId, String BomId, String projectId, String trackName, String standerRountNumber, String bomNumber, String projectNumber, String trackNumber) throws TaskExternalException {
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from t_mm_pbom  where fstorageOrgUnitId = '").append(storageId).append("' and froutingid = '");
        sb.append(standerRountId).append("' and fbomid = '").append(BomId).append("' ");
        if (projectId != null) {
            sb.append(" and fprojectid = '").append(projectId).append("'");
        }
        if (trackName != null) {
            sb.append(" and ftrackNumberid = '").append(trackName).append("'");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rowSet.next()) {
                throw new BomException(BomException.HASSAMEPBOM, (Object[])new String[]{standerRountNumber, bomNumber, projectNumber, trackNumber});
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private CoreBaseInfo checkField(Context ctx, DataToken obj, String filedName, int maxLength, IObjectBase dataBase, CoreBaseInfo baseInfo, String sql) throws TaskExternalException {
        filedName = obj.desc;
        this.verify(obj, filedName, maxLength, ctx);
        String number = obj.data.toString();
        try {
            baseInfo = dataBase.getValue(sql + " and number = '" + number + "'");
        }
        catch (Exception e) {
            throw new TaskExternalException(this.getPBomResource("res_70", new String[]{number, filedName}));
        }
        return baseInfo;
    }

    private void checkNumber(Context ctx, String number, String name) throws TaskExternalException {
        this.verifyStringLength(ctx, number, 80, name);
        String sql = "select fid from t_mm_pbom  where fnumber = '" + number + "'";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                throw new TaskExternalException(this.getResource("res_79", new String[]{number}));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private void dealEntryField(Context ctx, PBOMInfo baseInfo, Hashtable headData) throws TaskExternalException {
        Hashtable rowHashTable = null;
        DataToken obj = null;
        String fiiedName = null;
        String materialSql = " select id where status = '1' ";
        String wpSeq = null;
        MaterialInfo material = null;
        StringBuffer sbBuffer = new StringBuffer();
        BomEntryInfo bomEntryInfo = new BomEntryInfo();
        BomInfo bomInfo = new BomInfo();
        PBOMEntryCollection collect = new PBOMEntryCollection();
        PBOMEntryInfo pBomEntryInfo = null;
        MRWorkProcesEntryInfo workEntryInfo = null;
        String materialRootingId = this.standardRootingInfo.getMaterialRooting().getId().toString();
        Hashtable htEntries = new Hashtable();
        Hashtable<String, BigDecimal> htRow = null;
        String materialNumber = null;
        ArrayList alMR = new ArrayList();
        String bomEntryID = null;
        String materialID = null;
        String parentBOMID = null;
        try {
            for (int i = 0; i < headData.size(); ++i) {
                IRowSet rs = null;
                rowHashTable = (Hashtable)headData.get(new Integer(i));
                obj = (DataToken)rowHashTable.get(ENTRY_MATERIAL_NUMBER);
                if (this.IMaterial == null) {
                    this.IMaterial = MaterialFactory.getLocalInstance((Context)ctx);
                }
                material = (MaterialInfo)this.checkField(ctx, obj, fiiedName, 80, (IObjectBase)this.IMaterial, (CoreBaseInfo)material, " select id where status = '1' ");
                materialNumber = obj.data.toString();
                if (this.IBomEntry == null) {
                    this.IBomEntry = BomEntryFactory.getLocalInstance((Context)ctx);
                }
                if (this.boms.containsKey(this.bomInfo.getId().toString()) && this.boms.get(this.bomInfo.getId().toString()) != null) {
                    rs = (IRowSet)this.boms.get(this.bomInfo.getId().toString());
                } else {
                    rs = StandardRootingTreeFacadeFactory.getLocalInstance(ctx).omaExpandBOMNonST(this.bomInfo.getId().toString(), null);
                    this.boms.put(this.bomInfo.getId().toString(), rs.createCopy());
                }
                bomEntryInfo = null;
                if (rs != null && rs.size() > 0) {
                    rs.beforeFirst();
                    while (rs.next()) {
                        parentBOMID = rs.getString("FBOMID");
                        bomEntryID = rs.getString("FBOMEntryID");
                        materialID = rs.getString("FMaterialID");
                        if (bomEntryID == null || bomEntryID.trim().length() == 0 || materialID == null || materialID.trim().length() == 0) continue;
                        if (materialID.equals(material.getId().toString())) {
                            bomEntryInfo = this.IBomEntry.getBomEntryInfo((IObjectPK)new ObjectUuidPK(bomEntryID));
                            bomInfo = new BomInfo();
                            bomInfo.setId(BOSUuid.read((String)parentBOMID));
                            break;
                        }
                        bomEntryID = null;
                    }
                } else {
                    throw new TaskExternalException(this.getPBomResource("no_entryMaterial_Bom", new String[]{this.bomInfo.getNumber(), obj.data.toString()}));
                }
                if (bomEntryID == null || bomEntryInfo == null) {
                    throw new TaskExternalException(this.getPBomResource("no_entryMaterial_Bom", new String[]{this.bomInfo.getNumber(), obj.data.toString()}));
                }
                pBomEntryInfo = new PBOMEntryInfo();
                pBomEntryInfo.setBomItem(bomEntryInfo);
                pBomEntryInfo.put("material", (Object)material);
                pBomEntryInfo.put("bom", (Object)bomInfo);
                obj = (DataToken)rowHashTable.get(ROUTINGITEM_WPSEQ);
                this.verify(obj, fiiedName, 80, ctx);
                wpSeq = obj.data.toString();
                sbBuffer.setLength(0);
                sbBuffer.append("select id  where parent.id = '").append(materialRootingId).append("' ");
                sbBuffer.append(" and wpSeq = '").append(wpSeq).append("'");
                if (this.IWorkEntry == null) {
                    this.IWorkEntry = MRWorkProcesEntryFactory.getLocalInstance((Context)ctx);
                }
                try {
                    workEntryInfo = (MRWorkProcesEntryInfo)this.IWorkEntry.getValue(sbBuffer.toString());
                }
                catch (Exception e) {
                    throw new TaskExternalException(this.getPBomResource("wpseq_Bom", new String[]{this.standardRootingInfo.getNumber(), obj.data.toString()}));
                }
                htRow = new Hashtable<String, BigDecimal>();
                obj = (DataToken)rowHashTable.get(ENTRY_CONSUMEQUOTA);
                if (!this.isEmpty(obj)) {
                    this.verifyNumber(obj);
                    pBomEntryInfo.setBigDecimal("consumeQuota", new BigDecimal(obj.data.toString()));
                    if (htEntries.size() == 0) {
                        htRow.put(ENTRY_CONSUMEQUOTA, new BigDecimal(obj.data.toString().trim()));
                    } else if (htEntries.containsKey(materialNumber)) {
                        if (((Hashtable)htEntries.get(materialNumber)).containsKey(ENTRY_CONSUMEQUOTA)) {
                            ((Hashtable)htEntries.get(materialNumber)).put(ENTRY_CONSUMEQUOTA, ((BigDecimal)((Hashtable)htEntries.get(materialNumber)).get(ENTRY_CONSUMEQUOTA)).add(new BigDecimal(obj.data.toString().trim())));
                        } else {
                            ((Hashtable)htEntries.get(materialNumber)).put(ENTRY_CONSUMEQUOTA, new BigDecimal(obj.data.toString().trim()));
                        }
                    } else {
                        htRow.put(ENTRY_CONSUMEQUOTA, new BigDecimal(obj.data.toString().trim()));
                    }
                }
                if (!this.isEmpty(obj = (DataToken)rowHashTable.get(ENTRY_CONSUMERATE))) {
                    this.verifyNumber(obj);
                    pBomEntryInfo.setBigDecimal("consumeRate", new BigDecimal(obj.data.toString()));
                    if (htEntries.size() == 0) {
                        htRow.put(ENTRY_CONSUMERATE, new BigDecimal(obj.data.toString().trim()));
                    } else if (htEntries.containsKey(materialNumber)) {
                        if (((Hashtable)htEntries.get(materialNumber)).containsKey(ENTRY_CONSUMERATE)) {
                            ((Hashtable)htEntries.get(materialNumber)).put(ENTRY_CONSUMERATE, ((BigDecimal)((Hashtable)htEntries.get(materialNumber)).get(ENTRY_CONSUMERATE)).add(new BigDecimal(obj.data.toString().trim())));
                        } else {
                            ((Hashtable)htEntries.get(materialNumber)).put(ENTRY_CONSUMERATE, new BigDecimal(obj.data.toString().trim()));
                        }
                    } else {
                        htRow.put(ENTRY_CONSUMERATE, new BigDecimal(obj.data.toString().trim()));
                    }
                }
                obj = (DataToken)rowHashTable.get(ENTRY_STARTTRACENUMBER);
                this.verifyEmpty(obj);
                this.verifyDataLength(ctx, obj);
                TrackNumberInfo sTraceInfo = (TrackNumberInfo)this.verifyExists(ctx, obj, (IObjectBase)TrackNumberFactory.getLocalInstance((Context)ctx));
                pBomEntryInfo.put("sTrace", (Object)sTraceInfo);
                obj = (DataToken)rowHashTable.get(ENTRY_ENDTRACENUMBER);
                this.verifyEmpty(obj);
                this.verifyDataLength(ctx, obj);
                TrackNumberInfo eTraceInfo = (TrackNumberInfo)this.verifyExists(ctx, obj, (IObjectBase)TrackNumberFactory.getLocalInstance((Context)ctx));
                if (sTraceInfo.getNumber() != null && eTraceInfo.getNumber() != null && sTraceInfo.getNumber().compareTo(eTraceInfo.getNumber()) > 0) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.basedata.BasedataResource.Msg_OMA_PBOM_StartTrace_Greater_Than_EndTrace"));
                }
                pBomEntryInfo.put("eTrace", (Object)eTraceInfo);
                obj = (DataToken)rowHashTable.get(ENTRY_PARTNUMBER);
                if (!this.isEmpty(obj)) {
                    this.verifyDataLength(ctx, obj);
                    pBomEntryInfo.put("partNumber", (Object)obj.toString());
                }
                if (!this.isEmpty(obj = (DataToken)rowHashTable.get(ENTRY_ASSEMBLESEQ))) {
                    this.verifyNumber(obj);
                    pBomEntryInfo.put("assembleSeq", (Object)obj.toString());
                }
                if (!this.isEmpty(obj = (DataToken)rowHashTable.get(ENTRY_ORDERSEQ))) {
                    this.verifyNumber(obj);
                    pBomEntryInfo.put("orderSeq", (Object)obj.toString());
                }
                if (!this.isEmpty(obj = (DataToken)rowHashTable.get(ENTRY_ISMUSTREQ))) {
                    pBomEntryInfo.put("isMustReq", (Object)Boolean.valueOf(obj.toString()));
                }
                obj = (DataToken)rowHashTable.get(ENTRY_ISSUEMODE);
                this.verifyEmpty(obj);
                if (obj.toString().equals(MaterialIssueModeEnum.PRODUCEISSMODE.getAlias())) {
                    pBomEntryInfo.put("issueMode", (Object)MaterialIssueModeEnum.PRODUCEISSMODE);
                } else if (obj.toString().equals(MaterialIssueModeEnum.KANBANISSMODE.getAlias())) {
                    pBomEntryInfo.put("issueMode", (Object)MaterialIssueModeEnum.KANBANISSMODE);
                } else if (obj.toString().equals(MaterialIssueModeEnum.NOTISSMODE.getAlias())) {
                    pBomEntryInfo.put("issueMode", (Object)MaterialIssueModeEnum.NOTISSMODE);
                } else if (obj.toString().equals(MaterialIssueModeEnum.STRAIGHT.getAlias())) {
                    pBomEntryInfo.put("issueMode", (Object)MaterialIssueModeEnum.STRAIGHT);
                } else {
                    throw new TaskExternalException(this.getEMMIMMResource("DATA_NULL", new String[]{this.getColumnDescription(obj)}));
                }
                if (materialNumber != null && materialNumber.trim().length() > 0) {
                    if (htEntries.size() == 0) {
                        htEntries.put(materialNumber, htRow);
                    } else if (!htEntries.containsKey(materialNumber)) {
                        htEntries.put(materialNumber, htRow);
                    }
                }
                pBomEntryInfo.setRoutingItem(workEntryInfo);
                collect.add(pBomEntryInfo);
            }
        }
        catch (Exception e) {
            if (e instanceof TaskExternalException) {
                throw (TaskExternalException)e;
            }
            throw new TaskExternalException(this.getResource("res_96") + e.getMessage());
        }
        baseInfo.getPbomEntry().addCollection(collect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dealHeadField(Context ctx, PBOMInfo baseInfo, Hashtable headData) throws TaskExternalException {
        DataToken obj = (DataToken)headData.get(STORAGE_NUMBER);
        StringBuffer sb = new StringBuffer();
        if (this.isEmpty(obj)) {
            throw new TaskExternalException(this.getResource("res_70", new String[]{obj.desc}));
        }
        try {
            String storageOrgUnitNumber = obj.data.toString().trim();
            String filedName = null;
            sb.append(" select id  where status = '0' ");
            if (this.IStorageOrgUnit == null) {
                this.IStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            }
            this.storageOrg = (StorageOrgUnitInfo)this.checkField(ctx, obj, filedName, 80, (IObjectBase)this.IStorageOrgUnit, (CoreBaseInfo)this.storageOrg, sb.toString());
            this.storageOrg.setNumber(obj.toString().trim());
            if (this.storageOrg == null) {
                throw new TaskExternalException(this.getResource("res_77", new String[]{storageOrgUnitNumber}));
            }
            baseInfo.setStorageOrgUnit(this.storageOrg);
            String number = null;
            obj = (DataToken)headData.get(PBOM_NUMBER);
            if (this.isEmpty(obj)) {
                CodingRuleInfo ruleInfo = this.getCodingRuleInfo(ctx, this.storageOrg);
                if (ruleInfo == null) throw new TaskExternalException(this.getResource("res_70", new String[]{obj.desc}));
                number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)baseInfo, ruleInfo);
            } else {
                number = obj.data.toString().trim();
                filedName = obj.desc.toString();
                if (baseInfo.getId() == null) {
                    this.checkNumber(ctx, number, filedName);
                }
            }
            baseInfo.setNumber(number);
            obj = (DataToken)headData.get(PBOM_NAME);
            this.verify(obj, filedName, 255, ctx);
            String name = obj.data.toString().trim();
            baseInfo.setName(name);
            obj = (DataToken)headData.get(ROUTING_NUMBER);
            if (this.standardRooting == null) {
                this.standardRooting = StandardRootingFactory.getLocalInstance((Context)ctx);
            }
            sb.setLength(0);
            String storageSql = " and  storageOrgUnit.id = '" + this.storageOrg.getId().toString() + "'";
            sb.append(" select id ,material.id , materialRooting.id ");
            sb.append(" Where   status <> '30'  ");
            sb.append(storageSql);
            this.standardRootingInfo = (StandardRootingInfo)this.checkField(ctx, obj, filedName, 80, (IObjectBase)this.standardRooting, (CoreBaseInfo)this.standardRootingInfo, sb.toString());
            this.standardRootingInfo.setNumber(obj.data.toString().trim());
            baseInfo.setRouting(this.standardRootingInfo);
            obj = (DataToken)headData.get(BOM_NUMBER);
            if (this.IBom == null) {
                this.IBom = BomFactory.getLocalInstance((Context)ctx);
            }
            sb.setLength(0);
            sb.append(" Select id ,material.id,bomType,project.id ");
            sb.append(" Where  bomtype in ('40','45','50') and basestatus = '4' and  usageType = '10'   ");
            sb.append(storageSql);
            this.bomInfo = (BomInfo)this.checkField(ctx, obj, filedName, 80, (IObjectBase)this.IBom, (CoreBaseInfo)this.bomInfo, sb.toString());
            this.bomInfo.setNumber(obj.data.toString().trim());
            baseInfo.setBom(this.bomInfo);
            if (!this.standardRootingInfo.getMaterial().getId().toString().equals(this.bomInfo.getMaterial().getId().toString())) {
                throw new TaskExternalException(this.getPBomResource("material_rount_bom", new String[]{this.standardRootingInfo.getNumber(), this.bomInfo.getNumber()}));
            }
            if (this.bomInfo.getBomType().getValue() == 45) {
                obj = (DataToken)headData.get(TRACK_NUMBER);
                String trackNumberId = null;
                String trackNumber = null;
                if (this.isEmpty(obj)) {
                    sb.setLength(0);
                    sb.append("select distinct fprojectId from T_MM_OrderBOMPT where forderId = '").append(this.bomInfo.getId().toString()).append("'");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                    ProjectInfo projectInfo = new ProjectInfo();
                    if (rs.next()) {
                        projectInfo.setId(BOSUuid.read((String)rs.getString("fprojectId")));
                    }
                    baseInfo.setProject(projectInfo);
                } else {
                    if (this.ITrackNumber == null) {
                        this.ITrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
                    }
                    TrackNumberInfo trackNumberInfo = null;
                    sb.setLength(0);
                    sb.append(" Select id ,number");
                    sb.append(" Where  status = '10'   ");
                    trackNumberInfo = (TrackNumberInfo)this.checkField(ctx, obj, filedName, 80, (IObjectBase)this.ITrackNumber, (CoreBaseInfo)trackNumberInfo, sb.toString());
                    trackNumberId = trackNumberInfo.getId().toString();
                    trackNumber = trackNumberInfo.getNumber();
                    if (this.IOrderBOMPT == null) {
                        this.IOrderBOMPT = OrderBOMPTFactory.getLocalInstance((Context)ctx);
                    }
                    OrderBOMPTInfo orderBomPTInfo = new OrderBOMPTInfo();
                    sb.setLength(0);
                    sb.append("select projectId ").append(" where trackId = '").append(trackNumberInfo.getId().toString()).append("' ");
                    sb.append(" and orderId.Id = '").append(this.bomInfo.getId().toString()).append("'");
                    try {
                        orderBomPTInfo = (OrderBOMPTInfo)this.IOrderBOMPT.getValue(sb.toString());
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(this.getPBomResource("noTrackNumber_OrderBom", new String[]{this.bomInfo.getNumber(), obj.data.toString()}));
                    }
                    ProjectInfo projectInfo = new ProjectInfo();
                    projectInfo.setId(BOSUuid.read((String)orderBomPTInfo.getProjectId()));
                    baseInfo.setProject(projectInfo);
                    baseInfo.setTrackNumber(trackNumberInfo);
                }
                if (baseInfo.getProject() == null || baseInfo.getProject().getId() == null) {
                    throw new TaskExternalException(this.getPBomResource("OBTAIN_PROJECT_FAILED", new String[]{this.bomInfo.getNumber()}));
                }
                if (baseInfo.getTrackNumber() == null || baseInfo.getTrackNumber().getId() == null) {
                    throw new TaskExternalException(this.getPBomResource("OBTAIN_TRACKNUMBER_FAILED", new String[]{this.bomInfo.getNumber()}));
                }
                ProjectInfo pbomProject = null;
                if (this.IProject == null) {
                    this.IProject = ProjectFactory.getLocalInstance((Context)ctx);
                }
                pbomProject = (ProjectInfo)this.IProject.getValue((IObjectPK)new ObjectUuidPK(baseInfo.getProject().getId()));
                this.checkExitsByStorageAndStanderRountAndBom(ctx, this.storageOrg.getId().toString(), this.standardRootingInfo.getId().toString(), this.bomInfo.getId().toString(), baseInfo.getProject().getId().toString(), trackNumberId, this.standardRootingInfo.getNumber(), this.bomInfo.getNumber(), pbomProject.getNumber(), trackNumber);
            }
            baseInfo.setProject(this.bomInfo.getProject());
            StringBuffer description = new StringBuffer();
            description.append("\u5916\u90e8\u5bfc\u5165 ");
            description.append(ctx.getClientHostIP() == null ? "" : ctx.getClientHostIP());
            baseInfo.setDescription(description.toString());
            return;
        }
        catch (Exception e) {
            if (!(e instanceof TaskExternalException)) throw new TaskExternalException(this.getResource("res_96") + e.getMessage());
            throw (TaskExternalException)e;
        }
    }

    private String getPBomResource(String key, String[] params) {
        return ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.basedata.PBOMIndustryResource", (String)key, (String[])params);
    }

    private String getResource(String key) {
        return ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.basedata.BOMDataTransferResource", (String)key);
    }

    private String getResource(String key, String[] params) {
        return ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.basedata.BOMDataTransferResource", (String)key, (String[])params);
    }

    private boolean verify(DataToken dt, String filedName, int maxLength, Context ctx) throws TaskExternalException {
        if (this.isEmpty(dt)) {
            throw new TaskExternalException(this.getResource("res_70", new String[]{dt.desc}));
        }
        this.verifyStringLength(ctx, dt.data.toString().trim(), maxLength, filedName);
        return true;
    }

    protected CoreBaseInfo verifyExists(Context ctx, DataToken obj, IObjectBase iObjectBase) throws TaskExternalException, BOSException, EASBizException {
        if (this.isEmpty(obj)) {
            return null;
        }
        CoreBaseInfo info = null;
        String sql = "Select ID,FNumber Where Number='" + obj.data.toString().trim() + "'";
        try {
            info = iObjectBase.getValue(sql);
        }
        catch (Exception e) {
            throw new TaskExternalException(this.getEMMIMMResource("DATA_NOT_EXISTS", new String[]{this.getColumnDescription(obj), obj.data.toString()}));
        }
        return info;
    }

    protected void verifyDataLength(Context ctx, DataToken obj) throws BOSException, TaskExternalException {
        if (this.isEmpty(obj)) {
            return;
        }
        String table = null;
        String column = null;
        int length = 0;
        int maxlength = 0;
        if (ENTRY_STARTTRACENUMBER.toLowerCase().equals(obj.name.toLowerCase()) || ENTRY_ENDTRACENUMBER.toLowerCase().equals(obj.name.toLowerCase())) {
            table = "T_MM_TrackNumber";
            column = "FNumber";
        } else if (ENTRY_PARTNUMBER.toLowerCase().equals(obj.name.toLowerCase())) {
            table = "T_MM_PBOMEntry";
            column = "CFPartNumber";
        }
        length = obj.data.toString().trim().length();
        maxlength = this.getTableColumnLength(ctx, table, column);
        if (length > maxlength || maxlength == 0) {
            throw new TaskExternalException(this.getEMMIMMResource("DATA_OVER_LENGTH", new String[]{this.getColumnDescription(obj), String.valueOf(maxlength)}));
        }
    }

    protected int getTableColumnLength(Context ctx, String table, String column) throws BOSException {
        if (table == null || table.trim().length() == 0 || column == null || column.trim().length() == 0) {
            return 0;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Select\r\n");
        sql.append("Data_Type \"Type\",\r\n");
        sql.append("Data_Length \"Width\"\r\n");
        sql.append("From KSQL_UserColumns\r\n");
        sql.append("Where\r\n");
        sql.append("Lower(KSQL_COL_Name)='").append(column.toLowerCase()).append("'\r\n");
        sql.append("And Lower(KSQL_COL_TABName)='").append(table.toLowerCase()).append("'\r\n");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (result == null || result.size() == 0) {
            return 0;
        }
        int length = 0;
        try {
            result.next();
            if (result.getString("Width") != null) {
                length = result.getInt("Width");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return length;
    }

    protected void verifyEmpty(DataToken obj) throws TaskExternalException, BOSException {
        if (this.isEmpty(obj)) {
            throw new TaskExternalException(this.getEMMIMMResource("DATA_NULL", new String[]{this.getColumnDescription(obj)}));
        }
    }

    protected String getEMMIMMResource(String key, String[] params) {
        String res = EASResource.getString((String)"com.kingdee.eas.industry.emm.imm.IMMResource", (String)key);
        if (res == null || res.trim().length() == 0) {
            return null;
        }
        for (int number = 0; number < params.length; ++number) {
            res = res.replace("{" + number + "}", params[number]);
        }
        return res;
    }

    private boolean verifyStringLength(Context ctx, String number, int length, String name) throws TaskExternalException {
        if (MMUtils.isNotEmptyString((String)number) && number.length() > length) {
            throw new TaskExternalException(this.getResource("FieldLengthIsLarge", new String[]{name, String.valueOf(length)}));
        }
        return true;
    }

    protected void compareEntriesBOMItem(Context ctx, Hashtable<String, Hashtable<String, BigDecimal>> htEntries) throws BOSException, SQLException, TaskExternalException {
        if (this.bomInfo.getNumber() == null || this.bomInfo.getNumber().trim().length() == 0) {
            return;
        }
        if (htEntries == null || htEntries.size() == 0) {
            return;
        }
        IRowSet rs = null;
        if (this.boms.containsKey(this.bomInfo.getId().toString()) && this.boms.get(this.bomInfo.getId().toString()) != null) {
            rs = (IRowSet)this.boms.get(this.bomInfo.getId().toString());
        } else {
            try {
                rs = StandardRootingTreeFacadeFactory.getLocalInstance(ctx).omaExpandBOM(this.bomInfo.getId().toString(), null);
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage());
            }
            this.boms.put(this.bomInfo.getId().toString(), rs);
        }
        String materialNumber = null;
        String materialName = null;
        BigDecimal consumeQuota = null;
        BigDecimal consumeRate = null;
        rs.beforeFirst();
        rs.next();
        do {
            materialNumber = rs.getString("FMaterialNumber");
            materialName = rs.getString("FMaterialName");
            consumeQuota = rs.getBigDecimal("FConsumeQty");
            if (materialNumber == null || materialNumber.trim().length() == 0) continue;
            if (materialName == null) {
                materialName = "";
            }
            if (consumeQuota == null) {
                consumeQuota = new BigDecimal("0");
            }
            if (consumeRate == null) {
                consumeRate = new BigDecimal("0");
            }
            if (!htEntries.containsKey(materialNumber)) continue;
            if (htEntries.get(materialNumber).containsKey(ENTRY_CONSUMEQUOTA)) {
                if (htEntries.get(materialNumber).get(ENTRY_CONSUMEQUOTA).compareTo(consumeQuota) != 0) {
                    throw new TaskExternalException(this.getPBomResource("CONSUMEQUOTA_NOT_EQUAL_BOM", new String[]{materialNumber, materialName, htEntries.get(materialNumber).get(ENTRY_CONSUMEQUOTA).toString(), consumeQuota.toString()}));
                }
            } else if (new BigDecimal("0").compareTo(consumeQuota) != 0) {
                throw new TaskExternalException(this.getPBomResource("CONSUMEQUOTA_NOT_EQUAL_BOM", new String[]{materialNumber, materialName, "0", consumeQuota.toString()}));
            }
            if (htEntries.get(materialNumber).containsKey(ENTRY_CONSUMERATE)) {
                if (htEntries.get(materialNumber).get(ENTRY_CONSUMERATE).compareTo(consumeRate) == 0) continue;
                throw new TaskExternalException(this.getPBomResource("CONSUMERATE_NOT_EQUAL_BOM", new String[]{materialNumber, materialName, htEntries.get(materialNumber).get(ENTRY_CONSUMERATE).toString(), consumeRate.toString()}));
            }
            if (new BigDecimal("0").compareTo(consumeRate) == 0) continue;
            throw new TaskExternalException(this.getPBomResource("CONSUMERATE_NOT_EQUAL_BOM", new String[]{materialNumber, materialName, "0", consumeRate.toString()}));
        } while (rs.next());
    }

    protected String getColumnDescription(DataToken obj) throws BOSException {
        String description;
        block6: {
            if (obj == null) {
                return "";
            }
            if (obj.name == null || obj.name.trim().length() == 0) {
                return "";
            }
            description = "";
            try {
                if (this.templateEntries == null || !this.templateEntries.first()) break block6;
                do {
                    if (this.templateEntries.getString(COL_TEMPLATEENTRIES_NUMBER) == null || this.templateEntries.getString(COL_TEMPLATEENTRIES_NUMBER).trim().length() == 0 || !obj.name.trim().toLowerCase().equals(this.templateEntries.getString(COL_TEMPLATEENTRIES_NUMBER).trim().toLowerCase())) continue;
                    description = this.templateEntries.getString(COL_TEMPLATEENTRIES_NAME).trim();
                    if (description == null) {
                        description = "";
                    }
                    break;
                } while (this.templateEntries.next());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return description;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PBOMFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected void regenerateTemplateEntries(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append("select\r\n");
        sql.append("e.fseq seq,\r\n");
        sql.append("e.fnumber number,\r\n");
        sql.append("e.fname_l2 name\r\n");
        sql.append("from t_die_templatefieldentry e\r\n");
        sql.append("inner join t_die_template h on e.fparentid=h.fid\r\n");
        sql.append("where\r\n");
        sql.append("h.fnumber='PBOMTemplate'\r\n");
        try {
            this.templateEntries = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected void verifyNumber(DataToken obj) throws TaskExternalException, BOSException {
        if (this.isEmpty(obj)) {
            return;
        }
        try {
            new BigDecimal(obj.data.toString());
        }
        catch (Exception e) {
            throw new TaskExternalException(this.getPBomResource("DATA_NUMBER_INVALID", new String[]{this.getColumnDescription(obj), obj.data.toString()}));
        }
    }
}

