/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.industry.emm.basedata.scm.sm.pur.DeliveryPlanTransactionTypeInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.SupplyRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.scm.sm.AnalyseDeliveryPlanByStockFactory;
import com.kingdee.eas.industry.emm.scm.sm.AnalyseDeliveryPlanByStockInfo;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleBillInfo;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleCBBillInfo;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleCbFactory;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleCbInfo;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleCollection;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleFactory;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleInfo;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryPlanDetailFactory;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryPlanDetailInfo;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryPlanFBFacadeFactory;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryStatusEnum;
import com.kingdee.eas.industry.emm.scm.sm.purMacthEnum;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.CalculateDeliveryPlanFacadeFactory;
import com.kingdee.eas.mm.mo.CalculateResultScopeVO;
import com.kingdee.eas.mm.mo.DeliveryPlanSingletonFactory;
import com.kingdee.eas.mm.mo.KeyValueForDate;
import com.kingdee.eas.mm.mo.app.AbstractCalculateDeliveryPlanFacadeControllerBean;
import com.kingdee.eas.mm.mo.app.AbstractCalculateResultScope;
import com.kingdee.eas.mm.mo.app.AbstractMatchHandler;
import com.kingdee.eas.mm.mo.app.DeliveryPlanInventoryMatchHandler;
import com.kingdee.eas.mm.mo.app.DeliveryPlanMatchHandler;
import com.kingdee.eas.mm.mo.app.DeliveryPlanPurOrderMatchHandler;
import com.kingdee.eas.mm.mo.app.TrackNumberSingleCache;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CalculateDeliveryPlanFacadeControllerBean
extends AbstractCalculateDeliveryPlanFacadeControllerBean {
    private static final long serialVersionUID = 7155591380554257418L;
    private Map<String, BigDecimal> inventoryMap = new HashMap<String, BigDecimal>();
    static final String str_log = " select 1 , '\u7f16\u5236\u5f00\u59cb' ,'\u5f00\u59cb\u7f16\u5236,\u6570\u636e\u51c6\u5907', 0 ,'\u672a\u5f00\u59cb', 0 ,'1', 0  FROM dual  UNION ALL   select 2 , '\u83b7\u53d6\u4ea4\u8d27\u8ba1\u5212\u9700\u6c42' ,'\u83b7\u53d6\u4ea4\u8d27\u8ba1\u5212\u9700\u6c42', 0 ,'\u672a\u5f00\u59cb', 0 ,'1',0 FROM dual  UNION ALL   select 3 , '\u5339\u914d\u5e93\u5b58\u3001\u91c7\u8d2d\u8ba2\u5355' ,'\u5339\u914d\u5e93\u5b58\u3001\u91c7\u8d2d\u8ba2\u5355', 0 ,'\u672a\u5f00\u59cb', 0 ,'1', 0 FROM dual  UNION ALL  select 4 , '\u751f\u6210\u4ea4\u8d27\u8ba1\u5212','\u751f\u6210\u4ea4\u8d27\u8ba1\u5212', 0 ,'\u672a\u5f00\u59cb', 0 ,'1', 0 FROM dual  UNION ALL   select 5 , '\u5408\u5e76\u4ea4\u8d27\u8ba1\u5212\u751f\u6210\u60c5\u51b5\u8868','\u5408\u5e76\u4ea4\u8d27\u8ba1\u5212\u751f\u6210\u60c5\u51b5\u8868,\u5237\u65b0\u4ea4\u8d27\u8ba1\u5212\u53cd\u9988', 0 ,'\u672a\u5f00\u59cb', 0 ,'1', 0 FROM dual  UNION ALL  select 6 , '\u751f\u6210\u4ea4\u8d27\u8ba1\u5212\u65e5\u5fd7\u8868' ,'\u751f\u6210\u4ea4\u8d27\u8ba1\u5212\u65e5\u5fd7\u8868', 0 ,'\u672a\u5f00\u59cb', 0 ,'1', 0 FROM dual   UNION ALL  select 7 , '\u7f16\u5236\u5b8c\u6210' ,'\u7f16\u5236\u5b8c\u6210', 0 ,'\u672a\u5f00\u59cb', 0 ,'1', 0 FROM dual ";

    @Override
    protected String _exec(Context ctx, Date startDate, Date endDate, ArrayList ids) throws BOSException, EASBizException {
        String retValue = null;
        String storageUnitId = ContextUtil.getCurrentStorageUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentStorageUnit((Context)ctx).getId().toString();
        String[] params = new String[]{"MergeMaterialReqDate"};
        HashMap paramMap = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(params, storageUnitId);
        if (paramMap.containsKey("MergeMaterialReqDate") && paramMap.get("MergeMaterialReqDate") != null) {
            retValue = paramMap.get("MergeMaterialReqDate").toString();
        }
        String sql = null;
        sql = Boolean.parseBoolean(retValue) ? "  SELECT * FROM (SELECT D.*,E.CFISZJ,E.CFSTATUS FROM (SELECT PROJECTID,TRACKID,ORGID,PORGID,MATERIALID,DEMANDTIME,DEMANDTIME+DAYS TQDAY,QTY FROM  (SELECT A.FProjectid PROJECTID, A.FTrackId TRACKID, B.FSTORAGEORGUNITID ORGID, B.FMaterialid MATERIALID, a.fstorageorgunitid PORGID, case when c.cfarrivedays is null then 0 else c.cfarrivedays*-1 end DAYS,  SUM(B.FPlannedQty-B.FActIssueQty) QTY, MIN(B.FDEMANDTIME) DEMANDTIME  FROM T_MM_ManufactureOrder A  left join T_MM_MFTOrderStock B ON A.FID = B.FPARENTID  left join CT_PUR_SetPMADE C ON A.FSTORAGEORGUNITID = c.cfproductorgid  WHERE A.FPROJECTID IS NOT NULL  AND A.FTrackId IS NOT NULL  AND A.FBASESTATUS in (4,5,8)  AND B.FMaterialid IS NOT NULL  and B.FDEMANDTIME between ? and ?  #SUPPLYSTORAGE#  group by B.FMaterialid, B.FSTORAGEORGUNITID, A.FProjectid, A.FTrackId,c.cfarrivedays,a.fstorageorgunitid  order by MATERIALID, orgid, DEMANDTIME)) D LEFT JOIN  CT_DIR_DirectFeedingmMaterial E  on D.PROJECTID = E.cfprojectid and D.TRACKID = E.CFTRACKID AND D.MATERIALID = E.CFMATERIALID) F WHERE (F.cfiszj != 1 OR F.cfiszj IS NULL) AND (F.cfstatus IS null OR F.cfstatus NOT IN('1','2')) AND F.QTY>0" : "  SELECT * FROM (SELECT D.*,E.CFISZJ,E.CFSTATUS FROM (SELECT PROJECTID,TRACKID,ORGID,PORGID,MATERIALID,DEMANDTIME,DEMANDTIME+DAYS TQDAY,QTY FROM  (SELECT A.FProjectid PROJECTID, A.FTrackId TRACKID, B.FSTORAGEORGUNITID ORGID, B.FMaterialid MATERIALID, a.fstorageorgunitid PORGID, case when c.cfarrivedays is null then 0 else c.cfarrivedays*-1 end DAYS,  SUM(B.FPlannedQty-B.FActIssueQty) QTY, MAX(B.FDEMANDTIME) DEMANDTIME  FROM T_MM_ManufactureOrder A  left join T_MM_MFTOrderStock B ON A.FID = B.FPARENTID  left join CT_PUR_SetPMADE C ON A.FSTORAGEORGUNITID = c.cfproductorgid  WHERE A.FPROJECTID IS NOT NULL  AND A.FTrackId IS NOT NULL  AND A.FBASESTATUS in (4,5,8)  AND B.FMaterialid IS NOT NULL  and B.FDEMANDTIME between ? and ?  #SUPPLYSTORAGE#  group by B.FMaterialid, B.FSTORAGEORGUNITID, A.FProjectid, A.FTrackId,c.cfarrivedays,a.fstorageorgunitid  order by MATERIALID, orgid, DEMANDTIME)) D LEFT JOIN  CT_DIR_DirectFeedingmMaterial E  on D.PROJECTID = E.cfprojectid and D.TRACKID = E.CFTRACKID AND D.MATERIALID = E.CFMATERIALID) F WHERE (F.cfiszj != 1 OR F.cfiszj IS NULL) AND (F.cfstatus IS null OR F.cfstatus NOT IN('1','2')) AND F.QTY>0";
        Date[] dates = this.getReviseTime(startDate, endDate);
        if (ids.size() > 0) {
            String idsStr = " and B.FSTORAGEORGUNITID IN (" + SQLUtil.arrayToString((Object[])ids.toArray()) + ")";
            sql = sql.replaceAll("#SUPPLYSTORAGE#", idsStr);
        } else {
            sql = sql.replaceAll("#SUPPLYSTORAGE#", " and 1=1 ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{dates[0], dates[1]});
        DbUtil.execute((Context)ctx, (String)"delete from T_SM_ConsignmentSchedule a where a.fbasestatus = 1");
        try {
            while (rs.next()) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("STARTDATE", dates[0]);
                resultMap.put("ENDDATE", dates[1]);
                this.getResultMakeMap(rs, "PROJECTID", resultMap);
                this.getResultMakeMap(rs, "TRACKID", resultMap);
                this.getResultMakeMap(rs, "ORGID", resultMap);
                this.getResultMakeMap(rs, "PORGID", resultMap);
                this.getResultMakeMap(rs, "MATERIALID", resultMap);
                if (resultMap.get("ORGID") == null) continue;
                this.getResultMakeMap(rs, "DEMANDTIME", resultMap);
                this.getResultMakeMap(rs, "QTY", resultMap);
                this.getResultMakeMap(rs, "TQDAY", resultMap);
                this.calculteDeliveryPlan(ctx, resultMap);
                this.recordAnalyseDeliveryPlan(ctx, resultMap);
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return null;
    }

    private Date[] getReviseTime(Date startDate, Date endDate) throws BOSException, EASBizException {
        Date[] arraysdate = new Date[2];
        try {
            String defaultStartDate;
            SimpleDateFormat _sdf;
            SimpleDateFormat sdf;
            if (startDate != null) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                _sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                defaultStartDate = sdf.format(startDate);
                defaultStartDate = defaultStartDate + " 00:00:00";
                startDate = _sdf.parse(defaultStartDate);
            }
            if (endDate != null) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                _sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                defaultStartDate = sdf.format(endDate);
                defaultStartDate = defaultStartDate + " 23:59:59";
                endDate = _sdf.parse(defaultStartDate);
            }
            arraysdate[0] = new Timestamp(startDate.getTime());
            arraysdate[1] = new Timestamp(endDate.getTime());
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return arraysdate;
    }

    private void recordAnalyseDeliveryPlan(Context ctx, Map<String, Object> resultMap) throws SQLException, BOSException, EASBizException {
        AnalyseDeliveryPlanByStockInfo info = new AnalyseDeliveryPlanByStockInfo();
        MaterialInfo materialinfo = new MaterialInfo();
        String materialid = (String)resultMap.get("MATERIALID");
        if (materialid == null) {
            System.out.print("");
        }
        materialinfo.setId(BOSUuid.read((String)materialid));
        info.setMaterialID(materialinfo);
        TrackNumberInfo trackNum = new TrackNumberInfo();
        trackNum.setId(BOSUuid.read((String)((String)resultMap.get("TRACKID"))));
        info.setTrackNumID(trackNum);
        PurchaseOrgUnitInfo purorgInfo = new PurchaseOrgUnitInfo();
        purorgInfo.setId(BOSUuid.read((String)((String)resultMap.get("PORGID"))));
        info.setPurOrgID(purorgInfo);
        ProjectInfo projectInfo = new ProjectInfo();
        projectInfo.setId(BOSUuid.read((String)((String)resultMap.get("PROJECTID"))));
        info.setProjectID(projectInfo);
        StorageOrgUnitInfo storageinfo = new StorageOrgUnitInfo();
        storageinfo.setId(BOSUuid.read((String)((String)resultMap.get("ORGID"))));
        info.setStorageOrgID(storageinfo);
        info.setSolatedRule((String)resultMap.get("LOG_SOLATEDRULE"));
        info.setReceiveDate((Timestamp)resultMap.get("TQDAY"));
        info.setReqQty((BigDecimal)resultMap.get("QTY"));
        info.setReqDate((Timestamp)resultMap.get("DEMANDTIME"));
        info.setInventory((BigDecimal)resultMap.get("LOG_Inventory"));
        info.setOccupyInventory((BigDecimal)resultMap.get("LOG_OccupyInventory"));
        info.setOccupyOrderQty((BigDecimal)resultMap.get("LOG_OCCURORDERQTY"));
        info.setCalculateStartDate((Timestamp)resultMap.get("STARTDATE"));
        info.setCalculateEndDate((Timestamp)resultMap.get("ENDDATE"));
        List newdeliveryPlan = (List)resultMap.get("LOG_DELIVERYPLAN");
        List newdeliveryPlanCB = (List)resultMap.get("LOG_DELIVERYPLANCB");
        List existdeliveryPlan = (List)resultMap.get("LOG_EXISTDELIVERYPLAN");
        if (newdeliveryPlan == null && existdeliveryPlan == null) {
            return;
        }
        if (newdeliveryPlan != null && newdeliveryPlan.size() == 0 && existdeliveryPlan == null || existdeliveryPlan != null && existdeliveryPlan.size() == 0 && newdeliveryPlan == null) {
            return;
        }
        boolean deliveryPlanPkCount = false;
        if (newdeliveryPlan != null && newdeliveryPlan.size() > 0) {
            info.setDeliveryPlanPks(this.buildArrayList(newdeliveryPlan));
        }
        if (newdeliveryPlanCB != null && newdeliveryPlanCB.size() > 0) {
            info.setDeliveryPlanCBPks(this.buildArrayList(newdeliveryPlanCB));
        }
        if (existdeliveryPlan != null && existdeliveryPlan.size() > 0) {
            info.setExistDeliveryPlanPks(this.buildArrayList(existdeliveryPlan));
        }
        String stockpks = (String)resultMap.get("DETAILSTOCKID");
        info.setStockPks(stockpks);
        String stockqty = (String)resultMap.get("DETAILSTOCKQTY");
        info.setStockqty(stockqty);
        Boolean isrelated = resultMap.get("LOG_NOEXISTORDER") == null ? Boolean.valueOf(false) : (Boolean)resultMap.get("LOG_NOEXISTORDER");
        info.setIsrelated(isrelated.booleanValue());
        AnalyseDeliveryPlanByStockFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
    }

    private String buildArrayList(List<String> list) {
        StringBuffer sbStr = new StringBuffer("'");
        for (int n = 0; n < list.size(); ++n) {
            sbStr.append(list.get(n)).append("','");
        }
        sbStr.append("'");
        return sbStr.toString();
    }

    private void getResultMakeMap(IRowSet rs, String propName, Map<String, Object> map) throws SQLException, BOSException, EASBizException {
        if (rs.getObject(propName) instanceof String) {
            map.put(propName, rs.getString(propName));
        } else if (rs.getObject(propName) instanceof Timestamp) {
            map.put(propName, rs.getTimestamp(propName));
        } else if (rs.getObject(propName) instanceof BigDecimal) {
            map.put(propName, rs.getBigDecimal(propName));
        } else if (rs.getObject(propName) instanceof Date) {
            java.sql.Date date = rs.getDate(propName);
            Timestamp tmp = new Timestamp(date.getTime());
            map.put(propName, tmp);
        } else {
            map.put(propName, rs.getObject(propName));
        }
    }

    private void calculteDeliveryPlan(Context ctx, Map<String, Object> map) throws SQLException, BOSException, EASBizException {
        this.matchInventory(ctx, map);
        this.matchPurOrder(ctx, map);
    }

    private void matchInventory(Context ctx, Map<String, Object> map) throws SQLException, BOSException, EASBizException {
        String materialid = (String)map.get("MATERIALID");
        String projectid = (String)map.get("PROJECTID");
        String trackid = (String)map.get("TRACKID");
        String orgid = (String)map.get("ORGID");
        String porgid = (String)map.get("PORGID");
        BigDecimal qty = (BigDecimal)map.get("QTY");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)" /*dialect*/select case when k.fisprojectnumber||k.fistrackingnumber = '00' then 'NONE'  when k.fisprojectnumber||k.fistrackingnumber = '10' then 'ITEM'  when k.fisprojectnumber||k.fistrackingnumber = '11' then 'ITEM_TRACKNO'  else 'NONE' end fisolatedrule  from t_Bd_Materialinventory k where k.forgunit=? and k.fmaterialid=? ", (Object[])new Object[]{orgid, materialid});
        String solatedRule = "NONE";
        if (rs.next()) {
            solatedRule = rs.getString("FISOLATEDRULE");
        }
        this.getDetailInfo(ctx, orgid, porgid, materialid, projectid, trackid, map);
        this.getInventoryQty(ctx, orgid, solatedRule, materialid, projectid, trackid, qty, map);
    }

    private void getDetailInfo(Context ctx, String orgid, String porgid, String materialid, String projectid, String trackid, Map<String, Object> map) throws SQLException, BOSException, EASBizException {
        String sql = " SELECT B.FID FID,B.FUnIssueQty PLANNEDQTY  FROM T_MM_ManufactureOrder A left join T_MM_MFTOrderStock B ON A.FID = B.FPARENTID left join CT_PUR_SetPMADE C  ON A.FSTORAGEORGUNITID = c.cfproductorgid WHERE A.FPROJECTID IS NOT NULL AND A.FTrackId IS NOT NULL AND B.FMaterialid IS NOT NULL  and B.FDEMANDTIME between ? and ? and a.fstorageorgunitid = ? and B.FMaterialid = ? and B.FSTORAGEORGUNITID = ? and A.FTrackId =?  and A.FProjectid = ? ORDER BY B.FUnIssueQty DESC ";
        Date start = (Date)map.get("STARTDATE");
        Date end = (Date)map.get("ENDDATE");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{start, end, porgid, materialid, orgid, trackid, projectid});
        ArrayList<String> stockList = new ArrayList<String>();
        ArrayList<String> stockListQty = new ArrayList<String>();
        while (rs.next()) {
            String key = rs.getString("FID");
            BigDecimal plannedqty = rs.getBigDecimal("PLANNEDQTY");
            stockList.add(key);
            stockListQty.add(String.valueOf(plannedqty));
        }
        map.put("DETAILSTOCKID", this.buildArrayList(stockList));
        map.put("DETAILSTOCKQTY", this.buildArrayList(stockListQty));
    }

    private BigDecimal getInventoryQty(Context ctx, String orgid, String solatedrule, String materialid, String projectid, String trackid, BigDecimal qty, Map<String, Object> map) throws SQLException, BOSException, EASBizException {
        BigDecimal inventoryqty = BigDecimal.ZERO;
        String sql = null;
        IRowSet rs = null;
        String materialkey = null;
        if ("NONE".equals(solatedrule)) {
            materialkey = materialid + "#" + orgid + "#NONE";
            if (this.inventoryMap.get(materialkey) != null) {
                inventoryqty = this.inventoryMap.get(materialkey);
            } else {
                sql = "select fmaterialid,fstorageOrgunitid,SUM(fcurstoreqty) INVENTORY from T_IM_Inventory a  left join T_DB_WAREHOUSE b on a.fwarehouseid = b.fid \tleft join CT_IN_Depottype c on b.Cfdepottypeid = C.FID  left join T_IM_STORESTATE e on a.fstorestatusid = e.fid  where a.fmaterialid=? and a.fstorageOrgunitid=?  and B.CFDEPOTTYPEID IS NOT NULL AND C.CFFATTRIBLE = 1 and e.fnumber in ('1','201','202','203')  group by fmaterialid,fstorageOrgunitid";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialid, orgid});
                if (rs.next()) {
                    inventoryqty = rs.getBigDecimal("INVENTORY");
                }
            }
        } else if ("ITEM".equals(solatedrule)) {
            materialkey = materialid + "#" + orgid + "#" + projectid + "#ITEM";
            if (this.inventoryMap.get(materialkey) != null) {
                inventoryqty = this.inventoryMap.get(materialkey);
            } else {
                sql = "select fmaterialid,fstorageOrgunitid,fprojectid,SUM(fcurstoreqty) INVENTORY from T_IM_Inventory a  left join T_DB_WAREHOUSE b on a.fwarehouseid = b.fid \tleft join CT_IN_Depottype c on b.Cfdepottypeid = C.FID  left join T_IM_STORESTATE e on a.fstorestatusid = e.fid  where a.fmaterialid=? and a.fstorageOrgunitid=? and fprojectid=?   and B.CFDEPOTTYPEID IS NOT NULL AND C.CFFATTRIBLE = 1 and e.fnumber in ('1','201','202','203')  group by fmaterialid,fstorageOrgunitid,fprojectid";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialid, orgid, projectid});
                if (rs.next()) {
                    inventoryqty = rs.getBigDecimal("INVENTORY");
                }
            }
        } else {
            materialkey = materialid + "#" + orgid + "#" + projectid + "#" + trackid + "#ITEM";
            if (this.inventoryMap.get(materialkey) != null) {
                inventoryqty = this.inventoryMap.get(materialkey);
            } else {
                sql = "select fmaterialid,fstorageOrgunitid,fprojectid,ftracknumberid,SUM(fcurstoreqty) INVENTORY from T_IM_Inventory a  left join T_DB_WAREHOUSE b on a.fwarehouseid = b.fid \tleft join CT_IN_Depottype c on b.Cfdepottypeid = C.FID  left join T_IM_STORESTATE e on a.fstorestatusid = e.fid  where a.fmaterialid=? and a.fstorageOrgunitid=? and fprojectid=? and ftracknumberid=?  and B.CFDEPOTTYPEID IS NOT NULL AND C.CFFATTRIBLE = 1 and e.fnumber in ('1','201','202','203')  group by fmaterialid,fstorageOrgunitid,fprojectid,ftracknumberid";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialid, orgid, projectid, trackid});
                if (rs.next()) {
                    inventoryqty = rs.getBigDecimal("INVENTORY");
                }
            }
        }
        BigDecimal actualqty = BigDecimal.ZERO;
        BigDecimal occupyInventory = BigDecimal.ZERO;
        if (inventoryqty.doubleValue() >= qty.doubleValue()) {
            occupyInventory = qty;
            this.inventoryMap.put(materialkey, inventoryqty.subtract(qty));
            actualqty = BigDecimal.ZERO;
        } else {
            this.inventoryMap.put(materialkey, BigDecimal.ZERO);
            occupyInventory = inventoryqty;
            actualqty = qty.subtract(inventoryqty);
        }
        map.put("LOG_SOLATEDRULE", solatedrule);
        map.put("LOG_Inventory", inventoryqty);
        map.put("LOG_OccupyInventory", occupyInventory);
        map.put("ACTUALQTY", actualqty);
        map.put("FISOLATEDRULE", solatedrule);
        return actualqty;
    }

    private String matchExistDeliveryPlan(Context ctx, Map<String, Object> map, Map<String, Object> detailobj, boolean isChange) throws SQLException, BOSException, EASBizException {
        String materialid = (String)map.get("MATERIALID");
        String projectid = (String)map.get("PROJECTID");
        String trackid = (String)map.get("TRACKID");
        String orgid = (String)map.get("ORGID");
        String porgid = (String)map.get("PORGID");
        Timestamp demandtime = (Timestamp)map.get("DEMANDTIME");
        Timestamp tqdays = (Timestamp)map.get("TQDAY");
        if (isChange) {
            DbUtil.execute((Context)ctx, (String)"delete from t_sm_consignmentschedulecb a where a.fparentid = ? and fbasestatus != 4", (Object[])new Object[]{detailobj.get("FID")});
            HashMap<String, Object> deliveryObj = new HashMap<String, Object>();
            deliveryObj.put("MATERIALID", materialid);
            deliveryObj.put("FID", detailobj.get("FID"));
            deliveryObj.put("QTY", detailobj.get("QTY"));
            deliveryObj.put("DEMANDTIME", detailobj.get("DEMANDTIME"));
            return this.markDeliveryPlanChange(ctx, deliveryObj);
        }
        HashMap<String, Object> deliveryObj = new HashMap<String, Object>();
        deliveryObj.put("MATERIALID", materialid);
        deliveryObj.put("PROJECTID", projectid);
        deliveryObj.put("TRACKID", trackid);
        deliveryObj.put("ORGID", orgid);
        deliveryObj.put("QTY", detailobj.get("QTY"));
        deliveryObj.put("BIZDATE", detailobj.get("BIZDATE"));
        deliveryObj.put("ORDERID", detailobj.get("ORDERID"));
        deliveryObj.put("ENTRYID", detailobj.get("ENTRYID"));
        deliveryObj.put("SEQ", detailobj.get("SEQ"));
        deliveryObj.put("purorgid", detailobj.get("purorgid"));
        deliveryObj.put("PORGID", porgid);
        deliveryObj.put("DEMANDTIME", demandtime);
        deliveryObj.put("TQDAY", tqdays);
        deliveryObj.put("FISOLATEDRULE", map.get("FISOLATEDRULE"));
        return this.makeDeliveryPlan(ctx, deliveryObj);
    }

    public String markDeliveryPlanChange(Context ctx, Map<String, Object> map) throws BOSException, EASBizException {
        ConsignmentScheduleCbInfo info = new ConsignmentScheduleCbInfo();
        info.setBasestatus(1);
        String parentid = (String)map.get("FID");
        ConsignmentScheduleInfo sinfo = ConsignmentScheduleFactory.getLocalInstance((Context)ctx).getConsignmentScheduleInfo((IObjectPK)new ObjectUuidPK(parentid));
        info.setMaterialid((String)map.get("MATERIALID"));
        info.setParentid(parentid);
        BigDecimal qyt = (BigDecimal)map.get("QTY");
        qyt = qyt.multiply(new BigDecimal(-1));
        info.setNeedAmt(qyt);
        info.setNeedDate((Date)((Timestamp)map.get("DEMANDTIME")));
        info.setPreNeedDate(sinfo.getNeedDate());
        info.setPreNeedAmt(sinfo.getNeedAmt());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        ConsignmentScheduleCBBillInfo temp = new ConsignmentScheduleCBBillInfo();
        String storageUnitId = ContextUtil.getCurrentAdminUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentAdminUnit((Context)ctx).getId().toString();
        String code = iCodingRuleManager.getNumber((IObjectValue)temp, storageUnitId);
        info.setNumber(code);
        IObjectPK pk = ConsignmentScheduleCbFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
        return pk.toString();
    }

    private boolean matchPurOrder(Context ctx, Map<String, Object> map) throws SQLException, BOSException, EASBizException {
        String materialid = (String)map.get("MATERIALID");
        String projectid = (String)map.get("PROJECTID");
        String trackid = (String)map.get("TRACKID");
        String orgid = (String)map.get("ORGID");
        BigDecimal actualqty = (BigDecimal)map.get("ACTUALQTY");
        ArrayList<Map<String, Object>> actualorderqty = new ArrayList<Map<String, Object>>();
        String solatedrule = (String)map.get("FISOLATEDRULE");
        IRowSet rs = null;
        rs = "NONE".equals(solatedrule) ? DbUtil.executeQuery((Context)ctx, (String)"select a.fbizdate BIZDATE,a.fseq SEQ,a.fparentid ORDERID,a.FID ENTRYID, e.fnumber MATERIALNUMBER,a.fqty QTY,b.fnumber SFNUMBER,c.fnumber EFNUMBER,h.fpurchaseorgunitid purorgid from T_SM_PurOrderEntry a  left join T_MM_TRACKNUMBER b on a.ftracknoid = b.fid  left join T_MM_TRACKNUMBER c on a.cfendtracknoid = c.fid  left join t_bd_material e on a.fmaterialid = e.fid  LEFT JOIN t_sm_purorder F on a.fparentid = f.fid Left join CT_PUR_PurReType g on f.cfpurtypeid = g.fid  left join T_SM_PurOrder h on a.fparentid = h.fid  where A.FBASESTATUS = 4 and g.fhosttype = 1 AND a.FRequestOrgUnitID = ? and a.fmaterialid = ? ", (Object[])new Object[]{orgid, materialid}) : DbUtil.executeQuery((Context)ctx, (String)"select a.fbizdate BIZDATE,a.fseq SEQ,a.fparentid ORDERID,a.FID ENTRYID, e.fnumber MATERIALNUMBER,a.fqty QTY,b.fnumber SFNUMBER,c.fnumber EFNUMBER,h.fpurchaseorgunitid purorgid from T_SM_PurOrderEntry a  left join T_MM_TRACKNUMBER b on a.ftracknoid = b.fid  left join T_MM_TRACKNUMBER c on a.cfendtracknoid = c.fid  left join t_bd_material e on a.fmaterialid = e.fid  LEFT JOIN t_sm_purorder F on a.fparentid = f.fid Left join CT_PUR_PurReType g on f.cfpurtypeid = g.fid  left join T_SM_PurOrder h on a.fparentid = h.fid  where A.FBASESTATUS = 4 and g.fhosttype = 1 AND a.FRequestOrgUnitID = ? and a.fmaterialid = ? and a.fprojectid = ? ", (Object[])new Object[]{orgid, materialid, projectid});
        String trackNumber = TrackNumberSingleCache.getInstance(ctx).getTrackNumber(trackid);
        LinkedHashMap<String, List<Object[]>> deliveryPlanMap = new LinkedHashMap<String, List<Object[]>>();
        while (rs.next()) {
            BigDecimal qty = rs.getBigDecimal("QTY");
            Timestamp bizdate = rs.getTimestamp("BIZDATE");
            String orderid = rs.getString("ORDERID");
            String entryid = rs.getString("ENTRYID");
            BigDecimal seqnumber = rs.getBigDecimal("SEQ");
            String sfnumber = rs.getString("SFNUMBER");
            String efnumber = rs.getString("EFNUMBER");
            String purorgid = rs.getString("purorgid");
            HashMap<String, Object> amtMap = new HashMap<String, Object>();
            if ("ITEM_TRACKNO".equals(solatedrule)) {
                if (efnumber != null) {
                    if (trackNumber.compareTo(sfnumber) < 0 || trackNumber.compareTo(efnumber) > 0) continue;
                    qty = this.calculateDeliveryPlan(ctx, deliveryPlanMap, entryid, qty, map);
                    amtMap.put("QTY", qty);
                    amtMap.put("BIZDATE", bizdate);
                    amtMap.put("ORDERID", orderid);
                    amtMap.put("ENTRYID", entryid);
                    amtMap.put("SEQ", seqnumber);
                    amtMap.put("purorgid", purorgid);
                    actualorderqty.add(amtMap);
                    continue;
                }
                if (trackNumber.compareTo(sfnumber) != 0) continue;
                qty = this.calculateDeliveryPlan(ctx, deliveryPlanMap, entryid, qty, map);
                amtMap.put("QTY", qty);
                amtMap.put("BIZDATE", bizdate);
                amtMap.put("ORDERID", orderid);
                amtMap.put("ENTRYID", entryid);
                amtMap.put("SEQ", seqnumber);
                amtMap.put("purorgid", purorgid);
                actualorderqty.add(amtMap);
                continue;
            }
            qty = this.calculateDeliveryPlan(ctx, deliveryPlanMap, entryid, qty, map);
            amtMap.put("QTY", qty);
            amtMap.put("BIZDATE", bizdate);
            amtMap.put("ORDERID", orderid);
            amtMap.put("ENTRYID", entryid);
            amtMap.put("SEQ", seqnumber);
            amtMap.put("purorgid", purorgid);
            actualorderqty.add(amtMap);
        }
        map.put("EXISTDELIVERYPLAN", deliveryPlanMap);
        if (actualorderqty.size() == 0) {
            map.put("LOG_NOEXISTORDER", false);
            return false;
        }
        this.allotPurOrder(ctx, actualqty, actualorderqty, map);
        return true;
    }

    private BigDecimal calculateDeliveryPlan(Context ctx, Map<String, List<Object[]>> map, String entryid, BigDecimal qty, Map<String, Object> contextMap) throws SQLException, BOSException, EASBizException {
        BigDecimal existQty;
        String materialid = (String)contextMap.get("MATERIALID");
        String trackid = (String)contextMap.get("TRACKID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)" select a.fneedAmt DPLANQTY,freceivedamt ,a.fid,a.fparentid entryid,a.fneeddate DEMANDTIME from T_SM_ConsignmentSchedule a  where a.fparentid = ? order by fneeddate ", (Object[])new Object[]{entryid});
        IRowSet _rs = DbUtil.executeQuery((Context)ctx, (String)" select a.fneedAmt DPLANQTY,freceivedamt ,a.fid,a.fparentid entryid,a.fneeddate DEMANDTIME from T_SM_ConsignmentSchedule a  where a.fparentid= ? and a.fmaterialid=? and a.cftracknumberid=? ", (Object[])new Object[]{entryid, materialid, trackid});
        ArrayList<Object[]> linkedmap = new ArrayList<Object[]>();
        while (rs.next()) {
            existQty = rs.getBigDecimal("DPLANQTY");
            BigDecimal receivedQty = rs.getBigDecimal("FRECEIVEDAMT");
            existQty = existQty.subtract(receivedQty == null ? BigDecimal.ZERO : receivedQty);
            qty = qty.subtract(existQty);
        }
        while (_rs.next()) {
            existQty = _rs.getBigDecimal("DPLANQTY");
            String fid = _rs.getString("FID");
            Timestamp needdate = _rs.getTimestamp("DEMANDTIME");
            BigDecimal receivedQty = _rs.getBigDecimal("FRECEIVEDAMT");
            existQty = existQty.subtract(receivedQty == null ? BigDecimal.ZERO : receivedQty);
            linkedmap.add(new Object[]{fid, existQty, needdate});
        }
        map.put(entryid, linkedmap);
        return qty;
    }

    private void allotPurOrder(Context ctx, BigDecimal actualqty, List<Map<String, Object>> actualorderqty, Map<String, Object> map) throws SQLException, BOSException, EASBizException {
        Map existdeliveryplan = (Map)map.get("EXISTDELIVERYPLAN");
        Timestamp requestDate = (Timestamp)map.get("DEMANDTIME");
        ArrayList<String> newdeliveryPlan = new ArrayList<String>();
        ArrayList<String> newdeliveryPlanCB = new ArrayList<String>();
        ArrayList<String> existdeliveryPlan = new ArrayList<String>();
        Iterator iter = existdeliveryplan.entrySet().iterator();
        BigDecimal deliveryQty = BigDecimal.ZERO;
        BigDecimal occurorderQty = BigDecimal.ZERO;
        while (iter.hasNext()) {
            Map.Entry obj = iter.next();
            List delivery = (List)obj.getValue();
            for (int n = 0; n < delivery.size(); ++n) {
                Object[] _value = (Object[])delivery.get(n);
                deliveryQty = deliveryQty.add((BigDecimal)_value[1]);
                existdeliveryPlan.add((String)_value[0]);
            }
        }
        map.put("LOG_DELIVERYPLANQTY", deliveryQty);
        if (actualqty.compareTo(deliveryQty) >= 0) {
            for (Map.Entry obj : existdeliveryplan.entrySet()) {
                List delivery = (List)obj.getValue();
                for (int n = 0; n < delivery.size(); ++n) {
                    Object[] _value = (Object[])delivery.get(n);
                    String fid = (String)_value[0];
                    BigDecimal deliveryamt = (BigDecimal)_value[1];
                    Timestamp _time = (Timestamp)_value[2];
                    HashMap<String, Object> valueMapClone = new HashMap<String, Object>();
                    if (_time.compareTo(requestDate) == 0) continue;
                    valueMapClone.put("FID", fid);
                    valueMapClone.put("DEMANDTIME", _time);
                    valueMapClone.put("PREDEMANDTIME", requestDate);
                    valueMapClone.put("QTY", deliveryamt);
                    valueMapClone.put("PREQTY", deliveryamt);
                    String pk = this.matchExistDeliveryPlan(ctx, map, valueMapClone, true);
                    valueMapClone.put("primary", pk);
                    newdeliveryPlanCB.add(pk);
                }
            }
            actualqty = actualqty.subtract(deliveryQty);
            for (int i = 0; i < actualorderqty.size(); ++i) {
                String pk;
                Map<String, Object> valueMap = actualorderqty.get(i);
                HashMap<String, Object> valueMapClone = new HashMap<String, Object>();
                valueMapClone.putAll(valueMap);
                BigDecimal orderqty = (BigDecimal)valueMap.get("QTY");
                if (actualqty == BigDecimal.ZERO) {
                    return;
                }
                if (orderqty.compareTo(actualqty) >= 0) {
                    valueMapClone.put("QTY", actualqty);
                    occurorderQty = occurorderQty.add(actualqty);
                    pk = this.matchExistDeliveryPlan(ctx, map, valueMapClone, false);
                    actualqty = BigDecimal.ZERO;
                    valueMapClone.put("primary", pk);
                    newdeliveryPlan.add(pk);
                    break;
                }
                valueMapClone.put("QTY", orderqty);
                occurorderQty = occurorderQty.add(orderqty);
                pk = this.matchExistDeliveryPlan(ctx, map, valueMapClone, false);
                actualqty = actualqty.subtract(orderqty);
                valueMapClone.put("primary", pk);
                newdeliveryPlan.add(pk);
            }
        } else {
            actualqty = deliveryQty.subtract(actualqty);
            block5: for (Map.Entry obj : existdeliveryplan.entrySet()) {
                String entryid = (String)obj.getKey();
                List delivery = (List)obj.getValue();
                for (int n = 0; n < delivery.size(); ++n) {
                    String pk;
                    Object[] _value = (Object[])delivery.get(n);
                    String fid = (String)_value[0];
                    Timestamp _date = (Timestamp)_value[2];
                    BigDecimal qty = (BigDecimal)_value[1];
                    if (actualqty == BigDecimal.ZERO) {
                        return;
                    }
                    HashMap<String, Object> valueMapClone = new HashMap<String, Object>();
                    if (qty.compareTo(actualqty) >= 0) {
                        valueMapClone.put("QTY", actualqty);
                        valueMapClone.put("DEMANDTIME", _date);
                        valueMapClone.put("FID", fid);
                        pk = this.matchExistDeliveryPlan(ctx, map, valueMapClone, true);
                        valueMapClone.put("primary", pk);
                        actualqty = BigDecimal.ZERO;
                        newdeliveryPlanCB.add(pk);
                        continue block5;
                    }
                    valueMapClone.put("QTY", qty);
                    valueMapClone.put("DEMANDTIME", _date);
                    valueMapClone.put("FID", fid);
                    pk = this.matchExistDeliveryPlan(ctx, map, valueMapClone, true);
                    valueMapClone.put("primary", pk);
                    actualqty = actualqty.subtract(qty);
                    newdeliveryPlanCB.add(pk);
                }
            }
        }
        if (BigDecimal.ZERO.compareTo(occurorderQty = occurorderQty.add(deliveryQty)) < 0) {
            map.put("LOG_NOEXISTORDER", true);
        }
        map.put("LOG_OCCURORDERQTY", occurorderQty);
        map.put("LOG_DELIVERYPLAN", newdeliveryPlan);
        map.put("LOG_DELIVERYPLANCB", newdeliveryPlanCB);
        map.put("LOG_EXISTDELIVERYPLAN", existdeliveryPlan);
    }

    private String makeDeliveryPlan(Context ctx, Map<String, Object> map) throws BOSException, EASBizException {
        Timestamp demandtime = (Timestamp)map.get("DEMANDTIME");
        Timestamp tqdays = (Timestamp)map.get("TQDAY");
        Timestamp purdate = (Timestamp)map.get("BIZDATE");
        BigDecimal qty = (BigDecimal)map.get("QTY");
        BigDecimal inventoryqty = BigDecimal.ZERO;
        String entryid = (String)map.get("ENTRYID");
        BigDecimal seq = (BigDecimal)map.get("SEQ");
        String materialid = (String)map.get("MATERIALID");
        String tracknumberid = (String)map.get("TRACKID");
        String storageid = (String)map.get("PORGID");
        String solatedrule = (String)map.get("FISOLATEDRULE");
        String purorgid = (String)map.get("purorgid");
        ConsignmentScheduleInfo info = new ConsignmentScheduleInfo();
        String tmpsolaterule = null;
        tmpsolaterule = "ITEM_TRACKNO".equals(solatedrule) ? "2" : ("ITEM".equals(solatedrule) ? "1" : "0");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FID MERGERULEID from CT_PUR_DeliveryPTT k where k.cfpurorgid = ? AND K.ftrantype=? and k.cfstatus = 1", (Object[])new Object[]{purorgid, tmpsolaterule});
        try {
            if (rs.next()) {
                String mergeruleid = rs.getString("MERGERULEID");
                DeliveryPlanTransactionTypeInfo mergeinfo = new DeliveryPlanTransactionTypeInfo();
                mergeinfo.setId(BOSUuid.read((String)mergeruleid));
                info.setMergerule(mergeinfo);
            }
        }
        catch (Exception ex) {
            throw new BOSException("\u83b7\u53d6\u5408\u5e76\u89c4\u5219\u5931\u8d25");
        }
        info.setDeliverystatus(DeliveryStatusEnum.NOT_SEND);
        info.setNeedDate((Date)demandtime);
        info.setPurDate((Date)purdate);
        info.setNeedAmt(qty);
        info.setPlanReceiveDate(tqdays);
        info.setWarehouseAmt(inventoryqty);
        PurOrderEntryInfo entryinfo = new PurOrderEntryInfo();
        entryinfo.setId(BOSUuid.read((String)entryid));
        info.setParent(entryinfo);
        info.setSeq(seq.intValue());
        MaterialInfo materialinfo = new MaterialInfo();
        materialinfo.setId(BOSUuid.read((String)materialid));
        info.setMaterial(materialinfo);
        info.setTracknumberid(tracknumberid);
        StorageOrgUnitInfo storgetinfo = new StorageOrgUnitInfo();
        storgetinfo.setId(BOSUuid.read((String)storageid));
        info.setProductorg(storgetinfo);
        info.setSolatedrule(solatedrule);
        if (qty == null || BigDecimal.ZERO == qty) {
            return "";
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        ConsignmentScheduleBillInfo temp = new ConsignmentScheduleBillInfo();
        String storageUnitId = ContextUtil.getCurrentAdminUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentAdminUnit((Context)ctx).getId().toString();
        String code = iCodingRuleManager.getNumber((IObjectValue)temp, storageUnitId);
        info.setNumber(code);
        IObjectPK pk = ConsignmentScheduleFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
        return pk.toString();
    }

    public List splitCondition(List paramobj) {
        ArrayList paramobjs = new ArrayList();
        Timestamp startTime = (Timestamp)paramobj.get(0);
        Timestamp endTime = (Timestamp)paramobj.get(1);
        Object org = paramobj.get(2);
        Object objsupply = paramobj.get(3);
        Object objpurrd = paramobj.get(4);
        String startStr = "";
        String endStr = "";
        Object deley = paramobj.get(5);
        Object userID = paramobj.get(6);
        Object dpoInfo = paramobj.get(7);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startStr = sdf.format(startTime);
            endStr = sdf.format(endTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<KeyValueForDate> list = CalculateDeliveryPlanFacadeControllerBean.getKeyValueForDate(startStr, endStr);
        for (KeyValueForDate date : list) {
            ArrayList<Timestamp> newParam = new ArrayList<Timestamp>();
            Timestamp startDate = this.tranTimeStamp(date.getStartDate(), " 00:00:00");
            Timestamp endDate = this.tranTimeStamp(date.getEndDate(), " 23:59:59");
            newParam.add(startDate);
            newParam.add(endDate);
            newParam.add((Timestamp)org);
            newParam.add((Timestamp)objsupply);
            newParam.add((Timestamp)objpurrd);
            newParam.add((Timestamp)deley);
            newParam.add((Timestamp)userID);
            newParam.add((Timestamp)dpoInfo);
            paramobjs.add(newParam);
        }
        return paramobjs;
    }

    public Timestamp tranTimeStamp(String timeStr, String hz) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(timeStr + hz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }

    protected String getInsertTableSQL(String TableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(TableName).append("(\r\n");
        sql.append("Findex,\r\n");
        sql.append("FStep,\r\n");
        sql.append("Fcontent,\r\n");
        sql.append("Ftime,\r\n");
        sql.append("Fstatus,\r\n");
        sql.append("FlastIndex,\r\n");
        sql.append("fistop,");
        sql.append("Fpercent\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    @Override
    protected void _execNew(Context ctx, List paramobj, String tableName) throws BOSException, EASBizException {
        StringBuffer log = new StringBuffer();
        log.setLength(0);
        log.append(this.getInsertTableSQL(tableName) + str_log);
        DbUtil.execute((Context)ctx, (String)log.toString());
        log.setLength(0);
        log.setLength(0);
        log.append("update " + tableName + " set fstatus = '\u5df2\u5b8c\u6210',fpercent = 10  where findex = 1");
        DbUtil.execute((Context)ctx, (String)log.toString());
        log.setLength(0);
        log.append("update " + tableName + " set fstatus = '\u5904\u7406\u4e2d',fpercent = 0  where findex = 2");
        DbUtil.execute((Context)ctx, (String)log.toString());
        long startTime = System.currentTimeMillis();
        String[] classImps = AbstractCalculateResultScope.scopeClass;
        List<Object> restulevo = new ArrayList();
        ArrayList<AbstractCalculateResultScope> scopes = new ArrayList<AbstractCalculateResultScope>();
        try {
            for (String imp : classImps) {
                AbstractCalculateResultScope scope = (AbstractCalculateResultScope)Class.forName(imp).newInstance();
                scopes.add(scope);
                scope.initService(ctx, paramobj);
            }
        }
        catch (Exception ex) {
            throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u67e5\u8be2\u4ea4\u8d27\u8ba1\u5212\u6765\u6e90\u6570\u636e\u5931\u8d25\uff01" + ex.getMessage()));
        }
        finally {
            for (AbstractCalculateResultScope scope : scopes) {
                if (scope.getTmpTables() == null || scope.getTmpTables().size() <= 0) continue;
                for (int i = 0; i < scope.getTmpTables().size(); ++i) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(scope.getTmpTables().get(i).toString());
                }
            }
        }
        try {
            restulevo = this.getResultVOS(ctx, paramobj);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u67e5\u8be2\u4ea4\u8d27\u8ba1\u5212\u6765\u6e90\u6570\u636e\u5931\u8d25\uff01" + e.getMessage()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u67e5\u8be2\u4ea4\u8d27\u8ba1\u5212\u6765\u6e90\u6570\u636e\u5931\u8d25\uff01" + e.getMessage()));
        }
        long endTime = System.currentTimeMillis();
        log.setLength(0);
        double tmp = (double)(endTime - startTime) / 60000.0;
        DecimalFormat df = new DecimalFormat("#.00");
        log.append("update " + tableName + " set fstatus = '\u5df2\u5b8c\u6210',fpercent = 35 ,ftime = " + df.format(tmp) + " where findex = 2");
        DbUtil.execute((Context)ctx, (String)log.toString());
        this.delRecordBeforeCalculate(ctx, paramobj);
        try {
            CalculateDeliveryPlanFacadeFactory.getLocalInstance(ctx).createConsignmentPlanByStock(restulevo, tableName);
        }
        catch (Exception ex) {
            throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u5339\u914d\u5e93\u5b58\uff0c\u5728\u9014\uff0c\u91c7\u8d2d\u8ba2\u5355\u51fa\u9519\uff01" + ex.getMessage()), (Throwable)ex);
        }
        finally {
            this.clearSingletonAll(ctx);
        }
    }

    private void delRecordBeforeCalculate(Context ctx, List paramobj) throws BOSException, EASBizException {
        SupplyRelationshipDefinitionInfo supRInfo = (SupplyRelationshipDefinitionInfo)paramobj.get(3);
        DbUtil.execute((Context)ctx, (String)"delete from CT_SM_DeliveryPlanDetail where Cfsupplystorageorg in (SELECT Cfsupplyorgunitid FROM CT_BAS_SupplyRDE WHERE FParentID = ? ) ", (Object[])new Object[]{supRInfo.getId().toString()});
        DbUtil.execute((Context)ctx, (String)"delete from ct_sm_deliveryplanbystock  ");
    }

    private List dealMerge(Context ctx, List datas) throws BOSException, EASBizException {
        ArrayList<CalculateResultScopeVO> restulevo = new ArrayList<CalculateResultScopeVO>();
        StringBuffer sql = new StringBuffer();
        HashMap<String, CalculateResultScopeVO> map = new HashMap<String, CalculateResultScopeVO>();
        String isolatedrule = "";
        for (int i = 0; i < datas.size(); ++i) {
            BigDecimal qty;
            String calhashcode;
            CalculateResultScopeVO calplanVo = (CalculateResultScopeVO)datas.get(i);
            String supplystorageorgid = calplanVo.getSupplystorageorgid();
            String storageorgid = calplanVo.getStorageorgid();
            String materialid = calplanVo.getMaterialid();
            String projectid = calplanVo.getProjectid();
            java.sql.Date reqDate = calplanVo.getReqDate();
            sql.setLength(0);
            sql.append("Select mat.fisolatedrule \r\n");
            sql.append("from T_BD_MaterialPlan mat \r\n");
            sql.append("where mat.fmaterialid='").append(materialid).append("'\r\n");
            sql.append("And mat.fsupplyorgunit='").append(supplystorageorgid).append("'\r\n");
            sql.append("Group By mat.fisolatedrule");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs == null) continue;
            try {
                if (rs.next()) {
                    isolatedrule = rs.getString(1);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if ("NONE".equals(isolatedrule)) {
                calhashcode = storageorgid.hashCode() + "" + materialid.hashCode() + "" + reqDate.hashCode();
                if (map.containsKey(calhashcode)) {
                    qty = ((CalculateResultScopeVO)map.get(calhashcode)).getQty().add(calplanVo.getQty());
                    calplanVo.setQty(qty);
                    map.remove(calhashcode);
                    calplanVo.setProjectid(null);
                    calplanVo.setTracknumberid(null);
                    map.put(calhashcode, calplanVo);
                    continue;
                }
                map.put(calhashcode, calplanVo);
                continue;
            }
            if ("ITEM".equals(isolatedrule)) {
                calhashcode = storageorgid.hashCode() + "" + materialid.hashCode() + "" + projectid.hashCode() + "" + reqDate.hashCode();
                if (map.containsKey(calhashcode)) {
                    qty = ((CalculateResultScopeVO)map.get(calhashcode)).getQty().add(calplanVo.getQty());
                    calplanVo.setQty(qty);
                    map.remove(calhashcode);
                    calplanVo.setTracknumberid(null);
                    map.put(calhashcode, calplanVo);
                    continue;
                }
                map.put(calhashcode, calplanVo);
                continue;
            }
            restulevo.add(calplanVo);
        }
        for (CalculateResultScopeVO calculateResultScopeVO : map.values()) {
            restulevo.add(calculateResultScopeVO);
        }
        return restulevo;
    }

    @Override
    protected void _createConsignmentPlanByStock(Context ctx, List mergeIdList, String tableName) throws BOSException, EASBizException {
        StringBuffer log = new StringBuffer();
        long startTime = System.currentTimeMillis();
        log.setLength(0);
        log.append("update " + tableName + " set fstatus = '\u5904\u7406\u4e2d',fpercent = 10  where findex = 3");
        DbUtil.execute((Context)ctx, (String)log.toString());
        DeliveryPlanInventoryMatchHandler inventoryHandler = new DeliveryPlanInventoryMatchHandler();
        DeliveryPlanMatchHandler deliveryPlanHandler = new DeliveryPlanMatchHandler();
        DeliveryPlanPurOrderMatchHandler purorderhandler = new DeliveryPlanPurOrderMatchHandler();
        ((AbstractMatchHandler)inventoryHandler).setCtx(ctx);
        ((AbstractMatchHandler)inventoryHandler).setHandler(deliveryPlanHandler);
        ((AbstractMatchHandler)deliveryPlanHandler).setHandler(purorderhandler);
        ArrayList<CalculateResultScopeVO> logList = new ArrayList<CalculateResultScopeVO>();
        ArrayList<DeliveryPlanDetailInfo> saveList = new ArrayList<DeliveryPlanDetailInfo>();
        ArrayList<ConsignmentScheduleCbInfo> saveCbList = new ArrayList<ConsignmentScheduleCbInfo>();
        for (int n = 0; n < mergeIdList.size(); ++n) {
            long b1 = System.currentTimeMillis();
            CalculateResultScopeVO vo = (CalculateResultScopeVO)mergeIdList.get(n);
            ((AbstractMatchHandler)inventoryHandler).setVo(vo);
            ((AbstractMatchHandler)inventoryHandler).handleRequest();
            saveList.addAll(vo.getConsignmentList());
            saveCbList.addAll(vo.getConsignmentCbList());
            long b2 = System.currentTimeMillis();
            System.out.println("\u5339\u914d\u65f6\u95f4\uff1a" + (b2 - b1));
            logList.add(vo);
        }
        long endTime = System.currentTimeMillis();
        log.setLength(0);
        double tmp = (double)(endTime - startTime) / 60000.0;
        DecimalFormat df = new DecimalFormat("#.00");
        log.append("update " + tableName + " set fstatus = '\u5df2\u5b8c\u6210',fpercent = 35 ,ftime = " + df.format(tmp) + " where findex = 3");
        DbUtil.execute((Context)ctx, (String)log.toString());
        long startTime1 = System.currentTimeMillis();
        log.setLength(0);
        log.append("update " + tableName + " set fstatus = '\u5904\u7406\u4e2d',fpercent = 10  where findex = 4");
        DbUtil.execute((Context)ctx, (String)log.toString());
        this.saveConsignmentAndConsignmentCb(ctx, saveList, saveCbList);
        long endTime1 = System.currentTimeMillis();
        log.setLength(0);
        double tmp1 = (double)(endTime1 - startTime1) / 60000.0;
        log.append("update " + tableName + " set fstatus = '\u5df2\u5b8c\u6210',fpercent = 35 ,ftime = " + df.format(tmp1) + " where findex = 4");
        DbUtil.execute((Context)ctx, (String)log.toString());
        long startTime2 = System.currentTimeMillis();
        log.setLength(0);
        log.append("update " + tableName + " set fstatus = '\u5904\u7406\u4e2d',fpercent = 10  where findex = 5");
        DbUtil.execute((Context)ctx, (String)log.toString());
        DeliveryPlanFBFacadeFactory.getLocalInstance((Context)ctx).mergeDeliveryPlan(null);
        DeliveryPlanFBFacadeFactory.getLocalInstance((Context)ctx).refreshSupplyList(null);
        long endTime2 = System.currentTimeMillis();
        log.setLength(0);
        double tmp2 = (double)(endTime1 - startTime1) / 60000.0;
        log.append("update " + tableName + " set fstatus = '\u5df2\u5b8c\u6210',fpercent = 35 ,ftime = " + df.format(tmp2) + " where findex = 5");
        DbUtil.execute((Context)ctx, (String)log.toString());
        long startTime3 = System.currentTimeMillis();
        log.setLength(0);
        log.append("update " + tableName + " set fstatus = '\u5904\u7406\u4e2d',fpercent = 10  where findex = 6");
        DbUtil.execute((Context)ctx, (String)log.toString());
        this.saveConsignmentLog(ctx, logList);
        long endTime3 = System.currentTimeMillis();
        log.setLength(0);
        double tmp3 = (double)(endTime1 - startTime1) / 60000.0;
        log.append("update " + tableName + " set fstatus = '\u5df2\u5b8c\u6210',fpercent = 35 ,ftime = " + df.format(tmp3) + " where findex = 6");
        DbUtil.execute((Context)ctx, (String)log.toString());
        log.setLength(0);
        log.append("update " + tableName + " set fstatus = '\u5df2\u5b8c\u6210',fpercent = 10  where findex = 7");
        DbUtil.execute((Context)ctx, (String)log.toString());
        System.out.println("\u8ba1\u7b97\u7ed3\u675f!");
    }

    private void noMatchDeliveryByStock(Context ctx, List<CalculateResultScopeVO> logList) throws BOSException, EASBizException {
        HashSet deliveryList = new HashSet();
        for (int n = 0; n < logList.size(); ++n) {
            String deliverypks = logList.get(n).getExistdeliveryplanpks();
            String string = deliverypks = deliverypks == null ? "" : deliverypks.replaceAll("'", "");
            if (deliverypks.length() <= 0) continue;
            String[] stringArray = deliverypks.split(",");
        }
        String[] deliverypks = deliveryList.toArray(new String[0]);
        for (int n = 0; n < deliverypks.length; ++n) {
            DbUtil.execute((Context)ctx, (String)"delete from t_sm_consignmentschedulecb a where a.fparentid = ? and fbasestatus != 4", (Object[])new Object[]{deliverypks[n]});
        }
        String storageUnitId = ContextUtil.getCurrentStorageUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentStorageUnit((Context)ctx).getId().toString();
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (deliveryList.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", deliveryList, CompareType.NOTINCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        viewinfo.setFilter(filter);
        ConsignmentScheduleCollection colls = ConsignmentScheduleFactory.getLocalInstance((Context)ctx).getConsignmentScheduleCollection(viewinfo);
        ArrayList<ConsignmentScheduleCbInfo> saveCbList = new ArrayList<ConsignmentScheduleCbInfo>();
        for (int n = 0; n < colls.size(); ++n) {
            ConsignmentScheduleInfo _info = colls.get(n);
            ConsignmentScheduleCbInfo info = new ConsignmentScheduleCbInfo();
            info.setBasestatus(1);
            info.setMaterialid(_info.getMaterial().getId().toString());
            info.setParentid(_info.getId().toString());
            BigDecimal amout = _info.getNeedAmt() == null ? BigDecimal.ZERO : _info.getNeedAmt();
            BigDecimal whAmt = _info.getWarehouseAmt() == null ? BigDecimal.ZERO : _info.getWarehouseAmt();
            info.setNeedAmt(amout.subtract(whAmt).multiply(new BigDecimal(-1)));
            info.setNeedDate(_info.getNeedDate());
            info.setPreNeedDate(_info.getNeedDate());
            info.setPreNeedAmt(_info.getNeedAmt());
            if (info.getNeedAmt().compareTo(BigDecimal.ZERO) < 0) {
                saveCbList.add(info);
            }
            DbUtil.execute((Context)ctx, (String)"delete from t_sm_consignmentschedulecb a where a.fparentid = ? and fbasestatus != 4", (Object[])new Object[]{_info.getId().toString()});
        }
        if (saveCbList.size() > 0) {
            CoreBaseCollection _colls = new CoreBaseCollection();
            ConsignmentScheduleCBBillInfo temp = new ConsignmentScheduleCBBillInfo();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String[] numbers = iCodingRuleManager.getBatchNumber((IObjectValue)temp, storageUnitId, saveCbList.size());
            for (int n = 0; n < saveCbList.size(); ++n) {
                ConsignmentScheduleCbInfo info = (ConsignmentScheduleCbInfo)saveCbList.get(n);
                info.setNumber(numbers[n]);
                info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                _colls.add((CoreBaseInfo)info);
                DbUtil.execute((Context)ctx, (String)"delete from t_sm_consignmentschedulecb a where a.fparentid = ? and fbasestatus != 4", (Object[])new Object[]{info.getParentid()});
            }
            IObjectPK[] iObjectPKArray = ConsignmentScheduleCbFactory.getLocalInstance((Context)ctx).saveBatchData(_colls);
        }
    }

    private void saveConsignmentLog(Context ctx, List<CalculateResultScopeVO> logList) throws BOSException, EASBizException {
        CoreBaseCollection colls = new CoreBaseCollection();
        for (CalculateResultScopeVO scopeVO : logList) {
            AnalyseDeliveryPlanByStockInfo info = new AnalyseDeliveryPlanByStockInfo();
            MaterialInfo materialinfo = new MaterialInfo();
            String materialid = scopeVO.getMaterialid();
            materialinfo.setId(BOSUuid.read((String)materialid));
            info.setMaterialID(materialinfo);
            TrackNumberInfo trackNum = new TrackNumberInfo();
            if (scopeVO.getTracknumberid() != null) {
                trackNum.setId(BOSUuid.read((String)scopeVO.getTracknumberid()));
                info.setTrackNumID(trackNum);
            }
            ProjectInfo projectInfo = new ProjectInfo();
            if (scopeVO.getProjectid() != null) {
                projectInfo.setId(BOSUuid.read((String)scopeVO.getProjectid()));
                info.setProjectID(projectInfo);
            }
            PurchaseOrgUnitInfo purorgInfo = new PurchaseOrgUnitInfo();
            purorgInfo.setId(BOSUuid.read((String)scopeVO.getStorageorgid()));
            info.setPurOrgID(purorgInfo);
            StorageOrgUnitInfo storageinfo = new StorageOrgUnitInfo();
            storageinfo.setId(BOSUuid.read((String)scopeVO.getSupplystorageorgid()));
            info.setStorageOrgID(storageinfo);
            info.setSolatedRule(scopeVO.getSolatedrule());
            info.setReceiveDate(scopeVO.getPlanRecDate());
            info.setReqQty(scopeVO.getQty());
            info.setReqDate(new Timestamp(scopeVO.getReqDate().getTime()));
            info.setInventory(scopeVO.getInventoryqty());
            info.setOccupyInventory(scopeVO.getOccupyInventory());
            info.setOccupyOrderQty(scopeVO.getActPurOreryqty());
            info.setCalculateStartDate(scopeVO.getStartDate());
            info.setCalculateEndDate(scopeVO.getEndDate());
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            info.setExistDeliveryPlanPks(scopeVO.getExistdeliveryplanpks());
            boolean isRelated = scopeVO.getActPurOreryqty() == null ? false : scopeVO.getActPurOreryqty().compareTo(BigDecimal.ZERO) > 0;
            String existDeliverpks = scopeVO.getExistdeliveryplanpks() == null ? "" : scopeVO.getExistdeliveryplanpks().replaceAll("'", "");
            String[] calculateIds = existDeliverpks.split(",");
            BigDecimal ordQty = BigDecimal.ZERO;
            List<DeliveryPlanDetailInfo> csColl = scopeVO.getConsignmentList();
            if (csColl != null) {
                for (int ix = 0; ix < csColl.size(); ++ix) {
                    DeliveryPlanDetailInfo csInfo = csColl.get(ix);
                    ordQty = ordQty.add(csInfo.getDemandQty());
                }
            }
            info.setOccupyOrderQty(ordQty);
            BigDecimal unmatchQty = info.getReqQty().subtract(info.getOccupyInventory() != null ? info.getOccupyInventory() : BigDecimal.ZERO).subtract(info.getOccupyOrderQty() != null ? info.getOccupyOrderQty() : BigDecimal.ZERO);
            info.setUnMatchQty(unmatchQty);
            if ((info.getOccupyOrderQty() != null ? info.getOccupyOrderQty() : BigDecimal.ZERO).compareTo(BigDecimal.ZERO) == 0) {
                info.setPurOrderMa(purMacthEnum.UNMATCH);
            } else if (info.getReqQty().subtract(info.getOccupyInventory() != null ? info.getOccupyInventory() : BigDecimal.ZERO).compareTo(info.getOccupyOrderQty()) == 0) {
                info.setPurOrderMa(purMacthEnum.TOTAL);
            } else if (info.getReqQty().subtract(info.getOccupyInventory() != null ? info.getOccupyInventory() : BigDecimal.ZERO).compareTo(info.getOccupyOrderQty()) > 0) {
                info.setPurOrderMa(purMacthEnum.PART);
            }
            if (!IndustryUtils.isEmptyString((String)scopeVO.getPurGroupID())) {
                PurchaseGroupInfo ginfo = new PurchaseGroupInfo();
                ginfo.setId(BOSUuid.read((String)scopeVO.getPurGroupID()));
                info.setPurGroup(ginfo);
            }
            if (!IndustryUtils.isEmptyString((String)scopeVO.getPurPersonID())) {
                PersonInfo pinfo = new PersonInfo();
                pinfo.setId(BOSUuid.read((String)scopeVO.getPurPersonID()));
                info.setPurPerson(pinfo);
            }
            boolean isExistDelivery = existDeliverpks.length() > 0;
            info.setIsrelated(isRelated || isExistDelivery);
            info.setIsdisable(true);
            colls.add((CoreBaseInfo)info);
        }
        AnalyseDeliveryPlanByStockFactory.getLocalInstance((Context)ctx).addnewBatchData(colls);
    }

    private void saveConsignmentAndConsignmentCb(Context ctx, List<DeliveryPlanDetailInfo> saveList, List<ConsignmentScheduleCbInfo> saveCbList) throws BOSException, EASBizException {
        String storageUnitId;
        CoreBaseCollection colls = new CoreBaseCollection();
        String string = storageUnitId = ContextUtil.getCurrentStorageUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentStorageUnit((Context)ctx).getId().toString();
        if (saveList.size() > 0) {
            DeliveryPlanDetailInfo temp = new DeliveryPlanDetailInfo();
            for (int n = 0; n < saveList.size(); ++n) {
                DeliveryPlanDetailInfo info = saveList.get(n);
                DeliveryPlanDetailFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)info);
            }
        }
        colls.clear();
    }

    public void clearSingletonAll(Context ctx) throws BOSException, EASBizException {
        DeliveryPlanSingletonFactory.getInventoryMaterialSingleton(ctx).clear();
        DeliveryPlanSingletonFactory.getDeliveryPlanSingleton(ctx).clear();
        DeliveryPlanSingletonFactory.getPurOrderSignleton(ctx).clear();
        DeliveryPlanSingletonFactory.getDirectMaterialSingleton(ctx).clear();
    }

    @Override
    protected void _purInvWriteConsign(Context ctx, IObjectCollection purinvs, BatchActionEnum action) throws BOSException, EASBizException {
        for (int n = 0; n < purinvs.size(); ++n) {
            PurInWarehsBillInfo info = (PurInWarehsBillInfo)purinvs.getObject(n);
            PurInWarehsEntryCollection colls = info.getEntry();
            for (int m = 0; m < colls.size(); ++m) {
                PurReceivalEntryInfo _info;
                PurInWarehsEntryInfo entry = colls.get(m);
                String materialid = entry.getMaterial().getId().toString();
                String sourceid = entry.getSourceBillEntryId();
                if (sourceid == null) {
                    return;
                }
                BillTypeInfo sourceType = entry.getSourceBillType();
                if ("101".equals(sourceType.getNumber()) && (_info = PurReceivalEntryFactory.getLocalInstance((Context)ctx).getPurReceivalEntryInfo((IObjectPK)new ObjectUuidPK(sourceid))) != null && _info.getSourceBillEntryId() != null) {
                    sourceid = _info.getSourceBillEntryId();
                }
                BigDecimal amt = entry.getQty();
                if (action.equals((Object)BatchActionEnum.UNAUDIT)) {
                    amt = amt.multiply(new BigDecimal(-1));
                }
                if (materialid != null && sourceid != null && amt.compareTo(BigDecimal.ZERO) > 0) {
                    this.updateConsignmentPlanApprove(ctx, sourceid, materialid, amt, true);
                    continue;
                }
                if (materialid == null || sourceid == null || amt.compareTo(BigDecimal.ZERO) >= 0) continue;
                this.updateConsignmentPlanUnApprove(ctx, sourceid, materialid, amt, true);
            }
        }
    }

    private void updateConsignmentPlanUnApprove(Context ctx, String purentryid, String materialid, BigDecimal purInvQty, boolean isInv) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filteritem1 = new FilterItemInfo("material", (Object)materialid, CompareType.EQUALS);
        FilterItemInfo filteritem2 = new FilterItemInfo("parent", (Object)purentryid, CompareType.EQUALS);
        FilterItemInfo filteritem3 = new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS);
        SorterItemInfo sorteritem = new SorterItemInfo("NeedDate");
        view.getSorter().add(sorteritem);
        filter.getFilterItems().add(filteritem1);
        filter.getFilterItems().add(filteritem2);
        filter.getFilterItems().add(filteritem3);
        view.setFilter(filter);
        ConsignmentScheduleCollection colls = ConsignmentScheduleFactory.getLocalInstance((Context)ctx).getConsignmentScheduleCollection(view);
        for (int n = 0; n < colls.size(); ++n) {
            ConsignmentScheduleInfo scheduleInfo = colls.get(n);
            BigDecimal needAmt = scheduleInfo.getNeedAmt();
            BigDecimal amt = BigDecimal.ZERO;
            if (isInv) {
                amt = scheduleInfo.getWarehouseAmt() == null ? BigDecimal.ZERO : scheduleInfo.getWarehouseAmt();
            } else {
                BigDecimal bigDecimal = amt = scheduleInfo.getReceivedAmt() == null ? BigDecimal.ZERO : scheduleInfo.getReceivedAmt();
            }
            if (purInvQty.compareTo(BigDecimal.ZERO) >= 0) continue;
            BigDecimal newwarehouseAmt = amt.add(purInvQty);
            if (n == colls.size() - 1) {
                if (isInv) {
                    scheduleInfo.setWarehouseAmt(newwarehouseAmt);
                } else {
                    scheduleInfo.setReceivedAmt(newwarehouseAmt);
                }
                purInvQty = BigDecimal.ZERO;
                if (needAmt.compareTo(scheduleInfo.getWarehouseAmt()) > 0 && isInv) {
                    scheduleInfo.setClosedate(null);
                }
                if (scheduleInfo.getReceivedAmt() != null) {
                    if (needAmt.compareTo(scheduleInfo.getReceivedAmt()) <= 0 && !isInv) {
                        scheduleInfo.setDeliverystatus(DeliveryStatusEnum.ALL_SEND);
                    } else if (needAmt.compareTo(scheduleInfo.getReceivedAmt()) > 0 && !isInv && scheduleInfo.getReceivedAmt().compareTo(BigDecimal.ZERO) > 0) {
                        scheduleInfo.setDeliverystatus(DeliveryStatusEnum.PART_SEND);
                    } else if (needAmt.compareTo(scheduleInfo.getReceivedAmt()) > 0 && !isInv && scheduleInfo.getReceivedAmt().compareTo(BigDecimal.ZERO) == 0) {
                        scheduleInfo.setDeliverystatus(DeliveryStatusEnum.NOT_SEND);
                    }
                } else {
                    scheduleInfo.setDeliverystatus(DeliveryStatusEnum.NOT_SEND);
                }
                ConsignmentScheduleFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)scheduleInfo);
                break;
            }
            if (newwarehouseAmt.compareTo(BigDecimal.ZERO) >= 0) {
                if (isInv) {
                    scheduleInfo.setWarehouseAmt(newwarehouseAmt);
                } else {
                    scheduleInfo.setReceivedAmt(newwarehouseAmt);
                }
                purInvQty = BigDecimal.ZERO;
                if (needAmt.compareTo(scheduleInfo.getWarehouseAmt()) > 0 && isInv) {
                    scheduleInfo.setClosedate(null);
                }
                if (scheduleInfo.getReceivedAmt() != null) {
                    if (needAmt.compareTo(scheduleInfo.getReceivedAmt()) <= 0 && !isInv) {
                        scheduleInfo.setDeliverystatus(DeliveryStatusEnum.ALL_SEND);
                    } else if (needAmt.compareTo(scheduleInfo.getReceivedAmt()) > 0 && !isInv && scheduleInfo.getReceivedAmt().compareTo(BigDecimal.ZERO) > 0) {
                        scheduleInfo.setDeliverystatus(DeliveryStatusEnum.PART_SEND);
                    } else if (needAmt.compareTo(scheduleInfo.getReceivedAmt()) > 0 && !isInv && scheduleInfo.getReceivedAmt().compareTo(BigDecimal.ZERO) == 0) {
                        scheduleInfo.setDeliverystatus(DeliveryStatusEnum.NOT_SEND);
                    }
                } else {
                    scheduleInfo.setDeliverystatus(DeliveryStatusEnum.NOT_SEND);
                }
                ConsignmentScheduleFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)scheduleInfo);
                break;
            }
            if (isInv) {
                scheduleInfo.setWarehouseAmt(BigDecimal.ZERO);
            } else {
                scheduleInfo.setReceivedAmt(newwarehouseAmt);
            }
            purInvQty = newwarehouseAmt;
            if (needAmt.compareTo(scheduleInfo.getWarehouseAmt()) > 0 && isInv) {
                scheduleInfo.setClosedate(null);
            }
            if (scheduleInfo.getReceivedAmt() != null) {
                if (needAmt.compareTo(scheduleInfo.getReceivedAmt()) <= 0 && !isInv) {
                    scheduleInfo.setDeliverystatus(DeliveryStatusEnum.ALL_SEND);
                } else if (needAmt.compareTo(scheduleInfo.getReceivedAmt()) > 0 && !isInv && scheduleInfo.getReceivedAmt().compareTo(BigDecimal.ZERO) > 0) {
                    scheduleInfo.setDeliverystatus(DeliveryStatusEnum.PART_SEND);
                } else if (needAmt.compareTo(scheduleInfo.getReceivedAmt()) > 0 && !isInv && scheduleInfo.getReceivedAmt().compareTo(BigDecimal.ZERO) == 0) {
                    scheduleInfo.setDeliverystatus(DeliveryStatusEnum.NOT_SEND);
                }
            } else {
                scheduleInfo.setDeliverystatus(DeliveryStatusEnum.NOT_SEND);
            }
            ConsignmentScheduleFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)scheduleInfo);
        }
    }

    private void updateConsignmentPlanApprove(Context ctx, String purentryid, String materialid, BigDecimal purInvQty, boolean isInv) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filteritem1 = new FilterItemInfo("material", (Object)materialid, CompareType.EQUALS);
        FilterItemInfo filteritem2 = new FilterItemInfo("parent", (Object)purentryid, CompareType.EQUALS);
        FilterItemInfo filteritem3 = new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS);
        SorterItemInfo sorteritem = new SorterItemInfo("NeedDate");
        view.getSorter().add(sorteritem);
        filter.getFilterItems().add(filteritem1);
        filter.getFilterItems().add(filteritem2);
        filter.getFilterItems().add(filteritem3);
        view.setFilter(filter);
        ConsignmentScheduleCollection colls = ConsignmentScheduleFactory.getLocalInstance((Context)ctx).getConsignmentScheduleCollection(view);
        for (int n = 0; n < colls.size(); ++n) {
            ConsignmentScheduleInfo scheduleInfo = colls.get(n);
            BigDecimal needAmt = scheduleInfo.getNeedAmt();
            BigDecimal amt = BigDecimal.ZERO;
            if (isInv) {
                amt = scheduleInfo.getWarehouseAmt() == null ? BigDecimal.ZERO : scheduleInfo.getWarehouseAmt();
            } else {
                BigDecimal bigDecimal = amt = scheduleInfo.getReceivedAmt() == null ? BigDecimal.ZERO : scheduleInfo.getReceivedAmt();
            }
            if (purInvQty.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal newwarehouseAmt = amt.add(purInvQty);
                if (n == colls.size() - 1) {
                    if (isInv) {
                        scheduleInfo.setWarehouseAmt(newwarehouseAmt);
                    } else {
                        scheduleInfo.setReceivedAmt(newwarehouseAmt);
                    }
                    purInvQty = BigDecimal.ZERO;
                    if (needAmt.compareTo(scheduleInfo.getWarehouseAmt()) <= 0 && isInv) {
                        Timestamp d = new Timestamp(System.currentTimeMillis());
                        scheduleInfo.setClosedate(d);
                    }
                    ConsignmentScheduleFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)scheduleInfo);
                    break;
                }
                if (needAmt.compareTo(amt) > 0) {
                    if (needAmt.compareTo(newwarehouseAmt) >= 0) {
                        if (isInv) {
                            scheduleInfo.setWarehouseAmt(newwarehouseAmt);
                        } else {
                            scheduleInfo.setReceivedAmt(newwarehouseAmt);
                        }
                        purInvQty = BigDecimal.ZERO;
                    } else {
                        if (isInv) {
                            scheduleInfo.setWarehouseAmt(needAmt);
                        } else {
                            scheduleInfo.setReceivedAmt(needAmt);
                        }
                        purInvQty = newwarehouseAmt.subtract(needAmt);
                    }
                }
            }
            if (needAmt.compareTo(scheduleInfo.getWarehouseAmt()) <= 0 && isInv) {
                Timestamp d = new Timestamp(System.currentTimeMillis());
                scheduleInfo.setClosedate(d);
            }
            if (scheduleInfo.getReceivedAmt() != null) {
                if (needAmt.compareTo(scheduleInfo.getReceivedAmt()) <= 0 && !isInv) {
                    scheduleInfo.setDeliverystatus(DeliveryStatusEnum.ALL_SEND);
                } else if (needAmt.compareTo(scheduleInfo.getReceivedAmt()) > 0 && !isInv && scheduleInfo.getReceivedAmt().compareTo(BigDecimal.ZERO) > 0) {
                    scheduleInfo.setDeliverystatus(DeliveryStatusEnum.PART_SEND);
                } else if (needAmt.compareTo(scheduleInfo.getReceivedAmt()) > 0 && !isInv && scheduleInfo.getReceivedAmt().compareTo(BigDecimal.ZERO) == 0) {
                    scheduleInfo.setDeliverystatus(DeliveryStatusEnum.NOT_SEND);
                }
            } else {
                scheduleInfo.setDeliverystatus(DeliveryStatusEnum.NOT_SEND);
            }
            ConsignmentScheduleFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)scheduleInfo);
        }
    }

    @Override
    protected void _purRecWriteConsign(Context ctx, IObjectCollection purrec, BatchActionEnum actionType) throws BOSException, EASBizException {
        for (int n = 0; n < purrec.size(); ++n) {
            PurReceivalBillInfo info = (PurReceivalBillInfo)purrec.getObject(n);
            PurReceivalEntryCollection colls = info.getEntry();
            for (int m = 0; m < colls.size(); ++m) {
                PurReceivalEntryInfo entry = colls.get(m);
                String materialid = entry.getMaterial().getId().toString();
                String sourceid = entry.getSourceBillEntryId();
                if (sourceid == null) {
                    return;
                }
                BigDecimal amt = entry.getQty();
                if (actionType.equals((Object)BatchActionEnum.UNAUDIT)) {
                    amt = amt.multiply(new BigDecimal(-1));
                }
                if (materialid != null && sourceid != null && amt.compareTo(BigDecimal.ZERO) > 0) {
                    this.updateConsignmentPlanApprove(ctx, entry.getSourceBillEntryId(), materialid, amt, false);
                    continue;
                }
                if (materialid == null || sourceid == null || amt.compareTo(BigDecimal.ZERO) >= 0) continue;
                this.updateConsignmentPlanUnApprove(ctx, entry.getSourceBillEntryId(), materialid, amt, false);
            }
        }
    }

    public static List<KeyValueForDate> getKeyValueForDate(String startDate, String endDate) {
        ArrayList<KeyValueForDate> list = null;
        try {
            list = new ArrayList<KeyValueForDate>();
            String firstDay = "";
            String lastDay = "";
            Date d1 = new SimpleDateFormat("yyyy-MM-dd").parse(startDate);
            Date d2 = new SimpleDateFormat("yyyy-MM-dd").parse(endDate);
            Calendar dd = Calendar.getInstance();
            dd.setTime(d1);
            Calendar cale = Calendar.getInstance();
            Calendar c = Calendar.getInstance();
            c.setTime(d2);
            int startDay = d1.getDate();
            int endDay = d2.getDate();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            KeyValueForDate keyValueForDate = null;
            if (CalculateDeliveryPlanFacadeControllerBean.getIntervalDays(d1, d2) < 45) {
                keyValueForDate = new KeyValueForDate();
                keyValueForDate.setStartDate(startDate);
                keyValueForDate.setEndDate(endDate);
                list.add(keyValueForDate);
                return list;
            }
            while (dd.getTime().before(d2)) {
                keyValueForDate = new KeyValueForDate();
                cale.setTime(dd.getTime());
                if (dd.getTime().equals(d1)) {
                    cale.set(5, dd.getActualMaximum(5));
                    lastDay = sdf.format(cale.getTime());
                    keyValueForDate.setStartDate(sdf.format(d1));
                    keyValueForDate.setEndDate(lastDay);
                } else if (dd.get(2) == d2.getMonth() && dd.get(1) == c.get(1)) {
                    cale.set(5, 1);
                    firstDay = sdf.format(cale.getTime());
                    keyValueForDate.setStartDate(firstDay);
                    keyValueForDate.setEndDate(sdf.format(d2));
                } else {
                    cale.set(5, 1);
                    firstDay = sdf.format(cale.getTime());
                    cale.set(5, dd.getActualMaximum(5));
                    lastDay = sdf.format(cale.getTime());
                    keyValueForDate.setStartDate(firstDay);
                    keyValueForDate.setEndDate(lastDay);
                }
                list.add(keyValueForDate);
                dd.add(2, 1);
            }
            if (endDay <= startDay) {
                keyValueForDate = new KeyValueForDate();
                cale.setTime(d2);
                cale.set(5, 1);
                firstDay = sdf.format(cale.getTime());
                keyValueForDate.setStartDate(firstDay);
                keyValueForDate.setEndDate(sdf.format(d2));
                list.add(keyValueForDate);
            }
        }
        catch (ParseException e) {
            return null;
        }
        return list;
    }

    public static int getIntervalDays(Date fDate, Date oDate) {
        if (null == fDate || null == oDate) {
            return -1;
        }
        long intervalMilli = oDate.getTime() - fDate.getTime();
        return (int)(intervalMilli / 86400000L);
    }

    public List<CalculateResultScopeVO> getResultVOS(Context ctx, List paramobj) throws BOSException, SQLException, EASBizException, ParseException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append(" select min(cfdemanddate) demanddate from \n");
        sql.append(" ct_sm_deliveryplandemand \n");
        sql.append(" union \n");
        sql.append(" select max(cfdemanddate) demanddate from  \n");
        sql.append(" ct_sm_deliveryplandemand \n");
        IRowSet rsDate = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        java.sql.Date startDate = null;
        java.sql.Date endDate = null;
        if (rsDate != null) {
            int i = 0;
            while (rsDate.next()) {
                if (i == 0) {
                    startDate = rsDate.getDate("demanddate");
                    ++i;
                    continue;
                }
                if (i != true) continue;
                endDate = rsDate.getDate("demanddate");
            }
        }
        Date[] dateMonment = this.getReviseTime(startDate, endDate);
        SimpleDateFormat fromatter = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<KeyValueForDate> list = CalculateDeliveryPlanFacadeControllerBean.getKeyValueForDate(fromatter.format(startDate), fromatter.format(endDate));
        ArrayList<CalculateResultScopeVO> rsList = new ArrayList<CalculateResultScopeVO>();
        for (int i = 0; i < list.size(); ++i) {
            KeyValueForDate kdate = list.get(i);
            Date d1 = this.getStartOfDay(fromatter.parse(kdate.getStartDate()));
            Date d2 = this.getEndOfDay(fromatter.parse(kdate.getEndDate()));
            sql.setLength(0);
            sql.append(" \n");
            sql.append("  /*dialect*/ \n");
            sql.append(" select cdp.cfsupplierid,cdp.cfprojectid as projectid ,cdp.cftracknoid as trackid,cdp.cfsupplystorageorg as  porgid,  \n");
            sql.append(" cdp.cfstorageorgunitid as orgid,cdp.cfmaterialid as materialid, min (cdp.cfdistributionorder) as fdistributionorder , \n");
            sql.append(" min(cdp.cfdemanddate) as demandtime, min(cdp.cffarrivedays) as days,nvl( min(cdp.cfplanretime),min(cdp.cfdemanddate)) as planrecdate  \n");
            sql.append(" ,sum(cdp.cfdemandqty)-sum(nvl(cdp.CFCloseQty,0)) as qty , max(tmp.fpurperson) as fpurperson ,max(tmp.fpurgroup) as fpurgroup \n");
            sql.append(" from  \n");
            sql.append(" ct_sm_deliveryplandemand cdp \n");
            sql.append(" left join CT_DIR_DirectFeedingmMaterial dfg on ");
            sql.append(" dfg.CFMATERIALID =  cdp.cfmaterialid and  dfg.cfprojectid =  cdp.cfprojectid and  dfg.CFTRACKID =  cdp.cftracknoid \n ");
            sql.append(" left join t_bd_materialpurchasing tmp on tmp.fmaterialid = cdp.cfmaterialid and tmp.forgunit = 'uHesH1pARsmCli2qcHmx4cznrtQ=' ");
            sql.append(" where nvl(dfg.CFISZJ,0) <> 1 AND nvl(dfg.CFSTATUS,0) <> 1 \n");
            sql.append(" and cdp.cfdemanddate >= to_date('").append(sdf.format(d1)).append("','yyyy-MM-dd HH24:mi:ss') and cdp.cfdemanddate <= to_date('").append(sdf.format(d2)).append("','yyyy-MM-dd HH24:mi:ss')");
            sql.append(" group by  cdp.cfprojectid ,cdp.cftracknoid, cdp.cfstorageorgunitid , cdp.cfsupplystorageorg ,cdp.cfmaterialid, cdp.cfsupplierid ,\n");
            sql.append(" to_char (cdp.cfdemanddate ,'yyyy-MM-dd')  order by demandtime \n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs == null) {
                return rsList;
            }
            try {
                while (rs.next()) {
                    CalculateResultScopeVO vo = new CalculateResultScopeVO();
                    vo.setProjectid(rs.getString("PROJECTID"));
                    vo.setTracknumberid(rs.getString("TRACKID"));
                    vo.setSupplystorageorgid(rs.getString("PORGID"));
                    vo.setStorageorgid(rs.getString("ORGID"));
                    vo.setMaterialid(rs.getString("MATERIALID"));
                    vo.setReqDate(rs.getDate("DEMANDTIME"));
                    vo.setQty(rs.getBigDecimal("QTY"));
                    vo.setAdvanceday(rs.getInt("DAYS"));
                    vo.setStartDate((Timestamp)dateMonment[0]);
                    vo.setEndDate((Timestamp)dateMonment[1]);
                    vo.setActqty(rs.getBigDecimal("QTY"));
                    vo.setWorkstorageorgid(rs.getString("ORGID"));
                    vo.setSupplymethod(paramobj == null ? null : (SupplyRelationshipDefinitionInfo)paramobj.get(3));
                    vo.setPurmethod(paramobj == null ? null : (PurRelationshipDefinitionInfo)paramobj.get(4));
                    vo.setPlanRecDate(rs.getTimestamp("PLANRECDATE"));
                    vo.setPurGroupID(rs.getString("fpurgroup"));
                    vo.setPurPersonID(rs.getString("fpurperson"));
                    vo.setSupplierID(rs.getString("cfsupplierid"));
                    rsList.add(vo);
                }
                continue;
            }
            catch (Exception ex) {
                throw new BOSException("\u67e5\u8be2\u51fa\u9519\uff01");
            }
        }
        return rsList;
    }

    public boolean isValidateData(Context ctx, CalculateResultScopeVO vo) throws BOSException, EASBizException {
        return DeliveryPlanSingletonFactory.getDirectMaterialSingleton(ctx).isDirectMaterial(vo.getMaterialid(), vo.getProjectid(), vo.getTracknumberid());
    }

    private List splitDateForDemand(Context ctx, Date startDate, Date endDate) {
        return null;
    }

    public Date getEndOfDay(Date date) {
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(date);
        calendarEnd.set(11, 23);
        calendarEnd.set(12, 59);
        calendarEnd.set(13, 59);
        calendarEnd.set(14, 0);
        return calendarEnd.getTime();
    }

    public Date getStartOfDay(Date date) {
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(date);
        calendarEnd.set(11, 0);
        calendarEnd.set(12, 0);
        calendarEnd.set(13, 0);
        calendarEnd.set(14, 0);
        return calendarEnd.getTime();
    }

    class DeliveryLogSaveThread
    extends Thread {
        private CoreBaseCollection colls = null;
        private Context ctx = null;

        public DeliveryLogSaveThread(Context _ctx, CoreBaseCollection _colls) {
            this.colls = _colls;
            this.ctx = _ctx;
        }

        @Override
        public void run() {
            for (int n = 0; n < this.colls.size(); ++n) {
                try {
                    AnalyseDeliveryPlanByStockFactory.getLocalInstance((Context)this.ctx).save(this.colls.get(n));
                    System.out.println("\u4fdd\u5b58\u65e5\u5fd7\uff1a" + n);
                    continue;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

